/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _CHECKS_H
#define _CHECKS_H

#include <string>

inline bool
wf_object_name_check(const string& str) {
  return str.find_first_not_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == string::npos;
}

inline bool
wf_hostname_check(const string& str) {
  return str.find_first_not_of("abcdefghijklmnopqrstuvwxyz0123456789.") == string::npos;
}

inline bool
wf_interface_name_check(const string& str) {
  return str.find_first_not_of("abcdefghijklmnopqrstuvwxyz0123456789:") == string::npos;
}

inline bool
wf_zone_name_check(const string& str) {
  return str.find_first_not_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_") == string::npos;
}

#endif
