// $Id: World.cpp,v 1.31 2003/03/13 23:36:16 zongo Exp $
#ifdef WIN32
# include <iostream.h>
#else
# include <iostream>
#endif
#include <fstream>
#include <locale.h>

#include <Ark/ArkLexer.h>
#include <Ark/ArkFileSys.h>
#include "World.h"
#include "Main.h"
#include "Application.h"
#include "TerrainView.h"
#include "ViewWidget.h"

World::World(Ark::Cache *cache) :
   Ark::HeightField( cache ),
   m_GroundList(),
   m_IsChanged( false )
{
   g_Application->GetUI()->EnableSaveCommands(false);
}


World::~World ()
{
}


void 
World::Changed() const
{ 
   m_IsChanged = true; 
   g_Application->GetUI()->EnableSaveCommands(true);
}


void 
World::Unchanged() const
{ 
   m_IsChanged = false; 
   g_Application->GetUI()->EnableSaveCommands(false);
}


bool
World::LoadED(const std::string& path)
{
#ifdef _MBCS
   // FIXME FIXME FIXME... ugly because MSVC6 is lame with namespaces
   if (!Load(path.c_str())) return false;

   // ugly because MSVC6 is lame with namespaces
   ((Ark::HeightField *) this)->Init(Ark::WORLD_HAS_RENDERING);
#else
   if (!Ark::HeightField::Load(path.c_str()) ) return false;

   Ark::HeightField::Init(Ark::WORLD_HAS_RENDERING);
#endif
   
   m_Path = path;
   Unchanged();

   m_GroundList.Update();
   
   // Load entities.
   //Ark::Config worldcfg;
   m_Config.Load( path + "/world.cfg" );
   
   Ark::String entities = m_Config.GetStr("world::Entities", Ark::String());
   if (! entities.empty() )
   {
      Ark::AutoReadStream file (entities);
      Ark::Lexer lexer (entities, file.Get());
      
      /// Read untile EOF is reached.
      Ark::EntryList entries;
	 
      while (g_Application->GetClasses()->Read (lexer, &entries))
      {
	 Entity *ent = new Entity(this);
	 ent->SetEntries (entries);
	 Add (ent);
	 
	 entries.clear();
      }
   }
   
   Update();

   return true;
}


void
World::Write() const
{
   Ark::Sys()->FS()->MakeDir(m_Path.c_str(), 0755);
   Ark::String path = Ark::Sys()->FS()->GetFileName(m_Path);
   Ark::String::size_type start = path.find(Ark::Sys()->FS()->GetFileName("{game}"));
   Ark::String arkpath = path;
   Ark::String shaders = Ark::Sys()->FS()->GetFileName("{shaders}");
   if (start != Ark::String::npos)
     arkpath.replace(start, Ark::Sys()->FS()->GetFileName("{game}").size(), "{game}");

   std::string filename;
   
   // To be sure we never save locale dependent data
   char* loc = strdup( setlocale(LC_ALL, NULL) ); 
   setlocale(LC_ALL, "C");

   filename = path + "world.cfg";
   Ark::Sys()->Log("Writing %s \n", filename.c_str());

   std::ofstream f(filename.c_str());
   f.setf(std::ios::fixed);
   f << "heightfield::Scale = " << m_Scale << ";\n"
     << "heightfield::ScaleY = " << m_ScaleY << ";\n"
     << "heightfield::HeightData = \"" << arkpath << "elev.tga\";\n"
     << "heightfield::GroundData = \"" << arkpath << "ground.tga\";\n"
     << "heightfield::NumGrounds = " << (int) m_Grounds.size() << ";\n";

   Ark::MaterialList::const_iterator it;
   int i = 0;
   for (it = m_Grounds.begin(); it != m_Grounds.end(); ++it, ++i)
   {
      Ark::String shader_path = (*it)->Name();
      Ark::String::size_type shader_start = shader_path.find(shaders);
      if (shader_start != Ark::String::npos)
        shader_path.replace(shader_start, shaders.size(), "{shaders}");
      f << "heightfield::Ground" << i << " = \"" << shader_path << "\";\n";
   }

   Ark::String name = m_Config.GetStr("world::Name", "");
   f << "world::Entities = \"" << arkpath << "/entities.lst\";\n\n"
     << "world::Callbacks = \"" << arkpath << "/callbacks.lst\";\n"
     << "world::Script = \"" << arkpath << "/quest.lua\";\n"
     << "world::Name = \"" << name << "\";\n";
     
   f << "sky::ToneMap = \"{shaders}/sky-tonemap.mat\";\n"
     << "sky::StarMap = \"{shaders}/sky-starmap.mat\";\n"
     << "sky::Size    = 500.0;\n";
   
   Ark::Color fogc = GetFogColor();
   f << "atmosphere::TimeOfDay = " << GetTimeOfDay() << ";\n"
     << "atmosphere::FogRed = " << fogc.R << ";\n"
     << "atmosphere::FogGreen = " << fogc.G << ";\n"
     << "atmosphere::FogBlue = " << fogc.B << ";\n"
     << "atmosphere::FogDensity = " << GetFogDensity() << ";\n";

   filename = path + "/elev.tga";
   Ark::Sys()->Log("Writing %s\n", filename.c_str());
   Ark::Image img("tmp", m_SizeX, m_SizeZ, Ark::Image::I_8, m_Y);
   img.SaveTGA( filename );

   filename = path + "/ground.tga";
   Ark::Sys()->Log("Writing %s\n", filename.c_str());
   img.SetFormat(m_SizeX, m_SizeZ, Ark::Image::I_8, m_G);
   img.SaveTGA( filename );

   filename = path + "/entities.lst";
   std::ofstream ents(filename.c_str());

   Ark::EntityList::const_iterator eit;
   for (eit = m_Entities.begin(); eit != m_Entities.end(); ++eit)
   {
      ents << ((Entity*)(*eit))->ToString();
   } 

   // Restore previous locale
   setlocale(LC_ALL, loc);
   free( loc );
   
   Unchanged();
}

void
World::DebugDump()
{
   Ark::EntityList::const_iterator eit;
   for (eit = m_Entities.begin(); eit != m_Entities.end(); ++eit)
   {
      std::cout << ((Entity*)(*eit))->ToString();
   } 
}

// Ground materials
bool
World::LoadGround(const std::string& name)
{
  Ark::Material* mat = 0;
  
  GetCache()->Get(Ark::V_MATERIAL, name.c_str(), &mat);

  if (mat)
  {
     AppendGround(Ark::MaterialPtr(mat));
     m_GroundList.Add(mat);
     mat->Unref();
     
     GetCache()->Clear();
     return true;
  }
  
  return false;
}


