// $Id: CallbacksModelSelector.cpp,v 1.2 2002/02/17 00:27:07 nekeme Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "GLModelView.h"
#include "ModelSelector.h"

/**********************************************************************
 *     MODEL SELECTOR VIEW WIDGET CALLBACKS
 **********************************************************************/
void ModelSelector_setModel (GtkWidget *widget, char *val)
{
   //GtkWidget *root = lookup_widget (widget, "ModelSelectorWindow");
   GtkWidget *view = lookup_widget (widget, "ModelSelectorGLView");
   //char **modelname = 
   //   (char**) gtk_object_get_data (GTK_OBJECT(root), "modelname");

   //cerr << val << " " << root << " mdlname "
   //     << (void*)modelname << endl;
   //if (modelname != NULL)
   //  *modelname = val;


   g_ModelSelector.m_RModel = val;
   
   GLModelView *glview = (GLModelView*) GLView::GetView (view);
   glview->SetModel (val);
   glview->Redraw();
}


extern void mwidget_setResult (GtkWidget *widget, int val)
{
   GtkWidget *parent;
      
   for (;;)
   {
      if (GTK_IS_MENU (widget))
	 parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
	 parent = widget->parent;
      if (parent == NULL)
	 break;
      widget = parent;
   }
   
   //int *res = (int*) gtk_object_get_data (GTK_OBJECT(widget), "result");
   gtk_widget_hide (widget);
   
   //if (res != NULL)
   //*res = val;

   g_ModelSelector.m_Result = val;
}


gboolean
on_ModelSelectorWindow_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   mwidget_setResult(GTK_WIDGET(widget), RES_CANCEL);
   return TRUE;
}

void
on_ModelSelectorSizeSpin_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
}


void
on_ModelSelectorOkButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
   mwidget_setResult(GTK_WIDGET(button), RES_OK);
}

void
on_ModelSelectorCancelButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
   mwidget_setResult(GTK_WIDGET(button), RES_CANCEL);
}


void
on_ModelSelectorList_selection_changed (GtkList         *list,
                                        gpointer         user_data)
{
   GList *select = list->selection;
   
   if (!select)
      return;
   
   GtkObject *iselect = GTK_OBJECT(select->data);
   
   ModelSelector_setModel (GTK_WIDGET(list),
			   (char*) gtk_object_get_data (iselect, "name"));
}


GtkWidget*
ModelSelectorView_create (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{

  GLModelView* view = new GLModelView();
  return GTK_WIDGET( view->GetArea() );
}


gboolean
on_ModelSelectorView_motion_notify_event
                                        (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->Motion( int(event->x), int(event->y), event->state);
}


gboolean
on_ModelSelectorView_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->ButtonPress( int(event->x), int(event->y), event->button, event->state);
}


gboolean
on_ModelSelectorView_button_release_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->ButtonRelease( int(event->x), int(event->y), event->button, event->state);
}


gboolean
on_ModelSelectorView_expose_event      (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->Expose();
}


gboolean
on_ModelSelectorView_destroy_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  delete view;

  return FALSE;
}
