#if defined(TT_1)
#include <stdio.h>
#include <iconv.h>
#include <freetype/freetype.h>
#include "wprint.h"

#define TT_Flag_On_Curve 1

extern int verbose;

int find_unicode_cmap(TT_Face face, TT_CharMap *cmap)
{
  int i,n;
  unsigned short p,e;

  n=TT_Get_CharMap_Count(face);
  for(i=0; i<n; i++) {
    if(!TT_Get_CharMap_ID(face, i, &p, &e))
      if( (p==3 && e==1) || p==0 || (p==2 && e==1) )
        if(!TT_Get_CharMap(face, i, cmap))
          return 0;
  }
  return 1;
}

int	initTT(struct tt_info *ti)
{
	return(TT_Init_FreeType(&(ti->ttengine)));
}

int	setFont(struct tt_info *ti,char *file)
{
int			error;
TT_Face_Properties	properties;

	if ((error = TT_Open_Face(ti->ttengine,file,&(ti->font.ttface))) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Couldn't open font file %s\n",file);
		return(error);
	}
	if ((error=TT_New_Instance(ti->font.ttface, &(ti->font.ttinstance))) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Couldn't create new instance\n");
		return(error);
	}
	if ((error=TT_Set_Instance_Resolutions(ti->font.ttinstance,ti->font.xr,ti->font.yr)) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Couldn't set resolutions\n");
		return(error);
	}
	if ((error=TT_Set_Instance_CharSize(ti->font.ttinstance, (TT_F26Dot6)(ti->font.charsize*64.0))) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Couldn't set point size\n");
		return(error);
	}
	if ((error=TT_Get_Face_Properties(ti->font.ttface,&properties)) != TT_Err_Ok)
	{
	int	i;
		if (verbose)
			fprintf(stderr,"Couldn't read properties\n");
		for (i = 0;i < 9;i++)
			ti->font.names[i][0] = 0;

		ti->font.ttpostscript = NULL;
		ti->font.ttheader = NULL;

		return(error);
	}
	else
	{
	int		i,l;
	char		*name;
	TT_UShort	namelen;

		for (i = 0;i < properties.num_Names && i < 9;i++)
		{
			TT_Get_Name_String(ti->font.ttface,i,&name,&namelen);
			l = (namelen < MAXNAME) ? namelen : MAXNAME;
			strncpy(ti->font.names[i],name,l);
			ti->font.names[i][l] = 0;
		}
		ti->font.ttpostscript = properties.postscript;
		ti->font.ttheader = properties.header;
	}
	return(TT_Err_Ok);
}
int createGlyphs (FILE *out,struct tt_info *ti,unsigned short unicode,char *b64name)
{
TT_Error error;
TT_Glyph glyph;
TT_Glyph_Metrics metrics;
TT_CharMap cmap;
unsigned short index;

	if ((error=TT_New_Glyph(ti->font.ttface, &glyph)) != TT_Err_Ok)
		FTError("Coudn't create glyph", error);
  
	if ((error=find_unicode_cmap(ti->font.ttface, &cmap)))
		Error("Couldn't find suitable Cmap");

	index=TT_Char_Index(cmap, unicode);

	if((error=TT_Load_Glyph(ti->font.ttinstance, glyph, index, 0)))
		FTError("Couldn't load glyph", error);
	if((error=TT_Get_Glyph_Metrics(glyph, &metrics)))
		FTError("Couldn't get glyph metrics", error);

	glyphToPs(out,unicode,cmap,metrics,glyph,ti,b64name);

	if((error=TT_Done_Glyph(glyph)))
		FTError("Couldn't unload glyph", error);

	return 0;
}
int unsetFont(struct tt_info *ti)
{
TT_Error error;

	if ((error=TT_Done_Instance(ti->font.ttinstance)) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Coudn't unload instance\n");
	}
	if ((error=TT_Close_Face(ti->font.ttface)) != TT_Err_Ok)
	{
		if (verbose)
			fprintf(stderr,"Coudn't close font file\n");
	}
	return(error);
}
void finalizeTT(struct tt_info *ti)
{
TT_Error error;

	if ((error=TT_Done_FreeType(ti->ttengine)) != TT_Err_Ok)
		FTError("Coudn't finalise FreeType engine", error);
	return;
}
/*
 * Construct CharString of a glyph.
 */

int glyphToPs(FILE *out,
              unsigned short unicode,TT_CharMap cmap,TT_Glyph_Metrics metrics,
              TT_Glyph glyph,struct tt_info *ti,char *b64name)
{
TT_Outline		outline;
int ncontours,len,ncurves;/* ojo */

	fprintf(out,"/%s { %% U%04X\n",b64name,unicode);
	ncurves = 0;

	if (TT_Get_Glyph_Outline(glyph,&outline) != TT_Err_Ok)
		printf("Error getting glyph outline\n");

	fprintf(out,"%ld 0 %ld %ld %ld %ld setcachedevice\n",
	metrics.advance,
	metrics.bbox.xMin, metrics.bbox.yMin,
	metrics.bbox.xMax, metrics.bbox.yMax);

	len = 1; /* Por ahora */

    if (len != 0) {
        ncontours = outline.n_contours;
        if (ncontours > 0)
            ncurves += drawGlyph(out,glyph, glyph,outline);

        if (ncurves > 100)
		fprintf(out,"%% This glyph is too long, may have to be removed\n");
    }
    fprintf(out,"fill } bind def\n");
/*    TT_Done_Outline(&outline);
*/
    return(0);
}
int drawGlyph(FILE *out,TT_Glyph glyphno, TT_Glyph parent,TT_Outline outline)
{
    int i, j, k, k1, first, cs, ce;
    int finished, nguide, contour_start, contour_end;
    short ncontours, last_point;
    unsigned short *contour_end_pt;
    short xcoord[2000], ycoord[2000];
    unsigned char flags[2000];
    char pfa_file[256];
    int ncurves;
    TT_Vector	*vec;

    ncurves =0;

    contour_start = 0;
    ce = contour_start;

    ncontours = outline.n_contours;
    if (ncontours <= 0) {
	fprintf(out,"%%**** Composite glyph %04x refers to non-existent glyph",1);/*glyphno);*/
        return 0;
    }
    contour_end_pt = (unsigned short *) outline.contours;

    last_point = outline.n_points;
/*    ptr = ((unsigned char *)contour_end_pt) + (ncontours << 1) + n_inst + 2;
 Me parece que quiere los flags*/

j = k = 0;
    for (k = 0;k <= last_point;k++)
        flags[k] = outline.flags[k];

 	vec = outline.points;
    for (k=0; k <= last_point; k++) {
/*printf("%% k=%d (%d) x=%ld y=%ld\n",k,flags[k],vec[k].x,vec[k].y);*/
	xcoord[k] = vec[k].x;
	ycoord[k] = vec[k].y;
    }

    i = j = 0;
    first = 1;

    while (i <= outline.contours[outline.n_contours - 1]) {
        contour_end = outline.contours[j];

        if (first) {
            sprintf(pfa_file, "%d %d moveto\n", xcoord[i], ycoord[i]);
            fprintf(out,pfa_file);
            ncurves ++;
            contour_start = i;
            first = 0;
        } else if (flags[i] & ONOROFF) {
            sprintf(pfa_file, "%d %d lineto\n", xcoord[i], ycoord[i]);
            fprintf(out,pfa_file);
            ncurves ++;
        } else {
            cs = i-1;
            finished = nguide = 0;
            while (!finished) {
                if (i == contour_end+1) {
                    ce = contour_start;
                    finished = 1;
                } else if (flags[i] & ONOROFF) {
                    ce = i;
                    finished = 1;
                } else {
                    i++;
                    nguide++;
                }
            }

            switch (nguide) {
                case 0: 
			sprintf( pfa_file,"%d %d lineto\n",
				xcoord[ce], ycoord[ce]);
		            fprintf(out,pfa_file);
                        ncurves ++;
                        break;

                case 1: sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[cs]+2*xcoord[cs+1])/3,
                                (ycoord[cs]+2*ycoord[cs+1])/3,
                                (2*xcoord[cs+1]+xcoord[ce])/3,
                                (2*ycoord[cs+1]+ycoord[ce])/3,
                                xcoord[ce], ycoord[ce]);
		            fprintf(out,pfa_file);
                        ncurves ++;
                        break;

                case 2: sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (-xcoord[cs]+4*xcoord[cs+1])/3,
                                (-ycoord[cs]+4*ycoord[cs+1])/3,
                                (4*xcoord[cs+2]-xcoord[ce])/3,
                                (4*ycoord[cs+2]-ycoord[ce])/3,
                                xcoord[ce], ycoord[ce]);
		            fprintf(out,pfa_file);
                        ncurves ++;
                        break;

                case 3: sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[cs]+2*xcoord[cs+1])/3,
                                (ycoord[cs]+2*ycoord[cs+1])/3,
                                (5*xcoord[cs+1]+xcoord[cs+2])/6,
                                (5*ycoord[cs+1]+ycoord[cs+2])/6,
                                (xcoord[cs+1]+xcoord[cs+2])/2,
                                (ycoord[cs+1]+ycoord[cs+2])/2);
		            fprintf(out,pfa_file);
                        sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[cs+1]+5*xcoord[cs+2])/6,
                                (ycoord[cs+1]+5*ycoord[cs+2])/6,
                                (5*xcoord[cs+2]+xcoord[cs+3])/6,
                                (5*ycoord[cs+2]+ycoord[cs+3])/6,
                                (xcoord[cs+3]+xcoord[cs+2])/2,
                                (ycoord[cs+3]+ycoord[cs+2])/2);
		            fprintf(out,pfa_file);
                        sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[cs+2]+5*xcoord[cs+3])/6,
                                (ycoord[cs+2]+5*ycoord[cs+3])/6,
                                (2*xcoord[cs+3]+xcoord[ce])/3,
                                (2*ycoord[cs+3]+ycoord[ce])/3,
                                xcoord[ce], ycoord[ce]);
		            fprintf(out,pfa_file);
                        ncurves += 3;
                        break;

                default:k1 = cs + nguide;

                        sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[cs]+2*xcoord[cs+1])/3,
                                (ycoord[cs]+2*ycoord[cs+1])/3,
                                (5*xcoord[cs+1]+xcoord[cs+2])/6,
                                (5*ycoord[cs+1]+ycoord[cs+2])/6,
                                (xcoord[cs+1]+xcoord[cs+2])/2,
                                (ycoord[cs+1]+ycoord[cs+2])/2);
		            fprintf(out,pfa_file);
                        for (k = cs+2; k <= k1-1; k++) {
                            sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                    (xcoord[k-1]+5*xcoord[k])/6,
                                    (ycoord[k-1]+5*ycoord[k])/6,
                                    (5*xcoord[k]+xcoord[k+1])/6,
                                    (5*ycoord[k]+ycoord[k+1])/6,
                                    (xcoord[k]+xcoord[k+1])/2,
                                    (ycoord[k]+ycoord[k+1])/2);
				fprintf(out,pfa_file);
                        }
                        sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
                                (xcoord[k1-1]+5*xcoord[k1])/6,
                                (ycoord[k1-1]+5*ycoord[k1])/6,
                                (2*xcoord[k1]+xcoord[ce])/3,
                                (2*ycoord[k1]+ycoord[ce])/3,
                                xcoord[ce], ycoord[ce]);
		            fprintf(out,pfa_file);
                        ncurves += nguide;
                        break;
            }
        }
        if (i >= contour_end) {
            fprintf(out," closepath ");
            first = 1;
            i = contour_end + 1;
            j++;
        } else {
            i++;
        }
    }
    return ncurves;
}
#endif
