/*--------------------------------------------------------------------------*/
/* theme                                                                    */
/*--------------------------------------------------------------------------*/

#include <config.h>

#include <limits.h>
#include <string.h>

#include <gtk/gtk.h>
#include "gtk-callbacks.h"
#include "gtk-interface.h"
#include "gtk-support.h"

#include "theme.h"
#include "actors.h"

/*--------------------------------------------------------------------------*/
/* structures                                                               */
/*--------------------------------------------------------------------------*/

typedef struct {
   char *name;
   char *descr;
   char *author;
} THEME;

/*--------------------------------------------------------------------------*/
/* variables                                                                */
/*--------------------------------------------------------------------------*/

static THEME themes[] = {
   {
      "archon",
      "Modelled after the original ARCHON",
      "Matt Kimball, Dan LaPine, Mark Shoulson, Dan Hursh"
   },
   { }                                  /* indicator */
};

static char selected_theme[64] = "";

static void (*progress_func)(char *msg, float progress);

static GtkWidget *window;

/*--------------------------------------------------------------------------*/
/* theme_init                                                               */
/*--------------------------------------------------------------------------*/

void theme_init(void (*_progress_func)(char *msg, float progress))
{
   progress_func = _progress_func;
   actors_init(progress_func);
   theme_select(themes[0].name);
}

/*--------------------------------------------------------------------------*/
/* theme_select                                                             */
/*--------------------------------------------------------------------------*/

void theme_select(char *name)
{
   if (strcmp(name, selected_theme) == 0)
      progress_func("Selected theme is already the current theme", 1.0);
   else {
      strcpy(selected_theme, name);
      actors_load_theme(name);
      progress_func("Theme has been successfully loaded", 1.0);
   }
}

/*--------------------------------------------------------------------------*/
/* theme_select_theme                                                       */
/*--------------------------------------------------------------------------*/

void theme_select_theme(GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *list, *widget;
   THEME *theme;

   window = create_theme_window();

   list = lookup_widget(window, "list");
   for (theme = &themes[0]; theme->name != NULL; theme++) {
      widget = gtk_list_item_new_with_label(theme->name);
      gtk_container_add(GTK_CONTAINER(list), widget);
      gtk_widget_show(widget);
      gtk_object_set_data(GTK_OBJECT(widget), "theme", theme);
   }
   gtk_widget_show(GTK_WIDGET(window));
}

/*--------------------------------------------------------------------------*/
/* theme_list_selection_changed                                             */
/*--------------------------------------------------------------------------*/

void theme_list_selection_changed(GtkList *list, gpointer data)
{
   GtkWidget *descr, *author, *widget;
   GList *item;
   THEME *theme;

   descr = lookup_widget(window, "descr");
   author = lookup_widget(window, "author");

   widget = lookup_widget(window, "list");
   item = GTK_LIST(list)->selection;
   if (item == NULL) {
      gtk_entry_set_text(GTK_ENTRY(descr), "");
      gtk_entry_set_text(GTK_ENTRY(author), "");
      return;
   }

   theme = gtk_object_get_data(GTK_OBJECT(item->data), "theme");
   gtk_entry_set_text(GTK_ENTRY(descr), theme->descr);
   gtk_entry_set_text(GTK_ENTRY(author), theme->author);
}

/*--------------------------------------------------------------------------*/
/* theme_ok_clicked                                                         */
/*--------------------------------------------------------------------------*/

void theme_ok_clicked(GtkButton *button, gpointer data)
{
   GtkWidget *widget;
   GList *item;
   THEME *theme;

   widget = lookup_widget(window, "list");
   item = GTK_LIST(widget)->selection;
   if (item != NULL)
      theme = gtk_object_get_data(GTK_OBJECT(item->data), "theme");
   else
      theme = NULL;
   gtk_widget_destroy(window);
   if (theme != NULL)
      theme_select(theme->name);
}

/*--------------------------------------------------------------------------*/
/* theme_cancel_clicked                                                     */
/*--------------------------------------------------------------------------*/

void theme_cancel_clicked(GtkObject *object, gpointer data)
{
   gtk_widget_destroy(window);
}
