
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "icons.h"
#include "misc.h"
/****   calbacks  ***/

void on_zoom_in_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    /*tree_details_t *tree_details = get_tree_details(treeview); */
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    GtkTreePath *treepath;

    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {
	treepath = gtk_tree_model_get_path(treemodel, &iter);
	increase_size(treemodel, treepath, &iter, (gpointer) treeview);
	gtk_tree_path_free(treepath);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

/*  
  gtk_tree_selection_selected_foreach (selection,
		  increase_size,
		  (gpointer) tree_details->treeview);
*/
}


void on_zoom_out_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    /*tree_details_t *tree_details = get_tree_details(treeview); */
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    GtkTreePath *treepath;

    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {
	treepath = gtk_tree_model_get_path(treemodel, &iter);
	decrease_size(treemodel, treepath, &iter, (gpointer) treeview);
	gtk_tree_path_free(treepath);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

/*  gtk_tree_selection_selected_foreach (selection,
		  decrease_size,
		  (gpointer) tree_details->treeview);*/


}

void tb_zoom_in(GtkButton * button, gpointer user_data)
{
    on_zoom_in_activate((GtkMenuItem *) button, user_data);
}


void tb_zoom_out(GtkButton * button, gpointer user_data)
{
    on_zoom_out_activate((GtkMenuItem *) button, user_data);
}
