/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2002 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish distribute, sublicense and/or sell copies of
 * the Software, and to permit persons who receive copies from any such
 * party to do so, with the only requirement being that the above copyright
 * and this permission notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/

#ifdef USE_SMALL_ICONS

#define addpt_width 22
#define addpt_height 22
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width 22
#define align_height 22
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width 22
#define arc_height 22
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width 22
#define arc_box_height 22
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width 22
#define autoarrow_height 22
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width 22
#define box_height 22
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width 22
#define break_height 22
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width 22
#define open_comp_height 22
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width 22
#define join_split_height 22
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_intspl_width 22
#define c_intspl_height 22
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width 22
#define c_spl_height 22
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width 22
#define cirdia_height 22
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width 22
#define cirrad_height 22
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width 22
#define convert_height 22
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width 22
#define copy_height 22
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width 22
#define delete_height 22
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width 22
#define deletept_height 22
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width 22
#define edit_height 22
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width 22
#define elldia_height 22
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width 22
#define ellrad_height 22
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width 22
#define flip_x_height 22
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width 22
#define flip_y_height 22
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width 22
#define glue_height 22
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width 22
#define intspl_height 22
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width 22
#define line_height 22
static unsigned char line_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width 22
#define move_height 22
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width 22
#define movept_height 22
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width 22
#define picobj_height 22
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width 45
#define library_height 22
static unsigned char library_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width 22
#define polygon_height 22
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width 22
#define regpoly_height 22
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width 22
#define rotCCW_height 22
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width 22
#define rotCW_height 22
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width 22
#define scale_height 22
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width 22
#define spl_height 22
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width 22
#define text_height 22
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width 22
#define update_height 22
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define tangent_width 22
#define tangent_height 22
static unsigned char tangent_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x03,0x02,
 0x00,0x0c,0x02,0x24,0x10,0x02,0x2c,0x20,0x00,0x34,0x20,0x00,
 0x24,0x40,0x00,0x00,0x40,0x00,0xfe,0xff,0x03,0x00,0x40,0x00,
 0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,
 0x00,0x0c,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,};
#define anglemeas_width 22
#define anglemeas_height 22
static unsigned char anglemeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x36,0x00,0xc0,0x74,0x00,0xc0,
 0x84,0x01,0xc0,0x0e,0x02,0xc0,0x00,0x0c,0xc0,0x00,0x38,0xc0,0x00,0xc4,0xc8,
 0x00,0x84,0xd3,0x00,0x84,0xcb,0x00,0x68,0xd8,0x00,0x18,0xc0,0x06,0x06,0xc0,
 0x84,0x01,0xc0,0x66,0x00,0xc0,0x34,0x00,0xc0,0x36,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define lenmeas_width 22
#define lenmeas_height 22
static unsigned char lenmeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0xf0,0x00,0xc0,0x8c,0xc0,0xcc,
 0x84,0xb0,0xc8,0x82,0x10,0xc9,0xc2,0x10,0xc9,0x60,0x08,0xc9,0x18,0x0c,0xcf,
 0x08,0x02,0xc0,0xf0,0x01,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x24,0x49,0xd2,0xfc,0xff,0xdf,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define areameas_width 22
#define areameas_height 22
static unsigned char areameas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x80,0x01,0xc0,0xc0,0x03,0xc0,
 0x60,0x05,0xc0,0x50,0x0d,0xc0,0x58,0x15,0xc0,0x54,0x15,0xc0,0x56,0x35,0xc0,
 0x56,0x35,0xcc,0x56,0xf5,0xd7,0x56,0x55,0xd5,0x56,0x55,0xd5,0xdc,0x57,0xd5,
 0x78,0x5c,0xcd,0x18,0x58,0xc7,0x00,0xf8,0xc1,0x00,0x20,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};

#else /* USE_SMALL_ICONS */

/****** NORMAL SIZE ICONS ******/

#define regpoly_width 36
#define regpoly_height 32
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width 36
#define addpt_height 32
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width 36
#define align_height 32
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width 36
#define arc_height 32
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width 36
#define autoarrow_height 32
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width 36
#define box_height 32
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width 36
#define arc_box_height 32
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width 36
#define cirdia_height 32
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width 36
#define cirrad_height 32
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width 36
#define convert_height 32
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width 36
#define c_spl_height 32
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width 36
#define copy_height 32
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width 36
#define glue_height 32
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width 36
#define break_height 32
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width 36
#define open_comp_height 32
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width 36
#define join_split_height 32
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define delete_width 36
#define delete_height 32
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width 36
#define deletept_height 32
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width 36
#define elldia_height 32
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width 36
#define ellrad_height 32
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width 36
#define flip_x_height 32
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width 36
#define flip_y_height 32
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width 36
#define intspl_height 32
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width 36
#define c_intspl_height 32
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width 36
#define line_height 32
static unsigned char line_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width 73
#define library_height 32
static unsigned char library_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width 36
#define move_height 32
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width 36
#define movept_height 32
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width 36
#define polygon_height 32
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width 36
#define scale_height 32
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width 36
#define spl_height 32
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width 36
#define text_height 32
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width 36
#define picobj_height 32
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width 36
#define rotCCW_height 32
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width 36
#define rotCW_height 32
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width 36
#define update_height 32
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width 36
#define edit_height 32
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define areameas_width 36
#define areameas_height 32
static unsigned char areameas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0xee,0x00,0x00,0x00,0x00,0x27,0x01,0x00,0x00,0x80,
0x25,0x03,0x00,0x00,0xc0,0x24,0x05,0x00,0x00,0xe0,0x24,0x09,
0x00,0x00,0xa0,0x24,0x09,0x00,0x00,0xb0,0x24,0x19,0x00,0x00,
0xb0,0x24,0x19,0x00,0x00,0x98,0x24,0x39,0x00,0x00,0x98,0x24,
0x29,0x00,0x00,0x98,0x24,0x29,0x60,0x00,0x98,0x24,0xe9,0xdc,
0x00,0x98,0x24,0xc9,0x97,0x01,0x98,0x24,0x49,0x92,0x01,0x98,
0x24,0x49,0x92,0x01,0x90,0x24,0x49,0x92,0x01,0xb0,0xfc,0x49,
0x92,0x01,0xb0,0x0e,0x4b,0x92,0x00,0xe0,0x03,0x4e,0xd2,0x00,
0xc0,0x00,0x4c,0x72,0x00,0x00,0x00,0x4c,0x3a,0x00,0x00,0x00,
0xdc,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define tangent_width 36
#define tangent_height 32
static unsigned char tangent_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7d,0x00,0x00,0xe0,0x00,0x11,
0x00,0x00,0x00,0x03,0x11,0x00,0x00,0x00,0x0c,0x11,0x00,0x00,
0x00,0x10,0x11,0x00,0x00,0x00,0x20,0x01,0x00,0x10,0x01,0x20,
0x01,0x00,0x30,0x01,0x40,0x01,0x00,0x50,0x01,0x40,0x01,0x00,
0x90,0x01,0x80,0x01,0x00,0x10,0x01,0x80,0x01,0x00,0x00,0x00,
0xc0,0x01,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
0x00,0x40,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x10,0x01,0x00,
0x00,0x00,0x0c,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0xe0,
0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define anglemeas_width 36
#define anglemeas_height 32
static unsigned char anglemeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x07,0x00,0x00,
0x00,0x30,0x07,0x00,0x00,0x00,0x20,0x0f,0x00,0x00,0x00,0x20,
0x30,0x00,0x00,0x00,0x20,0x40,0x00,0x00,0x00,0x20,0x80,0x01,
0x00,0x00,0x70,0x00,0x06,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
0x00,0x00,0x21,0xc0,0x00,0x00,0x80,0xc0,0x20,0x01,0x00,0x80,
0x00,0x0f,0x01,0x00,0x80,0x00,0x8e,0x00,0x00,0x80,0x00,0x4f,
0x00,0x00,0x80,0xc0,0x20,0x00,0x00,0x00,0x21,0xe0,0x01,0x00,
0x00,0x1a,0x00,0x00,0x30,0x00,0x06,0x00,0x00,0x48,0x80,0x01,
0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
0x40,0x0f,0x00,0x00,0x00,0x48,0x07,0x00,0x00,0x00,0x30,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define lenmeas_width 36
#define lenmeas_height 32
static unsigned char lenmeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x80,0x13,0x00,0x40,
0x00,0x70,0x10,0x80,0xc1,0x00,0x18,0x10,0xe0,0x83,0x01,0x08,
0x10,0x30,0x06,0x01,0x0c,0x10,0x10,0x0c,0x01,0x04,0x18,0x18,
0x08,0x01,0x04,0x08,0x08,0x0c,0x01,0x04,0x04,0x08,0x04,0x01,
0x00,0x03,0x0c,0x84,0x01,0xc0,0x00,0x06,0xdc,0x00,0x60,0x00,
0x03,0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x02,
0x08,0x21,0x84,0x10,0x02,0x08,0x21,0x84,0x10,0x02,0xf8,0xff,
0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#endif /* USE_SMALL_ICONS */

/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/

#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/* create the data structures for them */

icon_struct	regpoly_ic = { regpoly_width, regpoly_height, 
				(char*)regpoly_bits };
icon_struct	addpt_ic = { addpt_width, addpt_height, 
				(char*)addpt_bits };
icon_struct	align_ic = { align_width, align_height, 
				(char*)align_bits };
icon_struct	arc_ic = { arc_width, arc_height, 
				(char*)arc_bits };
icon_struct	open_arc_ic = { open_arc_width, open_arc_height, 
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	autoarrow_ic = { autoarrow_width, autoarrow_height, 
				 (char*)autoarrow_bits };
icon_struct	box_ic = { box_width, box_height, 
				(char*)box_bits };
icon_struct	arc_box_ic = { arc_box_width, arc_box_height, 
				(char*)arc_box_bits };
icon_struct	cirrad_ic = { cirrad_width, cirrad_height,
				(char*)cirrad_bits };
icon_struct	cirdia_ic = { cirdia_width, cirdia_height,
				(char*)cirdia_bits };
icon_struct	c_spl_ic = { c_spl_width, c_spl_height,
				(char*)c_spl_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	intspl_ic = { intspl_width, intspl_height,
				(char*)intspl_bits };
icon_struct	c_intspl_ic = { c_intspl_width, c_intspl_height,
				(char*)c_intspl_bits };
icon_struct	copy_ic = { copy_width, copy_height,
				(char*)copy_bits };
icon_struct	glue_ic = { glue_width, glue_height,
				(char*)glue_bits };
icon_struct	break_ic = { break_width, break_height,
				(char*)break_bits };
icon_struct	open_comp_ic = { open_comp_width, open_comp_height, 
				 (char*)open_comp_bits };
icon_struct	join_split_ic = { join_split_width, join_split_height, 
				 (char*)join_split_bits };
icon_struct	deletept_ic = { deletept_width, deletept_height, 
				(char*)deletept_bits };
icon_struct	ellrad_ic = { ellrad_width, ellrad_height,
				(char*)ellrad_bits };
icon_struct	elldia_ic = { elldia_width, elldia_height,
				(char*)elldia_bits };
icon_struct	flip_x_ic = { flip_x_width, flip_x_height,
				(char*)flip_x_bits };
icon_struct	flip_y_ic = { flip_y_width, flip_y_height,
				(char*)flip_y_bits };
icon_struct	line_ic = { line_width, line_height,
				(char*)line_bits };
icon_struct	library_ic = {library_width, library_height,
				    (char*)library_bits };
icon_struct	move_ic = { move_width, move_height,
				(char*)move_bits };
icon_struct	movept_ic = { movept_width, movept_height,
				(char*)movept_bits };
icon_struct	polygon_ic = { polygon_width, polygon_height,
				(char*)polygon_bits };
icon_struct	delete_ic = { delete_width, delete_height,
				(char*)delete_bits };
icon_struct	rotCCW_ic = { rotCCW_width, rotCCW_height,
				(char*)rotCCW_bits };
icon_struct	scale_ic = { scale_width, scale_height,
				(char*)scale_bits };
icon_struct	convert_ic = { convert_width, convert_height,
				(char*)convert_bits };
icon_struct	spl_ic = { spl_width, spl_height,
				(char*)spl_bits };
icon_struct	text_ic = { text_width, text_height,
				(char*)text_bits };
icon_struct	picobj_ic = { picobj_width, picobj_height,
				(char*)picobj_bits };
icon_struct	rotCW_ic = { rotCW_width, rotCW_height,
				(char*)rotCW_bits };
icon_struct	update_ic = { update_width, update_height,
				(char*)update_bits };
icon_struct	edit_ic = { edit_width, edit_height,
				(char*)edit_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height, 
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height, 
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height, 
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height, 
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height, 
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height, 
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height, 
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height, 
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height, 
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height, 
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height, 
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height, 
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height, 
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height, 
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height, 
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height, 
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height, 
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height, 
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height, 
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height, 
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height, 
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height, 
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height, 
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height, 
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height, 
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height, 
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height, 
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height, 
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height, 
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height, 
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height, 
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height, 
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height, 
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height, 
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height, 
				(char*)fbarrows_bits };
icon_struct	tangent_ic = { tangent_width, tangent_height, (char*)tangent_bits };
icon_struct	anglemeas_ic = { anglemeas_width, anglemeas_height, (char*)anglemeas_bits };
icon_struct	lenmeas_ic = { lenmeas_width, lenmeas_height, (char*)lenmeas_bits };
icon_struct	areameas_ic = { areameas_width, areameas_height, (char*)areameas_bits };


/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define no_arrow_width 32
#define no_arrow_height 32
unsigned char no_arrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x04,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x24,0x32,0xd1,0x13,
0x24,0x4a,0x51,0x10,0x62,0x4a,0x53,0x20,0x62,0x4a,0x53,0x20,
0xa2,0x4a,0xd5,0x21,0xa2,0x4a,0x55,0x20,0x22,0x4b,0x59,0x20,
0x22,0x4b,0x59,0x20,0x24,0x4a,0x51,0x10,0x24,0x32,0xd1,0x13,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x10,0x00,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x40, 0x00, 0x06,
  0x00, 0x20, 0xe0, 0x01, 0x00, 0x10, 0x1e, 0x00, 0x00, 0xe8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x20, 0x70, 0x00,
  0x00, 0x40, 0x80, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x07,
  0x00, 0xe0, 0xff, 0x01, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow10o_width 32
#define arrow10o_height 32
unsigned char arrow10o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x08,0x1f,0x00,0x00,0x08,0xf0,0x01,
 0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow10f_width 32
#define arrow10f_height 32
unsigned char arrow10f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
  0x00, 0xf8, 0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow11o_width 32
#define arrow11o_height 32
unsigned char arrow11o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0xe8,0x01,0x00,0x00,0x10,0x1e,0x00,0x00,0x20,0xe0,0x01,0x00,0x40,0x00,0x06,
 0xfc,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow11f_width 32
#define arrow11f_height 32
unsigned char arrow11f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow12o_width 32
#define arrow12o_height 32
unsigned char arrow12o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x03,0x00,0x00,0x80,0x1c,0x00,0x00,0x80,0xe0,0x01,0x00,0x40,0x00,0x0e,
 0xf0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow12f_width 32
#define arrow12f_height 32
unsigned char arrow12f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x80, 0xff, 0x01,
  0x00, 0xc0, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow13a_width 32
#define arrow13a_height 32
unsigned char arrow13a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow13b_width 32
#define arrow13b_height 32
unsigned char arrow13b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14a_width 32
#define arrow14a_height 32
unsigned char arrow14a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14b_width 32
#define arrow14b_height 32
unsigned char arrow14b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
icon_struct	no_arrow_ic = { no_arrow_width, no_arrow_height, 
			      (char*)no_arrow_bits };
icon_struct	arrow0_ic = { arrow0_width, arrow0_height, 
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height, 
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height, 
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height, 
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height, 
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height, 
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height, 
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height, 
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height, 
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height, 
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height, 
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height, 
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height, 
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height, 
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height, 
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height, 
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height, 
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height, 
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height, 
			      (char*)arrow9b_bits };
icon_struct	arrow10o_ic = { arrow10o_width, arrow10o_height, 
			      (char*)arrow10o_bits };
icon_struct	arrow10f_ic = { arrow10f_width, arrow10f_height, 
			      (char*)arrow10f_bits };
icon_struct	arrow11o_ic = { arrow11o_width, arrow11o_height, 
			      (char*)arrow11o_bits };
icon_struct	arrow11f_ic = { arrow11f_width, arrow11f_height, 
			      (char*)arrow11f_bits };
icon_struct	arrow12o_ic = { arrow12o_width, arrow12o_height, 
			      (char*)arrow12o_bits };
icon_struct	arrow12f_ic = { arrow12f_width, arrow12f_height, 
			      (char*)arrow12f_bits };
icon_struct	arrow13a_ic = { arrow13a_width, arrow13a_height, 
			      (char*)arrow13a_bits };
icon_struct	arrow13b_ic = { arrow13b_width, arrow13b_height, 
			      (char*)arrow13b_bits };
icon_struct	arrow14a_ic = { arrow14a_width, arrow14a_height, 
			      (char*)arrow14a_bits };
icon_struct	arrow14b_ic = { arrow14b_width, arrow14b_height, 
			      (char*)arrow14b_bits };

icon_struct	printer_ic = { printer_width, printer_height, 
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

/* new icon from Marc-Aurle Darche */

#define fig_width 64
#define fig_height 64
static char fig_bits[] = {
 0x55,0x55,0x55,0x55,0x55,0xb5,0x6d,0xdb,0x55,0x55,0xa9,0xa4,0x54,0xd5,0xb6,
 0xb5,0x2a,0x95,0x4a,0x95,0xd2,0x6a,0xdb,0xde,0xa9,0x52,0xaa,0x52,0xf5,0xab,
 0x6d,0x6b,0x55,0x55,0x49,0xaa,0xea,0xd7,0xaa,0xd5,0xaa,0x4a,0x25,0x49,0x6a,
 0x2b,0xb7,0xbe,0xa5,0x2a,0x55,0xa5,0xd2,0xdf,0xda,0xd5,0x9a,0x54,0x29,0x95,
 0xd4,0x5f,0xad,0xba,0xa5,0x52,0xa5,0x52,0xea,0xfb,0x76,0xd7,0x55,0x95,0x14,
 0x49,0xe5,0xef,0xda,0xba,0xaa,0xaa,0xaa,0x54,0xf2,0xff,0x6b,0xdb,0xaa,0x24,
 0x49,0x25,0xb5,0xef,0xad,0xad,0x95,0xaa,0x24,0x92,0xf4,0xfe,0xdb,0xf6,0x54,
 0x55,0x55,0xa9,0xfa,0xff,0x6f,0xad,0xab,0x4a,0x55,0x25,0xf9,0x6f,0xbf,0xbb,
 0x54,0x02,0x00,0x95,0xac,0xfb,0xfd,0xd6,0x4a,0x1f,0x50,0x19,0x80,0x5e,0xef,
 0xbb,0x55,0x1f,0xe0,0x7a,0x50,0xeb,0xfa,0xdd,0xaa,0x3e,0xe0,0x3d,0xf8,0x5f,
 0xbf,0xb7,0x55,0x5f,0xe0,0x3c,0xfc,0xea,0xea,0xdf,0x4a,0x7f,0x40,0x1d,0xff,
 0x5d,0xbf,0xbf,0xaa,0x7e,0xc2,0x4e,0xff,0xeb,0xfa,0xdf,0x55,0xf5,0x40,0x84,
 0x7f,0x5f,0xef,0x7e,0xaa,0xf2,0x80,0xe5,0xdf,0xb7,0xfb,0xff,0x55,0x6a,0x81,
 0xf2,0xfb,0xed,0xbe,0xbf,0xaa,0xea,0x89,0xf0,0x7f,0xbf,0xf7,0xff,0xa5,0xea,
 0x01,0xfc,0xff,0xfd,0xde,0x7f,0x54,0xd5,0x03,0xfe,0xff,0xef,0xff,0xff,0x95,
 0xa4,0x03,0xf6,0xef,0xbf,0xff,0xff,0x55,0xd5,0x15,0xf6,0xbf,0xf7,0xfb,0x7f,
 0x55,0x95,0x43,0xf4,0xff,0xff,0xbf,0xff,0xaa,0xaa,0x07,0xea,0xff,0xff,0xff,
 0xff,0xaa,0x54,0x03,0xf4,0xff,0xee,0xfe,0xff,0xaa,0x52,0x11,0xec,0xff,0xff,
 0xff,0x7f,0xaa,0xca,0x18,0xe8,0xff,0xff,0xff,0xff,0x55,0x55,0x1c,0xe8,0xff,
 0xff,0xff,0xbf,0xaa,0x6a,0x2e,0xf0,0xff,0xff,0xff,0xff,0x52,0x15,0xbf,0xd0,
 0xff,0xff,0xff,0x5f,0xaa,0x9a,0x3f,0xaa,0x1f,0x9c,0xff,0xff,0x95,0xc6,0x7b,
 0xa0,0x07,0x04,0xff,0xaf,0xaa,0xd2,0x7a,0x69,0x07,0x00,0xfe,0xbf,0x5b,0xe3,
 0xba,0x40,0x03,0x08,0xff,0xef,0xd5,0x78,0xf5,0x64,0x45,0x0f,0xff,0xd7,0x6d,
 0x74,0x75,0x89,0xe1,0xff,0x7f,0xfa,0xb6,0x5c,0xf5,0xa1,0x02,0x00,0x0f,0x80,
 0x0b,0xe8,0x5a,0x04,0x05,0x81,0x0f,0x80,0x42,0xa2,0x8e,0x50,0x0c,0x80,0x03,
 0x81,0xbd,0xbd,0x7d,0xbf,0xd7,0x96,0xa3,0xe9,0xff,0xff,0xfe,0xff,0xe2,0xc3,
 0xc2,0xe0,0xff,0x77,0xfd,0xff,0xe9,0x83,0x83,0xe8,0x55,0xad,0x56,0x55,0x51,
 0x53,0x4b,0xb0,0xaa,0xb5,0xab,0xea,0xe0,0xc2,0x07,0xf8,0xdd,0x56,0x75,0xbf,
 0x52,0xcb,0x1e,0xfa,0x6b,0xbb,0xad,0xd5,0xe0,0x41,0x8e,0xdf,0xad,0xd5,0xda,
 0xea,0x54,0x25,0x06,0xf8,0xb6,0x6e,0x6f,0xbf,0xf0,0x03,0x01,0xd0,0xdb,0x55,
 0xb5,0xd5,0x54,0x89,0x60,0xe0,0xad,0xba,0x5b,0x6d,0xf0,0xeb,0xa1,0xc1,0xea,
 0x6e,0xed,0x0b,0x5d,0xbf,0xe9,0xca,0xbf,0xd5,0xb6,0x06,0xb8,0xfd,0x01,0xe0,
 0x52,0xbb,0xdb,0x05,0xde,0x77,0x13,0xf0,0xef,0xd6,0xb6,0x2e,0x77,0xff,0x85,
 0xb8,0x5a,0x7b,0xdb,0xab,0xef,0xdd,0x5f,0xff,0xed,0xad,0x6d,0xfd,0xfb,0xf7,
 0xff,0xef};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM_ICON

/* XPM version of xfig icon - first in full color for TrueColor displays,
   then in reduced color for 256 color-mapped displays */

char * fig_full_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64      253            2",
/* colors */
".. c #050804", ".# c #138820", ".a c #793d26", ".b c #ac8664", ".c c #084808", ".d c #74622c",
".e c #e0c68c", ".f c #d0895b", ".g c #3f180a", ".h c #ae643e", ".i c #47511c", ".j c #9c522e",
".k c #ccaa74", ".l c #066813", ".m c #785030", ".n c #412f27", ".o c #b17859", ".p c #eda870",
".q c #117611", ".r c #072804", ".s c #84767c", ".t c #f9e6a4", ".u c #60301f", ".v c #925132",
".w c #ed9967", ".x c #748634", ".y c #1b9c2c", ".z c #07580d", ".A c #9a6350", ".B c #eac8c4",
".C c #cc986c", ".D c #c5774e", ".E c #efb97f", ".F c #b09ea8", ".G c #603b30", ".H c #8c4930",
".I c #342818", ".J c #bb8863", ".K c #b27052", ".L c #7a4730", ".M c #1e6818", ".N c #073707",
".O c #9b6f4f", ".P c #248822", ".Q c #24791f", ".R c #9e5834", ".S c #ae786a", ".T c #8e5b3d",
".U c #1f5717", ".V c #d4a6a0", ".W c #805c3e", ".X c #43251e", ".Y c #b98b84", ".Z c #260f05",
".0 c #eca99d", ".1 c #10801e", ".2 c #e9d9df", ".3 c #d1998e", ".4 c #ae5e39", ".5 c #0a7015",
".6 c #613247", ".7 c #086011", ".8 c #074008", ".9 c #14480e", "#. c #e9dd9c", "## c #cd8d7f",
"#a c #623c3f", "#b c #a05853", "#c c #1c9428", "#d c #924f52", "#e c #279b29", "#f c #f1b7ad",
"#g c #4c2413", "#h c #996960", "#i c #753e49", "#j c #ac6554", "#k c #74514f", "#l c #bd704a",
"#m c #5e4732", "#n c #b27e5b", "#o c #7c4745", "#p c #d5babe", "#q c #766667", "#r c #522f28",
"#s c #f8c9c3", "#t c #c4966c", "#u c #041804", "#v c #fae8e6", "#w c #a4634b", "#x c #ca8055",
"#y c #1c7f21", "#z c #1c892a", "#A c #0a500f", "#B c #d29062", "#C c #f3af77", "#D c #a27759",
"#E c #6c3521", "#F c #6c3c2f", "#G c #c48a60", "#H c #997169", "#I c #ae8069", "#J c #dd9d90",
"#K c #fbc88b", "#L c #146818", "#M c #84503c", "#N c #082f05", "#O c #603629", "#P c #de9966",
"#Q c #14380a", "#R c #259425", "#S c #f0b0a5", "#T c #146016", "#U c #25a430", "#V c #605e24",
"#W c #51372f", "#X c #bc6843", "#Y c #bc7852", "#Z c #1c7720", "#0 c #945638", "#1 c #145812",
"#2 c #ac715c", "#3 c #1e6f16", "#4 c #b99391", "#5 c #2f1c15", "#6 c #147019", "#7 c #14400a",
"#8 c #522a32", "#9 c #746e6c", "a. c #f7d0cb", "a# c #94868c", "aa c #e2b982", "ab c #bfadb4",
"ac c #ac9aa0", "ad c #fcfafa", "ae c #e3a774", "af c #4f4947", "ag c #f0a290", "ah c #f8d7d3",
"ai c #fbf7b0", "aj c #896240", "ak c #fcd898", "al c #1a0a04", "am c #2c3614", "an c #e3a89e",
"ao c #87645e", "ap c #685048", "aq c #a07972", "ar c #e4a694", "as c #c4a4a8", "at c #a7888f",
"au c #888084", "av c #ef9f69", "aw c #f1bf87", "ax c #d9c1c4", "ay c #f0bfba", "az c #dcd294",
"aA c #052004", "aB c #6c4834", "aC c #9c5150", "aD c #1d6012", "aE c #fbe1e0", "aF c #904a52",
"aG c #805e54", "aH c #844225", "aI c #b9877c", "aJ c #6c3644", "aK c #6c3b46", "aL c #84534c",
"aM c #c4948e", "aN c #25811f", "aO c #d49f96", "aP c #14500e", "aQ c #fceff0", "aR c #a48264",
"aS c #fbd092", "aT c #e2a06e", "aU c #e4b078", "aV c #a17f79", "aW c #fcb87e", "aX c #a46f4e",
"aY c #e4b6b0", "aZ c #fcb076", "a0 c #341404", "a1 c #443a24", "a2 c #cf9f6f", "a3 c #c48e84",
"a4 c #c48879", "a5 c #041004", "a6 c #fce09c", "a7 c #aa8784", "a8 c #dc885f", "a9 c #fc9a74",
"b. c #844830", "b# c #8f5b4e", "ba c #fcaa94", "bb c #ac5e54", "bc c #a46a5c", "bd c #844847",
"be c #d4825a", "bf c #a47264", "bg c #bc806f", "bh c #fcb29c", "bi c #1c7228", "bj c #343234",
"bk c #148e25", "bl c #401e13", "bm c #78563f", "bn c #e4ced4", "bo c #ceaeae", "bp c #cf9285",
"bq c #4f2a1e", "br c #846a4c", "bs c #8a6a69", "bt c #94766c", "bu c #fca284", "bv c #fcaa74",
"bw c #bc7a64", "bx c #fcbab1", "by c #bc8059", "bz c #dc915f", "bA c #143204", "bB c #fcc084",
"bC c #fcc1b5", "bD c #141a04", "bE c #8c7274", "bF c #ecd094", "bG c #6c4846", "bH c #a46a51",
"bI c #1c8e24", "bJ c #78422e", "bK c #b36a43", "bL c #1ca22c", "bM c #9c6a52", "bN c #5c4234",
"bO c #b68e6a", "bP c #278e20", "bQ c #a45e39", "bR c #422a20", "bS c #633642", "bT c #a05e4f",
"bU c #945651", "bV c #7b4246", "bW c #ac6a54", "bX c #795651", "bY c #e0a297", "bZ c #bc9a99",
"b0 c #342214", "b1 c #c4b2b4", "b2 c #e4aea6", "b3 c #ecc68c", "b4 c #7c4f3f", "b5 c #0f781d",
"b6 c #5c3231",
/* pixels */
"bK.h#XbKbK#X#l#X#l#l#l#l#l#l#l#l.D#l.D.D#Y.D.D#Y.D.D#Y.D.D#Y#l.D#l#l#l#l#l#l#XbKbKbK.h.h.h.h.h.hbQ.4bQ.R.R.R.R.R.R.j.R.v.j.v.j.v",
"bK#XbKbK#lbK#lbK#l#l#l#l#l.D#l.D#l.D#Y#l.D#l#Y.D#Y#Y.D#Y#Y.D.D#l.D.D#l#l#l#l.ObK#XbK#XbK.h.h.h.4.4bQbQbQ.4.R.R.R.j.j.j.j.j.j.v.v",
"bKbKbK#XbK#l#l#l#l#l#l#l#l.D#l.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y#l.D.D#l.xbk.5.hbKbKbK.h.h.h.4bQ.4bQ.RbQ.R.R.R.R.R.j.j.j.v.v.j",
".hbK#lbK#X#l#X#l#l#l#l.D#l.D#Y.D#Y#Y.D#Y#Y#x#Yby.D#Yby#Y#x#Y#Y#Y#Y.D#Y#Y.h.z.q.1.7bKbK#XbK.h.h.h.hbQbQ.4.RbQ.R.R.R.j#0.j.j.v.v.v",
"#X#XbK#l#lbK#l#l#l#l.D#l#Y#Y#Y#Y#Y.Dby#Yby#Yby#Ybyby.Dby#Yby.Dby#Y#Y#Y#YbQ.r.7#y.7#VbKbKbKbK.h.h.4bQ.4bQbQ.R.R.R.R.j#0.j.j.j.v.v",
"bKbK#lbK#l#l#l#l#l#Y#l#Y#Y.D#Y.D#Yby#Yby.Dbybyby#xbybybybybyby#Yby.D#Y#Y#Y#w.8.q.M.z.m#lbK.hbK.h.h.hbQbQbQbQ.R.R.R.R#0.v.j.v.v.v",
"bK#lbK#l#l#l#l#l#Y#l#Y#Y#Y#Y#Yby#Yby#Ybybybybybybybybybybyby.Dbyby#Yby#Y#YaX.N.9#1.z.N#0bKbKbK.h.hbQ.hbQbQ.RbQ.R.j.R.j.j.v.j.v.v",
"#lbK#X#l#l#l#l#Y#l#Y#Y#Y#Y#Y#Y#Yby#xbybybyby#xbybybybyby#xbybybybybyby#Y#x.K.r.c#A.z.7#A.ibKbK.hbKbQ.4bQbQbQ.R.R.R#0#0#0.j.v.v.v",
"bK#l#l#l#l#l#l#Y#Y#Y#Y#Y#Ybybybybybybybybybyby.Jbybyby.Jbybybybybyby#Yby#YbM.N.z.7.5.5#T.l.7.W.h.h.h.hbQbQbQ.R.R.R.R.j#0.v.v.v.v",
"bK#lbK#lbK#Y#l#Y#l#Y#Y#Yby#Yby#Ybybybybyby.Jby.Jby.J.Jby.Jby.Jbybybybyby#n#m.8.z.7.7.U.#.1.5#A.WbK.hbQbQbQbQbQ.R.R.j#0.j.v.v.v.v",
"#l#l#l#l#Y.K#Y.K#Y#Y#Y#Yby#Yby#nby#n.J.J.Jby.J.J.J.Jby.J.J.Jby.JbybybybybH.N#A.c.9#L.1.1.1.1.l.c.W.h.hbQbQbQ.R.R.R#0.R#0.v.v.v.v",
"#X.K#l.K#l#l#Y#Y#Y#Y.o#Yby#nbybyby.Jby#n.J.J.J.J.J.J.J.J.J.J.Jby.J.Jby#n.m.8.c.N.z.l.l.5.5.l.l.7#AbQ#wbQbQbQ.RbQ.R#0.j.v.j.v.v.v",
"#l.K#l#l.o#l.o#Y.o#Ybyby#nbyby#n.Jby.J.J.J.J.J.J.J.J.J.J.J.J.J.J#n.J#n#Dam.N.N.9.7.7.l.l.l.z.7.7.7.z.W.hbQbQbQ.T.R.R#0.v.v.v.v.H",
".K#l.K#l#Y.K#Y#Y#Y#Y.o#Yby#nbyby.J.J#n.J.J.J.J.J.J.J.J.J.J.J.J.J.Jby.Jbm.r.N#A.z.7.7.l.l.7.7.l.5.l.7.z.ibQbT.R.R.R.R.v.R.v.v.v.v",
"#l#l.K#l.K#Y.o#Y.o#0#nbybybK.KaX.K#D.o.O.O#D#naR#n.bbO.J.b.J.b.J.J.J#Da1.N.c#A.7.7.lb5.1.5.5.1.1.1.1.5.l.z.mbQ.R.R#0#0.v.v.v.v.H",
".K#l.K#l.o#l.o#YaX#lbO.k.ea6a6a6a6akakakakaSbFaT.WbObO#D#Y.C#t.C#t#t.K.T.W.W.d#V.7.1.#.1.1bkbkbkbkbk.1.5.5.7.i#0#0.R.v.j.v.v.H.v",
".K#l.K#Y.K#Y.o#Y#0#E.v.hbeaaa6a6a6.t.taS#G#G#x#xaj.JbOaj.fa2.e#.aiaiaiaiazaz#K.o#3.#bk.#.#.ybk.y.ybk.#.1.1.5.z.c.m.R#0#0.v.v.v.v",
".K#l.K.K#l.o#Y.oaBal.Za0aH#Baka6a6a6a6aS#xbqbqa0#D.J.J#W.u.H#Y.p.taib3bz.f.D#Y.W.#bkbk#c#c.ybLbL.y.y.1.#.1.1.l.z.c.L.v#d.v.v#M.H",
".K.K#l.o.K#Y.o.o.Lalalala0bKaaa6a6a6a6.t#xblalb0aRbObralala0bKakaiaUa8#wbq.Z.ZaD.##c#c#c.ybLbLbLbL.ybk.#.1.1.5.7.c.c.m.v.v.v.H.v",
"#l.K.K#l.o.K#Y.obmalalalal.a#Gakakaka6a6.E#M..bNbObO#m..a0.vb3#.aUa8.L.Z..al#Q.qbk#c.y.y#e#U#UbLbL.ybI#c.1.#.1.l.z.8.8.H.v.v#M.H",
".K.K.K.K.o#Y.o.o#Malalalala0.D#Kaka6aka6aSbKal.O.baRalalbJaU#.aebe#Fal..bD#Q#L#Z#z#c#cbP#R#U#U#UbL#ebIbI#Z.1b5.5.z.8.8.N#M.H.v.H",
".K.K#l.K#l.o.o.o.Aa1.Xalal.Z#0aeakakakakak#P#WaRbObral.aa2bFae#l#Oal#N#A.7#6b5#6.##c#e#e#e#U#U#U#e.ybPbI#y.#b5.l.z.c.8.N#W.v#d.H",
".K.K.K.o.K.o.o#Y.o.o#n.Oalal.g#lakakakakak.EbQbObO.b#F#Gb3ae.K.u..#N.c.z.7#6.q#Z#z#cbP#e#U#e#e#e#R#e#c#y.#.1.1.l.z.c.8.8#N.H#M.H",
".K.K.K.K.o.K.o.o.o#n#n#nbmala0.haeaSakakakak.Dbt.J.O#YaSaT#l.X..#N.8#A.z#L#6#3#3#ybIbP#R#e#e#e#ebP#RbI#z#y#y.q.7.c.8.8.N#N#W.vbd",
".K.K.K.K.K.o.o.o.o.o#n#n.oalal.a.faSaSaSakaSaTaj#D.o#KaTbK.X...r#N.8#A.c.7#L#6b5aN#y.PbP#R#RbP#R#R.P#y#Z#6.q#6.7#A.c.8.8.r.Ib..H",
"bW.K.K.K.o.K#Y.o.obw.S.o#n#mal.g.DaaaSaSaSaS#KbQbKawaebK.X..#u.N#N.8.c.c#T#L#6#3#Z#3aN.P.PbPaN.P#zaN#Z#Z#L#6#L.7.8.8.8.N#NaAb.bd",
".KbW.K.K#2.K.o.o.o.o#n#n#IbMal.Z.R#PaSaSaSaSaSa8aaaebQbq..a5.r#N#N.N#A#A.7#T.MaD#Z#3aN#y.P.PaNaN#y.M#3#Z#T#6.7#A.c.c.8#N.raA.G.v",
"bW.K.K#2.K.o#2#2.o.o.o.o#n#nalal.u.D#K#KaS#KaS#K.EbH.u...na5aA#N.N#N.c.9#A#1#T#Tbi.M#3.Q#y#y#y.M#y#3.M#LaP#L.7#A.N.N.8.N.raA#rb.",
".KbW.K.K.K#2.K.o.o.o.S.o#I.o.Wala0.4a2#K#K#KaS#K#B#Oal.Wbma5aA.r#N#N.8.8aP#1#1.U.MaD.M.Q#Z#Z.Q.Ubi#L#L#T.c#T.z.8.N.8.N.N.r#ubqbd",
"bW.KbW.K#2.K.o#2.o.S.o.S.o.S.Oalal.H.D#K#K#K#K#K#P#Fbm.bapa5#u.r#N#N.8.8.caP#1aP#TaDaD#3#3#3.MaDbi#1#T#1.9.z.c.8#N.N#N.raA#u.nb.",
"bWbW.KbW.K#2.K#2.o.K.o.o.o#I.obNal#g#lbB#K#K#K#K.EbQaR#Ibma5#u.r.r#N.N.N#7aPaP.9.U#TaD#T#L.M#LaP#T#1#T.9.c#A.c.8.N.N#NaA#ua5b0bd",
"bWbWbW.K.K.K#2.K#2#2.o.S.o.o.S.Wal#g#laWbBbBbBbB#K#x.T#I.Wa5#uaA.r.r#N.8.N.c.9.9aP#1aPaD#T#1.U#7#TaPaP.N.8.9.8.N.r.r.r.r#ua5bqb.",
"bWbWbWbW#2#2.K#2#2.o#2.o.o.o.o.Sbl.Rae.EbBbB#KbBbBav#0#naja5#u#uaA.raA.NbA.N.9#7.9aPaP#1#1#1#7aPaP.c#7#N.c.8.N#N.r.r.raA#u..#r#o",
"#jbWbWbWbWbW#2#2#2#2#2bf.obf.o.AbQaT.E.f.fbBbBbBbBbB.h#h#Ha5a5#uaAaAaA#N#N.N#7.c#Q.9#7.9aP.9#7.c.9.9.8.r.8.N#N.r.raAaAa5a5..#E#o",
"bWbWbWbWbWbW#2bW#2#2#2.obf.obM.R#PaW.f.jbQbBaWbBbBaW.f#0.o#5a5#u#uaA#u.r.rbA#N#Q#Q#7#Q.9#7.9#N.9.8.N#N.r.N#N.r.raAaA#ua5....bJbV",
"bK#j#jbWbW#2bWbW#2#2#2bW#2aX.R#BaW#B.a.g#XaTbBaWaWaW#C#0aXbN..#u#u#u#uaA.raAbA.N#N#Q.N#Q.8#Q#N#7#NbA#N.r#N#NaA#u#u#ua5.....XbJ#o",
"#j#j#jbW#jbWbWbW#2bW#2#2aX.v.faW#BbJ.Z.Z.v#laWaWaWaWaW#l.W.A..a5#uaA#uaAaAaA.rbA.rbA.rbA#NbA#N#N.r.r.raA.raA#u#u#ua5......b6bVbJ",
"#j#j#j#jbWbWbWbWbWbWbWbH.v.faWav.R.Zalal#E.havaWaWaWaW#P.v#2.n..#u#u#u#uaAaAbDaA.raA.r.r.raAbA.raAaAaA#u#u#u#ua5a5......#5bJbVbV",
"#j#j#j#j#jbWbWbW#2bWbH.v#xaZ#P.Rbl.I#rala0.R.faWaZaZ#C#C.R.A.A....a5#u#uafas.2aQbnaubD.rafa##9bDaAaA#u#u#ua5a5a5a5......aJbJbVbJ",
"#j#w#j#j#j#j#j#jbc#w#0#xaZ.p.hbqbR.A.Aal.ZaH.RaZaZ.EaZ#C#x#MbWb4..a5a5#qayahaEaEaQaEaubEa.adaQab#u#ua5a5#ua5a5........bq.LbVbVbV",
"#jbb#j#w#jbH#jbW#w#0#xaZbv.K.u...Tbc#2#5.Z.g.4#P#CaZ#C#CaT.v#wbc#r..afb2a.#sbCbCbC#fbZ.3a.a.#say#9a5a5a5a5a5..a5.....Z#ibVbJbVbJ",
"bbbT#jbT#j#jbcbT.v#xaZav#x.aalb4bWbWaX#oala0.jbK#C#C#C#C.pbQ#MbW.Aa0a7bC#s.0.wbhbxaObsbgbhbxbxaO#qa5a5..a5........#5aKbJbVbV#i#i",
"bb#jbb#jbb#wbT.j#xaZaZ#xaH.ZaB#jbWbcbW.Aalal.u.4#P#C.p#C.p#BaH#jbcbcbYbCbC.3aLbKbyaLbRbd.wag.3bf.na5.............ZaK#obVbJbJ#ibJ",
"bbbQbbbT#jbU.jbebvaZbe.vblb6#wbcbc#jbc#j.Gal.g.R#x#C.p.p.p.p.R#M#jbf.0bCbx.Y#W.ubq#5al#g.aaLb4aoa5..........bj#qbsb4bVbV#i#i#i#i",
"#b#b.R#0.v.ja8bvaZav.4.ubRb##j#j#w#jbc#j#Mal#g.j.D.p.p.p.p.p.fb..Sa3#fbx#S#4ababbZacb1bnaQaQaEat.........s#p#vadaQaE#p#p#pb1as#i",
"b..4bK.DbeavaZaZbvbv#X#X.4bQ#0#b#j#wbU.v.R.R.R.h#P.p.p.p.paT.p#Y.vbg###J.BaQadadabaEadaQaEa.boap......a#a.ad#va.#s#saEadadadb1.G",
"b..4bzbza8.w.w.w.w#P#Pav.w#l.HbT#w#jb6.j#xbz#PaT.p.p.pavae.paTaT#P.f.Rb#bx#fbx#SaM#J#S#S#S#S#4bN#r#ObsayaE#sana3###S.0ananara7bS",
".uaH.aaH.a.a.a.aaHaHaHaHaHaHaHbTbTbU.g.aaH.HaHaHaHaHaHaHaH.H.H.v#Mb..vaqa4#2bHbW.Y.AbWbY#Sb2aIbGbd#o.Y#sah#Sa3b4bwbh#SanbfbT#H#a",
"b6alalalalalalalalalalalalal#Fbbbb#Malalal.Zal.Zal.Z.Zal.Z.Z.Zbl.G#h.SbpaM.G.u.ubq#Wa4#S#Sanaq#ibdbGaObC#San#H#Wa3bxananaVbq#g.G",
"aC#i#O#E#OaJ#O#FaJ#F#FaJ#O.G#dbTbTbd#r#r#rbq#r.Xbq.X.XbR.X.Xb0.X.AbY#f#S.YbGaK#F#FaB#J#f#SbYbs#obd#Wbp#Sb2an#H#q#Sa.#SbY#HbSb6aK",
"#b#b#b#bbb#b#b#bbQ#b#b#bbb#b#bbTbb#b#b#b#b#b#b#b#b#b#b#b#b#bbUbU.SbY#S#Sa7b4#daF#dbXbY#S#S.3aG#o#obRbwbab2ana7axaha.anaMbXbSaKaJ",
"aC.4aCbbaC#b#bbb#b#bbb#b#b#bbb#b#b#b#bbT#b#bbT#bb##bbU#bbUbUbU#d#I.0#SanaV#o#daL#o.Aan#S#SaMap#obV.X#oa9.0anayadaEaY#J#H#raJaKaK",
"#baC#baC.4aC#baC#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#bbUbUbU#d#b#daLa4.0#SbY#HbdbdaF#o.S.0#SanaIbGbVbVb6#g.va9an.0#Sb2a3.A.GbSaKaJbS",
"aCaCaCaCaCaC#baC.4aC#baC#b#baC#b#b#b#b#bbU#b#dbU#daCbUaCbU#d#daLbpag#SaO#qaFaLbdaK.Y.0.0anaV#kat#4#ibqaoanahbY#hb#.L#rb6aJ#aaJaJ",
"aC#b#b#b#baC#baCaCaC#baCaC#b#baCaC#daC#d#b#d#b#d#b#d#d#d#d#d#0bU.3.0#SbpaGbdbdbd.G##.0.0bYbZ.2aQac#iaobZ#S#fan#say#pa##iaKaJbSaJ",
"aCaCaCaCaC#baCaCaCaCaC#baCaCaC#b#d#b#b#daCbU#d#d#d#d#d#0#d#d#db##J#S.0.Y#kbdbdbd.Ga4.0an.0aEaQ.Bbtat.BaQaEananan#SbCa.axbXbSaJbS",
"aCaCaCaCaCaCaCaC#baCaCaCaCaC#daC#daC#d#daC#d#d#d#d#d#d#d#daLaFbfbYbaan#IbGbdbdbdb6bTbu.0anan.3bgaqaY#vahanbga4#JanbYb2ayboaKbSbS",
"aCaCaCaCaCaCaCaCaCaCaCaCaC#d.R#daC#daC#d#d#d#d#d#d#daF#dbdaFbdbgan.0.3bs#ibdbdbV#i.u.R#jbHbT#M#Oao#f#sbY#Ib4b.bTbg#JbYbY.VbsbS.6",
"aCaCaCaCaCaCaCaCaCaC#daC#daC#d#d#d#d#0#d#d#d#d#d#dbd#d#h#p#pa7#J.0.0#IbGbdbVbVbVbVbSbq.u.ub6b6bq.S.0.0bYaI#Wbl.ubJ.D.0bY.3bs.6bS",
"aCaFaCaFaCaFaFaCaFaC#daC#daFaCaFaC#daFaF#daF#daFaFaFaLaOahadad#S.0##.AaKbVbdbVbV#ibVbV#i#i#i#i#8b#buanbY.Vbo.Fab#pa.aybYaIbGbS.6",
"aCaFaCaFaCaFaCaFaCaFaCaFaFaCaFaFaFaFaF#daFaFbdaFbdaF#obp#S#f#say#J#hbS#ibVbVbVbV#i#i#i#i#iaK#ib6#ObebabYanayaEadad#vaYbpaG#8bS.6",
"aCaFaFaFaFaCaFaCaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbV.Kag.0babp.A.GaKbd#ibd#i#i#i#i#i#i#iaK#iaJblbV.DbpbYbYb2#SaYbYbgaL#W.6.6.6",
"aFaFaCaFaFaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdbdbdbdaH#jbw#2aL.uaKbV#ibV#i#ibV#i#i#iaK#iaJaKaJaJbl.a#dbT#2bg.Sbc#M.Gb6.6.6.6.6",
"aFaFaFaFaCaFaFaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdaFbdaFbVbd#i#E#E.ub6#i#ibVbV#i#i#i#i#i#i#iaJ#iaJaKaJaKaJ#8bq.u#F#O.u.u#8#8.6.6.6.6.6"
};

/* now reduced colors (notice that some match the predefined brown3, brown4, red4, etc */

char * fig_reduced_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64       32            1",
/* colors */
". c #000000", "# c #009000", "a c #925132", "b c #bb8863", "c c #145812", "d c #fbc88b",
"e c #bc8059", "f c #000000", "g c #9e5834", "h c #47511c", "i c #ed9967", "j c #000000",
"k c #b17859", "l c #000000", "m c #84767c", "n c #fbf7b0", "o c #748634", "p c #00b000",
"q c #a05853", "r c #ffe0e0", "s c #bc7852", "t c #b09ea8", "u c #000000", "v c #b27052",
"w c #ffc0c0", "x c #aa8784", "y c #900000", "z c #d5babe", "A c #803000", "B c #bd704a",
"C c #ffffff", "D c #a04000",
/* pixels */
"BgBBBBBBBBBBBBBBsBssssssssssssBsBBBBBBBBBBgggggggggggggggggagaga",
"BBBBBBBBBBBBBsBsBssBsBsssssssssBssBBBBvBBBBBggggggggggggggggggaa",
"BBBBBBBBBBBBBsBssssssssssssssssssBssBo##gBBBgggggggggggggggggaag",
"gBBBBBBBBBBsBssssssssesessesesssssssgc##cBBBBgggggggggggggaggaaa",
"BBBBBBBBBBsBsssssseseseseesesesessssglc#chBBBBggggggggggggagggaa",
"BBBBBBBBBsBsssssseseseeeeeeeeeesessssql#ccaBBgBgggggggggggaagaaa",
"BBBBBBBBsBssssseseseeeeeeeeeeeseesessvlccclaBBBgggggggggggggagaa",
"BBBBBBBsBssssssseeeeeeeeeeeeeeeeeeesevlccccchBBgBggggggggaaagaaa",
"BBBBBBBsssssseeeeeeeeeebeeebeeeeeesesqlcc##cccaggggggggggggaaaaa",
"BBBBBsBsBssseseseeeeebebebbebebeeeeekulcccc###caBgggggggggagaaaa",
"BBBBsvsvssssesekekbbbebbbbebbbebeeeevlcccc####ccaggggggggagaaaaa",
"BvBvBBssssksekeeebekbbbbbbbbbbbebbekalclccc##ccccgqggggggagagaaa",
"BvBBkBkskseekeekbebbbbbbbbbbbbbbkbkklllcccccccccccaggggaggaaaaaa",
"vBvBsvssssksekeebbkbbbbbbbbbbbbbbeballccccccccc#ccchgqggggagaaaa",
"BBvBvskskakeeBvvvkkvvkkkkbbbbbbbbbkjlccccc#########ccagggaaaaaaa",
"vBvBkBksvBbidddddddddddiabbksbbbbbvaaaahc############chaagagaaaa",
"vBvsvsksauageddddnndbbeeabbaeiddnnnndddk#####p#pp#####ccagaaaaaa",
"vBvvBksku.ffabddddddefffkbbufasinndiessa###ppppppp####cccaayaaaa",
"vvBkvskka...fBdddddnef.fkby..fBdniiqfffc#ppppppppp#####cccaaaaaa",
"BvvBkvska....abdddddda.ubbu.faddiiaf..l##ppppppppp#p###ccllaaaaa",
"vvvvkskka....fsddddddB.vbk..aidieu...lc##pp#pppppp######clllaaaa",
"vvBvBkkkqjf..faidddddiukby.aidiBu.lcc####ppppppppp#####ccclluaya",
"vvvkvkkskkkv..fBddddddgbbbubdivf.lccc####p#pppppppp####ccclllaaa",
"vvvvkvkkkkkka.fgidddddsmbvsdiBf.llccc######ppppp#p#####cclllluaA",
"vvvvvkkkkkkkk..aedddddiakkdiBf.lllcccc######pp#pp######ccclllfaa",
"vvvvkvskkekkku.fsddddddgBdiBf..lllcccc##############c#ccllllllaA",
"vvvvkvkkkkkkbq.fgidddddidigf..llllcccccc#########c##c#ccccllllua",
"vvvkvkkkkkkkkk..fsdddddddvf.j.llllcccccc#c#####c##ccccccllllllja",
"vvvvvkvkkkkkbka.fgidddddbu.aa.llllllccccccc####c#ccccccllllll.fA",
"vvvvkvkkkkkkkkv..asdddddiuabu..lllllccccccc###cc#ccccccllllll.ja",
"vvvvvkvkkvkkkbku.fBddddddgkba..llllllcccccccccccccccccclllll..fA",
"vvvvvvkvkkkkkkka.fBddddddeaba..llllllcccccccccclcccllcllllll..fa",
"vvvvkkvkkkkkkkkkfgiddddddiaka...llllllclcccccclcccllclllllll..jA",
"vvvvvvkkkkkkkkkqgideedddddgqm...lllllllclclccclccclllllllll...uA",
"vvvvvvkvkkkkkkqgideggdddddeakf...l.llllllllclclcllllllllll....aA",
"BvvvvkvvkkkvkvgbdbafBiddddiavu.....llllllllllllllllllll......faA",
"vvvvvvvvkvkkvaedbaffaBdddddBaq...l.lllllllllllllllllll.......uAa",
"vvvvvvvvvvvvaedigf..ugiddddiakj.....ll.llllllllllll.........faAA",
"vvvvvvvvkvvaeiigffj.fgediiiigqq.....utrCrm.luxm.ll..........uaAa",
"vqvvvvvvvqaeiigffqq.fagiidiieava...mrrrrCrmmrCCt...........faAAA",
"vqvqvvvvqaeiivf.avkfffgiiiiiiaqvj.uwrrrrrztwrrrrm.........fuAaAa",
"qqvqvvvqaeiiea.avvvA.fgBiiiiigavqfxrrwidrwmbdrrwm........fuaAAuu",
"qvqvqqqgeiieafuvvvvq..fgiiiiibavvvwrrwyBeyfAiwwkj.......fuAAaaua",
"qgqqvygeiieafuqvvvvvu.fgeiiiiigavkwrrxufff.fayay......jmmaAAuuuu",
"qqgaagiiiigffyvvqvvva.fgsiiiiieakxzrwxttttzrCCrx....mzCCCrzzzztu",
"agBseiiiiiBBggaqvqyaggggiiiiiiisabbwrCCCtrCCrrzu...xrCCrrrrCCCzu",
"agiiiiiiiiiiiBaqqvugeiiiiiiiiiiiiegyrzrwxwwwwwxujumrrrwxbwwwwwxu",
"faaaaaaaaaaaaaaqqyfaaaaaaaaaaaaaaaaxbkvvxqvwwwxuAAxrrwxaedwwkqmu",
"u.............uqqa...f.f.ff.ffffuqkwxufffubwwwxuAuwrwwmuxrwwxffu",
"DuuuuuuuuuuuuuyqqAjjjfjfffffffffqwzwxuuuuuwzwwmAAuwwwwmmwrwwmuuu",
"qqqqqqqqgqqqqqqqqqqqqqqqqqqqqqyykwwwxayAyAwwwwyAAfewwwxzrrwxAuuu",
"DgDqDqqqqqqqqqqqqqqqqqqqyqyqyyyybwwwxAyyAqwwwxuAAfAiwwrCrzwmjuuu",
"qDqDgDqDqqqqqqqqqqqqqqqqqyyyyqyybwwwmAAAAkwwwxuAAufaiwwwwxquuuuu",
"DDDDDDqDgDqDqqDqqqqqyqyyyDyDyyyywwwwmAyAuxwwwxAxxufywrwqyajuuuuu",
"DqqqqDqDDDqDDqqDDyDyqyqyqyyyyyaywwwwyAAAubwwwtrCtuytwzwrrzxuuuuu",
"DDDDDqDDDDDqDDDqyqqyDyyyyyyayyyywwwxAAAAubwwwrCrmxrCrwwwwrrzAuuu",
"DDDDDDDDqDDDDDyDyDyyDyyyyyyyyyAkwwwbuAAAuqwwwwwbxzCrwbbwwwwrzuuu",
"DDDDDDDDDDDDDygyDyDyyyyyyyAyAAAbwwwmuAAAufgvvqauyzrwbaaqbwwwwmuu",
"DDDDDDDDDDyDyDyyyyayyyyyyAyqzzxwwwbuAAAAAufffuufkwwwxuffaswwwmuu",
"DADADAADADyDyADADyAAyAyAAAywrCCwwbquAAAAuAAuuuuuywwwwzttzrrwxuuu",
"DADADADADADAADAAAAAyAAAAAAAwwzrrwquuAAAAuuuuuuuuuewwwrrCCCzwyuuu",
"DAAAADADAAADAAAAAAAAAAAAAAAvwwwwquuAuAuuuuuuuuuufAswwwwwzwbyuuuu",
"AADAAAAADAAAAAAAAAAAAAAAAAAavekyfuAuAuuAuuuuuuuuufayqkbkvauuuuuu",
"AAAADAAAAAAAAAAAAAAAAAAAAAAuuufuuuAAuuuuuuuuuuuuuuuffuuffuuuuuuu"
};

#endif /* USE_XPM_ICON */

/* bitmap of letters for splash screen ("3.2.X") */

#define letters_width 243
#define letters_height 110
static char letters_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,
 0xc0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,
 0x00,0xfc,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x3f,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0xfc,
 0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,
 0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x1f,
 0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
 0x07,0xc0,0xff,0x03,0x00,0x00,0x00,0x00,0x7f,0x80,0xff,0x3f,0x00,0x00,0x00,
 0x00,0x00,0xfe,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf8,0x03,0xc0,0xff,0x03,0x00,0x00,0x00,0x00,0x1f,0x00,0xfe,0x7f,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x03,0x80,0xff,0x07,0x00,0x00,0x00,0x80,0x0f,0x00,0xfc,0x7f,0x00,
 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0x07,0x00,0xff,0x07,0x00,0x00,0x00,0xc0,0x07,0x00,0xf8,0xff,
 0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x0f,0x00,0xff,0x0f,0x00,0x00,0x00,0xc0,0x07,0x00,0xf8,
 0xff,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0xff,0x0f,0x00,0x00,0x00,0xe0,0x07,0x00,
 0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xff,0x0f,0x00,0x00,0x00,0xe0,0x07,
 0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xff,0x0f,0x00,0x00,0x00,0xf0,
 0x1f,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x80,0x0f,0xff,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xff,0x0f,0x00,0x00,0x00,
 0xf0,0x7f,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x80,0x0f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0xff,0x0f,0x00,0x00,
 0x00,0xf0,0xff,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0xc0,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x80,0xff,0x0f,0x00,
 0x00,0x00,0xf0,0xff,0x01,0xf0,0xff,0x01,0x00,0x00,0x00,0xc0,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x80,0xff,0x07,
 0x00,0x00,0x00,0xf0,0xff,0x03,0xf0,0xff,0x01,0x00,0x00,0x00,0xc0,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x0f,0x80,0xff,
 0x07,0x00,0x00,0x00,0xf0,0xff,0x03,0xf8,0xff,0x01,0x00,0x00,0x00,0xc0,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x07,0xc0,
 0xff,0x03,0x00,0x00,0x00,0xf0,0xff,0x03,0xf8,0xff,0x00,0x00,0x00,0x00,0xe0,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0xff,0x03,0x00,0x00,0x00,0xf0,0xff,0x03,0xf8,0xff,0x00,0x00,0x00,0x00,
 0xe0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0x01,0x00,0x00,0x00,0xe0,0xff,0x03,0xfc,0xff,0x00,0x00,0x00,
 0x00,0xe0,0xc1,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0x00,0x00,0x00,0x00,0xe0,0xff,0x01,0xfc,0x7f,0x00,0x00,
 0x00,0x00,0xf0,0xf9,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0xc0,0xff,0x01,0xfe,0x3f,0x00,
 0x00,0x00,0x00,0xf0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x80,0xff,0x00,0xff,0x3f,
 0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x07,0xfe,0x0f,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0xff,
 0x1f,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0x0f,0x00,0x00,0x00,0x00,0xfc,0x07,0xfe,0xff,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0xff,0x07,0x00,0x00,0x00,0x00,0xfe,0x01,0xf8,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0x00,0x7e,0x00,0xf0,0xff,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0x7f,0x00,0xe0,0xff,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xff,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0xc0,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x0f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfc,0x7f,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0xc0,0xff,
 0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0xc0,
 0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,
 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x7f,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
 0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0xe0,
 0x03,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x00,0xf0,0x1f,0x00,0x0c,0x00,0x00,
 0x00,0x00,0x04,0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,
 0xf0,0x0f,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,0x3c,0x00,
 0x00,0x00,0x80,0x3f,0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,
 0x00,0xf8,0x1f,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0x3e,
 0x00,0x00,0x00,0xe0,0x7f,0x00,0x80,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,
 0x00,0x00,0xfc,0x3f,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,
 0x1e,0x00,0x00,0x00,0xf0,0xff,0x00,0x80,0xff,0x07,0xf0,0xff,0xff,0xff,0xff,
 0x1f,0x00,0x00,0xfc,0x3f,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0x80,0x7f,0x00,
 0x00,0x1f,0x00,0x00,0x00,0xf0,0xff,0x00,0xc0,0xff,0x07,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0xc0,0x1f,
 0x00,0x00,0x1f,0x00,0x00,0x00,0xf8,0xff,0x01,0xc0,0xff,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0xe0,
 0x07,0x00,0x80,0x0f,0x00,0x00,0x00,0xf8,0xff,0x01,0xc0,0xff,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xfc,0x7f,0x00,0xe0,0x01,0x00,
 0xf0,0x03,0x00,0xc0,0x0f,0x00,0x3c,0x00,0xf8,0xff,0x01,0xc0,0xff,0x03,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0xfc,0x7f,0x00,0xf8,0x07,
 0x00,0xf8,0x01,0x00,0xf0,0x07,0x00,0xff,0x00,0xf8,0xff,0x00,0xe0,0xff,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0xfe,0x7f,0x00,0xfc,
 0x0f,0x00,0xfc,0xff,0xff,0xff,0x07,0x80,0xff,0x01,0xf8,0xff,0x00,0xe0,0xff,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0xfe,0x3f,0x00,
 0xfe,0x1f,0x00,0xfe,0xff,0xff,0xff,0x07,0xc0,0xff,0x03,0xf8,0x7f,0x00,0xf0,
 0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x07,0x00,0xff,0x3f,
 0x00,0xff,0x3f,0x00,0xff,0xff,0xff,0xff,0x03,0xe0,0xff,0x07,0xf8,0x3f,0x00,
 0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0x00,0xff,
 0x1f,0x00,0xff,0x3f,0x80,0xff,0xff,0xff,0xff,0x03,0xe0,0xff,0x07,0xf0,0x1f,
 0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0x80,
 0xff,0x0f,0x00,0xff,0x3f,0xc0,0xff,0xff,0xff,0xff,0x03,0xe0,0xff,0x07,0xf0,
 0x07,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
 0xc0,0xff,0x07,0x00,0xff,0x3f,0xe0,0xff,0xff,0xff,0xff,0x01,0xe0,0xff,0x07,
 0xe0,0x07,0x00,0xfe,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x03,0xe0,0xff,0x03,0x00,0xff,0x3f,0xf0,0xff,0xff,0xff,0xff,0x01,0xe0,0xff,
 0x07,0xe0,0x0f,0x80,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf0,0x0f,0xf8,0xff,0x01,0x00,0xff,0x3f,0xf0,0xff,0xff,0xff,0xff,0x01,0xe0,
 0xff,0x07,0xc0,0x3f,0xe0,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0xff,0xff,0x00,0x00,0xfe,0x1f,0xf8,0xff,0xff,0xff,0xff,0x00,
 0xc0,0xff,0x03,0x80,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0xff,0xff,0x3f,0x00,0x00,0xfe,0x1f,0xf8,0xff,0xff,0xff,0xff,
 0x00,0xc0,0xff,0x03,0x00,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0xff,0x0f,0x00,0x00,0xfc,0x0f,0xf8,0xff,0xff,0xff,
 0x7f,0x00,0x80,0xff,0x01,0x00,0xfc,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x00,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x00,0xe0,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,0x00,0xf0,0x1f,
 0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x07,0x00,0x00,0x80,
 0x1f,0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x03,0x00,0x00,
 0x80,0x1f,0x00,0x00,0x00,0x00,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0x00,
 0x00,0x80,0x0f,0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,
 0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
 0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf0,0x01,0x00,0x00,0xc0,0x07,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x01,0x00,0x00,0xe0,0x07,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x3f,0x0f,0xf8,0xe1,0xdf,0x1f,0xe0,0xe7,0x07,0x80,0x9f,0x07,0xec,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0xff,0x1f,0xf8,0xe0,0xff,0x3f,0xe0,0xfb,0x0f,0xe0,0xff,0x0f,0xfe,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xe3,0x0f,0xfc,0x00,0x3f,0x7e,0xf0,0xff,0x0f,0xf0,0xf1,0x07,0x1e,
 0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xc1,0x0f,0xfc,0x80,0x1f,0x7c,0xf0,0x8f,0x0f,0xf8,0xe0,0x07,
 0x07,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0xc0,0x0f,0x7c,0x80,0x1f,0x7c,0xf0,0xc7,0x0f,0x7c,0xe0,
 0x07,0x03,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xf8,0xc0,0x07,0x7e,0x80,0x0f,0x7c,0xf0,0xc3,0x07,0x7c,
 0xe0,0x03,0x00,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfc,0xe0,0x07,0x7e,0xc0,0x0f,0x7e,0xf8,0xe1,0x07,
 0x7e,0xf0,0x03,0x00,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xe0,0x07,0x3e,0xc0,0x0f,0x7e,0xf8,0xe1,
 0x07,0x7e,0xf0,0x83,0x07,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0xe0,0x03,0x3e,0xc0,0x07,0x7e,0xf8,
 0xe0,0x03,0x3e,0xf0,0xc1,0x0f,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0xf0,0x23,0x3f,0xc1,0x07,0x3e,
 0xfc,0xf0,0x13,0x3e,0xf8,0xd1,0x0f,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0xf0,0x33,0x3f,0xe3,0x07,
 0x3f,0xfc,0xf0,0x31,0x3e,0xf8,0xd9,0x0f,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0xf8,0x19,0x9f,0xe1,
 0x07,0x1f,0x7c,0xf0,0x19,0x3e,0xfc,0xcc,0x07,0x1f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xfc,0x0f,0xdf,
 0xe0,0x8f,0x0f,0x7e,0xf0,0x0d,0x7c,0xfe,0xc7,0xc1,0x0f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
 0xff,0xf0,0xff,0x07,0x7e,0xf0,0x07,0xfc,0xff,0x83,0xff,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe3,
 0x03,0x3e,0xf0,0xfb,0x01,0x3e,0xe0,0x03,0xf0,0xf1,0x01,0xfe,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00};

/* splash background in XPM */

#ifdef USE_XPM

char *spl_bckgnd_xpm[] = {
/* width height ncolors chars_per_pixel */
"   630   210       60            1",
/* colors */
". c #000000", "# c #945e3c", "a c #ece8ff", "b c #a49ad1", "c c #8b8377", "d c #bb9b81",
"e c #241920", "f c #b2a9dd", "g c #78480c", "h c #d5d1fe", "i c #cec3ff", "j c #cdc3fe",
"k c #e5d6cd", "l c #aca9c3", "m c #b9b6dd", "n c #9d9ea7", "o c #b2a9e8", "p c #c0b6f1",
"q c #fceacb", "r c #a59add", "s c #a77c5e", "t c #e5c4b5", "u c #f1dde8", "v c #7f4d28",
"w c #d6a089", "x c #d1b6a9", "y c #d9d1ff", "z c #816c5b", "A c #ada9dd", "B c #674927",
"C c #433312", "D c #cbc3f1", "E c #fecaa9", "F c #fcfcf9", "G c #0d2e06", "H c #aa8c77",
"I c #c3a79a", "J c #e5b29d", "K c #dcd3cc", "L c #582c05", "M c #a9899a", "N c #d6cec9",
"O c #bebee6", "P c #d6d6fe", "Q c #2a3a09", "R c #8484b4", "S c #c3b4a9", "T c #2f1604",
"U c #8d89b6", "V c #cccdc9", "W c #d4d3cd", "X c #64665c", "Y c #9e9ac3", "Z c #aca9d1",
"0 c #73593e", "1 c #bfb6e8", "2 c #1d0205", "3 c #ffffff", "4 c #747474", "5 c #696999",
/* pixels */
"PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPR",
"OPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRR",
"OOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRR",
"OOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRR",
"OOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRR",
"OOOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRRR",
"OOOOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRRRR",
"OOOOOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRRRRR",
"OOOOOOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRRRRRR",
"OOOOOOOOOPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPRRRRRRRRRR",
"OOOOOOOOOO1f1tZffZb1fopfZrfrrbo1bbbrfrooppAtfAxZZorrAofopjoajpootoEt1rofffo1f1AbfofZr1Zfff111ZZZIrmmmlbmxlxkDOxmpayqyaaiEiaOmZt11bf1ooAfmt1f1OIISlSlflxlfmlZllllfmfSlIZxZxmxYIxmxZmZIYx1lZxxZSlZlfZllxIlIZlYIxlYYZllmIIYSYIllZllxmmZbmbflYIxlIIbYZlZbYZbf1f1tZffZb1fopfZrfrrbo1bbbrfrooppAtfAxZZorrAofopjoajpootoEt1rofffo1f1AbfofZr1Zfff111ZZZIrmmmlbmxlxkDOxmpayqyaaiEiaOmZt11bf1ooAfmt1f11OIISlSlflxlfmlZllllfmfSlIZxZxmxYIxmxZmZIYx1lZxxZSlZlfZllxIlIZlYIxlYYZllmIIYSYIllZllxmmZbmbflYIxlIIbYZlZbYZbf1f1tZffZb1fopfZrfrrbo1bbbrfrooppAtfAxZZorrAofopjoajpootoEt1rofffo1f1AbfofZr1Zfff111ZZZIrmmmlbmxlxkDOxmpayqyaaiEiaOmZt11bf1ooAfmt1f1RRRRRRRRRR",
"OOOOOOOOOOffm11fbbft1fpbIZfZbrfbIYbbrroooofpobZfttrfrforooopjpEppEppppp1AtofmpfZZffxZ1xm1fftZZb1b1fkObxfmlxtDmf11qaayjfiyiaakOkhmZZfffZZfOf1mD1ZlIllmxZxfmbtmlbImxZYlZlllYIlYYxZZJxrllxpfZxmxZZxx1mxZIYYIlZIIllIIIllbZZlbImmxfxbb11mlxAxIIIZIYlAfAbmblIAbffm11fbbft1fpbIZfZbrfbIYbbrroooofpobZfttrfrforooopjpEppEppppp1AtofmpfZZffxZ1xm1fftZZb1b1fkObxfmlxtDmf11qaayjfiyiaakOkhmZZfffZZfOf1mfD1ZlIllmxZxfmbtmlbImxZYlZlllYIlYYxZZJxrllxpfZxmxZZxx1mxZIYYIlZIIllIIIllbZZlbImmxfxbb11mlxAxIIIZIYlAfAbmblIAbffm11fbbft1fpbIZfZbrfbIYbbrroooofpobZfttrfrforooopjpEppEppppp1AtofmpfZZffxZ1xm1fftZZb1b1fkObxfmlxtDmf11qaayjfiyiaakOkhmZZfffZZfOf1mRRRRRRRRRR",
"OOOOOOOOOOftfmfZbIZmmxobbfofbobAbbbrYwoprrJE1bx1ftbbbtooooooopoopjEEppo1fpfAmofrIZfZxfbJZfZZfffZxtm1OOmllfSlZZmftyaaioopaykaam1m1tffffZxZfxmxDDkflIlZZtfmxlfmmxZmxmxZlxZZlllIZZf1DlmbImmxxxIffxfmfOllllYlIt1AIYlIllYxflblYllfffZfmxffxZrfZAlbAIJAoo1bZxbmftfmfZbIZmmxobbfofbobAbbbrYwoprrJE1bx1ftbbbtooooooopoopjEEppo1fpfAmofrIZfZxfbJZfZZfffZxtm1OOmllfSlZZmftyaaioopaykaam1m1tffffZxZfxmxxDDkflIlZZtfmxlfmmxZmxmxZlxZZlllIZZf1DlmbImmxxxIffxfmfOllllYlIt1AIYlIllYxflblYllfffZfmxffxZrfZAlbAIJAoo1bZxbmftfmfZbIZmmxobbfofbobAbbbrYwoprrJE1bx1ftbbbtooooooopoopjEEppo1fpfAmofrIZfZxfbJZfZZfffZxtm1OOmllfSlZZmftyaaioopaykaam1m1tffffZxZfxmxRRRRRRRRRR",
"OOOOOOOOOOoofoffZYlIfIZfZZrrfffbbrbIrZpoopqiZo1bAbtp11pf1oooftoJojjp1opop1fZfYZZmldxZIxambxIf1lbOmZmfkymZYSIZxmEypyipypDDDaaamxmxffm11fmAZIxl11kDxlYImmmmfOD1Df1lxZjmflllIlZfZfmolmmDx1mmZlmxmmZxlIIYYYlYlIllllbOZmlxtAlIIlZ1pt11m11ZAtjp1DfrZomAoomAZffZoofoffZYlIfIZfZZrrfffbbrbIrZpoopqiZo1bAbtp11pf1oooftoJojjp1opop1fZfYZZmldxZIxambxIf1lbOmZmfkymZYSIZxmEypyipypDDDaaamxmxffm11fmAZIxlx11kDxlYImmmmfOD1Df1lxZjmflllIlZfZfmolmmDx1mmZlmxmmZxlIIYYYlYlIllllbOZmlxtAlIIlZ1pt11m11ZAtjp1DfrZomAoomAZffZoofoffZYlIfIZfZZrrfffbbrbIrZpoopqiZo1bAbtp11pf1oooftoJojjp1opop1fZfYZZmldxZIxambxIf1lbOmZmfkymZYSIZxmEypyipypDDDaaamxmxffm11fmAZIxlRRRRRRRRRR",
"OOOOOOOOOO11fbAAYIbZZZIbbbbbAEpmrYbYbroA1oDyZbxfbbbrbrAfot11roooEpEoopEpopfxZIxfxYlIIltOlZmxbmfmZxxZAyOxxlxmmmEyyiiiyEyDEjaaaffmfmfmf1b1mmlmfmfmOfZIlZIZIxmmxmfllxtDllIllYIfx1fmmlmI1mfmZlxmZIl1mIxlYYlYIIlIZbfmmlIIZmxYlYlxAf11f1mm1m1pff1ZxofofpZfxfofo11fbAAYIbZZZIbbbbbAEpmrYbYbroA1oDyZbxfbbbrbrAfot11roooEpEoopEpopfxZIxfxYlIIltOlZmxbmfmZxxZAyOxxlxmmmEyyiiiyEyDEjaaaffmfmfmf1b1mmlmffmfmOfZIlZIZIxmmxmfllxtDllIllYIfx1fmmlmI1mfmZlxmZIl1mIxlYYlYIIlIZbfmmlIIZmxYlYlxAf11f1mm1m1pff1ZxofofpZfxfofo11fbAAYIbZZZIbbbbbAEpmrYbYbroA1oDyZbxfbbbrbrAfot11roooEpEoopEpopfxZIxfxYlIIltOlZmxbmfmZxxZAyOxxlxmmmEyyiiiyEyDEjaaaffmfmfmf1b1mmlmfRRRRRRRRRR",
"OOOOOOOOOOfffbbIYZxfZm1AbfZbrD1rbrbbbAopmftpbfZAIbbrfbb1rotEoDoppppppEj111ffmZZllIxYIflxxbZOfm1y1Zxfff11xflmDmiaajjjEpqiiia3yAZxoZZmZf1mffmtmlmbfflIlfllZZlZIlYYlYmxlIlIlIZmomlmmblZ11f1lIfmlZbllllllblllllYY1OmlYIlYIYYIYYIfbJ1b1btDtDmZfr1mfrff1IxZZmfffffbbIYZxfZm1AbfZbrD1rbrbbbAopmftpbfZAIbbrfbb1rotEoDoppppppEj111ffmZZllIxYIflxxbZOfm1y1Zxfff11xflmDmiaajjjEpqiiia3yAZxoZZmZf1mffmtmmlmbfflIlfllZZlZIlYYlYmxlIlIlIZmomlmmblZ11f1lIfmlZbllllllblllllYY1OmlYIlYIYYIYYIfbJ1b1btDtDmZfr1mfrff1IxZZmfffffbbIYZxfZm1AbfZbrD1rbrbbbAopmftpbfZAIbbrfbb1rotEoDoppppppEj111ffmZZllIxYIflxxbZOfm1y1Zxfff11xflmDmiaajjjEpqiiia3yAZxoZZmZf1mffmtmRRRRRRRRRR",
"OOOOOOOOOOoAtAZbYZbrbYYIAbbbbIIrbIbZbrjoropEZbfobJAoDoZZrrropEpoojtpE1ofopbbmmlAA1xfbfhxSxZmZfoyfSIZDImDZbfZYmpaaopA11kayy3aaSbfffbmxffYYYtD1lfAImZZxlZYYlIlIllYYllD1ZYIYmZfllxxYYlb1m1mZxflIfDZl1lYlIYYYlZfklllYYYlYYZYYllfotpij1pffoxffxffpyj1ffYblIAofoAtAZbYZbrbYYIAbbbbIIrbIbZbrjoropEZbfobJAoDoZZrrropEpoojtpE1ofopbbmmlAA1xfbfhxSxZmZfoyfSIZDImDZbfZYmpaaopA11kayy3aaSbfffbmxffYYYtD1IlfAImZZxlZYYlIlIllYYllD1ZYIYmZfllxxYYlb1m1mZxflIfDZl1lYlIYYYlZfklllYYYlYYZYYllfotpij1pffoxffxffpyj1ffYblIAofoAtAZbYZbrbYYIAbbbbIIrbIbZbrjoropEZbfobJAoDoZZrrropEpoojtpE1ofopbbmmlAA1xfbfhxSxZmZfoyfSIZDImDZbfZYmpaaopA11kayy3aaSbfffbmxffYYYtD1RRRRRRRRRR",
"OOOOOOOOOOoJ1ZbZbZZflbIYrbZIbbYbrZbAboEpoijjbbbfrooopobwArrrooij1oooD1oobobfmZxZbf1AZxDtOxttxJmymbxkkf11fkOmlZEiyj1rkOD11payi3mZA1ft1fAlblxkmYlff1fmmxlIIZIZxZIlIlIfODfZxlxoIYllIllm1ZffmflZtkktxOlYYlllYIlxmYIlYnnYYYZYYYxfDk1Dmjt11xfmffof11m1AZZbllb1ooJ1ZbZbZZflbIYrbZIbbYbrZbAboEpoijjbbbfrooopobwArrrooij1oooD1oobobfmZxZbf1AZxDtOxttxJmymbxkkf11fkOmlZEiyj1rkOD11payi3mZA1ft1fAlblxkmZYlff1fmmxlIIZIZxZIlIlIfODfZxlxoIYllIllm1ZffmflZtkktxOlYYlllYIlxmYIlYnnYYYZYYYxfDk1Dmjt11xfmffof11m1AZZbllb1ooJ1ZbZbZZflbIYrbZIbbYbrZbAboEpoijjbbbfrooopobwArrrooij1oooD1oobobfmZxZbf1AZxDtOxttxJmymbxkkf11fkOmlZEiyj1rkOD11payi3mZA1ft1fAlblxkmRRRRRRRRRR",
"OOOOOOOOOOo1ofZZbfZbbbbYYZArrZbbbfAAooEyi1fobZfroEEiyrrrrftooEiEooo1oooDo1ffmffZZxmfZffDDmf1m1O11ZY1ODmODOmxxZopEoE1kup11qyEj3aaxf1oAfJffSmkmIbfZfZZIllYlxlZmxlIlbl11mOfmr1flIfZIYbm1tft1xZxaamOxIYIIlIIYYxOYIIIYYYYYYZIIYIfD1fm1ty1f11mxZmfm1Z1ExxlIZbmfo1ofZZbfZbbbbYYZArrZbbbfAAooEyi1fobZfroEEiyrrrrftooEiEooo1oooDo1ffmffZZxmfZffDDmf1m1O11ZY1ODmODOmxxZopEoE1kup11qyEj3aaxf1oAfJffSmkmfIbfZfZZIllYlxlZmxlIlbl11mOfmr1flIfZIYbm1tft1xZxaamOxIYIIlIIYYxOYIIIYYYYYYZIIYIfD1fm1ty1f11mxZmfm1Z1ExxlIZbmfo1ofZZbfZbbbbYYZArrZbbbfAAooEyi1fobZfroEEiyrrrrftooEiEooo1oooDo1ffmffZZxmfZffDDmf1m1O11ZY1ODmODOmxxZopEoE1kup11qyEj3aaxf1oAfJffSmkmRRRRRRRRRR",
"OOOOOOOOOObf1fJfffAfZIbYIllbbr1bobb1AJyamoppbbJrpiypjtorrootEEpoo1ro1ofoZbfpqZZIIr1mfff1tfffDflmk1qh1fZblxSIYr1frJooOmoffqmmpD1a33aDo1AfomfOmitffrAtffoAop1fffZflIloptmfxkmmlbxZpxItO1kODmmtDZmmxllIlxmIYlVIfIYYlYYIYYYIbbmD1tJmD1qptfxf111yO1m11DyDbIbbbbf1fJfffAfZIbYIllbbr1bobb1AJyamoppbbJrpiypjtorrootEEpoo1ro1ofoZbfpqZZIIr1mfff1tfffDflmk1qh1fZblxSIYr1frJooOmoffqmmpD1a33aDo1AfomfOmpitffrAtffoAop1fffZflIloptmfxkmmlbxZpxItO1kODmmtDZmmxllIlxmIYlVIfIYYlYYIYYYIbbmD1tJmD1qptfxf111yO1m11DyDbIbbbbf1fJfffAfZIbYIllbbr1bobb1AJyamoppbbJrpiypjtorrootEEpoo1ro1ofoZbfpqZZIIr1mfff1tfffDflmk1qh1fZblxSIYr1frJooOmoffqmmpD1a33aDo1AfomfOmRRRRRRRRRR",
"OOOOOOOOOOjyqZfo1ffrrAbYZFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFropa1tboioJpJopiaaiypooojEjoppff1fAf1YZlZffbYYfo1ofo1pfmxZlxmZJf1fYIZmmZxZtprbo1f1oiotaxIEZfy333k1ot1m1mt1pppAopjiDppfm1ffxmAfmfAooop1AffmZZmxOZZmk11oxpmDhxIllIYYYIlZSmmIZYYIYnYYYYIZYYfm11om11y11Zf11tpj1mIAo1tDfofbtjyqZfo1ffrrAbYZYYIrIbbtooropa1tboioJpJopiaaiypooojEjoppff1fAf1YZlZffbYYfo1ofo1pfmxZlxmZJf1fYIZmmZxZtprbo1f1oiotaxIEZfy333k1ot1m1mt1RRRRRRRRRR",
"OOOOOOOOOOyqy1AbJofAbZZIIFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFooEpojJpiiDjtEpayyyiqoopoooooDot1f1f1bZlIYmmmbfmf1ppttZxZ1mxbZIIZfYxmxZZxt1oorbfmAojoEoZmDf1Daayyam1mO1mfmtDmft1ppfmf1fmOf1ZIroopopoptfZxbZbflxxbfO111fmOjDZxxYlIYIZbxmAbmxIZIYYYYIIYZbZfm11tmOmEootpfjyhmZxxoffmo11myayqy1AbJofAbZZIIbZZbAfZjopooEpojJpiiDjtEpayyyiqoopoooooDot1f1f1bZlIYmmmbfmf1ppttZxZ1mxbZIIZfYxmxZZxt1oorbfmAojoEoZmDf1Daayyam1mO1mfmRRRRRRRRRR",
"OOOOOOOOOOOmf1DjtJbbrAZffFFFFFFFFFFFF2FFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFTFFFFFFFFFFFFFF2FFFFFFFFFFFFFFQFFFFFFFFFFFFF2FFFFFFFFFFFFF.FFFFFFFFFFFFF2FFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFF.FFFFFFFFFFFFFTFFFFFFFFFFFFFGFFFFFFFFFFFFFFQFFFFFFFFFFFFF2FFFFFFiDoED1AfJroyaayaaaporoE1rboAooDp1mro1frfZfxfbfptDDkD1jOf1mtfxmIlYllllIYIbZJbbwmk1ffxyayy1111xyaaaatDVpEDDl1oEpyFaaaipOffbf11kmffEffoEjpoAAoEmxfZfpDpp1mSll1DblIlYIZfmxflIboblIdYYYIlIYfYbfbIZfAZipjt11fommbffopo11tp1xqOmf1DjtJbbrAZffZffbffbEioiDoED1AfJroyaayaaaporoE1rboAooDp1mro1frfZfxfbfptDDkD1jOf1mtfxmIlYllllIYIbZJbbwmk1ffxyayy1111xyaaaatDVpEDDlRRRRRRRRRR",
"OOOOOOOOOODff1o1D1ffJfrffFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEjojbffooD1rrpjayiqD1pprrrfooo11tot1frf1tA11t11p1m111Ea1ffD1bbbYIldbfIlYIbbbbrOOpoZl1aaqaOOmmyaaaatDh1DDDkDyaaa3aaaaaJott1AfZropDf11pEpoofppfofbtp1ofmlIfbomxYYYlZZOmxZZZbAbbYYIYxlYbYllfmbZfZboiD1p1ff1f1mffo11po111tyDff1o1D1ffJfrffffZZbAbyDoEjojbffooD1rrpjayiqD1pprrrfooo11tot1frf1tA11t11p1m111Ea1ffD1bbbYIldbfIlYIbbbbrOOpoZl1aaqaOOmmyaaaatDh1DDDkRRRRRRRRRR",
"OOOOOOOOOOhfoo1fZff1oAfAbFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFppijor1o1fJorrooobArfyjoooopoffAoppofrrqqpotpkD11xIotqiDmZf111fYdIMIxZbfrZZorfODAoxx1yjiy1y1paiaayDyyDyyjiyyaaa33aaaappijttfbAfpj1tox1tofbqyAopppjt1xb1Zx1DxlIbYIlmxxZZbbZfAZIIYIlYYYYbbffIffrfjDfoomffo1111bpo111ppmjthfoo1fZff1oAfAbbbIoopoArrppijor1o1fJorrooobArfyjoooopoffAoppofrrqqpotpkD11xIotqiDmZf111fYdIMIxZbfrZZorfODAoxx1yjiy1y1paiaayDyyDyyjiRRRRRRRRRR",
"OOOOOOOOOOhZAfZZfZbbtOfroFFFFFFFFFFFFGFFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFQFFFFFFFFFFFFFGFFFFFFFFFFFFFFGFFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFF.FFFFFFFFFFFFFCFFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFFQFFFFFFFFFFFFF2FFFFFFFFFFFFFGFFFFFFFFFFFFFFTFFFFFFFFFFFFFTFFFFFF444444obbtootE1mmflArtopjqDDptoofopoppfoopatjj1p11omtOm11Dmf1oftfYZtDEEp1Zbbmmxf1mx1DhD1ZtjD1yyiq1pj1xq11aayiyyyPaaaaa333attZffopmfx1pop1opo1JfoEorpZxtDZmlfIllZlfZbYxlZffbIIIZbZbYYYIlZbbxAfi1mmbfff1Aofffrmfio1ffAfDDhZAfZZfZbbtOfroffbrJ1frIooEDo1robbtootE1mmflArtopjqDDptoofopoppfoopatjj1p11omtOm11Dmf1oftfYZtDEEp1Zbbmmxf1mx1DhD1ZtjD1yyiq1pj1xq11aRRRRRRRRRR",
"OOOOOOOOOO1mbfffmffAAff1oFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444ooroOfh1ffbbwoJppEjp1yyyj1fptorooj1oyiyiDtt1mmlIf1mZxlZrffZIIpyipppxbmmxZllZfxyZZYZotOxyyq1pyommmxmaiyiyayDtaaaaaayaa1fxZ1ObAZf1O1111ppptfypbpoxDklZZZlYbSmyflIlIlxZlbYblbbYIYYYIfofbbZhm1ffoAffAfAAfff11of1frrf11mbfffmffAAff1ofrft1ZA1tptpJprwooroOfh1ffbbwoJppEjp1yyyj1fptorooj1oyiyiDtt1mmlIf1mZxlZrffZIIpyipppxbmmxZllZfxyZZYZotOxyyq1pyommmxmaRRRRRRRRRR",
"OOOOOOOOOOpDmbArbAfbJfA1oFQFF2FFTFFTFTFFCFFCFFTFFTFF2FFFFTFFGFFGFFGFFGFFGFTFFGFFGFFGFFTFFTFTFF2FFTFF2FFQFFFCFCFFQFF2FF2FFCFFQFFFF2FFTFFTFFCFFQFFQF2FFQFFTFFCFFCFF2FFFFCFFTFFQFFTFFGFFGFQFFGFFGFFGFF.FFGFFTFFQFFCFFQFFQFFQFFFFQFFGFFQFFTFFTFFQFCFFGFF.FFGFF.FFTFGFF.FFGFFQFFGFFQFFa444444oobomAmfo1AooojoEp1o1ED1pm1tEjJopDDkiyD1DE1ffZbxZxxZbYlbZAYIbooyjtbZJmfZxIYIZxOllII111OiytpyyoffmxZyaiaaymDiDaaayaiyapx1bbfAbbx1fZZbxoEjp11pbbrAlflIlZfZtfiDlIYImZblYlbIbZYIZIIbrfp1ZfoDtp1ZbbAfffbffff11ptfo1fo1pDmbArbAfbJfA1op1DhZJbotDoooorboobomAmfo1AooojoEp1o1ED1pm1tEjJopDDkiyD1DE1ffZbxZxxZbYlbZAYIbooyjtbZJmfZxIYIZxOllII111OiytpyyoffmxZyRRRRRRRRRR",
"OOOOOOOOOOm1fZmmfffAbAfkkukuuuuuuuuuuKuuKuuuuukuuuuuuuuuuuuuuuuuuukuuuuuuuuuukuuuuuuukuuuuuKuuuuuuukuuuuuuuKuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuKuuuuuuuuuuKuuKuuukuuuuuuuukuuuuuuuuuuukuuKuuKuuKuuuuuuuuuuuuuuKuuKuuuuuuKuuukuukuuKuuuuuuuKkuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuKuuu444444offmAftpobbbfoppjDbbroffftjptp1ofEEyotAf11fffIllZxmZbxbomZIYIb1pptftqmbfxZftOfIZxZthZfthEiiatfmfkDjaaaaiDfoEyyayyiaaaiaj1tEDEofmfxrIfbZrf1fpifZo1mffZfkmmymllYlxYIYIZIIYZbZlYYrpt1E1foyfpmfbZAfmZfAfmb111Doffmtf1m1fZmmfffAbAfkkkD1mmfAxOZot1rrJoffmAftpobbbfoppjDbbroffftjptp1ofEEyotAf11fffIllZxmZbxbomZIYIb1pptftqmbfxZftOfIZxZthZfthEiiatfmfkDjaRRRRRRRRRR",
"OOOOOOOOOOfp1xff1o1Abbma3VVWVVNVxVVNVVWVVNVVVVVVVVVNVVNVNVNVNVVVNVVVNVCQCVWNVVVVVNVVVVVVVVVVWVNNVVVVVVVVVNVVNVVVNVVVVVNVVVVNVVVNVNVNVVNVVVVVVVVVVWVVVNVVVVVVVWVVVVVWVNVVNVVVNVNVVNVVVVVVVWVVWVVVVWVVVVVVVVVVVVWQQQQWVVVVVVVVVVVVVWVWVVVVVVVWVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVWVVV444444mAZbbopyoofboorbrfAJffJf1j1pp1ottqitqDotpxxmIIml1OxbZZJbrZblZZbbtpjyhAffm111xflxmxDDtmDD1ijDmZSxmpyaayyayjDf111yODaapyyat1OjiifxbZ1IIrom1fZfDoo1pofmZfO1pkZlYYlZlIllIbZIIZbIbbpjtff1opqpqfDfZbfmmfZfxfZo1fJZff1p1fp1xff1o1Abbma3uPDmrxZbobfZrJrfmAZbbopyoofboorbrfAJffJf1j1pp1ottqitqDotpxxmIIml1OxbZZJbrZblZZbbtpjyhAffm111xflxmxDDtmDD1ijDmZSxmpyaRRRRRRRRRR",
"OOOOOOOOOOff1ffffffrbfODuVVVVVVVWVVVVCVVVVVVVVVVVVVVCVVVVVVVVVNVVVQWVQVVVCVVVVVWGVVWVWVNVWVVVVQVVVVVVVVNVVVVVQVVVVNVVVVVVVVVQNVVVVVVVVVVVVQNVVVWVVVWVVVVGWVWVVVVWVVVVVQVVVVVVVVVVVVVVQVVVVVVVNVVVVVQNVVNWVVNVVTVVVC2WVVVVWVWVVWVQVVVNVVVVWVVVVQNVWVNVVNVWVVWVTVVVNVVVVVWVNVQNVVVVV444444ZIwIrmop1JpmrfmZrfpooroopptDtt1opij111f1qmZlIlZSxYZmfxAZrr1bbo1ZrojjkbxZffff1DZxfmtqO1DyjyypDfODjyyyyyiyaqDpoop1ZZ1aayyaEpf1DjopffZAIZoofZbZbZmZapptfbopo1AlIbllbIIYYIZYZbZZZbp11AbJyymphf1O1bAAmffZfmfmoAfbff1ffff1ffffffrbfODukkDmZIZfoJmbftffZIwIrmop1JpmrfmZrfpooroopptDtt1opij111f1qmZlIlZSxYZmfxAZrr1bbo1ZrojjkbxZffff1DZxfmtqO1DyjyypDfODjyyyRRRRRRRRRR",
"OOOOOOOOOOAtoorrrotukDm1OVVVWVVVVWVVVVWVVVNVVVVWVVVVVVVVVVNVVVVVWVVVCVQQCVCVWWVVVVVVVVVVVVVNVVNVVWVWVNVVVVVWVVWVVVVVNVVWVNVVVVVVVVVWVVVVVVVVVWVVVVVVVVVWVVVVVVVVVVWVNVVVVWVVWVNVWVNVNVVNVWVNVVVWVNVVVNVVNVNVNTCTTNVVCVNVNVVVVWVVVVVWVVNVVVVNVVVVVVVVVWVVVVNVVVWVVVVVVNVVVVVVVVWVVV444444xmfbfbrfofZfffm11opD1111pEjoo1mt1pi11o1fZflbmlIIlZxlYxYlf11ffftEDDqqqmbxZxf1fDZfbxxpakkt1amDyyaihaaaaayaayttO1ZAfbAEEooiEDyprbp1D1orffAo1poJfbIYyipiypt11ZbIYYIIlbZZIIZZbbbo1optAfAo11xmIbfAfrfrZbbfZfxrffoZff11mAtoorrrotukDm1OZtmmAboAofArfOffxmfbfbrfofZfffm11opD1111pEjoo1mt1pi11o1fZflbmlIIlZxlYxYlf11ffftEDDqqqmbxZxf1fDZfbxxpakkt1amDyyaihaaaRRRRRRRRRR",
"OOOOOOOOOOfAJoopoyaauDfZIVWVVVVWVVVNWVVNWNVVWNVVNVWNVWVVNVVWNWVNVVNTVVVCVNVQVVVNVWWVNVNNNVNVNVNVNVNVVNVNVNVNVVVNVWNVNVNVNVVNWVNNWVNVVNWVNVNVVVNNWNNVNVNVWVVNVNWNNNVVVVWVWVNVVWVNVVWVVNWVVNVVNVNVVNVVWxVNNVVVTVNCNVNVNTWVVVWNVVWVWNVNVWVNNVWVNVWVNVNWVVNVNWVVVNVWVWWNWVWVNVNWVNVNVV444444fmmZIZZffbIbZJxbf1optDtfboptotf1D1pfAJobtmIlIlYIbfmSYYIIf1frAptDp1DqDo1ZIlpD1mxxx11kayD1yaofD33a3Fa333aaayiDfff1mZm11yypaayaqojptoopooookjiiiobrDOoijyptpbA1IYYYZZllYYbZbAfffrjfbAoofAfDIZZZbfbbfZAbxbIlImmIxZZfrfAJoopoyaauDfZIbYbfEforAZrfffjpfmmZIZZffbIbZJxbf1optDtfboptotf1D1pfAJobtmIlIlYIbfmSYYIIf1frAptDp1DqDo1ZIlpD1mxxx11kayD1yaofD33a3Fa3RRRRRRRRRR",
"OOOOOOOOOOooqyaaaaaauhmZbWWWWWWNWWNWNzWVNVWKNWWWNWWNzWWWNWWWWNWNWKzzNKWzWNWzNKWNzWWWWWWWWWNWWNzWWKWKWNWKWNNWKzWNKWWWWKWNWWKNzKWWNWWWWWWNNWXKKNNWNNNVWWWNXWNVNWVWVWNWVW0WVNVNVWNVWNWWN0NNVWVNVVNVNVN0VVWVVNNN0NV0NVXNVXNWWNVVNVVNBVWVWNVWVNVVNNBWWVVVWVVWVVNWVBVWVVVVVWVWVNVCWVVWVV444444fmmbbZbAArrfbZbfZrfffpoJbJo1ppq11foff11ZfZYYxIIZl1mxbZZxZAforEkDEEtjpftmfkt1mtxmOyhkDkmkyaDiy3333a3aaaaaaaa1ffmlYIOfripEaaaykjqpppyyqqjy1tPaajoyrbfpEyiEoZbxZlbbZlIbbZAfffAbfAjbffopAboAbbbbbofAZbAbZIZIlxflYIIfoooqyaaaaaauhmZbbwropopooff1mf1qfmmbbZbAArrfbZbfZrfffpoJbJo1ppq11foff11ZfZYYxIIZl1mxbZZxZAforEkDEEtjpftmfkt1mtxmOyhkDkmkyaDiy3333a3aRRRRRRRRRR",
"OOOOOOOOOOa333aaaaaakobDpWWWKKWKWKKKWKWKKKKKKKKKKKKKKKKKKKKKKKKKkKKckKkckkKHkKkKKkKkkkKkKkKKkKKKkKkKkkKkKkKKkkKkKkKkKKKKkKKKKKKKKkKKKKKKKKKKKWHcKKKKKKKWKKWKKWKKKWWKKWWWKWWWKWWKWWWWWWWWWWNKWNWWWWVNWWWNWWVNXWKXNNNWWXNNVWWWVNWWWWNNVWNWWNWWVNWVNWWWNWWNWWVNVWVNWNWNWNWNWWWWVNWVNV444444pmfOAfrbfbZb1ffbrZmAIbrtpEoJ1ftp1ffJfZfftlf1xIIZ1yypotmO1roDpkkOpD1111mfOfkfEammrkk1V11Zfmkyy3aaaaykyayyjtptZbbIYZbooomDDyyaaaqaykDkmfmZAt1t1oxfAxDEqiyjjot1bbmZZZfmfAZbbZbfpEf1ZppmfDobbZArbfp1flbbxfZlZfmbYIZfka333aaaaaakobDpfpp1ZDmfm11fffbfpmfOAfrbfbZb1ffbrZmAIbrtpEoJ1ftp1ffJfZfftlf1xIIZ1yypotmO1roDpkkOpD1111mfOfkfEammrkk1V11Zfmkyy3aaaaykRRRRRRRRRR",
"OOOOOOOOOO3a33aqyDhkArAD1WKWKWKKKKKWKKKKKKKKKKkKKKkKKkKkKkKkKkkkKkkHKkkHkkkHMkkkkkkKkKkKkkKKkkkKkKkKkKkKkKkKkKkKKkKkKkkKKkKkKkKKKKKKKKKKKKKKKkccKKKKWKKKKKKKWKKWKKKWKWKNKKWKNKWKWKWKWWWNNWWNNWKNWNWWNWNWNWNNzNNXKNWNNXNNXNNNNWNWNNWWWWWWNWWNWWVWNVNNVWNVWNWWNNWVNWVWNVWVWNVNWVNVNV4444441OxfJofbfbZboffbZZZfxZAZoD1orf1ptbfmAbrfoZxxIb1fIOmfo1xm1b1O1kDkO1mfkfxfftjyyaIffDkOmmxxZ1paaaaayyykkyyhtptDZblZlYZAtpflfDiyaaaaayjt1f1fIxp1JpoboJop1jiEEo11IZAmfmfZbxZZZbZ11pDmboporp1ZxAffZAtDmxZZxllIYppflImma3a33aqyDhkArAD1tfo1bZbrtfxbAbAf1OxfJofbfbZboffbZZZfxZAZoD1orf1ptbfmAbrfoZxxIb1fIOmfo1xm1b1O1kDkO1mfkfxfftjyyaIffDkOmmxxZ1paaaaayyykRRRRRRRRRR",
"OOOOOOOOOOauuaDpooEpbtkbrNKKKKKKKWKKKHKKKKWKkKKkKkKKHKKKKKkKkKKkxdzMzMzzzHzHdzHHzddddnddddddddzdddddddnddddHdzWkKkKkkKKxdHHHzMHdHHdMddddHd#dHHX#MdMdMHMH#MHHMNWKKWKKNKcKWNKNWKKNWKWKWzWNWKNWWNWWNWNzNWNWWNKWVzzzXNzNXNNN#XNNNVNWXVWNNNNWNWNVNVXNWNWWWNWWNWVNNXVWWVNWWVNWVNW0NWVNVN444444bf1xAtJfmZbbAbbmfbbbfZfbbrr1fffrfbfrbxZffbm1ZIfmlbfrfftfIIxOkOk1mmfmmxxxm1iaPf11kkDmmfZfmmtayyaa1qt1maEpp1jyf1bIbIbbfporxEyayyyaayiipptf1fippyioAoooo1oppyEfAfZxAffbZbZbbrffoooff11AfoofZbZArZfmxflZZbIIIpypZlbOuauuaDpooEpbtkbrEo11IbtD1t1fZJZfbf1xAtJfmZbbAbbmfbbbfZfbbrr1fffrfbfrbxZffbm1ZIfmlbfrfftfIIxOkOk1mmfmmxxxm1iaPf11kkDmmfZfmmtayyaa1qt1RRRRRRRRRR",
"OOOOOOOOOOOaayrJrorA1roJEWWKKKWKKkKKKKKKKKKKKKKKkKKkKkKKKkKKKkKkdzcssssscsccsscscssccscccsccsccscscscczccccs#0LNKkkKkKkdzzzzzzzzz#zz#z#z#z#z#z#z##X#z#####00BSWKWKKWKNWKNKWKNWKKWNKNKWKKNNWKWKNWWWNNNNNWNWXNKN#KNNNzNWXNNz0NNNNNNWNNWWNWNVWWNWVWVNWNVWNNWVNWWNNWNWWVNWWVWVNVNNNVNV444444bZbmm11offrffqjAbfZbAbAomt1foJZJAboofrbJbbfmfbfffIbofZZYYxmbZfmff1l11mmf11oijDtkakO1xmZffmfDfmfftjEyiyppmf1frIZmbbbbtrf1o1iIDaEijyyyyDbfZfayOfroApppyypiiiyyttffZbfxbffZrbfZfo1op1AbDffoff1fofAobZfbbIZYIDrfbAZrfOaayrJrorA1roJEmfrJmmmSZbmf1ZfbbZbmm11offrffqjAbfZbAbAomt1foJZJAboofrbJbbfmfbfffIbofZZYYxmbZfmff1l11mmf11oijDtkakO1xmZffmfDfmfftjEyRRRRRRRRRR",
"OOOOOOOOOO1ijpEo1rrfffrjjWKKKKKKKWKKKKKKKKKKkKkKkKkKkKKkkKKkKKkKHwxxxxJJxJxJJxJJxxxJxxJxxxxxxwxJxwIwJwwwwwwwcBLCxkKKkkKHsIIdddddddddddHddHdHHHHHHHHHHHHsHHzggHWKKKNKKKKNKNWKKNKNWKKWKWNWNWWNNKWNNNNWKWWNNzzNKNNzz0zNNNNNNXzNVNWWNNWNWNWNWWWNVVNWNWVNWVNWWNWVNVWNNVNWWVNWNWNNWVWNVN444444Zbrfxfofroff11p1fmAbfAttm1offrotAf11fbfbAbSltbArYZYfIfndIZfAZm1fmmfmxmm11DoDoDka3O1Dfmf1xx111bf1DqjEqyqpoottprfbfAxfDffftoypoayyiaaayyj1ff1rAZboot1EiyiiEEiiyypfbZAxfffbZbAbfAEjptAAtAfo1o111Afrbb1xZbZfprbIoAYrr1ijpEo1rrfffrjj1t11rZZxVoffxbZbZbrfxfofroff11p1fmAbfAttm1offrotAf11fbfbAbSltbArYZYfIfndIZfAZm1fmmfmxmm11DoDoDka3O1Dfmf1xx111bf1DqjERRRRRRRRRR",
"OOOOOOOOOOopoiooooo1roJDmNKWKKKKKKKKKHKKkKKKKKKkKKKKHkkKkKkKkKkxvxJtkqtEqqtEtqEEEEEttttEtttttEtttttttttttwwIsLLTCSKkkKtzdddxtxJxxJwxxwxwxwIJwIwwIwwwIIdssHzgLCKKWKKKKKzKKKNKNWKKKNWKNzWNWNKWWWNWNWKXWNNKWzzWNNNNKNXNNNzNN##WWNNVXNWWNNNVWNWNWNXWNVWNWNNVNNWNWXVWVWNVNWWVWNV0VNNNNV444444rff1mmfbfoo1ofoffbt11tD1Afffbft1f1foZffbtyIblIIxYlYxmxYYllxtxxmmfmmAtmxxtp1oDyu3aOkkf1oOlIDffooD1tqpEpEqjptt1o1rZbZZm1fAOmb3a3yyayajayimxofrZrZffpEEpiyyippyiqipfrZAffAfxAZZfriDt1JfAZAof1oA1rAf1JfZbxtijAbZxbUrJopoiooooo1roJDmto1mflbZZmfmlDffrff1mmfbfoo1ofoffbt11tD1Afffbft1f1foZffbtyIblIIxYlYxmxYYllxtxxmmfmmAtmxxtp1oDyu3aOkkf1oOlIDffooD1tqpRRRRRRRRRR",
"OOOOOOOOOOoiyyyEEpppijD1mWKKKKWKKKKKKKKKKKKkKKKKKkKkkKKkKkkKKKkSsJtqqqqqqqqqqqqqqqqqqqqqqqqqqqtqEqqEEEEttdII#LLLCCSkKkS#ddxttttttttJJJJJJJJJxJxxxxxxxwHHHHvBLLSWKKNKNWKKKWKNKKWNWKWKKNKWNNNNKNKWKNNWNKNNzz#NzNNKNNKNkNz#kz#zNNNNNVWNWVNWNNVWVWNNWWNWNWNWWVNWNNWNWNWWNNVNWNWNNVNNVV4444441t1ffbtmAAfffZf1y1xAJxfJbfffAfAo1o11obAfAbmm11bIlYx1mZIZlxlxf1fZmm1mxIfmDDjpia3a1flx1tjmfZZZbaay1111pqjEjyjob1t1mffox1xmDtfa33aaayiyiDyyptofZlfffm1Eppopj1AAiEqiiiofbf1ftE1jDjoEijEjffoAfofo1ooA1mbj1AfpoZIZYxrp1oiyyyEEpppijD1m1ImfIZZIbflZIbAb1t1ffbtmAAfffZf1y1xAJxfJbfffAfAo1o11obAfAbmm11bIlYx1mZIZlxlxf1fZmm1mxIfmDDjpia3a1flx1tjmfZZZbaay1111RRRRRRRRRR",
"OOOOOOOOOOoyOxDDjpiyffmf1WKKKKKKKKKKWkKkKKKKKkKkKKkKKkkkKkkKkkkddxxtttEkqqqqqqqqqqqqqqqqqqqqqqqqqqtttxJJwJIdvLCCCLTckKIcIdwwwwJJtttttJxJxJxJxJxxwwddddHHssLLTLHKKNKKKKKKNKNNKWNKNWKNNKNKWNKWWNNNKWWNNKNK##zzzNNzNNNzNN#z#z#zzNNNWNNVNNNWWVNNWNWWNNVNNWNNWWNVNNWWVWNVWVNNVNVNNNNVNN444444ftoZff1rZbfZffb1ffrtAfZbrffrxfZJobfoffotooZmbZbbxZbmZxmxbflIDo1fm1kDZlllOt1iEqaaDlYYpt1ffbIZIaaaEptDtqEyqyjtb1ODmfAfbtmx1mm1a3aaaaiaiyjqjpffbIIfxltppooopfxbtiijyyEoo1tDpiip1pEEiqyEfoffff1ooofAf1pbbbopAbbZZbA11oyOxDDjpiyffmf1JxZYbffbfflxffffftoZff1rZbfZffb1ffrtAfZbrffrxfZJobfoffotooZmbZbbxZbmZxmxbflIDo1fm1kDZlllOt1iEqaaDlYYpt1ffbIZIaaaEptDRRRRRRRRRR",
"OOOOOOOOOOoyZZf1fyyotffmfWcKKcKKcKKcKHKKHKKHkWHKkHKkMKkKkHKkMKK#IJtxJJJJJEqqqqqqqqqqqqqqqqqqqqtJJwwdwJwJIwJdvTCBCLC0NkzsddddddddHwJttJJJJxJJxwdHsHHsHHsHHsgLLCXKWcKWKKzWKzKKzKNzKWzNKzKzWKXWNzKNzKNzWNz#z#zzzkNzNzzzzz#z#NzzNzNN0NN0WWXNNXNW0VXNNXWWXNVXWNXWNXN0NW0NW0VN0VN0WV0WNV444444fxA1ff1ofAfZbbZfrZfpffrfxmbZrfoffbf1ooErofSmYxxA1ffxbfxZZllI1tpmf1k1flbxtppEppuytbIYmf1ffffopyyyyyyaaytypayobfttmltmfpfomZxfq3ayaajiyayiEpZlZlYIbmppooo1orAffojqqayEtp1pEiymfooipDp1f1tffAfo1AffpiobAZpobrIZbbfmooyZZf1fyyotffmfxfmIbf111tbImmZffxA1ff1ofAfZbbZfrZfpffrfxmbZrfoffbf1ooErofSmYxxA1ffxbfxZZllI1tpmf1k1flbxtppEppuytbIYmf1ffffopyyyyyyaRRRRRRRRRR",
"OOOOOOOOOOpOfZfffZfpxffbIWKKKKKKKKKKKKKKKKKKKKkKKKkKkkKkKKkKkKx#HwwJJxtJJttqqqqqqqqqqqqqqqqqktwxJJxJJJJwwdds#LCCCCLcKNzsHHHdddddddwtttJJJJJdsHHHHHHHsssss#gLTLSNKKWKKWKNKKKNKKKNWKWKWKNKNWKNNNNWNWWKNNzz###zzN#zzzz###N###zNNXWNNWVWxWNVNWNVWNNVWNNNVWNWNVWWVNVVNWNWNWNNNNNNNNWNVx444444xIbbAbOmfAbbbxZrfAZZffo1rIYbZbffbrfAfoo1AIYbbrfxZbfZmfmZ1fxZxfm1m1Z1ffmfpiptpEtj1bAfbbbEjpiE1iyyqyayyajyDyyqf1f1xtfZfAtOxIlffaaaaaayayyiqEZfZZIZfotffoofoZrZbAtptDyaipEpppjop1tpjD1xxfffmAxAffoorfrlZoZbIbbbbJ1popOfZfffZfpxffbIlxlImxxbbbmf11tfxIbbAbOmfAbbbxZrfAZZffo1rIYbZbffbrfAfoo1AIYbbrfxZbfZmfmZ1fxZxfm1m1Z1ffmfpiptpEtj1bAfbbbEjpiE1iyyqyayRRRRRRRRRR",
"OOOOOOOOOOyhbllZlx11ffflIWKKKKKKKKKKKHKkKKkKkKKkKKkKMkKKkKkKkKxzs#s##s#HJJtqqqqqqqqqqqqqqqqqqxJxJJIddHs####s#LCCCLCnKxzz#######dddJttxJxJxdHdddHHss###s##z#LLCxWKWKKKWzKKKNWKNWWKKNNNzKWNKNWWNKNKWNzNKNz##z#zk#z#zz###kz#z#NNXNNXNNWNVNNWVWNNVXWNVWWNWWVNWNNWXNNWVNNVNNVWWV0NVNWVV444444ZZbbffmmxbffbfrbZxbxbffbfZJIIZrArfoowf1fbJxfrJmffotffZffxZmlmSZD1fxfmmmxfyipip1pmrroopijiEjqaqyyyyaaaapqOpqytDpfApbfbtOx1tfDoFa3aiaaiayyiqpooZZbDp1boo1fffbZZZAE1oyyyjp1ppEpEpoopjffZZrZbfZxropofArlrpfxbbrrrroooyhbllZlx11ffflIblZxZm1off1fAmofZZbbffmmxbffbfrbZxbxbffbfZJIIZrArfoowf1fbJxfrJmffotffZffxZmlmSZD1fxfmmmxfyipip1pmrroopijiEjqaqyyyyaaRRRRRRRRRR",
"OOOOOOOOOOhmxIYlbff1llxZfWKKKKKKKKKKKkKkKKKkKkKkKKkKKkKkKkKKkkkkNS0LLLL0#HttEqqqqqqqqqqqqqqqqExxJH#z#0gLLLLLLLLCBLLxkkksLLgLLL#ddJtJttJwHdHddHs#s#LLLLLgLLLLCMWKKKKKNKKKKKKNWKWNKNNKNNNWKNNNNWNNKWNKNNKzkzzz#N#z##z###zzzzXNNNXKNNNVNNVNWNVNNNWVNWWVNNWNWNWVNNWWWNVNNWWNNVNNWNVWNN444444bbfbAffml1fbbbfffxbAZ1rfrfoZbYft11ffbfObbJymJbrJfoDfxb1Omm1ffZxk1fffxZIlfyaiiypopiipEqjtjpEqypqqqqyyaOmtympyop11oqt1fDZlmmkqa3a3ayyaaaaiayipiijEopo11pffZffrZbZpooayiiEpttEppEoppipfffxZrfAAfpoAZbfAo1IbborrpptEqhmxIYlbff1llxZf1mxxrt11f11fff1AbbfbAffml1fbbbfffxbAZ1rfrfoZbYft11ffbfObbJymJbrJfoDfxb1Omm1ffZxk1fffxZIlfyaiiypopiipEqjtjpEqypqqqqyyRRRRRRRRRR",
"OOOOOOOOOOoofZImxmmlfff1tWKWKKKKKkKKKHKKKKkKKkKKkKKkMkkkKkKkkkkkkKdSzLgLgzdJtqqqqqqqqqqqqqqqqqdxxdggLLLLLLLLLBLBLCLNkkKkcBBggg#dxJtttJwHdddds###vLLLLBLLLLLBCSKKKKWKKKzKNKNKKNKKWKKNKzKNWNWWNKNWNNWzWNNzzzzzzz##z##z###zWNzNNKNXXNNKNWNWWNNVWVXWWWNNWNNWVWNVNXxNVWNWNNNVWWN0WNNNVV444444frfffbZxmfolAZffffZbfffoff1o1tSZr1pIfmfp11op1xmffmfZ1fmxZxmfmmmfmEqDfmxmpkuyaa1ttyxtDEjf11iqqqyyaayayplthmofiipyaixtEffDlxxlma333aayyayiyyjppZt1pp1ft1ZxfoZZffZAopyiipEi1ptEpoEEppEEffofmfrffofAfAoZbZfbphjoop1ffoofZImxmmlfff1tmxbbm1t1mo1DfxZffrfffbZxmfolAZffffZbfffoff1o1tSZr1pIfmfp11op1xmffmfZ1fmxZxmfmmmfmEqDfmxmpkuyaa1ttyxtDEjf11iqqqyyaayaRRRRRRRRRR",
"OOOOOOOOOOxxmxIZYmZZZf1ffWKKKKKKKKKKKKKkKKKkKKkKkKkkkKKKkKkkKKKkkHkkHNdLLz#JtqqqqqqqqqqqqqqqqqtxxJgvTTCCLBLLBLLLBTckkKkkkSLLg#zwtttttwddddds#z#gLLBLLLLLgLLLCVKWKKKKKKKNKNKNWKKKKNWKKWNWNWNWNNWNWNNWNKzkNNzNNzzz#####zzzNWNWNKNNXKNNVNNNNVWWNWNNNWNWWVNWNNWNNWVWWNVWVNVWWNNWNNWVNN444444tfJffbfAxfZfJffbfoflf1ff1fop1fASftooZZbAfAtOxxZbDfffmfxxmZlbZZtDiyEpyDp1kuj1iyyyma1fOqaODmaayyiiiaaayymO1mmfaitahtJq1ZxZIZx11y333aaayyypyypoEojipEp1pDIbfffbfffbfoOyiyEipppipt1tEEjjfo1oofftD1ffrp1rZb1rpbrrp1oomxxmxIZYmZZZf1ffrmfo111fotfOkbZftfJffbfAxfZfJffbfoflf1ff1fop1fASftooZZbAfAtOxxZbDfffmfxxmZlbZZtDiyEpyDp1kuj1iyyyma1fOqaODmaayyiiiaaaRRRRRRRRRR",
"OOOOOOOOOOZAoZmZImx1rffZZWKKKKKKKKKKKKKKKKKKkKKkKkKKKkKKkkKkkkKkkHkkMkkHSL#dxtqqqqqqqqqqqqqqqqEwJx#gLTCCCCLLLggLLLMKkkKkKkSg#zdtttttwdddHds##gLLLLLBLBLLLgLLzNKKKKKKKNKKWKNKKWKNKNKNKNKWNKNWKNKNWKWNNNzNNkzNNkN#zzzzzzWNWNNWNNNNzNNNNNWNVNNNWWNVWNWNNNWWNVWNNVNNNWNNVWWNVWWVNNNVWV44444411fbffofZf1ofIZfftfZffbbropof1Abxop1tf1f1fDmZxmxppppp1ZZxpfZmp1mDiyyaq11ayktj1OxmaDpaaaaayiyiyjEaaaaaaD11xxZyipayEyhfbtODfZDkD333aaaijapiiiEppjiEpppoEfffooAfAxAfopyyyiEiEjD1pDppyEiffm11ff1ofAroofAfmoJprtOo1p1mZAoZmZImx1rffZZx1offAZAr1fIpbbo11fbffofZf1ofIZfftfZffbbropof1Abxop1tf1f1fDmZxmxppppp1ZZxpfZmp1mDiyyaq11ayktj1OxmaDpaaaaayiyiyjEaaaaRRRRRRRRRR",
"OOOOOOOOOODo1pfkDffofmffAWKKKKKKKKKKKHKkKKKKkKkKkKKkHKkkKkkkKKkkkdHMkkkHkkI#ttqqqqqqqqqqqqqqqqqJxxI00TTTCCLBczSxNKKkKkkkKkkS#Hwttttxddddds##vLLLLLLLzMSScxNNNWKKKKKKKWcKNNKNNKWKKKWKNzWKNWWNWNWNNNNzKKzNKVzNNNNzKNzNNzNNNNNNWNNNXXNNWNVNWWWNNVzNWVNWWVNNWWNVNXVVNWWVWWWVNVN0NWNWVN444444flb1bfZbom1tofbAt1Jt11tt1D1o1footoooZZllfjZZbffEiyypjiipppEpo1p1oDyiiayj1p1lIo1mbymfftEyyaa1yaaayyayyyayyytDDy3btiODott11momIma3jaaaioiyayppppEpbo11oo1o1o1op1fo1ZppoiiyiiyEtptEqEi1p11o11jpmfooffffoiD1rfroptoopDo1pfkDffofmffAfoAbmffAffbZrfffflb1bfZbom1tofbAt1Jt11tt1D1o1footoooZZllfjZZbffEiyypjiipppEpo1p1oDyiiayj1p1lIo1mbymfftEyyaa1yaaayyayRRRRRRRRRR",
"OOOOOOOOOODo1mo11t11J1frfWKKKKKKKKKKKkKKKkKKKkKKkKkKkKkKktKkKkKkkHkHkkkdkkNzIttqqqqqqqqqqqqqqqqtxxJg0CTCCTcKkkkkKkkKkkkkkkS#Hdxtttxddddds##vLLLLBLcSWKkWKKKKWKKKKWKWKKKWKKWKKKKNKWKWKNWWKNWNKNWKNWKNWNzNNzWWNKNzNNzNNzNKNNNzNNNNNzWNNVWNNNNNVNVWWNWNWWWNWNVWNVNWNVWWNVNWWNVNNVWVNV444444fZI11DffZfO11o1opEpDpftpffoomftptttpxSbbbffxoiEiiii1Epoppoppfpp1mtaypyitEpfIZfxmDfxIZx11ty33a1DyyyaaayaDmaitiDaZtybot1aOrr1OlxD3aaaaqjjiyyppoEpfofoootofff1m1oA1tpptpEiiijytjEEjDEji11111pp11oo1o1o1EpOxfoooEE11tDo1mo11t11J1frffZbxrfArfbbbfAZbfZI11DffZfO11o1opEpDpftpffoomftptttpxSbbbffxoiEiiii1Epoppoppfpp1mtaypyitEpfIZfxmDfxIZx11ty33a1DyyyaaRRRRRRRRRR",
"OOOOOOOOOOp1fA1tt1ffArZmxWWKKWKKKkKKKKKkKKKkKkKkKkKkKKkkkKKkkKkkHkkdkkkdkkks#ttqqqqqqqqqqqqqqqqqdxxHvgTGCTTKkkkKkkKkkkKkKxHsIwtttxddddds##vLLBLLLBKKKKKKKKKKKKKKKKKKKNKKNKNKKWNKWKKKKWKKNKNKWNKNWNNKNNzKNzKNKNNzKNzkNzNNNWNXNNNNNWXNNNNVWNNWNNWNNWWNWNWVWNWWNNVVNWNWVWNNVNWWNWNVNV444444bfZbm11DmrmOoDyEDp1off1torxbooEDDD1xIlZZfZ1piEipij1opbZo1DtoiiptDOapiEiiiy1Ixyxm1fAYZZfmmfa3aaaaaaa333aayaayfxayttff1ffxxxZYImIaaayD1AoyayEoopotoZopo111ofo1o1f1EpjpoiEpayiDiDDEiijityt1pqp1p1t1mo1opyfoooopoppjop1fA1tt1ffArZmxZffmrffrfAxZZbIZbfZbm11DmrmOoDyEDp1off1torxbooEDDD1xIlZZfZ1piEipij1opbZo1DtoiiptDOapiEiiiy1Ixyxm1fAYZZfmmfa3aaaaaaa3RRRRRRRRRR",
"OOOOOOOOOOf1otjpDoAo1ffIbWkWKKKKKKKkKHkKKkKKKKkKkKkkMkKKKkkKkkkkHkHHkkkdkkkH#JtEqqqqqqqqqqqqqqqqtxxwg0QQTTTSKdKkkkkkKkkkNHcdxtttJddddds##gLBCBLLcxkKkKKKcKKKKKKKKKKKKKcWKKNNKWKKKWWKWzNNNKWNKWNKNKNzN#KNNzNNNNNzNNzNNzNNNNNNzNWNXKzVNNWWWNNNVWXWNNWNNWNWNWNWWXWWNWNNWNWWNWN0KVNWWN444444fbbfAfAxp1mmofotpoAff1moAfZf1qxtktflZxftyi1fOkpDptDff11tjopqyifyyykjyyyyy1tmIZfxmxZfZxft1ffmtyaaaqyiaaaa33a3yaaaaotffDj1fZIm1kZItayo1pppiapoooo1rbE1fZmf1jpADfAottijpiyyiiiyyiyaaiiiyjj1pEDjp11pyayijpjptjDDqtpt1f1otjpDoAo1ffIbImmfAAbxfotpoAbffbbfAfAxp1mmofotpoAff1moAfZf1qxtktflZxftyi1fOkpDptDff11tjopqyifyyykjyyyyy1tmIZfxmxZfZxft1ffmtyaaaqyiRRRRRRRRRR",
"OOOOOOOOOOp1ooyo1foAAfZIbWKKKKKKKKKKkKKKkKKkkKkKkKkKkkKkkKkKkKkkHkkMkkkHkkkksHJtqqqqqqqqqqqqqqqqEJxxgvCTCTCckkkkkkkkkKkKI#dwJttxddddds##gLLLBLL0NKKKKKkKKKKKKKKKKKKKKKKKKKWKKKKWKKKNNKKKNKNKNWKNWNWWKzKNNzWWNNKzNNzNKzNKNNWKzNWNNNNzNNWNNNWNWNWVNWVNWNWWVNWVNWNNVWNVWWNWVNNWNNWVNV444444AfbmbZZIZODho1rpfftoofmomfxmmffmm1mZZffiyjDt1Om1mOkkO11Opkjia1ZaaaEyaiiytp1Zx1bo1DIZbffOff11maqjyjqy1maaaa33ayaaajk1ttfAmlllmOllbaiEpiiopaip11oo1ot1ff11fppopooppjppppEyjpiojaaayjjpiiDoppjjEppEpiy1fpp11ooo1tpoop1ooyo1foAAfZIbbmm1rfZZfZo1prbbAfbmbZZIZODho1rpfftoofmomfxmmffmm1mZZffiyjDt1Om1mOkkO11Opkjia1ZaaaEyaiiytp1Zx1bo1DIZbffOff11maqjyjqyRRRRRRRRRR",
"OOOOOOOOOOy1AoD1JAbfJArbJWKKKkKKKkKKKKkkKKkKKKkKkKkKKkkkKkkkkKkHkkMkkkkdkkkkH#xtEqqqqqqqqqqqqqqqqwxxdv0TTe2TVkkkkkkkkkKIzHdttttddddds##gLLLLLL#cKKKKkKKKKKKkKKKKKKKKWKNKKNKKKNKNWKNKWNNWKWKWNKWNKWWNKzKNNzNWNKNzWNzKNNzWNNWWzWNNKNNWXNNNVWNNNWNWWNWWNNWNNVNWNVNNWNWWNNVWNNWNNNVWNV444444rbrZbZbbx1rotAJffJpo1tOffmxxbZpmYxfZfpijjyto1Dt1ftk1O11tqjiyypIDyyiyyyoiEt1fyytytqqyoyDDmtDlxtjiyqaqkDaa3a3aa1y3aa1tpo1omxbIllZIYaajjyjoEyy11p1ofopmfo1jEoEqoAbpiippEitpoyaipppDppo1jiy1ottDpjEEpiO1o1p1fJooooEtyy1AoD1JAbfJArbJfxomfAbbbbftjfZbrbrZbZbbx1rotAJffJpo1tOffmxxbZpmYxfZfpijjyto1Dt1ftk1O11tqjiyypIDyyiyyyoiEt1fyytytqqyoyDDmtDlxtjiyqaqRRRRRRRRRR",
"OOOOOOOOOOjfoqo1Obfrp1fffVHKWHKKHKKHkHKKHkKHKkHkKMkKHkKkKdkKHkkHkkdkkdkdHHdkdzdttqqqqqqqqqqqqqqqqtxxIv0CTeCTSHkkHkkHkkHzHdJtttJdddds##gLLLLLLzHHcKcKKcKkcKKcKKcKKcKKNWcKKcKWzKNcKKzNKzKzNKzKWzKWzNNzKzzWKzKWzNWzNW#NNzXNzWNNNzNNzWVz#KXWWXNNXWXWVXNVXNVXNVXNNXVXNV0NVXWNXNN0NV0WVN444444ZbfoxrfZbxfEoEDffZbfo1f1Dk1DyDj1jyiEp111pq1m11m1yDytffbftyiyiyiyDjppiayEaiiEEi1tyipESff1ffDb1Zfm11qDyyqjyayDayayaatt11AZo1xbfIlIl3yiyipo1Ei1tjEto1111piiEyEyEEioo1ijO1p1aPtoDiyiyyjEEjjjjiqjjtDoyjtD1ooooooEpppiqjfoqo1Obfrp1ffff1ffIfbbbZf11rbrZbfoxrfZbxfEoEDffZbfo1f1Dk1DyDj1jyiEp111pq1m11m1yDytffbftyiyiyiyDjppiayEaiiEEi1tyipESff1ffDb1Zfm11qDRRRRRRRRRR",
"OOOOOOOOOO1tpypfrfffO1ofAWWKKKKKKkWKKKkKKKKkKKkKkkKkKkKKkKKkkKkdkkHkkkkMkdkkdx#ttqqqqqqqqqqqqqqqqqwxxH#LTT.CTkkkkkkkkxcHwxtttJwddds#vgLLBLLLdNHHKKkKKKKKKKKKKKKKKWKKkKNKKKKKKWKWKNKWKNNWNNKNKNWKWNWNzKKKzNKVWNNzNNKzNNzNNWNNKzNNNWWNNzNNWWNNWVNNWNVWNNVWNWVWVNNVWWVWWWNNNNNNWWWVKV444444Zxft1Zpffft1otEmmbZx1OtkOttmpOyiyyjif1o1m1OOx1kDjtyOf11jqEyiEyiqjjjEaaajjEiEitD1y1tiZxmmbIxbZmZfmtttyaaaatOyayy1myamfobbmxZfklIIbyaiaiEAAoipDf1E1t1Ef1pEppjtoootpojpto1ohff1pyyayjppDtpyyaaytopoyypjt1oopoojpoEjD1tpypfrfffO1ofAooAbfAfbYboo1fZfZxft1Zpffft1otEmmbZx1OtkOttmpOyiyyjif1o1m1OOx1kDjtyOf11jqEyiEyiqjjjEaaajjEiEitD1y1tiZxmmbIxbZmZfmtttRRRRRRRRRR",
"OOOOOOOOOOEyyij1tfo1oo1fpWKKKKKKKKKKKkKkkKkKKkKkKKkKkKkkKkkkkkkHkkMkkkkdkdkkdNzIttqqqqqqqqqqqqqqqqJxxdv0TTQTCkkkkkKkNHsdxttttdddds##gLBLCLLMKKHckKkKkKKKKKkKKKKKKKKKNKKNKKKNKKKNWKNKNKKKWKWNKNNKNWKNzNWNzKWWKNNzKNKzNNzWNWNKNzNNWWNNNzNWNVNWNNNWNNWNNWWVNWNNWNWNWNWNVNNNNVNWNNWWVV444444bbZo1bofAr1oJ1ofbAmk1mOmxmOxf1yiiijp1ppfxffOtkDpyjqf1DqqyayyEqyDiqEaaaayiiyipDj1j11tOftk1ZYxftImI1p1jyaaatyaaayfxyaDtffZAbZZffbZZyaaiEjfr1yyitJtjEpjo1pEooojpoJpAo1o1ooo1fffEj1DOiEtjEjyt1aaajEipyyDpDptDpqjiyDEpEyyij1tfo1oo1fpppfAff1ZJfblb1ffbbZo1bofAr1oJ1ofbAmk1mOmxmOxf1yiiijp1ppfxffOtkDpyjqf1DqqyayyEqyDiqEaaaayiiyipDj1j11tOftk1ZYxftImI1p1RRRRRRRRRR",
"OOOOOOOOOOtyyyitDof1oAo1pWKKKKKKkKKkKHKKKKkKkKkKkkKkHkKkKKkKkkHkkkHkkkkHkdkkdkI#ttqqqqqqqqqqqqqqqqEJxxgvCCCTCdkkkKkKHcdJttttdddds##LLLLLBCzKkkHHKkKKKKkKcKKKKKKKKKKKKKcKNKKKKWNKNKNKKzNNNKNWNNWNWNNzzKNKzNNWNKNzNNzzKWzNNWNNNKzNXNWNNNzNNNWNWNXNVNNWVNNWNNWVNXVNNVWNNWNVWNW0VNNNWV444444ffbfffppproofpokmlm1fmxtmmfDEjD1jD1offOZffft1tpxtykyDypqyjiyijqyqyyDEaaayyypiofff1OqaajhmxZSYbxfYtmyaaaaaaahmtaDjyyyiiooqoODrfmfmEaypo1orppEypppjppjiyto1pjtptp1ffffo1Ep1tDh1o1t1o1D1DjEDDDfopyihDjaijEDpqyyyijDktyyyitDof1oAo1pofo1m11kmffoorfoffbfffppproofpokmlm1fmxtmmfDEjD1jD1offOZffft1tpxtykyDypqyjiyijqyqyyDEaaayyypiofff1OqaajhmxZSYbxfYtmyRRRRRRRRRR",
"OOOOOOOOOOjyiyyypoopptp1oWKKKKKKKKKKKkKkKkKkKkKkKKkKkKkKkkkkkkdkkdkkkkkdkdkkdkNzxtEqqqqqqqqqqqqqqqqwxxdg0CTQTVkkkkKI#dwttttwddds##gLLLLLLIKkKKHckKkKKKKKKKKKKKKKKKKNKKWKKKKNNKKKKKKNKNKKWKWKNNKNNWKNzNNKzNWWNNNzKNWzNNzNNNWNNNzNNWNNNNzNNNNWVVWNKVNNWWWNWVNNWNNNWWVNWNWNVNWNWNWNNV444444ofAoofo1ooppoptmbIpp1fmm1DEppttpqpp1ZxxmllfkODfmaOOpDqjyiptijEijyyyppaaayjiEj1t11fmtqytyqOfpDOZt1ob3aaa3a33ajaaipiyDaajoa1fa1fmmOyaaotooojiEjooyo1jpyyDooqofoppAbffff1ppDp1fof111tffp11DjkjpjEEyy1xDayEtjDtiEDhtjjyiyyypoopptp1ooofoffo1mxfofffAofAoofo1ooppoptmbIpp1fmm1DEppttpqpp1ZxxmllfkODfmaOOpDqjyiptijEijyyyppaaayjiEj1t11fmtqytyqOfpDOZt1ob3RRRRRRRRRR",
"OOOOOOOOOOEiDjqyyjjpqhpo1WKKKKKKKKKKKkKKKkKKkKKkkKkkKkkkKkKkkkHkkHkkkkkdkdkkkdksHttqqqqqqqqqqqqqqqqtJxJg0TTQQSKkKkx#dwttttwwdwd##LLLLLLLnWKKkkcHKKKKkKKKkKKKKKKKKNKKKKKNKKKKKKNNKNKKNKNNWNNKNWNWKKNzKWNNzNNWNNkzNNNzNNNzWNVNWNNzWNWNNNNXWNNWNWNVWNWWNNNVNWNVNNVNVWNWNVVNNNVNNVWNVN4444441foZro111ppptppoAI1mftODDyy1tyqDDqp1m1fxbIbZmhmqyyfDqyDiyqjppDjyyjpopyaaayyaaDDDmtDt1yDiyyDDpkmfaqtayaa1laayqaaapmpyiaaiapoDtffEDiiyipootpyiippaoEiyipEEpy1opAbfAbAZfEi1ffffAbtfffoo1ppfo1o1tjiyEiEyDyyiptpED1EpjEiDjqyyjjpqhpo11ottofmmfffffofo1foZro111ppptppoAI1mftODDyy1tyqDDqp1m1fxbIbZmhmqyyfDqyDiyqjppDjyyjpopyaaayyaaDDDmtDt1yDiyyDDpkmfaqtaRRRRRRRRRR",
"OOOOOOOOOOijiyypiEEtptEf1WKKKKKKkKkKkHKkKKkKkKkKKkKKHKkkkkkKkHkkkdMkkkkHkHkkkdkx#xtEqqqqqqqqqqqqqqqqwxxs0BCTTTkkkx#HwJtttxdwddH#gLLLBTLIKkHkKKHHkKKKKKKKHkKKKKKKKKKKKKcNKNWKNWKNKKNWKzKKKNKWNKKWNNKzNKNzNNWNKKNzKNzzNNNzNWNWNNKXzNWNNWNNzWNWNWXNNWNWNNNWNNNWNXNVWNWNVNWWNWV0NWNVNV444444p11o1pijityyyiipiyijipiyiyOyyytDjymDffZffmqhmtotyy11DtyjpyjjjDDt1qkOoEayoDDtyayDkjjtmyyyqDDyfftlmDmqykZftZfpDtyjm1pjyyyaayjtEyyyoyipjtpjipyyaEptt1i1jp1oJto111fofoofopooffo1opmoofAftfoptf1fpofoyyyjiiyykqjODEjpEijiyypiEEtptEf1O11DpffOON111ooop11o1pijityyyiipiyijipiyiyOyyytDjymDffZffmqhmtotyy11DtyjpyjjjDDt1qkOoEayoDDtyayDkjjtmyyyqDDyfftlmDmqRRRRRRRRRR",
"OOOOOOOOOOyjooiyEEp1oooppWKKKKKKKKKKKkKkKkKKkKkkKkkkKkkkKkkkkHkkkHkkkkkdkdkkkdkkzwttqqqqqqqqqqqqqqqqxxxIv0TTeTxkxsHwJtttJddwdH#gLLLLLBIKKkKkKkcHKKKKkKKKKKKKKKKKKKKKKKWKKKNKNKKKWKKKKNWNWKNKNKWWKNNzNKNzNNKWNNNzNKNzKNN#WNWNNNWzNNNNWNNWXNNNWNNWNNWNWWWNWNVNNNNNWWNNWNWNVWNWNNWWNN444444o1EqjiaayiiiiipppjyyipyyyyEayyD1Dk1kmfJmmxqym1DtpyD1jytD1ayj111D1tDyDEayDqj1jyDthDyDyqPDOtmkOoxIxmDDOZfZtyjjjoi1fZoD1ppyaaaoEyaaDaayiEpyiiEaiiytooiofpEiijpoopo1oooopf1offAotoffffff1rft1o1off1o1ppayyyiyaaqjEjyyyjooiyEEp1oooppppjDtDtrAfOOmf1oo1EqjiaayiiiiipppjyyipyyyyEayyD1Dk1kmfJmmxqym1DtpyD1jytD1ayj111D1tDyDEayDqj1jyDthDyDyqPDOtmkOoxIxmDDRRRRRRRRRR",
"OOOOOOOOOOEjt1yaipoptpoEpWKKKkKKkKkKKKKkKKKkKkKKkKkKkkKkkkKkkHkkkdkkkkkdkdkkkdkkw#ttEqqqqqqqqqqqqqqqttJJv0TCTTcKHswxtttJwdwdH##LLLLLLIKkKkKkKKHHKkKkKKkKKKKKKKKKKKKKKKNKKKKKKKKWKNKWKNKKNKWNNNKNWKNzKNNzKNNWWKNzNNK#NNNzWWNNNWWNzWNWNWWNNzNNVNNWVNNNNWVNWNWWWVNNNWVNWVNWNWNNNVNWNN444444pppippaayppppo1pppipiiyiiaqaiyDkqyhf1OfmmIkDf111tpjyyyptaaaqODD11Dqp1yap1DttqDp1EftiyjqfpDfmkjmm111111kDayayDiyyafoDmjppaa1EiyaiiaaaaqiaayaaiaiyiiiiEEojjAt1xApopp1EjffAArrfoAffforforo1ffAfof1111pjyyEpEqaayaaijEjt1yaipoptpoEpiEp1oDD1ff11Om11pppippaayppppo1pppipiiyiiaqaiyDkqyhf1OfmmIkDf111tpjyyyptaaaqODD11Dqp1yap1DttqDp1EftiyjqfpDfmkjmm1111RRRRRRRRRR",
"OOOOOOOOOOjpoEpaapppyyjqjWKKKKKkKKKkKkKKkKKkKKkKkkKkKKkkkkkkHkkkdkkkkkkHkdkkkdkkkdHttqqqqqqqqqqqqqqqqtxxIg#TTTz#dwtEEtwwIwH##gLLLLLIkKkKkKkKkKHHKkKKkKKKKKKKKKKkKKKKKKKKKKKWKKWKNKNKKKNKNKKKWNKWNKzNKNWzKNKWNNNzNWKzNNNzWNWNWWWNzNNNNWVNKNzNNWNNNNWNWNWWVNWVWWVWVNWWVNVNWWNNNNWVWV444444pooiEpiaytjEafEppE1jEyyaaD11qyjOmkahDxf1oxD1DDyttyqjpt1iaDqqjDtjmm1iqat1f11jtDtyDm1fyta1mo111ttppD1DD1f1Dy1jyaaaajmobrroEjyyaaaaaayyiyyyya33aiaaiiii1t1pof1bAZbofbpooofAfAtmffffoffffoooffffooppo1o11pajEDjDyyqyjjpoEpaapppyyjqjDjyippp11pfompjEpooiEpiaytjEafEppE1jEyyaaD11qyjOmkahDxf1oxD1DDyttyqjpt1iaDqqjDtjmm1iqat1f11jtDtyDm1fyta1mo111ttppD1DRRRRRRRRRR",
"OOOOOOOOOOqypiaaayipiEqptKKKKKKKKkKKkKkKkKkKkKkKkKkKkkKKkKkkHkkkHkkkkkkdkdkkkkdkkx#JttqqqqqqqqqqqqqqqqwxxsvgTX#dwtEEtwwwwH##vLLLLLnKKkkKkKkKkkHHkKkKKKkKKKkKKKKKKKKKKKKKKKKKKKKWKWKNKNKWKWKWKKWNKNzKNNNzNNWNKNNzNWNzKNN#KWNWNNNKNzNKNNWWNWXKNNNVWNNWNWNWNWNWNNNNNWWNWWNNWNWVWNWNWN444444pooiypyEyatEatotjppjpiyaaD1paaDkkmmmmmxf1ftDDiaayyyqjjy1qtyjq1pqtmDtiqDf1f1iEDDy1DOD1Eaf1o1of1DjyyDfJZq1pyytyyaaaOJmIAJopAtiyyaaa3ayEopypya3aiyyiyijpJpppomofoof1oEooffffoo1rfAmrforfo1forrAffoo1footpyqpD1EayqkjqypiaaayipiEqptpEyjiyEptttpoDpppooiypyEyatEatotjppjpiyaaD1paaDkkmmmmmxf1ftDDiaayyyqjjy1qtyjq1pqtmDtiqDf1f1iEDDy1DOD1Eaf1o1of1DjyyDfRRRRRRRRRR",
"OOOOOOOOOOyiaaaaaaaaiEEojWKKKKKKKkKKKHKkKKkKkKkKkkkKdKkkkkkkdkkkdkMkkkkdkdkukkdkdkzdttqqqqqqqqqqqqqqqqJxxd00TzHxJEEtwwwwd##gLLLLLnKkKkkKkKHKkKHHkKKkKKKKHKKKKKKKtKKKKKcKKKNWKWKKNKKKKzKKNKNNWNNWKKzzkNzWWNKNNKNzNKz#NNNKzNWVWWNNzzNNWNNNWNNzNNXWVWVNNNNWNNVNNXNWWNNWNWNWVWNXNWVVWV444444oofiaoEEaaaiyyEEytDDDiaaakfmtijhhxxxmmmfDqqiqyaaaaaiyjjpkEy1D1tth1yiyyD11N1D1mtDtDkDt1yj1DtDpEqqjqD11oDDDqyyiyaajZArrrooorjoopaaayyyjEypAo1yayyDqyyEpiEp1Dotf1tpfEjjpArfff1pfZf1ffmfoofoffAbZfZf1oooo1pyqtpDiyDDyyiaaaaaaaaiEEojtEEjiyyiijjDtiipoofiaoEEaaaiyyEEytDDDiaaakfmtijhhxxxmmmfDqqiqyaaaaaiyjjpkEy1D1tth1yiyyD11N1D1mtDtDkDt1yj1DtDpEqqjqD1RRRRRRRRRR",
"OOOOOOOOOOpjEyaayyyaipapDWKKkKKkKKkKkKkKKkKKkKkkKkkkkkKkkkkHkkkkHkkkkkkdkkdkkudkkkI#ttEqqqqqqqqqqqqqqqtJJxg00HxJtEEwwwwd##gLLLLLdNkkkKkKKkKkKkHckKkKKkKkKkKkKKKKKKKKKKKKKKKWWKKKKKWKWKKNKKWKNWKKNzNNNNzWWNNNWNNzKVNKzNNKzWNWNNWNNNzNNNWWVNWNzNNNWWWNWNNWNWWNNWNNVWWNVWNNWNNVNNKNVV444444pyaaaayaay1tyyyyEy1iaaaaayjpayDkkm1xmmtf1DaaayyayyjEiij1tDqiaayDkD1mfyyqq1tjjqqyDyyDoEia1ojtiaaaqpo1ptyDqmftEaaptEExmArpDDEijEiyyayaEDp1p1rZbArZZYIbZbEiyEihijioiyiEjppEpiot1ffoofoofffoAfofAf1fmJorff1pDq1Eiyyt1pjEyaayyyaipapDpjpotpEiyyipiEpppyaaaayaay1tyyyyEy1iaaaaayjpayDkkm1xmmtf1DaaayyayyjEiij1tDqiaayDkD1mfyyqq1tjjqqyDyyDoEia1ojtiaaaqpo1RRRRRRRRRR",
"OOOOOOOOOOjEitiiiyijiaatoWKKKKKKkKKKKKkKkKkkKkkKkKkKkKkkKkkHkkkdukkkkkkdkkdkkkdqkkk#wttqqqqqqqqqqqqqqqqdxxHv#wxtEEJwwwd##gLLBLLMNkKkKkkkKkkkKkHHkKkKkKKKKKKKkKKKKKkKKKKKKKKNKKKKNKKKKKNKKNKNNKNWKztKkNzNKKNNWNK#NKNNzNKN#KNNNWNKNNzNWNNNWNNNXNNWNNNNWNWNWNWVNNNWWNWNWNWNWNWNWNVWNN444444oiaaaaaaayftyEiipEEyaaayayk1jyhDkkOkfxmmtyyyayiyayyyayDptqyaaDqmmDmZxpqjyDDtjtjiyytpyEaaayaaaayyppp1typ1yOO1iyaDpDhxmbrt1oyqpopDpaaiDoffArZbZZIZZIIbbloy1ffbZA1yyEiyi1p1pooAffooofAZrffotofffZJmooffo1mopytpEiaDDjEitiiiyijiaatoptEEijpjiyEiiyipoiaaaaaaayftyEiipEEyaaayayk1jyhDkkOkfxmmtyyyayiyayyyayDptqyaaDqmmDmZxpqjyDDtjtjiyytpyEaaayaaaayyppp1RRRRRRRRRR",
"OOOOOOOOOOqEijiijaaaaayyaKHKKHKKHKKHKHKKHKKMkKMkKdKkdkKkkdkdHkkdkkdkkdkddkdkkddkdkksHttqqqqqqqqqqqqqqqqtxxIgsxtEttwwwd##vLLLLLLNkHkKHKKHKkckkHHHHkHKkHKkHKKHKKHWKcKKKKcKNcKKcNtzKKzKNzKzKKzKKzNNzzNzNKzWNzKNzWKzNNzN#zKNzNKWWXNNzWzzNWXNWXNNzNXWNXNWXWNXWN0KNXN0WWXVNXWNXVNXNW0VWV444444jtaa3yyiayDEyDpp1ptiaaaEjED11yyD1kmmmkDtaaayyqyiyyyaDq11yaaaf111fttDkDEyyDOEEtiyqjqjppyaayiyyyjpEiDqjt1tjiyiiyijJymlx1oEAoDpooppppiymAbIIYIlIbfZbbZlbroDlbZArArEiEpppAZJfffJZb1oofAJArAfffffof1o1fom1fto1jayyiaayqEijiijaaaaayyaqpoEEjtjpEEiyyiEjtaa3yyiayDEyDpp1ptiaaaEjED11yyD1kmmmkDtaaayyqyiyyyaDq11yaaaf111fttDkDEyyDOEEtiyqjqjppyaayiyyyjpEiDqRRRRRRRRRR",
"OOOOOOOOOOa1tjpaapipEiiyyWKKKKKKKKKkKKkKkKkkKkkKkkkKkKkKkkkHkkkHkkkkkkkdkkdkkkdkkkkS#JttqqqqqqqqqqqqqqqEwJxvdtqEtwwJds#vLLLBLBckkkkKkkkKkKkkKkHHKKKkKKKKKKKKKKKWKVxSMMMnxNNWKKKKNKKNKKKNWNNNNNkNkzNNKNzNWNKNWNNzNWNKzNNNzNNWNNKWNNN#WNNWNWNWNKNNNNWWVNNWNWWVNNVWVWWWVNVNVNWNNWVNWV444444ayyayiyDjyya1EyfpooqyaaaDtjjpDyyy11mm1pqDtaqyayDqayht1pyODDmrtfmotyaaqaPfZZDiyyEqyaaDiayyiyiipyjppi1pDmqaiaiiypEpobxOJrpooobbboooyaplIYYbIIZbfflbZbYYffIYbYYIAp1AbxZZfpooZAfAmrZZfmAfbfAfff1fffffArbfffff1o1ayayia1tjpaapipEiiyyyaayyDtEjtiyaaayayyayiyDjyya1EyfpooqyaaaDtjjpDyyy11mm1pqDtaqyayDqayht1pyODDmrtfmotyaaqaPfZZDiyyEqyaaDiayyiyiipyjppi1RRRRRRRRRR",
"OOOOOOOOOOyy1oyyaEEEEiiiyWKKKKKKkKKKKkkKKkKKkKKkKKkkKkkkkkdkkkkdkkkkkkkdkkdkkudkkkku#dttqqqqqqqqqqqqqqqqxxJJJqttwwwds#vgLLLLLcNKkKkkKkKkKkKkkKHHKKKKkKkKKKKkKKNSInnnlMMHcXMWKNKKKNKKNKKKKKKKKNNNzNKKKzNKKWNWNKNzNKNNzKNWzKKNWNWNNNKXNNWWWNWNN0NWNVNNWWNNWWNWNNWNWNNNNWNNNWVNVNWNVN444444aiEaaayqjyayayyDjm1aaaaaatyEjjayyDO11qDDjqaaaahfyakDqyypfyDfoaDtO1tiatahZII1qiqDtqtyyaayyyyyiAiyppqyqDpiatqjyypiyDAxtootDDtAmZi1byajlIbIIZmfZxZfbZbYIfZIIblYYbtbZbZbbZf1fffbZJbbZZfffbfbbAofAffAfJfffof1of11aaayyyy1oyyaEEEEiiiyyyayyyiiEiyyyEiaaiEaaayqjyayayyDjm1aaaaaatyEjjayyDO11qDDjqaaaahfyakDqyypfyDfoaDtO1tiatahZII1qiqDtqtyyaayyyyyiAiyppqyRRRRRRRRRR",
"OOOOOOOOOOEayqaipiijEpiiyWKKKKKKKKKKkHKkKKkKkKkKkkkKdkKkkkHkkkkdkkdkkkkdkkdkkkkddkkkI#ttEqqqqqqqqqqqqqqqtxJJtEExwJws#vgLLLBLXxkkkKkKkkkKkKHKkKHHkkkKkKKKHkKKNxSSSSVxSSSSMMz0SWWWWNVSSzKWNWNWNKKNzKNzNzkNNWNNKNK#NNzKzNNW#NNNNWNNzNNzNNWNWNNWNz0NNWWNNNWVNNNNN0NVWNWVNNNNNWW0WWNWNV444444jiyayjiiyaaaaaEaaaya333aaayyi1aayDDkD11OtyiaaaqDyaayqyiDm1tqEiDqk1qymx1mblYZptiyjjjtaaaiyiyyiEaayyEip1oooyiyqDoiyy1rtopkuakfmZhAZZ1jotZbZZZZbAbZbbZZbflZbZZZbomIbbZZZZAfIZ1fAfZZbmfAZZbZbJtAbZbfZfffofoo111fDiaaqEayqaipiijEpiiypiiiooooooyyyDEijiyayjiiyaaaaaEaaaya333aaayyi1aayDDkD11OtyiaaaqDyaayqyiDm1tqEiDqk1qymx1mblYZptiyjjjtaaaiyiyyiEaayyEiRRRRRRRRRR",
"OOOOOOOOOOyiiaiyiEEiiyippWKKKKKKkKKkKkKkKkKkWkKkKkKkKkkKkkHkkkHkkkkkkkkdkkdkkkkdkkkkN#wttqqqqqqqqqqqqqqqqwxtEEJwwws##LLLLBLLxkKKkkKkkKkkKkKkKkHHKKKKKKkKkKNxSSVVNNVNNxSSSSMcXcNVSMnMccMxWKNWKNKNzKNKNzNNWWNWNKNzKNNNzNNNKzNWNWNWWNNNzKWNWNWNNNzNNWNNWWNWNNVWNNNNNVWNNVNVNNWNNNNWVV444444jmbrojyyqofE1qOiatoiyiykD1ktjayqaaytDtpqyyayaiyyyaam1Ob1xDfoyymiiiEDx11t1t11ZxDyj1EEiaaEyaiiipiEoEiyypoAApiy1p1iiorjEytpqypfbmfuOAroOxlbbZIZbZxZIYbb1ZYIlYYIOblbIblIblZZArZ11AArfZZb1ofAfpbIbZfrffof1frfZAfootyiyyiiaiyiEEiiyipptpEpffootyDtpDyajmbrojyyqofE1qOiatoiyiykD1ktjayqaaytDtpqyyayaiyyyaam1Ob1xDfoyymiiiEDx11t1t11ZxDyj1EEiaaEyaiiipiEoEiyRRRRRRRRRR",
"OOOOOOOOOOijpiiiypEjyyiipWWKkKKKKkKKKkKkKKKkKkkKkKkkKkKkkHkkKkdkkkkkkkkdkkdkkkkdukkkkdHttEqqqqqqqqqqqqqqqtJEqtwJwH##LLLLBBLxkkkkkKkKkKkKkKkkkNHHkKKKkKKkKWSVVNNNNNtNNNxxSSSIcXMSSSSlnMc0IWKWKNNkzKNNKzNNKWWNNNKzKNNKzNNKNzNNNNWNNNNWzNNNNWNWNNK0WNNWNNNVWNNWNWVVWWNWVNWNNVNNWVWNNN444444ifbbJfE1Abfot1Oya1fjatOoDp1DtmjyyaayDDDqayaaayqtyaDmkDtyfmfty11pqyy11kpDjyxZbxjtj1aijaypyijEpEiDEEEpEpyiiiiyippyiproEjjEmDpJrbfmVmZpZbbIZxllZZZZZlbfpZlbZZIoYYIYYbZZIbbIffZ1mAbffbxZotobf1bZAbbffffof1ffrZff11qpiijpiiiypEjyyiipEoEpfbf11pp1qkyaifbbJfE1Abfot1Oya1fjatOoDp1DtmjyyaayDDDqayaaayqtyaDmkDtyfmfty11pqyy11kpDjyxZbxjtj1aijaypyijEpEiDEEEpRRRRRRRRRR",
"OOOOOOOOOO1tpiaqEyEjaayEtWKKKKKKKKKKKHkKkKkKKKkKkKkkdKkkkHkkkkHkkkdkkkkdkkdkkkkddkkkkx#xttqqqqqqqqqqqqqqqqEqEwxwH##BLLBLLLSkHKkKKkkKkkKkKkHKKkHHKKkKKKKKcxxVNKNkkkkttttNtSSIdcSVVNVxSSMc0cKKWKWzKNKcNzKNWNNWKNNzWNzNzNNNNzNNNWWNzNNNKzWNNNWNWNXzNNNVNWVWNNNNNXNWNNVNNNVNWNWXNNWVNN444444EoffAffbbbZbm1xjhf1jqjyDkkkqjDftDjiaaiyaayaaayyqaPtD1k1amfZZymfDEDDlx1oDtiDx1ktfyaapaaiiyjpppyijioEiiyayyyiipppppmroo1pyIbtpfbpofmftbfbZfZbZIbIIxbZfolZbbxAobYYIYlxYlblIAZZlIbrffZfxJ1ff1oZbfZfbffAffffAZfrf11Eqj1tpiaqEyEjaayEt1oopooro1f11qpqjEoffAffbbbZbm1xjhf1jqjyDkkkqjDftDjiaaiyaayaaayyqaPtD1k1amfZZymfDEDDlx1oDtiDx1ktfyaapaaiiyjpppyijioEiRRRRRRRRRR",
"OOOOOOOOOOpttoyiaaayiaatpWKKKKKKKKKKKkKKKkKKkkKKkkKkKkkkkMkkkkdkkkkkkkkdkkdkkkkdqkkkkk#dttEqqqqqqqqqqqqqqEqEqwJd##gLLLLLLSkKkkKkkkKkKkKkKkKKkKHHkKKKkKkNxVNKKkkNkktkkkkttNxSSdVNNNNNSSSMc0HNWKNcNKNNNzKNWNKNWNKzNNNNzNKNW#KWNNNKNNNKNXNWNWNWNNNNXNNWNWWNWVNNNNNNWNWWVNNNNNWVNWNWWV444444D11JmktkxIfZZmmtDDjDEOfoxIfO11yjqjjty3aaaayaaaiyafbtjqEaa1fmftOmfImZZfZff1fqDqaqyiauiayyjDyppyyypppkDfooEiiopo1AZmofDot1ttp1oJiiiajEbZAAfbbZlZZblrfoxlffmrfbbIYIIIYYYYIYYZbZIYZlfZfZZro1oZbbbofmfxArfrZfbbZAftDptpttoyiaaayiaatptopo1rb11ff11tDyD11JmktkxIfZZmmtDDjDEOfoxIfO11yjqjjty3aaaayaaaiyafbtjqEaa1fmftOmfImZZfZff1fqDqaqyiauiayyjDyppyyypppkRRRRRRRRRR",
"OOOOOOOOOOtppDqEyyiyaaatpWKKKKKKKkKkKKkkKKkkKKkKKkKkkKkkkHkkkkHkkkkkkkkdkkdkkkkdkkkkkkI#tttqqqqqqqqqqqqqqqEqtJd##vLLLLBLIKkkkkKKkKkkkkKkKkKkkkHHkKkKKKKxVNKKkkkkkkkkktkkkttSIdkkkttNxxIIdzBSWWNzKNKNzKNKWNNWNKNzNKNKzNNKNzNWNNWNNWWNWzWNNNWNWNWN#NNWNNNNWWNNNNNWWNNNNNNVNWNNWNWNVV444444EjpbmmamxbfmxxZqD1y1oD11mDOtftyyDmtiaaaayayaaykiakt1yayiamflqOmmpfbIfxmxfDyayaayjkyyiyiiiiipEiyiapoffxjt1f11fiitobfZZoffpoobJpo1DakyffJbbbIbIbIZAfffZfZZfpAZZYYbZYlIYYbZYIYSIYbZbbbZbxbtZbfAxfffZZxbff1fffrf11jtttppDqEyyiyaaatptp1po1f1DD111yaaEjpbmmamxbfmxxZqD1y1oD11mDOtftyyDmtiaaaayayaaykiakt1yayiamflqOmmpfbIfxmxfDyayaayjkyyiyiiiiipEiyiapofRRRRRRRRRR",
"OOOOOOOOOOppEtDjtppiayippWKKKKKKKKKKKHKKkKKKkKkKkKkKHkkkHkkkkHkkkkHkkkkdkkdkkkkddktkkkN#wttqqqqqqqqqqqqqqqqEww#vvLLBCLLdNkkkdKkkKKkKkKkKkKHKKkHHKKKKkNVNKKkkukkkktktkkktktttSIkkkkttttxIdH#LNKKzkNNzzNNKKNKNKNNzNNzNzNNNNzNWNWNWzNNNNWzNNNNWxKXWKXNNNWNNNNNNNXNNNWVNWNVWNWNXNWNVWN444444EpEmfAhxZx1qmxxaatatED1D1Df1DDyDtDDjaayyyatDayDpayyaaPqy111IOxlD1fYYbfmfp1aayjyy11yaiipDpiyp1iyyap1bbomZr11oojaotoobbrZoOtpffpbrtEpttffZIbZYblbZffAZbfbff1bIIIZIZYlYlIZZIYIbZZbZIYZfIAbfbAffAmmrffAZff1fAfffo1DjpppEtDjtppiayipp1toooofZ1DDtDqyaEpEmfAhxZx1qmxxaatatED1D1Df1DDyDtDDjaayyyatDayDpayyaaPqy111IOxlD1fYYbfmfp1aayjyy11yaiipDpiyp1iyyap1bRRRRRRRRRR",
"OOOOOOOOOOppptjpp1pEiii1tWKKKKKKKKKkkkKKkKkKKkKkKkKkkKKkHkkkkHkkKkkkkkkdkkkdkkkkdkkkkkkdHttqqqqqqqqqqqqqqqEqwxg#gLCCCLcKkKkkkkkkkkKkKkkKkKkkkKHHKkKkKxVNKkuukkkkkkkkttttttktSxuukNttttxSIdcBxNKzNNNkcNNWKNNNWNK#KNKNNzNKKNzNWNNWWWNKNNXKNWWNWNNNNK0WNNVNWVNWNWNVNWNWNVNWNVWNVNNWWV444444yypfxIIZZxmZiyaaaaytqDDktmtqytjDDqqq3aaqyqa1DyqD1t1Dm1yai1bZft1ItymDtiyaa3Dyiaaaiyaaiaaj1oyDyiiipAfffft1ppt1AbtiqDEpofooff1Oo1oorOyyEffffZlfIIYZZfoZfffopxbZYYYbYblYIYIYIIZYIIIYIIIZxfffJrxAfZfxmffZfAtyyaDffoDDoppptjpp1pEiii1tfooo11fZffyDqyiiyypfxIIZZxmZiyaaaaytqDDktmtqytjDDqqq3aaqyqa1DyqD1t1Dm1yai1bZft1ItymDtiyaa3Dyiaaaiyaaiaaj1oyDyiiipAffRRRRRRRRRR",
"OOOOOOOOOOotpEtttoppjtpptWKKKKKKkKKKKkKkKKKkKKkKkKkkKkkkHkkkkdkkkkkkkkkdkkkdkkkkdkkkukkx#xxqqqqqqqqqqqqqqEqqJJdv#TLCCLxkkkkKkKkkkKkkkKkKkkKkKkHHKKKKNVNKuuukkkkktkkkktkkkttkxNFuNktttttxIdH#dNcNKKNNzNKNNNKNWNNzNNNNNzKNNNzWNKNNNNWNNKXNWNWNWWNNNWzNNNWNNNNNWNNNWNWNNWNVWWVNNWWNVN444444ayE1SxlIZfffaaappyDpj1DyftDDyyDjDpDDayajyyq1paatDD11t1paa1DxZ1mx1yoyaaaaaaDyiyjyaayayiypqyytiyyaE1lffApt1iDoootfp11jpkkD1xZm1ooAfbODifxZlbbxZZYfbA1Jffbp1ffbYIYYYYYblZrbYlYYlYlYYYlIZmfobZfbbbZbfZfffoZf1yPmfooDEotpEtttoppjtpptoppoop1Zmm1Dak1tayE1SxlIZfffaaappyDpj1DyftDDyyDjDpDDayajyyq1paatDD11t1paa1DxZ1mx1yoyaaaaaaDyiyjyaayayiypqyytiyyaE1lfRRRRRRRRRR",
"OOOOOOOOOOpptpjjqtp1EpEpoWKKKKKKKkKKKHkKkKkKkKkkKkKKdKkHkkkkkHkkkkHkkkkdkkkdkkukdkkkkkkk#dJEqqqqqqqqqqqqqqEEJJJv#TCCCCIkkkkkHkkkkkkKkkkkKkckKkHHKkKKVNkkuukkkkkttkkkktttktkNxuFutNtttttxSdH#HNzNNKNzzNWKKNKNWNKzKNzKNzNWNNzNWNNKzWNWWNNzNWVNWNXNNNNzNWNWNWNVWXNNVWNNWNNNNWWXNNNWNV444444yyyyOfflZrffaaj1ojyEDpqy1fOyqOp11tDyyqakDDa1taDD1jyyyqqaayyiEkk11a1jjayqDkyyyyEpyaayyqj1quD1piayymmoffpppj1totDf1E1Ej1OOkZIbr1pfJrrAhmYfxfZfIbrfbb111mj1ZxZbIlbYIYlxZIllYYYYlYIlIblYbfofrrZZfZbZfAZfffmffDp1foEDDpptpjjqtp1EpEpo1oEpt1ffxx1pyD1EyyyyOfflZrffaaj1ojyEDpqy1fOyqOp11tDyyqakDDa1taDD1jyyyqqaayyiEkk11a1jjayqDkyyyyEpyaayyqj1quD1piayymmoRRRRRRRRRR",
"OOOOOOOOOOhE1otjDDtppEqjjWKKKKKKkKKKKkKKkKKkKkKkkKkKkKkHkkKkHkkkkkkkkkkdkkkdkkkkdkkkkkkktzwJqqqqqqqqqqqqEqEqEwwIv0LCQTCSKkkkkKkKkkKKkkkkKKkKKkHHKkNVNKuFukkkkttxJxkEkEktktttxqFutttttttxxdH#HKzNNKKzkNNNNNNKNKNzNNKKNzNNNN#NNWNNWNNNNNNNzNNWNNNWNNNN#NWWNWNNNNNWWWNNNNWNNNVNNWNVNV444444yaiyjtbmm1Zxptmt1q1tO1tjmmxDDitopjqyqqyyO1yqjaqyt1oyyaa3ayaaay1qaytjDtmf1qj1jiyEayyafZmmx1u11jtkfxmfZboptff11p1f1o11ijtt1tfyiomO1rrIbbYSZfZbAffIb1mAx1bIbArfYYIbblYIIYIYIbYbYIbIYYIYfbZxZrbZZZZAfffAAffffmffffookhE1otjDDtppEqjjpoooDo1ffm1p1pmoyaiyjtbmm1Zxptmt1q1tO1tjmmxDDitopjqyqqyyO1yqjaqyt1oyyaa3ayaaay1qaytjDtmf1qj1jiyEayyafZmmx1u11jtkfxmfRRRRRRRRRR",
"OOOOOOOOOODpEtpptDDjtpptEWHKKHKKHKKHKHkKHkKHKkHKKHKkHkkHkMkkdkkHkkMkkdkMdkddkdkkdkkdkkIkkssJEqqqqqqqqqqqqqtqEwJJsvLTCTCTkHKkHkKkkHkkHKkckKHkkHHHHkSNkuFFukkkktJwIHkkkkkEtEEtwuuktttttttxIdH#dzNNcNNcNNzWNzNWzNKzKNzNNzNWzNzKNzNWzNKzWN#NzzNKXNXNNzNNXWNXWNXNWXNXNNXNNXNNXNWXNWXNWN444444jjyqpDfkqo1j1mImfmDp111DffDyyEDktqyaDqaDkjyjEayyp1iiiyyaaaaayaiyyyjjtp1mtEEtjiDDiyqafxx1ZmuDkqpkt1tD11op1bxfo11poppEypop1y1Diyt1EoobYofZfZIZbfZIbffbApIYIfIYUIblYYZbYIZbIIYlYYlIYYYYfZIbfobfoffffffbAffo1fAfp1ootDpEtpptDDjtpptEtooojk11DyfD11fmjjyqpDfkqo1j1mImfmDp111DffDyyEDktqyaDqaDkjyjEayyp1iiiyyaaaaayaiyyyjjtp1mtEEtjiDDiyqafxx1ZmuDkqpkt1tDRRRRRRRRRR",
"OOOOOOOOOODjqi1p1jpEttptpWKKKKKKKKKKKKKKKkKKkKkKkKkkKkkkkKkKMkkkkkkkkkkdkkkdkkkkdkkkkkkkkx#xtqqqqqqqqqqEEEqEtdwIdv0T2TCTVkkkKkkkKkKkKkkkKkKKkKHHKkVKkuFukkkkktxwH#xkkEEEkEEEtkkkkttNtttxIds#SzKKNNkzNkKNKKNKNNKzNKKNkzNNNKzNKNNNNKNWNKNKzKNNWNNNNNWNNXKNNNNNNWNNWWNVWNNWWWNNNNNNNN444444pEip1tk11EpEymfmfoqDtDty1Dq1DDqjDqyyayyyDqqjqayaayEpj1pqyyijiioooppEpyiDpptayjyyyaya11tmIfPkukj1ZfjftppkffZxfffop1EayEpooAfrpaooDtpobftblIbAfbrmroZboDZYYbZIIYYIfxbIIlIbZbIZIbIllYIIZYbYbfArffrAooombbfAfrZfo11opDjqi1p1jpEttptpppptq11mp1f1Ot1opEip1tk11EpEymfmfoqDtDty1Dq1DDqjDqyyayyyDqqjqayaayEpj1pqyyijiioooppEpyiDpptayjyyyaya11tmIfPkukj1ZfjfRRRRRRRRRR",
"OOOOOOOOOOpktEEDpijEEpojEWKKKkKkKKkKKkkKkKKkkKkKkKkKkKkkkkkkHkkkkkkkkkkMkkkdkkkkkdqkkkkkkkzJEqqqqqqqqqqqqEqEqxJJwgBBCTTCMkKkkkkkkKkkkKkKkKkkKkHHkKNkuFFkkkkktJwIs#dxkkkEEEEwxkkkkkttttEJwd#cNzNNNKNzNKWKNNKWNKKzNKNKNzWNKNNNNWWKNNNNWNNWKXNWNNWNWNKNKNXNWNNWWNVNVNWNNNWWNNVNWNWWNV444444tDOqifZf1pyqtkO1DmppD1D1tOjtqyOtyjtqyaqaa3aaaiaayyyiyijiiipopobIIZZbYYroppppiiayiaaaDtyyqD1iyuuyqhfbxf1f1A111ZIfArjjtEtjpJorooDDojf1ommDjobZblbrptoqDfAZIIlYYYYYYIlbYZAZIbZYfZIbIYYlYlZZfoptmffrAoobff1jDZo1ffZo1pktEEDpijEEpojE1ofoj11DOxZt1AfZtDOqifZf1pyqtkO1DmppD1D1tOjtqyOtyjtqyaqaa3aaaiaayyyiyijiiipopobIIZZbYYroppppiiayiaaaDtyyqD1iyuuyqhfbRRRRRRRRRR",
"OOOOOOOOOO1yDttjoEqEjoDjEWKKKKKKKkKKKHKKKKkKKkKkkKkKHkkkKkKkHkkkkkHkkkkHkkkdkkkkddkkktkkkkIxtqqqqqqqqqqEqEEEttdwIdvBTTTQTNkkHkkKkkkkKkKkkKHKkkHHKkNKuFukkkkkNxwd##SSNtEtEJwHwkkkkktEEEEJds#IKzkKKKNzKNWKKKNNKNKzKNzNNzNWNNNKNNWNzNWNWNWNNXKNWWXNNNVNNN0KNNNNNXWNNNWNNWNNWVWXNVNNVN44444411tpofff11iDf1DmmfttDmtD1kjDpDDOqqiyyqyaaaaaaayyyyEiiEjtpEipooZYbbIdYIYAoopiayyyaaaay1q11111taaaDD1ZZ1f1pm11xIxof1jiO1DtpoAoff1pp1fZppDtjobbZZbbo1fjmAZIIIYIYYYYbIYYYbbZfflIZxAZIIbbYIbIZfpooooofopZZoDp1ffpfAxt11yDttjoEqEjoDjEopo1EpoDpmbmfo1m11tpofff11iDf1DmmfttDmtD1kjDpDDOqqiyyqyaaaaaaayyyyEiiEjtpEipooZYbbIdYIYAoopiayyyaaaay1q11111taaaDD1ZRRRRRRRRRR",
"OOOOOOOOOOrqpEEDtiyEEEt1EWKKKKKKKkKKKkKkKkKkkKkKKkKkkKkkkkkMkkkKkkkkkkkdkkKdkkkkkdkkkkkkkNHxEqqqqqqqqqEqEEqtqtJwJIv#TTQ.QnKkkkkkkKkKKkkKkKkKkNHHkKkuFFukkkktJxIH##NKxNtwddssINkkkEtEEEJwH#dNzkNNNWzNKKNWKNKKNNNzNNKKNzKNWKNNNKNWNWWNWKNKNzNNNNNNNNNWNKW0WWNNKWNVNWNWWNNWNWWNNWNNWN444444tfO1ott1fftjffmDmf1ED11qDDjyDtDkqayqyqia3a33aaaaEiiyEj1ffopioorZmZYYYYIbJotoiaayiiiyqjqfmpkmmuauEtxffm11ffZblZmDAff1Dm1D1obOZboaabJfot1EpobbZAbZmlofJfrZIlYYYYIIlYIYYZbbZZIYIbbZAIbYYllIbftAfrAAf1pbbA1pffofffmmtrqpEEDtiyEEEt1EpEEpf1pp1tfmoft1tfO1ott1fftjffmDmf1ED11qDDjyDtDkqayqyqia3a33aaaaEiiyEj1ffopioorZmZYYYYIbJotoiaayiiiyqjqfmpkmmuauEtxfRRRRRRRRRR",
"OOOOOOOOOOmyjpDjDijj1DEjtWKKKKKKKKKKKKKkKKKKkKkKkKkKkkHKkKkMkkkkKkkkkkkdkkkdkkkkkdkkkkkkkdsJEqqqqqqqqEqqEqEEtEtwwIsvBTTQQTkkkkkKkkKkkKkkkKkKkkHHKVKuFFkkkkktxxds#HKKNSxHs#HSxSttttttEJwH#HNNcNNKNKzKNKWKNNKNWNKzKKNNtzWNKNNWKNKNNWNNWNWWNKzKNWNNKNNWNNNzNNNWNNWNWNNNWNNWNWNNWNNWNV444444mfZ11opj1boDfmmmmfmkDD11iqqyyjqyyytmaiyaa3aaaaayyiypj1pfJfoEifIbYYYYdYIYYb1opyyD1p11ij1fkDypqya3DEDmZotE1mxZfZZZm111mlmOOfZlI1rrfia1Z1q1yapxbbboop1yDmbAbbZZYZlUYIYbAbblbYIlYYYYIblYbYYZYbbfpobrfAUZZfZffD1fo1f1omyjpDjDijj1DEjtiyyjt1111DD1mpo1mfZ11opj1boDfmmmmfmkDD11iqqyyjqyyytmaiyaa3aaaaayyiypj1pfJfoEifIbYYYYdYIYYb1opyyD1p11ij1fkDypqya3DEDmRRRRRRRRRR",
"OOOOOOOOOOokjpokqqDjttptoWKKKKKKKkKKKHKKKKKkKKkKkKkkHKHkKkkHkkkKkkMKkkkHkkkdkkkkddkkkkkkI#wtqqqqqqqEqEqEEEqtqtEdwIIv0TQGQTSKdKkkKkkKkKkKkkckKkHHKNuFFukkkkktxwd##IKKKkHMxxKKKNISxxJxwwH#INNKcKKNKKzzKWKWKWKWNKKzNKzNNzKNNKNNNNNNzNNWNWNNWNzNWWzNNWVWNWNN#NNNWXNNNWVWNWNNWNWXNNVNNN444444mff1o1iqjpjEltkfmfb1p11DqjjjyyDDm11tyaay33aaaayajyyiitE1r1obyfxlnnYYYYYIIopoppj1otEEpptlf11jpaaaPkOOmf111xlfxAZbAo1tZIYxflZboy1fbqD1bA1Ayaptfo1tEmltD1blrIIYIZIIYbZIAbIIYbYYYIYYYYbYZYYrIYZoobArAbZZfAbr1o1foppofokjpokqqDjttptoDyojtD1q1Dllxptomff1o1iqjpjEltkfmfb1p11DqjjjyyDDm11tyaay33aaaayajyyiitE1r1obyfxlnnYYYYYIIopoppj1otEEpptlf11jpaaaPkOORRRRRRRRRR",
"OOOOOOOOOOrpqipyDpEtDDtyqWKKKKKKKKKKKkKkKkKKkKKkKkKkKkHkkKkHkKkkKkkkkKkdkkkkdkkkkdtkkkkI#wxqqqqqqqqqqqEEqEEttttJwwIzvBTGQQHkkkkkKkkkKkKkKkKkkKHHNNuFFkkkkkktxIH#vxKWKKkKKWKKNKKSddIddHdSNNNNzNKKNkzNNKNWWNKKNWKzKNKWKNzKKNtNNKNNKWNNNNWNWNN#NNWNNNWNNVKNXNKNNKWNVWWNNWNVNVWNNWWNNW444444qD1oo1ppEqitfqDxxOtmoptp111tjDO11DDOyaa3aaaiaayippiipErfUffYjbfZYYxbZYYbIo1IboDDtijEDitmmttt1yquak1DOf1f1Il1ftfxfpm1ZllfbfofpymIrE1ofrAlta1f1foDxlfoDkbbZAbZbZZYbbfbZZZbIbfIIZlIIYYlZIYlYYbZoZbxZbZbZrZbrffof1pffrpqipyDpEtDDtyqjaotDp1DijtxfoppqD1oo1ppEqitfqDxxOtmoptp111tjDO11DDOyaa3aaaiaayippiipErfUffYjbfZYYxbZYYbIo1IboDDtijEDitmmttt1yquak1DRRRRRRRRRR",
"OOOOOOOOOOfJpjpEjoO1p1pptWKKKKKKkKKKKKKKKkKkKkKkKkKkkHkKkkkHkkkKkkkkkkkHkkkkdkkkkkMkkKxzdxJqqqqJEqqEqEEqEEtqEEEtdwIdv0TQT2CxKkKkKtKkkKkKkkKKkKHHNNuFukkkkkkxwIH#sNKKKkNkKKNKWNNSSMcHccnMMSkzNKNNKNzkNKNWVxSSSMMccMnSxWzNNKWNNNKNNWNKNNWWNKNXNNNNWNWNNKNNN#NNWNWNWNWNWNNWWWNVNNNNWN444444totmp11ftypm111xfmpytDo1f1Omtytyiyaq3aayjEaairoptooDtpxm1EDIrblbYIIlbmmIfAZZZlZpi1pi1ppxoOpayDffaukmfxfbxZ1mflZxxofllZbfoAbiqyJxoEptffZIfjpZIjpptffAZbfrlrxZfrYIIYIYYIZlZIZIlYIlIIYYYYYYYYffoJfZrZIIZrbofAf1Zbb1ffJpjpEjoO1p1pptjjq1DtjjDtDyDOqDtotmp11ftypm111xfmpytDo1f1Omtytyiyaq3aayjEaairoptooDtpxm1EDIrblbYIIlbmmIfAZZZlZpi1pi1ppxoOpayDffaukmRRRRRRRRRR",
"OOOOOOOOOOoo1joOopo1EqO11WKKKKKKKKKKKHkKKKKKKkKkKkKKHHKKkKHkkkKkkkHkkkkdkkkkdkkkdkdkkxsHxxEqqqJJtqEqqEEEEEEttEttwwwwvBTTQCCndKkkkKkKKkkkKKHkKKccVKFFukkkEktxIds#HkNKKKcNKNxSSnlSSlSnnInncSNzkNNkNkczKKNSMlnnnnnnMncczcXNNNNzKNWNzWNNWNNWNNNzNWzWNNWWNNNNNNXKNzNWWNNVWNWNNWWXNWWWVV4444441rftmD1fojtq11fmk1Dqjmfmt1oo1tjDOyaya3aaiayprropoooot1YIZo1YAxIZblZblYIl1xblIZfroEo1koElmOiaaf1DKukOmmxfmfm1ZxfIZfZYlZApptoyytffpD1ot1bAxD1ro1ff1D1tbbofrAbfboZbIYYYYxZZbZIlIYYYYYYbIIYYUYAtpmfbZrbYIffoAoffZZbfooo1joOopo1EqO111pp1yqDtpDqjqDyt1rftmD1fojtq11fmk1Dqjmfmt1oo1tjDOyaya3aaiayprropoooot1YIZo1YAxIZblZblYIl1xblIZfroEo1koElmOiaaf1DKukORRRRRRRRRR",
"OOOOOOOOOOoppDptpo1EpE1o1WKKKKKKNkKKKKkKKkkKkKKKKKkkKMkkKkHKkkkkKkkkkkkHkkkkHkkkkkHkxHHJxEqqqtwJwqEqEqEEEtEtttttJwdwsvBTCT2TkKKkKkKkKkKkKKkKkkHMNkFFkkkkkkxxwdHsHSSSSSlSnnSSSSSVVxVSVSSszSNzNNKNNzNNVIlSSlSSSSSSSSIMccz0MnncMnMnMMnMnMdnNNkNzNNWNWNNWWNNNNXNWNWNNWNWNVNWWNVWNNNNNN444444jrf1m111ppDyoo1f1pt1D1Aff11xthDtDDtjyaaaaiporborbbbArfYbbJ1bxbZfZZxJZYYIfYYYIYrbryitjtptmfjaaDmx1DkOVmZZfm1mIAfxZrIlIbb1tpiiD1ffta1t1tDpEpioofffjaaD1fffAbZxbfrYIZbZIlIZZxZlIYYYYYIIYYIYYYZoprZAZffZA1fZrooffbZrooppDptpo1EpE1o1ojtDjaqDDypjDf1ojrf1m111ppDyoo1f1pt1D1Aff11xthDtDDtjyaaaaiporborbbbArfYbbJ1bxbZfZZxJZYYIfYYYIYrbryitjtptmfjaaDmx1DkORRRRRRRRRR",
"OOOOOOOOOOotpjjpptpj1op1oWKKKKKKKKkNKKKKkKKKKkKkKKKkKHkKkKHkkKKKkkkkkkkHkkkkdkkkktdkHswxtqqqtwxxJtEqEEEEqttEEtEttdwwdv0TTTCTSkkkkkkKkkKkKkKKKNMSVKFFkkkkkEtxIdddnMnnnnnSSVSVVNVNNNxxVtdz#NKzKKNKKcNSSlSVVxVNVxxSSSSSSdncnMMnMMMMMMMMdMMcWNNNzNNNNWNNNNWWNNN#WNNNWNVNNNNVNNWNNNNWVV4444441tjffm1mf1jpffojpo1Otf1pftxfOyqyjyaq1yaybAfbYro1rrbIbbfxIbr11blIZIZZIIIbfYbYYUbbJoiaiit1p1y1fDf1fOtOfmmkmmbxlZlfomIZrlxfZZxfAffxmjDt1OoyyEpoDDpoiipboo1DDffZfffIYIbZZIYIYllYIZYYbbYYYIfIIYZooblIbbblbffAAZrffr1footpjjpptpj1op1oijqyyyyDtDyjkDyp1tjffm1mf1jpffojpo1Otf1pftxfOyqyjyaq1yaybAfbYro1rrbIbbfxIbr11blIZIZZIIIbfYbYYUbbJoiaiit1p1y1fDf1fOtORRRRRRRRRR",
"OOOOOOOOOOojppjpEpppDotppWKKKKKKKKKKkHkKKKkKkKKKKkKkHKkKkkHkKkkkkKHkkKkHkkkkHkkkdkHHcwxtqqqtJxdJxxqEtqEEtqEttttttJwwws#BT2QCXKKkKkKkKkKkKkcNlSVVNKFukkkkkkxxISVSVVlSSSVVVNNNNNNNNNNtNxH#HNcKNNWKNcSlVVNVNNNxNxxxxxSSSIIIISSSSSSSSSISSIccNNNN#NXNWNNWNVNNKNKXNXNNVWWNNWNWVNWXNVWNWN444444D1y1mOmff1tobf1ptpomffm1tyajtqjEDiytDiaDrJUbbr1obAbblxfAZbIo1ZIlxZIbbYYIZIIYYYbZrEjpjiiyijDmftmfmmDOftVOkDDZmmx1mfZZxbfmbbbJfomxOypfItDpiEyo11qjqpobomyDmOfbbZfZIbbIlIYYYYIIZbIZZlbZYIllZfb1rIYYbZIIbZAbbbZfAfrAfojppjpEpppDotpppDyDaayDDjqyEDtpD1y1mOmff1tobf1ptpomffm1tyajtqjEDiytDiaDrJUbbr1obAbblxfAZbIo1ZIlxZIbbYYIZIIYYYbZrEjpjiiyijDmftmfmmDORRRRRRRRRR",
"OOOOOOOOOOoppEjEtiiqp1ojqKWKKKKKKKKKKKKkKkKKKkkKkKkKHKkKkKHkkkKkkkkkkkkHkkkkHkkkkkc#IxtqqqqJxd#wwJEEEEtEttttEEttttdwdH00TTCTTxKkkKkKkkkKNxSSVNNNNKFukkkkkkxwxNNNNxNNNVNNNNNNKNkttkNtxIH#HKzWKKNNVSVVNNNNNNNNxNxNxxxSSSIISSSSSSSSSSSSSHzcNWNKNNNNWNNNNKNVWNNNzNNWNNNWNNNNNNNWNWNWNN4444441ODmffmmmmptxmjoo11fZmfoopaytDyyiyD11qa1ftbYbof1Joobrf1bbYYbfYbZmZIAbIYfYbbIUIlbfOrbpDiypy1kDmfxmfykDyaaaaaOtDD11plxlm1fxlb111kOtqfobrJypiiyjopfjoJ11pD1fZbbZIbflZZbxYYYYYYYIllZfbZfZZZIbfopAYIYYIbIbbrbbbbAooffroppEjEtiiqp1ojqpiD1yqyqjyyqjE1m1ODmffmmmmptxmjoo11fZmfoopaytDyyiyD11qa1ftbYbof1Joobrf1bbYYbfYbZmZIAbIYfYbbIUIlbfOrbpDiypy1kDmfxmfykRRRRRRRRRR",
"OOOOOOOOOOopjtyjppDjpo1ppKKKKKKKkKKKKKKkKKKkKkKkkKkKHkKkKHkkKkkKkkkKkkkHkkkkdkKkkI#dxJqqqqqJw##dJJJEqtqEtttEttttttwddIv#TCTTTnKkkkKkkKkkVVVNNNKkkKukkkkkkttNttNtNNNNNNNktNktktttttttxIs#IkzKNNKllVNNNNKNttxttNttNxNNxxSSxSxxSxSxSSxSdczcNNNNNkNNNNNNNNWNNNNWzNKNNNNNNNWNWNNNWNNNNN444444tpf1OmmOqm1pDqpo1ff1DEptpEoEptDDp1jOJpEbf1oftAZbD1obt1f1ObIZtxYIYfZIZbftZfIffbfOOojijiEpoEOf1D1bxmZtDyktqqukOf1ftmfo1ZffmfAx1AD1obZrbbAyyaapippi11myyafffxZbYYbZZIblYYYIYYYZYYfOIIYYxmfopoo1AbYYYbIZmfrbAoopAroopopjtyjppDjpo1pp1jtkt11ytt11DDp1tpf1OmmOqm1pDqpo1ff1DEptpEoEptDDp1jOJpEbf1oftAZbD1obt1f1ObIZtxYIYfZIZbftZfIffbfOOojijiEpoEOf1D1bxmZtRRRRRRRRRR",
"OOOOOOOOOOpoijhjpjptDop1DNcKKcKKHKKHKHKKHkKHkKHkKHkHckkkkHkkHKkHKkHkkHkHdkHkHHkkc#dxJEqqqqJws###xwwEttttEtEtttttttJwwdsv0TeCQCkKkHkkHkkHNNkNkkkKukkkkkkkkktkkNtttktkNtktNtkkNkttttttxws#VNzKKcVSVNKkkkkNxttxtNJxttttxttxtxxxxxxNxxxIHHvcNzNNzzzKNzNNXNNXNNzNKXNXNNXNNXWNXNW0WNXWNN444444yjfmffxZymfpEpoJoDm1DpEDppEtppjpp1tD1DDfbIfomfxffAomf1Zf1xZIbmZYUxxZfZZfUblZffx1pforjEpjoo1m1k1xfxZjyq1hpikuk1mpkfmfxfommfZbfJpi1ffAbZoyaap1ooJJDyyoiakDf1xlIIZZIYblIYIZYYYZIYSOOIIbbZbbAooofZIZYZIbbZorbtEporofppoijhjpjptDop1DtD11yjjjDyjqhkmmyjfmffxZymfpEpoJoDm1DpEDppEtppjpp1tD1DDfbIfomfxffAomf1Zf1xZIbmZYUxxZfZZfUblZffx1pforjEpjoo1m1k1xfxZjRRRRRRRRRR",
"OOOOOOOOOOtoppDkyop1DDtj1WKKKKKKKKKKKKkKKkKkKKKkKkKckKkKkckKkkKkkkkkkkkMKkkkdkkxcHxJEqqqqJwH#vg#dwJtEqEtEtttEEtttttHdddv0TCTTCSkkKkKkKkKVNuukuukkkkkkkkkkkkkkkkkkkNkkkktkttkttttttttwd##NzKNWxlNNKkkKkNtttttttEtttxNtxtxtxxNxtxxxxxIHH#sNNNNKzNKKNNNNNWNKNWWNWzNKNNNNWNNWWNNNVNVWV444444it1xmxfm1ffmipfZ1DmtotpEpEp1po11oppqyttrAZAbbmmAf1oDjpbZIxbZItxbbZZbJZIIZbZIbbZrorto1ppifA1ff1OImx1kakmDDDotkO1p11Of1ZptfftZZA1pDjhffo1yyat11fbZtyiyyPaOtmmkmAblxlIAZlblYIYIYIbIfYfZAbbYbfffAxZbYYIZZbAoptpooAffotoppDkyop1DDtj11aqaiiypqaqDDOmfit1xmxfm1ffmipfZ1DmtotpEpEp1po11oppqyttrAZAbbmmAf1oDjpbZIxbZItxbbZZbJZIIZbZIbbZrorto1ppifA1ff1OImx1kRRRRRRRRRR",
"OOOOOOOOOOopfb1jpop1p11aiWWKKKKKKVdMMXMMMMMMMMMMMMMXzMMMMXMMMMMMMMzMMMMXMMMMzHsswxtqqqEtwJd#vLL##dwwEEtEtEttttttttttdddHvBTQGCCMMMMMMMMnSKkuuukkkkkkkkkkkkkkkkkkktkktkkttktkttttttttId#zc0cMSVKKuuukNttxttJEEEEEttktNttxttxxJJtJxJxwHs#0HMccMc0cMcccMcMcMcMcM0cMcccccMccccc0cccccc444444kD1DmObIbxffEpo11pAfrqbpp1opottt1Eofpp1fbIZZlZf1mDippD1EtoZZAbZbAxZZbbYlYIbOfIbf1qjEkppypotxmmfIx1mykmmf1yyfmNkyau1DDf1pZlfZmftjDtoj11JoEEZIZZfb1D1EiaJ1OffxYbZlYYZblIYYIYYIrfZbAYYYmOlIbbAAfZZIxmxbZZmmmopt1oropopfb1jpop1p11aiayq1qDkpyaDt11ZxkD1DmObIbxffEpo11pAfrqbpp1opottt1Eofpp1fbIZZlZf1mDippD1EtoZZAbZbAxZZbbYlYIbOfIbf1qjEkppypotxmmfIx1myRRRRRRRRRR",
"OOOOOOOOOOApo11DjtoppojayWKKKkKKKSXXXzXXXXX4XXXXXX0XXXXX0zXXXXXXXXXXXXBXXXXXzzcwJtqEqtEwJdsvLLLL#HwwxtEtttttttttttttddddg0CTQTTXXXXXXXXXlNuuFkkkkkkkkkkkkkkkktkkktktkxttEtttttkttttJId#000XclKKuFuutttNttJJJJwwJtEkkttxtxtJEtEEEEEEJHH#000XXXXBXXXXXXXXXXXXXXXXXXXXX0CBB0BX0X0XXXX444444fmO1f1YZZZxftyyEppotoffEfrmtootopEtptq11ZIbxbIIAhh1jt1fpjObmbIZbffrZIZblZZIYIlmIZ1tiiiyiipjlIm1mZfmtDmmZtat1p11Dymfmm11fZxZIAfpyaDOfjpfrE1xZbIb1qpADDiA1tkmIblbbYIZbbZIIYIlYIZZfmYUYmDZZbftfIbIlIfZYlxNOm1opo1bo1Apo11Djtoppojayayjt1jDkyayyD1bmfmO1f1YZZZxftyyEppotoffEfrmtootopEtptq11ZIbxbIIAhh1jt1fpjObmbIZbffrZIZblZZIYIlmIZ1tiiiyiipjlIm1mZfmtRRRRRRRRRR",
"OOOOOOOOOOopAoo1kt1oppyyyWWKKKKKKMzXX0XXXXzXXXXXXX0XXXXX0XXXXXXXXXXXXX0XXXzXzzdxtEqqqqJwwH#LLLLL##wwwtEtEtttttttttttxddds00CQTTXXXXX0XXXlNkuukkkktkkkkkktttttttttEttttxtttkutktttttxwd#gBX0lVNuFFuktttttJxwwdHdxtkkktttxtxxtEEEEEEEEws#00XXXXXBXXXXXXX0XXXXXXX0BX0XXBXBBXCXX0XXXXX444444Dfxtm1bbbmm1ptpoqEtpo1pEt1pmptEDp1tDfffZxbIZbfZZ1mmj1pfJj11pfZIbrAZbZfZbxJZYYlAxftpiiyyEjEDlZx1DSlYft1Om1yyDEDm1ZflSIxomIbbxZZyqyytpfJoAxbAbIAfEDo1DDpf1ODDlbbfZIZlIZlYlIbblYYYIlIYYUYIlYbEAZYYllIlYlZOmfEootpojpopAoo1kt1oppyyyympayjyiay1Dj1ZbDfxtm1bbbmm1ptpoqEtpo1pEt1pmptEDp1tDfffZxbIZbfZZ1mmj1pfJj11pfZIbrAZbZfZbxJZYYlAxftpiiyyEjEDlZx1DSlYfRRRRRRRRRR",
"OOOOOOOOOOtDfff1joffppamEWKWKKKKVX0ndMMMdddndndnIndIMIIdnInInInIIInIIIIIISnz#wItEqEtqxwJH#vLLLLcd#dwwxtEtttttttttttttHdddv0TCTTMndndndMMSNukkttttukkkkEktxtttttttttJttxxxuFFtttttttJId#HcccSKkuFFkNtttttwIdHs#sSkkkkkxtNxtxdwJJJJJJJJd##ccccccczccccccccccccczcczccczzzczzczzz4XXX444444Zk111DlZbkyDypDyj1jtoppEppofojpEj1fpZbZbrZIZbIYlffffZt1ofb11tffffZfZlIZIlIYIbZZZrotEpDj1ftDhDmbDqaytqtyyyyyyOuk1m1IlfZxZZIlbbfptEyED1ooyj1mmmoZfEEoorxof1fxZ1AfZIZZbfYYIbZblIZbZZbbIYbbbrZxxIllIISmmO1bZZjyyftppotDfff1joffppamEi11OqjyyqtOtmIffZk111DlZbkyDypDyj1jtoppEppofojpEj1fpZbZbrZIZbIYlffffZt1ofb11tffffZfZlIZIlIYIbZZZrotEpDj1ftDhDmbDqaytRRRRRRRRRR",
"OOOOOOOOOOopoAoop1Zt1jyDDWWKKKKKnXcxxSxxxxxxxxxxxSxxxxxxxxxxxxxxNxttNtNtNNIzdJxtqEqqJwJd##LLLLsxtHswwwttEttttttttttttwdddz0BTTTxxxxxxxxSVNkkttxNkFkkkkkktxwxJJxJxJxJxJxItFFFtttttttIIH#ddMIVKuFFFNtttNtNwdH##HdVkkuukttxtNtIHsHIwwwwwIs#HMHHHHHHHHHHcHHHHHHHHHHHHHHHHHHHHHHHcccXXM44444411m1OkmttyytEkDiiEoopomDoo11tjtpaflZZZIIfblfZYYYZZbfff11fZffyqfrfA1ZblxZIYYYYbffoffftpkf1Dk1mxZttiaj1qqqayaaDKkff1bbfIIZmYIZZotpoiyyffoyp1t1fxI1Dff1mf1111AIofffrZbAAYIbYYYbZxbZbfbbYUUYbfOfZmmmm11bbIZbbyaaoDjpoopoAoop1Zt1jyDDp11DDjyyyD1Ot1t111m1OkmttyytEkDiiEoopomDoo11tjtpaflZZZIIfblfZYYYZZbfff11fZffyqfrfA1ZblxZIYYYYbffoffftpkf1Dk1mxZttiajRRRRRRRRRR",
"OOOOOOOOOO1pf1xfoj11ffy1pWKWKKKWcXdxxxxxxxxxxxxxxxxxxxxxxtxttttttNtNtNttNI#dxxEEEqttwwd##gLLLLSNNI#dwwJttttttttttttttxdddH#0TCTSxxxxxxIxxkNSxxxkuFkkkkkkxJIHddIdIIddddIxuFFutttktttIIHsdddSNkuFFuNtttttxdHs#HddVNkuuktNtxxtIds##HHHHHHH#dHHHHHHHHHHHHHHHHHHHHHHHssHHHHHHHHHHHcXXXS444444yjtfbffmfqD1DjEp1t1ppt1pt1op1ptpqZIYIbbYZxbfbYYbbZxf1fffbZbfjipxbbfYbZmZlIYIYJbZxAf111ODt1OlYlx1yjEO1Dm1pyaaakuDm1AxlxxffZlZZbofrjiqmJfypoffxfIDpflpjo1mffZbfrbbfZfZbbYbZZbZmlZxZAxZbZbbfZ1pfDh1ffIYbIZfADaap1fpt1pf1xfoj11ffy1pp1OqpDpyDt1D11DtyjtfbffmfqD1DjEp1t1ppt1pt1op1ptpqZIYIbbYZxbfbYYbbZxf1fffbZbfjipxbbfYbZmZlIYIYJbZxAf111ODt1OlYlx1yjEORRRRRRRRRR",
"OOOOOOOOOO1ffZ1mmfxxYZtr1NKKKKKSXzSIxIxxxxxxxxxJxxJxxxxxxxxNxtNtNtttNttNtsHwxtEqtEEwJds#vLLLLINttt#Hwwwtttttttttttttttddddv#CTCMSxxIxxSxSSddddxkuFkkkkkkxxws##sssssssHSkuFFuttttttxwdssdddVKKFFFtttNtttwds#sdMdVNkFFuNtxttxIdH##HsssssssHHHHHHHHHHHHHHHHHHHHHcHHHcHHHHHHHHHsccXXXV444444f1tm111ofJjtoDpommof1ptpotof1ojppZIY11ZblxbIYIYYfAAfZ1q1rZADffoqOZffYIYxZYYbf1ZfIfmfZZffbbmlllZayOt1Ommxiyaya11xxm1foffom1xIlxAAf1oqhbbptofArxZayffff1flx1tkrlZAbZllIYIlAZxAZZbZmfmfOkOmfx1JAZIZYYYYlIIbm1aajoAZm1ffZ1mmfxxYZtr1Dqy1jDp11f1tpEppf1tm111ofJjtoDpommof1ptpotof1ojppZIY11ZblxbIYIYYfAAfZ1q1rZADffoqOZffYIYxZYYbf1ZfIfmfZZffbbmlllZayOt1RRRRRRRRRR",
"OOOOOOOOOOfZZmmbImllIZt1tKWKKWKHXHxIIxxxxSxxxxxxxxxxJxxxxxxtxtxttNxttNNtxHwwtEttqtwwwH#vLLLLHNtkxtd#Iwwtttttttttttttttwddds#BC2TxxxxxIxIIHHHdIkKuFkkkkkkJwds##IIIIIdIINKuFFkttttttxIdsHdddNKuFFuNtxttttwH##HdHIVkkFFuttxttxIds##dHdHHHHdHHHHHHHHHHHHHHHHHHHHHHHHHHcHHHHHHcHHHz0XXN444444m1Efm1r1fojtpO1oxmoDEo1oppop1tt11fIY1mYbZflIIIIYfZfZfojD1ooflZoitrb1xYUAZZbffoUbffoAYlZOVmZxlbDipfbh1mOoqayyafplIlZfAlZooofIIIfZlbbjjfZDDDbZ1A1ap1ootpDpl1DkfIZbbIYIZllIZbZZxfbZbZmbZbxfIbffxmZZZIIYlYlbIZkPEpbZffZZmmbImllIZt1ttDpDD1t1fm111iiEm1Efm1r1fojtpO1oxmoDEo1oppop1tt11fIY1mYbZflIIIIYfZfZfojD1ooflZoitrb1xYUAZZbffoUbffoAYlZOVmZxlbDipfbhRRRRRRRRRR",
"OOOOOOOOOOmxbmIbZxxZlxpyjWKKKWVXXnSxIxxxxxSxxxxxxxxxxxJxxxxxxxxxtttNttxxcwwtqtqEEJwwH##gLLLHxtttttx#ddwwtttttttttttJtttsdddv0TTTdxxxxxxxxISISVkkuFkkkkEtxwds#sIIdIdIISNkuFFttttEttJId#HdddVKuFFuttttttxIH#sHddSVKKFFutNtxttIHs##HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHsHHHHHHHHHc00XXN444444fto1t1tppEp1ptpbbZ1jpppotpt11p1t11IIbfZYbZxZYlZbmfmbfopoDfAfbxfEj1foZbbZxZbbffmAofbbdYYxOOSkD1jojfZty1tyaaayDffZZxmZZIm1O1mlZVOmZlYfofrpyyZbqfqaEtZbbffojty1rZbIblYIIYbZbZfAZfIbZxZlZIAZIlZlZxZYYZYIYYlZlIDay1obZmxbmIbZxxZlxpyj1jp111ffmf1tDpoDfto1t1tppEp1ptpbbZ1jpppotpt11p1t11IIbfZYbZxZYlZbmfmbfopoDfAfbxfEj1foZbbZxZbbffmAofbbdYYxOOSkD1jojfZtRRRRRRRRRR",
"OOOOOOOOOOf11mfmZZffmZxDDWNKKKSXzSxIxIxxSxxxxxxxxxJxxxxJxxxxxxtxxxxtxNxHsJtEEtEExwwd##gLLBLxNttttNtHswdwtttttttttttttttwddd#vBCCcSxxIIxIIxIxSNKuuFkkkkktxIdsvHIIIIIIISKkFFFttkttttwIH#dddINkuFFktttxtNxds#sHdHSNKuFFuxtxtJxdHs##HHHdHHHHHHHHHHHHHsHHHHHHHHHHHHHHHHHHsHHHHHHHc00XMN444444f11Dombfoipoppfbbbppoptporo1optpoo1YllxblYAxbxfffbbffofofZbAffZfotopomrIZxfbZfbbbbfbYIbfooyOYooxtjkmtqqy3ZooPakmxxZbxDOr1fDm11D1fm1YbyabroJp1itorbZfZZmZr1AfAxlYYYYZIZblbZZbZZ1ZllZIfmlIlZmZbZZmllYIfxZxZYtaa1bfbf11mfmZZffmZxDDfoff1ft11t1ftoftf11Dombfoipoppfbbbppoptporo1optpoo1YllxblYAxbxfffbbffofofZbAffZfotopomrIZxfbZfbbbbfbYIbfooyOYooxtjkmRRRRRRRRRR",
"OOOOOOOOOOtmfIIIYmmrrZltpWWKKVcXMxIxxxSxxxxSxxxxxxxxxxxxxxJxxxxxxtxxtxHsdtEqtqttwwds#vLLLLLttNtxNxtI#dwdxtttttttttttEttJdddH00TQTSxxIxIxxIIISNkKuFkkkkktxId#vHIIIIIIdVkKFFukttttttwdH#dddSNkuFFkttttttJd##sdddVNKuFFktxtxttdds#sHdHHHHHdHHHHHHHHHHHHHHHHHHHHHHHHHHHHcHHHHHHcz0XXSV444444m1mOtt1EpjiEofYIZbpppfpoofooot1ortDlYYbfooffffbffmfffZZZrfbrf1xftjpprbbZtoZIZZbZIIfAlbIZtpyjlYZfDyqmApiahf111h1fZffllo1fpiD1kDjortoZmttpmbpptfjpbbZbbbofmpmfAblZIYZfZbbblbIZbxfZbblZfbllbZbIZllIYIlZZAZAIYtaaa11ftmfIIIYmmrrZltpmZZf1m1fm11ffbA1m1mOtt1EpjiEofYIZbpppfpoofooot1ortDlYYbfooffffbffmfffZZZrfbrf1xftjpprbbZtoZIZZbZIIfAlbIZtpyjlYZfDyqmRRRRRRRRRR",
"OOOOOOOOOOplYZbYxkDblbAffWKWKS0XnSIxIxSxSxxxxxxxSxxxxxxxxxxxJxxxxxxxxd#IwtEttttwwws##LLLLLINttxtttNx#HdwdtttttttEtttttEtddddv0CTCcxxIxIIxwIISNkuuukkkkktxwH#vHwIIIIIINKuFFuNtktttxIdH#dddSNkuuutNttttxxd#vHdHSVNkFFFkNttxtxdH##sHdHHHHHsdHHHHHHHHHHHHHHHHHHHsHssHHHHHsHHHHHc0XX4VV444444pmffZotptjqqobIYIZotpofoo1ttojofrfpkYIZfAofAfAbft1flflrAffJrfofmf1po1ArrqjfZbbbZbxAoZZbfpfoIYYItyyDEpaiaa1fff11OofmfIofrpiDoppyoJAJ1pD1y1foommqpZZbZIbbZbAfZxZbflIJZfffAZZfZZZYIlZbbZfblxbZZbbZxIZbxIZbxAEqjauu1tplYZbYxkDblbAfffZxfoo111mtfZYZkpmffZotptjqqobIYIZotpofoo1ttojofrfpkYIZfAofAfAbft1flflrAffJrfofmf1po1ArrqjfZbbbZbxAoZZbfpfoIYYItyyDERRRRRRRRRR",
"OOOOOOOOOOffllYYYO1rIbZfZWcWKXXcSISISIISxIxSxxxxxSSxxxxxxJxxxxxxxxxxd#dwJtEtEtwwwH##LLLLLHxxxxtxtxxxd#dddxttttttttttttttwdddsvgQTTxxIIxIIIIISNkuuukEkkktxIH#vIIIIIIIINkuFFkktktttxIds#dddSNkuuutttttttId##HdMSVKKFFuNttxttxdH##sHHHHHHHHHHHHHHHHHHsHsHHsHHsHHHHHsHsHHcHHcHHXXXBnNN444444bbbf1otyEfrfbIYbbrff1oAbfojoAbYYYAroZYlbbAAmffAbZbb1poomf1mOyprfffjpoooyyifZlbZxIZfoAbfItDmlYx1yyj1xZ1iiDZZf1o1mmmfffoopojhppp1oAJJipotpDorAmfIlIAfbbrmbZIZbmD1rYlIbf1fIZxIZIImxZbZZlZbmfZIZblffAIblZfZbblZIO1qpbffllYYYO1rIbZfZZbZbbfmmxfZIZbZfbbbf1otyEfrfbIYbbrff1oAbfojoAbYYYAroZYlbbAAmffAbZbb1poomf1mOyprfffjpoooyyifZlbZxIZfoAbfItDmlYx1yyj1xRRRRRRRRRR",
"OOOOOOOOOObxZbYYbV1rYbrbbNNKxXXnxIxISxxIxxxIxSxxxxxSxxxSxxxxxJxJxxxd#dIJtEtttwwwH#zgLLBLzStNxtxtxtxxx#HwdwttttttJtJttJtJtsddHvvTCCdxJxIIJIIISKkuFukkkkkxwIH##IIIIIIdSNkuFFtttttttJId##dddINkuuktttxtxtId##HMIVNKuFFkxttttxxds##HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHsHHssHsHcXXX0VNN444444ZxZZfoopqZZZlIYwfAmrJfbbboptfbYIYZfrmYYIbfbmffrffooqp1bbZAfmDipZAbp1pojayimbZbbZIxoobff1o1ftmmEaaOJAfrjphfbft1toOkf1p1p1fftjpppDhpjipopporYb1bZfZbZxZZlZZbbAffrrbIlZffAxAblIllfZIlZZbIYffZZlZZAAffZrZZZbZIZlYfhiobxZbYYbV1rYbrbbZbZfZfmfZxbYIblbZxZZfoopqZZZlIYwfAmrJfbbboptfbYIYZfrmYYIbfbmffrffooqp1bbZAfmDipZAbp1pojayimbZbbZIxoobff1o1ftmmEaaOJARRRRRRRRRR",
"OOOOOOOOOOfmAbbIfD1AAxlbbWKKlXzIxSIIIxSSxIxxxxxxxxxxxxxxxSJxxxxxxxI#HwJttttEJdwd##gLLLLLSxxxxxxxxxxxtssdddJttttttttttJJttwdddz#TCT0SxIxIIJISlNuuuukkkktxJds##IIIdIIISKkuFFtktttttwId##dddINKkkktttttttId#vHnlVNkFFuktxtJxtxHs#sdHdHHHHdHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHscHHHc0X0MVNN444444ZxIZlxfZ1bIZblYAbIffAmfbbfbYbIYlYIx11fIYIfbmf1tpjDpDrtbZfZf1o1jEDtt11ypiiEmArrfAZforbZJE1oroEfiaafAAZboiafZAf1ofph1DDfff1JZittOtoyyp11OorbIbblIZbZbffZIbZZbbbZmYZlIZfbbZxZZYlIIlIlxxlbbbAbbbbZZbAZZZZxffZbZlIYEyyfmAbbIfD1AAxlbbbZbbbZfZlZYIbYIlZxIZlxfZ1bIZblYAbIffAmfbbfbYbIYlYIx11fIYIfbmf1tpjDpDrtbZfZf1o1jEDtt11ypiiEmArrfAZforbZJE1oroEfiaafAARRRRRRRRRR",
"OOOOOOOOOOj11lffOD1ffZZxxWWNcXMSIIIIIIIxIxSxxxxxxxSxxxxxxxxxJxxxxd#HwxtttttJdwds#vLLLLLIxxttxxxxxxJxxIvdddwtJttJtJtJttEtJJHddsvCTCTIxIIJIIIIxKkuukkkkkkxwds#sIIIdIIIVKuFFutttttttwdH#sddddNkkkktttttttwd#BcSVVKuuukNxttxtxwH##sHHHHHHHHHHHHHHHHHHHHsHHHHHHHHHsHHHHsHHHsHHHzBXXSNNN444444bZfZllZlIIZZAZZIbfbZbZIAbmlIbIbflZbboOmbbIbA1jipjJ1bAIpmZfbZff1kkjZboqiDffffbflIYlZbfAJmp1rfrJE1mIrbYboiDfZIfotmyaEpaxpotrZo1ODmlbboptrbArDDIIAtZbZblbbYIffZlIYZJZfxbZZfZIZlIlZm11fAbbxZbbbfmfZffAfArZZfZZZbIlZmqj11lffOD1ffZZxxZxZZbYbbYYIZbZZmbZfZllZlIIZZAZZIbfbZbZIAbmlIbIbflZbboOmbbIbA1jipjJ1bAIpmZfbZff1kkjZboqiDffffbflIYlZbfAJmp1rfrJE1mIrbRRRRRRRRRR",
"OOOOOOOOOODkhlAbku1bAZbfmNWS00IISxIIIIxIxIxxxxIxxxxxxxxxxxxxxxxxIzHdxtEtEEJddds##LLLgLHSxxxxxxxxJxxxxx#HdddtttJttttJJttttJddddgBTGTzxIIIJIIINKuuukkkkktxwd##sIIIIIIINkKFFktkttttxwdH#sddddSNkkktttNtttxIHcnSVNKuuktxttxtJxds##HdHdHHHHdHHdHHHHHHHHHHsHHHHHsHHHHHHHHHHHHHscLCXzNNNV444444bZxIYlllZbblfZfbAbbffbZJfmlbAbbZIbYYbtDbZbbboojtDpfAbb1OmZZfr1fjyyxZmpppfbbbAmIIYYIZJpErboAJooffbZAfftpDOofbAffpyypqDO1tbArDDt1mxx11oofUfkiDbZb1bxIYblYbbZZxbAbffbrbIbAmmZmmmmOtfbIbZbZrZZZoArArffAfffbfZZlxIYbf1DkhlAbku1bAZbfmxfIIZYYYIIlZfZbbbZxIYlllZbblfZfbAbbffbZJfmlbAbbZIbYYbtDbZbbboojtDpfAbb1OmZZfr1fjyyxZmpppfbbbAmIIYYIZJpErboAJooffbZAfRRRRRRRRRR",
"OOOOOOOOOOaaaxZxkD1obAbZIWWMXcSISISIIIIxIxIxIxIxxxxxxxxxxxxxSxxIzsdxtEttttdwwH##gLLLTzxtxxxJxJxxxxxxxxH#dddxEtttJttJtJJtJtxddHsBTCTCSIIwIIIIVkkuukkkkEtxwd#vHIIdIIIINKuFFkttttttxIds#sddddINkkkktttNttxIddSSNKkkkNtxtxtxxId##sHHHHHHHHHHHsHHHHHHHHHHsHHHHHHHHHHHsHsHHHHHHc0XClNNNN444444ZbZYIZZIllbZbbfYbbbmmZfAfbbrbbbZZYbIbbpbYblx1DEatmfZIrf11ffAff1mjaZfhffopZbbtDbZlYIfoyhpffoAfZbpZfbftDt1mk1ffmmjmOyif11of11ft11omO1ofoo1haEpfJZZffbZItIIlbffmt111fZZZxfbpffy1fAIIbZZxZbfAb1fZZffZbZAfofffrffZrtffaaaxZxkD1obAbZIZbllYIYlbIIZZffZZbZYIZZIllbZbbfYbbbmmZfAfbbrbbbZZYbIbbpbYblx1DEatmfZIrf11ffAff1mjaZfhffopZbbtDbZlYIfoyhpffoAfZbpZfbfRRRRRRRRRR",
"OOOOOOOOOOkaa1IOuofbbZZZZWVXXdIISIIxxSIISISIxSxSxxSxxxxxxxSxxxIzsdwttttttdwdd##gLLLLLIxSxxxxxxxxxxxxxxx#HdddtJtJtJttJJtJJJJsddd0CTCTHIIIIIISNkuuukkkkktJwH#vdIIIIIIINKuFFkktttttxId##HdddddxNkkkttttNttxSSxNNNNkttxtxttJwdH##HHHHHHHsHHHHHHHHHHHHHHHHHHHHHHHHsHHHHHHHHHHczXQX0NNNV444444ZbZAflbbbxbbbYYbZIIZfbrfbYIZbrYYIYIbbo11rrZbZZIb11fmpoAfffofZfopppofblZfjDoA1bbAAfotyDbAf1AfmZb1bbbxbfqhmfomxbZxfO11Zxp1ffZAx1mfZZAtfrtipEjfrlbbZbIYlYbAZZlfZZxfAffmAmZffffYZbYYYlIfIIYYZbZZZZfbZbIbbAfffbAZZIZfhkaa1IOuofbbZZZZZlYYYYIIlIZZmIZZZbZAflbbbxbbbYYbZIIZfbrfbYIZbrYYIYIbbo11rrZbZZIb11fmpoAfffofZfopppofblZfjDoA1bbAAfotyDbAf1AfmZb1bbbxRRRRRRRRRR",
"OOOOOOOOOOZaapZmkmrbAxZZbVcXcIISISISISIISSSSIISSISSSSISSxSSxIcsddtttttttwIds##LLBLBcxSxxxxSxSxxxSxSxSxxd#HddwtJtEJtJtJtJJJJJHHd#0TTTTcSIISISNkuuukkkEtxJIH##MddddMddKkuFutttttttwdH##HHHHMMMSNkktttttttNNxNtxtNtNtxJtJJwds#HHHHHcHHcsHccHcHcHcHccHcccsccsccccsccHcccsccczXXXSNzNNV444444rxZZbZxffbZZbIbZbbbZJbAbfYYIZrZIYbbAr1tDfbxrfJAJkOxpffm1ofm1bZtptOfAobffojDotfZbbftDahffIfx1off1bAfffDyD1mmVZbZZfo1ffxmfbbfZbZxbIffoo1pyPqtApZbZZbYYIYbffbxmbZfmbIZxfIIAAZfxZIYIlbYYblIZbIfIZbfZZZbZffrZAIZlbbflmZaapZmkmrbAxZZbmxZYIIYYYZZbIbZmrxZZbZxffbZZbIbZbbbZJbAbfYYIZrZIYbbAr1tDfbxrfJAJkOxpffm1ofm1bZtptOfAobffojDotfZbbftDahffIfx1off1bAffRRRRRRRRRR",
"OOOOOOOOOOYyyybmmmrZmofbfSzXX000000B0L000X000Lz00000LL0000v0#sdwtttttttwddH##gLLLLCL00CL0X0000C000000000zHdddtJJtJJJtJtJJJJJwdH#00CTTTTL00BSKkuukkkkkkJwIs#v0000zz00kKFFktktktttIIH##L0z0X0zcxNttttttttttxttttttttttJJwdH###000BL00L000X0X000zL0z00z0#Lzz00z0L000000XL#0XXXCNNzNNN444444ZZlbmbmmZAZYAbbIYbbAoZIblYYIfoYZbAZlbA1qDOOkOODfyyy11xomff1xfZpf1mbrfAxZrp1op1fZbrooaDtmlff1o11fp1jDOm1SmOmOlIZllffx1lIbIb1IZbmAbr11tyiyaobbpfJZZxIYlbIxZZofbbZZlZIAoYlZlZxZYIffAlbYfbAlIZmZbbAfIIbfZZZbIIYbmm1IYYyyybmmmrZmofbf1ZIlYIYIYbZAfbZfZZlbmbmmZAZYAbbIYbbAoZIblYYIfoYZbAZlbA1qDOOkOODfyyy11xomff1xfZpf1mbrfAxZrp1op1fZbrooaDtmlff1o11fp1jDRRRRRRRRRR",
"OOOOOOOOOOYl1ipfDfrAAbfffSnnnnnInnlnnnnnnInIznnnSnInIzIIIIc#sdwtttttttxddd##vLLLLCBcInzzSnISInSInInSIInSc#dddtttJJtJJJJJJJJJxHdHv02Q.e..TnnVNkuukkkkEtxwds#HIIIIdMIlkuFFkttttttxIds#H#InInInzIxttttttxtttttxtttJJtEEJwdH##MMnnn0MIMIMnnnnnInnnnnMInnnn0nnInMnnnnnnnndBIdMnnSNNzNNN444444ZZxmfAmZZbIrrfbYYboobYYbmZIYr1rfZYYIZxbuukJAoZxfOppfAfmrbZ1AIboAbrfbbfofmopppfbbrtiattp1Zb111mxmrrfooomfotpkZIlxZfZffDffx1DZmff11bffooofbfAZZArbfbZZZZbbfbZbmblIZIflllZxZZZIxZxZbYIYfmfIYAbblfZlfrAZIYIbbffoIAIYIYl1ipfDfrAAbfffbZIYYZfxf1lIlxmmZZxmfAmZZbIrrfbYYboobYYbmZIYr1rfZYYIZxbuukJAoZxfOppfAfmrbZ1AIboAbrfbbfofmopppfbbrtiattp1Zb111mxmrrfoRRRRRRRRRR",
"OOOOOOOOOOlIZ11tDtrfrfAmfWWWKKKKNKNKWKKKKKKNcNKKWKKKKHKKxIzcdwJtttNtttddd###LLLLLBCzSxccNNKKKKkKkKKKKKKKx#HddJtJJJJJtJJJJJJxJdHH#v02e.GGTCnVkuuukkkkktxwdsvINKKNKKKVkuuuktttkttxwds#zkNNKNNKzNSStkktxttttttttEEEEEJJwdss#xKKNKNzNNKNKNKNNNNNNKNKWNWNNNzNNNWNWNNNNWKNWNzNNKWNNzNNNV444444fmmZfZffZZr1fZIYYbf11bZItmYbmmmZYYYYZZbkukAxAr1Drbr1ffAZAAZIbJ1fp1mo1ooZff1jtpfAryayEjpoffDmOmxfooApppDofAJOxlIZlZxAZyfxfmfxbxZbmbZfAxfrf1xZZo1bxZxbIbZZfbfbtZIYIAZIYIZxZZIbbbfmfZbYZlmxbfZZbZbZx1frbIYboDmmZZlYIlIZ11tDtrfrfAmfZIlIYYYZbZmZZZfmfmmZfZffZZr1fZIYYbf11bZItmYbmmmZYYYYZZbkukAxAr1Drbr1ffAZAAZIbJ1fp1mo1ooZff1jtpfAryayEjpoffDmOmxfooApRRRRRRRRRR",
"OOOOOOOOOOlbbZyyaofJrffIZNWWKNWNWKKWWcKWWKKKcKKKKWKWcHxnHzsdwJtttttttdddd##gLLLLLLBBCgLBLLBcxKHKKkKKWSdzgzsddtJJtJtJJJJJJxJxJxsHHg#B2GGGBBcVKkuukkktEtxwd##SKKKKKKKNkuFutttktttxId#vzzKkNNNVckVSNNuFFuttJtEEEEEEJJwdds#I#NNNKNKNzkNNNNNNWWNNKNXKNNNKNNNzNNNWNzNNNNNNNNkzNNNzzNNNNV444444foxZxbAZZfffIrYIbft1mbbZIAfbmuumIYYYYbZDuumfb1DbZboofoffAAbbJ11op1mmDyfb1ofypoorEyypipofm1VVOmmooftff1k1rofofZZlbfbbfmfmx1ZZZbbZb1bbfAffo1ZIZmbfZffmfZZfZZbZ1mbYZZfZIfZYbllxllZIlAlbYYlobbAfZAIfA1oZZfIbmmlbIdYYYlbbZyyaofJrffIZIbZZlblYlYAZZAZmfoxZxbAZZfffIrYIbft1mbbZIAfbmuumIYYYYbZDuumfb1DbZboofoffAAbbJ11op1mmDyfb1ofypoorEyypipofm1VVOmmooftfRRRRRRRRRR",
"OOOOOOOOOOYbYIaaapofAZbZZWKKKKKKKNKNKKKKKKKcKKKKKKxSnB#zcHdwJtttttttIdddd#gLLLB0gB0LBgB0B0CLxkkkkKxdzgLBg#sddJtJJJJJJJJJJJxJxJwHHsv00TQCCCcNkuuukkkEktxwH#vxNKKKKNKVkuuukttktttwIH#ssNKNSInMSNVVNkFFFkttxwJJJwJwwdds##SNztNWNWNNzNNkNKWNKNKNNNKNNKNNKNNzKNNNKNNNNNNNNNNN#zzzNNNNNN444444fmIZbmffrAfbZIbYrA11Dk1ZbYYbmuArfUIAAAYb1uhpooxb1AbbmZfott1pjfpbbbfoDpED11rpoJjiiyyaiyDmmmONu1rrooopooOfr1offAbZbJaDDfofp1fxfxZxfIfbAffpffD11YlbZfofIZZZZZZfZfmbZIxbAfZZZbYYIbZlYZZfYIb1prZbfbZbbZAft1mZYbbbIbIbYYbYIaaapofAZbZZfxbZYbbbYbZZbbmmfmIZbmffrAfbZIbYrA11Dk1ZbYYbmuArfUIAAAYb1uhpooxb1AbbmZfott1pjfpbbbfoDpED11rpoJjiiyyaiyDmmmONu1rrooopRRRRRRRRRR",
"OOOOOOOOOOYYYIkaa1frbIZIbVNKKNKNKWKKNKNKKcKckKxSIz0z#zzsdddxttttttttddddH#v#000BgBgB00BBBCCLNKKNSd0000zzzzHddJJJJJJJJJJJJxJxJxJHHHs##00B00BBMINkkkkkttxwH#gNkKKKNkKVuuuuNttttttwdH#dcxnMMllSnNSNkuFFuNttIddIwdddHs#HIxNKKzNNNNkNzz#zzNNNKNNNNNNNKNKNNKNzkNNKNNNNNNKNKNNkNNNNNNNKWW444444fZIIbfArfrxAbZAYf1pf1ukobIbUImbbrbbZZrIbfayjrxbAbrIbo1ppEj1o1ZtAbbotmoojEDtiD1aiypEiEytDmf1mDpffmtDpoo1Offffxftopjlbo11A1rmfZZJAbfmrZbfp1bfrbblYZfAffIxAbbbfIYffIYYYbxbZYYlbffIIlAfllllfDfrAxZbIbrAtOmYYYYIZlIlbYYYYIkaa1frbIZIbYZIbbZZbAZZZIZrffZIIbfArfrxAbZAYf1pf1ukobIbUImbbrbbZZrIbfayjrxbAbrIbo1ppEj1o1ZtAbbotmoojEDtiD1aiypEiEytDmf1mDpffmtDpRRRRRRRRRR",
"OOOOOOOOOOYYIYfkaiprbZbfmWcWKcWNcKNcKcKKcsczzczzzzzz#zHddwJttttttttJHdddH#zzzzzzzzzz0BLLCLL0KkcszzzzzzzzzHdddJJtJJJJJJJxJxxJxJxsHHHHz###z#zzzz##kkktExwIH#scKKcNkcNNuuukttttttxIds#zHMnSSSVMcclNKFFFktttwddIdHHs##vSNzKNzzkNNzNNzNNzWzzWNzNNzKzNKzWNzNNzzNzNNzKzNNXNWXKNzNKzNN#NNN444444mAZZZZZZZbZbZJZbropj1DkkArIYUxrrrAbfbZZfppjOoAJZIbYZf1qiDDr1bAr1rfp1off1kDDDfZoia1D1EiyfAbbfooA1o11111OkEfbIftAayfbZ1xfftAf1bfZffffDbb1yk1ZmYZIbIfflZZffbxZZlYImlYIblZlZZYIZmxYllffZIAIIlZZbfrfopttOZbxblZZbZbxlYYYIYfkaiprbZbfmbZYIAbIblIbZZZmZmAZZZZZZZbZbZJZbropj1DkkArIYUxrrrAbfbZZfppjOoAJZIbYZf1qiDDr1bAr1rfp1off1kDDDfZoia1D1EiyfAbbfooA1o111RRRRRRRRRR",
"OOOOOOOOOOYYdYbr1aaqJfff1WWNKWNKKKWKNKNKKcsz#z#cssHHddddwttttttttttJHddddHHsssszszzz#LLLLBLMHNHzz#sssHHHdddddJJJJJJJJJxJJxJxJwJxsHHHHssszz####0HkkkktJxds#HkNkNKNNNNuuuktkttttxIds#MIllVVNVscVVNkFFuttttxIxSSIIMHczBcxKNNzNKNNkzkNKNKNzNkNKNWNKNNKNNKKNKzNNKNNNNNNNNNKNNNNNNKNNWNV444444fZZbrZbIbYbIbIlbbbAffZrOkq1bIbt1bfAIbf1rAfop111tbfof1ppjyjOfZbb11ArAr11m1yambZxmfmoiaqyDtr1oprbbbriy1ttDtmfZxDiooZbZbIZfpfkp1frfAt1AZbZ111IlfrbfAIbbfbZbZffYZfbZrZIYYbZIZmfxfxIZfbbImZfbY1rxftmxZZlIbYbZfJZbYYIIYYYdYbr1aaqJfff1mZZIblZlYxbZZmmmfZZbrZbIbYbIbIlbbbAffZrOkq1bIbt1bfAIbf1rAfop111tbfof1ppjyjOfZbb11ArAr11m1yambZxmfmoiaqyDtr1oprbbbriyRRRRRRRRRR",
"OOOOOOOOOObYYYIbbaaaoooZfWWWKNKKNWKWKKKKNszzzHdddddddddxttttttttttttHddddddddddddd###LLLLCCIkczHdddHdddddddwxJJJJJJJJJJxJxxxJxJJxsHHHHHHHHsHHvgIktkktxwds#HKKKKKKNNNuuutttttttwwd#MSVVNVNNd#cnVKkuuutxtxxtxxSSSSIMMcz0zVKzNkNNzNNNNKNNK#NNNKNNNKNKNNKNKNNzkNNKNNNNNNNNNNWNNNNNNNWN444444ZbfxfZZbllYblbIrrIbbAZbfOkDZYIrfAbfZ1oAbZryobkkpptDEEiEpypoAbbbfrffJAo1tfqaZffZZxfjyjD1jDffforAfroEahqt1fbff1ayffbIIIblftAmO11Ato11fZIfmxmAbAfAAbIYZZZZZZZZZbIYIbZIYYYYIIlfotmfmAZZZmAffbt1o1mbbYYYZflAZbbZIbIYIIbYYYIbbaaaoooZfZIYxYIlbZJroffmxZbfxfZZbllYblbIrrIbbAZbfOkDZYIrfAbfZ1oAbZryobkkpptDEEiEpypoAbbbfrffJAo1tfqaZffZZxfjyjD1jDffforAfroEaRRRRRRRRRR",
"OOOOOOOOOOIYYYbbbDaaoArZZNWKWKNKNKWKKcKKNcszzdHdddddwxJJtttttJtttttttxwddddHdddddd##LLBBCBBxkc#ddddddddwwwJJJJJJJJJxJxxJxxJxxxxwxxwdHHHssHsHsBgSkkkEtxwds#INKKKKKKVNuuktttttttxddISxNNNktSHzMSSkkuuktttttttxxxSSSSIdccz0czNNKNzkzNKWKNNzkNNWNKzNNWNNNKNNNzNKNzNNKKWKNNNKNWNzNNNWNN444444fZmmlIZZYYYIxYbbIbZU1IbZfmkoZIbIZZZfprblbrDDrmOppppppppopoofZZfbro1f11t1fm1offZYYiapp11pE1AoJbbpYroptqftrjffykfxZfZZIlIft1mNm1f11bf1lflZfmo111ffbZIrZbfbbZfrZbIrZIlllbIYfrAIZrfmlAxAAboopfD1mxIlYIZfAlbbZbAZZblZZIYYYbbbDaaoArZZIZZZbbbZZfffmlllfZmmlIZZYYYIxYbbIbZU1IbZfmkoZIbIZZZfprblbrDDrmOppppppppopoofZZfbro1f11t1fm1offZYYiapp11pE1AoJbbpYropRRRRRRRRRR",
"OOOOOOOOOOllbYbbbAoty1fblWWKWKKWKKWKKNKKkczzsHwJxJtttJttJttttttttttttJttttJtJwHddH##LLCCCLCNkzsddwxJJJJJJJJJJJJJJxJJxJxxxxxJxxxxxxwxxwxxwHHHsgvxkktktJId##SkKKKKKKVKuuktttttttxISNNNNkkNNdHzSVNkNukkJtNtttttxxxxSSISIdMczLSNKNzNNNNNNNk#KNKNKNNNKKKNNWKKNzNNKKNNNNNNNKNWNWNNNNNWNN444444rZfZxZlYbIlYYYYUYlroZIbbJrfaDfbUYfppbZZbbbfo1mtpEiytpDEppfAbbZIbf1o1p1o1foOrofiyyI1mlfofboopppq1IZItEibfbAffbbbZxmmfZlbImfAfblmArffxmmfbAoAZbbAffrAfmAAbZfffAZbbZZbbb1mmmOmm11omZ1mofDiajyDOxxflbZIfZIAffAbbfbIblllbYbbbAoty1fblZZZZYbbbbbAAbZZfrZfZxZlYbIlYYYYUYlroZIbbJrfaDfbUYfppbZZbbbfo1mtpEiytpDEppfAbbZIbf1o1p1o1foOrofiyyI1mlfofboopppq1IZItRRRRRRRRRR",
"OOOOOOOOOOlYZZbrrZf1kjJbZWNWKNKKWKWNKKKKNcc#HHxJtttJtttJttJtttttttttJttJtttttddddH#vLLLBLLctkzzddJJttJJJJJJJJJJJxJxxJxxxxxxxxxxwxwxxwxwJwsHs#vLtkkkEtxwH#vNNKKKKKKVNkkktkttttttxxNtNktktxdHdNNNkktkttttNtttttttxxxxSISIMMcXNKNzNkNkKNNNzNNKNNWtNWNKNNNNNKNzNNNNWNKNNNNNNNNNNNWNWNN444444ZAfbbZlYlYbYbdbYYIfmrYlIIrbkD1ZbYpobZbbbboroqbo1of11otpoporbxZrZA11O11ff1f1ooiDmIlffZJo1fboiipbrbbffoiboffmfZZfffZZxbIblmNfZZlOmfoo1IxAfbftfZZbAfAZA1ffxAfbbbmmbJo111mlZlZxlf11ytootpqDP1fOmmbfblZYflbfA1IbbAbbZZlYZZbrrZf1kjJbZbZbIbbZIAZZZlZffZAfbbZlYlYbYbdbYYIfmrYlIIrbkD1ZbYpobZbbbboroqbo1of11otpoporbxZrZA11O11ff1f1ooiDmIlffZJo1fboiipbrbbffRRRRRRRRRR",
"OOOOOOOOOObZIIfmmxZraaDfoNWWKKKKKWKKNcNKNcz#HHdddddddddddddddddddddddddwddwdddddds#vLLLLcSNKc#HdHIddddddddddddddddddddddddddddHdddddHdddHHss#gHkktktJJwH#skkNKKKKKVNkkktttttttttttNtkNtxIdHNkkkkkkkttttttttttxtttxxxxSSIIMczVNkzzNNNNkzkKNNNKKzNKNWNKNNWNNzNNzKNWNNWNNNWNNKzNNNWNN444444ZffZZfIIIbIIYYbIIY1ZfbbbZZZ1NOfbforbbIbZbfAribrA1Ibtoofp1ZArfJ1rfftjf1fr1fbppibZbxZffZfbfr1pi1o1rrtArEAfmmfZbIfmmfbZIAxZVkOIYIZxmxforfbOffmfIbZZbfArffZbAZZxffbAfDmIlYIIllIxZfmOmDh1mOfmZZblxZZmbZlZxYZZxxAZfAIZZbZIIfmmxZraaDfomxlbfZIYbllbZxAxZffZZfIIIbIIYYbIIY1ZfbbbZZZ1NOfbforbbIbZbfAribrA1Ibtoofp1ZArfJ1rfftjf1fr1fbppibZbxZffZfbfr1pi1o1rrtARRRRRRRRRR",
"OOOOOOOOOOAbbAIZSbfkaaaZ1VKNWKNWKNWWNKKNkcz#HHsHHHHHHHHHHHHHHHHHHHHHdHdHHHHHdHHHHz#BLLHzKKkcx#sHHHHHHHHHHHHHHHHHHsHsHssHssssHsHsssssssssssssvBdkkkktJwds#HWkNKKKKKNNkkktttEtttttttttttttIdSkKukkkNttttttNtttttxtxttxxxSSIIMzzNNKztNkNzKKNNKKNNNNWKNNWKNNNNzNkNNNNWNKNNNNKNNNNWNNNN444444frfbAxbIZYIYUbrbrAZbbIAfZIbbZbDoAbbrrfofJiDppmbJbbrfppDpofpDrbbAopff1AopijEmffbbZbZft1fxZrobborrmffoopZZfmr1llxDOxmfAqDmOfAbbZxO1mmlufffoZfZZZfxAZZfZfxZlIZIIZImIIlIYflYlYbbflfbIbZlAbZfbZfIIIZZZlIIlZIIIffAf1fbZAbbAIZSbfkaaaZ11ZZlZbZlIZfbffmmfrfbAxbIZYIYUbrbrAZbbIAfZIbbZbDoAbbrrfofJiDppmbJbbrfppDpofpDrbbAopff1AopijEmffbbZbZft1fxZrobborrmffoRRRRRRRRRR",
"OOOOOOOOOOfrfZbZmbmDua3ffWNWKNKNKKKKKNNKNcS0#vgggvggvgvgggggvggggggggggggggggv#vv##LIxkKcHcKS#vggggggvgvggvgv#ggvggggvgvggggggggggvggvgv#vvvvgxkkttEJwd##SKKKKKNKKVNkkktttttttttttttttttwduuuktNtttttEtJttNtxttxttNttxxxSIIczcNNkzz#zKKNNKNNKKNKNNKKNWNNNkNzNKNNKNWNWNKNNNKNKNNWNN444444ZZmxZxIZIbYIYfZDpobbbbbAZAbfm1orrIUAotorpDpopZr1fffbbojpo1oibIbtoyf1oiii11fAfxfbbot111ffff1obfEt1AApjpfbb1foIllfOmkOfkkZffIbZfZl1bfm11fffoAmbZbZZZxZffZIIbZZIYYYIYZbZmxIZxImIYZZZbZYfffmrIxYIxlxxYZYYbYYIZfbo1frrfrfZbZmbmDua3ffZZIZIYIbZbAAoZmmZZmxZxIZIbYIYfZDpobbbbbAZAbfm1orrIUAotorpDpopZr1fffbbojpo1oibIbtoyf1oiii11fAfxfbbot111ffff1obfEt1AApRRRRRRRRRR",
"OOOOOOOOOOAfbfbZfmkaDa3jfWWWWKNKKKWWNcKccczSSSSSSxzSzSxSSSxSSSSSxSzxxSzSxSSxxSSSzSSxKKKKKKKKNScSSxxSxSxxSSxSScSSsISxSSxxSSSxzSxxSxxSSSSSSSxxNtNkktEtJwH#vNKKNKKKKNKSkkkktttttttttttttEEEJtFukttttttEEEJJtttxttttxtttxttxxSIds0INzNKNNNNKNKNKNNzNKNNNNNNKNKNzNzNNNWWWNWNNWNN#NNNNNN444444mxZxZllbZbAYUoYjijorZbbZZbffpoborYUwforZbYDoEroD1frbbfpppo1pAbJijiropah1ff1xfmAfAo1offxffbffAJ1o1ofipEmbff1tZZIZxZm1tZZZZZbIZbZIlZbIZmZxfmtDZbZZbIfZbZZbbbfblYYYlYZZZbZZbZbZZbmbZZxxfmAfmffZlZbx1bbUIbbYlbZZ11oAbAfbfbZfmkaDa3jfrbbZYbbZZAffmblImxZxZllbZbAYUoYjijorZbbZZbffpoborYUwforZbYDoEroD1frbbfpppo1pAbJijiropah1ff1xfmAfAo1offxffbffAJ1o1ofiRRRRRRRRRR",
"OOOOOOOOOObbZbbbmOOxNDNDDNWNNKNKNWKNKKcKckNcKKWKKWcWKKKKWKKKKWKKKKKKKKcKKKKKKKKKHkKKKKKkKKkKKKKKkKKkKKkKKkKKKKKkKHkNKkKKKKKKkKkKKKKKKKKKVNKkukkkkkEtJIH#HKKkNNkKKKkSNkktttEtttttttEEEEJJkFFukNtttEEEJwwJxtttttttttxttxttJxwdM#LxNkNNKNKWKWNNNKWNKNKNKKKNNNNN#KNNKNNNNNNNNNWNWNWNWV444444AbbIYYYlIYYYrofZYYZxf1rbrfApAZrfDofYUbbZbAroEfoAfofZbIopopppiiyypijj1o1pmlIb1mZZbppDfmx1fffJoff1bZ1oopxffbo1ZZfIYZIZZllbIfZIbZlYIfflIlAfoObbZZxfbZbbJfbbfZxmlIYYIYbZZIYllZlZfZffImmffrxZbfZZZYYIIfZblYIYYYYIIbbYbbbZbbbmOOxNDNDDoyahbfAbZbAAZmffAbbIYYYlIYYYrofZYYZxf1rbrfApAZrfDofYUbbZbAroEfoAfofZbIopopppiiyypijj1o1pmlIb1mZZbppDfmx1fffJoff1bZ1oRRRRRRRRRR",
"OOOOOOOOOOZIYbIlZmZxAOOkjWWWKNWKVKWKcKKNkKNKWcNWKKcWKWKKKWKWKKKKKKKKKKskNKKKKWKKkckKKKkKKKKKKKKKKKKkKKkKkKKKkkKkscscKKkKKKKKKKKKKKKKKKKKVKkuukktEktJwd##xKKKKNKKKNNkSxNttJJJJJxJJJJwwwuFFuktttttJwddsssIxxxJtxttttttttJxJxtIdHzgkKNkKNNNKNNNKNKKNKKKNKKNKNNNNzNk#N####zzNKNNNNNKNN444444ZZZIlIYbZIYIfopUYYYbpD1ZbAfobZbbr1fbbbbbr1frpf1J1ffZbbtipiiip1DrppfbAoopfYYlbZfffopj1m1xffr1offJbbrfo1fAfImDrrfZ1oZfxlbbIZfZbIbYbffYZYb1mZfbIZZZIZIYIlZmfbxZlIIYIbllZIYbIbIZfAfxZZffmmxZZxbbZbbbbmxYIYbIbIYIYYYIAZIYbIlZmZxAOOkjpmfofofZbIIbbmmfZZZIlIYbZIYIfopUYYYbpD1ZbAfobZbbr1fbbbbbr1frpf1J1ffZbbtipiiip1DrppfbAoopfYYlbZfffopj1m1xffr1offJbbrfRRRRRRRRRR",
"OOOOOOOOOObZYYYIlrbZYbmDDNWNWKNNKWNNzNNKKNKKKcKNNcNKNKNKKKKKKKKKKKKKKkcKkKKKKKKKkckNkKNKKKKKkKKKKtKWtKKKkKKKKNkNkccskkNKKKKKkNKKKKKkNkNNNNkuuEtkktEJIHzHkKNKKNKNKKKWSIIxxxxxwxwwwwddHdFFFkNttttJwdHs#IxddwxxxxJJttttxtxttttIdHs0SKKNNNKKNKKWWNNNKNNKNNNNKNkNK#NNzNNNNNKNNKNNNNKNNx444444ZIbIZZZbZYYIfArdYIbbporrxfprbbbAboAIfAbroAooofArffbAfriyiyipo11roDAfoop1xfxlZImffotDZZAfbbZffZbYffxAfAbbfZftfJfykfbZfxZlbZ1IbflmZZfxfbbmlfZlbrZIbZYlZIbZmmfZblYYIllbIbZxbZbYZZZZAfxxAxZfbZbYxbrZZZAbYYfZZlYbIbYYIbZYYYIlrbZYbmDDpooAAmfbZZIZbZZZZIbIZZZbZYYIfArdYIbbporrxfprbbbAboAIfAbroAooofArffbAfriyiyipo11roDAfoop1xfxlZImffotDZZAfbbZffZbYffxARRRRRRRRRR",
"OOOOOOOOOOYYdYMImYIbbAlbjVzWWzWKzWKzczKNzKWzKzcKKzkKcKKKNcKKcKKcWKcKKcckckcWKcKKcsNsKNcKKcKcKKckNcKKcKNcKKKcKckksscsNkcKKcNKcKKnncWKckNINKkukkktEktJds#ScKNcKKcNKzKKKSdIIIwIIIddHHs#ItFFkttttttJdd##IKzNddIwxxxxJxttttJtxtxxIHs##WNzNNzNKzNKzNzWNzKNzWK#WNzNk#KzNNzNkzNNzNKzNKXNNN444444mffAZbxZIIIZbUAdYIbbbZffoApAfomYb1pobJoo1ArfAZxrrbbopyDoooyatDDpAIoootopZllIZZft1ip1Zxf1fb.ZJbffxrrIb1IbfIbxZZxf1AIxfIZbffxZIZlYYxZxbfmxfZZYlZmZZrAYlYIZZIIZZZIlYIYlZIYIZfbZxZIZfl..ZZf1fAZffbfZbIZbbZbZIlYYZbZIIYYdYMImYIbbAlbjEhmrfZZfxfbfZrfmmffAZbxZIIIZbUAdYIbbbZffoApAfomYb1pobJoo1.rfAZxrrbbopyDoooyatDDpAIo..topZllIZZft1ip..xf1fbmZJbffxrrIRRRRRRRRRR",
"OOOOOOOOOOIdYYUIxYYbrbZboWWKKWKNWNKWKzNKKKWKzkNKNcKNKWKKKKWKKKKKKKNKKNcKNKNKKWKKkckWKkKKKKKKKkKKKKKKKKkKKKkNKNKKKksskNkNKKkKKKKcc4zcSVKVNkuuktEtktJwd#HNNNKNKKNKKKNKKKNSHHHHHss##HdINKuuktttttxwdH#sNNKNNNIHdwJxJxtttttxJtxJdHsvIKNkNNNNNKKNWNNNKNNKWNNKKNNNNKzNNNNNNNKNWKWNKNNWWN444444mxZfbZfZbZbbfbfYYIIfZYfjfbf1otrbIrtorooofb......rfriaafAfEyapjkDAbfff1o1xlxlxZ..DjkkfmffZ..bfbffAbbbrDbIJr...fob1p...rbI.....IIIZ....1llZmfZYlfxAZ...lYIx...IZfI.....lI.....ffbZZZ..obZmfffAZrffIbbIZfbZ......ZIbIdYYUIxYYbrbZbo1DOf1xbr..ffZA11......fZbZbbfbfYYIIfZYfjfbf1otrbIrtorooo..oobbZxrfriaafAfEyapjk..bf..1o1xlxlxZfoDjk..mffZIfbfbffAbbbRRRRRRRRRR",
"OOOOOOOOOOYYYYMlZIbbfoffZWWWNNKWNWKNKKzNKNNcWNKKkcNKWKKNKWNNKWKKWKKNKKcKKKKKKKKNKsKKKKKKKKKKKKNKKKKKKKKKKKWKKKKNkKcsskNkKNKKKVxnMcccc4cVKkuuktkktEJws#INkkKKKKKKNNKKKNkNkNSSSxSzNkNVNkuktttttttIIH#skNKWKNNkIddIxxtttxtxtxttdds#HNNNkNNKKNNKtNKNNtNNNKKNNKNNNNzNkNNKKNNNKNNKNKNNNN444444IbxJbxmZfbZbfZmYYIZbbx1o1AZo1orbYfoabroro..ffZ..AroyaOfffjiApyD1ffff1fAxlIZImf..ymDpIAIbZ..f1ffAxYr.tyZYZf...Zff1..E..f..mm..YYY.....mbxfOZZIZlZZI...YYl..b..bm..Zm..Z..II..ffZbfx..1oxoAfAffD1orZIZbbb..bZZ..YZYYYYYMlZIbbfoffZfDkOo1Zf..xZbfm..bxJ..mZfbZbfZmYY.Zbbx1o1AZo1orbYfoab.or..AffZZmAroyaOfffjiApyD..ff..fAxlIZImfJpymD..AIbZfZf1ffAxYrrRRRRRRRRRR",
"OOOOOOOOOOIYdYdIZYlZIlZbfNNNWKWNWNWKKzWzzczWKNKKNzNKzKNKNKKKKKKKKWcKKKcKKWKKKNKKccKKKKKKKKWKKKcKKKKKKKKKKKKKKcNKKKksskKKKKKKMNNlSInnncMNKuuuktkkEEJH#sNkcKNKWKNKKKKNkNzKNNkNkNKNczcINkkktttttttwdH##SKWNKKkNNNIdIxtttkxttttJIHsvvNKNNKKNNNNNNNzNKNNNKNNKKNKkNzkNNNNKNNNNNWNzNNNKNN444444lIlkuOZlZYYbYfAlblIf1AAAbxmOmtZrxbfboooo..bfoZb.pyi1ff1rbiqfrOqofbpfAfZbbZfZffAr1jofZbxfb..fft1mff..ofYYbf...1ff...Z..p..ZY..lYI.YbxfZZIbb1ZZIZZZb...Yl...I..mZ..xZ..Z..ZI..ZfbZZA..ffZfooomfAfZf1fbfZl..IYIY.bIlIYdYdIZYlZIlZbffojkOfrxZfYYIlZ..Ilku.ZlZYYbYfAl..If1AAAbxmOmtZrxbfb..oo..bfoZbrpyi1ff1rbiqfrOqofbp..fZbbZfZffAr1jo..bxfbZAfft1mffmfRRRRRRRRRR",
"OOOOOOOOOOYYYYZIZIbZZbf1AVWKNNWKKKNWWKNKWKKKWKKNcKKKKNKWKKKKKKKWKKKNKKckNKKKKKKKKkcKKKKKKKKKKKKNKKKKKKKKKKKKKKkKKKKssNkNKKKNVWKNVVxSSIVkkuuktkktEEws#INNkNKKKNKKKNKNNNKNNkNNKKNkNNNNNKkktttttttwIds0TcSWKNWxSSnSSNNkkttxtJxxdHs#INNkNNKNtNKNNNNkNKKKNNKNNWKNNKNNNkNNWKNNKNNNKKNNWN444444lZImOlIYYbAfIAfIYY11AZfrOOmYYmZA1lbf1yp...bbfAboaD....ZbI.....y...A..rr.....Z..p1j.....f...f..1f....oJIZbf...poZ..bf..D.....bYI....IxZfZZfmfIZZIZZ...Yb..Yl..xx.....Al.....1ffZff.....fm...o..AJxbOrAbb....ZYZZ...Y..ZIZ.....f1A....hkf...bbZZf....mOlI...A..A....11.....Om......l....p...b..Aboa.....Z..y..JD..oI.....fbx...o..1j...bffbxbft11f1o1rRRRRRRRRRR",
"OOOOOOOOOOlbbIZbZYlIfmmfrNWNWWWWNKWKKKNKKNKWKKNKzKKNKKWKWKWKKKKKNKKKNkcNKKKWKKWKKKcKKKKKKKKKKKKKkKKKKKKKKKKKKKKKkNKNsccccKKVKKuKkNNNVVNkuuukkktEEEd#sNkkNkNKKKKKKKkNNkNkNKNKKKNWkNkVNKkktttttttxIdHz0T00ccncnnSVVKkFuktttttJdH##xkNNKNKNKNKNtNKNKNNNNKNKNKNKNNNz#zKKWNKNKNNKNKWNNN444444ZlZmZZYYYZxZb1YlYxAIbbbmmfmbIfZroZZorDa...rA1ooih..fA..Zr......o..f..1b.....A..ho..p..bx...o..1tm..bloIIYf..ptfI..bZ..iy...ZZIZ.....foobZxb1lZbZZf..lIZ..IY..Ylb...ffIY...ZbbfZff...m..fZ..1..AfZ1ff1mZI....IbZ..lb..ZbZ......f..AA..km..ZZbxlZf....ZZY..Zx..1Y..xA..b...fm......ZZ..Da...r..ooi..f...J..p..fE..1Z...1..bZ..Ao..oE..AZbxZffojf1tmotbRRRRRRRRRR",
"OOOOOOOOOObZZxYImrffIblflWNWNKNWKKNWNzKNNNKNKNKKcKKKcNWWNKKNKKNKKKcKKNckNKKKKKKKcKcKKKKKKKKKKKckKKKKKKKKKKKKKcKKNkNkckNKNcVKKuFkkkkNNNNuuuutEtEEEJs#xKKNcNKKKKKNKKKKKNcNKNkWNKKKKKKNVkkktttttttJwIddcczzccMnnllVNKFFukttxJJwdH#zzNKNKNKKNKNNKK#KNKNKKNNKNWNNkzzkNNzNNWNWNNN#NNNNWN444444lIlmmIllYbArfmfo1bbbbmZbfffbbbfAbZffArb..popijfZf..bZ..bY..r...o..ff.Jf...Zff..o..om..rf...t..Zf1..rffjEp1..p1xl..Z...r.....ymfmYf..ZZbrZbxZfZbZlb..lfI..l...YZ.....Zx.....bfffff..ff..ff..o1.fffbZZYxfxZ....YI..bZ..YIm..f...f..bZ..DD..AbbZflIl....Il..bA..mf..bb..m..fff...f..Zf..rb...o..jfZ..b..bb..fm.Zr..1f..oJ..AJ..fp..ff..ffrffm1tE1Zf1forRRRRRRRRRR",
"OOOOOOOOOObbYIbbkmxZIlYIZVNNNWKWKWWWWKNKNKWKWKNNcNNNWWKKKNKKKKKWKNKNKkcNKWKWKWKNKkcKKKKKKWKKKKKKKKKKKKKKKKKKKKKKKKkcNcNKkNNKkuFkkkkkkktuuukktEEEEw#dNKKKKKKNKNKKKKNKNNKKKKNKNKKNWKNNVNkkttttttttwSIIdMnMnnnSlVVNNuFFutxJJJtdds#HNNKNkNNKNKKNWKKNNKNNKNKNKKNNNzNNNkNzkNWKNNNNNNWNNW444444lZIDOxZldbZUo1oAbbbbxZbJoofZZbAbAfroobZ..yyaalIb...A...Z...f...f..f.o1o..Zbot..o..bf..ff..o...rf...ooffoy...O1ZlZ....I..mm..mrOYbm..Yx.......IbZb...ZbfZ....lI..Zb..b..lx..bofZf..mJf..1m..t.fffZbbxAZfbbY...lY..b...bb...Z......f...Ap..AbZflIllZ...xZ..b...1...b...Z..oof..b...f...bZ..y...lI...I..fY..I.fbb..O..fo1..fZ..t...f...foffffooofrfffEoRRRRRRRRRR",
"OOOOOOOOOOIlYYZmDNxbbIbblWKWKWNNKNKNNNKNKWNKNNKKzkNKNKNNWKKWKKWKKKKKKNckNKKKKKKKNNsKNKKKWKKKKNNtWKKKKKKKKKKKKNNkKKcKKkKkNNVkKuFkkkkkkkkuFutEtEEEJdsxKKWNNKNKNKNKNKKKKkNNNkNKNKNkKKKNSNkktNttttttNxwSSSISSSSVVxNNKkkkktttJtxdHs#IKKNNNKKKNKKNKWNNKNKKNtNKNKNN#NNKWNNkzNtKWKNNkNNWNN444444ZlZymmZYYIbY1AbIYbImmfxZfffArmbbbfro1AI..yaymbZb..fY..Ib..of..rS....1f..fAb1..roo....ff...o..1Zb..pfo1bf1..1mfIIZx..mZ..IA..bomIlY..YffZlrIIfbmfZ..IZbxZZ..lYI..fb..I..bY..AfAmb..mf..bfA....ZZfblZbAx.lbYI..I..YI..YZm..xb..b..If..bIf..fbAZZ.lZlZ..m..YI..1A..Yb..m...ff...m...f..1A...y..mbZ..A...ZI....fA..Sm..b1..rf..1j..oo..foff1mbof11ZbAopfRRRRRRRRRR",
"OOOOOOOOOOIbZZYYbNfbZbIIbVNNNKWWNWWKKzKWNNNKWKNcNNKKzKNWNKKNNKKKWWcNKKcNKKWNKKNKckcKKKKKKKNKNkcKKKKKKKKKKKKKKcKkNKckNNNKKVNkkuukktkkkkkuukttEEEJdsxKKKKKcNKKKNKKKKKNNKckKNKNkNKKNNNkxVktttttttttttxxxSSxVxVxNNNtNkktttttJJwHs#dKzNNtNNKNKKWNKNztNKNKNKNWNKNN##NWNKNN#KWWNNK#NNWNVN444444xfmmZbIlbbfobYYbbfmZbrfA11fotoooooopjpi...yEf..b..YZ..bY..pf.o1mm..br1..fbop..1f..m1tpo..Jo...o1...pEj1Zb..ofZIZZ..omm..YY..o1.bI..bmmAbfZZZrfZZI..IfZOf..ZIZI..Ib..b..lx..ZxZZZ..fm.fxZxm..bbAfIfmZZl..fbI..l..I....YY..fb.bI..bl..bl..poIIZI..xfm..b..b....Y...f..b..A.1..to..oo...p..yi...bZ..I..1.b...pf1..mm..br.fff..p....1..1tpoffJoptpo1pE1pRRRRRRRRRR",
"OOOOOOOOOOYZYYIYYxmrbZbYIWWWWNWKWKNNWNNKWWWNNKWzKNKNNKNWNKKKKWKWKKWWKKcNtWKKKKKKKNKcKKKKWKKNKKKKKKKKKKKKKKWKKKKNKkcKkkNKKlNkkkkkkkkkkkkkktEEEEJws#kKWKNKNKKNNtNKKNKNKNNNNKNNKKNKNkKNkSNttttttttttttxxxxxxNNNNttNktttttJJJxwH#HNNNKNKNNtNKNKNNKKNNNNKKNKNKNNkzkKWWNNkzNNKWNWNKNKNNN444444mZ1rbbbbf1pAwlbbfOfArfAbfofrfoJoiD1f1o11.....bbZZ...1xbZ....frJDm..rrr..mZop...A.....pf..mp...tp..ph1frp....xxb...xfmmO....fjm....IIZffZbbxfofbZ....xZ...xAIlZx....IYl....fZfZbx....fflfo1..xbIlZbfIll......YY...Y...IY....bZbY...bxfZ..jpblYZ......bb...1...l..fO......fo..fo...D..1o..1o...bb......xb.bfjAf...m....rffm...1...o...fpf11mpjj1tpjophRRRRRRRRRR",
"OOOOOOOOOOllIIZIYxZZffZbbNNNNKWWNKWWNKWNKNNKKNKzNKNKKNKKKWKNKKKKKWKNNKcNKWKWNKNKKKKcKNKNKKKKKNKKKKKKKKKKNNKKKNkNKKcNNNkKNlNkkkkkkktktkttktEEEJwH#dKNKKKNKKKKKKKNKKKKKkNNkNKKNKKNkNKKWxxtttttttttttttttxxxNNttNtttxtxttJtJwd##xNKNKNKKNKNNKKNKNNKNKKNKNNKKWKN#NNNWKNNzNNNWNWKNNNNNN444444lZffffbA1jobrbommZrfAAofo1foooyiyofAfbrfomroytrbbZZfAIb...p1JrbJm.brArrfbJ1ofAff.jZ...pt1fiaypDjfroptoojjrAoflxZbrmmxDmxlYf11mYIYYYIYf1ZZZZZffxZfffAZIZIIxfZbffIbZZYIYZmbZmfmxZZfmfmfbf11m.xZZbAIZZZbIlx1AfZIIYxYllIIZ...ZZffZbbbbmAZx..kDZZlZZmlZffffbA1jobrbommZrfAAofo1foooyiyofAfbrfomroytrbbZZfAIbZlbp1JrbJmDbrArrfbJ1ofAfffjZbbtpt1fiaypDjfropRRRRRRRRRR",
"OOOOOOOOOOYIlYYYImfbrZArZWWWWNWNKNKNWzNNWKWKNWNzKKKNzKKNKWKWKWNKWKcKKNzkNKKNKNKKcKNckNKKKWKNKKcKKKKKKKKKKKKKNcNkKKNskNKNKVVKkkkkktkkktkktEEEJwH#sxNkNKKkzKNKNKKKKKNKNKcKNNtNKNtNKNKKKcxttttttttttttttttttttNtttttttJJJtJwdH##NkNzNKNKNKKNKNNkNzNNNKNNNtNNNKNN#KNNNNzNNKNKKNzKNKKNN444444f11ZYftijpor1moZIbooooopoyyj1foffrfbtofbIf1oAapAZbr1xfY..bO1fA...A1pi1t1Zfmfomf..tyo..offbtpEto1AboffApf1D11bIbtOfmlfZxIZfpOfIbAIIlYIffbZbZbA1AxAfmrAZYIZIfmfArbZfZmIIZAZZm1mmZbIxZbm1m...bZfAZZlIZZIYYIYZmZYIIYYYIlYY..mfbrZArZZfZ....IbAOmmIlxf11ZYftijpor1moZIbooooopoyyj1foffrfbtofbIf1oAapAZbr1xfYYYbO1fAbbrA1pi1t1Zfmfomfootyom1offbtpEto1AbofRRRRRRRRRR",
"OOOOOOOOOOIYlYYxIffAfbIbbWNWNNWNKNNKNKKNWNWKKNKzNWNKKNNKNNKKKNKNWKNKKkckNWKWWtNKNKKsNKKKKKNKKKKKKKWKKNKKKkNKNKkNKNkKckNkNMVtNkktktkktkkkEEEJwd##NKNNKKNKKtNKKNKNNKKNNKKNkNKKNNKNKKNWNkIxxttttttttttttttttNttttxttJtttJwwdH#IzkNNNKNKNNNNKNNNWKkNNKKKtNWNKKWkNK#kNkzNNNKKNNKNNNNNWV444444ZIDIZZpyjDp1ObffAbArfoppay1AfJAAAbfroffZbfAfoijJoZbAbA....1pt...bfooyjpfbfmo1rfo.....pofArtopfomffofbrbf1EpfobJj1fZbZYbxmftmfbIZfYIIYbfIIlYbxt1rbZZfAbIZ1YxffZbZImxZYffxIbAmfmZflZfmfA...xfZ1rbbbIlllIYfZdZmblZYYIYlY....fAfbIbbZmb...ZZIbDOfYIZZIDIZZpyjDp1ObffAbArfoppay1AfJAAAbfroffZbfAfoijJoZbAbAbYYb1ptAbbbfooyjpfbfmo1rfo1pE11pofArtopfomffofRRRRRRRRRR",
"OOOOOOOOOOYYYYYZZZfflZbZZWNNWNKWNWWVNNKWWKNNKKzKKWNKKKKKKKNKNKKKKNKKNNzNkKNKKKNKKKKzNkNKNKKNKKKKKNKKKKKNKKNKKNNKKKNKNccccNSNNttktEtktktttJJdH###kNNkNNKNKNKKKKNKKKNKKKNKKNKNtWKKNKKNKNcISxxtxtttxtttttttttttttJJttEJJwddH#HNzKNNKNKNKkKNKtKNtKWNkNNKNKKNNNNNKNNzz#NNNKNNKNNNkNNNNN444444bbAfotpjkDqpropJoooooijijA1oopfAbombAJ1bobbIAoEpfrrbfbfIYbf1f1bbbrffojofAffAffmfroooi1JffbojofAofAfZZfAfopjEiiapmZbZZIZff1pmZIZZIllIZIAbZbbblx1bZYIbZAbmmZmAfrAZImmfl1OlZZfZfxfxZxmmxZbfZbmffAfAZbZYZlZmbYYxZrZYIYYYYYZZZfflZbZZZZZZfxZrlZtDmZbrbbAfotpjkDqpropJoooooijijA1oopfAbombAJ1bobbIAoEpfrrbfbfIYbf1f1bbbrffojofAffAffmfroooi1JffbojofAofAfZRRRRRRRRRR",
"OOOOOOOOOOYYYIZYIIblIZbxbVzNWzNWzKWzWzWNzNKzNNcNNzKNzKNNNzKWzNNzNWcNczzszNcWNcKKcWKckNcNWcKcNKcNKcKWcKWcKKKcNcNKcNKcKkcNKcISNNttkkkEttJJJJdss##szNzKNckNcKWzKNzNKcNNNNzkNzNKzKNzKNzKNc#sdSxxxxxtxtttttttJttJtJtEtJJwwdH#sHxk#zNkzNKzWKzKNzNKzNzNKzKNzNNzKKzKNzNzkNzNK#NNzNKzNWzKWN444444yijjEDj1tpi11pjj1AbAZfZbfrfZooofAAbfbbrYUYbZb1ppo1AZbYIbIbJtfo1brfArAppjf11Affxbo1oj1fAfAEjp1bbfZf1ffrofjftfDypx1fbAfbZZbfmffblbZIZIIZZImofbZZfobbAZZAmIZfZxmxfbmmfrxxZZZbffxAZZIZxlfflfmAZxfZIZbIZlflbAIxYYxAlYYYYYIZYIIblIZbxbIIAIbrrfmfomZijyyijjEDj1tpi11pjj1AbAZfZbfrfZooofAAbfbbrYUYbZb1ppo1AZbYIbIbJtfo1brfArAppjf11Affxbo1oj1fAfAEjp1bbfZf1fRRRRRRRRRR",
"OOOOOOOOOOYfm1blYYIYIYlZZNNWWNWWKWNWNNNWWNWNtNzNKNNKWKNNNNNNWKWKNKKNKzszNKNKKNkNKWKkzNKKKKNKKNKKKKWKKKNKKKKKKNKKKKKKKkNKNKNSdSxxxxxwxwwdH##INkz#NKKNKkNKKKKNWtNNNKKNKNKNtNKtNKtNKKNKkNNkNkIHdIwJwJwJwJwJJwJwwwwdddHsssINNNNKNzkKNtKKNKKNNNKtNKNNKNKNNNNNNKKNtNKNNkNNkNNKKNKNNNKNKV444444ayj1mmbtih11bAAZIbrfZbbbbbAo1A1obbfobZAYIYZbIbrfip1UbbrbYopjofbAbA1Ibyiyp1ob1oAAooopofffoofffflrfJfxooroyfA111DomfAbbbfbrf1oAZZIZYIZZZxlZfmZbZxoAbrmZbmbZffZZlfZfm1mffffbZZAZxZZZlZZAbbZxfAZZZZblxIIYYZZblYYZxZYdYfm1blYYIYIYlZZIIZIZf1ffmZlIjyyayj1mmbtih11bAAZIbrfZbbbbbAo1A1obbfobZAYIYZbIbrfip1UbbrbYopjofbAbA1Ibyiyp1ob1oAAooopofffoofffflrfJfxRRRRRRRRRR",
"OOOOOOOOOOo1mSbZbblYYIZYIWNNWNWWNWWWWzKNNKNNNNzKNWWNzNKWKKKWKNNKKNzKNczzNKKKNKNkcWNKzkNNNKKKNKzNKKKWNKKNKNKNKcWKKKNKKNKKKNkKzHIwIIwIIdH##IzkKNszNKNWKWKNzWNKKNNtKNNtKNzKWKKKKKNNKNKNNzNkNNkNdHdddIwIwIwwIwdddddHs#sHINKNNtNNKzNNzWNNKNNNKNNKNNztNNNtNKNNKNNKNzKKNNNKNKKNNKNzKNNNNN444444tDojIYpyat1obxbZbbZbZIZZZZbofZJmrfpmbbbbUbrZIZYbjppUYboftqDooAroro1AtaypDtprotf1oD1btptD1orrrZIr1fZfoofEqrZJ1r1mrfxIZbZfZAO1fZZbIZZfIZlIZZZIZbZZooZbZZmbf1ZAfxft1fo11mZbIxIbAfbbxYIZAfZZZfbblxlYIZZZbZIIZYIlmYZbbo1mSbZbblYYIZYIlbrofbZmZIlIIpDytDojIYpyat1obxbZbbZbZIZZZZbofZJmrfpmbbbbUbrZIZYbjppUYboftqDooAroro1AtaypDtprotf1oD1btptD1orrrZIr1fZfRRRRRRRRRR",
"OOOOOOOOOOZIYYYYlffYxZlbrWVNWNNNWNNWKWNNWWNKWzNNWWNKWWNNNWWWNKWNWWNKNczzKKNNKKNNWNKKcKWKKKWWKWKKWNWKWKWWKWKWWWKNWWKNKKKKNKNKKNMHHdHHs#HISNKKKNczNKWNNKNKKNKKNKKWWKKWKKWKNKKNKWKKKNkNkKNNkNNNKxSdsHHHHHHHHHHsssz#dSxNNNKKKNKNNzkNNKNKNKKKNNKKNWKNWKKWNWKKKKWKWKNNKNKNKNWNNWWNNKKNWN444444DEDiayi1mfbrbroAbbZbrbZfrbbArArAoofbbZblYYYbZbIojaytEjiiiqhrZbIfoJOofptD11pEpppo1Afrftooooftfofbjt1ptApyhfxprrfkyjxZb1ZbZf1pfobrZZZfbIllIIIbZbbZbZfOfmmfffffAbZfm1fofffZ1AlfffYZlbZIf1fffAZfmZIYZfoJfZIYZYYnxfZZmZIYYYYlffYxZlbrAfofZIbxYIIZb11DDEDiayi1mfbrbroAbbZbrbZfrbbArArAoofbbZblYYYbZbIojaytEjiiiqhrZbIfoJOofptD11pEpppo1Afrftooooftfofbjt1pRRRRRRRRRR",
"OOOOOOOOOOZZIIIYYO1bmfrtfVWWNVNVNWNWVNNWVNNWNXNWNNWNNWNNWNNWNNNWNNNNWXXXNNNWNNNWNWNNXNWNNNVWNWNWNNNWNWNNWWNWNWNNNWNWNNNNWNWNNNNddcHdISNNNNNNWNzzNNWNWNNWNNNNNWNNNNNWNWNWNNNWNNNNNNNNNNNNNNNNNWNNNx0ddHHzsHMdIIS0NNNNNNNNVWNNN0WNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNVNNNNNNNNNNNNNNVNVNNV444444yD1iy11pOIIbbIArrIrxbfbfZrrftro1oorbbrZZIYYbIYbriaypoE1ooEjbIbZAoooppEDtAfDofAypfIbfrootqfAofffApphrJoEyh1xtffoDOkfbZfbbIZfDr1bAfIfmbIbAZYZZbZbbfZxZxZfZfmm1mxxfxmf1fmfZmbZmffYIZxmbffflZffDZlllZffmmYIbxYIYfOlYIZZIIIYYO1bmfrtf1bxYAbZlIYbfAff1yD1iy11pOIIbbIArrIrxbfbfZrrftro1oorbbrZZIYYbIYbriaypoE1ooEjbIbZAoooppEDtAfDofAypfIbfrootqfAofffApphrRRRRRRRRRR",
"OOOOOOOOOObIrZYYYfmr1oomANVNVVWVNVVVVCVVNVVNVCVNVVNVCVVVVVNVVVNVVVCVVCTCNNVNVVNVCNVNCVNVVVNVNVCVWVNVNVNVNVNVNCVWVNVNVVVVVVVVCVNNNNNNNNVNVNCVVNCCNNNNVNVNQVVVVVVNVWVVVVCVVNVNVNVVVWVNNQVNNVNNVNVNVCNCNNNNNNNNNNVLNNCNNVVVWVVNNCNVCNNVWVVVVVVVVVCVVNVVVNVVVVVVVCVNVVVNVVVVNVVCNVNVVV444444PDDyyDmfOZIZIbbffbZffArfbAbfoooAoffbbbbfZYYbbrbbyaatEjorwpjorbAfDoopppDDbboot1p1ZfotmfffAbfJA1ffopjbZf1y1bAofffNmxoofAAZbbp1fob.AbAfZZfZbIZIZIAfmxlbIZAIZfff1Zfmf1JfffmZlblmZIYIZZmxfAZlZZmZIYYYxmfZIYYZIbZxlfIYIbIrZYY..mr1oomAbZlIIZbYblZfffZAPDDyyDmfOZIZIbbffbZffArfbAbfoooAoffbbbbfZYYbbrbbyaatEjorwpjorbAfDoopppDDbboot1p1.fotmfffAbfJA1ffopjbRRRRRRRRRR",
"OOOOOOOOOOZIZZZIbZ11tAbYIVVVVNVVNVWVVNVWVVNVVCVVNVVNVNVVNVVVNVVNNNVVNVCVVVVVVVVWxVVVNCVNNVWNVVWVNVNVNVWVNVVWVVVNVNVVWVWVWVVVVVNNVVNVNVVVVVVVVVTCNVVVWVVNVWVNVNVVVVNVNVNVVVVVVVVNVVVVVWNVVVVVVVVVVVVVVVNVVVVVVVVCVVVVVVVVVVVVVVCVVVVVVVNVNVVNVVVNVVVWNVNVWVNVVVWVVWVWVWWNVWVNVNVNVV444444Dop1OxoxZmbIrbAfmZbbrbAbAr1fAffAf1ZbbbYYI......tyaafArJpJiyxAxbbAAooo1t1IoDo1pA......pOrfmffofrfboft1offAfofrffZfmp..ffbZf1Omm..fZZIZblZIIlIYmlY...lIfb...xZff.....ZZf...lYlYYlfbmmxZf....ZllI...xlllI...ZlY....YZIZZZI..11tAbYIAIbIYYZYY......xDop1OxoxZ..IrbAfmZbbrbAbAr1fAffA....bbY...bIbZZtya......JiyxAxbbAAooo1..IoDo1pA..EjptpOrfmffofrfboftRRRRRRRRRR",
"OOOOOOOOOOlYYbYUbbpombfIZVWVNVVWVVNVVVVVVVWVVCNVVVNVVVVVVVNVVVVVVVNNVVCWVVWVWVVVVVWVNCVVVVVVVVNVVVWVVVNVVVVVVVVNVVWVVVWVVWVVVVVWVVVNVNWVVVVWVNCCVNVVVWVVVNVVWVVWVNVVVVVVWVWVVNVVVWVVVQVWVVVVVVVWVVWVNNNVVVWVNVVCVNVWVVVWVVWVVVCNWVVWVVVVWVVWVVVVWVWVVVVVWVVVWVVNVWVVVVVVVVVVWVVVVV444444AoptOmxZlmmbmffmmbZrxAblbAA1ArfJAfZZrbIIZ...ff..pyE1bbyiiiaZbYbU.JopOoAfbxpJAf..11f..fkbAffffmfIxZopDjopt11bffxZr1k..ZxZIfD1f1..fIllflIl.IYYYlIY...1fm..1..xm..Zm..1f..b..bIYIImZbfxf.fZ...ZI..Z..YYZ..m..Y.lY...lYYbYU..pombfIZxIIYYIZZZ...Zf..AoptOmxZl..bmffmmbZrxAblbAA1ArfJA...rbI..Zbrfffrp..1bb..iiaZbYbUbJopOo..bxpJ.ft..1fAIfkbAffffmfIxZopRRRRRRRRRR",
"OOOOOOOOOOIbIYbrbrpqbfZZrVVVVVWVWVVVVQWVVNVVTVVVVVWVCVVVVNVVVNVVVVCVVNVNVWVVVVWVQVVVVQNVVWVVVVQVWVVWVVWVVVVVWQVVWVWVWVVWVVVVCVWVVWVVVVWVNVBVVVCTNVWVWVVVCVVVVVVVVWVVVVCVVVVVVVVVVVVVNQVVVWVWVWVVVVVQVVVVNVVWVVVCNVBVVWVVVVVWVVCVCVVVVWVVVVVVVVCVVVVVWVVWVVWVVCVVVVWVWVVWVVWQVWVVVV444444oypAfZZYIfObIZxmZmbZrbZbbJffrZobrofZbZbZx...pf..ohADmJiyipy1bUb..r11otrAAo1o1..tlbIb.fobffp1ArZlfZA1DPfpE11AmffxftO11ZIlZZDpyO..1bbYZIZ..IlYIlYl...DO...m..Zf..Zm..1...I..lllYYbZfmfffZfm..f..Yx..IZ..Am..IlIZZ..IbIYbr..pqbfZZrbZZYYIZZI...Ym..oypAfZZYIfObIZxmZmbZrbZbbJffrZobr...bZb.xbb1pfbro..DmJi.ipy1bUbbbr11otrAAo1..of..bIbffobffp1ArZlfZA1RRRRRRRRRR",
"OOOOOOOOOOZbtODhOfoi11bYIuuuuuuuuuuuuuuuuuGGQuuuuuuuuuuuuuuuuuuuuuuuQC2CuuuuuuuuuuuuuCTTuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuTCuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuTuuuuuuuuuuuuuuuuuuuuuuuuCTQQuuuuuuuuuuuuCuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu444444ZlomblbIlYx1bZbbfrfZAZbrbofbxZx1oo11Dpoo1...f...tO.....ip........fO....frtof...xYbbAbro....AAf.....f...q..ZZ.....A..hDf.....I...D..1m....Zm1mIIY...Zx..xf..bI.....11..Il..IYIZllYfmxmAZOZ..x..1l..lm..Ib..ZZflY..ZbtOD.....11...I..IZbobf...Zo..Zl.....I..x1b.....fZ......fbxZx1o...Dp.o11offbZbt....ipipo..b...o...t..fr....A...b..brof1AbAAfZbZAxfRRRRRRRRRR",
"OOOOOOOOOOA1aukOfZ1y11lYIFFFFFFFFFFFFFFFFFCGQGGFFFFFFFFFFFFFFFFFFFF2FFFFTFFFFFFFFFFFC2T2FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTFFFFFFFFFFFFFFFFFFFFFFFQFFFF2FFFFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444IIAkZblYbYx1bIfbZbfxrZbfr1ZbZfoppbrborrbf......op..o...Ep.......om..to.fffof...fIbbZxb..po..fb......Z..k..fZ.....f..Dp..l..bZ...D..1f1..mbpfxZlI..IZb..ZA..fbY...xZf..lI..lYImZlYZlZxZbZ..f...xZ..l...YI..ZIZl..fA1auk...1..1l..Y..ZbAfbm.....hmII.....Y..x1..f...fx......ZbZfopp...or.bfobbrbfopm....jEpb...Z...m..t..fff..11...b..xb1fpofffbxZZIfZRRRRRRRRRR",
"OOOOOOOOOO1OkOYZrbfqffAbZFFFFFFFFFFFFQFFFFG...BaFFFFCFFFFFFFFFFFFFGFFFFFFFFFFFFFTFFF2T22FFFFFFQFFFFFFFFFFFFFFQFFFFFFFFFFFFFFGFFFFFFFFFFFFFGFFFGGFFFFFFFFCFFFFFFFFFFFFFT2CC2CTT2TFFFFFTFFFFFFFFFFFFF.FFFFFFFFCFFFFF.QFFFFFFFFFFCFQFF.C.2Q.FFFFFTFFFFFFFFFFFFFFTFFFFFFFFFFFFFQFFFFFF444444YlIDmbIYYlI1IZZbJfZbZrrZfxbm1profrfffrbZ...bIfrA1..r..oof...AI..m1...mtAAbfI..jOIbfmZo..fo..rZ..b...l..O1.ZI...Zff..p..bf..ZI...O..Jtm..op1pmxbZ..ZYZ..Z...fx.....xA..Y...fZlxxbxYbxfmZ..IZ...bZ..b...lY..fZI..Zb1OkOY..bf..fA..ZZ.IbZbfl..oi..xYl...bIY..I1..Z..fZb...Z..bm1prof...f.bZroAbIfrA1bI....ofU..AI..m..of..AAb..Ao...b..Zo1ffooxrZIYbImbRRRRRRRRRR",
"OOOOOOOOOOmbIbmZbIYIoAbZbFFFFFFFFFFFFFFFFFC.QTFFFFFFFFFFFFFFFFFFFGFFFFFFFTFFFFFFFFFFF.QTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQQFFFFFFFFFFFFFFFFFFFFFFFFT2TFFFTFFFFFTFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFFCFFFFFFFFFFQFFFGFG.FGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444IYIZxmbxZmZbZbbAbbJrffff1orbbbrfArfbrAbt...rbbYJ...Z..Epo..rb...bro...bfffob..tAbAfZl...o...1...Z...f..i.1fZ..1ZZf..x..1f..lZ..1...ff...OZllIIl...mZZx....ff..ZZ..ZIf....mZD.......AIZl.IbZ...Z...Z...l...llZ.YmmmbIb..bIY..Ab..f.ZZAZbZ...rI..IIY..xmbx..Z...b..bJr..f...rbbbrfAr...AbtAbrrbbYJorrZ...pob..b..fb..Ab..ff...AA..b...ltmboJ111fZlZIZlRRRRRRRRRR",
"OOOOOOOOOOZZbmbIZZIbfrfmfFFFFFFFFFFFFFFFFF2G2.FFFFFFFFFFFFFFFFFFFQFFFFFFFGFFFFFFFFFFFTT2FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFTFCG..Q.FFFFGFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFFQFFFFFFFFFFCFFFG.QF..FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFa444444IYYlZmZbIfxbbbrbIYfAfbobrbZbrA1bAbAYbbrA...Jbbrr..f...oE..bAb..bZffr..ffffZf..1mIbffA..b1..oo..lx..Ib....Om..rfff..ZZo....bb...x..ZIt..ZxZlIIZl..IxZbfZ..ZZf..bb..lfmx..lxfxmfmfAZIIfZYZZ.b..lZ..Yl..YZ..ZZZZbr.NZZbm..ZZ..frf....bbrxrj..fZl..ZI..lZmZ..fx..b...Yf...o...ZbrA1bAb...brAJEDJbbrr.1frr..Ey...b..bZ..r..fff..ff...I..fAtmb1o1oofxlxZmIRRRRRRRRRR",
"OOOOOOOOOObZbZAbIbYbrZAAoFQFFCFF2FFCFQFFTFFT2FTFFGFFQFFFFCFFTFFQFTTFFGFFCGGFFGFFQFF.F.TGFGFQFFGFFQFF.FFCFFF.FTFFCFFGFFQFFQFFQFFFFCFFQFF2FFCFFBGGQFGFFQFFGFFCFFQFFGFFFFGF.GFFGFFGFFCFQQFQFFCFFCFFGFFGFFGFFGFG.FFGFFTFGGFFGFFFFCF..FFGFFCFF.FFCFCFFGFFQFFQFFQFFGFQFFCFFGFFQFFGFFTFFF444444IIlIbZxbYbYbrAbbbYbAr1AbIbbbAb1ftobUbbrf..ppDJor..p..r.J..mfx...Zm.Z..fobYI1...rbZ..t..bf..t1..mm.xbZf..ttm..fAf1..Il..prZZZ..bx...Ym...ZIIlZfI..ZlZlx..IxZb..fZ..Imx..ZZZAfffIZAbYY1.....Y..lZ..YZ..Il..Ib.....mbZbZ..Ib.brZAA..froftpa..1Y...II..IbZx..bY..A..b.b..1A..bbbAb1fto..bbrfp..pDJor..pZb..Jp..fx..r......fob...f..rb...topbfoot1bmmmZxbRRRRRRRRRR",
"OOOOOOOOOOAZbbbZIZIffblZbFFFFFFFFFFFFFFFFFF.QFFFFFFFFFFFFFFFFFFFFQFFFFFFFQFFFFFFFFFFFFG.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQGFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFFFFFF2FFFFFFFFFFFFFFFFFFFFFFQFFFFFFFFTFFFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444AZbYlY1fxrYYrbwAo1t1mmZbfbZYbbZbAbbbrop....ppooo......ff..tmA..pft...foof1bb1.....fIDp...foop....bfJrx..ppm..ffop...1.....xf..Zf...Zb..llIZmlm....fl...ffmfZf....1Z...IZZbmAZbZZZIZZ.....IlI....lYlY....ZZ.....ZbAZbb....IffblZ..pDaaah.......YIA..YlY1...Y......1t..mZ...ZYbbZbAb.bropoo..ppooo......ffo..m..bp...b...of..b1..1J...Dppj1fooppfllbfJRRRRRRRRRR",
"OOOOOOOOOOfIIZZbYIY1rbfbrFFFFFFFFFFFFFFFFFF2.FFFFFFFFFFFFFFFFFFFFFTFFFFFFFFFFFFFFFFFFF.QFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF.GFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFGFFFFFFFFFFFTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444ZZZbYY1AbZbwoorJ1totZZfbZbYbbbIwoobrooppAopopfooooZArforryDmbbrof1offroArffftpEpfAff1piiiaDt...ZZZDZZb.otpofm111fZ1mf.11...xflf1O1mbZmIlIlIYYlZxIYxflZZfxmZfffxmmZfAfm1ffxZmZZIZfZb11lblZYlIYlYlYYllYIlIbODDmZZxAfIIZZbYIY1rbfb.OiaamfAfYYIbbIYYZZZbYY1AbZbwoorJ1totZZfbZbYbbbIwoobrooppAopopfooooZArforryDmbbrof1offroArffftpEpfAff1piiiaDtpo1ZZZDZRRRRRRRRRR",
"OOOOOOOOOOmYbbbZYYbtfAft1FFFFFFFFFFFFGFFFFF.FFFFFFFFGFFFFFFFFFFFFFC.FFFFQFFFFFFFGFFFFFFQFFFFFFGFFFFFFFFFFFFFFQFFFFFFFFFFFFFFQFFFFFFFFFFFFFGFFFQGFFFFFFFF.FFFFFFFFFFFFF2FFFFFFFFFFFFFQCFFFFFFFFFFFFFQFFFFFFFFFCFFFFCFFFFFFFFFFFFCTFFFFFFFFFFFFFCFFFFFFFFFFFFFFQFFFFFFFFFFFFFQFFFFFa444444xlIYIlm1IZbfrfffoopffbZbmbxbbxbrAoooot1ofoooooooJAfrffbbwkDfooooorAbfffrfofooppDmJfrfojoopyy..ffAJm...ffo1mfxZfmffOm..11D..blb111mtmIYZZllllllIbZlZOtrfmxbbxAxZSfAmfmmfmZZlZZIYIlmf1fbffbZZllllIYIIYYYImmklZbbZffmYbbbZYYbtf...1mahfbfDZbYbbYYIIxlIYIlm1IZbfrfffoopffbZbmbxbbxbrAoooot1ofoooooooJAfrffbbwkDfooooorAbfffrfofooppDmJfrfojoopyyDfffAJmrRRRRRRRRRR",
"OOOOOOOOOOAlbbZIYfbf1ffYoFFFFFFFFFFFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFTG2CFFFFFFFFFFFFFFF.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFFFFFFFFFFFFFaFFF.QCTFFFFFFFFFFFFFF2FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444mOmYYYbmZbrArbootEoZbZrbbrJooptorrff1ooororoofrAAffbAoof1y1ooroffffArAbboofffop1fbroo1tff1f....p1f...bZrbo1pffff11f1f.....ffYxftfbxlbxIxmZllYlZxxfmxoxxxArAfZbZYbYllxffxZZxIxmbxYZbfZZZfmbbZZlIIYYYYYxmZlwxZbxbbrAlbbZIYfbf...YoEYbYZYbbZfbIbYl1mOmYYYbmZbrArbootEoZbZrbbrJooptorrff1ooororoofrAAffbAoof1y1ooroffffArAbboofffop1fbroo1tff1fopiip1ffoRRRRRRRRRR",
"OOOOOOOOOOfbZbZIxZbxpoAopFFFFFFFFFFFFFF..Q.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTG2FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGQTGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTGQCGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444mmObYIbZZrrbbfpop1AfoZbArAoo1ooAborAf1fooooofrfrfptmropDEaDoooffffxfoorofrfomrphIbo1ffooAooffpEEjpOfbbIbbft1mf1p11xffmt1tpDxZZxmAIfIxZYlZIlllIZZZZZZmAmZbmbmxZlYlIZIZZmZllZZZZbZIZZxlIbmIbZbZbZlYlYIImlIYZIZZZfZbfbZbZIxZbxpoAopAYYYYYZYIZAAbIbfmmObYIbZZrrbbfpop1AfoZbArAoo1ooAborAf1fooooofrfrfptmropDEaDoooffffxfoorofrfomrphIbo1ffooAooffpEEjpOfRRRRRRRRRR",
"OOOOOOOOOObrZlbAbfbffOfopFFFFFFFFFFFF.FFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF.FFFFF.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFFF.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444YllbbbrAZrbboppArJArobbrbo1ooAorbZrbfto1fopo1rrJopffr11Dpaypporrfofr1EEj11or11ojxftorbfopD1pft1ftpiAbbbbxfmfff1tmfo1fo1p1fffZfZfZZZImlIIIlYYbZZZbZZmkE1tm1mxmIlIIx1OfbZZIblIbZl1brZZZlIZZffZxZYbYlYfmlIZbAZlIbbfZbrZlbAbfbffOfopYYdYYIbZYIfAbYbYYllbbbrAZrbboppArJArobbrbo1ooAorbZrbfto1fopo1rrJopffr11Dpaypporrfofr1EEj11or11ojxftorbfopD1pft1ftpiARRRRRRRRRR",
"OOOOOOOOOObrZIbrrZZooya1pFFFFFFFFFFFCFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444UYYbIbAZbmbf1mbfoboArfArroooojAfbbtybJfffofoprooyDorf1oJojybrJmJAobftEiitoobbxi1bfllxbAf11o1ffft1AoEyymYbmxb11fpmop1ofm1fmZbZ1xfZfffffffxZbYlIIImZxbllZmIZZ1mYlZZbxfZfZIZIbIZZmt1ZZxIlblZfxbZAbmkkuSIYlllZIIZZAbZbrZIbrrZZooya1pfYdUUbAblYAZbZfrUYYbIbAZbmbf1mbfoboArfArroooojAfbbtybJfffofoprooyDorf1oJojybrJmJAobftEiitoobbxi1bfllxbAf11o1ffft1AoERRRRRRRRRR",
"OOOOOOOOOOAIZbZfmtptEyakDFFFFFFFFFFF.QFFFFFFF.FFFFFFQFFFFFFFFFFFFFGFFFFFFFFFFFFFQFFFFTFFFFFFFQTFFFFFFFFFFFFFFGFFFFFFFFFFFFFFGFFFFFFFFFFFFFQFFFGGFFFFFFFFQFFFFFFFFFFFFFQFFFFFFTFFFFFFFGFFFFFFFFFFFFFGFFFFFFFFFFFFFFTFFFFFFFFFFF.FQFFFFFFCFFFFFFQFFFFFFFFFFFFFFQFFFFFFFFFFFFF.FFFFFF444444rYYYbYrbff1ofZbbroboooArp1JffooAbro1fbfbAooforJotof1omrrJpOmo1pfZffo1oppE1AZf1i1xZbf1foAo1fo1fAo1ofrrtijDffZ1ffDf1pO1mffxfrpopZ1mkmffZZZxfflIZlZSbZbZlfD1mxffxlZxfZIlfZZYlYlIlpy1ZbfIlbxZZ1xx1DVuxlZlbIlZZZZIIIZIAIZbZfmtptEyakDfYYZYfrIlYIYIIAfrYYYbYrbff1ofZbbroboooArp1JffooAbro1fbfbAooforJotof1omrrJpOmo1pfZffo1oppE1AZf1i1xZbf1foAo1fo1fAo1ofrRRRRRRRRRR",
"OOOOOOOOOOlYIZfZZDt1EykuDFFFFFFFFFFFCFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFF.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444ZbIbbbfAffopbZZbbrboopoJ1ofArp1bbbrAOZffoo1oorooo1ftOmrrJaEy1t1xIfftpofAbt1boEjkoAbfpfrf11m1oofmf1fZAIIpafp11o1pto1fArffrfZ1ffb1xhOobfxAff1fZbfxZlZfxbZfDxmxlZxxZfZZZZZIIIlZlJo1pbbZblbIbAAZAODDmflbfIZIZlIlZZYfZlYIZfZZDt1EykuDDZIbfAZbIYZbZIbZZbIbbbfAffopbZZbbrboopoJ1ofArp1bbbrAOZffoo1oorooo1ftOmrrJaEy1t1xIfftpofAbt1boEjkoAbfpfrf11m1oofmf1fZRRRRRRRRRR",
"OOOOOOOOOOIYAfYx1bAoff1VmFFFFFFFFFFFGFFFFFFFFCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTFFFFFFFFTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444bbbYIZmfbYfAoffZIboooffrooAfAo1ArbbArbAootooo11ffrEDpppiyaaijooffZmUoopfwbrrEa1yEfoAmf1frbf11fmqaffbbAmmfyayqytaEpr11rrfmmIfmAffiD1o111Df111oxmmZ11Omf1DoZlZlxZlZZlxZlZIlIAf1rAbmxxZmmmmSlSNNxlbZZfmxZlZxZllIZIIlIYAfYx1bAoff1VmOoAbfZIYlIZxIfbZbbbYIZmfbYfAoffZIboooffrooAfAo1ArbbArbAootooo11ffrEDpppiyaaijooffZmUoopfwbrrEa1yEfoAmf1frbf11fmqaffbRRRRRRRRRR",
"OOOOOOOOOOYfoZm1ff1pZI1moFFFFFFFFFFFFGFFFFFFQaFFFFFFTFFFFFFFFFFFFFQFFFFFFFFFFFFFQFFFFFQFFFFFTFQFFFFFFFFFFFFFFGFFFFFFFFFFFFFFGFFFFFFFFFFFFFTFFFGGFFFFFFFFTFFFFFFFFFFFFFGFFFFFFFTFFFFFFGFFFFFFFFFFFFFQFFFFFFFFFFFFFFTFFFFFFFFFFFFGTFFFFFGFFFFFFF.FFFFFFFFFFFFFFQFFFFFFFFFFFFFGFFFFFF444444bbZbrxrAZbYb1AAIb1o1fbrbAfrootJfrfbbrorop1oJoAr1t1pDEppppyakoEjmxZYbboorrrJJjyEE1pt1b11omfbf1riamZIffffx1EaaaDfjtrotfbffbfmlZZmo1rpjy1fp1o11DOmxbx1t1O11fZIxlxllxZbflxOlfmx11bllfOmmmxlSlllllbIAxZfbI.bZZxIYYYlYIYfoZm1ff1pZI1mofofYmbZIIYbZZYIbbbZbrx..ZbYb1AAIb1o1fbrbAfrootJfrfbbrorop1oJoAr1t..DEppppyakoEjmxZYbboorrrJJjyEE1pt1b11omfbf1riamZIfRRRRRRRRRR",
"OOOOOOOOOOYDxo1orop1ZbZZxFFFFFFFFFFFFFGFFFFTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFTFFFGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQFFFFQFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGFFFFGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444ZIxZo1obbbwrf1ofpipoArrbrbAoDoArrZbArrbAo11rtf1ppo1pyqoooaaaDDpmOfZUAborom1o1mpp1t11bfotp11rf1DDDfxIboDb11tpjp1......p1fZffIIf1k1Aotak1tDfp11fAxlf1Af......ZxlbxmZlmZllYmlZmxZlZZVmmlYYZI..IZfxAZZlZ..rxlZYIYYYYYYDxo1...p1Zb...rrAbf...bYZb...IZIxZo1..bbwrf1ofpipoArrb......ArrZbArrbAo11rtf1pp..pyqooo....Dp..fZ..borom1o1mpp1t11bfotp11rf1DDDfxIRRRRRRRRRR",
"OOOOOOOOOODIfbbbopmfbbYAbFFFFFFFFFFFFFFGQTTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQTTFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC.QGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQT.CFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444bfbbbrEq11mfr1ppoooobAJ1brooArorrofbooooobbZbAbJZfA1Dp1fpaiapj1tAommOOukrrof1Dofmff1ffrfAomppJtpEppyaiiiiaiio11...1b..ZbZrZfbf1fp1ptmm.11pDpj11jZfmo..ff1..D1t1bx1lSmf1mxffmIIYYlmbZllYYY..lZAxIblIf..xlIIlYII.bfDIfbb...mfb..A..bbZ..A..YIZ...Ibfbbbr..11mfr1ppoooobAJ1...oA..rrofbooooobbZbAbJZ..1Dp1fpa..pj..Aom..Oukrrof1Dofmff1ffrfAomppJtpEppyRRRRRRRRRR",
"OOOOOOOOOOZZbYbopbfArxAfYFTFFQFFGFFQF.FFGFFQFF.FFGFFCFFFFQFFTFF.FFQFFGFFQFQFFGFFGFFGFFTFFQFCFFCFF.FFTFFCFFFTFTFFCFF.FF.FF.FFTFFFFGFFTFFTFFGFF2eQGFGFFQFFTFFQFFCFFCFFFFCFFCFFCFFGFF.FFQFTFFQFFQFFQFFTFFGFFGFFCFFQFFCFF.FFCFFFFCFF.FFQFF.FFQFF.FGFFQFF.FFGFFGFFTFGFFGFF.FFQFFQFFGFFF444444bYIIUYpjmAffoooEoorofAorrroor1frfbZboffffrrrZbfZJoooffto1aayEyEtmfmmmkuNrrooopfZ1bfffAoffoOqjbZZtpJoooyiyiiiffm...to..tfJfZ1mZpopOhDj..1pEhyq1tpp1o..ofoD1.OOk1mmfYlY1ffmxZlbmIIYmmxZlIYYbZlIxZlIZxA..ZIYYIIY..xZZZbYb...fA...f..bb...r..bYY...YbYIIUY..mAffoooEoorofAor...or..rfbZboffffrrrZbfZJ..offto1...E..tmfmmmkuNrrooopfZ1bfffAoffoOqjbZZtpJoRRRRRRRRRR",
"OOOOOOOOOOxbYbpjIIZZffAIYFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF.GFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444YUYbwoooJofAoJopDofJorArbroAftfooffrZfJ1frAwrbAbffmArAffriayEyypffm1hODmmfor1AfmtAtooooyhmDyoAffjjprooyyappiofb...o...Dm.....Z.........1....yytp1t...ppt11fDx....mxI.....Y...x..Ib.....S..IZI.....f...Z..ZY....fmxbYbp...ZZ..AI..br..or..YYI...YYUYbw.....fA...p..fJorAr...A...oo.....J1...w..Ab...ArAffr.....ypff..hO......1Afm.....ooyhmDyoAffjjprRRRRRRRRRR",
"OOOOOOOOOOfEppbbIZIIbZffbFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC.FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF444444lYIlZZfAbrrfrrorroopoobbAooo1oAbAAArbrrD1ffomrffIbrofoffZiyaiDZfbfbfjmmmSm1rfootOfo11uak1prfoZffiEpfbAAoqattppo......xm..1...p.....u..1..Dt.jm1o1o...111m1mx..Dm..ff......l..l..qb.....I..YY..Z..xZ...f..xk1..YmbfEppb..ZII..ff..bY..rf..IfO..YIlYIlZ...b..fr..r..opoobb......Ab..A...rD..fo..ff..rofoffZ....DZfbf..jm......foo..f..1uak1prfoZffiEpfRRRRRRRRRR",
"OOOOOOOOOO1pAbZZIYlYbZbbbZbYbY4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444YYYIlIfbbbroboorAfoooporfoprbrArbrrfAbr1o1brfZxAbbrffJbrAEtypAbfbfJopmmmAt1rrtDmxfo11DDDpofofZmtpEpbbbbftaafp1...EyE1Zb..1..tt...kuD..q...1EqtkfDo..fEDmmmbf..Dx..mf..Z...A..1p.pl...III..l..lY..ll...m..YlY..mmb1pAbZ..YlY..b...bY..A...bmm..YYYYYIl..bb..ob..rA.ooopo...prbrAr..r..br1..br..xA..rffJbrA.....bfbf..pm...t..rt..xf..1DDDpofofZmtpEpbRRRRRRRRRR",
"OOOOOOOOOOpfbZZlYYYYxZllYIZbbI4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444IYYbbb1fAArArrorrrArr1OoropAAorAoot1rAJ1roAUbZbbrrbfZbbbfpiit1ZfAxmrAtf1rAfptDmmmlf1OVOpomAmfbfpto111fIbAtyD1o...pajpf...f..tO..ODx...it...qDDyoyp..1jffDOk...N...m...Z...l..A.11Z..YIlZ..f..Zl..Il..l...bb...OmEpfbZ...YYYx....IZbb....bYm...YYIYYb..1fA..Ar..r.rArr1O...pAAor...t..AJ1..A...b...bfZbbb...i..ZfAx..At..r...tD..ml..OVOpomAmfbfpto11RRRRRRRRRR",
"OOOOOOOOOOmofAZZrfZZZbZZZfZZbI4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444AbbbbbAofbrrorbrrorooAbr1ofAx1JoAbfoD1ofrrmAbrAbbtorrfAIfrpiAofbwbfffpo1bt1bbAtDiO1ffmS1o1mZxojjZo1bbbbrmDt111...jyOtj..j...f..qDDy..pE1D..OmkmtkO..lfZfmmO..p1..lx..Zl..11....bI..xffx..ZIl....IZ...Z..ZYY..mZDxmofA..rfZZZb..ZfZZbI..bbYt..YIoAbbb..Ao..rro....orooAb...fAx1J..b...1o..rm..rA..torrfAI...i...bw..ff...b...bAt....ffmS1o1mZxojjZo1bRRRRRRRRRR",
"OOOOOOOOOOfroo1mf1ffxAbZZbJfAb4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444fbbAbArfAJrrrbbrfooJrrbAAot1f1orfropofboo1AAbZbbtprrbrIbZrpipp1brbfoo1rpbpkYb1Irtmff1m1ff1fbAtipIbpbIbAbfmfprp..DDDyjj..m..m...1pAm...m.D..m11mO1m...xlZ..f..po..bf..ZZ.xmmm..kZI..ZmmZ..mf..ZZbZx..Zl...YI...xobfroo..f1ffx..ZZbJfA..IYYbj..YfDfbbA..rf.Jrrrb..fooJrrb..ot1f1o..r..o.b..1....b..prrbrIb..pip..br..oo..pb..Yb1..tmff1m1ff1fbAtipIbpbRRRRRRRRRR",
"OOOOOOOOOOIxrZbIbIffbZblZbArfb4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444bbbbbbrrrorrrrrAAfoofbrArroofoo1ororAAbAmmbofbbooorAbbIfYrppop1UrrrbfooobtDbbr1fo1m1f1o1ffofApjmZbpZbbZblofmf....m1hD1......S..x1ZJ..ft...DDDZ1xkmm.....fxfA...1Imb....fIIfx..xZl..bIZZ...m.....Zb..ZY...bJ..IlflIxr....If...blZbA...YYIZZ....jjbbbb....rorrrr..Afoofb....oofoo......Ab...b...b...rAbbI....p....r...f..ob...br.....1f1o1ffofApjmZbpZRRRRRRRRRR",
"OOOOOOOOOOlAZIZbYZxff1rbbrrZoUbbfmIboooJoIYbbbbroorrrbAfAfAbr1brA1otoootmooromrbAoprfoajZYYbYlbooorJioppobrfAroorootYrZbooDffYIAfo1opjffZZbrfYYYZ1A1tpfpDj1pkIZflllmZZZZffx1DtmxltOOmmOmxm1lfOxmAfA1fAIAxZt1tfxlfZZtZIflYIm1xfmofO1p1mVmxmV1fbbJqZfmSYplblAZIZbYZxff1rbbrrZoUbbfmIboooJoIYbbbbroorrrbAfAfAbr1brA1otoootmooromrbAoprfoajZYYbYlbooorJioppobrfAroorootYrZbooDffYIAfo1opjffZZbrfIYYYZ1A1tpfpDj1pkIZflllmZZZZffx1DtmxltOOmmOmxm1lfOxmAfA1fAIAxZ...fxlfZZt.IflYIm1xfmofO1.1m...mV1fbbJqZfmSYplblAZIZbYZxff1rbbrrZoUbbfmIboooJoIYbbbbroorrrbA.AfAbr1brA1otoootmooromrbAoprfoajZYYbYlbooorJioppobrfAroorootYrZ.oo...YIAfo1opjffZZbrfRRRRRRRRRR",
"OOOOOOOOOOZIlZbofo1ZrbmbrZbJfZbfZffrEyoprbbIZYbr1rrAobrAAffrAbbrobrororo1foooAroArAoEpprtUrbIIYboA1oiAoo1ZbrbrbbriyabfbbZJambZZf11o1kqf11fxrfZZIf1tpDj1qfmfmmZffIIlxxxxlfxxfkO1lZfxmffmxmffxmDOfbAo1ffbxmxmm1mxZZbZmlYZbl1kmbfmDkA1kkmmxlllmZxmmZZIYYYflAZIlZbofo1ZrbmbrZbJfZbfZffrEyoprbbIZYbr1rrAobrAAffrAbbrobrororo1foooAroArAoEpprtUrbIIYboA1oiAoo1ZbrbrbbriyabfbbZJambZZf11o1kqf11fxrffZZIf1tpDj1qfmfmmZffIIlxxxxlfxxfkO1lZfxmffmxmffxmDOfbAo1ffbxmx..1mxZZ...lYZbl1kmbfmDkA..kmm..llmZxmmZZIYYYflAZIlZbofo1ZrbmbrZbJfZbfZffrEyoprbbIZYbr1rrA...AAffrAbbrobrororo1foooAroArAoEpprtUrbIIYboA1oiAoo1Zbrbrbbriyabf..ZJa..ZZf11o1kqf11fxrfRRRRRRRRRR",
"OOOOOOOOOOIYYYZfmfbbrAoArfbrbYbYUIbopjjprAIbbbfffbbrbrrrfArroorborr1ooptpoooooJfJfZj1AfbrbAfYIlfot1ppfbf1bZmffft1yaafAfbooaOfJffo1fpOjjp1xZrZfbZf1pD11xhZmmbIfZxIllllAmllZf1kkOIxmmfmmmxxfmmO11frf111bZbZlIbxxlfIlIlxlYxYPkxfAm1ffZllZlYYYYIYYIfflYxYImbbIYYYZfmfbbrAoArfbrbYbYUIbopjjprAIbbbfffbbrbrrrfArroorborr1ooptpoooooJfJfZj1AfbrbAfYIlfot1ppfbf1bZmffft1yaafAfbooaOfJffo1fpOjjp1xZrZZfbZf1pD11xhZmmbIfZxIllllAmllZf1kkOIxmmfmmmxxfmmO11frf111bZbZ....xlf...lxlYxYPkxfAm1ffZ.....YYYIYYIfflYxYImbbIYYYZfmfbbrAoArfbrbYbYUIbopjjprAIbbbfffbb...rrfArroorborr1ooptpoooooJfJfZj1AfbrbAfYIlfot1ppfbf1bZmffft1yaafAf.....fJffo1fpOjjp1xZrZRRRRRRRRRR",
"OOOOOOOOOOZIIxbAIlbZmrfobfooAbZbxbrrpyy1ZboEfofmfbbbobbbrArooAoArooorr1ooooop1p1om1Jooo1bmxZbI1bbrfbIpoo1ZIxZIDD1DyajmffEiyfZfo1t11mmoppmx1ZZblmm1D1bSlIlZxOxxmZZImmSlIYlbllZOmmlxxxmmlmkkxxZmZmolfmlZZlxblZxZlZZIYllYYIYIYlOxfDObffxxlZYIfIZbZxlYlII1ZIbZIIxbAIlbZmrfobfooAbZbxbrrpyy1ZboEfofmfbbbobbbrArooAoArooorr1ooooop1p1om1Jooo1bmxZbI1bbrfbIpoo1ZIxZIDD1DyajmffEiyfZfo1t11mmoppmx1ZZlblmm1D1bSlIlZxOxxmZZImmSlIYlbllZOmmlxxxmmlmkkxxZmZmolfmlZZlxblZxZlZZIYllYYIYIYlOxfDObffxxlZYIfIZbZxlYlII1ZIbZIIxbAIlbZmrfobfooAbZbxbrrpyy1ZboEfofmfbbbobbbrArooAoArooorr1ooooop1p1om1Jooo1bmxZbI1bbrfbIpoo1ZIxZIDD1DyajmffEiyfZfo1t11mmoppmx1ZZRRRRRRRRRR",
"OOOOOOOOOOfZAZAbZAIYbbbooobbIUbrZbboijpjDJiyt1f1oAwrAbrrrArAArAroooorbJoooopo1oooomfommkxxo1fmbfbbxlxpD1flZxlfmmfJyaq1fpyiafbxZf1omf1fotpxkklxZlffmxZlIlYIIxkxZlxmxxmlkZIlIllmOllx1mmllZDlfSlmmxlmZZIxlmlllIlxfZxlIbmxIZlYIxxlbk1AmOm1kZlZmIfmZfZblYpAYIZfZAZAbZAIYbbbooobbIUbrZbboijpjDJiyt1f1oAwrAbrrrArAArAroooorbJoooopo1oooomfommkxxo1fmbfbbxlxpD1flZxlfmmfJyaq1fpyiafbxZf1omf1fotpxkklbxZlffmxZlIlYIIxkxZlxmxxmlkZIlIllmOllx1mmllZDlfSlmmxlmZZIxlmlllIlxfZxlIbmxIZlYIxxlbk1AmOm1kZlZmIfmZfZblYpAYIZfZAZAbZAIYbbbooobbIUbrZbboijpjDJiyt1f1oAwrAbrrrArAArAroooorbJoooopo1oooomfommkxxo1fmbfbbxlxpD1flZxlfmmfJyaq1fpyiafbxZf1omf1fotpxkklRRRRRRRRRR",
"OOOOOOOOOOZbxbmfxrZZYYYboforrbbUZbbprbppptyatD1oroAZbZZrrbArrrbbrJooJAroorppopoprroIbImmmo1ff1mZYYfxIot1fbmAxtfxf1iaypof1EamfxAxpfxfA1oDptaafOfmxkf1ZIlYIllISlIfYlIfOxlZlYxZZb1YIl1xZxbxfZfZxlxmSxlxfZllYIlYIZlfxZIIfZlIZYYmIllOffk1Zff1ffmZxZblrxAl1dYbZZbxbmfxrZZYYYboforrbbUZbbprbppptyatD1oroAZbZZrrbArrrbbrJooJAroorppopoprroIbImmmo1ff1mZYYfxIot1fbmAxtfxf1iaypof1EamfxAxpfxfA1oDptaaf1Ofmxkf1ZIlYIllISlIfYlIfOxlZlYxZZb1YIl1xZxbxfZfZxlxmSxlxfZllYIlYIZlfxZIIfZlIZYYmIllOffk1Zff1ffmZxZblrxAl1dYbZZbxbmfxrZZYYYboforrbbUZbbprbppptyatD1oroAZbZZrrbArrrbbrJooJAroorppopoprroIbImmmo1ff1mZYYfxIot1fbmAxtfxf1iaypof1EamfxAxpfxfA1oDptaafRRRRRRRRRR",
"OOOOOOOOOOZbmZofZffrIZbYYAbbZfZbrrfbZYrEjpaayy11pfbZIbffrArAoorfopoJofopooEptoo1rofmxDIbfxflZfZmZf1fZxZxmbmDfxmmmYpayDfftiDxI11fmmf1t1ftpEtDmD1bxmmmIlSIIllIZlllIllIZlxxb1fbmllmIlllIZxfZmmmlmZmxImOxOmIxmlSIlImOxxmfxlbIxxZIIYxbmAfffZIZffAffIl1SIIZZmffZbmZofZffrIZbYYAbbZfZbrrfbZYrEjpaayy11pfbZIbffrArAoorfopoJofopooEptoo1rofmxDIbfxflZfZmZf1fZxZxmbmDfxmmmYpayDfftiDxI11fmmf1t1ftpEtDmOD1bxmmmIlSIIllIZlllIllIZlxxb1fbmllmIlllIZxfZmmmlmZmxImOxOmIxmlSIlImOxxmfxlbIxxZIIYxbmAfffZIZffAffIl1SIIZZmffZbmZofZffrIZbYYAbbZfZbrrfbZYrEjpaayy11pfbZIbffrArAoorfopoJofopooEptoo1rofmxDIbfxflZfZmZf1fZxZxmbmDfxmmmYpayDfftiDxI11fmmf1t1ftpEtDmRRRRRRRRRR",
"OOOOOOOOOObfmbfAb11tbbbbZxbbfoofrbZbIbpjipa1aytOtrffZrAArforopoopooo1oAooopDproAofAD1pfb1ZfZmfrmmm1xbmxxIxfmZxfDZxyaijo1qj1Zfoofm1rfooAA1OmtpkmfmxlxIllYxlllllImlIlZxfmfmxxmlIlmZIbZlZfmfmm1fmSxmxmZllxmlbZllxxxmmZxx1bZxxlIllIfZZxfmlYlfxZbA1bbmZflmxDZfbfmbfAb11tbbbbZxbbfoofrbZbIbpjipa1aytOtrffZrAArforopoopooo1oAooopDproAofAD1pfb1ZfZmfrmmm1xbmxxIxfmZxfDZxyaijo1qj1Zfoofm1rfooAA1OmtpDkmfmxlxIllYxlllllImlIlZxfmfmxxmlIlmZIbZlZfmfmm1fmSxmxmZllxmlbZllxxxmmZxx1bZxxlIllIfZZxfmlYlfxZbA1bbmZflmxDZfbfmbfAb11tbbbbZxbbfoofrbZbIbpjipa1aytOtrffZrAArforopoopooo1oAooopDproAofAD1pfb1ZfZmfrmmm1xbmxxIxfmZxfDZxyaijo1qj1Zfoofm1rfooAA1OmtpRRRRRRRRRR",
"OOOOOOOOOOmZfI1ffmAfbZbJAfYbAroorJfZUbpEiiaDAf1A1o1rJZrborrofropqoooofo1oot11AAwmfbombxAt11ZlZmbfmmmbZIZffmmf1xmOpaaEi1tiikfff11AA1AffmxfxZ1tDxx1lmSlIlllIIllIllmIlZf1xllllmZlZf11lllmZZOmxmmOmSxZllxZlllmmIlImxfm1x11xAflZlYYllxlZxmlYIffZfffmAxbfZfl1bfmZfI1ffmAfbZbJAfYbAroorJfZUbpEiiaDAf1A1o1rJZrborrofropqoooofo1oot11AAwmfbombxAt11ZlZmbfmmmbZIZffmmf1xmOpaaEi1tiikfff11AA1AffmxfxZ1tODxx1lmSlIlllIIllIllmIlZf1xllllmZlZf11lllmZZOmxmmOmSxZllxZlllmmIlImxfm1x11xAflZlYYllxlZxmlYIffZfffmAxbfZfl1bfmZfI1ffmAfbZbJAfYbAroorJfZUbpEiiaDAf1A1o1rJZrborrofropqoooofo1oot11AAwmfbombxAt11ZlZmbfmmmbZIZffmmf1xmOpaaEi1tiikfff11AA1AffmxfxZ1tRRRRRRRRRR",
"OOOOOOOOOOxfZAf1kfoAZfrbZooZZbmrobIbwrpoipiyfkoZbbo1111ArJroAop1o1ropoopp1rm111tbbfZbfZbb1JZZfZZffZofm1fxxmZmmmOmiaaaaytopDbfmO1bfffAf1kfm1DtmfmmlSllYIlZllSmlIlfmlfmxllZlxbZZlZlxlxmIIxmmxSmfmxxlmmxxZlIlmlZIIYxxmftpmmxZYIIYYIxZIlIlxffmZffAAxAflIfIlDfxfZAf1kfoAZfrbZooZZbmrobIbwrpoipiyfkoZbbo1111ArJroAop1o1ropoopp1rm111tbbfZbfZbb1JZZfZZffZofm1fxxmZmmmOmiaaaaytopDbfmO1bfffAf1kfm1Dt1mfmmlSllYIlZllSmlIlfmlfmxllZlxbZZlZlxlxmIIxmmxSmfmxxlmmxxZlIlmlZIIYxxmftpmmxZYIIYYIxZIlIlxffmZffAAxAflIfIlDfxfZAf1kfoAZfrbZooZZbmrobIbwrpoipiyfkoZbbo1111ArJroAop1o1ropoopp1rm111tbbfZbfZbb1JZZfZZffZofm1fxxmZmmmOmiaaaaytopDbfmO1bfffAf1kfm1DtRRRRRRRRRR",
"OOOOOOOOO55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRRRRRRR",
"OOOOOOOO5555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRRRRRR",
"OOOOOOO555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRRRRR",
"OOOOOO55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRRRR",
"OOOOO5555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRRR",
"OOOO555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRRR",
"OOO55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRRR",
"OO5555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RRR",
"O555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555RR",
"55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555R"
};

#endif /* USE_XPM */

/* splash background for monochrome or non-XPM compile */

#define spl_bckgnd_width 630
#define spl_bckgnd_height 210
static char spl_bckgnd_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x81,0x20,0x00,0x10,0x08,0x02,0x11,0x49,0x84,0x20,0x00,
 0x82,0x88,0x84,0x10,0x10,0x41,0x04,0x02,0x20,0x92,0x40,0x40,0x00,0x10,0x44,
 0x88,0x10,0x04,0x00,0x02,0x04,0x11,0x00,0x44,0x02,0x01,0x22,0x01,0x00,0x02,
 0x01,0x09,0x80,0x24,0x02,0x80,0x08,0x82,0x10,0x01,0x84,0x90,0x80,0x40,0x08,
 0x84,0x40,0x04,0x44,0x00,0x44,0x10,0x10,0x42,0x04,0x49,0x92,0x80,0x88,0x00,
 0x00,0x48,0x40,0x04,0x80,0x08,0x01,0x20,0x24,0x82,0x94,0x44,0x42,0x08,0x40,
 0x00,0x10,0x82,0x24,0x08,0x02,0x10,0x42,0x02,0x04,0x90,0x50,0x02,0x00,0x0a,
 0x09,0x49,0x41,0x10,0x02,0x42,0x90,0x12,0x48,0x10,0x44,0x4a,0x00,0x48,0x24,
 0x08,0x24,0x29,0x48,0x24,0xa0,0x24,0x80,0x48,0x12,0x20,0x08,0x02,0x24,0x21,
 0x04,0x12,0x12,0x22,0x21,0x02,0x90,0x00,0x49,0x00,0x41,0x42,0x08,0x10,0x00,
 0x00,0x12,0x00,0x92,0x54,0x02,0x09,0x90,0x24,0x20,0x54,0x2a,0x01,0x08,0x00,
 0x00,0x00,0x80,0x08,0x20,0x02,0x10,0x00,0x41,0x20,0x01,0x00,0x80,0x20,0x02,
 0x00,0x10,0x21,0x00,0x00,0x00,0x08,0x02,0x20,0x00,0x02,0x00,0x01,0x41,0x00,
 0x00,0x22,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x08,0x00,0x00,0x04,
 0x41,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x02,0x20,0x00,0x22,0x08,
 0x00,0x00,0x42,0x22,0x44,0x00,0x44,0x00,0x00,0x00,0x00,0x02,0x00,0x04,0x00,
 0x10,0x04,0x20,0x22,0x82,0x88,0x08,0x02,0x09,0x20,0x81,0x08,0x00,0x00,0x44,
 0x24,0x12,0x80,0x20,0x82,0x40,0x04,0x91,0x24,0x12,0x80,0x40,0x80,0x24,0x20,
 0x24,0x10,0x00,0x81,0x10,0x08,0x10,0x12,0x20,0x49,0x04,0x08,0x11,0x08,0x89,
 0x20,0x24,0x49,0x40,0x00,0x14,0x48,0x84,0x50,0x24,0x21,0x41,0x84,0x84,0x10,
 0x05,0x89,0x08,0x80,0x88,0x90,0x00,0x80,0x00,0x44,0x10,0x44,0x80,0x48,0x92,
 0x90,0x88,0x40,0x80,0x2a,0x51,0x02,0x00,0x20,0x00,0x42,0x40,0x00,0x09,0x08,
 0x42,0x24,0x49,0x00,0x00,0x00,0x12,0x08,0x20,0x08,0x00,0x00,0x80,0x40,0x22,
 0x10,0x12,0x80,0x08,0x01,0x04,0x14,0x24,0x04,0x01,0x84,0x80,0x08,0x00,0x20,
 0x41,0x80,0x20,0x00,0x04,0x01,0x00,0x12,0x24,0x01,0x02,0x20,0x04,0x01,0x08,
 0x10,0x20,0x00,0x40,0x10,0x00,0x80,0x24,0x02,0x04,0x10,0x10,0x20,0x01,0x82,
 0x10,0x24,0x00,0x00,0x00,0x02,0x10,0x24,0x14,0x04,0x88,0x48,0x04,0x49,0x00,
 0x04,0x22,0x80,0x20,0x00,0x01,0x00,0x91,0x88,0x48,0x00,0x40,0x02,0x01,0x91,
 0x44,0x10,0x00,0x08,0x02,0x00,0x02,0x00,0x90,0x20,0x01,0x00,0x20,0x20,0x01,
 0x00,0x42,0x84,0x00,0x00,0x02,0x02,0x22,0x00,0x40,0x84,0x00,0x00,0x20,0x20,
 0x01,0x00,0x10,0x80,0x80,0x00,0x12,0x02,0x40,0x24,0x00,0x00,0x10,0x21,0x42,
 0x81,0x04,0x88,0x00,0x80,0x00,0x11,0x11,0x09,0x10,0x81,0x80,0x2a,0x48,0x01,
 0x02,0x01,0x00,0x20,0x41,0x00,0x22,0x00,0x20,0x10,0x11,0x00,0x02,0x02,0x24,
 0x05,0x20,0x40,0x00,0x00,0x04,0x12,0x01,0x20,0x89,0x20,0x44,0x04,0x00,0x40,
 0x41,0x02,0x08,0x20,0x49,0x00,0x20,0x88,0x28,0x48,0x80,0x00,0x49,0x12,0x20,
 0x00,0x49,0x88,0x08,0x48,0x22,0x42,0x12,0x12,0x92,0x80,0x10,0x04,0x00,0x4a,
 0x84,0x40,0x00,0x00,0x10,0x80,0x20,0x20,0x04,0x10,0x04,0x40,0x80,0x40,0x10,
 0x10,0x15,0x22,0x10,0x00,0x48,0x84,0x04,0x08,0x12,0x00,0x89,0x02,0x00,0x84,
 0x44,0x10,0x20,0x00,0x10,0x09,0x09,0x12,0x11,0x81,0x00,0x20,0x01,0x20,0x88,
 0x10,0x40,0x12,0x04,0x04,0x48,0x42,0x04,0x00,0x88,0x00,0x21,0x80,0x00,0x24,
 0x04,0x00,0x80,0x00,0x4a,0x00,0x01,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,
 0x40,0x20,0x91,0x00,0x11,0x02,0x44,0x04,0x82,0x08,0x02,0x82,0x10,0x41,0x20,
 0x02,0x24,0x02,0x82,0xc4,0x2a,0x88,0x84,0x90,0x00,0x20,0x80,0x00,0x00,0x11,
 0x00,0x20,0x89,0x00,0x10,0x40,0x84,0x84,0x00,0x00,0x20,0x00,0x04,0x20,0x88,
 0x08,0x10,0x02,0x02,0x00,0x11,0x00,0x21,0x10,0x01,0x00,0x00,0x24,0x02,0x12,
 0x04,0x04,0x10,0x01,0x90,0x84,0x10,0x88,0x00,0x00,0x20,0x92,0x12,0x01,0x11,
 0x22,0x21,0x11,0x02,0x09,0x04,0x00,0x20,0x00,0x10,0x01,0xa1,0x08,0x42,0x80,
 0x10,0x40,0x08,0x80,0x10,0x01,0x20,0x00,0x20,0x15,0x02,0x52,0x4a,0xaa,0x4a,
 0x55,0x6a,0x55,0xaa,0xaa,0x4a,0x52,0xaa,0xa2,0x2a,0x29,0x29,0xd5,0x6a,0x95,
 0x55,0x69,0x95,0x52,0x55,0x65,0x55,0xa9,0x56,0x4a,0x55,0x4a,0xa5,0xaa,0xad,
 0x75,0xc9,0xb4,0xd4,0xaa,0xb5,0x66,0xaa,0xa5,0x5a,0xab,0x55,0xb5,0xdf,0x56,
 0xa5,0x54,0xb5,0xd6,0xaa,0x56,0xd5,0x74,0xb5,0xb5,0x6d,0xab,0x76,0x6b,0xb6,
 0x2a,0xb5,0x5a,0xbb,0xd6,0x57,0x6b,0xaf,0x56,0x6d,0xd7,0x7d,0x5b,0x29,0xa0,
 0x24,0x25,0x49,0x92,0x24,0x15,0x49,0x85,0x54,0x29,0x29,0xa5,0x54,0x4a,0x95,
 0xa4,0x2a,0x14,0x4a,0xa8,0x92,0x4a,0x2a,0x49,0x95,0xa8,0x54,0xa9,0xaa,0xaa,
 0xa9,0xaa,0x54,0x52,0x8a,0xaa,0xaa,0x2a,0x51,0x8a,0x52,0x55,0xaa,0xa4,0x48,
 0x55,0x4a,0x20,0xa9,0xaa,0xaa,0x4a,0x29,0x55,0xa9,0x2a,0x95,0xaa,0x4a,0x95,
 0x54,0x95,0x54,0x55,0xd5,0x4a,0xa5,0x4a,0x55,0xa8,0xaa,0x52,0xa9,0xaa,0x54,
 0x8a,0x4a,0x15,0x0a,0x48,0x94,0x92,0x24,0x49,0x48,0x92,0x28,0x21,0x52,0x52,
 0x12,0x85,0x24,0x22,0x95,0xa4,0xa9,0xa4,0x12,0x25,0xa9,0xa4,0x92,0x24,0x45,
 0x25,0x45,0x91,0x24,0x4a,0x49,0x49,0xa5,0x54,0x15,0x45,0x49,0x95,0xb4,0x94,
 0xaa,0x2a,0x95,0x56,0x52,0x55,0xab,0x4a,0x55,0x25,0x55,0x55,0x95,0x4a,0x55,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x55,0x55,
 0x55,0x55,0x55,0x55,0xb5,0xaa,0x2a,0xa0,0x92,0xa2,0x48,0x49,0x92,0x52,0x29,
 0xa5,0x4a,0x89,0x0a,0x49,0xa9,0x92,0x94,0x22,0x49,0x92,0x92,0x4a,0x52,0x4a,
 0x4a,0x54,0xaa,0x52,0x52,0xa9,0x54,0x52,0xa5,0x54,0x2a,0x29,0xa5,0xc8,0x54,
 0xaa,0xaa,0x8a,0x4a,0x49,0xa5,0x52,0x29,0x95,0xaa,0xaa,0x2a,0x49,0xaa,0xaa,
 0xaa,0x52,0x55,0xa9,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x15,0x0a,0x24,0x09,0x25,
 0x92,0x24,0x45,0xa2,0x14,0x95,0x52,0x54,0x55,0x92,0xa4,0x52,0x54,0x92,0xa4,
 0x54,0xaa,0xa4,0x94,0x92,0x92,0x44,0xaa,0x24,0x15,0xa5,0x4a,0x4a,0xa5,0x52,
 0x4a,0x49,0x15,0x55,0x25,0x49,0xa9,0xaa,0x2a,0xa9,0xaa,0x52,0x55,0x52,0x2a,
 0x55,0x55,0xa9,0x54,0x52,0x55,0x55,0x4a,0x55,0xaa,0xaa,0x54,0x95,0x54,0x55,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0x24,
 0x40,0x49,0xaa,0x52,0x49,0x92,0x28,0x15,0xa2,0x40,0x28,0x49,0x22,0x29,0x95,
 0x94,0x2a,0x55,0x55,0x92,0x22,0x55,0xa2,0x54,0xa9,0xaa,0x12,0x55,0x49,0x95,
 0x54,0x29,0x29,0x49,0xa5,0xaa,0x64,0x25,0xa9,0x2a,0x55,0x92,0xa4,0x2a,0x49,
 0xaa,0xa4,0xaa,0x52,0x49,0x55,0x95,0xaa,0x4a,0x2a,0xa9,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x95,0x54,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x55,0x15,0x0a,0x94,0x10,0x84,0x92,0x24,0xa5,0xa4,0x94,0x96,0x42,
 0xa5,0x94,0x52,0x28,0x51,0xa2,0x24,0xa2,0x4a,0x54,0x92,0x4a,0x49,0x92,0x24,
 0xa5,0x92,0x52,0x52,0x49,0x52,0x4a,0x55,0x2a,0x95,0x8a,0x54,0x95,0x54,0x92,
 0xaa,0x2a,0x55,0x55,0xa5,0xaa,0x4a,0x55,0x55,0x4a,0x55,0xa5,0xaa,0xaa,0x4a,
 0x55,0x52,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x94,0xaa,0xaa,0xaa,0x55,
 0x55,0x55,0x55,0x55,0x55,0xb5,0x4a,0x15,0xa0,0x42,0xca,0x52,0x48,0x92,0x12,
 0x52,0x25,0x51,0x2a,0x51,0x4a,0x09,0x95,0x14,0x49,0x4a,0x55,0xa4,0x2a,0x49,
 0xa9,0xa4,0x4a,0x52,0x52,0x49,0x54,0x29,0xa5,0x4a,0xa5,0x94,0x52,0x49,0xa9,
 0x4a,0x4a,0xa5,0xaa,0x52,0xaa,0x92,0x2a,0x29,0x95,0x54,0x2a,0x55,0xa9,0xa4,
 0x2a,0x55,0xa5,0xaa,0xaa,0x2a,0xa5,0x54,0x25,0xa5,0x4a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x12,0x94,0x12,
 0x95,0xaa,0x54,0xa4,0x84,0x48,0x4a,0x49,0x8a,0x28,0x6a,0xa1,0xa2,0xaa,0x94,
 0x88,0x4a,0x42,0x95,0x12,0x15,0xa9,0x4a,0x25,0x55,0x25,0xa5,0x94,0x94,0x2a,
 0xa9,0x24,0x95,0x52,0xa9,0x54,0x4a,0x25,0xa5,0x52,0x2a,0x49,0x55,0x52,0x55,
 0x49,0xa9,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x92,0xaa,0x4a,0x55,0x55,0x55,0xaa,0x2a,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0x15,0x04,0x51,0xa4,0x48,0x12,0x8a,0x92,0x32,0x25,0x91,0xa4,0xa4,0x92,0x92,
 0x54,0x94,0x44,0x42,0xa5,0x24,0xa9,0x48,0xa8,0xa4,0x94,0x24,0x92,0x92,0x92,
 0x52,0x52,0x52,0x51,0x25,0x95,0x52,0xaa,0x94,0x4a,0x29,0xa9,0x94,0x4a,0x55,
 0x55,0xa5,0xaa,0x4a,0x55,0x25,0x55,0x55,0xa5,0x92,0x54,0x52,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x12,0x50,0xa4,0x12,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa8,0xa4,0x24,0x55,0xa9,0xaa,
 0x4a,0x55,0xaa,0xa4,0xaa,0x54,0x25,0xa9,0xaa,0xaa,0x52,0x49,0x55,0x55,0xa5,
 0x4a,0x95,0xaa,0xaa,0x2a,0x55,0x2a,0xa9,0xaa,0x52,0x55,0x55,0x52,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x0a,0x12,0xa4,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x55,
 0x55,0x25,0x25,0x49,0xa9,0x4a,0x95,0x2a,0x49,0x2a,0xa9,0xaa,0x24,0x55,0x95,
 0xaa,0x54,0xaa,0xaa,0xaa,0xaa,0x94,0x24,0xa5,0x52,0xa5,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa0,0xa8,
 0x12,0x01,0x20,0x00,0x10,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x10,0x00,
 0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x04,0x00,0x01,0x40,0x00,0x20,
 0x00,0x08,0xa8,0x24,0x49,0xaa,0xaa,0x2a,0x95,0x54,0x52,0xa9,0xaa,0x52,0x55,
 0x92,0xaa,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x52,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x0a,0x0a,0x8a,0xa4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x55,0xa5,0x52,0x52,0xa5,0x4a,0xa5,0x2a,
 0x95,0x52,0x95,0x4a,0x55,0x55,0x55,0x49,0x29,0x25,0x25,0x29,0xa9,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x50,0x50,0x4a,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x92,0x2a,0xa5,0x24,
 0x4a,0x52,0x4a,0x55,0xa5,0x94,0x2a,0xa9,0xaa,0xa4,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x95,0x2a,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x04,0x25,0x21,0x01,0x20,
 0x00,0x10,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x10,0x00,0x04,0x00,0x01,
 0x40,0x00,0x20,0x00,0x08,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0xa8,
 0x4a,0x92,0x2a,0x55,0x55,0x55,0xa9,0xa4,0x54,0x55,0x52,0x25,0x49,0x55,0x49,
 0x55,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0x94,0x94,0x54,0x52,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x92,
 0x48,0x4a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x54,0x55,0x55,0x52,0x95,0x94,0xa4,0x92,0x4a,0x29,0xa5,0x4a,
 0x55,0x55,0x95,0x2a,0xa9,0x4a,0xaa,0xaa,0x2a,0xa5,0xa4,0x2a,0x25,0x55,0x55,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x15,0x20,0x24,0x29,0x25,0x29,0x49,0x12,0x92,0x24,0x25,0x49,0x4a,
 0x92,0x28,0x49,0x12,0x92,0x24,0x25,0x49,0x42,0x92,0xa4,0x24,0x49,0x92,0x24,
 0x21,0x49,0x52,0x92,0xa4,0x24,0x49,0xd8,0xa4,0xa4,0xaa,0xa4,0x4a,0x95,0x54,
 0xa9,0xaa,0x52,0xa9,0x54,0x55,0x52,0x55,0x95,0xaa,0x4a,0x95,0x54,0x55,0x55,
 0x55,0x55,0x95,0x52,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0x55,0xa9,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x8a,0x48,0x92,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x49,0x49,0x49,
 0x55,0xa9,0x2a,0xa5,0x2a,0xa5,0x4c,0x2a,0x25,0xa9,0x2a,0xa9,0xaa,0x54,0xa9,
 0x52,0x55,0xa9,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0x94,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x25,0x25,0x49,
 0x25,0x49,0xa5,0x54,0xea,0x55,0xaa,0x24,0xa9,0x24,0xa9,0x4a,0x55,0x55,0x95,
 0x52,0x55,0xaa,0x2a,0x55,0x25,0xa9,0xa7,0x54,0x92,0x92,0x54,0x25,0xa9,0x24,
 0x6d,0x55,0xaa,0x54,0x92,0x24,0x51,0x95,0xa4,0x94,0x52,0x55,0x55,0x95,0xaa,
 0x4a,0x49,0x25,0x55,0x55,0xa5,0x2a,0x55,0x55,0x55,0xa9,0xaa,0x52,0x55,0x55,
 0x55,0x95,0xaa,0xaa,0x4a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,
 0x2a,0x48,0x94,0x20,0x30,0x04,0x10,0x02,0x24,0x02,0x01,0x50,0x04,0x20,0x04,
 0x10,0x00,0x04,0x40,0x01,0x40,0x00,0x20,0x00,0x88,0x40,0x0c,0x00,0x09,0x40,
 0x00,0x20,0x04,0x88,0xa8,0xaa,0x92,0xaa,0xaa,0xaa,0x4a,0xa9,0xaa,0xaa,0xaa,
 0x92,0x52,0xaa,0xa4,0x2a,0x55,0x55,0x95,0x54,0x95,0xaa,0x52,0xa5,0x54,0x55,
 0x95,0xaa,0xaa,0x4a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x56,0x55,0x55,0x55,0x55,
 0x55,0x55,0x95,0x2a,0x00,0xa5,0x22,0x09,0x04,0x21,0x89,0x20,0xd1,0x25,0x11,
 0x05,0x41,0x12,0x21,0x22,0x11,0x21,0x12,0x48,0x12,0x92,0x44,0x22,0x22,0xe4,
 0x53,0x8a,0x20,0x29,0x49,0x12,0x41,0x12,0xaa,0x12,0xa9,0x12,0x25,0x55,0xaa,
 0x54,0x95,0x52,0x25,0xa9,0x94,0x4a,0x55,0xa9,0x2a,0xa9,0xaa,0xaa,0x54,0xa5,
 0xaa,0xaa,0xaa,0xaa,0x54,0x95,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x2a,0x88,0x94,0x40,0x40,0x08,0x20,
 0x04,0x8c,0x08,0x44,0x20,0x08,0x41,0x80,0x08,0x44,0x84,0x00,0x01,0x40,0x00,
 0x10,0x88,0x08,0x91,0x28,0x20,0x02,0x00,0x00,0x48,0x08,0x40,0x54,0x65,0x4a,
 0xaa,0x54,0x92,0x92,0x4a,0x52,0x4a,0xaa,0xaa,0xaa,0x52,0x95,0x4a,0xa9,0x4a,
 0xa9,0x92,0xaa,0x54,0x4a,0x55,0x25,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x80,0x2a,0x45,
 0x12,0x25,0x82,0x14,0x21,0x89,0x4a,0x01,0x44,0x21,0x24,0x14,0x10,0x01,0x10,
 0x24,0x25,0x49,0x49,0x22,0x02,0x48,0x90,0x24,0x09,0x49,0x4a,0x4a,0x22,0x42,
 0x1a,0xd8,0x14,0x55,0xa5,0x52,0x55,0x55,0xa5,0xaa,0xaa,0x52,0x4a,0x4a,0x55,
 0x52,0x55,0xa5,0x2a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0x52,0x55,0xa9,0x4a,
 0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0x2a,0x2a,0x50,0x28,0x01,0x10,0x10,0x00,0x00,0x88,0x08,0x88,0x00,0x00,0x00,
 0x41,0x42,0x48,0xc2,0x00,0x00,0x00,0x00,0x81,0x28,0x01,0x92,0x20,0x20,0x00,
 0x20,0x00,0x00,0x10,0x80,0xaa,0x6a,0x49,0x2a,0x95,0x92,0x24,0x29,0xa5,0x94,
 0x4a,0x55,0x29,0x55,0x55,0x2a,0x55,0xaa,0x4a,0xaa,0x92,0xaa,0xaa,0x92,0x54,
 0x55,0xa5,0xaa,0xaa,0xaa,0x4a,0xaa,0xaa,0x54,0x55,0x55,0x55,0x95,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x12,0x40,0x0a,0x95,0x20,0x81,0x04,0x42,0x24,0x21,0x10,
 0x21,0x20,0x88,0x48,0x00,0x00,0x00,0x88,0x20,0x21,0x49,0x24,0x24,0x00,0x90,
 0x90,0x24,0x05,0x92,0x84,0x92,0x92,0x84,0x24,0xa8,0x12,0xa5,0x92,0xaa,0x54,
 0x55,0x55,0x29,0xa5,0x54,0xa5,0xaa,0x92,0x4a,0xa5,0xaa,0x52,0x55,0x55,0xaa,
 0x4a,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x4a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x0a,0x51,0x21,0x05,0x24,0x20,
 0x08,0x01,0xd6,0x65,0x95,0x56,0x53,0x15,0x24,0x5d,0xab,0x52,0xab,0x16,0x40,
 0x82,0x20,0x49,0x0a,0x62,0x15,0x93,0x41,0x50,0x00,0x20,0x20,0x88,0xac,0xa4,
 0x2a,0x55,0x49,0x25,0xa9,0xa4,0xaa,0xaa,0x2a,0x29,0xa5,0x54,0x55,0xa9,0x94,
 0x4a,0x52,0xa5,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0x2a,0xa5,0x54,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x40,0xa8,
 0x94,0x90,0x00,0x08,0x42,0x10,0x29,0x9a,0xaa,0xaa,0xac,0x6a,0x01,0xa5,0xda,
 0x6d,0xad,0x5a,0x12,0x20,0x08,0x00,0x40,0x4c,0x48,0x04,0x10,0x04,0x28,0x09,
 0x09,0x02,0x69,0x55,0x52,0xa9,0xa4,0x54,0x25,0x55,0x4a,0x29,0xa5,0xaa,0x54,
 0x55,0x29,0x55,0xa5,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x95,0x54,0x55,
 0x55,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x15,0x0a,0x05,0x29,0x01,0x92,0xa0,0x10,0x44,0x82,0x40,0x00,0x80,0x42,
 0xf4,0x48,0xa9,0x24,0x92,0x52,0x2d,0x40,0x02,0x21,0x49,0x02,0x82,0x83,0x12,
 0x82,0x20,0x01,0x20,0x20,0x48,0x54,0x95,0xa4,0x92,0x2a,0xa5,0x4a,0x49,0xa9,
 0x4a,0x29,0xa5,0x4a,0x25,0x55,0xa5,0x2a,0x55,0x55,0x55,0x92,0xaa,0xaa,0xaa,
 0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xa4,0xaa,0xaa,0x56,
 0x55,0x55,0x55,0x55,0x55,0x29,0xa0,0xa8,0x84,0x44,0x20,0x04,0x80,0x00,0x25,
 0x08,0x48,0x25,0x10,0xa2,0x83,0x04,0x09,0x49,0x24,0x35,0x49,0x48,0x20,0x00,
 0xa8,0x14,0x54,0x46,0x21,0x48,0x48,0x4a,0x0a,0x09,0x58,0xa5,0x2a,0x55,0xaa,
 0x2a,0xa9,0xaa,0x2a,0xa9,0xaa,0x54,0xa9,0x54,0xa5,0x2a,0xa9,0xa4,0x94,0x4a,
 0x55,0x49,0x52,0x52,0xaa,0x52,0x55,0x29,0x55,0x55,0x55,0x55,0x52,0xaa,0x96,
 0x5a,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x4a,0x15,0x0a,0x92,0x2a,0x11,0x01,
 0x01,0x05,0x08,0x01,0x00,0x02,0x00,0x00,0xf4,0x42,0x11,0x20,0x04,0x51,0x5d,
 0x00,0x00,0x82,0x92,0x00,0x13,0x40,0x0a,0x84,0x00,0x01,0x20,0x40,0x20,0xd5,
 0x54,0x55,0xaa,0x92,0x54,0x2a,0x25,0xa5,0x2a,0xa5,0x4a,0x4a,0x55,0x4a,0xaa,
 0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0xa9,0xaa,0xaa,
 0xa4,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x80,
 0x24,0xa1,0x00,0x48,0x50,0x20,0x82,0x08,0x42,0x00,0x00,0x44,0xa9,0x97,0xa4,
 0x4a,0x51,0x8a,0x34,0x92,0x92,0x28,0x20,0x24,0x96,0xc9,0x36,0x11,0x4a,0x24,
 0x09,0x12,0x0a,0x54,0x25,0x49,0x49,0xa9,0x92,0x4a,0xa9,0x54,0xa5,0x94,0x52,
 0x55,0xaa,0xaa,0x52,0x95,0xaa,0xaa,0x52,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x2a,0x48,0x4a,0x2a,0x29,0x09,0x12,0x92,0xa0,0x00,0x20,0xa4,
 0x12,0xf1,0x4d,0x15,0x01,0x44,0xa9,0x7e,0x40,0x92,0x84,0x24,0xc9,0x8d,0xb6,
 0x09,0x49,0x52,0x92,0xa4,0x24,0x49,0xb5,0x4a,0x92,0x92,0x4a,0xa5,0x54,0x4a,
 0x95,0x54,0x55,0x95,0x52,0x49,0x55,0x95,0xa4,0xa4,0x52,0xaa,0xa4,0xaa,0xaa,
 0x4a,0x55,0x4a,0x55,0x55,0x55,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x29,0x80,0x92,0x24,0x01,0x00,0x80,0x80,0x20,
 0x15,0x08,0x04,0x00,0xa0,0x6c,0x4f,0x49,0x52,0xa9,0x54,0x35,0x0a,0x00,0x20,
 0x02,0x40,0xd5,0xaa,0x66,0x00,0x00,0x00,0x00,0x40,0x20,0x54,0x51,0x55,0x55,
 0xaa,0x54,0xa5,0xaa,0x4a,0x95,0x4a,0xa9,0x2a,0x55,0x49,0xaa,0xaa,0xaa,0x4a,
 0x95,0x2a,0x49,0x52,0x55,0xa5,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,0x24,0x49,0x48,
 0x22,0x22,0x14,0x80,0xd5,0x82,0x80,0xa0,0x4a,0xf3,0x45,0xb5,0x04,0x24,0xab,
 0x3a,0xa0,0x24,0x21,0x48,0x89,0x9a,0x96,0x22,0x55,0x52,0xa9,0xa4,0x12,0x09,
 0x54,0x95,0x2a,0x55,0x49,0x95,0x4a,0x49,0x52,0x29,0x29,0x55,0x4a,0x95,0xaa,
 0x52,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0x54,0x52,0x55,0xa5,
 0xaa,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0x10,0x48,0x92,0x02,0x80,0x00,0x00,0x09,0xfc,0x02,0x00,0x08,0xf4,0x5e,0x07,
 0x6f,0x91,0xd2,0xfc,0x9f,0x04,0x00,0x08,0x02,0x84,0xcc,0x6a,0x4d,0x80,0x00,
 0x00,0x10,0x00,0x42,0x59,0x55,0x91,0x24,0x55,0x52,0x52,0xaa,0x2a,0xa5,0xaa,
 0x4a,0xa9,0x52,0xaa,0x2a,0x29,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x54,0xa9,
 0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x4a,0x15,0x42,0xa5,0x24,0x91,0x24,0x44,0x12,0x20,0xa0,0x15,0x08,
 0x40,0xdd,0xfb,0x27,0x5d,0x44,0x55,0x57,0x15,0x50,0x92,0xa0,0x48,0x28,0xab,
 0xb6,0x84,0x09,0x52,0x22,0xa1,0x24,0x08,0xd4,0x24,0xa5,0xaa,0x92,0xaa,0xaa,
 0x92,0x54,0x55,0xa5,0x94,0xaa,0xaa,0x52,0xaa,0x4a,0x55,0x95,0x4a,0x52,0x55,
 0xa5,0xaa,0xaa,0x4a,0xa5,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,
 0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x12,0x28,0x28,0x92,0x00,0x00,0x10,0x40,
 0x04,0x92,0x05,0x80,0x04,0xf4,0x6e,0x05,0x54,0x81,0xa8,0xfd,0x5f,0x02,0x00,
 0x08,0x00,0x42,0xc4,0xaa,0x00,0x41,0x80,0x08,0x08,0x00,0x91,0x54,0x95,0xaa,
 0x92,0x54,0x25,0x25,0xa9,0xaa,0xaa,0x94,0x52,0x95,0x54,0x95,0x4a,0x55,0x25,
 0x55,0x55,0x55,0x92,0x54,0x55,0x95,0xaa,0xaa,0xaa,0x54,0x55,0x55,0xa5,0x56,
 0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x82,0x44,0x25,
 0x49,0x92,0x80,0x08,0x20,0x82,0x2a,0x01,0xa0,0xba,0xbb,0x43,0x58,0x54,0xf5,
 0x57,0x0b,0x48,0x92,0x22,0x49,0x40,0x24,0x1b,0x12,0x09,0x09,0x20,0x21,0x49,
 0x04,0xaa,0x52,0x4a,0xaa,0x2a,0xa9,0x54,0x55,0x49,0x92,0xaa,0xaa,0xa4,0x4a,
 0x55,0xa9,0x54,0xaa,0x52,0x55,0x95,0xaa,0x2a,0xa5,0xaa,0xaa,0x2a,0x55,0xa5,
 0xaa,0x52,0xaa,0x54,0xa5,0xaa,0xaa,0x4a,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,
 0x15,0x20,0x29,0x91,0x00,0x20,0x24,0x90,0x84,0x28,0x08,0x20,0x00,0xe8,0x4e,
 0x10,0x24,0x20,0x55,0x2d,0x21,0x41,0x00,0x20,0x00,0x49,0x84,0xa4,0x20,0x23,
 0x40,0x0a,0x24,0x00,0x48,0x6c,0xa9,0x52,0x55,0x92,0x94,0x4a,0x4a,0x2a,0x55,
 0x52,0x29,0x55,0x55,0x52,0x55,0xa5,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x52,
 0x55,0xa9,0x92,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x55,0xab,0xaa,
 0xaa,0xaa,0xaa,0x2a,0x15,0x0a,0x44,0x2a,0x25,0x01,0x01,0x01,0x00,0x82,0x48,
 0x00,0x82,0xfa,0x03,0x00,0x89,0x4a,0xfe,0x03,0x04,0x04,0x49,0x84,0x24,0x44,
 0x82,0x24,0x0c,0x82,0x24,0x20,0x80,0x92,0x00,0xa9,0x4a,0x2a,0x49,0x65,0xa5,
 0x54,0xa9,0x52,0xa9,0x4a,0x4a,0x29,0xa9,0x2a,0x25,0x55,0x49,0x95,0x2a,0xa9,
 0xaa,0x52,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x40,0x29,0x89,0x00,0x48,0x10,
 0x20,0x24,0x11,0x12,0x08,0x10,0xa0,0x17,0x49,0x28,0xa4,0x55,0x93,0x90,0x20,
 0x00,0x10,0x00,0x40,0x92,0x24,0x41,0x24,0x80,0x04,0x29,0x04,0x52,0x54,0x55,
 0x49,0xa5,0x14,0x55,0x25,0x25,0x55,0x95,0xaa,0xaa,0x4a,0x95,0xaa,0xaa,0x2a,
 0x55,0x52,0x55,0x55,0x49,0xaa,0x52,0x55,0x25,0x55,0x55,0x55,0x55,0xaa,0xaa,
 0x2a,0x55,0x55,0x55,0xd5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x0a,0x44,
 0x52,0x49,0x20,0x44,0x92,0x00,0x44,0x28,0x40,0x00,0xf5,0x26,0x00,0x86,0x48,
 0xff,0x00,0x01,0x42,0x4a,0xa1,0x92,0x2a,0x82,0x24,0x18,0x85,0x4a,0x90,0x20,
 0x90,0x08,0xb4,0x24,0x95,0x2a,0x55,0x29,0xa9,0xaa,0x4a,0xaa,0x54,0x29,0x55,
 0xaa,0xa4,0x54,0xa9,0xaa,0xaa,0xa4,0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x55,0x55,0x4a,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0x50,0x29,0x49,0x00,0x04,0x01,0x00,0x20,0x89,0x20,0x01,0x00,0xd0,
 0x0f,0x10,0x29,0x55,0xd5,0x48,0x44,0x10,0x00,0x04,0x00,0x20,0x92,0x20,0x11,
 0x10,0x00,0x04,0x04,0x02,0x00,0xaa,0x92,0x52,0x52,0xa5,0x4a,0x55,0x52,0x52,
 0x49,0x25,0x55,0xa9,0x52,0x95,0x2a,0x95,0x52,0x95,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0x95,0x54,0x52,0x55,0x95,0x2a,0xa5,0xaa,0xaa,0x55,0x55,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x4a,0x2a,0x02,0xa4,0x24,0x49,0x01,0x10,0x01,0x89,0x04,
 0x92,0x00,0x22,0xaa,0x8f,0x42,0x85,0xd4,0xbf,0x00,0x10,0x42,0x12,0x10,0x4a,
 0x24,0x82,0x44,0x90,0x94,0x48,0x22,0x50,0x48,0xaa,0x54,0x55,0xaa,0x4a,0x2a,
 0x55,0x4a,0xa5,0xaa,0x2a,0x55,0x92,0x52,0x95,0xaa,0x52,0xa5,0x94,0xaa,0x2a,
 0x29,0x55,0x55,0x2a,0x49,0xaa,0x52,0xa5,0x2a,0x55,0xa9,0x54,0x55,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x15,0x50,0x11,0x92,0x24,0x68,
 0x49,0x54,0x12,0x40,0x65,0x44,0x00,0xc0,0x2b,0x08,0x01,0xa9,0x55,0x25,0x49,
 0x42,0x92,0xa5,0x24,0x49,0x92,0x4a,0x25,0x51,0x52,0x92,0x25,0x25,0x49,0xb4,
 0x4a,0x49,0xa9,0x92,0x24,0xa5,0x2a,0x29,0x55,0x49,0x55,0x95,0x54,0x55,0xaa,
 0x54,0x55,0xa9,0xaa,0xaa,0x92,0x54,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0xaa,0x12,0x02,
 0xa4,0x24,0x01,0x01,0x00,0x00,0x80,0x24,0x10,0x00,0x80,0x54,0x1f,0x61,0xa4,
 0xfa,0x4e,0x10,0x00,0x08,0x00,0x00,0x00,0x10,0x21,0x48,0x20,0x24,0x00,0x00,
 0x80,0x00,0x00,0x54,0xa9,0x92,0x4a,0x55,0xa9,0x2a,0xa9,0x4a,0x49,0x55,0xa5,
 0xaa,0x2a,0xa9,0x4a,0x55,0xa5,0x4a,0x49,0x55,0x55,0xa5,0x52,0x55,0xa5,0xaa,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,0xaa,0x4a,
 0x55,0x55,0x15,0xa8,0x92,0x92,0x10,0x08,0x12,0x09,0x80,0x84,0x42,0x01,0x10,
 0xc0,0x1f,0x40,0x21,0xaa,0x8b,0x84,0x12,0x81,0x48,0x48,0x22,0x25,0x89,0x48,
 0x20,0x81,0x24,0x49,0x24,0xa4,0x24,0x59,0x25,0x55,0x29,0x49,0x95,0xa4,0x94,
 0xaa,0xaa,0x54,0x2a,0x49,0xa5,0x4a,0xa9,0xaa,0x54,0xaa,0xaa,0x2a,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x5a,0x55,0xaa,0xaa,0x4a,0x2a,0x02,0x24,0x25,0x41,0x20,0x40,0x50,0x52,
 0x00,0x92,0x88,0x04,0x4a,0x5b,0x14,0x44,0xfd,0x46,0x00,0x41,0x48,0x00,0x21,
 0x08,0x18,0x41,0x45,0x4a,0x29,0x40,0x00,0x21,0x00,0x08,0xd4,0xaa,0x24,0x55,
 0x55,0xaa,0x4a,0xa5,0x54,0x52,0xa5,0x54,0x55,0xaa,0xaa,0x2a,0x49,0x55,0x55,
 0xaa,0xa4,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x95,0xaa,
 0xaa,0xaa,0xaa,0x4a,0x55,0xa5,0xaa,0x55,0x55,0x55,0x15,0x50,0x91,0xa8,0x08,
 0x04,0x09,0x00,0x00,0x92,0x80,0x02,0x00,0xa0,0x1e,0x50,0x29,0xab,0x81,0x22,
 0x08,0x02,0x24,0x04,0x02,0x11,0x89,0x48,0x40,0x40,0x15,0x52,0x08,0x49,0x22,
 0x55,0x49,0xaa,0x92,0x52,0x49,0xa9,0xaa,0x92,0x2a,0x95,0x4a,0x2a,0x95,0x24,
 0xa5,0x2a,0x95,0x4a,0x55,0x55,0x49,0xa9,0xaa,0x4a,0xaa,0x2a,0x49,0x92,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0xa9,0xaa,0x52,0x55,0x55,0xaa,0xaa,0xaa,0x12,
 0x02,0x2a,0x45,0x21,0x11,0x40,0x82,0x44,0x80,0x92,0x00,0x40,0x90,0x9f,0x14,
 0x90,0xfe,0xa4,0x08,0x00,0x48,0x80,0x90,0x50,0x08,0x21,0x94,0x84,0x84,0x40,
 0x00,0x21,0x00,0x00,0xac,0xaa,0x52,0x2a,0xa5,0x2a,0x95,0x94,0xaa,0x54,0xaa,
 0x52,0xc9,0x54,0x55,0x55,0x55,0xa9,0x54,0x29,0x55,0x55,0x4a,0x55,0x55,0x55,
 0x52,0x55,0x55,0x29,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,
 0xaa,0x4a,0x55,0x15,0xa8,0x84,0x28,0x04,0xa0,0x08,0x28,0x20,0x15,0x20,0x89,
 0x00,0x80,0x3a,0x48,0xa4,0x6d,0x44,0x40,0x49,0x01,0x25,0x20,0x04,0x88,0x84,
 0x09,0x21,0x11,0x41,0x24,0xa0,0x94,0x9a,0x54,0x25,0x29,0xa5,0x2a,0xa5,0x52,
 0x4a,0x49,0x95,0x52,0x55,0x55,0x4a,0x55,0x29,0x49,0xa5,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xa4,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x55,0xb5,0xaa,0x2a,0x02,0x28,0x45,0x21,0x01,0x82,0x00,
 0x01,0x80,0x02,0x01,0x04,0x11,0x3f,0x03,0xa9,0x37,0x40,0x02,0x00,0x24,0x00,
 0x09,0x20,0x49,0x90,0xc8,0x88,0x40,0x05,0x81,0x04,0x00,0x00,0xb4,0x54,0xa5,
 0x2a,0x49,0x2a,0xa5,0x52,0xaa,0x52,0x25,0x29,0xa5,0xaa,0xa4,0xaa,0xaa,0x2a,
 0x55,0xa5,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,0x4a,0x0a,0xa4,0x52,0xa9,
 0x08,0x10,0x20,0x08,0x24,0x84,0x20,0x12,0x20,0x40,0x75,0x2a,0xd2,0x1d,0x91,
 0x20,0x92,0x80,0x48,0x00,0x09,0x88,0x82,0x88,0x00,0x09,0x52,0x24,0x10,0x49,
 0x22,0xa9,0x92,0x54,0x52,0x55,0xa5,0x54,0xa9,0x2a,0xa9,0xaa,0x4a,0xa9,0x52,
 0x55,0x4a,0x55,0xaa,0x4a,0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x10,0x84,0x04,0x41,0x42,0x00,0x21,0x90,0x22,0x22,0x0a,0x00,0x04,0xbe,
 0x40,0xb5,0x07,0x40,0x84,0x00,0x04,0x02,0x49,0x20,0x85,0x80,0x88,0x24,0x21,
 0x04,0x80,0x44,0x20,0x08,0xac,0x2a,0xa5,0xa4,0x54,0xaa,0x4a,0x4a,0xa5,0x4a,
 0x4a,0x55,0x95,0x2a,0x95,0x52,0xaa,0x52,0x55,0x55,0x55,0x55,0x49,0x55,0x25,
 0x95,0x52,0x52,0x55,0x55,0x55,0x49,0x55,0x55,0x52,0xa9,0x4a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x15,0x05,0x29,0xa9,0x08,0x08,0x29,0x00,0x01,0x80,0x44,
 0x04,0x82,0x80,0x5a,0x12,0xea,0x22,0x49,0x11,0x24,0x41,0x20,0x00,0x04,0x90,
 0x90,0x88,0x00,0x0a,0x84,0x24,0x00,0x08,0x81,0x54,0xa5,0x52,0x55,0x4a,0x49,
 0x52,0x55,0x52,0x55,0x29,0xa9,0x54,0xa9,0x52,0x55,0x49,0x95,0x52,0x95,0xaa,
 0xaa,0xaa,0x94,0xaa,0x52,0x55,0x55,0x4a,0x2a,0xa9,0xaa,0x52,0x55,0x2d,0x95,
 0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x50,0xa4,0x24,0x21,0x20,0x00,
 0x09,0x14,0x05,0x02,0x29,0x00,0x50,0x3c,0xa1,0xba,0x01,0x84,0x80,0x00,0x48,
 0x84,0xa4,0x90,0x4c,0x82,0x0c,0x25,0x21,0x29,0x80,0xa4,0x02,0x4c,0xb4,0x4a,
 0x95,0x4a,0xa9,0xaa,0xaa,0x92,0x2a,0xa9,0xaa,0x92,0x52,0x4a,0x55,0x55,0x95,
 0xaa,0x94,0x52,0x49,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xa9,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x2a,0x0a,0x29,
 0x92,0x00,0x05,0x04,0x90,0x40,0x90,0x44,0x08,0x10,0x00,0x4a,0x10,0xed,0x89,
 0x80,0x20,0x48,0x02,0x11,0x10,0x04,0x42,0xa8,0x20,0x41,0x0c,0x10,0x29,0x10,
 0x40,0x01,0x54,0xa9,0x48,0x29,0x25,0x25,0x95,0x54,0x55,0x95,0x54,0x55,0x95,
 0xaa,0xaa,0x92,0x6a,0x52,0x55,0x55,0x55,0x55,0x2a,0x55,0xa9,0xaa,0xaa,0xaa,
 0xaa,0x52,0x95,0xaa,0xaa,0xaa,0x56,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x14,0x20,0x44,0x49,0x45,0x90,0x90,0x00,0x88,0x00,0x40,0x48,0x80,0x84,
 0x14,0xa4,0x3e,0x20,0x48,0x82,0x00,0x10,0x40,0x82,0x10,0x42,0x80,0x14,0x09,
 0x41,0x92,0x80,0x40,0x14,0x48,0xaa,0x92,0x2a,0x55,0x55,0xaa,0x28,0xa5,0xa4,
 0x52,0x49,0x2a,0x55,0x55,0x92,0x54,0x89,0xaa,0xaa,0x94,0xaa,0xaa,0x52,0xa5,
 0xaa,0x2a,0x25,0x95,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x09,0x91,0x24,0x24,0x21,0x45,0x52,0x12,0x44,
 0x25,0x12,0x04,0x00,0x29,0x49,0x6f,0x8a,0xa4,0x24,0x4a,0x45,0x92,0xa4,0xa4,
 0x4a,0x92,0x24,0x21,0x4d,0x52,0x16,0xa5,0x24,0x49,0x68,0x55,0xa5,0x4a,0xa9,
 0x92,0xa6,0x2a,0x55,0x4a,0x55,0x49,0x49,0x25,0x55,0x55,0xb5,0x2a,0x55,0x55,
 0x55,0xa5,0xaa,0xaa,0x2a,0xa5,0xaa,0x52,0xa9,0xaa,0xaa,0xaa,0xaa,0x54,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0xa4,0x24,0x49,0x01,0x04,
 0x00,0x00,0x88,0x10,0x40,0x28,0x01,0x00,0x14,0xa4,0x35,0x00,0x40,0x00,0x00,
 0x50,0x04,0x00,0x00,0x42,0x84,0x10,0x01,0x08,0x00,0x40,0x08,0x00,0x02,0xad,
 0x92,0x94,0x94,0x92,0x54,0x4a,0x52,0x49,0x55,0xaa,0xaa,0x2a,0xa9,0xaa,0x4a,
 0x52,0x49,0x49,0x55,0x92,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x29,0x01,
 0x90,0xa4,0x40,0x00,0x20,0x84,0x04,0x82,0x14,0x10,0x80,0x48,0x02,0x69,0x3f,
 0x41,0x84,0x92,0x92,0x4a,0x83,0x48,0x24,0x21,0x91,0x24,0xa9,0x88,0xa4,0x10,
 0x42,0x92,0x48,0x54,0x55,0xaa,0x52,0xaa,0x4a,0xa9,0xaa,0x2a,0xa9,0x4a,0x2a,
 0xa5,0xaa,0x92,0x54,0x95,0xaa,0xaa,0x4a,0x55,0x55,0x4a,0x52,0x4a,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0x52,0xa5,0xaa,0xaa,0xaa,0xaa,0x6a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x54,0x55,0x0a,0x09,0xa9,0x84,0x10,0x90,0x08,0x80,0xa1,0x10,
 0x00,0x14,0xd2,0x0d,0x04,0x51,0x00,0x41,0x10,0x2d,0x22,0x01,0x29,0x80,0x14,
 0x01,0x29,0x50,0x82,0x10,0x01,0x08,0x54,0x49,0x51,0xaa,0x52,0x55,0x55,0x49,
 0xaa,0x92,0x54,0x49,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x25,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x01,0x88,0xa2,0x20,0x00,0x10,0x00,0x44,
 0x40,0x25,0x20,0x00,0x02,0x81,0x74,0x8f,0x20,0x80,0x24,0x10,0x85,0x28,0x54,
 0x20,0x21,0x92,0x10,0x12,0x90,0x44,0x20,0x44,0x48,0x22,0x69,0x55,0x95,0x4a,
 0x2a,0x49,0x92,0x54,0xa5,0xaa,0x92,0xaa,0x2a,0xa9,0x54,0x25,0x29,0x49,0x4a,
 0x55,0x55,0x49,0xa9,0xaa,0xaa,0x94,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x54,0x51,0x54,0x01,
 0x11,0x81,0x24,0x01,0x02,0x80,0xa4,0x04,0x10,0x44,0xda,0x05,0x04,0x42,0x00,
 0x22,0x10,0x52,0xd1,0x0a,0x89,0x80,0x50,0x42,0x11,0x80,0x04,0x01,0x20,0x00,
 0xac,0x92,0xaa,0x54,0xa5,0xaa,0x2a,0xa5,0x2a,0x55,0x55,0x55,0xaa,0xaa,0x4a,
 0xaa,0xaa,0xaa,0xaa,0x52,0x92,0xaa,0x4a,0x55,0x55,0x55,0x55,0xa9,0xaa,0x54,
 0x55,0x55,0x2a,0x55,0x55,0x55,0x49,0xad,0x56,0x55,0x55,0x55,0x55,0x95,0x2a,
 0x01,0x14,0x25,0x48,0x20,0x08,0x10,0xa2,0x88,0x0a,0x41,0x40,0x00,0x90,0x76,
 0x93,0x80,0x48,0x49,0x09,0x84,0x28,0x84,0x82,0x28,0x90,0x14,0x0a,0x25,0xd2,
 0x48,0x60,0x0a,0x99,0x54,0x49,0x49,0x92,0x92,0x24,0x49,0x55,0x92,0x92,0x54,
 0x92,0x4a,0x55,0x52,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xa4,0xaa,
 0x4a,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0xb5,0x52,0x49,0x55,0x55,
 0x55,0x55,0x55,0x15,0x54,0xa1,0x48,0x01,0x82,0x20,0x02,0x02,0x00,0x20,0x40,
 0x01,0x44,0x00,0xdd,0x01,0x24,0x40,0x00,0xa0,0x10,0xa2,0x10,0xa5,0x20,0x89,
 0x10,0x22,0x20,0x00,0x01,0x0a,0x40,0x00,0xaa,0x2a,0x52,0x55,0xaa,0xaa,0xaa,
 0xa4,0xaa,0x54,0xa5,0xaa,0x94,0xa4,0xaa,0x4a,0xa9,0x24,0x29,0xa5,0xaa,0xaa,
 0x2a,0x49,0x55,0x55,0xaa,0xaa,0x52,0x55,0x55,0xa5,0xaa,0x52,0xab,0xaa,0x4a,
 0x55,0xb5,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x01,0x54,0x52,0x92,0x10,0x82,0x80,
 0x48,0xa2,0x84,0x92,0x04,0x00,0xc4,0xf6,0x90,0x00,0x89,0x22,0x05,0x82,0x10,
 0x44,0x06,0x12,0x80,0x44,0x02,0xa0,0x12,0x91,0x00,0x12,0x92,0x68,0xa5,0x95,
 0x4a,0x55,0x92,0x94,0x2a,0xa9,0xaa,0x2a,0xa5,0x52,0x55,0x95,0x2a,0x55,0x55,
 0xa5,0x54,0x55,0x49,0xa5,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0xa5,
 0xaa,0x54,0x95,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x2a,0x54,0x82,0x8a,
 0x00,0x24,0x08,0x28,0x22,0x04,0x04,0x80,0x90,0x00,0x51,0x5f,0x02,0x02,0x44,
 0x08,0x00,0x08,0x22,0x90,0xcc,0x48,0x22,0x14,0x92,0x45,0x40,0x02,0xb2,0x80,
 0x08,0x56,0x29,0x2a,0x29,0x49,0x55,0x29,0x49,0x25,0x25,0xa9,0x94,0xaa,0x4a,
 0xaa,0x54,0x25,0x55,0x55,0x95,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x0a,0x01,0x34,0x51,0x24,0x01,0x00,0x02,0x01,0x80,0x10,0x89,0x02,0x20,0xc0,
 0x76,0x48,0x90,0x80,0x20,0x21,0x41,0x08,0x05,0x8a,0x10,0x88,0x41,0x04,0x40,
 0x24,0xa4,0x00,0x24,0x40,0x54,0x55,0x49,0x55,0x55,0xa9,0x4a,0x55,0x55,0x95,
 0x4a,0x55,0x95,0x54,0xa5,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xa4,0xaa,0x2a,0x55,0x55,0x55,0x55,0x95,0x54,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x95,0x2a,0x54,0x41,0x8a,0x00,0x40,0x91,0x00,0x50,0x24,0x42,
 0x00,0x01,0x02,0x90,0x1f,0x00,0x00,0xa4,0x00,0x08,0x08,0x21,0x50,0x55,0x94,
 0x80,0x28,0x24,0x12,0x82,0x04,0x22,0x80,0x04,0x59,0x49,0x55,0x92,0x24,0x25,
 0x55,0x2a,0xa9,0x54,0x55,0x2a,0xa9,0xaa,0x2a,0x25,0xa9,0xa4,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x92,0x2a,0x49,0x55,0x4a,0x52,0x55,0xa9,0xaa,0xaa,0x6a,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x01,0x28,0xa1,0x92,0x28,0x04,
 0xa8,0x04,0x81,0x08,0x22,0x4a,0x88,0x84,0x7a,0x92,0x24,0x41,0x92,0x40,0x42,
 0x08,0x02,0x18,0x10,0x92,0x24,0x05,0x81,0x48,0x28,0x24,0x25,0x58,0x54,0xa5,
 0xa4,0xaa,0xaa,0x94,0x52,0x49,0x95,0x52,0x49,0x49,0xa5,0x92,0x54,0x55,0x55,
 0x55,0x25,0x49,0x55,0x95,0x2a,0x49,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0x94,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x54,0x95,
 0x4a,0x00,0x02,0x20,0x80,0x10,0x04,0x80,0x00,0x01,0x00,0x20,0x6f,0x00,0x00,
 0x84,0x00,0x04,0x01,0x00,0x88,0x4a,0x49,0x80,0x20,0x24,0x24,0x21,0x91,0x00,
 0x80,0x00,0xb4,0x2a,0x95,0x24,0x49,0x55,0x4a,0x55,0x2a,0x95,0xaa,0xaa,0x2a,
 0x55,0xa5,0x54,0x25,0x95,0xaa,0xaa,0x24,0xa9,0xaa,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0x01,0x40,0x24,0x25,0x29,0x89,0x12,0x92,0xa0,0x2a,0x49,0x16,0x20,
 0x40,0xfa,0x52,0x92,0x50,0x15,0x90,0x48,0x12,0x21,0x29,0x49,0x96,0x24,0x25,
 0x49,0x53,0x92,0xa8,0x2c,0xca,0x54,0x95,0xa4,0xaa,0xaa,0x4a,0x55,0x4a,0xa5,
 0x4a,0x29,0x25,0xa9,0x54,0x55,0x95,0x54,0xa9,0x54,0x55,0x55,0x55,0x55,0x55,
 0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x54,0x95,0x92,0x10,0x00,0x00,0x80,0x00,0x02,
 0x08,0x00,0x80,0x80,0x24,0xfd,0x00,0x00,0x42,0x00,0x41,0x03,0x08,0x04,0x2a,
 0x08,0x80,0x20,0x84,0x00,0x01,0x20,0x82,0x80,0x00,0x54,0xa9,0x2a,0x55,0x92,
 0x54,0x92,0x52,0xa9,0x54,0x4a,0x55,0xa5,0x4a,0x2a,0xa9,0xaa,0xaa,0xaa,0x2a,
 0x55,0xa5,0xa4,0xaa,0xaa,0xaa,0x4a,0x49,0x55,0x55,0x52,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x15,0x01,0x50,0x49,0x02,0x01,
 0x49,0x24,0x50,0x40,0x81,0x24,0x14,0x08,0x40,0xda,0x09,0x92,0x80,0x00,0x10,
 0x24,0x42,0x40,0x25,0x08,0x91,0xa4,0x10,0x24,0x0a,0x49,0x20,0x22,0x24,0xb4,
 0x4a,0x92,0x24,0x55,0x4a,0x55,0x29,0x95,0x52,0x55,0xa9,0x2a,0x55,0xa5,0xa6,
 0x4a,0x4a,0x95,0xa4,0xaa,0xaa,0xaa,0x54,0xa5,0x2a,0x55,0x55,0x52,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x54,
 0x05,0x92,0x08,0x34,0x00,0x11,0x04,0x84,0x08,0x01,0x01,0x01,0x82,0xf6,0x91,
 0x00,0x54,0x82,0x44,0x83,0x08,0x09,0x8a,0x48,0x80,0x24,0x40,0x01,0x62,0x40,
 0x29,0x08,0x89,0x54,0xa9,0xaa,0x4a,0xa5,0x52,0xaa,0x4a,0x55,0x95,0x52,0x4a,
 0xaa,0x52,0xa9,0x28,0xa9,0x52,0x52,0x55,0x49,0x2a,0x55,0x25,0x55,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x01,0x68,0x29,0x81,0x00,0x24,0x80,0x08,0x11,0x08,0x12,0x28,
 0x80,0x20,0xf8,0x02,0x20,0x81,0x08,0x90,0x2a,0x2a,0x40,0x25,0x04,0x94,0x20,
 0x0a,0x48,0x02,0x92,0x00,0x41,0x00,0x59,0x25,0x49,0xa9,0x54,0x29,0x45,0xaa,
 0xa4,0x54,0x55,0x55,0x49,0x2a,0x95,0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x49,0x55,0x95,0xaa,0x94,0x52,0x55,0x4a,0xad,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x54,0x92,0x44,0x24,0x40,0x00,0x42,0x20,
 0x80,0x20,0x40,0x06,0x24,0x88,0xea,0x23,0x02,0x40,0x00,0x41,0x41,0x85,0x84,
 0x92,0x24,0x81,0x08,0x20,0x02,0x84,0x80,0x44,0x04,0x12,0xd4,0xaa,0x52,0xaa,
 0x4a,0xaa,0x54,0xa9,0x2a,0xa5,0xa4,0x92,0xaa,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,
 0x4a,0xaa,0x52,0xa9,0xaa,0x2a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x81,0x48,0x52,0x01,
 0x29,0x92,0x10,0x08,0x8a,0x08,0x05,0x82,0x00,0x00,0xb9,0x8b,0x90,0x94,0x42,
 0x90,0x12,0x21,0xa9,0x10,0x08,0x90,0x64,0x09,0x91,0x54,0x10,0x21,0x90,0x88,
 0x54,0x49,0xaa,0x4a,0x52,0x95,0x2a,0x25,0xa9,0x2a,0x95,0x54,0x55,0x49,0xa9,
 0x92,0x94,0x24,0x55,0xa9,0xaa,0x2a,0x55,0x55,0xa5,0xaa,0xaa,0x94,0x2a,0x55,
 0x55,0x55,0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x12,
 0x24,0x92,0x24,0x09,0x00,0x00,0x40,0x22,0x20,0x02,0x82,0x01,0x80,0x44,0xf4,
 0x02,0x04,0x40,0x00,0xa2,0x41,0x08,0x52,0x44,0x46,0x84,0x00,0x40,0x00,0x08,
 0x45,0x89,0x00,0x20,0xac,0x52,0x25,0xa9,0xaa,0x52,0x49,0x55,0xa5,0x54,0x55,
 0xa5,0x24,0x55,0x55,0x55,0x55,0x55,0x49,0xaa,0x92,0x54,0x25,0xa9,0xaa,0x54,
 0x55,0x55,0x55,0x55,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x15,0x88,0x48,0x92,0x80,0x84,0x44,0x24,0x08,0x81,0x50,0x90,
 0x88,0x24,0x00,0xd2,0x4f,0x20,0x44,0x41,0x48,0x01,0x42,0x29,0x11,0x10,0x51,
 0x55,0x12,0x49,0x22,0x00,0x02,0x4a,0x0a,0x54,0x55,0x52,0x95,0x14,0xa9,0x54,
 0x29,0x95,0x4a,0x29,0x55,0xaa,0xaa,0x94,0x54,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xa9,0x2a,0xa9,0x52,0xa9,0xaa,0xaa,0x52,0x95,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x22,0x92,0x24,0x49,0x10,0x10,0x91,
 0x04,0x04,0x10,0x45,0x02,0x00,0x12,0xe9,0x07,0x81,0x44,0x00,0x51,0x54,0x88,
 0x44,0x49,0x8a,0x24,0x55,0x08,0x01,0x49,0x12,0x34,0x00,0x49,0xb5,0xa4,0x94,
 0x52,0xa9,0x4a,0x25,0xa5,0xaa,0x52,0x52,0xa9,0x52,0xa5,0x52,0xa5,0xa4,0x24,
 0x55,0xa5,0xaa,0x4a,0x55,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x54,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0x55,0x55,0x15,0x88,0x48,0x92,
 0x00,0x42,0x02,0x20,0x80,0x90,0x04,0xa0,0x40,0x85,0x40,0xa4,0x2e,0x08,0x80,
 0x22,0x84,0x02,0x25,0x91,0x0a,0x22,0x89,0xc8,0xaa,0x6a,0x10,0x80,0x04,0x49,
 0x00,0x54,0x95,0x4a,0x29,0xa5,0x54,0xaa,0x54,0x52,0xaa,0xaa,0x2a,0x95,0x94,
 0xaa,0x2a,0x95,0xaa,0xaa,0xaa,0x54,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xb5,0xaa,0xaa,0xaa,
 0x12,0x22,0x92,0x24,0x09,0x08,0x88,0x04,0x25,0x80,0x10,0x14,0x28,0x10,0x00,
 0xf2,0x0f,0x20,0x52,0x00,0xb0,0x54,0x10,0x44,0x89,0x08,0x24,0x92,0x52,0x94,
 0x94,0x24,0x48,0x00,0x12,0xd4,0x52,0x52,0x4a,0x55,0x49,0x49,0x49,0xa5,0x4a,
 0x25,0xa5,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x49,0x95,0x4a,0xaa,0x4a,0x55,0x95,
 0x54,0x25,0x95,0x52,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xd5,
 0x4a,0x55,0x55,0x95,0x2a,0x88,0x48,0x52,0x21,0x21,0x21,0x20,0x04,0x24,0x10,
 0x49,0x41,0x02,0x92,0x88,0x9b,0x04,0x04,0x20,0x09,0x09,0x05,0x91,0x24,0x46,
 0x81,0xa4,0x88,0xa2,0x50,0x01,0x29,0x92,0x88,0x54,0x29,0x55,0x55,0x49,0x2a,
 0x55,0x55,0x99,0x52,0xaa,0x52,0x49,0x55,0xa9,0xa4,0xaa,0x92,0x2a,0xa9,0xaa,
 0x52,0xaa,0x54,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0xb5,0xaa,0x4a,0x55,0x15,0x22,0x92,0x0a,0x04,0x00,0x00,
 0x12,0x90,0x80,0x40,0x14,0x48,0x41,0x00,0x64,0x1f,0x20,0x51,0x01,0x44,0x20,
 0x90,0xa0,0x04,0x10,0x24,0x00,0x21,0xa4,0x00,0x24,0x10,0x00,0x20,0xac,0x4a,
 0x49,0x52,0xaa,0x52,0x29,0xa5,0xa2,0x54,0x49,0x2a,0x95,0x24,0x55,0x55,0x52,
 0xaa,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,
 0xaa,0x2a,0x95,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0x14,0x80,0x48,
 0xa1,0x01,0x29,0x89,0x10,0x05,0x88,0x14,0x0a,0x60,0x08,0x24,0x91,0x5f,0x04,
 0x04,0x10,0x01,0x89,0x04,0x48,0x05,0x05,0x81,0x54,0x14,0x51,0x12,0x00,0x52,
 0x52,0x8a,0x54,0xa5,0xaa,0x2a,0x55,0x4a,0x95,0x94,0xac,0x2a,0x55,0x95,0xaa,
 0xaa,0x2a,0x55,0x95,0xaa,0x54,0xa5,0xaa,0xaa,0x52,0x55,0x52,0x55,0x55,0xa9,
 0x54,0x55,0x55,0x55,0x25,0x55,0x55,0xab,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x95,0x2a,0x0a,0x12,0x4a,0x34,0x21,0x48,0x12,0x92,0x24,0x11,0x21,0xaa,0x42,
 0x00,0x64,0x3b,0x92,0x00,0x42,0x08,0x20,0x90,0xa0,0xb0,0x20,0x14,0x82,0x40,
 0x6a,0x72,0x9b,0xa4,0x24,0x49,0xb4,0x54,0x92,0xa4,0xa2,0x2a,0xa9,0xaa,0x52,
 0xa5,0xaa,0x52,0x29,0x55,0x49,0x49,0x55,0x25,0xa5,0x2a,0x25,0x55,0x95,0xaa,
 0xaa,0x52,0x55,0x55,0x95,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0x54,0x29,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x25,0xa0,0x54,0x29,0x01,0x08,0x02,0x48,0x00,0x80,
 0x40,0x0a,0x50,0x09,0x11,0x91,0x3e,0x00,0x91,0x00,0x20,0x09,0x02,0xa4,0x04,
 0x00,0x81,0x20,0x94,0x90,0x00,0x40,0x40,0x00,0x00,0xa9,0x2a,0x55,0x55,0x29,
 0xa5,0x4a,0x25,0x55,0x52,0x25,0xa9,0xa4,0x92,0xaa,0x2a,0xa9,0x54,0x55,0x55,
 0x55,0x49,0x55,0x49,0x55,0xaa,0xaa,0x4a,0x55,0x95,0xaa,0x5a,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x15,0x0a,0xa0,0x44,0x44,0xb4,
 0xaa,0xaa,0xd6,0x56,0x55,0x41,0xed,0x04,0x44,0x48,0xfb,0x5a,0x00,0x24,0x09,
 0x40,0x48,0x52,0x4b,0x94,0x04,0x92,0x00,0xe2,0x76,0x95,0x95,0xb6,0x5d,0x56,
 0x49,0x49,0x49,0x56,0x2a,0x55,0xaa,0x4a,0x95,0x54,0x55,0x55,0x55,0x2a,0x55,
 0xa5,0xaa,0x2a,0xa9,0xaa,0xaa,0x54,0x55,0x55,0x55,0x25,0x55,0x55,0x55,0x55,
 0xa5,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x52,0x55,0x55,0xd5,0xaa,0xaa,0x14,0x40,
 0x15,0x2a,0x01,0xaa,0xb5,0x55,0x6b,0x5b,0x5d,0x00,0x74,0x4b,0x00,0x22,0x7d,
 0xad,0x05,0x01,0x40,0x12,0x11,0xc0,0x16,0x00,0xa8,0x00,0x94,0x50,0xab,0xed,
 0xf6,0x6d,0xab,0x6b,0xa5,0xa4,0x54,0x49,0xa5,0x92,0x92,0xa4,0xaa,0xaa,0x2a,
 0x95,0x54,0xa5,0x52,0x55,0x4a,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0xaa,
 0xaa,0xaa,0x52,0x25,0x55,0x55,0x55,0x55,0xb5,0xaa,0x4a,0xad,0xaa,0xaa,0x2a,
 0x55,0x95,0x2a,0x0a,0xa4,0x50,0x49,0x6c,0x6b,0xb7,0xad,0xea,0x2a,0x49,0xdd,
 0x22,0x12,0x90,0xf6,0x75,0x20,0x48,0x02,0x40,0x40,0xaa,0x05,0x28,0x51,0xa4,
 0x02,0xa4,0xd6,0x5a,0xab,0xba,0x77,0x55,0x95,0x2a,0x95,0x52,0x4a,0xaa,0x54,
 0x95,0x24,0x49,0x52,0xa9,0x4a,0x55,0x95,0xaa,0x52,0x52,0x25,0x55,0x55,0x25,
 0x55,0x52,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,0xaa,0xaa,0x4a,0x55,0xb5,
 0x52,0x55,0x55,0x55,0x55,0x55,0x15,0xa0,0x92,0x0a,0x00,0x96,0x14,0x48,0x20,
 0x11,0x55,0x00,0xf5,0x0a,0x40,0x22,0x7d,0x8a,0x02,0x01,0x50,0x15,0x01,0x40,
 0x25,0x02,0xaa,0x00,0x50,0x89,0x55,0x55,0x55,0xd5,0x54,0xab,0x52,0x95,0x52,
 0xaa,0x52,0x49,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0xa9,0x54,0x92,0xaa,0x2a,
 0x55,0x29,0x49,0xaa,0xaa,0xaa,0x54,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,
 0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x0a,0x24,0x69,0x89,
 0x02,0xa0,0x00,0x85,0x04,0x08,0x51,0x1d,0x24,0x01,0x48,0x5a,0x20,0x48,0x48,
 0x05,0x40,0x90,0x54,0x04,0x48,0x14,0xa2,0x24,0x52,0xaa,0x92,0x54,0x25,0x55,
 0x6d,0x25,0xa9,0xaa,0x4a,0x55,0x55,0x45,0x52,0xa9,0x92,0xa4,0x92,0x94,0x4a,
 0xa5,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x49,0x95,0xaa,0xaa,0xaa,0x2a,0x55,
 0xaa,0xaa,0xb4,0xaa,0xaa,0xaa,0xaa,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x15,
 0x40,0x49,0x12,0x21,0xa5,0x0a,0xaa,0x20,0x40,0x25,0x88,0x76,0x4a,0x50,0x02,
 0x75,0x15,0x21,0x00,0xa8,0x2a,0x00,0xa1,0x02,0x80,0xaa,0x00,0xd1,0xa9,0x52,
 0xaa,0x2a,0x55,0xa5,0x55,0xa9,0xa4,0x24,0x25,0x49,0x4a,0xa9,0x4a,0x4a,0xaa,
 0xaa,0x54,0xa5,0x2a,0x55,0x55,0x95,0x52,0xa9,0x4a,0x55,0xa5,0xaa,0xaa,0xaa,
 0x92,0x54,0x55,0x55,0x55,0xa5,0x4a,0x55,0x52,0x55,0x55,0x95,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x4a,0x2a,0x0a,0x94,0xa4,0x00,0x09,0x50,0x00,0x8a,0x0a,0x0a,0x50,
 0x1f,0x25,0x02,0xa8,0x7e,0x40,0x8a,0x88,0xaa,0x2a,0x10,0x54,0x12,0x15,0x15,
 0x20,0x24,0xa6,0x4a,0x55,0xa5,0xaa,0xaa,0x54,0x95,0x4a,0x55,0xaa,0xaa,0x94,
 0x2a,0x55,0x55,0x55,0x95,0x2a,0x55,0xaa,0xaa,0xa4,0x2a,0x95,0x4a,0x55,0xa5,
 0x2a,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x95,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x15,0x40,0x21,0x49,0x14,0x53,0x85,0xaa,
 0x20,0xa0,0x04,0xa5,0x0d,0x90,0x48,0x42,0xe8,0x2a,0x2a,0x20,0xa8,0x88,0x00,
 0x21,0x01,0x40,0xaa,0x02,0xd1,0x51,0x29,0x49,0x52,0x49,0xd2,0xa9,0x4a,0xa9,
 0xa4,0x92,0x94,0xaa,0x94,0x52,0xa9,0x92,0xa4,0x4a,0x55,0xa5,0x24,0x95,0xa4,
 0xaa,0xaa,0x54,0xaa,0x54,0x55,0xa9,0xaa,0xaa,0x2a,0xa9,0x4a,0x55,0x55,0x55,
 0x55,0x6a,0x55,0x55,0x55,0x55,0x55,0xd5,0xaa,0xaa,0xaa,0x12,0x2a,0x54,0x92,
 0xc0,0x04,0x12,0x00,0x82,0x04,0x11,0x68,0xa7,0x4c,0x00,0x88,0xfa,0x40,0x01,
 0x00,0x15,0x25,0x48,0x54,0x05,0x82,0x4a,0x20,0xa4,0x2a,0x55,0x95,0x2a,0x55,
 0x55,0x6d,0x29,0x25,0x95,0x54,0xa9,0xa4,0x52,0x95,0x92,0x54,0x55,0x52,0x4a,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa5,0xaa,0x4a,0xa9,0x54,0x55,0x55,
 0x55,0x49,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,
 0x15,0x00,0x89,0x24,0x85,0xa2,0x88,0xaa,0x28,0x41,0x45,0xd2,0x0d,0x28,0x92,
 0x02,0xa4,0x2b,0xa8,0x48,0x50,0x11,0x00,0xa1,0x00,0x28,0x25,0x00,0xa9,0x94,
 0x92,0xaa,0xaa,0xaa,0x6a,0xa9,0xa4,0xaa,0xaa,0xaa,0x4a,0x2a,0x55,0x52,0xaa,
 0x4a,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0xa5,0x94,0x4a,0x55,0x55,0x49,0x55,
 0x55,0x55,0xa5,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x2a,0x2a,0x24,0x49,0x50,0x89,0x24,0x00,0x01,0x94,0x00,
 0xb5,0xa7,0x90,0x00,0x50,0xd9,0x41,0x05,0x00,0x1d,0x4a,0x10,0x54,0x81,0x80,
 0x4a,0x20,0x50,0xa5,0x54,0x52,0x52,0x92,0xd4,0x54,0x55,0x24,0x49,0x25,0x55,
 0x55,0x4a,0x55,0x55,0x55,0x49,0x55,0x55,0x4a,0x4a,0x92,0x92,0x54,0x55,0xa9,
 0xa4,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0xa5,0xa4,0xaa,0xaa,0xaa,
 0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x14,0x80,0x92,0x94,0x82,0x24,0x02,
 0x55,0x54,0x41,0x81,0xe8,0x02,0x54,0xa5,0x04,0xe5,0x2a,0x20,0x24,0x52,0x11,
 0x04,0x29,0x0a,0xa4,0x16,0x81,0xaa,0x52,0x4a,0x95,0x4a,0x55,0xb5,0xb4,0x2a,
 0x55,0x55,0x92,0x24,0x49,0xa5,0x2a,0x25,0xa9,0x2a,0x49,0xaa,0xaa,0x52,0x55,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0xaa,0x54,0x4a,0xa5,0xaa,0x4a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x95,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,0x28,
 0x51,0x64,0x91,0xa8,0x00,0x01,0x34,0x14,0xdd,0x49,0x21,0x00,0x10,0xda,0x43,
 0x15,0x80,0x2c,0x05,0x50,0x54,0x81,0x00,0x49,0x10,0x50,0x95,0x52,0xaa,0x54,
 0xa5,0x6a,0x54,0x51,0x49,0x92,0xaa,0xaa,0x52,0x2a,0x49,0xa9,0x92,0x52,0x95,
 0x92,0x52,0x55,0x55,0x55,0x95,0x54,0xaa,0x2a,0x49,0x55,0x55,0x55,0xaa,0x4a,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x2a,0x10,0x8a,0x0a,0xa1,0x24,0x12,0x54,0x52,0x91,0xa0,0xf6,0x12,0xa8,
 0x2a,0x85,0xa2,0x17,0x02,0x10,0x92,0x50,0x00,0xa1,0x04,0xa9,0x16,0x80,0x54,
 0xa9,0xaa,0x92,0xaa,0x54,0x59,0xa9,0x2a,0x55,0x55,0xa9,0x92,0x2a,0xa5,0xaa,
 0x2a,0x55,0xaa,0x52,0x55,0x55,0xaa,0xa4,0x92,0x52,0x55,0x25,0xa9,0xaa,0xaa,
 0x4a,0x55,0x55,0xa9,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x4a,0x15,0x42,0x50,0x54,0x69,0x92,0x48,0x01,0x08,0x4c,
 0x80,0x5a,0x41,0x22,0x01,0x10,0xd4,0xa2,0x28,0x42,0x2c,0x05,0x04,0x5c,0x22,
 0x84,0x42,0x28,0xb2,0x52,0x4a,0x55,0x49,0x95,0x2a,0x6c,0xa5,0x92,0xaa,0x4a,
 0xaa,0x54,0x29,0x55,0x4a,0xa5,0x92,0x54,0xaa,0x94,0x92,0x2a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x25,0x55,0xa9,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0x2a,0xa9,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x10,0x2a,0x89,0xa0,0x44,
 0x12,0xa8,0x82,0x12,0x54,0x7d,0x90,0xc4,0x44,0x85,0xd4,0x17,0x05,0x00,0x95,
 0x14,0x50,0x22,0x01,0x40,0x16,0x80,0x50,0x2a,0x25,0x29,0x55,0x52,0xba,0x54,
 0x29,0x49,0x91,0x54,0x55,0x4a,0x55,0x49,0x55,0xa9,0xaa,0x4a,0x25,0x55,0x55,
 0x55,0x55,0x2a,0x25,0x55,0x95,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0xaa,0x2a,
 0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,
 0x41,0x25,0x19,0x12,0x41,0x05,0x54,0x8a,0x90,0xb6,0x02,0x50,0x12,0x10,0xa2,
 0x4f,0x48,0x94,0x54,0x42,0x00,0x59,0x4a,0x89,0x42,0x24,0xaa,0xa4,0x54,0x52,
 0xaa,0xaa,0x2e,0x54,0x55,0xaa,0x2a,0x49,0x92,0x92,0xa4,0xaa,0xa4,0x4a,0x4a,
 0x55,0x55,0xa5,0xaa,0xa4,0xa4,0x52,0x55,0x55,0xa9,0xa4,0xaa,0xaa,0xaa,0x92,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x2a,0x00,0x94,0x50,0xa2,0x44,0x94,0x50,0x01,0x05,0xa4,0x2f,0x50,
 0x85,0x84,0xa4,0x50,0x2f,0x12,0x00,0x9a,0x14,0x48,0xa8,0x02,0x20,0x11,0x08,
 0x29,0x55,0x55,0x55,0x25,0x49,0x15,0xb4,0x4a,0x95,0xa4,0xaa,0x4a,0x55,0x95,
 0x24,0x95,0x54,0x29,0xa9,0x52,0x55,0x92,0xaa,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,
 0xaa,0x52,0x2a,0x55,0x29,0x55,0x55,0x55,0x55,0xa5,0xaa,0x54,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x15,0xaa,0x28,0x45,0x59,0x92,0x48,0x02,0xaa,
 0x90,0x54,0x9d,0x02,0x90,0x0a,0x00,0xca,0x4d,0x09,0xa2,0x24,0x01,0x00,0x15,
 0x25,0x05,0x42,0x21,0x5a,0x49,0x92,0x4a,0xa9,0xaa,0xba,0x54,0x91,0x52,0x55,
 0x25,0x55,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0x92,0x94,0x54,0x55,0x95,0x4a,0x55,
 0x52,0x55,0x55,0x95,0xaa,0xaa,0x52,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x29,0x00,0x44,0x29,0x94,
 0x24,0x25,0x54,0x41,0x05,0xd2,0x27,0x54,0xa5,0xa2,0x2a,0x21,0x3f,0x02,0x08,
 0x9a,0x14,0x4a,0x54,0x09,0x90,0x14,0x48,0x25,0x55,0x55,0x55,0x55,0x55,0x4d,
 0x59,0x55,0x49,0x2a,0xa9,0x52,0xa5,0x4a,0x95,0x52,0x25,0x55,0x55,0x55,0xa5,
 0xaa,0x52,0x55,0x4a,0x55,0xaa,0x92,0x54,0x55,0x55,0x55,0x55,0x55,0x95,0x52,
 0x55,0xa9,0xaa,0xaa,0x4a,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x15,
 0xaa,0x12,0x52,0x6d,0x7b,0xbb,0x7b,0x1f,0x90,0x6c,0xdf,0x6b,0xdb,0x0a,0x80,
 0x54,0xfd,0x4d,0x40,0x75,0x07,0x00,0x75,0x57,0x40,0x40,0x82,0xda,0x6d,0xdb,
 0xda,0xb6,0x6d,0x4b,0xd4,0x2a,0x55,0x49,0x95,0xa4,0x94,0x2a,0xa9,0x94,0x54,
 0x92,0x2a,0x55,0x95,0x24,0x55,0x52,0x55,0x55,0x55,0xaa,0xaa,0x24,0xa5,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x95,0x52,0x55,0x55,0x55,
 0x55,0x55,0x55,0x15,0x00,0x54,0x89,0x90,0x84,0x90,0x84,0xa8,0x02,0xf5,0xa5,
 0x90,0x24,0x92,0x24,0x20,0xf7,0x03,0x12,0x8a,0x10,0xa4,0x94,0x10,0x15,0x92,
 0x50,0xa5,0x92,0x84,0x44,0x49,0xa2,0x44,0xa8,0x92,0x2a,0x55,0x4a,0x55,0x52,
 0x52,0xa5,0xaa,0x4a,0x55,0x92,0x4a,0xaa,0xaa,0x4a,0x55,0xa9,0xaa,0x92,0xaa,
 0x4a,0x55,0x55,0x55,0x49,0x49,0x55,0x55,0xaa,0xaa,0x52,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x2a,0x21,0x25,0x01,0x00,0x02,0x10,
 0x0a,0xa8,0xda,0x56,0x02,0x80,0x4a,0x90,0x42,0x7d,0x0b,0x40,0x05,0x02,0x01,
 0x15,0x94,0x80,0x00,0x44,0x81,0x00,0x10,0x50,0x00,0x48,0x20,0x56,0xa5,0x48,
 0xa9,0x54,0x4a,0x55,0xa5,0x2a,0x25,0x55,0xa9,0xaa,0x54,0xa9,0xaa,0x54,0x95,
 0x4a,0x92,0xaa,0xaa,0x52,0x55,0x55,0x4a,0x55,0x55,0xaa,0xaa,0x2a,0x95,0xaa,
 0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x12,0x40,0x48,0x91,
 0x88,0x64,0x30,0x51,0x25,0x41,0xb4,0xdf,0x57,0x48,0x15,0x05,0xa8,0xfa,0x07,
 0x11,0x4a,0x10,0x20,0x2a,0x11,0x20,0x48,0x52,0x11,0x91,0xc4,0x84,0x64,0x82,
 0x18,0xb4,0x52,0xa5,0x94,0x4a,0xa5,0x2a,0x29,0xa9,0x52,0x29,0x25,0x55,0x55,
 0x55,0x49,0x55,0x52,0x55,0x55,0x55,0x55,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x15,0x0a,0x15,0x2a,0x21,0x00,0x09,0x64,0x85,0x88,0x7e,0xb5,0x0e,0xf1,0x05,
 0xa8,0x84,0xd6,0x12,0x44,0x05,0x09,0x85,0x14,0x4a,0x82,0x22,0x35,0x01,0x01,
 0x00,0x80,0x00,0x10,0x47,0x54,0x95,0xaa,0x52,0xa9,0x94,0xa4,0x4a,0xa5,0xac,
 0x52,0x55,0x92,0x92,0x4a,0x2a,0xa5,0xaa,0xaa,0xaa,0x54,0x92,0x2a,0x55,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,
 0x55,0x55,0x55,0x55,0x15,0x90,0x40,0x89,0x04,0x12,0x42,0xb5,0x22,0xa2,0xaa,
 0xef,0x0d,0x5c,0xaa,0x02,0x91,0xb4,0xae,0x80,0x4a,0x00,0x20,0x55,0x11,0x00,
 0x49,0x0a,0x4a,0x3e,0x29,0x92,0x90,0x04,0x88,0x54,0x29,0x29,0x95,0x54,0xaa,
 0x52,0xaa,0x2a,0x45,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x52,0x95,0xaa,
 0xaa,0xaa,0x4a,0x55,0xa5,0x54,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x42,0x2a,0x25,0x51,0x29,0x5d,
 0x4d,0x08,0x28,0x55,0xda,0xe7,0x53,0x15,0x48,0x44,0x69,0x55,0x12,0x4b,0x82,
 0x88,0x4a,0x52,0x20,0x52,0x25,0x21,0x41,0x52,0x92,0xa5,0xa4,0x48,0xb4,0x52,
 0x52,0xaa,0x92,0x52,0x4a,0x29,0xa9,0xaa,0x4a,0x52,0x25,0x55,0xaa,0xaa,0x94,
 0xa4,0x2a,0xa9,0x52,0x55,0xa5,0x54,0x55,0xaa,0x4a,0x55,0x55,0x55,0xaa,0xaa,
 0x4a,0x55,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x12,0x10,0x90,
 0xa8,0x04,0x00,0x52,0xa5,0x22,0x51,0xaa,0xea,0x16,0xac,0x42,0x12,0x11,0x95,
 0xd5,0x80,0x04,0x10,0x22,0x2a,0x94,0x80,0x88,0x1a,0x8a,0x40,0x00,0x00,0x01,
 0x00,0x02,0x54,0x95,0x4a,0x49,0x4a,0x95,0xaa,0x4a,0x95,0x54,0xa5,0x4a,0x52,
 0x49,0x55,0x92,0x52,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0xa9,0xaa,0x4a,0x49,0xa9,0xaa,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x2a,0x4a,0x25,0x45,0x10,0x22,0xaa,0x14,0x08,0x84,0xa4,0xb4,0x67,0x91,
 0x14,0x41,0x44,0x52,0x6a,0x24,0x23,0x05,0x80,0x82,0x28,0x10,0x22,0x6a,0x42,
 0x94,0x44,0x09,0x8a,0x94,0x90,0x54,0xa9,0x94,0xaa,0xaa,0xa4,0x94,0x54,0xaa,
 0x92,0x54,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,0x4a,0x4a,0x55,0xaa,0x24,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x50,0x91,0x82,0x88,0x54,0x42,0x42,0x51,
 0x12,0xed,0x85,0x4a,0x42,0x10,0x11,0xa8,0xaa,0x80,0x0a,0x00,0x29,0x29,0x4a,
 0x80,0x88,0xa4,0x42,0x01,0x41,0x40,0x22,0x00,0x08,0x6a,0x95,0xaa,0x4a,0x29,
 0x55,0xa5,0x4a,0xa5,0xaa,0xaa,0x52,0x29,0x55,0x55,0x55,0x55,0xa9,0xaa,0x4a,
 0x55,0x55,0x49,0xaa,0xa4,0x2a,0xa9,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x15,0xaa,0x8a,0x24,0x11,0x20,
 0x2a,0x09,0x11,0x00,0x49,0xba,0x67,0x22,0x08,0x45,0x44,0x01,0x69,0x52,0x41,
 0x44,0x80,0x00,0x0c,0x09,0x22,0x52,0x4b,0xa4,0x08,0x12,0x42,0x92,0x24,0x54,
 0x29,0x49,0x92,0x52,0x29,0x29,0xa9,0x94,0x54,0x49,0x25,0x55,0x49,0xaa,0x92,
 0x24,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x95,0xaa,0x4a,0x55,0x55,
 0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0x55,0x55,0xa5,0x2a,0x00,
 0x24,0x95,0x80,0x04,0x1a,0x40,0x84,0x54,0xa0,0xea,0x45,0x89,0x42,0x10,0x21,
 0x54,0x6a,0x80,0x0a,0x11,0x24,0x92,0x22,0xa0,0x88,0x88,0x44,0x80,0x82,0x00,
 0x14,0x00,0x00,0xa9,0x4a,0x55,0x55,0x95,0x4a,0x55,0x95,0xaa,0x4a,0xaa,0x54,
 0x95,0xaa,0x52,0xaa,0xaa,0x2a,0x49,0x55,0x25,0x55,0x55,0x95,0xaa,0xa4,0xaa,
 0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0x5a,0xaa,0x4a,0x55,0x55,0xab,0xaa,0xaa,
 0xaa,0xaa,0x12,0xaa,0x48,0x48,0x0a,0x50,0xaa,0x9a,0x28,0x41,0x45,0xba,0x30,
 0x11,0x55,0xa5,0x54,0xa5,0x2a,0x29,0x21,0x80,0x80,0x00,0x85,0x08,0x20,0x22,
 0x95,0x49,0x48,0x4a,0xa4,0xa4,0x4c,0xac,0x52,0x92,0x54,0x2a,0x55,0x4a,0x52,
 0x29,0x95,0x92,0xaa,0xa4,0xaa,0x4a,0x55,0x55,0x49,0x55,0x29,0xa9,0xa4,0xaa,
 0xaa,0x4a,0x55,0x55,0x55,0xaa,0xaa,0x94,0x52,0x92,0xaa,0x52,0x55,0x55,0x55,
 0x55,0x4a,0x55,0x55,0x55,0x55,0x15,0x00,0x24,0x25,0x81,0x04,0xaa,0x4a,0x55,
 0xad,0x34,0x6d,0xa9,0x54,0xa9,0xaa,0x4a,0x55,0x72,0x80,0x05,0x08,0x29,0x50,
 0x00,0x42,0x0a,0x48,0x14,0x21,0x10,0x80,0x04,0x00,0x00,0x68,0xa9,0x4a,0x25,
 0xa5,0xa4,0x52,0x55,0x4a,0xa9,0xaa,0x4a,0xaa,0x24,0x55,0xa5,0x24,0x55,0x55,
 0x55,0x55,0x55,0x52,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0xad,0xaa,
 0xaa,0xaa,0x54,0x55,0x55,0xb5,0xaa,0xaa,0x52,0x55,0x2a,0xaa,0x48,0x49,0x08,
 0x20,0x6a,0xbb,0x6b,0x5b,0xdb,0x0d,0xe2,0x77,0xd7,0x6e,0xbf,0xed,0x2d,0x52,
 0x91,0x22,0x80,0x02,0x25,0x08,0xa1,0x80,0x2a,0x0e,0x41,0x08,0x48,0x4a,0x92,
 0x56,0x25,0xa9,0x4a,0xa9,0x4a,0x95,0x4a,0x55,0xa5,0x54,0x52,0x95,0xaa,0x54,
 0x4a,0x55,0x55,0x95,0x4a,0x55,0x55,0x95,0xaa,0x54,0x55,0x52,0x55,0x95,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x95,0xaa,0x4a,0x55,0x55,0xad,0xaa,0x12,
 0x00,0x25,0x92,0x42,0x89,0x15,0x14,0x08,0xa4,0x00,0x81,0x08,0x00,0x20,0x01,
 0x00,0x00,0x02,0x40,0x01,0x08,0x12,0x48,0x00,0x42,0x08,0x2a,0x20,0x41,0x44,
 0x22,0x29,0x00,0x08,0x54,0x95,0x2a,0xa9,0x2a,0xa9,0xa4,0xa4,0x52,0xaa,0x2a,
 0x55,0xa5,0xaa,0x4a,0x35,0x55,0x49,0x52,0x55,0x95,0x4a,0x55,0xa5,0xaa,0x4a,
 0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x95,0x2a,0x4a,0xa8,0x24,0x11,0x20,0x40,0x44,0x20,0x40,0x12,0x04,
 0x40,0x44,0x04,0x92,0x90,0x24,0x90,0x94,0x24,0x20,0x40,0x80,0xa0,0x10,0x21,
 0x80,0x5a,0x10,0x10,0x00,0x90,0x24,0x21,0xb4,0x52,0x52,0x2a,0x49,0x95,0x2a,
 0x95,0x94,0x92,0x52,0x25,0x29,0x49,0x55,0x49,0x49,0x55,0x55,0xaa,0x54,0x55,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x10,0x44,0x92,0x00,0x92,0x24,0x01,
 0x04,0x09,0x80,0x42,0x12,0x10,0x41,0x0a,0x04,0x00,0x02,0x40,0x01,0x0a,0x15,
 0x2a,0x08,0xaa,0x08,0x25,0xc0,0x84,0x04,0x92,0x24,0xd9,0x84,0x54,0xa9,0x4a,
 0x95,0xaa,0x4a,0xa5,0x52,0x55,0x55,0xa9,0x54,0x55,0x55,0xa9,0xaa,0xaa,0x54,
 0x55,0x49,0x55,0xa9,0x52,0x55,0x55,0xa9,0xaa,0x2a,0xa9,0x4a,0x29,0x29,0x55,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x42,0x29,0x25,
 0x25,0x10,0x20,0x92,0x10,0x60,0x12,0x12,0x80,0x00,0x08,0x4a,0x20,0x49,0x20,
 0x69,0xa4,0xa0,0xa0,0x14,0x20,0x95,0xa2,0x90,0xaa,0x00,0xa0,0x00,0x20,0x01,
 0x10,0x54,0x25,0xa9,0xa4,0x94,0x54,0xaa,0x54,0xa5,0x54,0x4a,0x95,0xaa,0x2a,
 0x25,0x55,0x55,0xa5,0xaa,0xaa,0x92,0xaa,0x2a,0x95,0xaa,0xaa,0x54,0xa9,0x2a,
 0x55,0x55,0x55,0x95,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x15,0x28,0x44,0x91,0x24,0xa9,0x4a,0x12,0x92,0x44,0x24,0x49,0x4a,0x94,0x22,
 0x45,0x92,0x12,0x09,0x50,0x49,0x42,0x94,0x0a,0x88,0x48,0x14,0x04,0xa0,0xd9,
 0x52,0xb2,0xa5,0x24,0x49,0x6a,0x95,0x54,0xaa,0x4a,0x25,0x49,0x4a,0x52,0x95,
 0x2a,0xa5,0x4a,0x52,0x55,0x49,0x92,0x2a,0x49,0x55,0x55,0x95,0xaa,0xaa,0x54,
 0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0xb5,0xaa,0xaa,0xaa,0x54,0x55,0xb5,
 0xaa,0xaa,0xaa,0x4a,0x25,0x82,0x28,0x2a,0x81,0x24,0x10,0x42,0x00,0x11,0x01,
 0x02,0x00,0x01,0x08,0x14,0x08,0x85,0x40,0x22,0x00,0x88,0xaa,0x22,0x02,0x05,
 0x49,0x52,0x55,0x00,0x08,0x08,0x40,0x88,0x00,0x54,0xa9,0xa2,0x92,0x54,0xaa,
 0xfe,0x95,0x2a,0xa9,0xd2,0x2a,0x57,0x55,0x5d,0xbf,0x5f,0xbf,0xaa,0x5e,0x5f,
 0xdf,0x4f,0x5d,0xa5,0x4a,0xbf,0x4a,0x55,0x55,0xab,0xbf,0xaa,0x4a,0x55,0x49,
 0x57,0x55,0xd5,0x5d,0x55,0x5d,0x55,0x55,0x15,0x20,0x4a,0x89,0x20,0x40,0x08,
 0x02,0x49,0x40,0x40,0x82,0x52,0x90,0x20,0x09,0x42,0x75,0x00,0x54,0x12,0x02,
 0x80,0x08,0x50,0x55,0xa0,0x00,0x80,0x05,0x02,0x02,0x48,0x22,0x48,0x59,0xa5,
 0x2a,0x55,0xa5,0x92,0xd6,0x52,0x95,0x4a,0xd5,0xa9,0xae,0x9a,0xba,0x76,0x5b,
 0x5f,0x55,0x59,0xbb,0xdb,0xac,0x5e,0x55,0xa9,0xb5,0xaa,0xaa,0x52,0xab,0xb5,
 0xaa,0xaa,0x2a,0xb5,0xab,0xaa,0xaa,0xbb,0xaa,0xba,0xaa,0xaa,0x2a,0x8a,0x10,
 0x25,0x09,0xa1,0x23,0x12,0x00,0x45,0x12,0x09,0x00,0x01,0x02,0x28,0x10,0x0a,
 0x29,0x29,0x41,0x68,0x0a,0x85,0x02,0x0e,0x02,0x49,0x6a,0x91,0x50,0x20,0x21,
 0x00,0x09,0x54,0x95,0x54,0x4a,0x4a,0x55,0x4b,0x55,0xaa,0x2a,0x29,0xa5,0x26,
 0x2d,0x9d,0xbb,0x3d,0x95,0x4a,0xdd,0x9d,0xfd,0x5f,0x4d,0x95,0xaa,0xab,0x54,
 0xa9,0xaa,0xca,0xab,0xaa,0xab,0xd4,0xba,0xab,0xaa,0x54,0x5e,0x55,0x5d,0x55,
 0x55,0x0a,0x20,0xa4,0x50,0x41,0x08,0x08,0x89,0x24,0x48,0x00,0x84,0x48,0x48,
 0x48,0x92,0x84,0x50,0x00,0x10,0x08,0x01,0x40,0x20,0x48,0xb1,0x50,0x82,0x90,
 0x00,0x00,0x09,0x88,0x48,0x80,0xac,0x52,0x92,0x52,0x29,0xa9,0xa7,0x7c,0x77,
 0xdb,0xff,0x7e,0x7b,0x4f,0x5d,0xf7,0xdf,0xab,0x54,0xae,0xdb,0xdb,0xad,0x7e,
 0x77,0xd5,0xd7,0x5b,0x5f,0xaf,0x57,0xd7,0xdb,0xf7,0xbb,0x7d,0xbf,0xde,0xed,
 0xfa,0xba,0xad,0xaa,0x4a,0x29,0x8a,0x92,0x8a,0x04,0x02,0x20,0x21,0x80,0x40,
 0x92,0x24,0x02,0x02,0x01,0xa8,0x10,0x04,0x20,0x4a,0x00,0x88,0x08,0x09,0x01,
 0xba,0x2a,0x00,0x62,0x25,0x25,0xa0,0x80,0x02,0x25,0xb4,0xa4,0xaa,0x94,0xaa,
 0x92,0xa9,0x66,0x7f,0x9b,0x6d,0x77,0xbf,0xae,0xae,0x3b,0xa7,0xaf,0xaa,0xde,
 0xbd,0xcf,0x93,0x76,0xb7,0x2a,0xaf,0xbb,0xbb,0xdd,0xa9,0xaf,0xbd,0xdd,0xfa,
 0xdb,0x5d,0xbb,0xef,0xed,0xce,0x5e,0x55,0x55,0x15,0x40,0x48,0x52,0x90,0x20,
 0x09,0x11,0x24,0x44,0x00,0x05,0x40,0x40,0x20,0x11,0x86,0x40,0x88,0x14,0x49,
 0x42,0x22,0x10,0xa4,0x44,0x15,0x81,0x50,0x01,0x40,0x09,0x64,0x4c,0x08,0xd4,
 0x2a,0x95,0xaa,0x4a,0xca,0x2b,0xf7,0x66,0xd7,0x67,0xbb,0x77,0x57,0x2d,0xdb,
 0x5f,0x9e,0x52,0x9d,0x9d,0xd7,0x57,0xef,0x6e,0xa5,0xbe,0x5d,0xfb,0xbb,0x55,
 0xbd,0xdb,0xfb,0xba,0xbd,0xbb,0xdf,0xd9,0xde,0xfd,0xad,0xaa,0xaa,0x2a,0x0a,
 0x25,0x89,0x02,0x44,0x40,0x84,0x00,0x11,0x09,0x90,0x24,0x09,0x12,0x48,0x00,
 0x04,0x00,0x0a,0x20,0x10,0x80,0x44,0x10,0x52,0x21,0x10,0x4a,0x48,0x04,0x40,
 0x20,0x00,0xa0,0x54,0x55,0x52,0x49,0x52,0xd5,0x55,0x77,0x7b,0xdf,0x79,0xbb,
 0x9b,0xab,0xae,0xfe,0x4c,0xed,0xbf,0xa6,0xef,0x7e,0xae,0x76,0x56,0xaa,0xda,
 0x5d,0xdb,0xde,0x2b,0xdd,0xdd,0xec,0xdd,0xcd,0xcd,0xbd,0xe7,0xee,0xee,0xae,
 0xaa,0xaa,0x0a,0x50,0x90,0xa4,0x20,0x11,0x12,0x21,0x48,0x40,0x40,0x04,0x00,
 0x80,0x80,0x04,0x02,0x40,0x48,0x84,0x0a,0x02,0x11,0x10,0x84,0x24,0x8a,0x84,
 0x50,0x02,0x21,0x12,0x94,0x54,0x0a,0x54,0x49,0x49,0xaa,0x2a,0xa9,0x4b,0x77,
 0x77,0xcb,0xb2,0x5e,0x7b,0x97,0x96,0xce,0x2e,0x5d,0x95,0xae,0xd6,0xed,0x57,
 0xb7,0x5e,0x55,0xdd,0xae,0xfb,0xad,0xd5,0xda,0xdd,0x6f,0xdd,0xdd,0xbd,0xad,
 0xeb,0xe6,0xee,0x56,0x55,0x55,0x29,0x82,0x4a,0x12,0x09,0x20,0x80,0x10,0x01,
 0x46,0x12,0x25,0x49,0x12,0x24,0x04,0x88,0x04,0x02,0x23,0x81,0x48,0x44,0x40,
 0x21,0x90,0x20,0x10,0x55,0x11,0x48,0x40,0x11,0x10,0x88,0x54,0x95,0xaa,0x52,
 0x4a,0xa5,0xb3,0x9b,0x9b,0xee,0xba,0xcb,0x9d,0xab,0xae,0xee,0xdd,0xa6,0xaa,
 0x56,0xd7,0x6e,0x96,0xbb,0x5e,0xd5,0xfa,0xdd,0xdd,0xee,0x6a,0xdd,0xee,0xfe,
 0xee,0xfe,0xae,0xdf,0x75,0xbf,0x76,0xaf,0xaa,0x4a,0x15,0x28,0x20,0x49,0x01,
 0x09,0x92,0x44,0x48,0x40,0x00,0x08,0x00,0x00,0x01,0xa4,0x22,0x50,0x90,0x02,
 0x20,0x00,0x00,0x12,0x08,0x0a,0x88,0x44,0x28,0x44,0x02,0x09,0x50,0x12,0x21,
 0x68,0xa5,0x54,0x2a,0xa9,0x94,0xae,0x5e,0xaf,0xd6,0x75,0xbf,0x79,0xab,0xaf,
 0xab,0xe7,0x9b,0xa4,0xdf,0xd5,0xef,0x57,0x4f,0x4d,0xd5,0xcf,0xbe,0xcf,0xd7,
 0xd5,0xef,0xdd,0xed,0xda,0xcd,0xdd,0xbd,0xea,0x5e,0xef,0xae,0xaa,0xaa,0x2a,
 0x82,0x4a,0x92,0x24,0xa0,0x80,0x00,0x01,0x49,0x92,0x48,0x52,0x12,0xa4,0x04,
 0x00,0x01,0x41,0x89,0x08,0x49,0x92,0x40,0xa0,0xa0,0x02,0x22,0x15,0x00,0x10,
 0x20,0x12,0x90,0x80,0x56,0x29,0x49,0xa5,0x52,0x55,0x55,0xa1,0x55,0x2b,0x92,
 0xbd,0x82,0x4a,0x52,0xa4,0xaa,0xaa,0xaa,0x22,0x29,0x91,0xaa,0xaa,0x56,0x55,
 0x55,0xc9,0x55,0xd4,0x52,0xa9,0x2a,0x55,0xa5,0x1a,0x55,0xa5,0xaa,0x52,0x55,
 0x55,0x55,0x55,0x12,0x48,0x28,0x29,0x81,0x24,0x90,0x30,0x24,0x44,0x00,0x09,
 0x40,0x80,0x20,0x08,0x4a,0x10,0xa4,0x20,0x42,0x40,0x00,0x24,0x0a,0x08,0xa0,
 0x08,0x14,0x93,0x44,0x89,0x20,0x0a,0x18,0x58,0x55,0xa5,0x92,0x4a,0x92,0x94,
 0xac,0xd5,0x4a,0xa9,0x73,0x5a,0xa9,0x4a,0x55,0x2a,0xa5,0xaa,0xac,0xaa,0xaa,
 0x52,0xa9,0x55,0xa9,0x54,0xd5,0x52,0x7b,0x55,0x55,0x55,0x55,0x55,0x65,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x22,0x91,0xa2,0x08,0x00,0x85,0x04,
 0x80,0x40,0x12,0x88,0x04,0x09,0x02,0x52,0x00,0x41,0x50,0x02,0x00,0x09,0x49,
 0x40,0x20,0xa1,0x04,0xa0,0x12,0x00,0x00,0x00,0x44,0x24,0x41,0x54,0x49,0x95,
 0x54,0x55,0xa5,0x52,0xd5,0xeb,0x52,0x55,0x9f,0xaa,0xaa,0xaa,0xaa,0x52,0x2a,
 0x95,0x52,0x55,0x55,0x95,0xaa,0xab,0xaa,0xaa,0xea,0xad,0x7c,0x95,0xaa,0xaa,
 0xaa,0xaa,0x5a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x2a,0x08,0x4a,0x14,
 0x21,0x49,0x40,0x40,0x12,0x48,0x40,0x22,0x20,0x80,0x90,0xa0,0x2a,0x14,0xa9,
 0x20,0x29,0x40,0x00,0x92,0x4a,0x08,0x51,0x4a,0x95,0x48,0x92,0x24,0x81,0x03,
 0x08,0x54,0x55,0x52,0x2a,0xa9,0x54,0x2a,0x49,0x95,0xaa,0x4a,0x55,0x25,0x95,
 0x54,0x95,0xaa,0xa9,0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0x52,
 0x05,0x55,0x55,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x15,0x22,0xa8,0xa2,0x24,0x29,0x49,0x12,0x92,0x54,0x25,0x49,0x4a,0x9a,0x28,
 0x49,0x82,0x00,0xaa,0x25,0x49,0x12,0x93,0x64,0x00,0x21,0x04,0x91,0x52,0x49,
 0x52,0x92,0x94,0xa4,0x49,0xb5,0x92,0x54,0xa5,0x92,0xaa,0x52,0x95,0x52,0x4a,
 0x52,0x92,0x54,0xaa,0x4a,0x52,0x95,0x4a,0xa9,0x2a,0x55,0x92,0x54,0x55,0xa5,
 0xaa,0x52,0x55,0x55,0x75,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x2a,0x88,0x12,0x14,0x01,0x00,0x42,0x84,0x00,0xa1,0x00,
 0x90,0x00,0x00,0x02,0x00,0x28,0x52,0x45,0x08,0x00,0x41,0x20,0x00,0xaa,0x14,
 0xa1,0x54,0x20,0x00,0x00,0x00,0x20,0x08,0x00,0x54,0x49,0x25,0x55,0x4a,0x25,
 0x95,0x52,0x4a,0xa9,0xaa,0xaa,0x52,0xa5,0xaa,0xaa,0xa4,0x54,0x55,0xa9,0xaa,
 0xaa,0x4a,0xaa,0xaa,0x54,0x55,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,
 0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x22,0xa4,0x52,0x24,0x29,0x48,
 0x10,0x12,0xa4,0x14,0x11,0x52,0x21,0x20,0x82,0x50,0xa4,0xc2,0x40,0x21,0x44,
 0x84,0x24,0x91,0xa2,0x94,0x0a,0x21,0x25,0x49,0x49,0x22,0x20,0x2a,0xd4,0xaa,
 0x4a,0xa9,0x2a,0xa9,0x54,0xaa,0xaa,0x2a,0x95,0x54,0x95,0x2a,0xa9,0x54,0x55,
 0x95,0x4a,0x55,0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0x52,0x55,0x55,0xa9,0xaa,
 0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x25,0x08,0x91,
 0x24,0x09,0x00,0xa1,0x44,0x80,0xa0,0x80,0x10,0x00,0x88,0x88,0x20,0x82,0xaa,
 0x90,0x10,0x08,0x00,0x10,0x00,0x20,0x55,0xaa,0x22,0x24,0x00,0x00,0x00,0x80,
 0x84,0x00,0x59,0x25,0xa9,0x94,0xa4,0x94,0x4a,0x95,0x52,0x4a,0xa5,0x4a,0xaa,
 0x52,0x95,0x4a,0xaa,0x52,0xa9,0xaa,0xa4,0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,
 0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0xa2,0x24,0x49,0xa0,0x44,0x24,0x10,0x09,0x62,0x22,0x92,0x24,0x01,
 0x02,0x0a,0x88,0x04,0x42,0x82,0x44,0x49,0x42,0x52,0x02,0xa4,0xa5,0x00,0x20,
 0x49,0x25,0x49,0x0a,0x10,0x24,0x54,0xa9,0x52,0xa5,0xaa,0x2a,0x29,0xa9,0x94,
 0x52,0xaa,0x52,0x49,0x55,0xa5,0xaa,0x92,0xaa,0x2a,0xa5,0x2a,0xa5,0xaa,0x2a,
 0x49,0xa9,0x52,0x55,0xaa,0xaa,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x08,0x90,0x24,0x05,0x20,0x20,0x12,0xa0,0xe4,
 0x08,0x11,0x41,0x48,0xa8,0x20,0x31,0x50,0xcc,0x24,0x11,0x90,0x80,0x20,0x90,
 0x0a,0x80,0x4c,0x29,0x01,0x40,0x10,0xa0,0x04,0x89,0xac,0x54,0x4a,0x52,0x52,
 0x4a,0xa5,0x94,0xaa,0xaa,0x52,0x2a,0x55,0x4a,0xaa,0x52,0x55,0x29,0x55,0x95,
 0xaa,0x54,0x25,0xa9,0xaa,0x4a,0x95,0xaa,0x55,0xa9,0xaa,0x52,0x55,0x25,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0xa2,0x4a,0x92,0x90,0x8a,
 0x22,0x48,0x02,0x48,0x22,0x24,0x24,0x02,0x01,0x04,0x84,0x04,0xe1,0x00,0x40,
 0x42,0x0a,0x8a,0x04,0x10,0x92,0x00,0x44,0x2a,0x89,0x44,0x11,0x10,0x10,0xd4,
 0x92,0x54,0x95,0x4a,0xa9,0xfe,0x52,0xa5,0x54,0x95,0x5f,0x55,0x55,0x55,0x5a,
 0xea,0x55,0xa9,0xd7,0xd7,0xd7,0xab,0xea,0xd7,0xeb,0xfb,0xd2,0x55,0x55,0x7d,
 0x55,0x57,0x55,0xa9,0xae,0xab,0xfa,0xaa,0xea,0xaa,0xab,0xaa,0x4a,0x2a,0x08,
 0x24,0x49,0x05,0x20,0xa8,0x82,0x48,0x42,0x00,0xa1,0x80,0x50,0x50,0x21,0x01,
 0x20,0xc0,0x92,0x0a,0x10,0x90,0x20,0x21,0x85,0x80,0x24,0xc1,0x00,0x20,0x00,
 0x84,0x84,0x04,0xa9,0xaa,0x92,0x54,0x29,0x55,0xde,0xaa,0x54,0x25,0xe9,0xba,
 0x92,0x52,0x49,0x5d,0xd5,0x4a,0x4b,0xee,0x6e,0x77,0x57,0x55,0x77,0xeb,0xd6,
 0xab,0xab,0xaa,0xce,0xaa,0xae,0xaa,0x56,0xaf,0xa9,0xae,0x55,0xd5,0xda,0xab,
 0xaa,0xaa,0x12,0xa2,0x48,0x12,0x90,0x20,0x11,0x10,0x00,0x25,0x49,0x29,0x4a,
 0x04,0x21,0x08,0x54,0x81,0xc4,0x40,0xa1,0x44,0x01,0x22,0x04,0x28,0xca,0x04,
 0x48,0x49,0x42,0x49,0x30,0x10,0x2a,0xac,0x24,0x55,0xa5,0xaa,0x92,0xee,0x92,
 0xaa,0x55,0x75,0x49,0x2a,0x95,0xaa,0x52,0xe9,0xaa,0x55,0x77,0xe7,0xbe,0x53,
 0x55,0x77,0x37,0xab,0xd5,0x52,0x95,0xfe,0x55,0x52,0x55,0xa9,0xae,0x56,0xaf,
 0xaa,0xaa,0xda,0x55,0x55,0x55,0x15,0x08,0x24,0x49,0x01,0x08,0x1c,0x04,0x12,
 0xf0,0x00,0xe0,0x00,0x00,0x04,0x00,0x00,0x08,0xc0,0x00,0x00,0x00,0x20,0x20,
 0x80,0x00,0xc0,0x83,0x40,0x00,0x08,0x00,0x00,0x01,0x00,0xd4,0xaa,0x94,0x52,
 0x4a,0xa9,0xd6,0xfd,0xf6,0xfb,0x6a,0xb5,0xef,0x77,0xb7,0xaf,0x6f,0xef,0x53,
 0xe7,0xf6,0x77,0x57,0xaa,0x7e,0xbb,0xd7,0xd5,0xef,0xae,0xce,0xed,0x6b,0xf7,
 0xab,0xde,0xa9,0x5e,0xfd,0x7e,0xdf,0xae,0xaa,0xaa,0x2a,0xa2,0x48,0x55,0x00,
 0x00,0x7c,0x00,0x00,0x08,0x01,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
 0x00,0x00,0x00,0x20,0x00,0x00,0x20,0x04,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
 0x54,0x49,0x29,0x95,0x94,0x4a,0x7f,0x36,0xff,0x2c,0x79,0xc9,0xce,0x6e,0xfb,
 0xdc,0xee,0xd6,0xac,0x6b,0xd7,0xb9,0xab,0x52,0xbb,0x7f,0xab,0xe5,0xee,0x56,
 0x7f,0x7e,0xb7,0xb5,0x57,0x6d,0x4a,0xbd,0xee,0xed,0xdc,0x5d,0x55,0x95,0x0a,
 0x08,0x55,0x22,0x01,0x20,0x7c,0x10,0x00,0x04,0x00,0xf1,0x40,0x00,0x20,0x00,
 0x10,0x00,0xc4,0x00,0x01,0xc0,0xff,0x20,0x00,0x08,0x10,0x0c,0x40,0xf9,0x41,
 0x00,0x20,0x00,0x08,0x58,0xa5,0x4a,0xa9,0x52,0xa9,0x2e,0xf7,0xd6,0x5e,0xb5,
 0xea,0xed,0xee,0x76,0x6f,0xef,0xee,0x4a,0x77,0xef,0xb7,0x4b,0x55,0x5b,0xbb,
 0x6b,0xd5,0xdd,0x55,0x77,0x5d,0xfb,0x75,0xab,0xae,0xaa,0x7a,0xdd,0x6f,0xef,
 0x5f,0x55,0x55,0x29,0x22,0x20,0x49,0x00,0x00,0x3c,0x00,0x00,0x02,0x02,0xe0,
 0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x47,0x10,0x00,0x00,0x08,
 0x10,0x80,0x68,0x01,0x00,0x00,0x00,0x00,0x54,0x95,0x54,0x4a,0x95,0x4a,0xa7,
 0x3b,0xf7,0xba,0xb2,0x74,0xde,0x6e,0x39,0xed,0x76,0xe7,0xd2,0xc9,0xb3,0xf3,
 0xf5,0xaf,0xbc,0xdb,0xab,0x6a,0xad,0xab,0xe7,0xce,0xdb,0xbb,0xab,0xbe,0xaa,
 0x74,0x6d,0x76,0xed,0xa6,0xaa,0xaa,0x2a,0x08,0x95,0x24,0x01,0x00,0x3c,0x00,
 0x00,0x02,0x02,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xfd,
 0x10,0x00,0x00,0x08,0x10,0x80,0xb8,0x01,0x00,0x00,0x00,0x00,0xa8,0x52,0x4a,
 0x55,0xaa,0x54,0x57,0x5b,0xe7,0x7a,0xba,0xea,0xee,0xee,0xbb,0xd6,0x77,0xeb,
 0xaa,0xd7,0x7b,0xd7,0xaa,0x52,0xdb,0xbd,0xb5,0xea,0xd6,0x2a,0xf7,0xae,0xdd,
 0xba,0x55,0x5d,0x55,0xeb,0xee,0xbf,0xee,0x5e,0x55,0x55,0x15,0x22,0x48,0x4a,
 0x25,0x29,0x59,0x12,0x92,0x26,0x27,0xe9,0x4a,0x92,0x28,0x49,0x12,0x92,0xe4,
 0x25,0x49,0x42,0x93,0xb4,0x24,0x49,0x9a,0x34,0xa1,0x49,0x52,0x92,0xa4,0x24,
 0x49,0x6c,0x55,0xa9,0xa4,0x24,0xa9,0x93,0xbf,0x6b,0xb5,0x7a,0x75,0x67,0xd3,
 0x5a,0xef,0xb8,0x77,0xd5,0xe9,0xb4,0xeb,0xaa,0xfa,0xbf,0xdd,0xfd,0x6a,0xaf,
 0xab,0x7b,0xd7,0xfd,0xdb,0xab,0xae,0x56,0x6b,0x77,0x7b,0x6f,0x57,0x55,0x25,
 0x15,0x48,0x25,0x51,0x00,0x00,0x18,0x00,0x00,0x02,0x02,0xc0,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x08,0x10,0x80,0x00,
 0x00,0x00,0x00,0x00,0x00,0xa8,0x24,0x25,0x95,0x52,0x95,0x4f,0x7b,0xeb,0x7e,
 0xe5,0xcb,0xf3,0xd7,0x5d,0xee,0x6b,0x6b,0xd5,0x77,0xf5,0x39,0x29,0xf5,0xf3,
 0xf2,0xfe,0xf5,0xd3,0xab,0xbf,0xaa,0xfb,0xba,0x57,0x55,0x57,0xbf,0x6e,0xf7,
 0xee,0x5e,0x55,0x55,0x25,0x02,0x48,0x8a,0x00,0x00,0x18,0x00,0x00,0x04,0x00,
 0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x10,0x00,0x00,
 0x10,0x08,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0xaa,0xaa,0xaa,0x52,
 0x28,0x85,0x94,0x84,0x94,0x54,0x6c,0x54,0x52,0xb9,0x97,0xaa,0x2a,0x88,0x4a,
 0xa6,0xaa,0xaa,0x54,0x95,0x4a,0x4a,0xaa,0x54,0x42,0x95,0x92,0x4a,0xa9,0xaa,
 0xaa,0xaa,0x52,0x95,0x12,0x51,0x55,0x55,0x15,0x50,0xa5,0x24,0x01,0x20,0x08,
 0x10,0x00,0x0c,0x01,0x81,0x40,0x00,0x20,0x00,0x10,0x00,0xc4,0x00,0x01,0x40,
 0x00,0x30,0x00,0x08,0x20,0x04,0x80,0x01,0x40,0x00,0x20,0x00,0x08,0xb4,0x4a,
 0x49,0x49,0x29,0xa9,0xa6,0xaa,0x52,0xb5,0x52,0x55,0x73,0xeb,0x2a,0xb5,0x56,
 0x55,0xa5,0x6b,0x55,0x55,0x55,0x95,0x2a,0x55,0x55,0x55,0x75,0xab,0x5a,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xed,0x56,0x55,0x55,0x29,0x02,0x88,
 0x52,0x00,0x00,0x08,0x00,0x00,0xf0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0xc0,0x03,0x00,0x01,0x00,0x00,0x00,
 0x00,0x00,0x54,0xa9,0x2a,0x95,0x52,0xa5,0x54,0x54,0x55,0x4a,0xa5,0x4a,0x7c,
 0x1d,0x55,0xf5,0x57,0x92,0x2a,0x4a,0xa9,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xba,0x54,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,
 0xaa,0x0a,0xa8,0x52,0x08,0x01,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x07,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xa8,0x4a,0x92,0x52,0x95,0x94,0x92,0x4a,0x2a,
 0xa5,0x54,0x52,0x4b,0x69,0xa5,0x4a,0x49,0x55,0xa9,0x35,0x55,0x52,0xa9,0xaa,
 0xaa,0xaa,0xa4,0xa4,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0xad,0xaa,0xaa,0x4a,0x2a,0x02,0xa4,0x52,0x00,0x20,0x10,0x00,0x00,0x00,
 0x00,0x40,0x10,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x40,0x20,0x00,
 0x00,0x00,0x00,0x80,0x40,0x00,0x00,0x00,0x00,0x00,0x6c,0xa9,0x54,0x2a,0xa9,
 0xaa,0xaa,0x52,0xc9,0x54,0x95,0xaa,0x94,0x4a,0x4a,0x52,0xaa,0xaa,0x2a,0x4a,
 0xa5,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x15,0x48,0x11,0x49,0x01,0x10,
 0x20,0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x00,
 0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x54,
 0x95,0x4a,0x95,0x4a,0x92,0x54,0xaa,0x2a,0x55,0x52,0x25,0x65,0xaa,0xaa,0xaa,
 0x2a,0x25,0xa5,0x55,0x55,0x35,0x55,0xa5,0x92,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0x2a,0x22,
 0xa4,0x94,0x00,0x30,0x20,0x10,0x00,0x04,0x00,0x21,0x60,0x00,0x20,0x00,0x10,
 0x00,0xc4,0x00,0x01,0x40,0x20,0x20,0x00,0x08,0x00,0x04,0x40,0x81,0x40,0x00,
 0x20,0x00,0x08,0xa8,0x52,0x52,0x52,0xaa,0xaa,0x92,0x92,0x54,0x49,0x55,0xaa,
 0x94,0x52,0xa9,0xaa,0x52,0xa9,0xaa,0x54,0x55,0x49,0x49,0x2a,0x55,0x55,0x55,
 0x55,0xaa,0x52,0x49,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0x09,0x08,0x55,0x22,0x01,0x10,0x20,0x00,0x00,0x00,0x00,0x20,0x20,
 0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,
 0x40,0x80,0x00,0x20,0x00,0x00,0x00,0xd8,0x94,0xaa,0x4a,0x25,0x55,0x4a,0x55,
 0xa5,0xaa,0x4a,0x95,0xaa,0xaa,0x2a,0x25,0x55,0x55,0x55,0xa5,0x92,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x4a,0x4a,0xa5,0x2a,0x55,0xa9,0xaa,0x54,0x55,0x25,0x55,0x55,
 0x55,0x55,0xad,0xaa,0xaa,0xaa,0x2a,0x22,0x80,0x94,0x00,0x10,0x20,0x00,0x00,
 0x00,0x00,0x20,0x20,0x10,0x00,0x02,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,0x00,
 0x00,0x00,0x00,0x00,0x40,0x80,0x00,0x00,0x00,0x20,0x00,0x54,0xa5,0x24,0x55,
 0xaa,0xa4,0xaa,0xa4,0x4a,0x92,0x54,0x52,0x49,0x95,0xaa,0x54,0x95,0x2a,0x29,
 0x95,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x95,0x2a,0x88,0x5a,0x4a,0x00,
 0x20,0x10,0x10,0x00,0x04,0x00,0x41,0x50,0x00,0x20,0x00,0x10,0x00,0xc4,0x00,
 0x01,0x40,0x40,0x20,0x40,0x08,0x00,0x04,0x80,0x41,0x40,0x00,0x20,0x00,0x08,
 0xac,0x52,0x95,0xa4,0x92,0x92,0x24,0x95,0x54,0x55,0xa5,0xaa,0x2a,0x49,0x49,
 0x55,0xa9,0xa4,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x95,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x15,
 0x22,0x20,0x91,0x00,0x40,0x08,0x00,0x00,0x00,0x00,0x80,0x08,0x00,0x00,0x00,
 0x00,0x01,0xc0,0x00,0x20,0x00,0x80,0x10,0x00,0x00,0x00,0x00,0x00,0x21,0x00,
 0x00,0x00,0x00,0x00,0xa8,0x4a,0xaa,0x4a,0x55,0x55,0x55,0xa9,0xaa,0xaa,0x2a,
 0x25,0x55,0x55,0xaa,0x5f,0xaa,0xaa,0x4a,0xf5,0x57,0x92,0x24,0xa9,0x56,0x79,
 0x55,0xd5,0xf5,0xf5,0x75,0xd5,0x55,0x55,0xbf,0xaa,0x52,0xaf,0xde,0x5d,0x55,
 0x55,0xb5,0xaa,0x14,0x08,0x95,0x4a,0x01,0x80,0x07,0x00,0x00,0x00,0x00,0x00,
 0x07,0x00,0x04,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x1e,0x00,0x00,0x00,0x00,0x00,0x68,0x29,0x49,0x29,0x29,0x29,0xa9,
 0x2a,0x25,0x49,0x52,0xa9,0xa4,0xaa,0xaa,0xbb,0x4a,0x55,0xa9,0xb4,0x56,0x55,
 0x55,0x95,0x56,0xb5,0xaa,0xaa,0xbb,0xbb,0xf5,0xea,0x92,0xaa,0xee,0xaa,0xaa,
 0xae,0xde,0x5a,0x55,0x55,0x95,0x4a,0x25,0x22,0x48,0x24,0x24,0x29,0x49,0x12,
 0x92,0x24,0x25,0x49,0x4a,0x92,0x28,0x49,0x12,0x92,0xe4,0x25,0x49,0x42,0x92,
 0xa4,0x24,0x49,0x92,0x24,0x21,0x49,0x52,0x92,0xa4,0x24,0x49,0xac,0xaa,0x52,
 0xaa,0x52,0xa5,0x12,0xa5,0x54,0x55,0x95,0xaa,0x4a,0x52,0xa5,0xbb,0x52,0x6a,
 0x55,0x5d,0x95,0xaa,0xaa,0xaa,0xaa,0xba,0x6a,0xe9,0xdd,0xd9,0x75,0xd5,0xaa,
 0x54,0x77,0x55,0x55,0xab,0x6e,0x55,0x55,0x55,0x55,0x55,0x15,0x40,0x25,0x49,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x54,0x25,0x55,0x95,0x94,0x54,0xaa,0x92,0xaa,0xa4,0x52,0x25,0x55,0x95,
 0xaa,0x75,0xdf,0x7f,0xaf,0xba,0xea,0xf5,0xdd,0xfd,0xeb,0xdf,0x7b,0xd5,0xb9,
 0xbd,0x75,0xea,0x77,0xab,0xeb,0xbe,0x77,0xab,0xb6,0xde,0xaf,0xbf,0xaa,0xaa,
 0x2a,0x0a,0x48,0x92,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x54,0x49,0x4a,0x52,0x55,0xa5,0x4a,0xaa,0x24,0x95,
 0x54,0xaa,0x54,0x55,0xaa,0x9f,0xdd,0xf5,0x2d,0x4d,0xb5,0xbb,0xdb,0x6e,0xb7,
 0xb9,0x75,0xe5,0xda,0xdd,0xbb,0xea,0xee,0x57,0x3f,0xbb,0xbb,0x57,0x5f,0xed,
 0xde,0xad,0xaa,0x2a,0x15,0x40,0x25,0x25,0xd5,0x6f,0x55,0xfb,0xff,0xb7,0xed,
 0xad,0x6a,0xef,0xed,0xfe,0xff,0xfe,0x57,0xda,0x7f,0xff,0xad,0xaa,0x7d,0xff,
 0x6f,0xdb,0xb7,0xaa,0xfd,0xff,0xff,0xff,0xff,0x6b,0x55,0xa5,0x2a,0xa5,0x94,
 0x52,0xa9,0xaa,0xaa,0x4a,0x55,0x25,0xa9,0xd2,0xd5,0xef,0xba,0xab,0x5e,0x7a,
 0xb7,0xbb,0x5c,0xdb,0xdd,0x5b,0xd5,0xdd,0xdb,0x75,0x75,0x6f,0xaa,0xab,0x5f,
 0x77,0xab,0x7e,0xdd,0xdd,0xae,0xaa,0xaa,0x12,0x2a,0x48,0x94,0x48,0xaa,0x6a,
 0x25,0x11,0xaa,0x9a,0x6a,0x55,0x99,0xaa,0x22,0x49,0x89,0x54,0x35,0xc4,0x88,
 0xaa,0xb6,0xa2,0x24,0xaa,0x2a,0xaa,0xaa,0x22,0x22,0x49,0x22,0x12,0x55,0xa9,
 0x94,0xa4,0x94,0x2a,0x55,0x25,0x55,0x29,0x55,0x92,0xaa,0x4a,0xd5,0xe5,0xdc,
 0xba,0x57,0xad,0xda,0xbb,0xfb,0xae,0xbb,0xbb,0xbd,0x6a,0xfa,0xf4,0x9a,0x6a,
 0xf7,0xd5,0xd7,0x5d,0x9b,0xab,0xb7,0xd6,0xee,0x5d,0x55,0x55,0x15,0x00,0xa5,
 0x22,0xa5,0xaa,0xb6,0xda,0xd6,0xd5,0xaa,0xaa,0xaa,0xaa,0xaa,0xda,0x56,0x6b,
 0xab,0xcd,0x35,0xb7,0x6a,0x55,0x5d,0xab,0x55,0xd5,0x55,0x6b,0xdd,0xda,0x56,
 0xad,0xd5,0x5a,0x25,0xa5,0xaa,0x52,0xa5,0x92,0x54,0x49,0x4a,0xa9,0xaa,0x94,
 0xaa,0xd4,0xd5,0xef,0xba,0xae,0xae,0xba,0xbb,0xb5,0xae,0xf5,0xdd,0xb9,0xea,
 0x65,0xf5,0x7a,0x75,0x67,0xab,0xab,0xbb,0xfb,0x55,0xf7,0xee,0x96,0x57,0x55,
 0x95,0x2a,0x4a,0x88,0x94,0x54,0xd5,0xaa,0x55,0xad,0xaa,0x56,0x5b,0x5b,0x6b,
 0x5b,0xab,0x6a,0x55,0x6d,0xb5,0x6a,0x55,0x55,0xd5,0xaa,0x5a,0xb5,0xad,0x5a,
 0x55,0x55,0x55,0xb5,0x5a,0xad,0xaa,0x4a,0x2a,0x95,0x2a,0xa9,0x54,0xa5,0xaa,
 0xaa,0x92,0x54,0xa9,0x54,0xe5,0xca,0x76,0xdd,0x26,0x5d,0xdb,0xda,0x75,0xd7,
 0x3b,0xee,0x5a,0x75,0x7a,0xb5,0x9a,0xba,0xe9,0xd5,0xd5,0xad,0x9d,0xab,0x7b,
 0x77,0xef,0xaa,0xaa,0xaa,0x14,0x20,0x24,0x49,0xa2,0xb6,0xaa,0xaa,0xaa,0x5a,
 0xd5,0xaa,0xaa,0x55,0xd5,0xaa,0xaa,0xb6,0xaa,0xaa,0x56,0x55,0x5b,0x5b,0xd5,
 0xaa,0x56,0xb5,0xaa,0x5a,0xab,0x56,0x55,0xab,0xaa,0xaa,0x52,0xa5,0xa4,0x94,
 0x54,0x2a,0x95,0x94,0x52,0x55,0x25,0x55,0x25,0xf5,0xe9,0xef,0xba,0xaf,0xfa,
 0x7a,0xfd,0xba,0x96,0xfd,0xdd,0x5d,0xf9,0x5d,0xbd,0x7e,0xf5,0xd6,0xd2,0xab,
 0xdf,0xfb,0xab,0xef,0xee,0xde,0x57,0x55,0x55,0x15,0x8a,0x52,0x92,0x94,0x88,
 0x24,0x25,0x51,0xa2,0x24,0x49,0x52,0x4a,0x12,0x95,0x94,0x48,0x49,0x25,0x49,
 0xaa,0xa4,0xa4,0x2a,0xa5,0x28,0x49,0x55,0xa5,0x54,0xa9,0x4a,0x54,0x55,0x55,
 0x95,0x54,0x29,0xa9,0x4a,0xa5,0x54,0xa9,0x94,0xaa,0xaa,0x92,0xaa,0x4a,0x95,
 0x14,0x49,0x51,0xa5,0xaa,0x1a,0x55,0xa9,0xda,0xa5,0xaa,0x4a,0x52,0x45,0x95,
 0xaa,0x6a,0x2d,0x95,0x54,0x95,0xaa,0x54,0x95,0x62,0x5f,0x55,0x55,0x15,0x20,
 0x94,0x24,0x45,0x52,0x92,0x90,0x14,0x29,0x92,0x24,0x89,0x24,0x49,0x42,0x4a,
 0x92,0x24,0x92,0x2a,0x11,0x29,0x49,0x44,0x29,0x95,0x24,0x49,0x52,0x92,0x14,
 0x51,0x25,0x49,0x92,0xa8,0x92,0xaa,0x4a,0xa5,0x52,0x25,0x95,0x4a,0x49,0x52,
 0xaa,0x54,0x29,0x55,0xaa,0xaa,0xac,0x54,0x4a,0xdd,0x5a,0xaa,0xde,0x55,0x55,
 0x55,0x55,0xb5,0xaa,0xaa,0x5a,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xfa,0xad,
 0xaa,0x2a,0x25,0x82,0x20,0x49,0x28,0x45,0x49,0x55,0x49,0x45,0x25,0x49,0x2a,
 0x49,0x55,0x99,0x50,0x25,0x55,0x29,0xa4,0xaa,0x92,0x92,0x2a,0x52,0xa2,0x4a,
 0x92,0xa4,0x2a,0xa9,0x4a,0x49,0x95,0xaa,0x52,0x2a,0xa5,0x52,0x2a,0x95,0xaa,
 0xaa,0x2a,0x55,0x95,0x4a,0xa5,0xaa,0x52,0x55,0x55,0xa5,0xaa,0xaa,0x5e,0x57,
 0x55,0xfd,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0xbd,0x5a,0x55,0x55,0x55,0x55,
 0x55,0x55,0xe5,0x57,0x55,0x55,0x15,0x54,0x94,0x24,0x95,0x28,0x52,0x24,0xa4,
 0x28,0x91,0xa4,0x92,0xa4,0x88,0xa4,0x2a,0x52,0x49,0x4a,0x93,0x24,0x49,0xa9,
 0x92,0x2a,0x55,0x52,0x55,0x95,0x44,0x95,0x54,0xaa,0x52,0x49,0x2a,0xa5,0x52,
 0xaa,0x52,0x49,0x52,0x49,0x52,0xa5,0x54,0xa9,0x2a,0xa5,0x4a,0xa5,0x92,0xaa,
 0xaa,0x52,0xa5,0xaa,0xaa,0x22,0x95,0x54,0x55,0x55,0x55,0x55,0x25,0x45,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xaa,0xaa,0xaa,0x2a,0x00,0x29,0x49,0x21,
 0x45,0x89,0x92,0x49,0x52,0x2a,0x15,0x29,0x15,0x25,0x49,0x92,0x24,0x92,0x94,
 0x24,0x49,0x2a,0x4a,0xa4,0x44,0x49,0xa5,0x24,0x29,0xa9,0x24,0x49,0x95,0xa4,
 0x52,0xa5,0x94,0x94,0x4a,0x25,0x55,0x25,0x55,0x55,0x2a,0xa5,0x2a,0x55,0x55,
 0xaa,0x2a,0x55,0x95,0x94,0x2a,0x55,0x4a,0x95,0xaa,0xaa,0x4a,0x92,0x2a,0x55,
 0xa9,0xaa,0x5a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x25,0x09,
 0x55,0x84,0x54,0x4a,0xa9,0x24,0x49,0x24,0x15,0x45,0x49,0x8a,0xa2,0x52,0x25,
 0x49,0x95,0x4a,0x45,0xa9,0x2a,0x45,0x25,0x55,0xaa,0xa4,0x28,0x95,0x4a,0x55,
 0x52,0x25,0x49,0x95,0x54,0x52,0xa5,0xaa,0x24,0xa9,0xaa,0x94,0xaa,0x4a,0xa9,
 0x2a,0xa5,0xa4,0x52,0x55,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x55,0xa5,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0xaa,0xaa,0xaa,0x2a,0x80,0x28,0x21,0x29,0x02,0xa9,0x94,0x4a,0xa2,0x28,0x52,
 0x51,0x94,0x24,0x4a,0x95,0xa8,0x94,0x28,0x25,0x51,0xaa,0x54,0x49,0x91,0x4a,
 0xa5,0xa4,0x94,0xa4,0x4a,0xaa,0x52,0x2a,0xa5,0x94,0x54,0x49,0x55,0x4a,0x92,
 0xaa,0x24,0xa9,0x4a,0xa9,0x54,0x95,0x94,0x92,0x4a,0x25,0x55,0xa5,0x54,0x49,
 0x29,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x15,0x29,0xa5,0x4a,0x92,0xb4,0x12,0xa2,
 0xa4,0x54,0x4a,0x25,0xaa,0x4a,0x52,0x51,0x22,0x25,0x49,0x55,0x52,0x4a,0x51,
 0x92,0x54,0x2a,0x29,0x52,0x52,0xa5,0x92,0xa4,0x52,0x2a,0x49,0x95,0x4a,0x4a,
 0xaa,0x52,0x55,0x55,0x52,0x55,0x55,0x2a,0x95,0x2a,0x55,0x55,0x55,0xaa,0xaa,
 0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x49,0x55,0x55,0x55,0xaa,0xaa,0xaa,0x2a,0x04,0x48,0x94,
 0x24,0x09,0x49,0x15,0x89,0x42,0x91,0x48,0x11,0x91,0x44,0x8a,0x54,0x4a,0x92,
 0xa4,0xa4,0x94,0x8a,0x2a,0x89,0x52,0x52,0xa5,0x4a,0x4a,0x2a,0x95,0xa4,0x54,
 0x55,0x52,0xa9,0x92,0x92,0x94,0x92,0xa4,0x4a,0x4a,0x4a,0xa9,0xaa,0x52,0xa9,
 0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x2a,0xa9,0xaa,0x54,
 0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x56,0xaa,0xaa,0xaa,0x55,0x55,0x55,
 0x09,0xa1,0x2a,0xa5,0x52,0xd5,0xa4,0xa4,0xaa,0x34,0x55,0x55,0xaa,0xac,0xaa,
 0x6a,0x95,0x52,0x55,0x95,0x2a,0xa5,0x54,0xa5,0xaa,0x4a,0x95,0x2a,0x55,0xa9,
 0xaa,0x52,0x55,0xa5,0x52,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x95,0xaa,0x2a,0x29,0x55,0x55,0x55,0xd5,0x4a,0x55,0x55,
 0x55,0x55,0xa9,0xaa,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x55,0x55,
 0x55,0x55,0x55,0x95,0x2a,0x04,0xd4,0x5a,0xad,0xaa,0x5e,0x5b,0xb5,0xaa,0x56,
 0xd5,0xd6,0x6a,0xad,0xaa,0x6a,0xad,0xad,0x6a,0xd5,0x5a,0xab,0x5a,0xb5,0xba,
 0x6a,0xd5,0xaa,0x56,0x55,0xad,0xaa,0x5a,0xad,0xaa,0x55,0xb5,0x6a,0x55,0x55,
 0x55,0x55,0xd5,0xaa,0x56,0xad,0xaa,0xaa,0x6a,0x55,0xd5,0xd6,0xaa,0xaa,0xaa,
 0xaa,0xba,0xaa,0xaa,0xd5,0xaa,0x56,0xab,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x56,0x55,0xb5,0xb6,0xaa,0xaa,0xaa,0x2a,0xa1,0xb6,0x56,0xab,0x55,0xa5,
 0xd5,0x56,0xdb,0x6a,0x5b,0x55,0xad,0xd6,0x56,0xad,0xb5,0x6a,0x5b,0x6d,0x6d,
 0xb5,0xd5,0x56,0xab,0xb6,0x5a,0x6d,0x6b,0x6b,0x6b,0xdb,0x56,0xab,0x6d,0x6d,
 0x5b,0x5b,0xdb,0xda,0xb6,0xb6,0x6d,0x6d,0xab,0x55,0x5b,0x5b,0x55,0xdb,0xaa,
 0xaa,0xda,0x56,0x55,0x55,0xab,0x6a,0xad,0x5a,0x5b,0xab,0xda,0x56,0x55,0xab,
 0x56,0x6d,0x55,0x5b,0x5b,0x6b,0x6d,0x5b,0xab,0xda,0xd6,0x56,0x15,0x84,0xaa,
 0xb5,0x5a,0xdb,0x5a,0xad,0x6a,0x55,0xad,0xaa,0x6d,0xab,0xb5,0xda,0x5a,0x55,
 0x55,0xd5,0xaa,0x55,0x6b,0xad,0xad,0x6a,0x55,0xab,0xaa,0x5a,0xad,0x5a,0x55,
 0xb5,0x5a,0x55,0xab,0x6a,0x55,0x55,0xab,0xd5,0x6a,0x55,0xab,0x5a,0xdb,0x6a,
 0xb5,0xad,0xaa,0x6d,0x6d,0xab,0x6d,0xdb,0x6e,0xd5,0xd6,0x5a,0xab,0xd6,0xda,
 0xaa,0xda,0xb6,0xb6,0x6d,0xab,0x6d,0xb5,0x6a,0xad,0x55,0xd5,0x6a,0xab,0x5a,
 0xad,0x14,0xa8,0xda,0xaa,0x6d,0xad,0xd6,0x6a,0x5b,0xdb,0x56,0xdb,0xaa,0x6a,
 0x55,0x55,0xab,0xda,0xb6,0xad,0xb6,0xaa,0x55,0xb5,0xb2,0xad,0xad,0xd5,0xd6,
 0xaa,0x55,0xab,0x6d,0xab,0xd5,0xb6,0xaa,0x55,0xad,0x6d,0xb5,0x5a,0xad,0x5a,
 0xd5,0x6a,0x55,0xad,0xaa,0xd6,0x56,0xb5,0x56,0xb5,0xaa,0x6a,0x55,0xad,0x5a,
 0xab,0xd5,0xaa,0x6a,0x6d,0x55,0x5b,0x55,0x55,0xb5,0xaa,0x55,0xad,0x55,0xb5,
 0x56,0xad,0x55,0xab,0x55,0x25,0x42,0xab,0x56,0x55,0xb5,0xb5,0x56,0xd5,0xaa,
 0x6a,0x55,0xb5,0xad,0xb6,0xad,0x6a,0xab,0x55,0xb5,0x55,0x5b,0xad,0x55,0x6b,
 0x55,0xb5,0xb6,0xb5,0x56,0x6d,0x55,0x55,0xad,0xb6,0x6a,0x6d,0xad,0xb5,0xaa,
 0x56,0xb5,0xaa,0xb5,0x5a,0xab,0xaa,0x6a,0x57,0xb5,0xda,0xaa,0xb5,0x56,0xb5,
 0x55,0xab,0xb5,0x55,0xb5,0xb6,0x5a,0xab,0xaa,0xad,0x6a,0x6d,0xb5,0xaa,0xad,
 0xd6,0xaa,0xda,0xd6,0x5a,0x55,0x6d,0xb5,0x5a,0x15,0xb0,0xad,0xda,0xaa,0x55,
 0x55,0xb5,0x5a,0x6d,0xb5,0x6a,0x5b,0x55,0xab,0xd6,0xb6,0xb5,0xaa,0x56,0xd5,
 0xaa,0x6a,0x6d,0xad,0x6a,0xab,0xaa,0xaa,0xda,0xaa,0xda,0xb6,0x6a,0x55,0x55,
 0xab,0xd6,0xd6,0x56,0xdb,0xd6,0xd6,0xaa,0xad,0xda,0xb6,0xad,0x6a,0xab,0x55,
 0x5b,0x55,0xab,0xad,0xb6,0xda,0xaa,0x6a,0xad,0x5a,0xad,0xb5,0xb6,0x6a,0x55,
 0xab,0xd6,0xb6,0x6a,0xb5,0xd6,0x56,0x55,0xd5,0xb6,0x56,0xad,0xd6,0x2a,0xaa,
 0x6a,0xb5,0x6d,0xad,0xb6,0xd5,0x56,0xd5,0xd6,0x56,0xd5,0xda,0x6a,0xb5,0xaa,
 0x56,0xdb,0xaa,0xb6,0xb6,0x55,0xab,0x5a,0x5b,0x6d,0xad,0xd6,0xaa,0xb5,0xb5,
 0x6a,0xdb,0xaa,0xad,0x5a,0x35,0x55,0x6d,0x55,0x55,0xad,0x56,0x6b,0x55,0x6d,
 0xd5,0x5a,0xad,0xb6,0x6a,0x6b,0xb5,0x6a,0xd5,0xaa,0x56,0x5b,0x6b,0xd5,0x6a,
 0xad,0x55,0xdb,0xd6,0xda,0xaa,0x55,0x5b,0xab,0xad,0x6a,0xdb,0x56,0xd5,0xda,
 0x6a,0x55,0x15,0x54,0x55,0xab,0xaa,0x6a,0xab,0x5a,0xd5,0x56,0x55,0xb5,0x56,
 0xad,0x5a,0x55,0x55,0xd5,0x6a,0xb5,0x55,0x55,0x6d,0x55,0xab,0xad,0xaa,0xb5,
 0xb5,0x56,0xad,0x56,0xab,0x2a,0xdb,0x6a,0xab,0xd5,0xb5,0xb2,0xaa,0xad,0xd5,
 0xda,0xaa,0xad,0xaa,0x6a,0xd5,0x6a,0x55,0x55,0xb5,0xda,0x56,0xad,0xb6,0xda,
 0xaa,0x55,0xab,0x56,0xd5,0xda,0xaa,0x6a,0x55,0xb5,0xaa,0x55,0xb5,0x6a,0xb5,
 0xaa,0x6a,0x5b,0x55,0xad,0xb5,0x15,0x6a,0xdb,0x56,0xad,0xd5,0x5a,0xab,0xad,
 0x5a,0x5b,0xab,0xb5,0x55,0xd5,0xb6,0x6d,0xad,0x56,0x6b,0xad,0x6d,0xab,0xda,
 0x6a,0x6a,0x5b,0xab,0xaa,0x6d,0x6b,0xad,0x5a,0xeb,0xaa,0x56,0xb5,0x56,0xad,
 0xad,0x6d,0xb5,0x5a,0x55,0xad,0xda,0xaa,0xad,0x56,0xdb,0x6a,0xdb,0xd6,0xa6,
 0xda,0x5a,0xd5,0xaa,0x56,0xad,0xb6,0xb5,0xaa,0xaa,0x56,0x5b,0xab,0xad,0xb6,
 0x6a,0xab,0xaa,0xad,0x56,0x5b,0xd5,0x6a,0xab,0x56,0x15,0xb5,0x55,0xd9,0xd6,
 0xb6,0xaa,0xd5,0x6a,0xab,0xd5,0xda,0x5a,0xb5,0xad,0xaa,0xaa,0xb5,0x5a,0xad,
 0x6a,0x55,0xd5,0x56,0xb5,0x56,0x55,0xd5,0xb6,0xaa,0xaa,0x6a,0xad,0xad,0xda,
 0xda,0xda,0x6a,0xd5,0xaa,0xaa,0x56,0xad,0xb6,0x6a,0x55,0xdb,0xaa,0xb5,0x2a,
 0x5b,0xad,0xaa,0x6a,0x55,0x6b,0x5b,0x6d,0x6b,0xd5,0xaa,0x5a,0xb7,0xd6,0xda,
 0xaa,0xda,0xd6,0xda,0x5a,0x6d,0x5b,0xd5,0xda,0xaa,0x5a,0x5b,0xd5,0x6a,0x2d};

icon_struct	letters_ic = { letters_width, letters_height, 
			      (char*)letters_bits };
icon_struct	spl_bckgnd_ic = { spl_bckgnd_width, spl_bckgnd_height, 
			      (char*)spl_bckgnd_bits };
