/*
    $Id: test_xkeyswrc.c,v 1.2 2001/06/21 21:14:35 dima Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 2000  Dima Barsky <dima@debian.org>,
                        Igor Belyi  <ibelyi@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include "xkeyswrc.h"

/*
 * Test of the xkeyswrc parser generated from xkeyswrc.l and xkeyswrc.y
 *
 * Input is a filename to parse.
 * Output is the parsed structure - the list of groups and the list of keymaps.
 */

int main(int argc, char* argv[]) {
    group_t* group;
    keymap_t* keymap;
    keysym_t* keysym;
    value_t* value;
    element_t* elem;

    if(argc > 1) {
	includeFile(argv[1]);
    }

    printf("Groups:\n");
    for(group=group_list; group!=NULL; group=group->next) {
	printf("\tname = %s\n", group->name);
	if (group->pattern) {
	    printf("\t\tpattern = %s", group->pattern->name);
	    for(elem=group->pattern->next; elem!=NULL; elem=elem->next)
		printf(",%s", elem->name);
	    printf("\n");
	}
	if (group->except) {
	    printf("\t\texcept = %s", group->except->name);
	    for(elem=group->except->next; elem!=NULL; elem=elem->next)
		printf(",%s", elem->name);
	    printf("\n");
	}
    }

    printf("Keymaps:\n");
    for(keymap=keymap_list; keymap!=NULL; keymap=keymap->next) {
	printf("\tname = %s\n", keymap->name);
	if (keymap->prefix)
	    printf("\t\tprefix = %s\n", keymap->prefix);
	if (keymap->keymap_list) {
	    printf("\t\tbased =");
	    for(elem=keymap->keymap_list; elem!=NULL; elem=elem->next)
		printf(" %s", elem->name);
	    printf("\n");
	}
	for(keysym=keymap->keysym_list; keysym!=NULL; keysym=keysym->next) {
	    printf("\t\t");
	    if(keysym->group_spec)
		printf("group %s ", keysym->group_spec);
	    if(keysym->mod_list)
		for(elem=keysym->mod_list; elem!=NULL; elem=elem->next)
		    printf("%s ", elem->name);
	    printf("keysym %s = ", keysym->keysym);
	    for(value=keysym->values; value!=NULL; value=value->next) {
		if (value->value) {
		    printf("%s", value->value->name);
		    for(elem=value->value->next; elem!=NULL; elem=elem->next)
			printf(",%s", elem->name);
		}
		if (value->keymap)
		    printf("/%s ", value->keymap);
		else
		    printf(" ");
	    }
	    printf("\n");
	}
    }

    return 0;
}

