/* ,file-id archive://[lord]/398/vu/./scan.c/1998-05-18
*/
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



#include <ctype.h>
#include <errno.h>
#include "scan.h"



unsigned int
scan_uhex (int * errn, char ** sp, int * lp, int fwidth)
{
  char * str;
  int len;
  unsigned int prev_n;
  unsigned int n;
  

  str = *sp;
  len = *lp;
  prev_n = 0;
  n = 0;

  if (!fwidth)
    fwidth = len;

  while (len && fwidth && isxdigit (*str))
    {
      prev_n = n;

      if (isdigit (*str))
	n = n * 16 + (*str - '0');
      else
	n = n * 16 + (toupper (*str) - 'A');

      if ((n / 16) != prev_n)
	{
	  *errn = ERANGE;
	  return -1;
	}

      --len;
      --fwidth;
      ++str;
    }

  *sp = str;
  *lp = len;

  return n;
}
