

#include "stdio.h"
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define GTK_ENABLE_BROKEN
#include <gtk/gtk.h>
#include "gtk-meta.h"

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#ifdef HAVE_X
#include <gdk/gdkx.h>
#endif
#include <gdk/gdkrgb.h>


#include <gdk/gdk.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

#include "guide.h"
#include "settings.h"
#include "utils.h"

/* trick to have a translation that is not immediate */
#ifdef ENABLE_NLS 
#undef _
#define _(S) (g_strdup(dgettext(PACKAGE,(S))))
//#define _(S) (g_strdup(S))
#endif


#if GTK_MAJOR_VERSION >= 2
#define SHOW(A)      gtk_widget_show(A);gtk_window_deiconify(GTK_WINDOW(A));
#define HIDE(A)      gtk_window_iconify(GTK_WINDOW(A));
#else
#define SHOW(A)      gtk_widget_show(A);
#define HIDE(A)      gtk_widget_hide(A);
#endif


/* the first letter in the title is W if it only applies to warp,
 and M for morph*/
char **pane_text=NULL;


static void init_text()
{ 
  char *p[] = {    
    _(" Introduction"),
    
    _("     Welcome to GtkMorph\n\n\
GtkMorph is a powerful program that permits you to warp or morph images.\
\n\n\
   Using this guide.\
\n\n\
Hit 'next' to skip a topic, or 'do it' to do it; when you have done a topic,\
 hit 'Guide' in the main window to come back to the guide.\n\
(Note that, when you hit 'do it', the guide will iconify and deiconify\
 other windows to highlight your task: with some dumb window managers,\
 this will not work ok).\n\
 If you are not satisfied by the way you have complied with the guide\
 requests, hit 'prev' and 'do it' to retry the task.\n\
As a first task, you may get acquainted with the main gtkmorph window:\
 if you want to give it a look, hit 'do it': the main window will pop up!\
 Note that, if you keep the mouse still on a menu voice or on a button\
 for a moment, a tip shows up. When you are done,\
 hit 'Guide' to come back to the guide.\n\
If you know the program main window, simply hit 'next'.\
\n\n\
If you are fed up with the guide, you may\
 stop it at any time by closing this window:\
 the normal gtkmorph program will pop up."),

    _(" Select subimage size"),

    _("Now you select the size that the output image(s) \
will have. To this end, in the lower part of the main window, there is a \
pair of spins; select your preferred size and hit 'apply'.\n\
After that, you will be brought back to the guide.\n\
You may change the size again by selecting 'resulting size...' \
in the Edit menu."),

    _(" Morph or warp"),

    _("You may `warp' or `morph'.\n\n\
'Warp' means 'to deform, contort, distort, wring, bend, or otherwise twist'.\n\
If you have one single input image and you want to make \
a distortion of it, then you want to warp it. In this case, hit 'next'\n\n\
'Morphing' images instead means 'blending together warped versions\
 of the images'. So\
 to morph you need two or more input images.\n\
In this case, press 'do it', and, in the File menu, choose 'add image'\
 as many times as\
 to reach the required number of input images,\
 then hit 'Guide' in the main window.\
\n\n\
Note that at startup the program is set for ``warping'':\
 there is only one input image."),

    _(" Load image(s)"),

    _("Now you need to load the input images.\n\
In each input image window, load the input image \
using the big 'load image' button."),

    _("WLoad reference image"),

    _("If you wish, you may load an image in the main window; it may help you \
if you are warping images and you want to have a reference to use as a \
target. This is not really necessary, and you may do as well without.\n\n\
If in this reference image there are 3 important features, like the eyes \
and mouth in face, then you should drag the 3 white points on these \
features.\n\n\
Similarly, if you have a reference mesh that is associated to this image, \
you may load it now, using the 'load mesh' button\n\n\
When done, click 'Guide'."),

    _(" Select subimage(s)"),

    _("Now you select a subimage of each input image. You do this by either\
 moving the selection rectangle (using the spins at bottom of the\
 window) or by dragging the 3 white feature points. (see [1] below)\
\n\n\
When you have chosen the preferred subimage, hit 'apply'\
 (and the window will close).\
 If later you find out that are not satisfied of your choice, you may\
 click in the option menu (at center top) and select 'choose subimage' to\
 repeat this process.\
\n\n\
Alternatively,\
 if you have already a mesh for this image, you may load it now; since the\
 subimage selection is saved with the mesh; when you load the saved mesh,\
 the subimage is reselected for you.\
\n\n\
 [1] Note that you cannot position the 3 points freely: their mutual\
 position is copied from the position of the 3 reference points in the\
 resulting image; so you will need to be patient.\n\
Note also that the selection rectangle has currently a fixed aspect\
 (see [2]); if you want to freely change the aspect, change the\
 'preserve aspect ratio' setting in the 'settings'.\n\
 [2] 'aspect' is the ratio between width and height."),
    
    _(" Adjust mesh"), 

    _("Now you adjust the mesh in the input image(s) so that they best fit\
 to the features of those images. If you hit the right mouse key while on\
 the mesh, you will get a menu.\n\
It is very important that points in different meshes are syncronized, that is,\
 that point (i,j) in every mesh is associated to the same type of feature;\
 for this reason, when you drag a point in a mesh, the same point flashes in\
 all other meshes.\n\
When you have put points on a feature (say, for example, the right eye),\
 you may hit 'pack' to pack all this point into a 'feature': you may\
 then move them all together, using the 'move' tool. (After you hit 'pack'\
 you should also hit 'new' to change feature).\
\n\n\
From time to time, you better save the mesh(es).\
\n\n\
Tips:\n\
1) try to keep the mesh lines as linear as possible:\
 add new lines (with right mouse button) if this helps!\n\
2) to have a better morph, for each image, set the `morph factors' to\
 a maximum, hit `do warp' and try to adjust the mesh until this warp\
 looks right\n\
3) if you are fighting with small details, then you should increase\
 the resulting image size until you have fixed things. (Use the\
 the 'x2' button.)\n"),

    _("WWarp"),
    _("Hit the 'do warp' button to view the warp. If you are not satisfied, \
choose 'edit mesh' in the option menu (top center) and edit the mesh further.\
From time to time, you better save the mesh.\
\n\n\
Tips:\n\
  1) try to keep the mesh lines as linear as possible:\n\
   add new lines (with right mouse button) if this helps!\n\
  2) if you are fighting with small details, then you should increase\n\
    the resulting image size until you have fixed things\n"),

    _("MMorph"),
    _("To morph your images, you must decide how much each image should\
 influence the resulting morph. To this end, you adjust the morph factors\
 to your need; the 'mesh interpolation' slide tells how much this mesh\
 will influence the resulting mesh, and the 'image blending' tells how much\
 this image is visible in the resulting image.\n\n\
Then hit the 'do morph' button in the main window to view the morph.\n\
 If you are not satisfied,\
 choose 'edit mesh' in the option menu (top center) and edit the mesh further;\
 or, choose 'view warp&mesh' and edit the morph factors.\
\n\n\
If you want to change the morph factors further, choose ``morph factors..''\
 in the 'edit' menu\
\n\n\
Tip: set all factors to equal values and\
 do a morph: if the images do not superimpose well, you may try to select\
 a subimage in each image so that they superimpose better"),
    
    _("MMovie"),
    _("To make a movie of your morph, choose 'morph sequence' in the Morph menu.\
 A window will pop up. Click on help there for further help."),
    /* END OF LIST */
    _(" End"),
    _("Here ends the guide.\n\nGoodbye and thank you"),
    NULL,
    NULL
  };
  pane_text=g_malloc(sizeof(p));
  memcpy(pane_text,p,sizeof(p));
}



int guide_step=0,  guide_tot_steps=-1;
GtkWidget *guide_widget=NULL;

#if GTK_MAJOR_VERSION >= 2
GtkTextView *guide_widget_text=NULL;
#else
GtkText *guide_widget_text=NULL;
GtkEditable *guide_widget_editable=NULL;
#endif




gboolean guide_callback(char *what,
		    int imagenum)
{
  int lp=0;
  if(!guide_widget)
    return FALSE;

  if(!(sp->im_widget[imagenum])) {
    g_critical("guide cannot auto hide %d",imagenum);
    return FALSE;
  }
    
  if ( guide_step!= 6 && ! 
       (strcmp(what,"file")==0 && imagenum==MAIN_WIN)
       )  {
    HIDE(sp->im_widget[imagenum]);
    

    for(lp=0;lp<MAX_WINS+2;lp++)
      if(sp->im_widget[lp])
	if( GTK_WIDGET_VISIBLE (sp->im_widget[lp])) {
	  g_debug("guide:image %d is visible",lp);
	  return TRUE;
	}
    on_back_to_guide_activate(NULL,NULL);
  }
  return TRUE;
}




void guide_set_text()
{
  char s[6000];

  g_return_if_fail(guide_widget_text);

  if(!pane_text || !pane_text[guide_step*2] || !pane_text[guide_step*2+1]) {
    g_critical("no guide text %d!!!",guide_step);
    return;
  }
  sprintf(s,"gtkmorph guide %d:%s",guide_step,pane_text[guide_step*2]+1);
  gtk_window_set_title(GTK_WINDOW (guide_widget), s);  
  sprintf(s,"                                            [task %d:%s]\n",
	  guide_step,pane_text[guide_step*2]+1);

#if GTK_MAJOR_VERSION >= 2
 {

  GtkTextBuffer *buffer;

  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (guide_widget_text));

  gtk_text_buffer_set_text (buffer, s,-1);
  gtk_text_buffer_insert_at_cursor (buffer,
				    pane_text[guide_step*2+1],-1);
  /* Now you might put the view in a container and display it on the
   * screen; when the user edits the text, signals on the buffer
   * will be emitted, such as "changed", "insert_text", and so on.
   */
 }
#else
 {
   gint position;
   gtk_text_freeze (guide_widget_text);
  if(gtk_text_get_length (guide_widget_text)>0)
    gtk_editable_delete_text(guide_widget_editable,//GtkEditable *editable,
			     0,//gint start_pos,
			     gtk_text_get_length (guide_widget_text));
  gtk_text_set_point(guide_widget_text,0);
  gtk_editable_insert_text(guide_widget_editable,
			   s,strlen(s),   &position);
  gtk_editable_insert_text(guide_widget_editable,//GtkEditable *editable,
			   pane_text[guide_step*2+1],//const gchar *new_text,
			   strlen(pane_text[guide_step*2+1]),
			   //gint new_text_length,
			   &position);//gint *position);

  gtk_text_thaw (guide_widget_text);
 }
#endif
}



static void show_all(int step)
{ 
  int lp=0,m=MAIN_WIN;

  while (gtk_events_pending())
    gtk_main_iteration ();


  if(step==0 || step==1 || step == 4) {
    lp=m;
  }  else
    if(step==3||step==5||step==6)
      m--;

  for(;lp<=m;lp++)
    if(sp->im_widget[lp]) {
      SHOW(sp->im_widget[lp]);
    }
}

static void hide_all()
{ 
  int lp;

  while (gtk_events_pending())
    gtk_main_iteration ();

  for(lp=0;lp<MAX_WINS+2;lp++)
    if(sp->im_widget[lp]) {
      HIDE(sp->im_widget[lp]);
    }
}





void guide_initialize()
{
  int lp=0;

  if(guide_widget)
    return;

  init_text();
  
  while(pane_text[lp])
    lp++;
  lp--;
  guide_tot_steps=lp/2;
  
  guide_widget=create_guide();


#if GTK_MAJOR_VERSION >= 2
  guide_widget_text=GTK_TEXT_VIEW(lookup_widget(guide_widget,"text"));
  g_assert(guide_widget_text);
#else
  guide_widget_text=GTK_TEXT(lookup_widget(guide_widget,"text"));
  guide_widget_editable=GTK_EDITABLE(lookup_widget(guide_widget,"text"));
  g_assert(guide_widget_text && guide_widget_editable);
#endif



  guide_set_text();
  gtk_window_set_default_size(GTK_WINDOW(guide_widget),700,300);
  gtk_widget_show(guide_widget);
  
  hide_all();

  settings_set_value("no warnings",1);
}

void guide_next()
{
  guide_step++;
  while(guide_step<guide_tot_steps && 
	(    ( pane_text[2*guide_step][0] == 'M' && sp->max_wins==1 )
	  || ( pane_text[2*guide_step][0] == 'W' && sp->max_wins> 1 )
	     ))
    guide_step++;
}


/*************************** callbacks **********************************/
void
on_back_to_guide_activate              (GtkButton     *button,
                                        gpointer         user_data)
{
  guide_initialize();
  guide_next();
  if(guide_step<guide_tot_steps) {
    guide_set_text();
    hide_all();
    SHOW(guide_widget);
  } else
    gtk_object_destroy(GTK_OBJECT(guide_widget)); 
}


void
on_guide_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  for(lp=0;lp<MAX_WINS+2;lp++)
    if(sp->im_widget[lp])
      {
	GtkWidget *w=(lookup_widget(sp->im_widget[lp],"back_to_guide"));
	if(w) gtk_widget_show(w);
      }
  guide_initialize();
  guide_set_text();
  hide_all();
  gtk_widget_show(guide_widget);
  SHOW(guide_widget);
}


gboolean
on_guide_text_expose_event             (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  return FALSE;
}


void
on_guide_prev_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  if(guide_step>0)
    guide_step--;
  guide_set_text();
}


void
on_guide_do_it_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  int lp=0,  z=EDITVIEW_EYES;

  if(guide_step>5)
    z=EDITVIEW_EDIT;
  if(guide_step==8)
    z=EDITVIEW_SHOWMESHES;

  show_all(guide_step);

  for(lp=0;lp<=MAIN_WIN;lp++)
    if(sp->im_widget[lp]) {
      set_editview(lp,z);
    }
}


void
on_guide_next_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  guide_next();
  if(guide_step<=guide_tot_steps) {
    guide_set_text();
  } else
    gtk_object_destroy(GTK_OBJECT(guide_widget)); 
}


gboolean
on_guide_delete_event                  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  //destroy will be called as well
  return FALSE;
}


void
on_guide_destroy  (GtkObject       *object,
		   gpointer         user_data)
{
  //GtkWidget *widget = GTK_WIDGET(object);
  int lp;
  show_all(-1);
  guide_widget=NULL;
  guide_widget_text=NULL;
#if GTK_MAJOR_VERSION < 2
  guide_widget_editable=NULL;
#endif
  settings_set_value("no warnings",0);
  for(lp=0;lp<MAX_WINS+2;lp++)
    if(sp->im_widget[lp])
      {
	GtkWidget *w=(lookup_widget(sp->im_widget[lp],"back_to_guide"));
	if(w) gtk_widget_hide(w);
      }
}
