/*
 *  Warning/error routines.
 *
 *  Copyright (c) 2002  Brendan O'Dea <bod@debian.org>
 *
 *  This is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "misc.h"
#include "carp.h"

RCS_Id("$Id: carp.c,v 1.1 2002/01/20 07:14:25 bod Exp $")

char const *self = 0;

static void confess(int print_err, char const *fmt, void *ap)
{
    char const *err;

    if (self && *self)
	fprintf(stderr, "%s: ", self);

    vfprintf(stderr, fmt, ap);
    if (print_err && errno && (err = strerror(errno)) && *err)
	fprintf(stderr, " (%s)\n", err);
    else
	putc('\n', stderr);
}

void carp(int print_err, char const *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    confess(print_err, fmt, ap);
    va_end(ap);
}

void croak(int exit_value, int print_err, char const *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    confess(print_err, fmt, ap);
    va_end(ap);

    exit(exit_value);
}
