$ save_verify='f$verify(0)
$! set ver
$!
$!      Compile and link for xrubik
$!
$! USAGE:
$! @make [debug clobber clean]
$!       debug : compile with debugger switch
$!       clean : clean all except executable
$!       clobber : clean all
$!
$! If you have
$!              XVMSUTILS library (VMS6.2 or lower)
$!              XPM library
$!              Mesa GL library
$! insert the correct directory instead of X11:
$ xvmsutilsf="X11:XVMSUTILS.OLB"
$ xpmf="SYS$LIBRARY:LIBXPM.OLB"
$ glf="GL:LIBMESAGL.OLB"
$ glf_share="GL:LIBMESAGL.EXE"
$!
$! Already assumes DEC C on Alpha.
$! Assume VAX C on VAX.
$ decc=0
$! Assume DEC C on VAX.
$! decc=1
$!
$ QUOTE = """""""""
$ QUOTE = QUOTE + QUOTE + QUOTE
$ scorepath = "SCOREPATH=" + QUOTE + "[]" + QUOTE
$ scorefile = "SCOREFILE=" + QUOTE + "rubik.scores" + QUOTE
$ logpath = "LOGPATH=" + QUOTE + "[]" + QUOTE
$ logfile = "LOGFILE=" + QUOTE + "rubik.log" + QUOTE
$ defscore=="''scorepath',''scorefile'"
$ deflog=="''logpath',''logfile'"
$!
$! NOTHING SHOULD BE MODIFIED BELOW
$!
$ if p1 .eqs. "CLEAN" then goto Clean
$ if p1 .eqs. "CLOBBER" then goto Clobber
$!
$ axp=f$getsyi("HW_MODEL") .ge. 1024
$ sys_ver=f$edit(f$getsyi("version"),"compress")
$ if f$extract(0,1,sys_ver) .nes. "V"
$ then
$   type sys$input
This script will assume that the operating system version is at least V7.0.
$!
$   sys_ver="V7.0"
$ endif
$ sys_maj=0+f$extract(1,1,sys_ver)
$ if sys_maj .lt. 7
$ then
$   xvmsutils=f$search("''xvmsutilsf'") .nes. ""
$ endif
$ xpm=f$search("''xpmf'") .nes. ""
$ gl=f$search("''glf'") .nes. ""
$ gl_share=f$search("''glf_share'") .nes. ""
$!
$!
$! Create .opt file
$ close/nolog optf
$ open/write optf xrubik.opt
$!
$ defs=="VMS"
$ defs=="''defs',HAVE_MOTIF"
$ if xpm then defs=="''defs',HAVE_XPM"
$ if gl .or. gl_share then defs=="''defs',HAVE_OPENGL,HAVE_GLBINDTEXTURE"
$ if sys_maj .lt. 7
$ then
$   if xvmsutils then defs=="''defs',USE_XVMSUTILS"
$ else
$   defs=="''defs',SRAND=srand48,LRAND=lrand48,MAXRAND=2147483648.0"
$ endif
$ defs=="''defscore',''deflog',''defs'"
$!
$!
$! Establish the Compiling Environment
$!
$! Set compiler command
$ if axp
$ then
$   cc=="cc/standard=vaxc/define=(''defs')"
$ else
$   if decc
$   then
$     cc=="cc/decc/standard=vaxc/define=(''defs')"
$   else ! VAX C
$     cc=="cc/define=(''defs')"
$   endif
$ endif
$ if p1 .eqs. "DEBUG" .or. p2 .eqs. "DEBUG" .or. p3 .eqs. "DEBUG"
$ then
$   if axp
$   then
$     cc=="cc/deb/noopt/standard=vaxc/define=(''defs')/list"
$   else
$     if decc
$     then
$       cc=="cc/deb/noopt/decc/standard=vaxc/define=(''defs')/list"
$     else ! VAX C
$       cc=="cc/deb/noopt/define=(''defs')/list"
$     endif
$   endif
$   link=="link/deb"
$ endif
$!
$ if axp .or. .not. decc
$ then
$   define/nolog sys sys$library
$ endif
$!
$ write sys$output "Compiling xrubik with ''defs'"
$ call make Rubik.obj    "cc Rubik.c"    Rubik.c RubikP.h Rubik.h
$ call make Rubik2d.obj  "cc Rubik2d.c"  Rubik2d.c RubikP.h Rubik.h Rubik2dP.h Rubik2d.h
$ call make Rubik3d.obj  "cc Rubik3d.c"  Rubik3d.c RubikP.h Rubik.h Rubik3dP.h Rubik3d.h
$ if gl .or. gl_share
$ then
$   call make RubikGL.obj  "cc RubikGL.c"  RubikGL.c RubikP.h Rubik.h RubikGLP.h RubikGL.h
$ endif
$ call make RubikS.obj  "cc RubikS.c"  RubikS.c RubikP.h Rubik.h
$ call make RubikU.obj  "cc RubikU.c"  RubikU.c RubikP.h Rubik.h
$ call make rngs.obj    "cc rngs.c"    rngs.c
$ call make xrubik.obj  "cc xrubik.c"  xrubik.c Rubik.h
$!
$! Get libraries
$ if xpm then write optf "''xpmf'/lib"
$ if gl then write optf "''glf'/lib"
$ if gl_share then write optf "''glf_share'/share"
$ if sys_maj .lt. 7
$ then
$   if xvmsutils then write optf "''xvmsutilsf'/lib"
$ endif
$! if .not. axp then write optf "sys$library:vaxcrtl/lib"
$ write optf "sys$library:vaxcrtl/lib"
$ if axp then write optf "sys$library:ucx$ipc_shr/share"
$ if axp then write optf "sys$share:decw$xextlibshr/share"
$ if axp then write optf "sys$share:decw$xtlibshrr5/share"
$ if .not. axp then write optf "sys$library:ucx$ipc/lib"
$! write optf "sys$share:decw$dxmlibshr/share"
$ write optf "sys$share:decw$xmlibshr12/share"
$ write optf "sys$share:decw$xlibshr/share"
$ close optf
$!
$! LINK
$ write sys$output "Linking xrubik"
$ link/map xrubik/opt
$!
$ set noverify
$ exit
$!
$Clobber:      ! Delete executables, Purge directory and clean up object files
$!                and listings
$ delete/noconfirm/log xrubik.exe;*
$!
$Clean:        ! Purge directory, clean up object files and listings
$ close/nolog optf
$ purge
$ delete/noconfirm/log *.lis;*
$ delete/noconfirm/log *.obj;*
$ delete/noconfirm/log *.opt;*
$ delete/noconfirm/log *.map;*
$!
$ exit
$!
! SUBROUTINE TO CHECK DEPENDENCIES
$ make: subroutine
$   v='f$verify(0)
$!   p1       What we are trying to make
$!   p2       Command to make it
$!   p3 - p8  What it depends on
$
$   if (f$extract(0,3,p2) .eqs. "cc ") then write optf "''p1'"
$   if (f$extract(0,3,p2) .eqs. "CC ") then write optf "''p1'"
$
$   if f$search(p1) .eqs. "" then goto MakeIt
$   time=f$cvtime(f$file(p1,"RDT"))
$   arg=3
$Loop:
$   argument=p'arg
$   if argument .eqs. "" then goto Exit
$   el=0
$Loop2:
$   file=f$element(el," ",argument)
$   if file .eqs. " " then goto Endl
$   afile=""
$Loop3:
$   ofile=afile
$   afile=f$search(file)
$   if afile .eqs. "" .or. afile .eqs. ofile then goto NextEl
$   if f$cvtime(f$file(afile,"RDT")) .gts. time then goto MakeIt
$   goto Loop3
$NextEL:
$   el=el+1
$   goto Loop2
$EndL:
$   arg=arg+1
$   if arg .le. 8 then goto Loop
$   goto Exit
$
$MakeIt:
$   set verify
$   'p2
$   vv='f$verify(0)
$Exit:
$   if v then set verify
$ endsubroutine
