/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#include "icon_inferred.xpm"

const char *tideDialogText = "This dialog allows you to update, add, or "
  "delete a tide station record.  Pressing the OK button will save all "
  "changes made to this record to the database.  Pressing the Cancel button "
  "will discard all changes.  You can delete a record using the Delete Record "
  "button.";
const char *recnumText = "This is the record number in the tide constituent "
  "database.  It is for information only and is not editable.";
const char *refText = "This is the reference station name for this "
  "subordinate record.  It is for information only and is not editable.";
const char *nameText = "This is the name of the station.";
const char *latText = "This is the latitude of the station.  It will be "
  "displayed in the format selected in the <b>Preferences</b> menu.  The "
  "latitude may be entered in any of the following formats:<br><br>"
  "        Hemisphere Degrees Minutes Seconds.decimal<br>"
  "        Hemisphere Degrees Minutes.decimal<br>"
  "        Hemisphere Degrees.decimal<br>"
  "        SignDegrees Minutes Seconds.decimal<br>"
  "        SignDegrees Minutes.decimal<br>"
  "        SignDegrees.decimal<br><br>"
  "South is negative.";
const char *lonText = "This is the longitude of the station.  It will be "
  "displayed in the format selected in the <b>Preferences</b> menu.  The "
  "longitude may be entered in any of the following formats:<br><br>"
  "        Hemisphere Degrees Minutes Seconds.decimal<br>"
  "        Hemisphere Degrees Minutes.decimal<br>"
  "        Hemisphere Degrees.decimal<br>"
  "        SignDegrees Minutes Seconds.decimal<br>"
  "        SignDegrees Minutes.decimal<br>"
  "        SignDegrees.decimal<br><br>"
  "West is negative.";
const char *sourceText = "This is the source of the station data.";
const char *tzfileText = "This is the timezone name from tzdata2002c.";
const char *countryText = "This is the country name taken from the ISO 3199-1 "
  "two-character country ID data file.";
const char *pedigreeText = "This is the pedigree information from the XTide "
  "harmonics.txt file.  You probably shouldn't change this unless you really "
  "know what you are doing.";
const char *restrictionText = "This is the data restriction for this station. "
  "Usually this is set to <b>PUBLIC DOMAIN</b>.  If you don't know what the "
  "restriction is you should leave this alone.";
const char *commentsText = "This is the comments field for the station. "
  "You are allowed 1500 characters.  You can allow the text to wrap or use "
  "the <b>Enter</b> key to start new lines.  Blank lines are accepted.";
const char *unitsText = "This is the units field for a reference station. "
  "This is usually <b>meters</b> or <b>feet</b> but, in the case of a "
  "current, may be <b>knots</b> or <b>knots^2</b>.";
const char *datumText = "This is the datum name for a reference station. "
  "This is usually <b>Mean Lower Low Water</b>.";
const char *datum_offsetText = "This is the offset from the above datum in "
  "the specified units.";
const char *zone_offsetText = "This is the time offset in hours and minutes "
  "from Greenwich Mean Time.  The format is +/-HHMM.  Do not use daylight "
  "savings time.";
const char *expiration_dateText = "This is the expiration date for this "
  "station.  The format is YYYYMMDD.  Unknown is indicated by a blank.";
const char *monthsText = "This is the number of months that tide data was "
  "collected for this station.  Unknown is indicated by a blank.";
const char *ldosText = "This is the last date that a tide gage was on this "
  "station.  The format is YYYYMMDD.  Unknown is indicated by a blank.";
const char *constituentsText = "This table contains all of the amplitude and "
  "epoch data for this station.  The constituent names are not editable. "
  "Blank fields are undefined.  To edit a field double-click in the field.  "
  "To remove a constituent replace the values with blanks.  Fields containing "
  "a <img source=\"inferred\"> are inferred constituents.  They are there "
  "mostly for information and are not actually stored in the database.  They "
  "are computed \'on-the-fly\'.  If you modify one of these values it "
  "<i><b>will</b></i> be saved to the database and will no longer be treated "
  "as an inferred constituent.";
const char *level_unitsText = "This is the units field for the <b>Minimum "
  "Level Add</b> and <b>Maximum Level Add</b> fields.  This is usually "
  "<b>meters</b> or <b>feet</b> but, in the case of a current, may be "
  "<b>knots</b> or <b>knots^2</b>.";
const char *direction_unitsText = "This is the units field for the <b>Minimum "
  "Direction</b> and <b>Maximum Direction</b> fields.";
const char *min_time_addText = "This is the minimum time corrector for the "
  "station.  The format is +/-HHMM.  Blank indicates <b>Unknown</b>.";
const char *min_level_addText = "This is the minimum level corrector (in the "
  "specified units) for the station.  Blank indicates <b>Unknown</b>.";
const char *min_level_multText = "This is the minimum level multiplier for "
  "the station.  Blank indicates <b>Unknown</b>.";
const char *min_avg_levelText = "This is the minimum average level corrector "
  "(in the specified units) for the station.  Blank indicates "
  "<b>Unknown</b>.  This is used for current records and, at present, is not "
  "used in <b>XTide</b>.";
const char *min_directionText = "This is the minimum direction corrector (in "
  "the specified units) for the station.  Blank indicates "
  "<b>Unknown</b>.  This is used for current records and, at present, is not "
  "used in <b>XTide</b>.";
const char *max_time_addText = "This is the maximum time corrector for the "
  "station.  The format is +/-HHMM.  Blank indicates <b>Unknown</b>.";
const char *max_level_addText = "This is the maximum level corrector (in the "
  "specified units) for the station.  Blank indicates <b>Unknown</b>.";
const char *max_level_multText = "This is the maximum level multiplier for "
  "the station.  Blank indicates <b>Unknown</b>.";
const char *max_avg_levelText = "This is the maximum average level corrector "
  "(in the specified units) for the station.  Blank indicates "
  "<b>Unknown</b>.  This is used for current records and, at present, is not "
  "used in <b>XTide</b>.";
const char *max_directionText = "This is the maximum direction corrector (in "
  "the specified units) for the station.  Blank indicates <b>Unknown</b>.  "
  "This is used for current records and, at present, is not used in "
  "<b>XTide</b>.";
const char *flood_beginsText = "This is the time corrector for the beginning "
  "of flood tide for this station.  The format is +/-HHMM.  Blank indicates "
  "<b>Unknown</b>.";
const char *ebb_beginsText = "This is the time corrector for the beginning "
  "of ebb tide for this station.  The format is +/-HHMM.  Blank indicates "
  "<b>Unknown</b>.";
const char *subListText = "This dialog displays a list of subordinate "
  "stations for the selected reference station.  It also allows you to change "
  "the reference station for one or more of the listed subordinate stations.  "
  "You can use all of the standard <i><b>Extended</b></i> list selection "
  "options to select subordinate stations to have their reference station "
  "changed.  When the user selects an item the selection is cleared and the "
  "new item selected.  However, if the user presses the <b>Ctrl</b> key when "
  "clicking on an item, the clicked item gets toggled and all other items are "
  "left untouched.  And if the user presses the <b>Shift</b> key while "
  "clicking on an item, all items between the current item and the clicked "
  "item get selected or unselected, depending on the state of the clicked "
  "item.  Also, multiple items can be selected by dragging the mouse while "
  "the left mouse button is kept pressed.";
