/****************************************************************************
 *
 *                      scene.cc: Scene manipulation and rendering implementation
 *      This is part of the yafray package
 *      Copyright (C) 2002 Alejandro Conty Estevez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "threadedscene.h"
#include "matrix4.h"
#include <cstdio>
#include <cstdlib>
#include<fstream>

using namespace std;

#if HAVE_PTHREAD

#include<pthread.h>
#include <semaphore.h>
#include<map>

sem_t pstop;


__BEGIN_YAFRAY

/*
void threadedscene_t::renderPart(colorOutput_t &out, int curpass, int off)
{
	sem_wait(&pstop);
	scene_t::renderPart(out, curpass, off);
}

struct render_part_t
{
	scene_t *scene;
	colorOutput_t *out;
	int cpus, offset, curpass;
};

void * render_thread(void *param)
{
	render_part_t *part=(render_part_t *)param;

	part->scene->renderPart(*(part->out), part->curpass, part->offset);
	pthread_exit(0);
}
*/

void threadedscene_t::render(colorOutput_t &out)
{
	/*
	int resx,resy;
	int steps;
	resx=render_camera->resX();
	resy=render_camera->resY();
	vector<pthread_t> tid(cpus);
	pthread_attr_t attr;
	vector<render_part_t> part(cpus);


	fprintf(stderr,"Building the bounding tree ... ");
	fflush(stderr);
	BTree=new boundTree_t (obj_list);
	cout<<"OK\n";
	setupLights();

	cout<<"Launching "<<cpus<<" threads for rendering ...\n";
	cout<<"Rendering ...\n";

	colorBuffer.set(resx,resy);
	ZBuffer.set(resx,resy);
	ABuffer.set(resx,resy);
	oversample.set(resx,resy);

	for(int i=0;i<resy;++i)
		for(int j=0;j<resx;++j)
			oversample(j,i)=1;


	steps=resy/(int)(resy/STEPS);
	steps=cpus*((int)steps/cpus);

	cout << "0%";
	for(int i=0;i<((steps+1)/2)-3;++i) cout<<" ";
	cout << "50%";
	for(int i=0;i<((steps+1)/2)-3;++i) cout<<" ";
	cout << "100%\n";

	int numpass;
	if (AA_onepass_max) numpass=1; else numpass=AA_passes+1;
	for (int pass=0;pass<numpass;++pass)
	{
		cout<<"\r[";
		for(int i=0;i<steps;++i) cout<<".";
		if (pass==0)
			cout << "] first render pass\r";
		else
			cout << "] AA pass " << pass << "\r";
		cout<<"[";
		cout.flush();
		sem_init(&pstop, 0, 0);
		pthread_attr_init(&attr);
		pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_JOINABLE);
		for(int i=0;i<cpus;++i)
		{
			part[i].scene=this;
			part[i].out=&out;
			part[i].curpass=pass;
			part[i].cpus=cpus;
			part[i].offset=i;
			pthread_create(&tid[i], &attr, render_thread,(void *)&part[i]);
		}
		pthread_attr_destroy(&attr);
		for(int i=0;i<cpus;++i) {
				sem_post(&pstop);
		}
		for(int i=0;i<cpus;++i) {
				pthread_join(tid[i], NULL);
		}
		cout<<"]                  ";
		sem_destroy(&pstop);
		if(repeatFirst && (pass==0))
		{
			repeatFirst=false;
			--pass;
			cout<<"\nLight needs post init ...";cout.flush();
			postSetupLights();
			cout<<"OK, repeating first pass\n";
		}
		else if (!checkSampling()) break;
	}
	cout<<"\nThreads finished\n";
	delete BTree;
	BTree=NULL;

	for(list<filter_t *>::iterator ite=filter_list.begin();ite!=filter_list.end();
									ite++)
		(*ite)->apply(colorBuffer,ZBuffer,ABuffer);

	color_t color;
	for(int i=0;i<resy;++i)
		for(int j=0;j<resx;++j)
		{
			colorBuffer(j, i) >> color;
			out.putPixel(j, i, color, ABuffer(j, i));
		}
	*/
}

/*

void threadedscene_t::renderPart(colorOutput_t &out, int curpass, int off)
{
}

void threadedscene_t::render(colorOutput_t &out)
{
	cerr << "This yafray executable was built without threading support,\n"
			 << "Please try another strategy\n";
}
*/
__END_YAFRAY

#else

#endif

