#ifndef __VPORTS_H
#define __VPORTS_H

/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

/*
 * Copyright (C) 1999 Francesco P. Lovergine. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 4. Any modification to the program, as well as redistribution in binary
 *    or derived source form must be advertised to the author.
 *
 * THIS SOFTWARE IS PROVIDED `AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: vports.h,v 1.3 2000/12/04 09:24:11 kiavik Exp $ */

#ifdef VPORTS

#define VP_LIST_INIT	0xff
#define VP_RET_IGNORE	0
#define VP_RET_REJECT	1
#define VP_RET_ACCEPT	2
#define VP_CACHE_EXPIRE	30	/* in seconds */

typedef struct vp_callcache
{
	time_t tm;
	struct vp_callcache *next;
	struct vp_callcache *prev;
} VP_CALLCACHE;

typedef struct vp_acctid
{
	char acctid[32];
	struct vp_acctid *next;
	struct vp_acctid *prev;
} VP_ACCTID;

typedef struct vp_nas
{
	UINT4	addr;
	u_char acctidinit;
	VP_ACCTID *acctid_first;
	VP_ACCTID *acctid_last;
	struct vp_nas *next;
	struct vp_nas *prev;
} VP_NAS;

typedef struct vp_called
{
	char num[16];
	u_int max;
	u_char nasipinit;
	u_char callcacheinit;
	VP_NAS *nasip_first;
	VP_NAS *nasip_last;
	VP_CALLCACHE *cc_first;
	VP_CALLCACHE *cc_last;
	struct vp_called *next;
	struct vp_called *prev;
} VP_CALLED;

int vports_init();
VP_CALLED *begin_cidlist();
VP_CALLED  *new_cidlist();
VP_CALLED *get_cidlist(u_char *num);
void create_cidlist(u_char *num, int max);
int vports_in_use(VP_CALLED *cidcur);
int vports_in_cache(VP_CALLED *cidcur);
VP_CALLCACHE *begin_cclist(VP_CALLED *cidcur);
void free_single_cclist(VP_CALLED *cidcur, VP_CALLCACHE *cc_cur);
VP_CALLCACHE *new_cclist(VP_CALLED *cidcur);
VP_NAS *begin_nasiplist(VP_CALLED *cidcur);
void free_single_nasiplist(VP_CALLED *cidcur, VP_NAS *nasip_cur);
VP_NAS *get_nasiplist(VP_CALLED *cidcur, UINT4 addr);
VP_NAS *new_nasiplist(VP_CALLED *cidcur, UINT4 addr);
VP_ACCTID *begin_acctidlist(VP_NAS *nasip_cur);
void free_single_acctidlist(VP_NAS *nasip_cur, VP_ACCTID *acctid_cur);
VP_ACCTID *get_acctidlist(VP_NAS *nasip_cur, u_char *acctid);
VP_ACCTID *new_acctidlist(VP_NAS *nasip_cur, u_char *acctid);
int vp_check_req(AUTH_REQ *authreq);
void vp_update_cid(AUTH_REQ *authreq);

VP_CALLED	*cidfirst;
VP_CALLED	*cidlast;
u_char		vp_cidinit;


#endif /* VPORTS */

#endif /* __VPORTS_H */
