#include <string.h>

        struct yaz_iconv_trie_flat {
            char from[6];
            unsigned combining : 1;
            unsigned short to;
        };
        struct yaz_iconv_trie_dir {
            short ptr : 15;
            unsigned combining : 1;
            unsigned short to;
        };
        
        struct yaz_iconv_trie {
            struct yaz_iconv_trie_flat *flat;
            struct yaz_iconv_trie_dir *dir;
        };
    

        static unsigned long lookup(struct yaz_iconv_trie **ptrs, int ptr, unsigned char *inp,
                                    size_t inbytesleft, size_t *no_read, int *combining)
        {
            struct yaz_iconv_trie *t = (ptr >= 0) ? ptrs[ptr] : 0;
            if (!t || inbytesleft < 1)
                return 0;
            if (t->dir)
            {
                size_t ch = inp[0] & 0xff;
                unsigned long code =
                lookup(ptrs, t->dir[ch].ptr, inp+1, inbytesleft-1, no_read, combining);
                if (code)
                {
                    (*no_read)++;
                    return code;
                }
                if (t->dir[ch].to)
                {
                    code = t->dir[ch].to;
		    *combining = t->dir[ch].combining;
                    *no_read = 1;
                    return code;
                }
            }
            else
            {
                struct yaz_iconv_trie_flat *flat = t->flat;
                while (flat->to)
                {
                    size_t len = strlen(flat->from);
                    if (len <= inbytesleft)
                    {
                        if (memcmp(flat->from, inp, len) == 0)
                        {
                            *no_read = len;
			    *combining = flat->combining;
                            return flat->to;
                        }
                    }
                    flat++;
                }
            }
            return 0;
        }
    
/* TRIE: size 166 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_1page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x001B} /* 1B */,
  {-1, 0, 0},
  {-1, 0, 0x001D} /* 1D */,
  {-1, 0, 0x001E} /* 1E */,
  {-1, 0, 0x001F} /* 1F */,
  {-1, 0, 0x0020} /* 20 */,
  {-1, 0, 0x0021} /* 21 */,
  {-1, 0, 0x0022} /* 22 */,
  {-1, 0, 0x0023} /* 23 */,
  {-1, 0, 0x0024} /* 24 */,
  {-1, 0, 0x0025} /* 25 */,
  {-1, 0, 0x0026} /* 26 */,
  {-1, 0, 0x0027} /* 27 */,
  {-1, 0, 0x0028} /* 28 */,
  {-1, 0, 0x0029} /* 29 */,
  {-1, 0, 0x002A} /* 2A */,
  {-1, 0, 0x002B} /* 2B */,
  {-1, 0, 0x002C} /* 2C */,
  {-1, 0, 0x002D} /* 2D */,
  {-1, 0, 0x002E} /* 2E */,
  {-1, 0, 0x002F} /* 2F */,
  {-1, 0, 0x0030} /* 30 */,
  {-1, 0, 0x0031} /* 31 */,
  {-1, 0, 0x0032} /* 32 */,
  {-1, 0, 0x0033} /* 33 */,
  {-1, 0, 0x0034} /* 34 */,
  {-1, 0, 0x0035} /* 35 */,
  {-1, 0, 0x0036} /* 36 */,
  {-1, 0, 0x0037} /* 37 */,
  {-1, 0, 0x0038} /* 38 */,
  {-1, 0, 0x0039} /* 39 */,
  {-1, 0, 0x003A} /* 3A */,
  {-1, 0, 0x003B} /* 3B */,
  {-1, 0, 0x003C} /* 3C */,
  {-1, 0, 0x003D} /* 3D */,
  {-1, 0, 0x003E} /* 3E */,
  {-1, 0, 0x003F} /* 3F */,
  {-1, 0, 0x0040} /* 40 */,
  {-1, 0, 0x0041} /* 41 */,
  {-1, 0, 0x0042} /* 42 */,
  {-1, 0, 0x0043} /* 43 */,
  {-1, 0, 0x0044} /* 44 */,
  {-1, 0, 0x0045} /* 45 */,
  {-1, 0, 0x0046} /* 46 */,
  {-1, 0, 0x0047} /* 47 */,
  {-1, 0, 0x0048} /* 48 */,
  {-1, 0, 0x0049} /* 49 */,
  {-1, 0, 0x004A} /* 4A */,
  {-1, 0, 0x004B} /* 4B */,
  {-1, 0, 0x004C} /* 4C */,
  {-1, 0, 0x004D} /* 4D */,
  {-1, 0, 0x004E} /* 4E */,
  {-1, 0, 0x004F} /* 4F */,
  {-1, 0, 0x0050} /* 50 */,
  {-1, 0, 0x0051} /* 51 */,
  {-1, 0, 0x0052} /* 52 */,
  {-1, 0, 0x0053} /* 53 */,
  {-1, 0, 0x0054} /* 54 */,
  {-1, 0, 0x0055} /* 55 */,
  {-1, 0, 0x0056} /* 56 */,
  {-1, 0, 0x0057} /* 57 */,
  {-1, 0, 0x0058} /* 58 */,
  {-1, 0, 0x0059} /* 59 */,
  {-1, 0, 0x005A} /* 5A */,
  {-1, 0, 0x005B} /* 5B */,
  {-1, 0, 0x005C} /* 5C */,
  {-1, 0, 0x005D} /* 5D */,
  {-1, 0, 0x005E} /* 5E */,
  {-1, 0, 0x005F} /* 5F */,
  {-1, 0, 0x0060} /* 60 */,
  {-1, 0, 0x0061} /* 61 */,
  {-1, 0, 0x0062} /* 62 */,
  {-1, 0, 0x0063} /* 63 */,
  {-1, 0, 0x0064} /* 64 */,
  {-1, 0, 0x0065} /* 65 */,
  {-1, 0, 0x0066} /* 66 */,
  {-1, 0, 0x0067} /* 67 */,
  {-1, 0, 0x0068} /* 68 */,
  {-1, 0, 0x0069} /* 69 */,
  {-1, 0, 0x006A} /* 6A */,
  {-1, 0, 0x006B} /* 6B */,
  {-1, 0, 0x006C} /* 6C */,
  {-1, 0, 0x006D} /* 6D */,
  {-1, 0, 0x006E} /* 6E */,
  {-1, 0, 0x006F} /* 6F */,
  {-1, 0, 0x0070} /* 70 */,
  {-1, 0, 0x0071} /* 71 */,
  {-1, 0, 0x0072} /* 72 */,
  {-1, 0, 0x0073} /* 73 */,
  {-1, 0, 0x0074} /* 74 */,
  {-1, 0, 0x0075} /* 75 */,
  {-1, 0, 0x0076} /* 76 */,
  {-1, 0, 0x0077} /* 77 */,
  {-1, 0, 0x0078} /* 78 */,
  {-1, 0, 0x0079} /* 79 */,
  {-1, 0, 0x007A} /* 7A */,
  {-1, 0, 0x007B} /* 7B */,
  {-1, 0, 0x007C} /* 7C */,
  {-1, 0, 0x007D} /* 7D */,
  {-1, 0, 0x007E} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0098} /* 88 */,
  {-1, 0, 0x009C} /* 89 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x200D} /* 8D */,
  {-1, 0, 0x200C} /* 8E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0141} /* A1 */,
  {-1, 0, 0x00D8} /* A2 */,
  {-1, 0, 0x0110} /* A3 */,
  {-1, 0, 0x00DE} /* A4 */,
  {-1, 0, 0x00C6} /* A5 */,
  {-1, 0, 0x0152} /* A6 */,
  {-1, 0, 0x02B9} /* A7 */,
  {-1, 0, 0x00B7} /* A8 */,
  {-1, 0, 0x266D} /* A9 */,
  {-1, 0, 0x00AE} /* AA */,
  {-1, 0, 0x00B1} /* AB */,
  {-1, 0, 0x01A0} /* AC */,
  {-1, 0, 0x01AF} /* AD */,
  {-1, 0, 0x02BE} /* AE */,
  {-1, 0, 0},
  {-1, 0, 0x02BB} /* B0 */,
  {-1, 0, 0x0142} /* B1 */,
  {-1, 0, 0x00F8} /* B2 */,
  {-1, 0, 0x0111} /* B3 */,
  {-1, 0, 0x00FE} /* B4 */,
  {-1, 0, 0x00E6} /* B5 */,
  {-1, 0, 0x0153} /* B6 */,
  {-1, 0, 0x02BA} /* B7 */,
  {-1, 0, 0x0131} /* B8 */,
  {-1, 0, 0x00A3} /* B9 */,
  {-1, 0, 0x00F0} /* BA */,
  {-1, 0, 0},
  {-1, 0, 0x01A1} /* BC */,
  {-1, 0, 0x01B0} /* BD */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x00B0} /* C0 */,
  {-1, 0, 0x2113} /* C1 */,
  {-1, 0, 0x2117} /* C2 */,
  {-1, 0, 0x00A9} /* C3 */,
  {-1, 0, 0x266F} /* C4 */,
  {-1, 0, 0x00BF} /* C5 */,
  {-1, 0, 0x00A1} /* C6 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 1, 0x0309} /* E0 */,
  {-1, 1, 0x0300} /* E1 */,
  {-1, 1, 0x0301} /* E2 */,
  {-1, 1, 0x0302} /* E3 */,
  {-1, 1, 0x0303} /* E4 */,
  {-1, 1, 0x0304} /* E5 */,
  {-1, 1, 0x0306} /* E6 */,
  {-1, 1, 0x0307} /* E7 */,
  {-1, 1, 0x0308} /* E8 */,
  {-1, 1, 0x030C} /* E9 */,
  {-1, 1, 0x030A} /* EA */,
  {-1, 1, 0xFE20} /* EB */,
  {-1, 1, 0xFE21} /* EC */,
  {-1, 1, 0x0315} /* ED */,
  {-1, 1, 0x030B} /* EE */,
  {-1, 1, 0x0310} /* EF */,
  {-1, 1, 0x0327} /* F0 */,
  {-1, 1, 0x0328} /* F1 */,
  {-1, 1, 0x0323} /* F2 */,
  {-1, 1, 0x0324} /* F3 */,
  {-1, 1, 0x0325} /* F4 */,
  {-1, 1, 0x0333} /* F5 */,
  {-1, 1, 0x0332} /* F6 */,
  {-1, 1, 0x0326} /* F7 */,
  {-1, 1, 0x031C} /* F8 */,
  {-1, 1, 0x032E} /* F9 */,
  {-1, 1, 0xFE22} /* FA */,
  {-1, 1, 0xFE23} /* FB */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 1, 0x0313} /* FE */,
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_1page0 = {
  0, marc8_1page0_dir
};
struct yaz_iconv_trie *marc8_1ptrs [] = {
 &marc8_1page0,
0, };

unsigned long yaz_marc8_1_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_1ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 3 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_2page0_flat[] = {
  {"\x61", 0, 0x03B1},
  {"\x62", 0, 0x03B2},
  {"\x63", 0, 0x03B3},
  {"", 0}
};
struct yaz_iconv_trie marc8_2page0 = {
  marc8_2page0_flat, 0
};
struct yaz_iconv_trie *marc8_2ptrs [] = {
 &marc8_2page0,
0, };

unsigned long yaz_marc8_2_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_2ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_3page0_flat[] = {
  {"\x28", 0, 0x208D},
  {"\x29", 0, 0x208E},
  {"\x2B", 0, 0x208A},
  {"\x2D", 0, 0x208B},
  {"\x30", 0, 0x2080},
  {"\x31", 0, 0x2081},
  {"\x32", 0, 0x2082},
  {"\x33", 0, 0x2083},
  {"\x34", 0, 0x2084},
  {"\x35", 0, 0x2085},
  {"\x36", 0, 0x2086},
  {"\x37", 0, 0x2087},
  {"\x38", 0, 0x2088},
  {"\x39", 0, 0x2089},
  {"", 0}
};
struct yaz_iconv_trie marc8_3page0 = {
  marc8_3page0_flat, 0
};
struct yaz_iconv_trie *marc8_3ptrs [] = {
 &marc8_3page0,
0, };

unsigned long yaz_marc8_3_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_3ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_4page0_flat[] = {
  {"\x28", 0, 0x207D},
  {"\x29", 0, 0x207E},
  {"\x2B", 0, 0x207A},
  {"\x2D", 0, 0x207B},
  {"\x30", 0, 0x2070},
  {"\x31", 0, 0x00B9},
  {"\x32", 0, 0x00B2},
  {"\x33", 0, 0x00B3},
  {"\x34", 0, 0x2074},
  {"\x35", 0, 0x2075},
  {"\x36", 0, 0x2076},
  {"\x37", 0, 0x2077},
  {"\x38", 0, 0x2078},
  {"\x39", 0, 0x2079},
  {"", 0}
};
struct yaz_iconv_trie marc8_4page0 = {
  marc8_4page0_flat, 0
};
struct yaz_iconv_trie *marc8_4ptrs [] = {
 &marc8_4page0,
0, };

unsigned long yaz_marc8_4_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_4ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 78 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_5page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0021} /* 21 */,
  {-1, 0, 0x05F4} /* 22 */,
  {-1, 0, 0x0023} /* 23 */,
  {-1, 0, 0x0024} /* 24 */,
  {-1, 0, 0x0025} /* 25 */,
  {-1, 0, 0x0026} /* 26 */,
  {-1, 0, 0x05F3} /* 27 */,
  {-1, 0, 0x0028} /* 28 */,
  {-1, 0, 0x0029} /* 29 */,
  {-1, 0, 0x002A} /* 2A */,
  {-1, 0, 0x002B} /* 2B */,
  {-1, 0, 0x002C} /* 2C */,
  {-1, 0, 0x05BE} /* 2D */,
  {-1, 0, 0x002E} /* 2E */,
  {-1, 0, 0x002F} /* 2F */,
  {-1, 0, 0x0030} /* 30 */,
  {-1, 0, 0x0031} /* 31 */,
  {-1, 0, 0x0032} /* 32 */,
  {-1, 0, 0x0033} /* 33 */,
  {-1, 0, 0x0034} /* 34 */,
  {-1, 0, 0x0035} /* 35 */,
  {-1, 0, 0x0036} /* 36 */,
  {-1, 0, 0x0037} /* 37 */,
  {-1, 0, 0x0038} /* 38 */,
  {-1, 0, 0x0039} /* 39 */,
  {-1, 0, 0x003A} /* 3A */,
  {-1, 0, 0x003B} /* 3B */,
  {-1, 0, 0x003C} /* 3C */,
  {-1, 0, 0x003D} /* 3D */,
  {-1, 0, 0x003E} /* 3E */,
  {-1, 0, 0x003F} /* 3F */,
  {-1, 1, 0x05B7} /* 40 */,
  {-1, 1, 0x05B8} /* 41 */,
  {-1, 1, 0x05B6} /* 42 */,
  {-1, 1, 0x05B5} /* 43 */,
  {-1, 1, 0x05B4} /* 44 */,
  {-1, 1, 0x05B9} /* 45 */,
  {-1, 1, 0x05BB} /* 46 */,
  {-1, 1, 0x05B0} /* 47 */,
  {-1, 1, 0x05B2} /* 48 */,
  {-1, 1, 0x05B3} /* 49 */,
  {-1, 1, 0x05B1} /* 4A */,
  {-1, 1, 0x05BC} /* 4B */,
  {-1, 1, 0x05BF} /* 4C */,
  {-1, 1, 0x05C1} /* 4D */,
  {-1, 1, 0xFB1E} /* 4E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x005B} /* 5B */,
  {-1, 0, 0},
  {-1, 0, 0x005D} /* 5D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x05D0} /* 60 */,
  {-1, 0, 0x05D1} /* 61 */,
  {-1, 0, 0x05D2} /* 62 */,
  {-1, 0, 0x05D3} /* 63 */,
  {-1, 0, 0x05D4} /* 64 */,
  {-1, 0, 0x05D5} /* 65 */,
  {-1, 0, 0x05D6} /* 66 */,
  {-1, 0, 0x05D7} /* 67 */,
  {-1, 0, 0x05D8} /* 68 */,
  {-1, 0, 0x05D9} /* 69 */,
  {-1, 0, 0x05DA} /* 6A */,
  {-1, 0, 0x05DB} /* 6B */,
  {-1, 0, 0x05DC} /* 6C */,
  {-1, 0, 0x05DD} /* 6D */,
  {-1, 0, 0x05DE} /* 6E */,
  {-1, 0, 0x05DF} /* 6F */,
  {-1, 0, 0x05E0} /* 70 */,
  {-1, 0, 0x05E1} /* 71 */,
  {-1, 0, 0x05E2} /* 72 */,
  {-1, 0, 0x05E3} /* 73 */,
  {-1, 0, 0x05E4} /* 74 */,
  {-1, 0, 0x05E5} /* 75 */,
  {-1, 0, 0x05E6} /* 76 */,
  {-1, 0, 0x05E7} /* 77 */,
  {-1, 0, 0x05E8} /* 78 */,
  {-1, 0, 0x05E9} /* 79 */,
  {-1, 0, 0x05EA} /* 7A */,
  {-1, 0, 0x05F0} /* 7B */,
  {-1, 0, 0x05F1} /* 7C */,
  {-1, 0, 0x05F2} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_5page0 = {
  0, marc8_5page0_dir
};
struct yaz_iconv_trie *marc8_5ptrs [] = {
 &marc8_5page0,
0, };

unsigned long yaz_marc8_5_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_5ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 136 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_6page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0021} /* 21 */,
  {-1, 0, 0x0022} /* 22 */,
  {-1, 0, 0x0023} /* 23 */,
  {-1, 0, 0x0024} /* 24 */,
  {-1, 0, 0x0025} /* 25 */,
  {-1, 0, 0x0026} /* 26 */,
  {-1, 0, 0x0027} /* 27 */,
  {-1, 0, 0x0028} /* 28 */,
  {-1, 0, 0x0029} /* 29 */,
  {-1, 0, 0x002A} /* 2A */,
  {-1, 0, 0x002B} /* 2B */,
  {-1, 0, 0x002C} /* 2C */,
  {-1, 0, 0x002D} /* 2D */,
  {-1, 0, 0x002E} /* 2E */,
  {-1, 0, 0x002F} /* 2F */,
  {-1, 0, 0x0030} /* 30 */,
  {-1, 0, 0x0031} /* 31 */,
  {-1, 0, 0x0032} /* 32 */,
  {-1, 0, 0x0033} /* 33 */,
  {-1, 0, 0x0034} /* 34 */,
  {-1, 0, 0x0035} /* 35 */,
  {-1, 0, 0x0036} /* 36 */,
  {-1, 0, 0x0037} /* 37 */,
  {-1, 0, 0x0038} /* 38 */,
  {-1, 0, 0x0039} /* 39 */,
  {-1, 0, 0x003A} /* 3A */,
  {-1, 0, 0x003B} /* 3B */,
  {-1, 0, 0x003C} /* 3C */,
  {-1, 0, 0x003D} /* 3D */,
  {-1, 0, 0x003E} /* 3E */,
  {-1, 0, 0x003F} /* 3F */,
  {-1, 0, 0x044E} /* 40 */,
  {-1, 0, 0x0430} /* 41 */,
  {-1, 0, 0x0431} /* 42 */,
  {-1, 0, 0x0446} /* 43 */,
  {-1, 0, 0x0434} /* 44 */,
  {-1, 0, 0x0435} /* 45 */,
  {-1, 0, 0x0444} /* 46 */,
  {-1, 0, 0x0433} /* 47 */,
  {-1, 0, 0x0445} /* 48 */,
  {-1, 0, 0x0438} /* 49 */,
  {-1, 0, 0x0439} /* 4A */,
  {-1, 0, 0x043A} /* 4B */,
  {-1, 0, 0x043B} /* 4C */,
  {-1, 0, 0x043C} /* 4D */,
  {-1, 0, 0x043D} /* 4E */,
  {-1, 0, 0x043E} /* 4F */,
  {-1, 0, 0x043F} /* 50 */,
  {-1, 0, 0x044F} /* 51 */,
  {-1, 0, 0x0440} /* 52 */,
  {-1, 0, 0x0441} /* 53 */,
  {-1, 0, 0x0442} /* 54 */,
  {-1, 0, 0x0443} /* 55 */,
  {-1, 0, 0x0436} /* 56 */,
  {-1, 0, 0x0432} /* 57 */,
  {-1, 0, 0x044C} /* 58 */,
  {-1, 0, 0x044B} /* 59 */,
  {-1, 0, 0x0437} /* 5A */,
  {-1, 0, 0x0448} /* 5B */,
  {-1, 0, 0x044D} /* 5C */,
  {-1, 0, 0x0449} /* 5D */,
  {-1, 0, 0x0447} /* 5E */,
  {-1, 0, 0x044A} /* 5F */,
  {-1, 0, 0x042E} /* 60 */,
  {-1, 0, 0x0410} /* 61 */,
  {-1, 0, 0x0411} /* 62 */,
  {-1, 0, 0x0426} /* 63 */,
  {-1, 0, 0x0414} /* 64 */,
  {-1, 0, 0x0415} /* 65 */,
  {-1, 0, 0x0424} /* 66 */,
  {-1, 0, 0x0413} /* 67 */,
  {-1, 0, 0x0425} /* 68 */,
  {-1, 0, 0x0418} /* 69 */,
  {-1, 0, 0x0419} /* 6A */,
  {-1, 0, 0x041A} /* 6B */,
  {-1, 0, 0x041B} /* 6C */,
  {-1, 0, 0x041C} /* 6D */,
  {-1, 0, 0x041D} /* 6E */,
  {-1, 0, 0x041E} /* 6F */,
  {-1, 0, 0x041F} /* 70 */,
  {-1, 0, 0x042F} /* 71 */,
  {-1, 0, 0x0420} /* 72 */,
  {-1, 0, 0x0421} /* 73 */,
  {-1, 0, 0x0422} /* 74 */,
  {-1, 0, 0x0423} /* 75 */,
  {-1, 0, 0x0416} /* 76 */,
  {-1, 0, 0x0412} /* 77 */,
  {-1, 0, 0x042C} /* 78 */,
  {-1, 0, 0x042B} /* 79 */,
  {-1, 0, 0x0417} /* 7A */,
  {-1, 0, 0x0428} /* 7B */,
  {-1, 0, 0x042D} /* 7C */,
  {-1, 0, 0x0429} /* 7D */,
  {-1, 0, 0x0427} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0491} /* C0 */,
  {-1, 0, 0x0452} /* C1 */,
  {-1, 0, 0x0453} /* C2 */,
  {-1, 0, 0x0454} /* C3 */,
  {-1, 0, 0x0451} /* C4 */,
  {-1, 0, 0x0455} /* C5 */,
  {-1, 0, 0x0456} /* C6 */,
  {-1, 0, 0x0457} /* C7 */,
  {-1, 0, 0x0458} /* C8 */,
  {-1, 0, 0x0459} /* C9 */,
  {-1, 0, 0x045A} /* CA */,
  {-1, 0, 0x045B} /* CB */,
  {-1, 0, 0x045C} /* CC */,
  {-1, 0, 0x045E} /* CD */,
  {-1, 0, 0x045F} /* CE */,
  {-1, 0, 0},
  {-1, 0, 0x0463} /* D0 */,
  {-1, 0, 0x0473} /* D1 */,
  {-1, 0, 0x0475} /* D2 */,
  {-1, 0, 0x046B} /* D3 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x005B} /* DB */,
  {-1, 0, 0},
  {-1, 0, 0x005D} /* DD */,
  {-1, 0, 0},
  {-1, 0, 0x005F} /* DF */,
  {-1, 0, 0x0490} /* E0 */,
  {-1, 0, 0x0402} /* E1 */,
  {-1, 0, 0x0403} /* E2 */,
  {-1, 0, 0x0404} /* E3 */,
  {-1, 0, 0x0401} /* E4 */,
  {-1, 0, 0x0405} /* E5 */,
  {-1, 0, 0x0406} /* E6 */,
  {-1, 0, 0x0407} /* E7 */,
  {-1, 0, 0x0408} /* E8 */,
  {-1, 0, 0x0409} /* E9 */,
  {-1, 0, 0x040A} /* EA */,
  {-1, 0, 0x040B} /* EB */,
  {-1, 0, 0x040C} /* EC */,
  {-1, 0, 0x040E} /* ED */,
  {-1, 0, 0x040F} /* EE */,
  {-1, 0, 0x042A} /* EF */,
  {-1, 0, 0x0462} /* F0 */,
  {-1, 0, 0x0472} /* F1 */,
  {-1, 0, 0x0474} /* F2 */,
  {-1, 0, 0x046A} /* F3 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_6page0 = {
  0, marc8_6page0_dir
};
struct yaz_iconv_trie *marc8_6ptrs [] = {
 &marc8_6page0,
0, };

unsigned long yaz_marc8_6_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_6ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 173 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_7page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0021} /* 21 */,
  {-1, 0, 0x0022} /* 22 */,
  {-1, 0, 0x0023} /* 23 */,
  {-1, 0, 0x0024} /* 24 */,
  {-1, 0, 0x066A} /* 25 */,
  {-1, 0, 0x0026} /* 26 */,
  {-1, 0, 0x0027} /* 27 */,
  {-1, 0, 0x0028} /* 28 */,
  {-1, 0, 0x0029} /* 29 */,
  {-1, 0, 0x066D} /* 2A */,
  {-1, 0, 0x002B} /* 2B */,
  {-1, 0, 0x060C} /* 2C */,
  {-1, 0, 0x002D} /* 2D */,
  {-1, 0, 0x002E} /* 2E */,
  {-1, 0, 0x002F} /* 2F */,
  {-1, 0, 0x0660} /* 30 */,
  {-1, 0, 0x0661} /* 31 */,
  {-1, 0, 0x0662} /* 32 */,
  {-1, 0, 0x0663} /* 33 */,
  {-1, 0, 0x0664} /* 34 */,
  {-1, 0, 0x0665} /* 35 */,
  {-1, 0, 0x0666} /* 36 */,
  {-1, 0, 0x0667} /* 37 */,
  {-1, 0, 0x0668} /* 38 */,
  {-1, 0, 0x0669} /* 39 */,
  {-1, 0, 0x003A} /* 3A */,
  {-1, 0, 0x061B} /* 3B */,
  {-1, 0, 0x003C} /* 3C */,
  {-1, 0, 0x003D} /* 3D */,
  {-1, 0, 0x003E} /* 3E */,
  {-1, 0, 0x061F} /* 3F */,
  {-1, 0, 0},
  {-1, 0, 0x0621} /* 41 */,
  {-1, 0, 0x0622} /* 42 */,
  {-1, 0, 0x0623} /* 43 */,
  {-1, 0, 0x0624} /* 44 */,
  {-1, 0, 0x0625} /* 45 */,
  {-1, 0, 0x0626} /* 46 */,
  {-1, 0, 0x0627} /* 47 */,
  {-1, 0, 0x0628} /* 48 */,
  {-1, 0, 0x0629} /* 49 */,
  {-1, 0, 0x062A} /* 4A */,
  {-1, 0, 0x062B} /* 4B */,
  {-1, 0, 0x062C} /* 4C */,
  {-1, 0, 0x062D} /* 4D */,
  {-1, 0, 0x062E} /* 4E */,
  {-1, 0, 0x062F} /* 4F */,
  {-1, 0, 0x0630} /* 50 */,
  {-1, 0, 0x0631} /* 51 */,
  {-1, 0, 0x0632} /* 52 */,
  {-1, 0, 0x0633} /* 53 */,
  {-1, 0, 0x0634} /* 54 */,
  {-1, 0, 0x0635} /* 55 */,
  {-1, 0, 0x0636} /* 56 */,
  {-1, 0, 0x0637} /* 57 */,
  {-1, 0, 0x0638} /* 58 */,
  {-1, 0, 0x0639} /* 59 */,
  {-1, 0, 0x063A} /* 5A */,
  {-1, 0, 0x005B} /* 5B */,
  {-1, 0, 0},
  {-1, 0, 0x005D} /* 5D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0640} /* 60 */,
  {-1, 0, 0x0641} /* 61 */,
  {-1, 0, 0x0642} /* 62 */,
  {-1, 0, 0x0643} /* 63 */,
  {-1, 0, 0x0644} /* 64 */,
  {-1, 0, 0x0645} /* 65 */,
  {-1, 0, 0x0646} /* 66 */,
  {-1, 0, 0x0647} /* 67 */,
  {-1, 0, 0x0648} /* 68 */,
  {-1, 0, 0x0649} /* 69 */,
  {-1, 0, 0x064A} /* 6A */,
  {-1, 1, 0x064B} /* 6B */,
  {-1, 1, 0x064C} /* 6C */,
  {-1, 1, 0x064D} /* 6D */,
  {-1, 1, 0x064E} /* 6E */,
  {-1, 1, 0x064F} /* 6F */,
  {-1, 1, 0x0650} /* 70 */,
  {-1, 1, 0x0651} /* 71 */,
  {-1, 1, 0x0652} /* 72 */,
  {-1, 0, 0x0671} /* 73 */,
  {-1, 0, 0x0670} /* 74 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x066C} /* 78 */,
  {-1, 0, 0x201D} /* 79 */,
  {-1, 0, 0x201C} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x06FD} /* A1 */,
  {-1, 0, 0x0672} /* A2 */,
  {-1, 0, 0x0673} /* A3 */,
  {-1, 0, 0x0679} /* A4 */,
  {-1, 0, 0x067A} /* A5 */,
  {-1, 0, 0x067B} /* A6 */,
  {-1, 0, 0x067C} /* A7 */,
  {-1, 0, 0x067D} /* A8 */,
  {-1, 0, 0x067E} /* A9 */,
  {-1, 0, 0x067F} /* AA */,
  {-1, 0, 0x0680} /* AB */,
  {-1, 0, 0x0681} /* AC */,
  {-1, 0, 0x0682} /* AD */,
  {-1, 0, 0x0683} /* AE */,
  {-1, 0, 0x0684} /* AF */,
  {-1, 0, 0x0685} /* B0 */,
  {-1, 0, 0x0686} /* B1 */,
  {-1, 0, 0x06BF} /* B2 */,
  {-1, 0, 0x0687} /* B3 */,
  {-1, 0, 0x0688} /* B4 */,
  {-1, 0, 0x0689} /* B5 */,
  {-1, 0, 0x068A} /* B6 */,
  {-1, 0, 0x068B} /* B7 */,
  {-1, 0, 0x068C} /* B8 */,
  {-1, 0, 0x068D} /* B9 */,
  {-1, 0, 0x068E} /* BA */,
  {-1, 0, 0x068F} /* BB */,
  {-1, 0, 0x0690} /* BC */,
  {-1, 0, 0x0691} /* BD */,
  {-1, 0, 0x0692} /* BE */,
  {-1, 0, 0x0693} /* BF */,
  {-1, 0, 0x0694} /* C0 */,
  {-1, 0, 0x0695} /* C1 */,
  {-1, 0, 0x0696} /* C2 */,
  {-1, 0, 0x0697} /* C3 */,
  {-1, 0, 0x0698} /* C4 */,
  {-1, 0, 0x0699} /* C5 */,
  {-1, 0, 0x069A} /* C6 */,
  {-1, 0, 0x069B} /* C7 */,
  {-1, 0, 0x069C} /* C8 */,
  {-1, 0, 0x06FA} /* C9 */,
  {-1, 0, 0x069D} /* CA */,
  {-1, 0, 0x069E} /* CB */,
  {-1, 0, 0x06FB} /* CC */,
  {-1, 0, 0x069F} /* CD */,
  {-1, 0, 0x06A0} /* CE */,
  {-1, 0, 0x06FC} /* CF */,
  {-1, 0, 0x06A1} /* D0 */,
  {-1, 0, 0x06A2} /* D1 */,
  {-1, 0, 0x06A3} /* D2 */,
  {-1, 0, 0x06A4} /* D3 */,
  {-1, 0, 0x06A5} /* D4 */,
  {-1, 0, 0x06A6} /* D5 */,
  {-1, 0, 0x06A7} /* D6 */,
  {-1, 0, 0x06A8} /* D7 */,
  {-1, 0, 0x06A9} /* D8 */,
  {-1, 0, 0x06AA} /* D9 */,
  {-1, 0, 0x06AB} /* DA */,
  {-1, 0, 0x06AC} /* DB */,
  {-1, 0, 0x06AD} /* DC */,
  {-1, 0, 0x06AE} /* DD */,
  {-1, 0, 0x06AF} /* DE */,
  {-1, 0, 0x06B0} /* DF */,
  {-1, 0, 0x06B1} /* E0 */,
  {-1, 0, 0x06B2} /* E1 */,
  {-1, 0, 0x06B3} /* E2 */,
  {-1, 0, 0x06B4} /* E3 */,
  {-1, 0, 0x06B5} /* E4 */,
  {-1, 0, 0x06B6} /* E5 */,
  {-1, 0, 0x06B7} /* E6 */,
  {-1, 0, 0x06B8} /* E7 */,
  {-1, 0, 0x06BA} /* E8 */,
  {-1, 0, 0x06BB} /* E9 */,
  {-1, 0, 0x06BC} /* EA */,
  {-1, 0, 0x06BD} /* EB */,
  {-1, 0, 0x06B9} /* EC */,
  {-1, 0, 0x06BE} /* ED */,
  {-1, 0, 0x06C0} /* EE */,
  {-1, 0, 0x06C4} /* EF */,
  {-1, 0, 0x06C5} /* F0 */,
  {-1, 0, 0x06C6} /* F1 */,
  {-1, 0, 0x06CA} /* F2 */,
  {-1, 0, 0x06CB} /* F3 */,
  {-1, 0, 0x06CD} /* F4 */,
  {-1, 0, 0x06CE} /* F5 */,
  {-1, 0, 0x06D0} /* F6 */,
  {-1, 0, 0x06D2} /* F7 */,
  {-1, 0, 0x06D3} /* F8 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 1, 0x0306} /* FD */,
  {-1, 1, 0x030C} /* FE */,
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_7page0 = {
  0, marc8_7page0_dir
};
struct yaz_iconv_trie *marc8_7ptrs [] = {
 &marc8_7page0,
0, };

unsigned long yaz_marc8_7_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_7ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 73 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_8page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 1, 0x0300} /* 21 */,
  {-1, 1, 0x0301} /* 22 */,
  {-1, 1, 0x0308} /* 23 */,
  {-1, 1, 0x0342} /* 24 */,
  {-1, 1, 0x0313} /* 25 */,
  {-1, 1, 0x0314} /* 26 */,
  {-1, 1, 0x0345} /* 27 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x00AB} /* 30 */,
  {-1, 0, 0x00BB} /* 31 */,
  {-1, 0, 0x201C} /* 32 */,
  {-1, 0, 0x201D} /* 33 */,
  {-1, 0, 0x0374} /* 34 */,
  {-1, 0, 0x0375} /* 35 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x0387} /* 3B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x037E} /* 3F */,
  {-1, 0, 0},
  {-1, 0, 0x0391} /* 41 */,
  {-1, 0, 0x0392} /* 42 */,
  {-1, 0, 0},
  {-1, 0, 0x0393} /* 44 */,
  {-1, 0, 0x0394} /* 45 */,
  {-1, 0, 0x0395} /* 46 */,
  {-1, 0, 0x03DA} /* 47 */,
  {-1, 0, 0x03DC} /* 48 */,
  {-1, 0, 0x0396} /* 49 */,
  {-1, 0, 0x0397} /* 4A */,
  {-1, 0, 0x0398} /* 4B */,
  {-1, 0, 0x0399} /* 4C */,
  {-1, 0, 0x039A} /* 4D */,
  {-1, 0, 0x039B} /* 4E */,
  {-1, 0, 0x039C} /* 4F */,
  {-1, 0, 0x039D} /* 50 */,
  {-1, 0, 0x039E} /* 51 */,
  {-1, 0, 0x039F} /* 52 */,
  {-1, 0, 0x03A0} /* 53 */,
  {-1, 0, 0x03DE} /* 54 */,
  {-1, 0, 0x03A1} /* 55 */,
  {-1, 0, 0x03A3} /* 56 */,
  {-1, 0, 0},
  {-1, 0, 0x03A4} /* 58 */,
  {-1, 0, 0x03A5} /* 59 */,
  {-1, 0, 0x03A6} /* 5A */,
  {-1, 0, 0x03A7} /* 5B */,
  {-1, 0, 0x03A8} /* 5C */,
  {-1, 0, 0x03A9} /* 5D */,
  {-1, 0, 0x03E0} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x03B1} /* 61 */,
  {-1, 0, 0x03B2} /* 62 */,
  {-1, 0, 0x03D0} /* 63 */,
  {-1, 0, 0x03B3} /* 64 */,
  {-1, 0, 0x03B4} /* 65 */,
  {-1, 0, 0x03B5} /* 66 */,
  {-1, 0, 0x03DB} /* 67 */,
  {-1, 0, 0x03DD} /* 68 */,
  {-1, 0, 0x03B6} /* 69 */,
  {-1, 0, 0x03B7} /* 6A */,
  {-1, 0, 0x03B8} /* 6B */,
  {-1, 0, 0x03B9} /* 6C */,
  {-1, 0, 0x03BA} /* 6D */,
  {-1, 0, 0x03BB} /* 6E */,
  {-1, 0, 0x03BC} /* 6F */,
  {-1, 0, 0x03BD} /* 70 */,
  {-1, 0, 0x03BE} /* 71 */,
  {-1, 0, 0x03BF} /* 72 */,
  {-1, 0, 0x03C0} /* 73 */,
  {-1, 0, 0x03DF} /* 74 */,
  {-1, 0, 0x03C1} /* 75 */,
  {-1, 0, 0x03C3} /* 76 */,
  {-1, 0, 0x03C2} /* 77 */,
  {-1, 0, 0x03C4} /* 78 */,
  {-1, 0, 0x03C5} /* 79 */,
  {-1, 0, 0x03C6} /* 7A */,
  {-1, 0, 0x03C7} /* 7B */,
  {-1, 0, 0x03C8} /* 7C */,
  {-1, 0, 0x03C9} /* 7D */,
  {-1, 0, 0x03E1} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_8page0 = {
  0, marc8_8page0_dir
};
struct yaz_iconv_trie *marc8_8ptrs [] = {
 &marc8_8page0,
0, };

unsigned long yaz_marc8_8_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_8ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
/* TRIE: size 15739 */
/* PAGE 827 */
struct yaz_iconv_trie_flat marc8_9page827_flat[] = {
  {"\x25", 0, 0x300C},
  {"\x26", 0, 0x300D},
  {"\x31", 0, 0xFF3B},
  {"\x32", 0, 0xFF3D},
  {"\x33", 0, 0x3002},
  {"\x34", 0, 0xFF0E},
  {"\x35", 0, 0x3001},
  {"\x38", 0, 0xFF0C},
  {"\x39", 0, 0xFF1B},
  {"\x3A", 0, 0xFF1A},
  {"\x3B", 0, 0xFF1F},
  {"\x3D", 0, 0xFF01},
  {"\x59", 0, 0xFF0F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page827 = {
  marc8_9page827_flat, 0
};
/* PAGE 826 */
struct yaz_iconv_trie_flat marc8_9page826_flat[] = {
  {"\x46", 0, 0x3013},
  {"\x21", 0, 0xE8D0},
  {"\x22", 0, 0xE8D1},
  {"\x23", 0, 0xE8D2},
  {"\x24", 0, 0xE8D3},
  {"\x25", 0, 0xE8D4},
  {"\x26", 0, 0xE8D5},
  {"\x28", 0, 0xE8D6},
  {"\x29", 0, 0xE8D7},
  {"\x2A", 0, 0xE8D8},
  {"\x2B", 0, 0xE8D9},
  {"\x2C", 0, 0xE8DA},
  {"\x2D", 0, 0xE8DB},
  {"\x2E", 0, 0xE8DC},
  {"\x2F", 0, 0xE8DD},
  {"\x30", 0, 0xE8DE},
  {"\x32", 0, 0xE8DF},
  {"\x33", 0, 0xE8E0},
  {"\x34", 0, 0xE8E1},
  {"\x35", 0, 0xE8E2},
  {"\x36", 0, 0xE8E3},
  {"\x37", 0, 0xE8E4},
  {"\x38", 0, 0xE8E5},
  {"\x39", 0, 0xE8E6},
  {"\x3A", 0, 0xE8E7},
  {"\x3B", 0, 0xE8E8},
  {"\x3C", 0, 0xE8E9},
  {"\x3D", 0, 0xE8EA},
  {"\x3E", 0, 0xE8EB},
  {"\x3F", 0, 0xE8EC},
  {"\x40", 0, 0xE8ED},
  {"\x41", 0, 0xE8EE},
  {"\x42", 0, 0xE8EF},
  {"\x43", 0, 0xE8F0},
  {"\x44", 0, 0xE8F1},
  {"\x45", 0, 0xE8F2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page826 = {
  marc8_9page826_flat, 0
};
/* PAGE 825 */
struct yaz_iconv_trie_flat marc8_9page825_flat[] = {
  {"\x20", 0, 0x3000},
  {"\x21", 0, 0x3000},
  {"\x28", 0, 0xFF08},
  {"\x29", 0, 0xFF09},
  {"\x2D", 0, 0xFF0D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page825 = {
  marc8_9page825_flat, 0
};
/* PAGE 824 */
struct yaz_iconv_trie_flat marc8_9page824_flat[] = {
  {"\x21", 0, 0xAD35},
  {"\x22", 0, 0xAD7B},
  {"\x23", 0, 0xE8CA},
  {"\x24", 0, 0xAD89},
  {"\x25", 0, 0xAD9D},
  {"\x26", 0, 0xADB9},
  {"\x27", 0, 0xADD5},
  {"\x28", 0, 0xAE07},
  {"\x29", 0, 0xAE0E},
  {"\x2A", 0, 0xAE0F},
  {"\x2B", 0, 0xAE11},
  {"\x2C", 0, 0xAE14},
  {"\x2D", 0, 0xAE5F},
  {"\x2E", 0, 0xAEED},
  {"\x2F", 0, 0xAF09},
  {"\x30", 0, 0xAF50},
  {"\x31", 0, 0xAFBF},
  {"\x32", 0, 0xB060},
  {"\x33", 0, 0xB9C4},
  {"\x34", 0, 0xC54D},
  {"\x35", 0, 0xC54F},
  {"\x36", 0, 0xC552},
  {"\x37", 0, 0xC5AB},
  {"\x38", 0, 0xC5B1},
  {"\x39", 0, 0xC61C},
  {"\x3A", 0, 0xC61D},
  {"\x3B", 0, 0xC6FD},
  {"\x3C", 0, 0xE8CB},
  {"\x3D", 0, 0xC733},
  {"\x3E", 0, 0xCB4C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page824 = {
  marc8_9page824_flat, 0
};
/* PAGE 823 */
struct yaz_iconv_trie_flat marc8_9page823_flat[] = {
  {"\x21", 0, 0x3181},
  {"\x22", 0, 0x3186},
  {"\x23", 0, 0x317F},
  {"\x24", 0, 0xE8B0},
  {"\x25", 0, 0xE8B1},
  {"\x40", 0, 0xE8B2},
  {"\x41", 0, 0xE8B3},
  {"\x42", 0, 0xE8B4},
  {"\x43", 0, 0xE8B5},
  {"\x44", 0, 0xE8B6},
  {"\x45", 0, 0xE8B7},
  {"\x46", 0, 0xE8B8},
  {"\x47", 0, 0xE8B9},
  {"\x48", 0, 0xE8BA},
  {"\x49", 0, 0xE8BB},
  {"\x4A", 0, 0xE8BC},
  {"\x4B", 0, 0xE8BD},
  {"\x4C", 0, 0xE8BE},
  {"\x4D", 0, 0xE8BF},
  {"\x4E", 0, 0xE8C0},
  {"\x4F", 0, 0xE8C1},
  {"\x50", 0, 0xE8C2},
  {"\x51", 0, 0xE8C3},
  {"\x52", 0, 0xE8C4},
  {"\x53", 0, 0xE8C5},
  {"\x54", 0, 0xE8C6},
  {"\x55", 0, 0xE8C7},
  {"\x56", 0, 0xE8C8},
  {"\x57", 0, 0xE8C9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page823 = {
  marc8_9page823_flat, 0
};
/* PAGE 822 */
struct yaz_iconv_trie_flat marc8_9page822_flat[] = {
  {"\x21", 0, 0xD79D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page822 = {
  marc8_9page822_flat, 0
};
/* PAGE 821 */
struct yaz_iconv_trie_dir marc8_9page821_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD5D9} /* 21 */,
  {-1, 0, 0xD5DB} /* 22 */,
  {-1, 0, 0xD5DD} /* 23 */,
  {-1, 0, 0xD5E4} /* 24 */,
  {-1, 0, 0xD5E5} /* 25 */,
  {-1, 0, 0xD5E8} /* 26 */,
  {-1, 0, 0xD5EC} /* 27 */,
  {-1, 0, 0xD5F4} /* 28 */,
  {-1, 0, 0xD5F5} /* 29 */,
  {-1, 0, 0xD5F7} /* 2A */,
  {-1, 0, 0xD5F9} /* 2B */,
  {-1, 0, 0xD600} /* 2C */,
  {-1, 0, 0xD601} /* 2D */,
  {-1, 0, 0xD604} /* 2E */,
  {-1, 0, 0xD608} /* 2F */,
  {-1, 0, 0xD610} /* 30 */,
  {-1, 0, 0xD611} /* 31 */,
  {-1, 0, 0xD613} /* 32 */,
  {-1, 0, 0xD614} /* 33 */,
  {-1, 0, 0xD615} /* 34 */,
  {-1, 0, 0xD61C} /* 35 */,
  {-1, 0, 0xD638} /* 36 */,
  {-1, 0, 0xD639} /* 37 */,
  {-1, 0, 0xD63C} /* 38 */,
  {-1, 0, 0xD640} /* 39 */,
  {-1, 0, 0xD648} /* 3A */,
  {-1, 0, 0xD649} /* 3B */,
  {-1, 0, 0xD64B} /* 3C */,
  {-1, 0, 0xD64D} /* 3D */,
  {-1, 0, 0},
  {-1, 0, 0xD654} /* 3F */,
  {-1, 0, 0xD655} /* 40 */,
  {-1, 0, 0xD658} /* 41 */,
  {-1, 0, 0xD65C} /* 42 */,
  {-1, 0, 0},
  {-1, 0, 0xD667} /* 44 */,
  {-1, 0, 0xD669} /* 45 */,
  {-1, 0, 0xD670} /* 46 */,
  {-1, 0, 0xD671} /* 47 */,
  {-1, 0, 0xD683} /* 48 */,
  {-1, 0, 0},
  {-1, 0, 0xD68C} /* 4A */,
  {-1, 0, 0xD68D} /* 4B */,
  {-1, 0, 0xD69F} /* 4C */,
  {-1, 0, 0xD6A1} /* 4D */,
  {-1, 0, 0xD6A8} /* 4E */,
  {-1, 0, 0xD6C4} /* 4F */,
  {-1, 0, 0xD6C5} /* 50 */,
  {-1, 0, 0xD6C8} /* 51 */,
  {-1, 0, 0xD6CC} /* 52 */,
  {-1, 0, 0xD6D1} /* 53 */,
  {-1, 0, 0xD6D4} /* 54 */,
  {-1, 0, 0xD6D7} /* 55 */,
  {-1, 0, 0xD6E0} /* 56 */,
  {-1, 0, 0xD6E4} /* 57 */,
  {-1, 0, 0xD6E8} /* 58 */,
  {-1, 0, 0xD6F0} /* 59 */,
  {-1, 0, 0xD6FC} /* 5A */,
  {-1, 0, 0},
  {-1, 0, 0xD700} /* 5C */,
  {-1, 0, 0xD711} /* 5D */,
  {-1, 0, 0xD718} /* 5E */,
  {-1, 0, 0xD719} /* 5F */,
  {-1, 0, 0xD71C} /* 60 */,
  {-1, 0, 0xD720} /* 61 */,
  {-1, 0, 0xD728} /* 62 */,
  {-1, 0, 0xD729} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0xD72D} /* 65 */,
  {-1, 0, 0xD734} /* 66 */,
  {-1, 0, 0xD73C} /* 67 */,
  {-1, 0, 0xD744} /* 68 */,
  {-1, 0, 0xD749} /* 69 */,
  {-1, 0, 0xD750} /* 6A */,
  {-1, 0, 0xD751} /* 6B */,
  {-1, 0, 0xD754} /* 6C */,
  {-1, 0, 0xD757} /* 6D */,
  {-1, 0, 0xD758} /* 6E */,
  {-1, 0, 0xD759} /* 6F */,
  {-1, 0, 0xD760} /* 70 */,
  {-1, 0, 0xD761} /* 71 */,
  {-1, 0, 0xD763} /* 72 */,
  {-1, 0, 0xD765} /* 73 */,
  {-1, 0, 0xD769} /* 74 */,
  {-1, 0, 0xD76C} /* 75 */,
  {-1, 0, 0xD770} /* 76 */,
  {-1, 0, 0xD774} /* 77 */,
  {-1, 0, 0xD788} /* 78 */,
  {-1, 0, 0xD789} /* 79 */,
  {-1, 0, 0xD78C} /* 7A */,
  {-1, 0, 0xD790} /* 7B */,
  {-1, 0, 0xD798} /* 7C */,
  {-1, 0, 0xD799} /* 7D */,
  {-1, 0, 0xD79B} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page821 = {
  0, marc8_9page821_dir
};
/* PAGE 820 */
struct yaz_iconv_trie_dir marc8_9page820_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD33D} /* 21 */,
  {-1, 0, 0},
  {-1, 0, 0xD37C} /* 23 */,
  {-1, 0, 0xD37D} /* 24 */,
  {-1, 0, 0xD380} /* 25 */,
  {-1, 0, 0xD384} /* 26 */,
  {-1, 0, 0xD38C} /* 27 */,
  {-1, 0, 0xD38D} /* 28 */,
  {-1, 0, 0xD38F} /* 29 */,
  {-1, 0, 0xD390} /* 2A */,
  {-1, 0, 0xD391} /* 2B */,
  {-1, 0, 0xD398} /* 2C */,
  {-1, 0, 0xD399} /* 2D */,
  {-1, 0, 0xD39C} /* 2E */,
  {-1, 0, 0xD3A0} /* 2F */,
  {-1, 0, 0xD3A8} /* 30 */,
  {-1, 0, 0xD3A9} /* 31 */,
  {-1, 0, 0xD3AB} /* 32 */,
  {-1, 0, 0xD3AD} /* 33 */,
  {-1, 0, 0xD3B4} /* 34 */,
  {-1, 0, 0xD3B5} /* 35 */,
  {-1, 0, 0xD3B8} /* 36 */,
  {-1, 0, 0xD3BC} /* 37 */,
  {-1, 0, 0xD3C4} /* 38 */,
  {-1, 0, 0xD3C5} /* 39 */,
  {-1, 0, 0xD3C8} /* 3A */,
  {-1, 0, 0xD3C9} /* 3B */,
  {-1, 0, 0xD3D0} /* 3C */,
  {-1, 0, 0xD3EC} /* 3D */,
  {-1, 0, 0xD3ED} /* 3E */,
  {-1, 0, 0xD3F0} /* 3F */,
  {-1, 0, 0xD3F4} /* 40 */,
  {-1, 0, 0xD3FC} /* 41 */,
  {-1, 0, 0xD3FD} /* 42 */,
  {-1, 0, 0xD3FF} /* 43 */,
  {-1, 0, 0xD401} /* 44 */,
  {-1, 0, 0xD440} /* 45 */,
  {-1, 0, 0xD444} /* 46 */,
  {-1, 0, 0xD45C} /* 47 */,
  {-1, 0, 0xD46F} /* 48 */,
  {-1, 0, 0xD478} /* 49 */,
  {-1, 0, 0xD479} /* 4A */,
  {-1, 0, 0xD47C} /* 4B */,
  {-1, 0, 0xD480} /* 4C */,
  {-1, 0, 0xD488} /* 4D */,
  {-1, 0, 0xD489} /* 4E */,
  {-1, 0, 0xD48B} /* 4F */,
  {-1, 0, 0xD48D} /* 50 */,
  {-1, 0, 0xD4CC} /* 51 */,
  {-1, 0, 0xD4E8} /* 52 */,
  {-1, 0, 0xD504} /* 53 */,
  {-1, 0, 0},
  {-1, 0, 0xD508} /* 55 */,
  {-1, 0, 0xD50C} /* 56 */,
  {-1, 0, 0xD514} /* 57 */,
  {-1, 0, 0xD515} /* 58 */,
  {-1, 0, 0xD53C} /* 59 */,
  {-1, 0, 0xD53D} /* 5A */,
  {-1, 0, 0xD540} /* 5B */,
  {-1, 0, 0xD544} /* 5C */,
  {-1, 0, 0xD54C} /* 5D */,
  {-1, 0, 0xD54D} /* 5E */,
  {-1, 0, 0xD54F} /* 5F */,
  {-1, 0, 0xD551} /* 60 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD558} /* 63 */,
  {-1, 0, 0xD559} /* 64 */,
  {-1, 0, 0xD55C} /* 65 */,
  {-1, 0, 0xD560} /* 66 */,
  {-1, 0, 0xD565} /* 67 */,
  {-1, 0, 0xD568} /* 68 */,
  {-1, 0, 0xD569} /* 69 */,
  {-1, 0, 0xD56B} /* 6A */,
  {-1, 0, 0xD56C} /* 6B */,
  {-1, 0, 0xD56D} /* 6C */,
  {-1, 0, 0xD571} /* 6D */,
  {-1, 0, 0xD574} /* 6E */,
  {-1, 0, 0xD575} /* 6F */,
  {-1, 0, 0xD578} /* 70 */,
  {-1, 0, 0xD57C} /* 71 */,
  {-1, 0, 0xD584} /* 72 */,
  {-1, 0, 0xD585} /* 73 */,
  {-1, 0, 0xD587} /* 74 */,
  {-1, 0, 0xD588} /* 75 */,
  {-1, 0, 0xD589} /* 76 */,
  {-1, 0, 0xD590} /* 77 */,
  {-1, 0, 0xD5A5} /* 78 */,
  {-1, 0, 0xD5C8} /* 79 */,
  {-1, 0, 0xD5C9} /* 7A */,
  {-1, 0, 0xD5CC} /* 7B */,
  {-1, 0, 0xD5D0} /* 7C */,
  {-1, 0, 0xD5D2} /* 7D */,
  {-1, 0, 0xD5D8} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page820 = {
  0, marc8_9page820_dir
};
/* PAGE 819 */
struct yaz_iconv_trie_dir marc8_9page819_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD0ED} /* 21 */,
  {-1, 0, 0xD0EF} /* 22 */,
  {-1, 0, 0xD0F0} /* 23 */,
  {-1, 0, 0xD0F1} /* 24 */,
  {-1, 0, 0xD130} /* 25 */,
  {-1, 0, 0xD131} /* 26 */,
  {-1, 0, 0xD134} /* 27 */,
  {-1, 0, 0xD138} /* 28 */,
  {-1, 0, 0xD140} /* 29 */,
  {-1, 0, 0xD141} /* 2A */,
  {-1, 0, 0xD143} /* 2B */,
  {-1, 0, 0xD144} /* 2C */,
  {-1, 0, 0xD145} /* 2D */,
  {-1, 0, 0xD14C} /* 2E */,
  {-1, 0, 0xD14D} /* 2F */,
  {-1, 0, 0xD150} /* 30 */,
  {-1, 0, 0xD154} /* 31 */,
  {-1, 0, 0xD15C} /* 32 */,
  {-1, 0, 0xD15D} /* 33 */,
  {-1, 0, 0xD15F} /* 34 */,
  {-1, 0, 0xD160} /* 35 */,
  {-1, 0, 0xD161} /* 36 */,
  {-1, 0, 0xD168} /* 37 */,
  {-1, 0, 0xD1A0} /* 38 */,
  {-1, 0, 0xD1A1} /* 39 */,
  {-1, 0, 0xD1A4} /* 3A */,
  {-1, 0, 0xD1A8} /* 3B */,
  {-1, 0, 0xD1B0} /* 3C */,
  {-1, 0, 0xD1B1} /* 3D */,
  {-1, 0, 0xD1B3} /* 3E */,
  {-1, 0, 0xD1B5} /* 3F */,
  {-1, 0, 0xD1D8} /* 40 */,
  {-1, 0, 0xD1F4} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0xD22C} /* 43 */,
  {-1, 0, 0xD22D} /* 44 */,
  {-1, 0, 0xD230} /* 45 */,
  {-1, 0, 0xD234} /* 46 */,
  {-1, 0, 0xD23C} /* 47 */,
  {-1, 0, 0xD23D} /* 48 */,
  {-1, 0, 0xD23F} /* 49 */,
  {-1, 0, 0xD241} /* 4A */,
  {-1, 0, 0xD264} /* 4B */,
  {-1, 0, 0xD277} /* 4C */,
  {-1, 0, 0xD280} /* 4D */,
  {-1, 0, 0xD284} /* 4E */,
  {-1, 0, 0xD288} /* 4F */,
  {-1, 0, 0xD290} /* 50 */,
  {-1, 0, 0xD291} /* 51 */,
  {-1, 0, 0xD293} /* 52 */,
  {-1, 0, 0xD295} /* 53 */,
  {-1, 0, 0xD29C} /* 54 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD2AC} /* 57 */,
  {-1, 0, 0},
  {-1, 0, 0xD2B8} /* 59 */,
  {-1, 0, 0xD2B9} /* 5A */,
  {-1, 0, 0xD2BC} /* 5B */,
  {-1, 0, 0xD2BF} /* 5C */,
  {-1, 0, 0xD2C0} /* 5D */,
  {-1, 0, 0xD2C8} /* 5E */,
  {-1, 0, 0xD2C9} /* 5F */,
  {-1, 0, 0xD2CB} /* 60 */,
  {-1, 0, 0xD2D4} /* 61 */,
  {-1, 0, 0xD1F8} /* 62 */,
  {-1, 0, 0xD2F0} /* 63 */,
  {-1, 0, 0xD2F1} /* 64 */,
  {-1, 0, 0xD2F4} /* 65 */,
  {-1, 0, 0xD2F8} /* 66 */,
  {-1, 0, 0xD300} /* 67 */,
  {-1, 0, 0xD301} /* 68 */,
  {-1, 0, 0xD305} /* 69 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD30C} /* 6C */,
  {-1, 0, 0xD30D} /* 6D */,
  {-1, 0, 0xD30E} /* 6E */,
  {-1, 0, 0xD310} /* 6F */,
  {-1, 0, 0xD314} /* 70 */,
  {-1, 0, 0xD31C} /* 71 */,
  {-1, 0, 0xD31D} /* 72 */,
  {-1, 0, 0xD31F} /* 73 */,
  {-1, 0, 0xD320} /* 74 */,
  {-1, 0, 0xD321} /* 75 */,
  {-1, 0, 0xD325} /* 76 */,
  {-1, 0, 0xD328} /* 77 */,
  {-1, 0, 0xD329} /* 78 */,
  {-1, 0, 0xD32C} /* 79 */,
  {-1, 0, 0xD330} /* 7A */,
  {-1, 0, 0xD338} /* 7B */,
  {-1, 0, 0xD339} /* 7C */,
  {-1, 0, 0xD33B} /* 7D */,
  {-1, 0, 0xD33C} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page819 = {
  0, marc8_9page819_dir
};
/* PAGE 818 */
struct yaz_iconv_trie_dir marc8_9page818_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xCEA5} /* 21 */,
  {-1, 0, 0xCEAC} /* 22 */,
  {-1, 0, 0xCEAD} /* 23 */,
  {-1, 0, 0xCEE4} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0xCEE8} /* 26 */,
  {-1, 0, 0xCEEC} /* 27 */,
  {-1, 0, 0xCEF4} /* 28 */,
  {-1, 0, 0xCEF5} /* 29 */,
  {-1, 0, 0xCEF7} /* 2A */,
  {-1, 0, 0},
  {-1, 0, 0xCEF9} /* 2C */,
  {-1, 0, 0},
  {-1, 0, 0xCF00} /* 2E */,
  {-1, 0, 0xCF01} /* 2F */,
  {-1, 0, 0xCF04} /* 30 */,
  {-1, 0, 0xCF08} /* 31 */,
  {-1, 0, 0xCF10} /* 32 */,
  {-1, 0, 0xCF11} /* 33 */,
  {-1, 0, 0xCF13} /* 34 */,
  {-1, 0, 0xCF15} /* 35 */,
  {-1, 0, 0xCF1C} /* 36 */,
  {-1, 0, 0xCF20} /* 37 */,
  {-1, 0, 0xCF24} /* 38 */,
  {-1, 0, 0xCF2C} /* 39 */,
  {-1, 0, 0xCF2D} /* 3A */,
  {-1, 0, 0xCF2F} /* 3B */,
  {-1, 0, 0xCF30} /* 3C */,
  {-1, 0, 0xCF54} /* 3D */,
  {-1, 0, 0xCF55} /* 3E */,
  {-1, 0, 0xCF58} /* 3F */,
  {-1, 0, 0xCF5C} /* 40 */,
  {-1, 0, 0xCF64} /* 41 */,
  {-1, 0, 0xCF65} /* 42 */,
  {-1, 0, 0xCF67} /* 43 */,
  {-1, 0, 0xCF69} /* 44 */,
  {-1, 0, 0xCF70} /* 45 */,
  {-1, 0, 0xCF71} /* 46 */,
  {-1, 0, 0xCF74} /* 47 */,
  {-1, 0, 0xCF78} /* 48 */,
  {-1, 0, 0xCF80} /* 49 */,
  {-1, 0, 0xCF85} /* 4A */,
  {-1, 0, 0xCF8C} /* 4B */,
  {-1, 0, 0xCF8D} /* 4C */,
  {-1, 0, 0xCFA1} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0xCFB0} /* 4F */,
  {-1, 0, 0xCFC4} /* 50 */,
  {-1, 0, 0xCFE0} /* 51 */,
  {-1, 0, 0xCFE1} /* 52 */,
  {-1, 0, 0xCFE4} /* 53 */,
  {-1, 0, 0xCFE8} /* 54 */,
  {-1, 0, 0xCFF0} /* 55 */,
  {-1, 0, 0xCFF3} /* 56 */,
  {-1, 0, 0xCFF5} /* 57 */,
  {-1, 0, 0xCFFC} /* 58 */,
  {-1, 0, 0},
  {-1, 0, 0xD018} /* 5A */,
  {-1, 0, 0xD02D} /* 5B */,
  {-1, 0, 0xD034} /* 5C */,
  {-1, 0, 0xD035} /* 5D */,
  {-1, 0, 0xD038} /* 5E */,
  {-1, 0, 0xD050} /* 5F */,
  {-1, 0, 0xD06C} /* 60 */,
  {-1, 0, 0xD070} /* 61 */,
  {-1, 0, 0xD074} /* 62 */,
  {-1, 0, 0xD07C} /* 63 */,
  {-1, 0, 0xD07D} /* 64 */,
  {-1, 0, 0xD081} /* 65 */,
  {-1, 0, 0xD0A4} /* 66 */,
  {-1, 0, 0xD0A5} /* 67 */,
  {-1, 0, 0xD0A8} /* 68 */,
  {-1, 0, 0xD0AC} /* 69 */,
  {-1, 0, 0xD0B4} /* 6A */,
  {-1, 0, 0xD0B5} /* 6B */,
  {-1, 0, 0xD0B7} /* 6C */,
  {-1, 0, 0xD0B9} /* 6D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xD0C0} /* 70 */,
  {-1, 0, 0xD0C1} /* 71 */,
  {-1, 0, 0xD0C4} /* 72 */,
  {-1, 0, 0xD0C8} /* 73 */,
  {-1, 0, 0xD0C9} /* 74 */,
  {-1, 0, 0xD0D0} /* 75 */,
  {-1, 0, 0xD0D1} /* 76 */,
  {-1, 0, 0xD0D3} /* 77 */,
  {-1, 0, 0xD0D4} /* 78 */,
  {-1, 0, 0xD0D5} /* 79 */,
  {-1, 0, 0xD0DC} /* 7A */,
  {-1, 0, 0xD0DD} /* 7B */,
  {-1, 0, 0xD0E0} /* 7C */,
  {-1, 0, 0xD0E4} /* 7D */,
  {-1, 0, 0xD0EC} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page818 = {
  0, marc8_9page818_dir
};
/* PAGE 817 */
struct yaz_iconv_trie_dir marc8_9page817_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xCC29} /* 21 */,
  {-1, 0, 0xCC2C} /* 22 */,
  {-1, 0, 0xCC2E} /* 23 */,
  {-1, 0, 0xCC2F} /* 24 */,
  {-1, 0, 0xCC30} /* 25 */,
  {-1, 0, 0xCC38} /* 26 */,
  {-1, 0, 0xCC39} /* 27 */,
  {-1, 0, 0xCC3B} /* 28 */,
  {-1, 0, 0xCC3C} /* 29 */,
  {-1, 0, 0xCC3D} /* 2A */,
  {-1, 0, 0xCC3E} /* 2B */,
  {-1, 0, 0xCC3F} /* 2C */,
  {-1, 0, 0xCC44} /* 2D */,
  {-1, 0, 0xCC45} /* 2E */,
  {-1, 0, 0xCC48} /* 2F */,
  {-1, 0, 0xCC4C} /* 30 */,
  {-1, 0, 0xCC54} /* 31 */,
  {-1, 0, 0xCC55} /* 32 */,
  {-1, 0, 0xCC58} /* 33 */,
  {-1, 0, 0xCC59} /* 34 */,
  {-1, 0, 0xCC60} /* 35 */,
  {-1, 0, 0xCC64} /* 36 */,
  {-1, 0, 0xCC70} /* 37 */,
  {-1, 0, 0xCC71} /* 38 */,
  {-1, 0, 0xCC98} /* 39 */,
  {-1, 0, 0xCC99} /* 3A */,
  {-1, 0, 0xCC9C} /* 3B */,
  {-1, 0, 0xCCA0} /* 3C */,
  {-1, 0, 0xCCA8} /* 3D */,
  {-1, 0, 0xCCA9} /* 3E */,
  {-1, 0, 0xCCAB} /* 3F */,
  {-1, 0, 0xCCAD} /* 40 */,
  {-1, 0, 0xCCB4} /* 41 */,
  {-1, 0, 0xCCB5} /* 42 */,
  {-1, 0, 0xCCB8} /* 43 */,
  {-1, 0, 0xCCBC} /* 44 */,
  {-1, 0, 0xCCC7} /* 45 */,
  {-1, 0, 0xCCD0} /* 46 */,
  {-1, 0, 0xCCE4} /* 47 */,
  {-1, 0, 0xCD08} /* 48 */,
  {-1, 0, 0xCD09} /* 49 */,
  {-1, 0, 0xCD0C} /* 4A */,
  {-1, 0, 0xCD10} /* 4B */,
  {-1, 0, 0xCD18} /* 4C */,
  {-1, 0, 0xCD19} /* 4D */,
  {-1, 0, 0xCD1B} /* 4E */,
  {-1, 0, 0xCD1D} /* 4F */,
  {-1, 0, 0xCD2C} /* 50 */,
  {-1, 0, 0xCD5C} /* 51 */,
  {-1, 0, 0xCD78} /* 52 */,
  {-1, 0, 0xCD94} /* 53 */,
  {-1, 0, 0xCD95} /* 54 */,
  {-1, 0, 0xCD98} /* 55 */,
  {-1, 0, 0xCD9C} /* 56 */,
  {-1, 0, 0xCDA4} /* 57 */,
  {-1, 0, 0xCDA5} /* 58 */,
  {-1, 0, 0xCDA7} /* 59 */,
  {-1, 0, 0xCDA9} /* 5A */,
  {-1, 0, 0xCDB0} /* 5B */,
  {-1, 0, 0xCDC4} /* 5C */,
  {-1, 0, 0xCDCC} /* 5D */,
  {-1, 0, 0xCDE8} /* 5E */,
  {-1, 0, 0xCE04} /* 5F */,
  {-1, 0, 0xCE20} /* 60 */,
  {-1, 0, 0xCE21} /* 61 */,
  {-1, 0, 0xCE30} /* 62 */,
  {-1, 0, 0xCE35} /* 63 */,
  {-1, 0, 0xCE58} /* 64 */,
  {-1, 0, 0xCE59} /* 65 */,
  {-1, 0, 0xCE5C} /* 66 */,
  {-1, 0, 0xCE60} /* 67 */,
  {-1, 0, 0xCE61} /* 68 */,
  {-1, 0, 0xCE68} /* 69 */,
  {-1, 0, 0xCE69} /* 6A */,
  {-1, 0, 0xCE6B} /* 6B */,
  {-1, 0, 0xCE6D} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xCE74} /* 6F */,
  {-1, 0, 0xCE75} /* 70 */,
  {-1, 0, 0xCE78} /* 71 */,
  {-1, 0, 0xCE7C} /* 72 */,
  {-1, 0, 0xCE84} /* 73 */,
  {-1, 0, 0xCE85} /* 74 */,
  {-1, 0, 0xCE87} /* 75 */,
  {-1, 0, 0xCE89} /* 76 */,
  {-1, 0, 0xCE90} /* 77 */,
  {-1, 0, 0xCE91} /* 78 */,
  {-1, 0, 0xCE94} /* 79 */,
  {-1, 0, 0xCE98} /* 7A */,
  {-1, 0, 0xCEA0} /* 7B */,
  {-1, 0, 0xCEA1} /* 7C */,
  {-1, 0, 0xCEA3} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page817 = {
  0, marc8_9page817_dir
};
/* PAGE 816 */
struct yaz_iconv_trie_dir marc8_9page816_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC974} /* 21 */,
  {-1, 0, 0xC988} /* 22 */,
  {-1, 0, 0xC989} /* 23 */,
  {-1, 0, 0xC98C} /* 24 */,
  {-1, 0, 0xC990} /* 25 */,
  {-1, 0, 0xC998} /* 26 */,
  {-1, 0, 0xC999} /* 27 */,
  {-1, 0, 0xC99D} /* 28 */,
  {-1, 0, 0xC9C0} /* 29 */,
  {-1, 0, 0xC9C1} /* 2A */,
  {-1, 0, 0xC9C4} /* 2B */,
  {-1, 0, 0xC9C7} /* 2C */,
  {-1, 0, 0xC9C8} /* 2D */,
  {-1, 0, 0xC9CA} /* 2E */,
  {-1, 0, 0xC9D0} /* 2F */,
  {-1, 0, 0xC9D1} /* 30 */,
  {-1, 0, 0xC9D3} /* 31 */,
  {-1, 0, 0xC9D5} /* 32 */,
  {-1, 0, 0xC9D6} /* 33 */,
  {-1, 0, 0xC9D9} /* 34 */,
  {-1, 0, 0xC9DA} /* 35 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC9DC} /* 38 */,
  {-1, 0, 0xC9DD} /* 39 */,
  {-1, 0, 0xC9E0} /* 3A */,
  {-1, 0, 0xC9E2} /* 3B */,
  {-1, 0, 0xC9E4} /* 3C */,
  {-1, 0, 0},
  {-1, 0, 0xC9E7} /* 3E */,
  {-1, 0, 0xC9EC} /* 3F */,
  {-1, 0, 0xC9ED} /* 40 */,
  {-1, 0, 0xC9EF} /* 41 */,
  {-1, 0, 0xC9F0} /* 42 */,
  {-1, 0, 0xC9F1} /* 43 */,
  {-1, 0, 0xC9F8} /* 44 */,
  {-1, 0, 0xC9F9} /* 45 */,
  {-1, 0, 0xC9FC} /* 46 */,
  {-1, 0, 0xCA00} /* 47 */,
  {-1, 0, 0xCA08} /* 48 */,
  {-1, 0, 0xCA09} /* 49 */,
  {-1, 0, 0xCA0B} /* 4A */,
  {-1, 0, 0xCA0C} /* 4B */,
  {-1, 0, 0xCA0D} /* 4C */,
  {-1, 0, 0xCA18} /* 4D */,
  {-1, 0, 0xCA4C} /* 4E */,
  {-1, 0, 0xCA4D} /* 4F */,
  {-1, 0, 0xCA50} /* 50 */,
  {-1, 0, 0xCA54} /* 51 */,
  {-1, 0, 0xCA5C} /* 52 */,
  {-1, 0, 0xCA5D} /* 53 */,
  {-1, 0, 0xCA61} /* 54 */,
  {-1, 0, 0xCA84} /* 55 */,
  {-1, 0, 0xCA98} /* 56 */,
  {-1, 0, 0xCABC} /* 57 */,
  {-1, 0, 0xCABD} /* 58 */,
  {-1, 0, 0xCAC0} /* 59 */,
  {-1, 0, 0xCAC4} /* 5A */,
  {-1, 0, 0xCACC} /* 5B */,
  {-1, 0, 0xCACD} /* 5C */,
  {-1, 0, 0xCAD1} /* 5D */,
  {-1, 0, 0xCAD2} /* 5E */,
  {-1, 0, 0xCAD3} /* 5F */,
  {-1, 0, 0xCAD8} /* 60 */,
  {-1, 0, 0xCAD9} /* 61 */,
  {-1, 0, 0xCB10} /* 62 */,
  {-1, 0, 0xCB14} /* 63 */,
  {-1, 0, 0xCB18} /* 64 */,
  {-1, 0, 0xCB20} /* 65 */,
  {-1, 0, 0xCB21} /* 66 */,
  {-1, 0, 0xCB41} /* 67 */,
  {-1, 0, 0xCB48} /* 68 */,
  {-1, 0, 0xCB49} /* 69 */,
  {-1, 0, 0xCB50} /* 6A */,
  {-1, 0, 0xCB58} /* 6B */,
  {-1, 0, 0xCB59} /* 6C */,
  {-1, 0, 0xCB5D} /* 6D */,
  {-1, 0, 0xCB64} /* 6E */,
  {-1, 0, 0xCBB8} /* 6F */,
  {-1, 0, 0xCBD4} /* 70 */,
  {-1, 0, 0xCBE4} /* 71 */,
  {-1, 0, 0xCBE7} /* 72 */,
  {-1, 0, 0xCC0C} /* 73 */,
  {-1, 0, 0xCC0D} /* 74 */,
  {-1, 0, 0xCC10} /* 75 */,
  {-1, 0, 0xCC14} /* 76 */,
  {-1, 0, 0xCC1C} /* 77 */,
  {-1, 0, 0xCC1D} /* 78 */,
  {-1, 0, 0xCC21} /* 79 */,
  {-1, 0, 0xCC22} /* 7A */,
  {-1, 0, 0xCC27} /* 7B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xCC28} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page816 = {
  0, marc8_9page816_dir
};
/* PAGE 815 */
struct yaz_iconv_trie_dir marc8_9page815_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC7A1} /* 21 */,
  {-1, 0, 0xC7A3} /* 22 */,
  {-1, 0, 0xC7A4} /* 23 */,
  {-1, 0, 0xC7A5} /* 24 */,
  {-1, 0, 0xC7A6} /* 25 */,
  {-1, 0, 0xC7A7} /* 26 */,
  {-1, 0, 0xC7AC} /* 27 */,
  {-1, 0, 0xC7AD} /* 28 */,
  {-1, 0, 0xC7B0} /* 29 */,
  {-1, 0, 0xC7B4} /* 2A */,
  {-1, 0, 0xC7BC} /* 2B */,
  {-1, 0, 0xC7BD} /* 2C */,
  {-1, 0, 0xC7BF} /* 2D */,
  {-1, 0, 0xC7C0} /* 2E */,
  {-1, 0, 0xC7C1} /* 2F */,
  {-1, 0, 0xC7C8} /* 30 */,
  {-1, 0, 0xC7C9} /* 31 */,
  {-1, 0, 0xC7CC} /* 32 */,
  {-1, 0, 0xC7D8} /* 33 */,
  {-1, 0, 0xC800} /* 34 */,
  {-1, 0, 0xC801} /* 35 */,
  {-1, 0, 0xC804} /* 36 */,
  {-1, 0, 0xC808} /* 37 */,
  {-1, 0, 0xC80A} /* 38 */,
  {-1, 0, 0xC810} /* 39 */,
  {-1, 0, 0xC811} /* 3A */,
  {-1, 0, 0xC813} /* 3B */,
  {-1, 0, 0xC814} /* 3C */,
  {-1, 0, 0xC815} /* 3D */,
  {-1, 0, 0xC816} /* 3E */,
  {-1, 0, 0xC81C} /* 3F */,
  {-1, 0, 0xC81D} /* 40 */,
  {-1, 0, 0xC820} /* 41 */,
  {-1, 0, 0xC824} /* 42 */,
  {-1, 0, 0xC82C} /* 43 */,
  {-1, 0, 0xC82D} /* 44 */,
  {-1, 0, 0xC82F} /* 45 */,
  {-1, 0, 0xC838} /* 46 */,
  {-1, 0, 0xC83C} /* 47 */,
  {-1, 0, 0xC84C} /* 48 */,
  {-1, 0, 0xC870} /* 49 */,
  {-1, 0, 0xC871} /* 4A */,
  {-1, 0, 0xC874} /* 4B */,
  {-1, 0, 0xC878} /* 4C */,
  {-1, 0, 0xC87A} /* 4D */,
  {-1, 0, 0xC880} /* 4E */,
  {-1, 0, 0xC881} /* 4F */,
  {-1, 0, 0xC885} /* 50 */,
  {-1, 0, 0xC886} /* 51 */,
  {-1, 0, 0xC887} /* 52 */,
  {-1, 0, 0xC88B} /* 53 */,
  {-1, 0, 0xC88C} /* 54 */,
  {-1, 0, 0xC88D} /* 55 */,
  {-1, 0, 0xC890} /* 56 */,
  {-1, 0, 0xC894} /* 57 */,
  {-1, 0, 0xC89C} /* 58 */,
  {-1, 0, 0xC89D} /* 59 */,
  {-1, 0, 0xC89F} /* 5A */,
  {-1, 0, 0xC8A0} /* 5B */,
  {-1, 0, 0},
  {-1, 0, 0xC8A8} /* 5D */,
  {-1, 0, 0xC8AC} /* 5E */,
  {-1, 0, 0xC8B0} /* 5F */,
  {-1, 0, 0xC8B8} /* 60 */,
  {-1, 0, 0xC8C4} /* 61 */,
  {-1, 0, 0xC8C8} /* 62 */,
  {-1, 0, 0xC8CC} /* 63 */,
  {-1, 0, 0xC8D4} /* 64 */,
  {-1, 0, 0xC8D5} /* 65 */,
  {-1, 0, 0xC8D7} /* 66 */,
  {-1, 0, 0xC8E0} /* 67 */,
  {-1, 0, 0xC8E4} /* 68 */,
  {-1, 0, 0xC8F0} /* 69 */,
  {-1, 0, 0xC8F1} /* 6A */,
  {-1, 0, 0xC8F5} /* 6B */,
  {-1, 0, 0xC8FC} /* 6C */,
  {-1, 0, 0xC8FD} /* 6D */,
  {-1, 0, 0xC900} /* 6E */,
  {-1, 0, 0xC904} /* 6F */,
  {-1, 0, 0xC906} /* 70 */,
  {-1, 0, 0xC90C} /* 71 */,
  {-1, 0, 0xC90D} /* 72 */,
  {-1, 0, 0xC90F} /* 73 */,
  {-1, 0, 0xC911} /* 74 */,
  {-1, 0, 0xC918} /* 75 */,
  {-1, 0, 0xC92C} /* 76 */,
  {-1, 0, 0xC950} /* 77 */,
  {-1, 0, 0},
  {-1, 0, 0xC954} /* 79 */,
  {-1, 0, 0xC958} /* 7A */,
  {-1, 0, 0xC960} /* 7B */,
  {-1, 0, 0xC961} /* 7C */,
  {-1, 0, 0xC96C} /* 7D */,
  {-1, 0, 0xC970} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page815 = {
  0, marc8_9page815_dir
};
/* PAGE 814 */
struct yaz_iconv_trie_dir marc8_9page814_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC641} /* 21 */,
  {-1, 0, 0xC644} /* 22 */,
  {-1, 0, 0xC648} /* 23 */,
  {-1, 0, 0xC650} /* 24 */,
  {-1, 0, 0xC651} /* 25 */,
  {-1, 0, 0xC653} /* 26 */,
  {-1, 0, 0xC654} /* 27 */,
  {-1, 0, 0},
  {-1, 0, 0xC65C} /* 29 */,
  {-1, 0, 0xC65D} /* 2A */,
  {-1, 0, 0xC660} /* 2B */,
  {-1, 0, 0xC671} /* 2C */,
  {-1, 0, 0xC678} /* 2D */,
  {-1, 0, 0xC679} /* 2E */,
  {-1, 0, 0xC67C} /* 2F */,
  {-1, 0, 0xC680} /* 30 */,
  {-1, 0, 0xC688} /* 31 */,
  {-1, 0, 0xC68B} /* 32 */,
  {-1, 0, 0xC68D} /* 33 */,
  {-1, 0, 0xC694} /* 34 */,
  {-1, 0, 0xC695} /* 35 */,
  {-1, 0, 0xC698} /* 36 */,
  {-1, 0, 0xC6A5} /* 37 */,
  {-1, 0, 0xC6A7} /* 38 */,
  {-1, 0, 0xC6A9} /* 39 */,
  {-1, 0, 0xC6B0} /* 3A */,
  {-1, 0, 0xC6B1} /* 3B */,
  {-1, 0, 0xC6B4} /* 3C */,
  {-1, 0, 0xC6B7} /* 3D */,
  {-1, 0, 0xC6B8} /* 3E */,
  {-1, 0, 0xC6B9} /* 3F */,
  {-1, 0, 0xC6BA} /* 40 */,
  {-1, 0, 0xC6C0} /* 41 */,
  {-1, 0, 0xC6C1} /* 42 */,
  {-1, 0, 0xC6C3} /* 43 */,
  {-1, 0, 0xC6C5} /* 44 */,
  {-1, 0, 0xC6CC} /* 45 */,
  {-1, 0, 0xC6CD} /* 46 */,
  {-1, 0, 0xC6D0} /* 47 */,
  {-1, 0, 0xC6D4} /* 48 */,
  {-1, 0, 0xC6DC} /* 49 */,
  {-1, 0, 0xC6DD} /* 4A */,
  {-1, 0, 0xC6DF} /* 4B */,
  {-1, 0, 0xC6E0} /* 4C */,
  {-1, 0, 0xC6E1} /* 4D */,
  {-1, 0, 0xC6E8} /* 4E */,
  {-1, 0, 0xC6E9} /* 4F */,
  {-1, 0, 0xC6EC} /* 50 */,
  {-1, 0, 0xC6F0} /* 51 */,
  {-1, 0, 0xC6F8} /* 52 */,
  {-1, 0, 0xC704} /* 53 */,
  {-1, 0, 0xC705} /* 54 */,
  {-1, 0, 0xC708} /* 55 */,
  {-1, 0, 0xC70C} /* 56 */,
  {-1, 0, 0xC714} /* 57 */,
  {-1, 0, 0xC717} /* 58 */,
  {-1, 0, 0xC719} /* 59 */,
  {-1, 0, 0xC720} /* 5A */,
  {-1, 0, 0xC721} /* 5B */,
  {-1, 0, 0xC724} /* 5C */,
  {-1, 0, 0xC728} /* 5D */,
  {-1, 0, 0xC730} /* 5E */,
  {-1, 0, 0xC735} /* 5F */,
  {-1, 0, 0xC737} /* 60 */,
  {-1, 0, 0xC73C} /* 61 */,
  {-1, 0, 0xC73D} /* 62 */,
  {-1, 0, 0xC740} /* 63 */,
  {-1, 0, 0xC744} /* 64 */,
  {-1, 0, 0xC74A} /* 65 */,
  {-1, 0, 0xC74C} /* 66 */,
  {-1, 0, 0xC74D} /* 67 */,
  {-1, 0, 0xC751} /* 68 */,
  {-1, 0, 0xC758} /* 69 */,
  {-1, 0, 0xC774} /* 6A */,
  {-1, 0, 0xC775} /* 6B */,
  {-1, 0, 0xC778} /* 6C */,
  {-1, 0, 0xC77C} /* 6D */,
  {-1, 0, 0xC77D} /* 6E */,
  {-1, 0, 0xC783} /* 6F */,
  {-1, 0, 0xC784} /* 70 */,
  {-1, 0, 0xC785} /* 71 */,
  {-1, 0, 0xC787} /* 72 */,
  {-1, 0, 0xC788} /* 73 */,
  {-1, 0, 0xC789} /* 74 */,
  {-1, 0, 0xC78A} /* 75 */,
  {-1, 0, 0xC78E} /* 76 */,
  {-1, 0, 0xC655} /* 77 */,
  {-1, 0, 0},
  {-1, 0, 0xC790} /* 79 */,
  {-1, 0, 0xC791} /* 7A */,
  {-1, 0, 0xC794} /* 7B */,
  {-1, 0, 0xC796} /* 7C */,
  {-1, 0, 0xC798} /* 7D */,
  {-1, 0, 0xC7A0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page814 = {
  0, marc8_9page814_dir
};
/* PAGE 813 */
struct yaz_iconv_trie_dir marc8_9page813_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC549} /* 21 */,
  {-1, 0, 0xC54A} /* 22 */,
  {-1, 0, 0xC54C} /* 23 */,
  {-1, 0, 0xC54E} /* 24 */,
  {-1, 0, 0xC553} /* 25 */,
  {-1, 0, 0xC554} /* 26 */,
  {-1, 0, 0xC555} /* 27 */,
  {-1, 0, 0xC557} /* 28 */,
  {-1, 0, 0xC558} /* 29 */,
  {-1, 0, 0xC559} /* 2A */,
  {-1, 0, 0xC55E} /* 2B */,
  {-1, 0, 0xC55F} /* 2C */,
  {-1, 0, 0xC560} /* 2D */,
  {-1, 0, 0xC561} /* 2E */,
  {-1, 0, 0xC564} /* 2F */,
  {-1, 0, 0xC568} /* 30 */,
  {-1, 0, 0xC570} /* 31 */,
  {-1, 0, 0xC571} /* 32 */,
  {-1, 0, 0xC573} /* 33 */,
  {-1, 0, 0xC574} /* 34 */,
  {-1, 0, 0xC575} /* 35 */,
  {-1, 0, 0xC57C} /* 36 */,
  {-1, 0, 0xC57D} /* 37 */,
  {-1, 0, 0xC580} /* 38 */,
  {-1, 0, 0xC584} /* 39 */,
  {-1, 0, 0xC587} /* 3A */,
  {-1, 0, 0xC58C} /* 3B */,
  {-1, 0, 0xC58D} /* 3C */,
  {-1, 0, 0xC58F} /* 3D */,
  {-1, 0, 0xC590} /* 3E */,
  {-1, 0, 0xC591} /* 3F */,
  {-1, 0, 0xC595} /* 40 */,
  {-1, 0, 0xC597} /* 41 */,
  {-1, 0, 0xC598} /* 42 */,
  {-1, 0, 0xC59C} /* 43 */,
  {-1, 0, 0xC5B4} /* 44 */,
  {-1, 0, 0xC5B5} /* 45 */,
  {-1, 0, 0xC5B6} /* 46 */,
  {-1, 0, 0xC5B8} /* 47 */,
  {-1, 0, 0xC5B9} /* 48 */,
  {-1, 0, 0xC5BA} /* 49 */,
  {-1, 0, 0xC5BB} /* 4A */,
  {-1, 0, 0xC5BC} /* 4B */,
  {-1, 0, 0xC5BD} /* 4C */,
  {-1, 0, 0xC5C4} /* 4D */,
  {-1, 0, 0xC5C5} /* 4E */,
  {-1, 0, 0xC5C6} /* 4F */,
  {-1, 0, 0xC5C7} /* 50 */,
  {-1, 0, 0xC5C8} /* 51 */,
  {-1, 0, 0xC5C9} /* 52 */,
  {-1, 0, 0xC5CA} /* 53 */,
  {-1, 0, 0xC5CC} /* 54 */,
  {-1, 0, 0xC5CE} /* 55 */,
  {-1, 0, 0xC5D0} /* 56 */,
  {-1, 0, 0xC5D1} /* 57 */,
  {-1, 0, 0xC5D4} /* 58 */,
  {-1, 0, 0xC5D8} /* 59 */,
  {-1, 0, 0xC5E0} /* 5A */,
  {-1, 0, 0xC5E1} /* 5B */,
  {-1, 0, 0xC5E3} /* 5C */,
  {-1, 0, 0xC5E5} /* 5D */,
  {-1, 0, 0xC5EC} /* 5E */,
  {-1, 0, 0xC5ED} /* 5F */,
  {-1, 0, 0xC5EE} /* 60 */,
  {-1, 0, 0xC5F0} /* 61 */,
  {-1, 0, 0xC5F4} /* 62 */,
  {-1, 0, 0xC5F6} /* 63 */,
  {-1, 0, 0xC5F7} /* 64 */,
  {-1, 0, 0xC5FC} /* 65 */,
  {-1, 0, 0xC5FD} /* 66 */,
  {-1, 0, 0xC5FE} /* 67 */,
  {-1, 0, 0xC5FF} /* 68 */,
  {-1, 0, 0xC600} /* 69 */,
  {-1, 0, 0xC601} /* 6A */,
  {-1, 0, 0xC606} /* 6B */,
  {-1, 0, 0xC607} /* 6C */,
  {-1, 0, 0xC608} /* 6D */,
  {-1, 0, 0xC60C} /* 6E */,
  {-1, 0, 0xC610} /* 6F */,
  {-1, 0, 0xC61B} /* 70 */,
  {-1, 0, 0xC624} /* 71 */,
  {-1, 0, 0xC625} /* 72 */,
  {-1, 0, 0xC628} /* 73 */,
  {-1, 0, 0xC62C} /* 74 */,
  {-1, 0, 0xC62D} /* 75 */,
  {-1, 0, 0xC62E} /* 76 */,
  {-1, 0, 0xC633} /* 77 */,
  {-1, 0, 0xC634} /* 78 */,
  {-1, 0, 0xC635} /* 79 */,
  {-1, 0, 0xC637} /* 7A */,
  {-1, 0, 0xC639} /* 7B */,
  {-1, 0, 0xC63A} /* 7C */,
  {-1, 0, 0xC63B} /* 7D */,
  {-1, 0, 0xC640} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page813 = {
  0, marc8_9page813_dir
};
/* PAGE 812 */
struct yaz_iconv_trie_dir marc8_9page812_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC2B7} /* 21 */,
  {-1, 0, 0xC2B9} /* 22 */,
  {-1, 0, 0xC2DC} /* 23 */,
  {-1, 0, 0xC2DD} /* 24 */,
  {-1, 0, 0xC2E0} /* 25 */,
  {-1, 0, 0xC2E3} /* 26 */,
  {-1, 0, 0xC2E4} /* 27 */,
  {-1, 0, 0xC2EB} /* 28 */,
  {-1, 0, 0xC2EC} /* 29 */,
  {-1, 0, 0xC2ED} /* 2A */,
  {-1, 0, 0xC2EF} /* 2B */,
  {-1, 0, 0xC2F1} /* 2C */,
  {-1, 0, 0xC2F6} /* 2D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC2F8} /* 30 */,
  {-1, 0, 0xC2F9} /* 31 */,
  {-1, 0, 0xC2FC} /* 32 */,
  {-1, 0, 0xC300} /* 33 */,
  {-1, 0, 0xC308} /* 34 */,
  {-1, 0, 0xC309} /* 35 */,
  {-1, 0, 0xC30B} /* 36 */,
  {-1, 0, 0xC30C} /* 37 */,
  {-1, 0, 0xC30D} /* 38 */,
  {-1, 0, 0xC313} /* 39 */,
  {-1, 0, 0xC314} /* 3A */,
  {-1, 0, 0xC315} /* 3B */,
  {-1, 0, 0xC318} /* 3C */,
  {-1, 0, 0xC31C} /* 3D */,
  {-1, 0, 0xC324} /* 3E */,
  {-1, 0, 0xC327} /* 3F */,
  {-1, 0, 0xC328} /* 40 */,
  {-1, 0, 0xC329} /* 41 */,
  {-1, 0, 0xC330} /* 42 */,
  {-1, 0, 0xC343} /* 43 */,
  {-1, 0, 0xC345} /* 44 */,
  {-1, 0, 0xC368} /* 45 */,
  {-1, 0, 0xC369} /* 46 */,
  {-1, 0, 0xC36C} /* 47 */,
  {-1, 0, 0xC370} /* 48 */,
  {-1, 0, 0xC372} /* 49 */,
  {-1, 0, 0xC378} /* 4A */,
  {-1, 0, 0xC379} /* 4B */,
  {-1, 0, 0xC37C} /* 4C */,
  {-1, 0, 0xC37D} /* 4D */,
  {-1, 0, 0xC384} /* 4E */,
  {-1, 0, 0xC388} /* 4F */,
  {-1, 0, 0xC399} /* 50 */,
  {-1, 0, 0xC3D8} /* 51 */,
  {-1, 0, 0xC3D9} /* 52 */,
  {-1, 0, 0xC3DC} /* 53 */,
  {-1, 0, 0xC3DF} /* 54 */,
  {-1, 0, 0xC3E0} /* 55 */,
  {-1, 0, 0xC3E8} /* 56 */,
  {-1, 0, 0xC3ED} /* 57 */,
  {-1, 0, 0xC3F4} /* 58 */,
  {-1, 0, 0xC3F5} /* 59 */,
  {-1, 0, 0xC410} /* 5A */,
  {-1, 0, 0xC42C} /* 5B */,
  {-1, 0, 0xC430} /* 5C */,
  {-1, 0, 0xC434} /* 5D */,
  {-1, 0, 0xC43C} /* 5E */,
  {-1, 0, 0xC43F} /* 5F */,
  {-1, 0, 0xC464} /* 60 */,
  {-1, 0, 0xC465} /* 61 */,
  {-1, 0, 0xC468} /* 62 */,
  {-1, 0, 0xC46C} /* 63 */,
  {-1, 0, 0xC474} /* 64 */,
  {-1, 0, 0xC479} /* 65 */,
  {-1, 0, 0xC480} /* 66 */,
  {-1, 0, 0xC494} /* 67 */,
  {-1, 0, 0xC4D4} /* 68 */,
  {-1, 0, 0xC4D5} /* 69 */,
  {-1, 0, 0xC4F0} /* 6A */,
  {-1, 0, 0xC4F1} /* 6B */,
  {-1, 0, 0xC4F4} /* 6C */,
  {-1, 0, 0xC4F8} /* 6D */,
  {-1, 0, 0xC500} /* 6E */,
  {-1, 0, 0xC501} /* 6F */,
  {-1, 0, 0xC50C} /* 70 */,
  {-1, 0, 0xC510} /* 71 */,
  {-1, 0, 0xC528} /* 72 */,
  {-1, 0, 0xC529} /* 73 */,
  {-1, 0, 0xC52C} /* 74 */,
  {-1, 0, 0xC530} /* 75 */,
  {-1, 0, 0xC538} /* 76 */,
  {-1, 0, 0xC539} /* 77 */,
  {-1, 0, 0xC53B} /* 78 */,
  {-1, 0, 0xC53D} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC544} /* 7C */,
  {-1, 0, 0xC545} /* 7D */,
  {-1, 0, 0xC548} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page812 = {
  0, marc8_9page812_dir
};
/* PAGE 811 */
struct yaz_iconv_trie_dir marc8_9page811_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC11C} /* 21 */,
  {-1, 0, 0xC11D} /* 22 */,
  {-1, 0, 0xC11E} /* 23 */,
  {-1, 0, 0xC120} /* 24 */,
  {-1, 0, 0xC123} /* 25 */,
  {-1, 0, 0xC124} /* 26 */,
  {-1, 0, 0xC125} /* 27 */,
  {-1, 0, 0xC126} /* 28 */,
  {-1, 0, 0xC127} /* 29 */,
  {-1, 0, 0xC12A} /* 2A */,
  {-1, 0, 0xC12C} /* 2B */,
  {-1, 0, 0xC12D} /* 2C */,
  {-1, 0, 0xC12F} /* 2D */,
  {-1, 0, 0xC130} /* 2E */,
  {-1, 0, 0xC131} /* 2F */,
  {-1, 0, 0xC136} /* 30 */,
  {-1, 0, 0xC138} /* 31 */,
  {-1, 0, 0xC139} /* 32 */,
  {-1, 0, 0xC13C} /* 33 */,
  {-1, 0, 0xC140} /* 34 */,
  {-1, 0, 0xC148} /* 35 */,
  {-1, 0, 0xC149} /* 36 */,
  {-1, 0, 0xC14B} /* 37 */,
  {-1, 0, 0xC14D} /* 38 */,
  {-1, 0, 0xC151} /* 39 */,
  {-1, 0, 0xC154} /* 3A */,
  {-1, 0, 0xC158} /* 3B */,
  {-1, 0, 0xC167} /* 3C */,
  {-1, 0, 0xC168} /* 3D */,
  {-1, 0, 0xC170} /* 3E */,
  {-1, 0, 0xC18C} /* 3F */,
  {-1, 0, 0xC18D} /* 40 */,
  {-1, 0, 0xC18E} /* 41 */,
  {-1, 0, 0xC190} /* 42 */,
  {-1, 0, 0xC194} /* 43 */,
  {-1, 0, 0xC19C} /* 44 */,
  {-1, 0, 0xC19D} /* 45 */,
  {-1, 0, 0xC19F} /* 46 */,
  {-1, 0, 0xC1A1} /* 47 */,
  {-1, 0, 0xC1A5} /* 48 */,
  {-1, 0, 0xC1A8} /* 49 */,
  {-1, 0, 0xC1A9} /* 4A */,
  {-1, 0, 0xC1B0} /* 4B */,
  {-1, 0, 0xC1C4} /* 4C */,
  {-1, 0, 0xC1C8} /* 4D */,
  {-1, 0, 0xC1D7} /* 4E */,
  {-1, 0, 0xC1E0} /* 4F */,
  {-1, 0, 0xC1E4} /* 50 */,
  {-1, 0, 0xC1E8} /* 51 */,
  {-1, 0, 0xC1F0} /* 52 */,
  {-1, 0, 0xC1F1} /* 53 */,
  {-1, 0, 0xC1F3} /* 54 */,
  {-1, 0, 0xC1FC} /* 55 */,
  {-1, 0, 0xC1FD} /* 56 */,
  {-1, 0, 0xC200} /* 57 */,
  {-1, 0, 0xC204} /* 58 */,
  {-1, 0, 0xC20D} /* 59 */,
  {-1, 0, 0},
  {-1, 0, 0xC218} /* 5B */,
  {-1, 0, 0xC219} /* 5C */,
  {-1, 0, 0xC21C} /* 5D */,
  {-1, 0, 0xC21F} /* 5E */,
  {-1, 0, 0xC220} /* 5F */,
  {-1, 0, 0xC228} /* 60 */,
  {-1, 0, 0xC229} /* 61 */,
  {-1, 0, 0xC22B} /* 62 */,
  {-1, 0, 0xC22D} /* 63 */,
  {-1, 0, 0xC22F} /* 64 */,
  {-1, 0, 0xC231} /* 65 */,
  {-1, 0, 0xC232} /* 66 */,
  {-1, 0, 0xC234} /* 67 */,
  {-1, 0, 0xC250} /* 68 */,
  {-1, 0, 0xC258} /* 69 */,
  {-1, 0, 0xC26C} /* 6A */,
  {-1, 0, 0xC270} /* 6B */,
  {-1, 0, 0xC274} /* 6C */,
  {-1, 0, 0xC27C} /* 6D */,
  {-1, 0, 0xC27D} /* 6E */,
  {-1, 0, 0xC27F} /* 6F */,
  {-1, 0, 0xC281} /* 70 */,
  {-1, 0, 0xC288} /* 71 */,
  {-1, 0, 0xC289} /* 72 */,
  {-1, 0, 0xC290} /* 73 */,
  {-1, 0, 0xC298} /* 74 */,
  {-1, 0, 0xC29B} /* 75 */,
  {-1, 0, 0xC29D} /* 76 */,
  {-1, 0, 0xC2A4} /* 77 */,
  {-1, 0, 0xC2A5} /* 78 */,
  {-1, 0, 0xC2A8} /* 79 */,
  {-1, 0, 0xC2AC} /* 7A */,
  {-1, 0, 0xC2AD} /* 7B */,
  {-1, 0, 0},
  {-1, 0, 0xC2B4} /* 7D */,
  {-1, 0, 0xC2B5} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page811 = {
  0, marc8_9page811_dir
};
/* PAGE 810 */
struct yaz_iconv_trie_dir marc8_9page810_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xBE70} /* 21 */,
  {-1, 0, 0xBE71} /* 22 */,
  {-1, 0, 0xBE73} /* 23 */,
  {-1, 0, 0xBE74} /* 24 */,
  {-1, 0, 0xBE75} /* 25 */,
  {-1, 0, 0xBE7B} /* 26 */,
  {-1, 0, 0xBE7C} /* 27 */,
  {-1, 0, 0xBE7D} /* 28 */,
  {-1, 0, 0xBE80} /* 29 */,
  {-1, 0, 0xBE84} /* 2A */,
  {-1, 0, 0xBE8C} /* 2B */,
  {-1, 0, 0xBE8F} /* 2C */,
  {-1, 0, 0xBE90} /* 2D */,
  {-1, 0, 0xBE91} /* 2E */,
  {-1, 0, 0xBE98} /* 2F */,
  {-1, 0, 0xBEA8} /* 30 */,
  {-1, 0, 0xBED0} /* 31 */,
  {-1, 0, 0xBED1} /* 32 */,
  {-1, 0, 0xBED4} /* 33 */,
  {-1, 0, 0xBED7} /* 34 */,
  {-1, 0, 0xBED8} /* 35 */,
  {-1, 0, 0xBEE0} /* 36 */,
  {-1, 0, 0xBEE3} /* 37 */,
  {-1, 0, 0xBEE4} /* 38 */,
  {-1, 0, 0xBEE5} /* 39 */,
  {-1, 0, 0xBEEC} /* 3A */,
  {-1, 0, 0xBF08} /* 3B */,
  {-1, 0, 0xBF09} /* 3C */,
  {-1, 0, 0xBF18} /* 3D */,
  {-1, 0, 0xBF1D} /* 3E */,
  {-1, 0, 0xBF40} /* 3F */,
  {-1, 0, 0xBF41} /* 40 */,
  {-1, 0, 0xBF44} /* 41 */,
  {-1, 0, 0xBF48} /* 42 */,
  {-1, 0, 0xBF50} /* 43 */,
  {-1, 0, 0xBF51} /* 44 */,
  {-1, 0, 0xBF55} /* 45 */,
  {-1, 0, 0xBFB0} /* 46 */,
  {-1, 0, 0xBFC0} /* 47 */,
  {-1, 0, 0xBFC5} /* 48 */,
  {-1, 0, 0xBFCC} /* 49 */,
  {-1, 0, 0xBFCD} /* 4A */,
  {-1, 0, 0xBFD0} /* 4B */,
  {-1, 0, 0xBFD4} /* 4C */,
  {-1, 0, 0xBFDC} /* 4D */,
  {-1, 0, 0xBFDD} /* 4E */,
  {-1, 0, 0xBFE1} /* 4F */,
  {-1, 0, 0xC058} /* 50 */,
  {-1, 0, 0xC059} /* 51 */,
  {-1, 0, 0xC05C} /* 52 */,
  {-1, 0, 0xC060} /* 53 */,
  {-1, 0, 0xC068} /* 54 */,
  {-1, 0, 0xC069} /* 55 */,
  {-1, 0, 0xC090} /* 56 */,
  {-1, 0, 0xC091} /* 57 */,
  {-1, 0, 0xC094} /* 58 */,
  {-1, 0, 0xC098} /* 59 */,
  {-1, 0, 0xC0A0} /* 5A */,
  {-1, 0, 0xC0A3} /* 5B */,
  {-1, 0, 0xC0A5} /* 5C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xC0AC} /* 5F */,
  {-1, 0, 0xC0AD} /* 60 */,
  {-1, 0, 0xC0AE} /* 61 */,
  {-1, 0, 0xC0AF} /* 62 */,
  {-1, 0, 0xC0B0} /* 63 */,
  {-1, 0, 0xC0B3} /* 64 */,
  {-1, 0, 0xC0B4} /* 65 */,
  {-1, 0, 0xC0B5} /* 66 */,
  {-1, 0, 0xC0B6} /* 67 */,
  {-1, 0, 0xC0BC} /* 68 */,
  {-1, 0, 0xC0BD} /* 69 */,
  {-1, 0, 0xC0BF} /* 6A */,
  {-1, 0, 0xC0C0} /* 6B */,
  {-1, 0, 0xC0C1} /* 6C */,
  {-1, 0, 0xC0C5} /* 6D */,
  {-1, 0, 0xC0C8} /* 6E */,
  {-1, 0, 0xC0C9} /* 6F */,
  {-1, 0, 0xC0CC} /* 70 */,
  {-1, 0, 0xC0CF} /* 71 */,
  {-1, 0, 0xC0D0} /* 72 */,
  {-1, 0, 0xC0D8} /* 73 */,
  {-1, 0, 0xC0D9} /* 74 */,
  {-1, 0, 0xC0DB} /* 75 */,
  {-1, 0, 0xC0DC} /* 76 */,
  {-1, 0, 0xC0DD} /* 77 */,
  {-1, 0, 0xC0E4} /* 78 */,
  {-1, 0, 0xC0E5} /* 79 */,
  {-1, 0, 0xC0E8} /* 7A */,
  {-1, 0, 0xC0EC} /* 7B */,
  {-1, 0, 0xC0F4} /* 7C */,
  {-1, 0, 0xC0F7} /* 7D */,
  {-1, 0, 0xC0F9} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page810 = {
  0, marc8_9page810_dir
};
/* PAGE 809 */
struct yaz_iconv_trie_dir marc8_9page809_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xBC40} /* 21 */,
  {-1, 0, 0xBC41} /* 22 */,
  {-1, 0, 0xBC43} /* 23 */,
  {-1, 0, 0xBC44} /* 24 */,
  {-1, 0, 0xBC45} /* 25 */,
  {-1, 0, 0xBC84} /* 26 */,
  {-1, 0, 0xBC85} /* 27 */,
  {-1, 0, 0xBC88} /* 28 */,
  {-1, 0, 0xBC8B} /* 29 */,
  {-1, 0, 0xBC8C} /* 2A */,
  {-1, 0, 0xBC94} /* 2B */,
  {-1, 0, 0xBC95} /* 2C */,
  {-1, 0, 0xBC97} /* 2D */,
  {-1, 0, 0xBC98} /* 2E */,
  {-1, 0, 0xBC99} /* 2F */,
  {-1, 0, 0xBC9A} /* 30 */,
  {-1, 0, 0xBCA0} /* 31 */,
  {-1, 0, 0xBCA1} /* 32 */,
  {-1, 0, 0xBCA4} /* 33 */,
  {-1, 0, 0xBCA7} /* 34 */,
  {-1, 0, 0xBCA8} /* 35 */,
  {-1, 0, 0xBCB0} /* 36 */,
  {-1, 0, 0xBCB1} /* 37 */,
  {-1, 0, 0xBCB3} /* 38 */,
  {-1, 0, 0xBCB5} /* 39 */,
  {-1, 0, 0xBCBC} /* 3A */,
  {-1, 0, 0xBCBD} /* 3B */,
  {-1, 0, 0xBCC0} /* 3C */,
  {-1, 0, 0xBCC4} /* 3D */,
  {-1, 0, 0xBCCC} /* 3E */,
  {-1, 0, 0xBCCD} /* 3F */,
  {-1, 0, 0xBCCF} /* 40 */,
  {-1, 0, 0xBCD0} /* 41 */,
  {-1, 0, 0xBCD1} /* 42 */,
  {-1, 0, 0xBCD2} /* 43 */,
  {-1, 0, 0xBCD5} /* 44 */,
  {-1, 0, 0xBCF4} /* 45 */,
  {-1, 0, 0xBCF5} /* 46 */,
  {-1, 0, 0xBCF6} /* 47 */,
  {-1, 0, 0xBCF8} /* 48 */,
  {-1, 0, 0xBCFC} /* 49 */,
  {-1, 0, 0xBD04} /* 4A */,
  {-1, 0, 0xBD05} /* 4B */,
  {-1, 0, 0xBD07} /* 4C */,
  {-1, 0, 0xBD09} /* 4D */,
  {-1, 0, 0xBD10} /* 4E */,
  {-1, 0, 0xBD14} /* 4F */,
  {-1, 0, 0xBD24} /* 50 */,
  {-1, 0, 0xBD48} /* 51 */,
  {-1, 0, 0xBD49} /* 52 */,
  {-1, 0, 0xBD4C} /* 53 */,
  {-1, 0, 0xBD50} /* 54 */,
  {-1, 0, 0xBD58} /* 55 */,
  {-1, 0, 0xBD59} /* 56 */,
  {-1, 0, 0xBD64} /* 57 */,
  {-1, 0, 0xBD80} /* 58 */,
  {-1, 0, 0xBD81} /* 59 */,
  {-1, 0, 0xBD84} /* 5A */,
  {-1, 0, 0xBD87} /* 5B */,
  {-1, 0, 0xBD88} /* 5C */,
  {-1, 0, 0xBD89} /* 5D */,
  {-1, 0, 0xBD90} /* 5E */,
  {-1, 0, 0xBD91} /* 5F */,
  {-1, 0, 0xBD93} /* 60 */,
  {-1, 0, 0xBD95} /* 61 */,
  {-1, 0, 0xBD99} /* 62 */,
  {-1, 0, 0xBD9C} /* 63 */,
  {-1, 0, 0xBDD4} /* 64 */,
  {-1, 0, 0xBDF0} /* 65 */,
  {-1, 0, 0xBE0C} /* 66 */,
  {-1, 0, 0xBE0D} /* 67 */,
  {-1, 0, 0xBE10} /* 68 */,
  {-1, 0, 0xBE14} /* 69 */,
  {-1, 0, 0xBE1C} /* 6A */,
  {-1, 0, 0xBE1D} /* 6B */,
  {-1, 0, 0xBE1F} /* 6C */,
  {-1, 0, 0xBE44} /* 6D */,
  {-1, 0, 0xBE45} /* 6E */,
  {-1, 0, 0xBE48} /* 6F */,
  {-1, 0, 0xBE4B} /* 70 */,
  {-1, 0, 0xBE4C} /* 71 */,
  {-1, 0, 0xBE4E} /* 72 */,
  {-1, 0, 0xBE54} /* 73 */,
  {-1, 0, 0xBE55} /* 74 */,
  {-1, 0, 0xBE57} /* 75 */,
  {-1, 0, 0xBE59} /* 76 */,
  {-1, 0, 0xBE5A} /* 77 */,
  {-1, 0, 0xBE5B} /* 78 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xBE60} /* 7B */,
  {-1, 0, 0xBE61} /* 7C */,
  {-1, 0, 0xBE64} /* 7D */,
  {-1, 0, 0xBE68} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page809 = {
  0, marc8_9page809_dir
};
/* PAGE 808 */
struct yaz_iconv_trie_dir marc8_9page808_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xBA38} /* 21 */,
  {-1, 0, 0xBA39} /* 22 */,
  {-1, 0, 0xBA3C} /* 23 */,
  {-1, 0, 0xBA40} /* 24 */,
  {-1, 0, 0xBA48} /* 25 */,
  {-1, 0, 0xBA49} /* 26 */,
  {-1, 0, 0xBA4B} /* 27 */,
  {-1, 0, 0xBA4D} /* 28 */,
  {-1, 0, 0xBA4E} /* 29 */,
  {-1, 0, 0xBA53} /* 2A */,
  {-1, 0, 0xBA54} /* 2B */,
  {-1, 0, 0xBA55} /* 2C */,
  {-1, 0, 0xBA58} /* 2D */,
  {-1, 0, 0xBA5C} /* 2E */,
  {-1, 0, 0xBA64} /* 2F */,
  {-1, 0, 0xBA65} /* 30 */,
  {-1, 0, 0xBA67} /* 31 */,
  {-1, 0, 0xBA70} /* 32 */,
  {-1, 0, 0xBA71} /* 33 */,
  {-1, 0, 0xBA74} /* 34 */,
  {-1, 0, 0xBA78} /* 35 */,
  {-1, 0, 0xBA83} /* 36 */,
  {-1, 0, 0xBA84} /* 37 */,
  {-1, 0, 0xBA85} /* 38 */,
  {-1, 0, 0xBA87} /* 39 */,
  {-1, 0, 0xBAA8} /* 3A */,
  {-1, 0, 0xBAA9} /* 3B */,
  {-1, 0, 0xBAAB} /* 3C */,
  {-1, 0, 0xBAAC} /* 3D */,
  {-1, 0, 0xBAB0} /* 3E */,
  {-1, 0, 0xBAB8} /* 3F */,
  {-1, 0, 0xBAB9} /* 40 */,
  {-1, 0, 0xBABB} /* 41 */,
  {-1, 0, 0xBABD} /* 42 */,
  {-1, 0, 0xBAC3} /* 43 */,
  {-1, 0, 0xBAFC} /* 44 */,
  {-1, 0, 0xBB0F} /* 45 */,
  {-1, 0, 0xBB18} /* 46 */,
  {-1, 0, 0xBB34} /* 47 */,
  {-1, 0, 0xBB35} /* 48 */,
  {-1, 0, 0xBB36} /* 49 */,
  {-1, 0, 0xBB38} /* 4A */,
  {-1, 0, 0xBB3B} /* 4B */,
  {-1, 0, 0xBB3C} /* 4C */,
  {-1, 0, 0xBB3D} /* 4D */,
  {-1, 0, 0xBB44} /* 4E */,
  {-1, 0, 0xBB47} /* 4F */,
  {-1, 0, 0xBB49} /* 50 */,
  {-1, 0, 0xBB4D} /* 51 */,
  {-1, 0, 0xBB4F} /* 52 */,
  {-1, 0, 0xBB50} /* 53 */,
  {-1, 0, 0xBB54} /* 54 */,
  {-1, 0, 0xBB58} /* 55 */,
  {-1, 0, 0xBB61} /* 56 */,
  {-1, 0, 0xBB63} /* 57 */,
  {-1, 0, 0xBB88} /* 58 */,
  {-1, 0, 0xBB8C} /* 59 */,
  {-1, 0, 0xBBA4} /* 5A */,
  {-1, 0, 0xBBC0} /* 5B */,
  {-1, 0, 0xBBC4} /* 5C */,
  {-1, 0, 0xBBC8} /* 5D */,
  {-1, 0, 0xBBD0} /* 5E */,
  {-1, 0, 0xBBF8} /* 5F */,
  {-1, 0, 0xBBF9} /* 60 */,
  {-1, 0, 0xBBFC} /* 61 */,
  {-1, 0, 0xBBFF} /* 62 */,
  {-1, 0, 0xBC00} /* 63 */,
  {-1, 0, 0xBC08} /* 64 */,
  {-1, 0, 0xBC09} /* 65 */,
  {-1, 0, 0xBC0B} /* 66 */,
  {-1, 0, 0},
  {-1, 0, 0xBC0D} /* 68 */,
  {-1, 0, 0xBC0F} /* 69 */,
  {-1, 0, 0xBC11} /* 6A */,
  {-1, 0, 0xBBB4} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0xBC14} /* 6D */,
  {-1, 0, 0xBC15} /* 6E */,
  {-1, 0, 0xBC16} /* 6F */,
  {-1, 0, 0xBC18} /* 70 */,
  {-1, 0, 0xBC1B} /* 71 */,
  {-1, 0, 0xBC1C} /* 72 */,
  {-1, 0, 0xBC1D} /* 73 */,
  {-1, 0, 0xBC1F} /* 74 */,
  {-1, 0, 0xBC24} /* 75 */,
  {-1, 0, 0xBC25} /* 76 */,
  {-1, 0, 0xBC27} /* 77 */,
  {-1, 0, 0xBC29} /* 78 */,
  {-1, 0, 0xBC2D} /* 79 */,
  {-1, 0, 0xBC30} /* 7A */,
  {-1, 0, 0xBC31} /* 7B */,
  {-1, 0, 0xBC34} /* 7C */,
  {-1, 0, 0xBC37} /* 7D */,
  {-1, 0, 0xBC38} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page808 = {
  0, marc8_9page808_dir
};
/* PAGE 807 */
struct yaz_iconv_trie_dir marc8_9page807_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB7FD} /* 21 */,
  {-1, 0, 0xB7FF} /* 22 */,
  {-1, 0, 0xB800} /* 23 */,
  {-1, 0, 0xB801} /* 24 */,
  {-1, 0, 0xB807} /* 25 */,
  {-1, 0, 0xB808} /* 26 */,
  {-1, 0, 0xB809} /* 27 */,
  {-1, 0, 0xB80C} /* 28 */,
  {-1, 0, 0xB810} /* 29 */,
  {-1, 0, 0xB818} /* 2A */,
  {-1, 0, 0xB819} /* 2B */,
  {-1, 0, 0xB81B} /* 2C */,
  {-1, 0, 0xB81D} /* 2D */,
  {-1, 0, 0xB824} /* 2E */,
  {-1, 0, 0xB825} /* 2F */,
  {-1, 0, 0xB828} /* 30 */,
  {-1, 0, 0xB82C} /* 31 */,
  {-1, 0, 0xB834} /* 32 */,
  {-1, 0, 0xB835} /* 33 */,
  {-1, 0, 0xB837} /* 34 */,
  {-1, 0, 0xB838} /* 35 */,
  {-1, 0, 0xB839} /* 36 */,
  {-1, 0, 0xB840} /* 37 */,
  {-1, 0, 0xB85C} /* 38 */,
  {-1, 0, 0xB85D} /* 39 */,
  {-1, 0, 0xB860} /* 3A */,
  {-1, 0, 0xB864} /* 3B */,
  {-1, 0, 0xB86C} /* 3C */,
  {-1, 0, 0xB86D} /* 3D */,
  {-1, 0, 0xB86F} /* 3E */,
  {-1, 0, 0xB871} /* 3F */,
  {-1, 0, 0xB8B0} /* 40 */,
  {-1, 0, 0xB8CC} /* 41 */,
  {-1, 0, 0xB8E1} /* 42 */,
  {-1, 0, 0xB8E8} /* 43 */,
  {-1, 0, 0xB8E9} /* 44 */,
  {-1, 0, 0xB8EC} /* 45 */,
  {-1, 0, 0xB8F0} /* 46 */,
  {-1, 0, 0xB8F8} /* 47 */,
  {-1, 0, 0xB8F9} /* 48 */,
  {-1, 0, 0xB8FB} /* 49 */,
  {-1, 0, 0xB8FD} /* 4A */,
  {-1, 0, 0xB904} /* 4B */,
  {-1, 0, 0xB93C} /* 4C */,
  {-1, 0, 0xB958} /* 4D */,
  {-1, 0, 0xB959} /* 4E */,
  {-1, 0, 0xB95C} /* 4F */,
  {-1, 0, 0xB960} /* 50 */,
  {-1, 0, 0xB968} /* 51 */,
  {-1, 0, 0xB96D} /* 52 */,
  {-1, 0, 0xB974} /* 53 */,
  {-1, 0, 0xB975} /* 54 */,
  {-1, 0, 0xB978} /* 55 */,
  {-1, 0, 0xB97C} /* 56 */,
  {-1, 0, 0xB984} /* 57 */,
  {-1, 0, 0xB985} /* 58 */,
  {-1, 0, 0xB987} /* 59 */,
  {-1, 0, 0xB989} /* 5A */,
  {-1, 0, 0xB98E} /* 5B */,
  {-1, 0, 0xB9AC} /* 5C */,
  {-1, 0, 0xB9AD} /* 5D */,
  {-1, 0, 0xB9B0} /* 5E */,
  {-1, 0, 0xB9B4} /* 5F */,
  {-1, 0, 0xB9BC} /* 60 */,
  {-1, 0, 0xB9BD} /* 61 */,
  {-1, 0, 0xB9BF} /* 62 */,
  {-1, 0, 0xB9C1} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB9C8} /* 66 */,
  {-1, 0, 0xB9C9} /* 67 */,
  {-1, 0, 0xB9CC} /* 68 */,
  {-1, 0, 0xB9CE} /* 69 */,
  {-1, 0, 0xB9CF} /* 6A */,
  {-1, 0, 0xB9D0} /* 6B */,
  {-1, 0, 0xB9D1} /* 6C */,
  {-1, 0, 0xB9D8} /* 6D */,
  {-1, 0, 0xB9D9} /* 6E */,
  {-1, 0, 0xB9DB} /* 6F */,
  {-1, 0, 0xB9DD} /* 70 */,
  {-1, 0, 0xB9DE} /* 71 */,
  {-1, 0, 0xB9E1} /* 72 */,
  {-1, 0, 0xB9E3} /* 73 */,
  {-1, 0, 0xB9E4} /* 74 */,
  {-1, 0, 0xB9E5} /* 75 */,
  {-1, 0, 0xB9E8} /* 76 */,
  {-1, 0, 0xB9EC} /* 77 */,
  {-1, 0, 0xB9F4} /* 78 */,
  {-1, 0, 0xB9F5} /* 79 */,
  {-1, 0, 0xB9F7} /* 7A */,
  {-1, 0, 0xB9F8} /* 7B */,
  {-1, 0, 0xB9F9} /* 7C */,
  {-1, 0, 0xB9FA} /* 7D */,
  {-1, 0, 0xBA00} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page807 = {
  0, marc8_9page807_dir
};
/* PAGE 806 */
struct yaz_iconv_trie_dir marc8_9page806_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB540} /* 21 */,
  {-1, 0, 0xB541} /* 22 */,
  {-1, 0, 0xB543} /* 23 */,
  {-1, 0, 0xB544} /* 24 */,
  {-1, 0, 0xB545} /* 25 */,
  {-1, 0, 0xB54B} /* 26 */,
  {-1, 0, 0xB54C} /* 27 */,
  {-1, 0, 0xB54D} /* 28 */,
  {-1, 0, 0xB550} /* 29 */,
  {-1, 0, 0xB554} /* 2A */,
  {-1, 0, 0xB55C} /* 2B */,
  {-1, 0, 0xB55D} /* 2C */,
  {-1, 0, 0xB55F} /* 2D */,
  {-1, 0, 0xB560} /* 2E */,
  {-1, 0, 0xB561} /* 2F */,
  {-1, 0, 0xB5A0} /* 30 */,
  {-1, 0, 0xB5A1} /* 31 */,
  {-1, 0, 0xB5A4} /* 32 */,
  {-1, 0, 0xB5A8} /* 33 */,
  {-1, 0, 0xB5AB} /* 34 */,
  {-1, 0, 0xB5B0} /* 35 */,
  {-1, 0, 0xB5B1} /* 36 */,
  {-1, 0, 0xB5B3} /* 37 */,
  {-1, 0, 0xB5B4} /* 38 */,
  {-1, 0, 0xB5B5} /* 39 */,
  {-1, 0, 0xB5BB} /* 3A */,
  {-1, 0, 0xB5BC} /* 3B */,
  {-1, 0, 0xB5C0} /* 3C */,
  {-1, 0, 0xB5C4} /* 3D */,
  {-1, 0, 0xB5CC} /* 3E */,
  {-1, 0, 0xB5CF} /* 3F */,
  {-1, 0, 0xB5D1} /* 40 */,
  {-1, 0, 0xB610} /* 41 */,
  {-1, 0, 0xB611} /* 42 */,
  {-1, 0, 0xB614} /* 43 */,
  {-1, 0, 0xB618} /* 44 */,
  {-1, 0, 0xB625} /* 45 */,
  {-1, 0, 0xB664} /* 46 */,
  {-1, 0, 0xB69C} /* 47 */,
  {-1, 0, 0xB69D} /* 48 */,
  {-1, 0, 0xB6A4} /* 49 */,
  {-1, 0, 0xB6AB} /* 4A */,
  {-1, 0, 0xB6AC} /* 4B */,
  {-1, 0, 0xB6B1} /* 4C */,
  {-1, 0, 0xB6F0} /* 4D */,
  {-1, 0, 0xB6F4} /* 4E */,
  {-1, 0, 0xB6F8} /* 4F */,
  {-1, 0, 0xB700} /* 50 */,
  {-1, 0, 0xB701} /* 51 */,
  {-1, 0, 0xB728} /* 52 */,
  {-1, 0, 0xB729} /* 53 */,
  {-1, 0, 0xB72C} /* 54 */,
  {-1, 0, 0xB72F} /* 55 */,
  {-1, 0, 0xB730} /* 56 */,
  {-1, 0, 0xB738} /* 57 */,
  {-1, 0, 0xB739} /* 58 */,
  {-1, 0, 0xB73B} /* 59 */,
  {-1, 0, 0xB744} /* 5A */,
  {-1, 0, 0xB748} /* 5B */,
  {-1, 0, 0xB760} /* 5C */,
  {-1, 0, 0xB764} /* 5D */,
  {-1, 0, 0xB768} /* 5E */,
  {-1, 0, 0xB770} /* 5F */,
  {-1, 0, 0xB771} /* 60 */,
  {-1, 0, 0xB775} /* 61 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB77C} /* 64 */,
  {-1, 0, 0xB77D} /* 65 */,
  {-1, 0, 0xB780} /* 66 */,
  {-1, 0, 0xB784} /* 67 */,
  {-1, 0, 0xB78C} /* 68 */,
  {-1, 0, 0xB78D} /* 69 */,
  {-1, 0, 0xB78F} /* 6A */,
  {-1, 0, 0xB790} /* 6B */,
  {-1, 0, 0xB791} /* 6C */,
  {-1, 0, 0xB797} /* 6D */,
  {-1, 0, 0xB798} /* 6E */,
  {-1, 0, 0xB799} /* 6F */,
  {-1, 0, 0xB79C} /* 70 */,
  {-1, 0, 0xB7A0} /* 71 */,
  {-1, 0, 0xB7A8} /* 72 */,
  {-1, 0, 0xB7A9} /* 73 */,
  {-1, 0, 0xB7AB} /* 74 */,
  {-1, 0, 0xB7AC} /* 75 */,
  {-1, 0, 0xB7AD} /* 76 */,
  {-1, 0, 0xB7B4} /* 77 */,
  {-1, 0, 0xB7B5} /* 78 */,
  {-1, 0, 0xB7C9} /* 79 */,
  {-1, 0, 0xB7EC} /* 7A */,
  {-1, 0, 0xB7ED} /* 7B */,
  {-1, 0, 0xB7F0} /* 7C */,
  {-1, 0, 0xB7F4} /* 7D */,
  {-1, 0, 0xB7FC} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page806 = {
  0, marc8_9page806_dir
};
/* PAGE 805 */
struct yaz_iconv_trie_dir marc8_9page805_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB304} /* 21 */,
  {-1, 0, 0xB308} /* 22 */,
  {-1, 0, 0xB310} /* 23 */,
  {-1, 0, 0xB311} /* 24 */,
  {-1, 0, 0xB313} /* 25 */,
  {-1, 0, 0xB314} /* 26 */,
  {-1, 0, 0xB315} /* 27 */,
  {-1, 0, 0xB354} /* 28 */,
  {-1, 0, 0xB355} /* 29 */,
  {-1, 0, 0xB358} /* 2A */,
  {-1, 0, 0xB35B} /* 2B */,
  {-1, 0, 0xB35C} /* 2C */,
  {-1, 0, 0xB35F} /* 2D */,
  {-1, 0, 0xB364} /* 2E */,
  {-1, 0, 0xB365} /* 2F */,
  {-1, 0, 0xB367} /* 30 */,
  {-1, 0, 0xB368} /* 31 */,
  {-1, 0, 0xB369} /* 32 */,
  {-1, 0, 0xB36A} /* 33 */,
  {-1, 0, 0xB36B} /* 34 */,
  {-1, 0, 0xB36E} /* 35 */,
  {-1, 0, 0xB370} /* 36 */,
  {-1, 0, 0xB371} /* 37 */,
  {-1, 0, 0xB374} /* 38 */,
  {-1, 0, 0xB378} /* 39 */,
  {-1, 0, 0xB380} /* 3A */,
  {-1, 0, 0xB383} /* 3B */,
  {-1, 0, 0xB385} /* 3C */,
  {-1, 0, 0xB38C} /* 3D */,
  {-1, 0, 0xB3C4} /* 3E */,
  {-1, 0, 0xB3C5} /* 3F */,
  {-1, 0, 0xB3C8} /* 40 */,
  {-1, 0, 0xB3CB} /* 41 */,
  {-1, 0, 0xB3CC} /* 42 */,
  {-1, 0, 0xB3D0} /* 43 */,
  {-1, 0, 0xB3D4} /* 44 */,
  {-1, 0, 0xB3D5} /* 45 */,
  {-1, 0, 0xB3D7} /* 46 */,
  {-1, 0, 0xB3D9} /* 47 */,
  {-1, 0, 0xB3DB} /* 48 */,
  {-1, 0, 0xB3FC} /* 49 */,
  {-1, 0, 0xB400} /* 4A */,
  {-1, 0, 0xB410} /* 4B */,
  {-1, 0, 0xB418} /* 4C */,
  {-1, 0, 0xB41C} /* 4D */,
  {-1, 0, 0xB420} /* 4E */,
  {-1, 0, 0xB428} /* 4F */,
  {-1, 0, 0xB429} /* 50 */,
  {-1, 0, 0xB42B} /* 51 */,
  {-1, 0, 0xB42C} /* 52 */,
  {-1, 0, 0xB450} /* 53 */,
  {-1, 0, 0xB451} /* 54 */,
  {-1, 0, 0xB454} /* 55 */,
  {-1, 0, 0xB458} /* 56 */,
  {-1, 0, 0xB460} /* 57 */,
  {-1, 0, 0xB461} /* 58 */,
  {-1, 0, 0xB463} /* 59 */,
  {-1, 0, 0xB465} /* 5A */,
  {-1, 0, 0xB46C} /* 5B */,
  {-1, 0, 0xB480} /* 5C */,
  {-1, 0, 0xB488} /* 5D */,
  {-1, 0, 0xB4A4} /* 5E */,
  {-1, 0, 0xB4B7} /* 5F */,
  {-1, 0, 0xB4C0} /* 60 */,
  {-1, 0, 0xB4D0} /* 61 */,
  {-1, 0, 0xB4DC} /* 62 */,
  {-1, 0, 0xB4DD} /* 63 */,
  {-1, 0, 0xB4E0} /* 64 */,
  {-1, 0, 0xB4E3} /* 65 */,
  {-1, 0, 0xB4E4} /* 66 */,
  {-1, 0, 0xB4EC} /* 67 */,
  {-1, 0, 0xB4ED} /* 68 */,
  {-1, 0, 0xB4EF} /* 69 */,
  {-1, 0, 0xB4F1} /* 6A */,
  {-1, 0, 0xB514} /* 6B */,
  {-1, 0, 0xB515} /* 6C */,
  {-1, 0, 0xB518} /* 6D */,
  {-1, 0, 0xB51B} /* 6E */,
  {-1, 0, 0xB51C} /* 6F */,
  {-1, 0, 0xB524} /* 70 */,
  {-1, 0, 0xB525} /* 71 */,
  {-1, 0, 0xB527} /* 72 */,
  {-1, 0, 0xB528} /* 73 */,
  {-1, 0, 0xB529} /* 74 */,
  {-1, 0, 0xB52A} /* 75 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB530} /* 78 */,
  {-1, 0, 0xB531} /* 79 */,
  {-1, 0, 0xB532} /* 7A */,
  {-1, 0, 0xB534} /* 7B */,
  {-1, 0, 0xB537} /* 7C */,
  {-1, 0, 0xB538} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page805 = {
  0, marc8_9page805_dir
};
/* PAGE 804 */
struct yaz_iconv_trie_dir marc8_9page804_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB128} /* 21 */,
  {-1, 0, 0xB12C} /* 22 */,
  {-1, 0, 0xB134} /* 23 */,
  {-1, 0, 0xB135} /* 24 */,
  {-1, 0, 0xB137} /* 25 */,
  {-1, 0, 0xB140} /* 26 */,
  {-1, 0, 0xB141} /* 27 */,
  {-1, 0, 0xB144} /* 28 */,
  {-1, 0, 0xB150} /* 29 */,
  {-1, 0, 0xB151} /* 2A */,
  {-1, 0, 0xB153} /* 2B */,
  {-1, 0, 0xB154} /* 2C */,
  {-1, 0, 0xB155} /* 2D */,
  {-1, 0, 0xB158} /* 2E */,
  {-1, 0, 0xB15C} /* 2F */,
  {-1, 0, 0xB178} /* 30 */,
  {-1, 0, 0xB179} /* 31 */,
  {-1, 0, 0xB17A} /* 32 */,
  {-1, 0, 0xB17C} /* 33 */,
  {-1, 0, 0xB180} /* 34 */,
  {-1, 0, 0xB188} /* 35 */,
  {-1, 0, 0xB189} /* 36 */,
  {-1, 0, 0xB18B} /* 37 */,
  {-1, 0, 0xB18D} /* 38 */,
  {-1, 0, 0xB192} /* 39 */,
  {-1, 0, 0xB193} /* 3A */,
  {-1, 0, 0xB194} /* 3B */,
  {-1, 0, 0xB1A8} /* 3C */,
  {-1, 0, 0xB1CC} /* 3D */,
  {-1, 0, 0xB1D0} /* 3E */,
  {-1, 0, 0xB1D4} /* 3F */,
  {-1, 0, 0xB1DC} /* 40 */,
  {-1, 0, 0xB1E8} /* 41 */,
  {-1, 0, 0xB1FD} /* 42 */,
  {-1, 0, 0xB204} /* 43 */,
  {-1, 0, 0xB205} /* 44 */,
  {-1, 0, 0xB208} /* 45 */,
  {-1, 0, 0xB20B} /* 46 */,
  {-1, 0, 0xB20C} /* 47 */,
  {-1, 0, 0xB213} /* 48 */,
  {-1, 0, 0xB214} /* 49 */,
  {-1, 0, 0xB215} /* 4A */,
  {-1, 0, 0xB217} /* 4B */,
  {-1, 0, 0xB220} /* 4C */,
  {-1, 0, 0xB233} /* 4D */,
  {-1, 0, 0xB234} /* 4E */,
  {-1, 0, 0xB258} /* 4F */,
  {-1, 0, 0xB25C} /* 50 */,
  {-1, 0, 0xB260} /* 51 */,
  {-1, 0, 0xB268} /* 52 */,
  {-1, 0, 0xB269} /* 53 */,
  {-1, 0, 0xB274} /* 54 */,
  {-1, 0, 0xB284} /* 55 */,
  {-1, 0, 0xB289} /* 56 */,
  {-1, 0, 0xB290} /* 57 */,
  {-1, 0, 0xB291} /* 58 */,
  {-1, 0, 0xB294} /* 59 */,
  {-1, 0, 0xB298} /* 5A */,
  {-1, 0, 0xB299} /* 5B */,
  {-1, 0, 0xB2A0} /* 5C */,
  {-1, 0, 0xB2A1} /* 5D */,
  {-1, 0, 0xB2A5} /* 5E */,
  {-1, 0, 0xB2A6} /* 5F */,
  {-1, 0, 0xB2AA} /* 60 */,
  {-1, 0, 0xB2AC} /* 61 */,
  {-1, 0, 0xB2C8} /* 62 */,
  {-1, 0, 0xB2C9} /* 63 */,
  {-1, 0, 0xB2CC} /* 64 */,
  {-1, 0, 0xB2D0} /* 65 */,
  {-1, 0, 0xB2D8} /* 66 */,
  {-1, 0, 0xB2D9} /* 67 */,
  {-1, 0, 0xB2DB} /* 68 */,
  {-1, 0, 0xB2DD} /* 69 */,
  {-1, 0, 0xB2E2} /* 6A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB2E4} /* 6D */,
  {-1, 0, 0xB2E5} /* 6E */,
  {-1, 0, 0xB2E6} /* 6F */,
  {-1, 0, 0xB2E8} /* 70 */,
  {-1, 0, 0xB2EB} /* 71 */,
  {-1, 0, 0xB2EC} /* 72 */,
  {-1, 0, 0xB2ED} /* 73 */,
  {-1, 0, 0xB2EE} /* 74 */,
  {-1, 0, 0xB2F3} /* 75 */,
  {-1, 0, 0xB2F4} /* 76 */,
  {-1, 0, 0xB2F5} /* 77 */,
  {-1, 0, 0xB2F7} /* 78 */,
  {-1, 0, 0xB2F9} /* 79 */,
  {-1, 0, 0xB2FA} /* 7A */,
  {-1, 0, 0xB2FB} /* 7B */,
  {-1, 0, 0xB2FF} /* 7C */,
  {-1, 0, 0xB300} /* 7D */,
  {-1, 0, 0xB301} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page804 = {
  0, marc8_9page804_dir
};
/* PAGE 803 */
struct yaz_iconv_trie_dir marc8_9page803_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xAF9C} /* 21 */,
  {-1, 0, 0xAFB8} /* 22 */,
  {-1, 0, 0xAFB9} /* 23 */,
  {-1, 0, 0xAFBC} /* 24 */,
  {-1, 0, 0xAFC0} /* 25 */,
  {-1, 0, 0xAFC7} /* 26 */,
  {-1, 0, 0xAFC8} /* 27 */,
  {-1, 0, 0xAFC9} /* 28 */,
  {-1, 0, 0xAFCB} /* 29 */,
  {-1, 0, 0xAFCD} /* 2A */,
  {-1, 0, 0xAFCE} /* 2B */,
  {-1, 0, 0xAFD4} /* 2C */,
  {-1, 0, 0xAFD8} /* 2D */,
  {-1, 0, 0xAFE9} /* 2E */,
  {-1, 0, 0xAFF0} /* 2F */,
  {-1, 0, 0xB000} /* 30 */,
  {-1, 0, 0},
  {-1, 0, 0xB00C} /* 32 */,
  {-1, 0, 0xB00D} /* 33 */,
  {-1, 0, 0xB010} /* 34 */,
  {-1, 0, 0xB014} /* 35 */,
  {-1, 0, 0xB01C} /* 36 */,
  {-1, 0, 0xB01D} /* 37 */,
  {-1, 0, 0xB028} /* 38 */,
  {-1, 0, 0xB044} /* 39 */,
  {-1, 0, 0xB045} /* 3A */,
  {-1, 0, 0xB048} /* 3B */,
  {-1, 0, 0xB04A} /* 3C */,
  {-1, 0, 0xB04C} /* 3D */,
  {-1, 0, 0xB053} /* 3E */,
  {-1, 0, 0xB054} /* 3F */,
  {-1, 0, 0xB055} /* 40 */,
  {-1, 0, 0xB057} /* 41 */,
  {-1, 0, 0xB059} /* 42 */,
  {-1, 0, 0xB05D} /* 43 */,
  {-1, 0, 0xB07C} /* 44 */,
  {-1, 0, 0xB07D} /* 45 */,
  {-1, 0, 0xB080} /* 46 */,
  {-1, 0, 0xB084} /* 47 */,
  {-1, 0, 0xB08C} /* 48 */,
  {-1, 0, 0xB08D} /* 49 */,
  {-1, 0, 0xB08F} /* 4A */,
  {-1, 0, 0xB090} /* 4B */,
  {-1, 0, 0xB091} /* 4C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xB098} /* 4F */,
  {-1, 0, 0xB099} /* 50 */,
  {-1, 0, 0xB09A} /* 51 */,
  {-1, 0, 0xB09C} /* 52 */,
  {-1, 0, 0xB09F} /* 53 */,
  {-1, 0, 0xB0A0} /* 54 */,
  {-1, 0, 0xB0A1} /* 55 */,
  {-1, 0, 0xB0A8} /* 56 */,
  {-1, 0, 0xB0A9} /* 57 */,
  {-1, 0, 0xB0AB} /* 58 */,
  {-1, 0, 0xB0AC} /* 59 */,
  {-1, 0, 0xB0AD} /* 5A */,
  {-1, 0, 0xB0AE} /* 5B */,
  {-1, 0, 0xB0AF} /* 5C */,
  {-1, 0, 0xB0B1} /* 5D */,
  {-1, 0, 0xB0B3} /* 5E */,
  {-1, 0, 0xB0B4} /* 5F */,
  {-1, 0, 0xB0B5} /* 60 */,
  {-1, 0, 0xB0B8} /* 61 */,
  {-1, 0, 0xB0BB} /* 62 */,
  {-1, 0, 0xB0BC} /* 63 */,
  {-1, 0, 0xB0C4} /* 64 */,
  {-1, 0, 0xB0C5} /* 65 */,
  {-1, 0, 0xB0C7} /* 66 */,
  {-1, 0, 0xB0C8} /* 67 */,
  {-1, 0, 0xB0C9} /* 68 */,
  {-1, 0, 0xB0D0} /* 69 */,
  {-1, 0, 0xB0D1} /* 6A */,
  {-1, 0, 0xB0E0} /* 6B */,
  {-1, 0, 0xB0E5} /* 6C */,
  {-1, 0, 0xB0EC} /* 6D */,
  {-1, 0, 0xB108} /* 6E */,
  {-1, 0, 0xB109} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0xB10B} /* 71 */,
  {-1, 0, 0xB10C} /* 72 */,
  {-1, 0, 0xB10F} /* 73 */,
  {-1, 0, 0xB110} /* 74 */,
  {-1, 0, 0xB113} /* 75 */,
  {-1, 0, 0xB118} /* 76 */,
  {-1, 0, 0xB119} /* 77 */,
  {-1, 0, 0xB11B} /* 78 */,
  {-1, 0, 0xB11C} /* 79 */,
  {-1, 0, 0xB11D} /* 7A */,
  {-1, 0, 0xB11E} /* 7B */,
  {-1, 0, 0xB123} /* 7C */,
  {-1, 0, 0xB124} /* 7D */,
  {-1, 0, 0xB125} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page803 = {
  0, marc8_9page803_dir
};
/* PAGE 802 */
struct yaz_iconv_trie_dir marc8_9page802_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xADC0} /* 22 */,
  {-1, 0, 0xADC4} /* 23 */,
  {-1, 0, 0xADC8} /* 24 */,
  {-1, 0, 0xADD0} /* 25 */,
  {-1, 0, 0xADD1} /* 26 */,
  {-1, 0, 0xADD3} /* 27 */,
  {-1, 0, 0xADDC} /* 28 */,
  {-1, 0, 0xADE0} /* 29 */,
  {-1, 0, 0xADE4} /* 2A */,
  {-1, 0, 0xADEC} /* 2B */,
  {-1, 0, 0xADF8} /* 2C */,
  {-1, 0, 0xADF9} /* 2D */,
  {-1, 0, 0xADFC} /* 2E */,
  {-1, 0, 0xADFF} /* 2F */,
  {-1, 0, 0xAE00} /* 30 */,
  {-1, 0, 0xAE01} /* 31 */,
  {-1, 0, 0xAE08} /* 32 */,
  {-1, 0, 0xAE09} /* 33 */,
  {-1, 0, 0xAE0B} /* 34 */,
  {-1, 0, 0xAE0D} /* 35 */,
  {-1, 0, 0xAE30} /* 36 */,
  {-1, 0, 0xAE31} /* 37 */,
  {-1, 0, 0xAE34} /* 38 */,
  {-1, 0, 0xAE37} /* 39 */,
  {-1, 0, 0xAE38} /* 3A */,
  {-1, 0, 0xAE40} /* 3B */,
  {-1, 0, 0xAE41} /* 3C */,
  {-1, 0, 0xAE43} /* 3D */,
  {-1, 0, 0xAE44} /* 3E */,
  {-1, 0, 0xAE45} /* 3F */,
  {-1, 0, 0xAE4A} /* 40 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xAE4C} /* 43 */,
  {-1, 0, 0xAE4D} /* 44 */,
  {-1, 0, 0xAE4E} /* 45 */,
  {-1, 0, 0xAE50} /* 46 */,
  {-1, 0, 0xAE54} /* 47 */,
  {-1, 0, 0xAE5C} /* 48 */,
  {-1, 0, 0xAE5D} /* 49 */,
  {-1, 0, 0xAE60} /* 4A */,
  {-1, 0, 0xAE61} /* 4B */,
  {-1, 0, 0xAE62} /* 4C */,
  {-1, 0, 0xAE65} /* 4D */,
  {-1, 0, 0xAE68} /* 4E */,
  {-1, 0, 0xAE69} /* 4F */,
  {-1, 0, 0xAE6C} /* 50 */,
  {-1, 0, 0xAE70} /* 51 */,
  {-1, 0, 0xAE78} /* 52 */,
  {-1, 0, 0xAE79} /* 53 */,
  {-1, 0, 0xAE7B} /* 54 */,
  {-1, 0, 0xAE7C} /* 55 */,
  {-1, 0, 0xAE7D} /* 56 */,
  {-1, 0, 0xAE84} /* 57 */,
  {-1, 0, 0xAE85} /* 58 */,
  {-1, 0, 0xAEBC} /* 59 */,
  {-1, 0, 0xAEBD} /* 5A */,
  {-1, 0, 0xAEBE} /* 5B */,
  {-1, 0, 0xAEC0} /* 5C */,
  {-1, 0, 0xAEC4} /* 5D */,
  {-1, 0, 0xAECC} /* 5E */,
  {-1, 0, 0xAECD} /* 5F */,
  {-1, 0, 0xAECF} /* 60 */,
  {-1, 0, 0xAED0} /* 61 */,
  {-1, 0, 0xAED1} /* 62 */,
  {-1, 0, 0xAED8} /* 63 */,
  {-1, 0, 0xAEDC} /* 64 */,
  {-1, 0, 0xAEF4} /* 65 */,
  {-1, 0, 0xAF0D} /* 66 */,
  {-1, 0, 0xAF2C} /* 67 */,
  {-1, 0, 0xAF2D} /* 68 */,
  {-1, 0, 0xAF30} /* 69 */,
  {-1, 0, 0xAF34} /* 6A */,
  {-1, 0, 0xAF3C} /* 6B */,
  {-1, 0, 0xAF3D} /* 6C */,
  {-1, 0, 0xAF3F} /* 6D */,
  {-1, 0, 0xAF41} /* 6E */,
  {-1, 0, 0xAF42} /* 6F */,
  {-1, 0, 0xAF43} /* 70 */,
  {-1, 0, 0xAF48} /* 71 */,
  {-1, 0, 0xAF49} /* 72 */,
  {-1, 0, 0xAF4C} /* 73 */,
  {-1, 0, 0xAF58} /* 74 */,
  {-1, 0, 0xAF5C} /* 75 */,
  {-1, 0, 0xAF5D} /* 76 */,
  {-1, 0, 0xAF64} /* 77 */,
  {-1, 0, 0xAF65} /* 78 */,
  {-1, 0, 0xAF79} /* 79 */,
  {-1, 0, 0xAF80} /* 7A */,
  {-1, 0, 0xAF84} /* 7B */,
  {-1, 0, 0xAF88} /* 7C */,
  {-1, 0, 0xAF90} /* 7D */,
  {-1, 0, 0xAF95} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page802 = {
  0, marc8_9page802_dir
};
/* PAGE 801 */
struct yaz_iconv_trie_dir marc8_9page801_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xAC70} /* 21 */,
  {-1, 0, 0xAC71} /* 22 */,
  {-1, 0, 0},
  {-1, 0, 0xAC74} /* 24 */,
  {-1, 0, 0xAC77} /* 25 */,
  {-1, 0, 0xAC78} /* 26 */,
  {-1, 0, 0xAC79} /* 27 */,
  {-1, 0, 0},
  {-1, 0, 0xAC80} /* 29 */,
  {-1, 0, 0xAC81} /* 2A */,
  {-1, 0, 0xAC83} /* 2B */,
  {-1, 0, 0xAC84} /* 2C */,
  {-1, 0, 0xAC85} /* 2D */,
  {-1, 0, 0xAC86} /* 2E */,
  {-1, 0, 0},
  {-1, 0, 0xAC89} /* 30 */,
  {-1, 0, 0xAC8A} /* 31 */,
  {-1, 0, 0xAC8B} /* 32 */,
  {-1, 0, 0xAC8C} /* 33 */,
  {-1, 0, 0xAC90} /* 34 */,
  {-1, 0, 0xAC94} /* 35 */,
  {-1, 0, 0xAC9C} /* 36 */,
  {-1, 0, 0xAC9F} /* 37 */,
  {-1, 0, 0xACA0} /* 38 */,
  {-1, 0, 0xACA1} /* 39 */,
  {-1, 0, 0xACA8} /* 3A */,
  {-1, 0, 0xACA9} /* 3B */,
  {-1, 0, 0xACAA} /* 3C */,
  {-1, 0, 0xACAC} /* 3D */,
  {-1, 0, 0xACAF} /* 3E */,
  {-1, 0, 0xACB0} /* 3F */,
  {-1, 0, 0xACB8} /* 40 */,
  {-1, 0, 0xACB9} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0xACBC} /* 43 */,
  {-1, 0, 0xACBD} /* 44 */,
  {-1, 0, 0xACC1} /* 45 */,
  {-1, 0, 0},
  {-1, 0, 0xACC4} /* 47 */,
  {-1, 0, 0},
  {-1, 0, 0xACD7} /* 49 */,
  {-1, 0, 0xACE0} /* 4A */,
  {-1, 0, 0xACE1} /* 4B */,
  {-1, 0, 0xACE4} /* 4C */,
  {-1, 0, 0xACE7} /* 4D */,
  {-1, 0, 0xACE8} /* 4E */,
  {-1, 0, 0xACEA} /* 4F */,
  {-1, 0, 0xACEC} /* 50 */,
  {-1, 0, 0xACEF} /* 51 */,
  {-1, 0, 0xACF0} /* 52 */,
  {-1, 0, 0xACF1} /* 53 */,
  {-1, 0, 0xACF3} /* 54 */,
  {-1, 0, 0xACF5} /* 55 */,
  {-1, 0, 0xACF6} /* 56 */,
  {-1, 0, 0xACFA} /* 57 */,
  {-1, 0, 0xACFC} /* 58 */,
  {-1, 0, 0xACFD} /* 59 */,
  {-1, 0, 0xAD00} /* 5A */,
  {-1, 0, 0xAD04} /* 5B */,
  {-1, 0, 0xAD0C} /* 5C */,
  {-1, 0, 0xAD0D} /* 5D */,
  {-1, 0, 0xAD0F} /* 5E */,
  {-1, 0, 0xAD11} /* 5F */,
  {-1, 0, 0xAD18} /* 60 */,
  {-1, 0, 0xAD19} /* 61 */,
  {-1, 0, 0xAD1C} /* 62 */,
  {-1, 0, 0xAD20} /* 63 */,
  {-1, 0, 0xAD28} /* 64 */,
  {-1, 0, 0xAD29} /* 65 */,
  {-1, 0, 0xAD2D} /* 66 */,
  {-1, 0, 0xAD34} /* 67 */,
  {-1, 0, 0xAD38} /* 68 */,
  {-1, 0, 0xAD3C} /* 69 */,
  {-1, 0, 0xAD44} /* 6A */,
  {-1, 0, 0},
  {-1, 0, 0xAD49} /* 6C */,
  {-1, 0, 0xAD50} /* 6D */,
  {-1, 0, 0xAD6C} /* 6E */,
  {-1, 0, 0xAD6D} /* 6F */,
  {-1, 0, 0xAD70} /* 70 */,
  {-1, 0, 0xAD73} /* 71 */,
  {-1, 0, 0xAD74} /* 72 */,
  {-1, 0, 0xAD75} /* 73 */,
  {-1, 0, 0xAD76} /* 74 */,
  {-1, 0, 0xAD7C} /* 75 */,
  {-1, 0, 0xAD7D} /* 76 */,
  {-1, 0, 0xAD7F} /* 77 */,
  {-1, 0, 0xAD81} /* 78 */,
  {-1, 0, 0xAD82} /* 79 */,
  {-1, 0, 0xAD88} /* 7A */,
  {-1, 0, 0xAD8C} /* 7B */,
  {-1, 0, 0xAD90} /* 7C */,
  {-1, 0, 0},
  {-1, 0, 0xADA4} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page801 = {
  0, marc8_9page801_dir
};
/* PAGE 800 */
struct yaz_iconv_trie_flat marc8_9page800_flat[] = {
  {"\x5F", 0, 0xAC00},
  {"\x60", 0, 0xAC01},
  {"\x61", 0, 0xAC02},
  {"\x62", 0, 0xAC04},
  {"\x63", 0, 0xAC07},
  {"\x64", 0, 0xAC08},
  {"\x65", 0, 0xAC09},
  {"\x66", 0, 0xAC10},
  {"\x67", 0, 0xAC11},
  {"\x68", 0, 0xAC12},
  {"\x69", 0, 0xAC13},
  {"\x6A", 0, 0xAC14},
  {"\x6B", 0, 0xAC15},
  {"\x6C", 0, 0xAC16},
  {"\x6D", 0, 0xAC17},
  {"\x6E", 0, 0xAC19},
  {"\x6F", 0, 0xAC1A},
  {"\x70", 0, 0xAC1B},
  {"\x70", 0, 0xAC1B},
  {"\x71", 0, 0xAC1C},
  {"\x72", 0, 0xAC1D},
  {"\x73", 0, 0xAC20},
  {"\x75", 0, 0xAC24},
  {"\x76", 0, 0xAC2C},
  {"\x77", 0, 0xAC2D},
  {"\x78", 0, 0xAC2F},
  {"\x79", 0, 0xAC30},
  {"\x7A", 0, 0xAC31},
  {"\x7B", 0, 0xAC38},
  {"\x7C", 0, 0xAC39},
  {"\x7D", 0, 0xAC40},
  {"\x7E", 0, 0xAC54},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page800 = {
  marc8_9page800_flat, 0
};
/* PAGE 799 */
struct yaz_iconv_trie_flat marc8_9page799_flat[] = {
  {"\x21", 0, 0x315C},
  {"\x25", 0, 0x3160},
  {"\x26", 0, 0x3161},
  {"\x27", 0, 0x3162},
  {"\x28", 0, 0x3163},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page799 = {
  marc8_9page799_flat, 0
};
/* PAGE 798 */
struct yaz_iconv_trie_flat marc8_9page798_flat[] = {
  {"\x57", 0, 0x3131},
  {"\x58", 0, 0x3134},
  {"\x59", 0, 0x3137},
  {"\x5A", 0, 0x3139},
  {"\x5B", 0, 0x3141},
  {"\x5C", 0, 0x3142},
  {"\x5D", 0, 0x3145},
  {"\x5E", 0, 0x3147},
  {"\x5F", 0, 0x3148},
  {"\x60", 0, 0x314A},
  {"\x61", 0, 0x314B},
  {"\x62", 0, 0x314C},
  {"\x63", 0, 0x314D},
  {"\x64", 0, 0x314E},
  {"\x65", 0, 0x3132},
  {"\x69", 0, 0x3138},
  {"\x6E", 0, 0x3143},
  {"\x70", 0, 0x3146},
  {"\x71", 0, 0x3149},
  {"\x72", 0, 0x314F},
  {"\x73", 0, 0x3150},
  {"\x74", 0, 0x3151},
  {"\x76", 0, 0x3153},
  {"\x77", 0, 0x3154},
  {"\x78", 0, 0x3155},
  {"\x7A", 0, 0x3157},
  {"\x7B", 0, 0x3158},
  {"\x7E", 0, 0x315B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page798 = {
  marc8_9page798_flat, 0
};
/* PAGE 797 */
struct yaz_iconv_trie_dir marc8_9page797_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {798, 0, 0} /* 24 */,
  {799, 0, 0} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {800, 0, 0} /* 48 */,
  {801, 0, 0} /* 49 */,
  {802, 0, 0} /* 4A */,
  {803, 0, 0} /* 4B */,
  {804, 0, 0} /* 4C */,
  {805, 0, 0} /* 4D */,
  {806, 0, 0} /* 4E */,
  {807, 0, 0} /* 4F */,
  {808, 0, 0} /* 50 */,
  {809, 0, 0} /* 51 */,
  {810, 0, 0} /* 52 */,
  {811, 0, 0} /* 53 */,
  {812, 0, 0} /* 54 */,
  {813, 0, 0} /* 55 */,
  {814, 0, 0} /* 56 */,
  {815, 0, 0} /* 57 */,
  {816, 0, 0} /* 58 */,
  {817, 0, 0} /* 59 */,
  {818, 0, 0} /* 5A */,
  {819, 0, 0} /* 5B */,
  {820, 0, 0} /* 5C */,
  {821, 0, 0} /* 5D */,
  {822, 0, 0} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {823, 0, 0} /* 76 */,
  {824, 0, 0} /* 77 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page797 = {
  0, marc8_9page797_dir
};
/* PAGE 796 */
struct yaz_iconv_trie_dir marc8_9page796_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x30A1} /* 21 */,
  {-1, 0, 0x30A2} /* 22 */,
  {-1, 0, 0x30A3} /* 23 */,
  {-1, 0, 0x30A4} /* 24 */,
  {-1, 0, 0x30A5} /* 25 */,
  {-1, 0, 0x30A6} /* 26 */,
  {-1, 0, 0x30A7} /* 27 */,
  {-1, 0, 0x30A8} /* 28 */,
  {-1, 0, 0x30A9} /* 29 */,
  {-1, 0, 0x30AA} /* 2A */,
  {-1, 0, 0x30AB} /* 2B */,
  {-1, 0, 0x30AC} /* 2C */,
  {-1, 0, 0x30AD} /* 2D */,
  {-1, 0, 0x30AE} /* 2E */,
  {-1, 0, 0x30AF} /* 2F */,
  {-1, 0, 0x30B0} /* 30 */,
  {-1, 0, 0x30B1} /* 31 */,
  {-1, 0, 0x30B2} /* 32 */,
  {-1, 0, 0x30B3} /* 33 */,
  {-1, 0, 0x30B4} /* 34 */,
  {-1, 0, 0x30B5} /* 35 */,
  {-1, 0, 0x30B6} /* 36 */,
  {-1, 0, 0x30B7} /* 37 */,
  {-1, 0, 0x30B8} /* 38 */,
  {-1, 0, 0x30B9} /* 39 */,
  {-1, 0, 0x30BA} /* 3A */,
  {-1, 0, 0x30BB} /* 3B */,
  {-1, 0, 0x30BC} /* 3C */,
  {-1, 0, 0x30BD} /* 3D */,
  {-1, 0, 0x30BE} /* 3E */,
  {-1, 0, 0x30BF} /* 3F */,
  {-1, 0, 0x30C0} /* 40 */,
  {-1, 0, 0x30C1} /* 41 */,
  {-1, 0, 0x30C2} /* 42 */,
  {-1, 0, 0x30C3} /* 43 */,
  {-1, 0, 0x30C4} /* 44 */,
  {-1, 0, 0x30C5} /* 45 */,
  {-1, 0, 0x30C6} /* 46 */,
  {-1, 0, 0x30C7} /* 47 */,
  {-1, 0, 0x30C8} /* 48 */,
  {-1, 0, 0x30C9} /* 49 */,
  {-1, 0, 0x30CA} /* 4A */,
  {-1, 0, 0x30CB} /* 4B */,
  {-1, 0, 0x30CC} /* 4C */,
  {-1, 0, 0x30CD} /* 4D */,
  {-1, 0, 0x30CE} /* 4E */,
  {-1, 0, 0x30CF} /* 4F */,
  {-1, 0, 0x30D0} /* 50 */,
  {-1, 0, 0x30D1} /* 51 */,
  {-1, 0, 0x30D2} /* 52 */,
  {-1, 0, 0x30D3} /* 53 */,
  {-1, 0, 0x30D4} /* 54 */,
  {-1, 0, 0x30D5} /* 55 */,
  {-1, 0, 0x30D6} /* 56 */,
  {-1, 0, 0x30D7} /* 57 */,
  {-1, 0, 0x30D8} /* 58 */,
  {-1, 0, 0x30D9} /* 59 */,
  {-1, 0, 0x30DA} /* 5A */,
  {-1, 0, 0x30DB} /* 5B */,
  {-1, 0, 0x30DC} /* 5C */,
  {-1, 0, 0x30DD} /* 5D */,
  {-1, 0, 0x30DE} /* 5E */,
  {-1, 0, 0x30DF} /* 5F */,
  {-1, 0, 0x30E0} /* 60 */,
  {-1, 0, 0x30E1} /* 61 */,
  {-1, 0, 0x30E2} /* 62 */,
  {-1, 0, 0x30E3} /* 63 */,
  {-1, 0, 0x30E4} /* 64 */,
  {-1, 0, 0x30E5} /* 65 */,
  {-1, 0, 0x30E6} /* 66 */,
  {-1, 0, 0x30E7} /* 67 */,
  {-1, 0, 0x30E8} /* 68 */,
  {-1, 0, 0x30E9} /* 69 */,
  {-1, 0, 0x30EA} /* 6A */,
  {-1, 0, 0x30EB} /* 6B */,
  {-1, 0, 0x30EC} /* 6C */,
  {-1, 0, 0x30ED} /* 6D */,
  {-1, 0, 0x30EE} /* 6E */,
  {-1, 0, 0x30EF} /* 6F */,
  {-1, 0, 0x30F0} /* 70 */,
  {-1, 0, 0x30F1} /* 71 */,
  {-1, 0, 0x30F2} /* 72 */,
  {-1, 0, 0x30F3} /* 73 */,
  {-1, 0, 0x30F4} /* 74 */,
  {-1, 0, 0x30F5} /* 75 */,
  {-1, 0, 0x30F6} /* 76 */,
  {-1, 0, 0x309B} /* 77 */,
  {-1, 0, 0x309C} /* 78 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page796 = {
  0, marc8_9page796_dir
};
/* PAGE 795 */
struct yaz_iconv_trie_dir marc8_9page795_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x3041} /* 21 */,
  {-1, 0, 0x3042} /* 22 */,
  {-1, 0, 0x3043} /* 23 */,
  {-1, 0, 0x3044} /* 24 */,
  {-1, 0, 0x3045} /* 25 */,
  {-1, 0, 0x3046} /* 26 */,
  {-1, 0, 0x3047} /* 27 */,
  {-1, 0, 0x3048} /* 28 */,
  {-1, 0, 0x3049} /* 29 */,
  {-1, 0, 0x304A} /* 2A */,
  {-1, 0, 0x304B} /* 2B */,
  {-1, 0, 0x304C} /* 2C */,
  {-1, 0, 0x304D} /* 2D */,
  {-1, 0, 0x304E} /* 2E */,
  {-1, 0, 0x304F} /* 2F */,
  {-1, 0, 0x3050} /* 30 */,
  {-1, 0, 0x3051} /* 31 */,
  {-1, 0, 0x3052} /* 32 */,
  {-1, 0, 0x3053} /* 33 */,
  {-1, 0, 0x3054} /* 34 */,
  {-1, 0, 0x3055} /* 35 */,
  {-1, 0, 0x3056} /* 36 */,
  {-1, 0, 0x3057} /* 37 */,
  {-1, 0, 0x3058} /* 38 */,
  {-1, 0, 0x3059} /* 39 */,
  {-1, 0, 0x305A} /* 3A */,
  {-1, 0, 0x305B} /* 3B */,
  {-1, 0, 0x305C} /* 3C */,
  {-1, 0, 0x305D} /* 3D */,
  {-1, 0, 0x305E} /* 3E */,
  {-1, 0, 0x305F} /* 3F */,
  {-1, 0, 0x3060} /* 40 */,
  {-1, 0, 0x3061} /* 41 */,
  {-1, 0, 0x3062} /* 42 */,
  {-1, 0, 0x3063} /* 43 */,
  {-1, 0, 0x3064} /* 44 */,
  {-1, 0, 0x3065} /* 45 */,
  {-1, 0, 0x3066} /* 46 */,
  {-1, 0, 0x3067} /* 47 */,
  {-1, 0, 0x3068} /* 48 */,
  {-1, 0, 0x3069} /* 49 */,
  {-1, 0, 0x306A} /* 4A */,
  {-1, 0, 0x306B} /* 4B */,
  {-1, 0, 0x306C} /* 4C */,
  {-1, 0, 0x306D} /* 4D */,
  {-1, 0, 0x306E} /* 4E */,
  {-1, 0, 0x306F} /* 4F */,
  {-1, 0, 0x3070} /* 50 */,
  {-1, 0, 0x3071} /* 51 */,
  {-1, 0, 0x3072} /* 52 */,
  {-1, 0, 0x3073} /* 53 */,
  {-1, 0, 0x3074} /* 54 */,
  {-1, 0, 0x3075} /* 55 */,
  {-1, 0, 0x3076} /* 56 */,
  {-1, 0, 0x3077} /* 57 */,
  {-1, 0, 0x3078} /* 58 */,
  {-1, 0, 0x3079} /* 59 */,
  {-1, 0, 0x307A} /* 5A */,
  {-1, 0, 0x307B} /* 5B */,
  {-1, 0, 0x307C} /* 5C */,
  {-1, 0, 0x307D} /* 5D */,
  {-1, 0, 0x307E} /* 5E */,
  {-1, 0, 0x307F} /* 5F */,
  {-1, 0, 0x3080} /* 60 */,
  {-1, 0, 0x3081} /* 61 */,
  {-1, 0, 0x3082} /* 62 */,
  {-1, 0, 0x3083} /* 63 */,
  {-1, 0, 0x3084} /* 64 */,
  {-1, 0, 0x3085} /* 65 */,
  {-1, 0, 0x3086} /* 66 */,
  {-1, 0, 0x3087} /* 67 */,
  {-1, 0, 0x3088} /* 68 */,
  {-1, 0, 0x3089} /* 69 */,
  {-1, 0, 0x308A} /* 6A */,
  {-1, 0, 0x308B} /* 6B */,
  {-1, 0, 0x308C} /* 6C */,
  {-1, 0, 0x308D} /* 6D */,
  {-1, 0, 0x308E} /* 6E */,
  {-1, 0, 0x308F} /* 6F */,
  {-1, 0, 0x3090} /* 70 */,
  {-1, 0, 0x3091} /* 71 */,
  {-1, 0, 0x3092} /* 72 */,
  {-1, 0, 0x3093} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page795 = {
  0, marc8_9page795_dir
};
/* PAGE 794 */
struct yaz_iconv_trie_flat marc8_9page794_flat[] = {
  {"\x3C", 0, 0x30FC},
  {"\x26", 0, 0x30FB},
  {"\x39", 0, 0x3005},
  {"\x52", 0, 0x3008},
  {"\x53", 0, 0x3009},
  {"\x54", 0, 0x300A},
  {"\x55", 0, 0x300B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page794 = {
  marc8_9page794_flat, 0
};
/* PAGE 793 */
struct yaz_iconv_trie_flat marc8_9page793_flat[] = {
  {"\x4C\x2A", 0, 0x915E},
  {"\x58\x6F", 0, 0x4EEB},
  {"\x5B\x71", 0, 0x57B4},
  {"\x5C\x43", 0, 0x82CA},
  {"\x5C\x50", 0, 0x82C4},
  {"\x5D\x46", 0, 0x841C},
  {"\x5D\x5C", 0, 0x8488},
  {"\x5F\x30", 0, 0x7519},
  {"\x5F\x39", 0, 0x5416},
  {"\x5F\x50", 0, 0x549D},
  {"\x5F\x51", 0, 0x54D0},
  {"\x5F\x54", 0, 0x54B4},
  {"\x5F\x5B", 0, 0x54A3},
  {"\x5F\x61", 0, 0x54DA},
  {"\x60\x2D", 0, 0x55B9},
  {"\x60\x3A", 0, 0x55EA},
  {"\x60\x4C", 0, 0x55F5},
  {"\x60\x54", 0, 0x5623},
  {"\x60\x58", 0, 0x562D},
  {"\x60\x67", 0, 0x567B},
  {"\x61\x31", 0, 0x5C9C},
  {"\x62\x2A", 0, 0x7339},
  {"\x62\x47", 0, 0x9987},
  {"\x62\x4E", 0, 0x9995},
  {"\x63\x40", 0, 0x61B7},
  {"\x66\x40", 0, 0x80EC},
  {"\x6B\x42", 0, 0x80BC},
  {"\x6B\x44", 0, 0x80BD},
  {"\x6B\x4C", 0, 0x80E9},
  {"\x6B\x5B", 0, 0x810E},
  {"\x6B\x5F", 0, 0x8112},
  {"\x6B\x6A", 0, 0x8159},
  {"\x6C\x42", 0, 0x70BB},
  {"\x6C\x43", 0, 0x70C0},
  {"\x6D\x3B", 0, 0x7818},
  {"\x6D\x3F", 0, 0x781C},
  {"\x6D\x45", 0, 0x783C},
  {"\x72\x7D", 0, 0x87A8},
  {"\x73\x60", 0, 0x7B7B},
  {"\x73\x6E", 0, 0x7BA2},
  {"\x74\x38", 0, 0x823E},
  {"\x75\x23", 0, 0x9170},
  {"\x75\x5D", 0, 0x8E3A},
  {"\x77\x5D", 0, 0x9B0F},
  {"\x77\x71", 0, 0x9EE2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page793 = {
  marc8_9page793_flat, 0
};
/* PAGE 792 */
struct yaz_iconv_trie_flat marc8_9page792_flat[] = {
  {"\x23", 0, 0x9D64},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page792 = {
  marc8_9page792_flat, 0
};
/* PAGE 791 */
struct yaz_iconv_trie_flat marc8_9page791_flat[] = {
  {"\x3B", 0, 0x9B96},
  {"\x40", 0, 0x9BB4},
  {"\x45", 0, 0x9BCF},
  {"\x46", 0, 0x9BD1},
  {"\x4E", 0, 0x9BF2},
  {"\x60", 0, 0x9C30},
  {"\x65", 0, 0x9C5A},
  {"\x7E", 0, 0x9D48},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page791 = {
  marc8_9page791_flat, 0
};
/* PAGE 790 */
struct yaz_iconv_trie_flat marc8_9page790_flat[] = {
  {"\x24", 0, 0x98AA},
  {"\x52", 0, 0x99F2},
  {"\x74", 0, 0x9ADE},
  {"\x7D", 0, 0x9AF1},
  {"\x7E", 0, 0x9AF7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page790 = {
  marc8_9page790_flat, 0
};
/* PAGE 789 */
struct yaz_iconv_trie_flat marc8_9page789_flat[] = {
  {"\x23", 0, 0x9666},
  {"\x58", 0, 0x9779},
  {"\x5D", 0, 0x9786},
  {"\x60", 0, 0x9790},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page789 = {
  marc8_9page789_flat, 0
};
/* PAGE 788 */
struct yaz_iconv_trie_flat marc8_9page788_flat[] = {
  {"\x27", 0, 0x933B},
  {"\x5B", 0, 0x958A},
  {"\x5D", 0, 0x9596},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page788 = {
  marc8_9page788_flat, 0
};
/* PAGE 787 */
struct yaz_iconv_trie_flat marc8_9page787_flat[] = {
  {"\x28", 0, 0x9056},
  {"\x5C", 0, 0x91DF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page787 = {
  marc8_9page787_flat, 0
};
/* PAGE 786 */
struct yaz_iconv_trie_flat marc8_9page786_flat[] = {
  {"\x3F", 0, 0x8EBE},
  {"\x40", 0, 0x8EC5},
  {"\x41", 0, 0x8EC8},
  {"\x5A", 0, 0x8F4C},
  {"\x7A", 0, 0x9027},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page786 = {
  marc8_9page786_flat, 0
};
/* PAGE 785 */
struct yaz_iconv_trie_flat marc8_9page785_flat[] = {
  {"\x27", 0, 0x8977},
  {"\x5C", 0, 0x8ADA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page785 = {
  marc8_9page785_flat, 0
};
/* PAGE 784 */
struct yaz_iconv_trie_flat marc8_9page784_flat[] = {
  {"\x2C", 0, 0x87D0},
  {"\x5E", 0, 0x88B0},
  {"\x61", 0, 0x88C3},
  {"\x6D", 0, 0x8904},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page784 = {
  marc8_9page784_flat, 0
};
/* PAGE 783 */
struct yaz_iconv_trie_flat marc8_9page783_flat[] = {
  {"\x46", 0, 0x8630},
  {"\x5B", 0, 0x86AB},
  {"\x62", 0, 0x86EF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page783 = {
  marc8_9page783_flat, 0
};
/* PAGE 782 */
struct yaz_iconv_trie_flat marc8_9page782_flat[] = {
  {"\x4D", 0, 0x8422},
  {"\x68", 0, 0x84D9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page782 = {
  marc8_9page782_flat, 0
};
/* PAGE 781 */
struct yaz_iconv_trie_flat marc8_9page781_flat[] = {
  {"\x33", 0, 0x81A4},
  {"\x5C", 0, 0x825D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page781 = {
  marc8_9page781_flat, 0
};
/* PAGE 780 */
struct yaz_iconv_trie_flat marc8_9page780_flat[] = {
  {"\x4F", 0, 0x7E05},
  {"\x6D", 0, 0x7E83},
  {"\x6E", 0, 0x7DD5},
  {"\x76", 0, 0x7E90},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page780 = {
  marc8_9page780_flat, 0
};
/* PAGE 779 */
struct yaz_iconv_trie_flat marc8_9page779_flat[] = {
  {"\x49", 0, 0x7C13},
  {"\x4C", 0, 0x7C17},
  {"\x4E", 0, 0x7BF6},
  {"\x64", 0, 0x7C90},
  {"\x66", 0, 0x7CAD},
  {"\x71", 0, 0x7CC0},
  {"\x74", 0, 0x7CD8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page779 = {
  marc8_9page779_flat, 0
};
/* PAGE 778 */
struct yaz_iconv_trie_flat marc8_9page778_flat[] = {
  {"\x25", 0, 0x7907},
  {"\x4E", 0, 0x7A43},
  {"\x73", 0, 0x7B02},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page778 = {
  marc8_9page778_flat, 0
};
/* PAGE 777 */
struct yaz_iconv_trie_flat marc8_9page777_flat[] = {
  {"\x6D", 0, 0x7874},
  {"\x73", 0, 0x78B5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page777 = {
  marc8_9page777_flat, 0
};
/* PAGE 776 */
struct yaz_iconv_trie_flat marc8_9page776_flat[] = {
  {"\x26", 0, 0x74F2},
  {"\x36", 0, 0x753C},
  {"\x3A", 0, 0x7549},
  {"\x3E", 0, 0x7569},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page776 = {
  marc8_9page776_flat, 0
};
/* PAGE 775 */
struct yaz_iconv_trie_flat marc8_9page775_flat[] = {
  {"\x70", 0, 0x7195},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page775 = {
  marc8_9page775_flat, 0
};
/* PAGE 774 */
struct yaz_iconv_trie_flat marc8_9page774_flat[] = {
  {"\x63", 0, 0x6E82},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page774 = {
  marc8_9page774_flat, 0
};
/* PAGE 773 */
struct yaz_iconv_trie_flat marc8_9page773_flat[] = {
  {"\x36", 0, 0x6B1F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page773 = {
  marc8_9page773_flat, 0
};
/* PAGE 772 */
struct yaz_iconv_trie_flat marc8_9page772_flat[] = {
  {"\x29", 0, 0x6925},
  {"\x2D", 0, 0x6928},
  {"\x30", 0, 0x6923},
  {"\x30", 0, 0x6923},
  {"\x31", 0, 0x6921},
  {"\x39", 0, 0x697E},
  {"\x43", 0, 0x6981},
  {"\x4F", 0, 0x69DD},
  {"\x53", 0, 0x6A2E},
  {"\x71", 0, 0x6A78},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page772 = {
  marc8_9page772_flat, 0
};
/* PAGE 771 */
struct yaz_iconv_trie_flat marc8_9page771_flat[] = {
  {"\x37", 0, 0x6737},
  {"\x7B", 0, 0x6926},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page771 = {
  marc8_9page771_flat, 0
};
/* PAGE 770 */
struct yaz_iconv_trie_flat marc8_9page770_flat[] = {
  {"\x31", 0, 0x64F6},
  {"\x73", 0, 0x6683},
  {"\x7E", 0, 0x66BC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page770 = {
  marc8_9page770_flat, 0
};
/* PAGE 769 */
struct yaz_iconv_trie_flat marc8_9page769_flat[] = {
  {"\x4B", 0, 0x6327},
  {"\x5E", 0, 0x63B5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page769 = {
  marc8_9page769_flat, 0
};
/* PAGE 768 */
struct yaz_iconv_trie_flat marc8_9page768_flat[] = {
  {"\x37", 0, 0x5F16},
  {"\x3B", 0, 0x5F41},
  {"\x6A", 0, 0x603A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page768 = {
  marc8_9page768_flat, 0
};
/* PAGE 767 */
struct yaz_iconv_trie_flat marc8_9page767_flat[] = {
  {"\x26", 0, 0x4E62},
  {"\x2C", 0, 0x599B},
  {"\x2E", 0, 0x5CBB},
  {"\x30", 0, 0x5CBC},
  {"\x32", 0, 0x5CC5},
  {"\x33", 0, 0x5CBE},
  {"\x4E", 0, 0x5D76},
  {"\x57", 0, 0x5D90},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page767 = {
  marc8_9page767_flat, 0
};
/* PAGE 766 */
struct yaz_iconv_trie_flat marc8_9page766_flat[] = {
  {"\x4E", 0, 0x5B36},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page766 = {
  marc8_9page766_flat, 0
};
/* PAGE 765 */
struct yaz_iconv_trie_flat marc8_9page765_flat[] = {
  {"\x29", 0, 0x5726},
  {"\x2A", 0, 0x5737},
  {"\x38", 0, 0x57B3},
  {"\x3A", 0, 0x57AA},
  {"\x3B", 0, 0x57B0},
  {"\x42", 0, 0x57D6},
  {"\x4B", 0, 0x5870},
  {"\x51", 0, 0x58B9},
  {"\x57", 0, 0x58B8},
  {"\x5C", 0, 0x58D7},
  {"\x5F", 0, 0x58E5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page765 = {
  marc8_9page765_flat, 0
};
/* PAGE 764 */
struct yaz_iconv_trie_flat marc8_9page764_flat[] = {
  {"\x26", 0, 0x54D8},
  {"\x3B", 0, 0x555D},
  {"\x75", 0, 0x56CE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page764 = {
  marc8_9page764_flat, 0
};
/* PAGE 763 */
struct yaz_iconv_trie_flat marc8_9page763_flat[] = {
  {"\x5D", 0, 0x53FA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page763 = {
  marc8_9page763_flat, 0
};
/* PAGE 762 */
struct yaz_iconv_trie_flat marc8_9page762_flat[] = {
  {"\x30", 0, 0x5116},
  {"\x5E", 0, 0x51E9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page762 = {
  marc8_9page762_flat, 0
};
/* PAGE 761 */
struct yaz_iconv_trie_flat marc8_9page761_flat[] = {
  {"\x5D", 0, 0x6762},
  {"\x68", 0, 0x5301},
  {"\x7A", 0, 0x9453},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page761 = {
  marc8_9page761_flat, 0
};
/* PAGE 760 */
struct yaz_iconv_trie_flat marc8_9page760_flat[] = {
  {"\x7B", 0, 0x9EBF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page760 = {
  marc8_9page760_flat, 0
};
/* PAGE 759 */
struct yaz_iconv_trie_flat marc8_9page759_flat[] = {
  {"\x23", 0, 0x7872},
  {"\x2B", 0, 0x7560},
  {"\x38", 0, 0x567A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page759 = {
  marc8_9page759_flat, 0
};
/* PAGE 758 */
struct yaz_iconv_trie_flat marc8_9page758_flat[] = {
  {"\x64", 0, 0x51EA},
  {"\x77", 0, 0x5302},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page758 = {
  marc8_9page758_flat, 0
};
/* PAGE 757 */
struct yaz_iconv_trie_flat marc8_9page757_flat[] = {
  {"\x32", 0, 0x9D2B},
  {"\x36", 0, 0x96EB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page757 = {
  marc8_9page757_flat, 0
};
/* PAGE 756 */
struct yaz_iconv_trie_flat marc8_9page756_flat[] = {
  {"\x29", 0, 0x7C82},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page756 = {
  marc8_9page756_flat, 0
};
/* PAGE 755 */
struct yaz_iconv_trie_dir marc8_9page755_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {794, 0, 0} /* 21 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {795, 0, 0} /* 24 */,
  {796, 0, 0} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {756, 0, 0} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {757, 0, 0} /* 3C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {758, 0, 0} /* 46 */,
  {-1, 0, 0},
  {759, 0, 0} /* 48 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {760, 0, 0} /* 4B */,
  {761, 0, 0} /* 4C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {762, 0, 0} /* 51 */,
  {763, 0, 0} /* 52 */,
  {764, 0, 0} /* 53 */,
  {765, 0, 0} /* 54 */,
  {766, 0, 0} /* 55 */,
  {767, 0, 0} /* 56 */,
  {768, 0, 0} /* 57 */,
  {-1, 0, 0},
  {769, 0, 0} /* 59 */,
  {770, 0, 0} /* 5A */,
  {771, 0, 0} /* 5B */,
  {772, 0, 0} /* 5C */,
  {773, 0, 0} /* 5D */,
  {774, 0, 0} /* 5E */,
  {775, 0, 0} /* 5F */,
  {-1, 0, 0},
  {776, 0, 0} /* 61 */,
  {777, 0, 0} /* 62 */,
  {778, 0, 0} /* 63 */,
  {779, 0, 0} /* 64 */,
  {780, 0, 0} /* 65 */,
  {-1, 0, 0},
  {781, 0, 0} /* 67 */,
  {782, 0, 0} /* 68 */,
  {783, 0, 0} /* 69 */,
  {784, 0, 0} /* 6A */,
  {785, 0, 0} /* 6B */,
  {-1, 0, 0},
  {786, 0, 0} /* 6D */,
  {787, 0, 0} /* 6E */,
  {788, 0, 0} /* 6F */,
  {789, 0, 0} /* 70 */,
  {790, 0, 0} /* 71 */,
  {791, 0, 0} /* 72 */,
  {792, 0, 0} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page755 = {
  0, marc8_9page755_dir
};
/* PAGE 754 */
struct yaz_iconv_trie_flat marc8_9page754_flat[] = {
  {"\x73\x5D", 0, 0xE9C6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page754 = {
  marc8_9page754_flat, 0
};
/* PAGE 753 */
struct yaz_iconv_trie_flat marc8_9page753_flat[] = {
  {"\x30\x51", 0, 0x8CAE},
  {"\x30\x57", 0, 0x4E98},
  {"\x34\x21", 0, 0x91D6},
  {"\x35\x6A", 0, 0x8BC3},
  {"\x38\x4D", 0, 0x51C3},
  {"\x3A\x47", 0, 0x8885},
  {"\x3B\x52", 0, 0x6C3D},
  {"\x3D\x67", 0, 0x8FF3},
  {"\x45\x6D", 0, 0x822E},
  {"\x49\x6B", 0, 0x852B},
  {"\x4E\x5B", 0, 0x9271},
  {"\x51\x3B", 0, 0x7E9F},
  {"\x56\x3F", 0, 0x8616},
  {"\x5E\x5D", 0, 0x9616},
  {"\x61\x22", 0, 0x9988},
  {"\x6A\x26", 0, 0x51B4},
  {"\x79\x54", 0, 0x734E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page753 = {
  marc8_9page753_flat, 0
};
/* PAGE 752 */
struct yaz_iconv_trie_flat marc8_9page752_flat[] = {
  {"\x22\x2A", 0, 0x83B5},
  {"\x29\x25", 0, 0x8770},
  {"\x29\x62", 0, 0xE9C2},
  {"\x2C\x3C", 0, 0x87E5},
  {"\x2D\x75", 0, 0xE9C3},
  {"\x2F\x5D", 0, 0xE9C4},
  {"\x2F\x73", 0, 0x7E5D},
  {"\x2F\x7A", 0, 0x891D},
  {"\x30\x32", 0, 0x88AE},
  {"\x33\x59", 0, 0x56AF},
  {"\x33\x63", 0, 0x8C25},
  {"\x38\x6F", 0, 0x544B},
  {"\x3C\x6C", 0, 0x8FB6},
  {"\x41\x34", 0, 0x919B},
  {"\x41\x76", 0, 0x91DB},
  {"\x44\x5B", 0, 0xE9C5},
  {"\x44\x6B", 0, 0x954E},
  {"\x47\x2C", 0, 0x952A},
  {"\x47\x54", 0, 0x9544},
  {"\x47\x7B", 0, 0x943E},
  {"\x48\x32", 0, 0x953F},
  {"\x48\x35", 0, 0x954C},
  {"\x48\x62", 0, 0x9229},
  {"\x4A\x6C", 0, 0x9667},
  {"\x4D\x61", 0, 0x7EF1},
  {"\x4F\x39", 0, 0x988C},
  {"\x50\x3A", 0, 0x98D1},
  {"\x50\x53", 0, 0x98DA},
  {"\x51\x54", 0, 0x9942},
  {"\x55\x74", 0, 0x9B2E},
  {"\x58\x58", 0, 0x9BE3},
  {"\x58\x75", 0, 0x9CD0},
  {"\x59\x34", 0, 0x9CA6},
  {"\x59\x4E", 0, 0x9BF5},
  {"\x59\x73", 0, 0x51EB},
  {"\x5A\x6C", 0, 0x9D46},
  {"\x5B\x35", 0, 0x9DAB},
  {"\x5B\x7E", 0, 0x9DC6},
  {"\x5C\x6B", 0, 0x9D50},
  {"\x5D\x49", 0, 0x9E81},
  {"\x5F\x70", 0, 0x9F44},
  {"\x5F\x7B", 0, 0x97F2},
  {"\x60\x47", 0, 0x816D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page752 = {
  marc8_9page752_flat, 0
};
/* PAGE 751 */
struct yaz_iconv_trie_flat marc8_9page751_flat[] = {
  {"\x4D", 0, 0x8343},
  {"\x6A", 0, 0x8323},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page751 = {
  marc8_9page751_flat, 0
};
/* PAGE 750 */
struct yaz_iconv_trie_flat marc8_9page750_flat[] = {
  {"\x45", 0, 0x82AE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page750 = {
  marc8_9page750_flat, 0
};
/* PAGE 749 */
struct yaz_iconv_trie_flat marc8_9page749_flat[] = {
  {"\x4E", 0, 0x80B7},
  {"\x59", 0, 0x817D},
  {"\x6B", 0, 0x815F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page749 = {
  marc8_9page749_flat, 0
};
/* PAGE 748 */
struct yaz_iconv_trie_flat marc8_9page748_flat[] = {
  {"\x28", 0, 0xE9C1},
  {"\x5D", 0, 0x7D4B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page748 = {
  marc8_9page748_flat, 0
};
/* PAGE 747 */
struct yaz_iconv_trie_flat marc8_9page747_flat[] = {
  {"\x5D", 0, 0x7A39},
  {"\x65", 0, 0x7DFC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page747 = {
  marc8_9page747_flat, 0
};
/* PAGE 746 */
struct yaz_iconv_trie_flat marc8_9page746_flat[] = {
  {"\x5A", 0, 0x7EE6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page746 = {
  marc8_9page746_flat, 0
};
/* PAGE 745 */
struct yaz_iconv_trie_flat marc8_9page745_flat[] = {
  {"\x43", 0, 0x7CCD},
  {"\x7B", 0, 0x7CE8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page745 = {
  marc8_9page745_flat, 0
};
/* PAGE 744 */
struct yaz_iconv_trie_flat marc8_9page744_flat[] = {
  {"\x42", 0, 0x7C31},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page744 = {
  marc8_9page744_flat, 0
};
/* PAGE 743 */
struct yaz_iconv_trie_flat marc8_9page743_flat[] = {
  {"\x46", 0, 0x7B9F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page743 = {
  marc8_9page743_flat, 0
};
/* PAGE 742 */
struct yaz_iconv_trie_flat marc8_9page742_flat[] = {
  {"\x62", 0, 0xE9C0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page742 = {
  marc8_9page742_flat, 0
};
/* PAGE 741 */
struct yaz_iconv_trie_flat marc8_9page741_flat[] = {
  {"\x5C", 0, 0x7A06},
  {"\x5F", 0, 0x7A63},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page741 = {
  marc8_9page741_flat, 0
};
/* PAGE 740 */
struct yaz_iconv_trie_flat marc8_9page740_flat[] = {
  {"\x3E", 0, 0x79EB},
  {"\x3E", 0, 0x79EB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page740 = {
  marc8_9page740_flat, 0
};
/* PAGE 739 */
struct yaz_iconv_trie_flat marc8_9page739_flat[] = {
  {"\x75", 0, 0xE9D7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page739 = {
  marc8_9page739_flat, 0
};
/* PAGE 738 */
struct yaz_iconv_trie_flat marc8_9page738_flat[] = {
  {"\x64", 0, 0x78D9},
  {"\x65", 0, 0x78B9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page738 = {
  marc8_9page738_flat, 0
};
/* PAGE 737 */
struct yaz_iconv_trie_flat marc8_9page737_flat[] = {
  {"\x76", 0, 0x7839},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page737 = {
  marc8_9page737_flat, 0
};
/* PAGE 736 */
struct yaz_iconv_trie_flat marc8_9page736_flat[] = {
  {"\x66", 0, 0x778B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page736 = {
  marc8_9page736_flat, 0
};
/* PAGE 735 */
struct yaz_iconv_trie_flat marc8_9page735_flat[] = {
  {"\x22", 0, 0x7596},
  {"\x74", 0, 0x76B9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page735 = {
  marc8_9page735_flat, 0
};
/* PAGE 734 */
struct yaz_iconv_trie_flat marc8_9page734_flat[] = {
  {"\x58", 0, 0x7640},
  {"\x69", 0, 0x75EB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page734 = {
  marc8_9page734_flat, 0
};
/* PAGE 733 */
struct yaz_iconv_trie_flat marc8_9page733_flat[] = {
  {"\x3A", 0, 0x73F1},
  {"\x61", 0, 0xE9BF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page733 = {
  marc8_9page733_flat, 0
};
/* PAGE 732 */
struct yaz_iconv_trie_flat marc8_9page732_flat[] = {
  {"\x38", 0, 0x729F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page732 = {
  marc8_9page732_flat, 0
};
/* PAGE 731 */
struct yaz_iconv_trie_flat marc8_9page731_flat[] = {
  {"\x41", 0, 0x4E2C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page731 = {
  marc8_9page731_flat, 0
};
/* PAGE 730 */
struct yaz_iconv_trie_flat marc8_9page730_flat[] = {
  {"\x47", 0, 0xE9BE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page730 = {
  marc8_9page730_flat, 0
};
/* PAGE 729 */
struct yaz_iconv_trie_flat marc8_9page729_flat[] = {
  {"\x3A", 0, 0x717A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page729 = {
  marc8_9page729_flat, 0
};
/* PAGE 728 */
struct yaz_iconv_trie_flat marc8_9page728_flat[] = {
  {"\x75", 0, 0x8315},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page728 = {
  marc8_9page728_flat, 0
};
/* PAGE 727 */
struct yaz_iconv_trie_flat marc8_9page727_flat[] = {
  {"\x24", 0, 0x6F46},
  {"\x26", 0, 0x6EDD},
  {"\x2B", 0, 0x701E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page727 = {
  marc8_9page727_flat, 0
};
/* PAGE 726 */
struct yaz_iconv_trie_flat marc8_9page726_flat[] = {
  {"\x3D", 0, 0x6F62},
  {"\x63", 0, 0x6F99},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page726 = {
  marc8_9page726_flat, 0
};
/* PAGE 725 */
struct yaz_iconv_trie_flat marc8_9page725_flat[] = {
  {"\x35", 0, 0x6E0C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page725 = {
  marc8_9page725_flat, 0
};
/* PAGE 724 */
struct yaz_iconv_trie_flat marc8_9page724_flat[] = {
  {"\x6E", 0, 0x6CAD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page724 = {
  marc8_9page724_flat, 0
};
/* PAGE 723 */
struct yaz_iconv_trie_flat marc8_9page723_flat[] = {
  {"\x46", 0, 0x6B4E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page723 = {
  marc8_9page723_flat, 0
};
/* PAGE 722 */
struct yaz_iconv_trie_flat marc8_9page722_flat[] = {
  {"\x33", 0, 0x6AAA},
  {"\x39", 0, 0x69DE},
  {"\x3F", 0, 0x6A65},
  {"\x45", 0, 0x67A6},
  {"\x59", 0, 0x6B05},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page722 = {
  marc8_9page722_flat, 0
};
/* PAGE 721 */
struct yaz_iconv_trie_flat marc8_9page721_flat[] = {
  {"\x46", 0, 0x8538},
  {"\x77", 0, 0x8223},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page721 = {
  marc8_9page721_flat, 0
};
/* PAGE 720 */
struct yaz_iconv_trie_flat marc8_9page720_flat[] = {
  {"\x68", 0, 0x69C7},
  {"\x7A", 0, 0x6922},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page720 = {
  marc8_9page720_flat, 0
};
/* PAGE 719 */
struct yaz_iconv_trie_flat marc8_9page719_flat[] = {
  {"\x22", 0, 0x6860},
  {"\x31", 0, 0x6798},
  {"\x60", 0, 0x6764},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page719 = {
  marc8_9page719_flat, 0
};
/* PAGE 718 */
struct yaz_iconv_trie_flat marc8_9page718_flat[] = {
  {"\x33", 0, 0xE9BD},
  {"\x55", 0, 0x6741},
  {"\x5B", 0, 0x6859},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page718 = {
  marc8_9page718_flat, 0
};
/* PAGE 717 */
struct yaz_iconv_trie_flat marc8_9page717_flat[] = {
  {"\x44", 0, 0x65D9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page717 = {
  marc8_9page717_flat, 0
};
/* PAGE 716 */
struct yaz_iconv_trie_flat marc8_9page716_flat[] = {
  {"\x4A", 0, 0x64B8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page716 = {
  marc8_9page716_flat, 0
};
/* PAGE 715 */
struct yaz_iconv_trie_flat marc8_9page715_flat[] = {
  {"\x74", 0, 0x631D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page715 = {
  marc8_9page715_flat, 0
};
/* PAGE 714 */
struct yaz_iconv_trie_flat marc8_9page714_flat[] = {
  {"\x61", 0, 0x622C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page714 = {
  marc8_9page714_flat, 0
};
/* PAGE 713 */
struct yaz_iconv_trie_flat marc8_9page713_flat[] = {
  {"\x62", 0, 0xE9BC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page713 = {
  marc8_9page713_flat, 0
};
/* PAGE 712 */
struct yaz_iconv_trie_flat marc8_9page712_flat[] = {
  {"\x4C", 0, 0x53A9},
  {"\x67", 0, 0x5EDB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page712 = {
  marc8_9page712_flat, 0
};
/* PAGE 711 */
struct yaz_iconv_trie_flat marc8_9page711_flat[] = {
  {"\x32", 0, 0x5D5B},
  {"\x39", 0, 0x5D73},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page711 = {
  marc8_9page711_flat, 0
};
/* PAGE 710 */
struct yaz_iconv_trie_flat marc8_9page710_flat[] = {
  {"\x30", 0, 0x5C53},
  {"\x3F", 0, 0x5C76},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page710 = {
  marc8_9page710_flat, 0
};
/* PAGE 709 */
struct yaz_iconv_trie_dir marc8_9page709_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {710, 0, 0} /* 23 */,
  {-1, 0, 0},
  {711, 0, 0} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {712, 0, 0} /* 28 */,
  {713, 0, 0} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {714, 0, 0} /* 2F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {715, 0, 0} /* 34 */,
  {716, 0, 0} /* 35 */,
  {-1, 0, 0},
  {717, 0, 0} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {718, 0, 0} /* 3A */,
  {719, 0, 0} /* 3B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {720, 0, 0} /* 3F */,
  {-1, 0, 0},
  {721, 0, 0} /* 41 */,
  {-1, 0, 0},
  {722, 0, 0} /* 43 */,
  {723, 0, 0} /* 44 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {724, 0, 0} /* 47 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {725, 0, 0} /* 4C */,
  {726, 0, 0} /* 4D */,
  {-1, 0, 0},
  {727, 0, 0} /* 4F */,
  {-1, 0, 0},
  {728, 0, 0} /* 51 */,
  {729, 0, 0} /* 52 */,
  {-1, 0, 0},
  {730, 0, 0} /* 54 */,
  {731, 0, 0} /* 55 */,
  {732, 0, 0} /* 56 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {733, 0, 0} /* 5C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {734, 0, 0} /* 5F */,
  {735, 0, 0} /* 60 */,
  {-1, 0, 0},
  {736, 0, 0} /* 62 */,
  {737, 0, 0} /* 63 */,
  {-1, 0, 0},
  {738, 0, 0} /* 65 */,
  {-1, 0, 0},
  {739, 0, 0} /* 67 */,
  {740, 0, 0} /* 68 */,
  {741, 0, 0} /* 69 */,
  {-1, 0, 0},
  {742, 0, 0} /* 6B */,
  {743, 0, 0} /* 6C */,
  {-1, 0, 0},
  {744, 0, 0} /* 6E */,
  {745, 0, 0} /* 6F */,
  {-1, 0, 0},
  {746, 0, 0} /* 71 */,
  {747, 0, 0} /* 72 */,
  {748, 0, 0} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {749, 0, 0} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {750, 0, 0} /* 7C */,
  {751, 0, 0} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page709 = {
  0, marc8_9page709_dir
};
/* PAGE 708 */
struct yaz_iconv_trie_flat marc8_9page708_flat[] = {
  {"\x6A", 0, 0xE9BB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page708 = {
  marc8_9page708_flat, 0
};
/* PAGE 707 */
struct yaz_iconv_trie_flat marc8_9page707_flat[] = {
  {"\x54", 0, 0x5968},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page707 = {
  marc8_9page707_flat, 0
};
/* PAGE 706 */
struct yaz_iconv_trie_flat marc8_9page706_flat[] = {
  {"\x74", 0, 0x590A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page706 = {
  marc8_9page706_flat, 0
};
/* PAGE 705 */
struct yaz_iconv_trie_flat marc8_9page705_flat[] = {
  {"\x3D", 0, 0xE9BA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page705 = {
  marc8_9page705_flat, 0
};
/* PAGE 704 */
struct yaz_iconv_trie_flat marc8_9page704_flat[] = {
  {"\x77", 0, 0x57D3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page704 = {
  marc8_9page704_flat, 0
};
/* PAGE 703 */
struct yaz_iconv_trie_flat marc8_9page703_flat[] = {
  {"\x21", 0, 0xF9A9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page703 = {
  marc8_9page703_flat, 0
};
/* PAGE 702 */
struct yaz_iconv_trie_flat marc8_9page702_flat[] = {
  {"\x22", 0, 0x7F83},
  {"\x26", 0, 0x6C8D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page702 = {
  marc8_9page702_flat, 0
};
/* PAGE 701 */
struct yaz_iconv_trie_flat marc8_9page701_flat[] = {
  {"\x2E", 0, 0x4EC2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page701 = {
  marc8_9page701_flat, 0
};
/* PAGE 700 */
struct yaz_iconv_trie_flat marc8_9page700_flat[] = {
  {"\x37", 0, 0x4FE3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page700 = {
  marc8_9page700_flat, 0
};
/* PAGE 699 */
struct yaz_iconv_trie_flat marc8_9page699_flat[] = {
  {"\x55", 0, 0x4EB6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page699 = {
  marc8_9page699_flat, 0
};
/* PAGE 698 */
struct yaz_iconv_trie_flat marc8_9page698_flat[] = {
  {"\x24", 0, 0x9F62},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page698 = {
  marc8_9page698_flat, 0
};
/* PAGE 697 */
struct yaz_iconv_trie_flat marc8_9page697_flat[] = {
  {"\x3B", 0, 0x9D12},
  {"\x47", 0, 0x9D2C},
  {"\x4F", 0, 0x9D49},
  {"\x58", 0, 0x68BA},
  {"\x5C", 0, 0xE9B9},
  {"\x60", 0, 0x9EBD},
  {"\x66", 0, 0x9ED2},
  {"\x68", 0, 0x9ED9},
  {"\x78", 0, 0x9F21},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page697 = {
  marc8_9page697_flat, 0
};
/* PAGE 696 */
struct yaz_iconv_trie_flat marc8_9page696_flat[] = {
  {"\x22", 0, 0x994B},
  {"\x30", 0, 0x99C4},
  {"\x3F", 0, 0x9A08},
  {"\x45", 0, 0x9A12},
  {"\x47", 0, 0x99C6},
  {"\x4D", 0, 0x9A13},
  {"\x59", 0, 0x81B8},
  {"\x5F", 0, 0x9AEA},
  {"\x67", 0, 0x95D8},
  {"\x68", 0, 0x9599},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page696 = {
  marc8_9page696_flat, 0
};
/* PAGE 695 */
struct yaz_iconv_trie_flat marc8_9page695_flat[] = {
  {"\x2D", 0, 0x9771},
  {"\x44", 0, 0x9818},
  {"\x48", 0, 0x981A},
  {"\x53", 0, 0x985E},
  {"\x6F", 0, 0x991D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page695 = {
  marc8_9page695_flat, 0
};
/* PAGE 694 */
struct yaz_iconv_trie_flat marc8_9page694_flat[] = {
  {"\x30", 0, 0xE9B7},
  {"\x35", 0, 0x6B92},
  {"\x3A", 0, 0x967A},
  {"\x49", 0, 0x51CB},
  {"\x4C", 0, 0x9D8F},
  {"\x50", 0, 0x96E3},
  {"\x58", 0, 0xF9B2},
  {"\x62", 0, 0x7668},
  {"\x6F", 0, 0x970A},
  {"\x70", 0, 0x9752},
  {"\x71", 0, 0x9756},
  {"\x72", 0, 0x975B},
  {"\x73", 0, 0xE9B8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page694 = {
  marc8_9page694_flat, 0
};
/* PAGE 693 */
struct yaz_iconv_trie_flat marc8_9page693_flat[] = {
  {"\x27", 0, 0x93AD},
  {"\x3D", 0, 0x9421},
  {"\x3F", 0, 0x922C},
  {"\x5D", 0, 0x95D4},
  {"\x69", 0, 0x95A2},
  {"\x6C", 0, 0xE925},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page693 = {
  marc8_9page693_flat, 0
};
/* PAGE 692 */
struct yaz_iconv_trie_flat marc8_9page692_flat[] = {
  {"\x2B", 0, 0x9162},
  {"\x34", 0, 0x91B8},
  {"\x36", 0, 0x91C6},
  {"\x38", 0, 0x91C8},
  {"\x42", 0, 0x91E1},
  {"\x58", 0, 0x9234},
  {"\x65", 0, 0x8217},
  {"\x70", 0, 0x92AD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page692 = {
  marc8_9page692_flat, 0
};
/* PAGE 691 */
struct yaz_iconv_trie_flat marc8_9page691_flat[] = {
  {"\x32", 0, 0x9038},
  {"\x39", 0, 0x9039},
  {"\x47", 0, 0x9059},
  {"\x50", 0, 0x9045},
  {"\x54", 0, 0xE924},
  {"\x5B", 0, 0x8FBA},
  {"\x5E", 0, 0x961D},
  {"\x72", 0, 0xE9B6},
  {"\x77", 0, 0x9139},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page691 = {
  marc8_9page691_flat, 0
};
/* PAGE 690 */
struct yaz_iconv_trie_flat marc8_9page690_flat[] = {
  {"\x29", 0, 0x8E8D},
  {"\x46", 0, 0x8F0C},
  {"\x52", 0, 0x8F42},
  {"\x55", 0, 0x8EE2},
  {"\x58", 0, 0x8EE3},
  {"\x5E", 0, 0x5F01},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page690 = {
  marc8_9page690_flat, 0
};
/* PAGE 689 */
struct yaz_iconv_trie_flat marc8_9page689_flat[] = {
  {"\x23", 0, 0x621D},
  {"\x31", 0, 0x8CCE},
  {"\x3B", 0, 0x8D08},
  {"\x68", 0, 0xE9B5},
  {"\x7E", 0, 0x5C69},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page689 = {
  marc8_9page689_flat, 0
};
/* PAGE 688 */
struct yaz_iconv_trie_flat marc8_9page688_flat[] = {
  {"\x36", 0, 0x8B20},
  {"\x46", 0, 0x8A33},
  {"\x4A", 0, 0x8AAD},
  {"\x4B", 0, 0x5909},
  {"\x59", 0, 0x8273},
  {"\x63", 0, 0x734F},
  {"\x64", 0, 0x72E2},
  {"\x73", 0, 0x8D2E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page688 = {
  marc8_9page688_flat, 0
};
/* PAGE 687 */
struct yaz_iconv_trie_flat marc8_9page687_flat[] = {
  {"\x24", 0, 0x897E},
  {"\x26", 0, 0xE9B4},
  {"\x30", 0, 0x899A},
  {"\x32", 0, 0x89B3},
  {"\x61", 0, 0x4F89},
  {"\x71", 0, 0x8AA4},
  {"\x7A", 0, 0x8ACB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page687 = {
  marc8_9page687_flat, 0
};
/* PAGE 686 */
struct yaz_iconv_trie_flat marc8_9page686_flat[] = {
  {"\x24", 0, 0x86CD},
  {"\x36", 0, 0x877F},
  {"\x40", 0, 0x8827},
  {"\x46", 0, 0x8853},
  {"\x6C", 0, 0x523E},
  {"\x6F", 0, 0xE9B3},
  {"\x73", 0, 0x7ED4},
  {"\x7E", 0, 0x7E7F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page686 = {
  marc8_9page686_flat, 0
};
/* PAGE 685 */
struct yaz_iconv_trie_flat marc8_9page685_flat[] = {
  {"\x29", 0, 0x85CD},
  {"\x2B", 0, 0x8535},
  {"\x31", 0, 0x82B8},
  {"\x32", 0, 0x7C54},
  {"\x3A", 0, 0xE9B0},
  {"\x3F", 0, 0x6A98},
  {"\x47", 0, 0x51E6},
  {"\x6A", 0, 0xE9B1},
  {"\x71", 0, 0xE9B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page685 = {
  marc8_9page685_flat, 0
};
/* PAGE 684 */
struct yaz_iconv_trie_flat marc8_9page684_flat[] = {
  {"\x21", 0, 0x8332},
  {"\x2C", 0, 0x8392},
  {"\x3A", 0, 0xE9AE},
  {"\x3F", 0, 0xE9AF},
  {"\x42", 0, 0x8420},
  {"\x64", 0, 0x77C7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page684 = {
  marc8_9page684_flat, 0
};
/* PAGE 683 */
struct yaz_iconv_trie_flat marc8_9page683_flat[] = {
  {"\x22", 0, 0x81D3},
  {"\x28", 0, 0xE9AC},
  {"\x34", 0, 0x6319},
  {"\x37", 0, 0x820E},
  {"\x6D", 0, 0xE9AD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page683 = {
  marc8_9page683_flat, 0
};
/* PAGE 682 */
struct yaz_iconv_trie_flat marc8_9page682_flat[] = {
  {"\x3B", 0, 0x695C},
  {"\x61", 0, 0xE923},
  {"\x65", 0, 0x8133},
  {"\x7D", 0, 0x9ACC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page682 = {
  marc8_9page682_flat, 0
};
/* PAGE 681 */
struct yaz_iconv_trie_flat marc8_9page681_flat[] = {
  {"\x21", 0, 0x7D9A},
  {"\x23", 0, 0x7E4A},
  {"\x27", 0, 0x6B20},
  {"\x2B", 0, 0x7F36},
  {"\x38", 0, 0x7F87},
  {"\x3E", 0, 0xE9A9},
  {"\x47", 0, 0x7FAE},
  {"\x4E", 0, 0x7FCE},
  {"\x5A", 0, 0x7FFA},
  {"\x5B", 0, 0xE9AA},
  {"\x5C", 0, 0x8002},
  {"\x6E", 0, 0xE9AB},
  {"\x77", 0, 0x8068},
  {"\x7C", 0, 0x8080},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page681 = {
  marc8_9page681_flat, 0
};
/* PAGE 680 */
struct yaz_iconv_trie_flat marc8_9page680_flat[] = {
  {"\x3B", 0, 0x7CF8},
  {"\x54", 0, 0x7DF4},
  {"\x5A", 0, 0x7E01},
  {"\x64", 0, 0x770C},
  {"\x6A", 0, 0x7EF7},
  {"\x6D", 0, 0x7DCF},
  {"\x6E", 0, 0x7E26},
  {"\x76", 0, 0x7E04},
  {"\x79", 0, 0x7F0B},
  {"\x7E", 0, 0x7E92},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page680 = {
  marc8_9page680_flat, 0
};
/* PAGE 679 */
struct yaz_iconv_trie_flat marc8_9page679_flat[] = {
  {"\x36", 0, 0x7C14},
  {"\x3B", 0, 0x7C12},
  {"\x44", 0, 0xE9A8},
  {"\x52", 0, 0x7C56},
  {"\x61", 0, 0x7CBE},
  {"\x6C", 0, 0x7CAB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page679 = {
  marc8_9page679_flat, 0
};
/* PAGE 678 */
struct yaz_iconv_trie_flat marc8_9page678_flat[] = {
  {"\x29", 0, 0x7A50},
  {"\x3C", 0, 0xE9A7},
  {"\x43", 0, 0x7A32},
  {"\x4C", 0, 0x7A4F},
  {"\x7B", 0, 0x7B7A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page678 = {
  marc8_9page678_flat, 0
};
/* PAGE 677 */
struct yaz_iconv_trie_flat marc8_9page677_flat[] = {
  {"\x21", 0, 0x7B36},
  {"\x37", 0, 0x7814},
  {"\x39", 0, 0x5CFA},
  {"\x56", 0, 0x78FA},
  {"\x5B", 0, 0x783F},
  {"\x67", 0, 0x79D8},
  {"\x7B", 0, 0xE9A6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page677 = {
  marc8_9page677_flat, 0
};
/* PAGE 676 */
struct yaz_iconv_trie_flat marc8_9page676_flat[] = {
  {"\x41", 0, 0x862F},
  {"\x45", 0, 0xE9A3},
  {"\x56", 0, 0x8846},
  {"\x59", 0, 0xE9A4},
  {"\x73", 0, 0x66B8},
  {"\x7B", 0, 0xE9A5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page676 = {
  marc8_9page676_flat, 0
};
/* PAGE 675 */
struct yaz_iconv_trie_flat marc8_9page675_flat[] = {
  {"\x36", 0, 0x7575},
  {"\x3C", 0, 0x7573},
  {"\x51", 0, 0x75CA},
  {"\x5B", 0, 0x75F3},
  {"\x67", 0, 0xE9A2},
  {"\x79", 0, 0x7672},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page675 = {
  marc8_9page675_flat, 0
};
/* PAGE 674 */
struct yaz_iconv_trie_flat marc8_9page674_flat[] = {
  {"\x2B", 0, 0x7363},
  {"\x2C", 0, 0x731F},
  {"\x3E", 0, 0xF9AD},
  {"\x63", 0, 0x749C},
  {"\x71", 0, 0xE9A1},
  {"\x77", 0, 0x4EC0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page674 = {
  marc8_9page674_flat, 0
};
/* PAGE 673 */
struct yaz_iconv_trie_flat marc8_9page673_flat[] = {
  {"\x2E", 0, 0x55B6},
  {"\x38", 0, 0x71D7},
  {"\x3E", 0, 0x7235},
  {"\x45", 0, 0x5C13},
  {"\x62", 0, 0x72A0},
  {"\x74", 0, 0xE9A0},
  {"\x78", 0, 0x72F0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page673 = {
  marc8_9page673_flat, 0
};
/* PAGE 672 */
struct yaz_iconv_trie_flat marc8_9page672_flat[] = {
  {"\x21", 0, 0x6CA2},
  {"\x25", 0, 0xE99F},
  {"\x2B", 0, 0x6FEB},
  {"\x2E", 0, 0x6E0B},
  {"\x31", 0, 0x6E16},
  {"\x37", 0, 0x56A0},
  {"\x40", 0, 0x6F45},
  {"\x47", 0, 0x7AC3},
  {"\x6A", 0, 0x932C},
  {"\x6B", 0, 0x83F8},
  {"\x73", 0, 0x7115},
  {"\x75", 0, 0x6427},
  {"\x77", 0, 0x7188},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page672 = {
  marc8_9page672_flat, 0
};
/* PAGE 671 */
struct yaz_iconv_trie_flat marc8_9page671_flat[] = {
  {"\x35", 0, 0x6DA3},
  {"\x46", 0, 0x78C6},
  {"\x4A", 0, 0x6E13},
  {"\x4B", 0, 0x51D6},
  {"\x4C", 0, 0x6F91},
  {"\x57", 0, 0x6F22},
  {"\x58", 0, 0x6E80},
  {"\x5F", 0, 0xE99E},
  {"\x66", 0, 0x6E89},
  {"\x74", 0, 0x6FF3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page671 = {
  marc8_9page671_flat, 0
};
/* PAGE 670 */
struct yaz_iconv_trie_flat marc8_9page670_flat[] = {
  {"\x41", 0, 0x51BD},
  {"\x59", 0, 0x6D99},
  {"\x61", 0, 0x6E05},
  {"\x67", 0, 0xE99D},
  {"\x6C", 0, 0x51C5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page670 = {
  marc8_9page670_flat, 0
};
/* PAGE 669 */
struct yaz_iconv_trie_flat marc8_9page669_flat[] = {
  {"\x21", 0, 0x6B53},
  {"\x2A", 0, 0x6B74},
  {"\x2E", 0, 0x6B81},
  {"\x38", 0, 0x6BB1},
  {"\x55", 0, 0x6C17},
  {"\x5A", 0, 0x6C32},
  {"\x76", 0, 0x6C89},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page669 = {
  marc8_9page669_flat, 0
};
/* PAGE 668 */
struct yaz_iconv_trie_flat marc8_9page668_flat[] = {
  {"\x34", 0, 0xE99B},
  {"\x37", 0, 0x6804},
  {"\x44", 0, 0x69D8},
  {"\x45", 0, 0x6982},
  {"\x53", 0, 0x6955},
  {"\x56", 0, 0x6A2A},
  {"\x59", 0, 0x9792},
  {"\x61", 0, 0x691C},
  {"\x69", 0, 0x6A71},
  {"\x6C", 0, 0xE99C},
  {"\x6D", 0, 0x823B},
  {"\x6F", 0, 0x685C},
  {"\x70", 0, 0x6A29},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page668 = {
  marc8_9page668_flat, 0
};
/* PAGE 667 */
struct yaz_iconv_trie_flat marc8_9page667_flat[] = {
  {"\x2D", 0, 0x67A9},
  {"\x44", 0, 0xE9C8},
  {"\x56", 0, 0x6813},
  {"\x76", 0, 0x685F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page667 = {
  marc8_9page667_flat, 0
};
/* PAGE 666 */
struct yaz_iconv_trie_flat marc8_9page666_flat[] = {
  {"\x39", 0, 0x6674},
  {"\x47", 0, 0x66A8},
  {"\x4D", 0, 0x663F},
  {"\x52", 0, 0x66F5},
  {"\x58", 0, 0x66FD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page666 = {
  marc8_9page666_flat, 0
};
/* PAGE 665 */
struct yaz_iconv_trie_flat marc8_9page665_flat[] = {
  {"\x35", 0, 0x6442},
  {"\x36", 0, 0x643A},
  {"\x3A", 0, 0x64B9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page665 = {
  marc8_9page665_flat, 0
};
/* PAGE 664 */
struct yaz_iconv_trie_flat marc8_9page664_flat[] = {
  {"\x2A", 0, 0x6323},
  {"\x35", 0, 0x6368},
  {"\x46", 0, 0x6362},
  {"\x47", 0, 0x633F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page664 = {
  marc8_9page664_flat, 0
};
/* PAGE 663 */
struct yaz_iconv_trie_flat marc8_9page663_flat[] = {
  {"\x3D", 0, 0x62DD},
  {"\x46", 0, 0x629C},
  {"\x49", 0, 0x62D0},
  {"\x53", 0, 0x627A},
  {"\x66", 0, 0x62F4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page663 = {
  marc8_9page663_flat, 0
};
/* PAGE 662 */
struct yaz_iconv_trie_flat marc8_9page662_flat[] = {
  {"\x40", 0, 0xE998},
  {"\x4A", 0, 0x5FDC},
  {"\x4B", 0, 0xE999},
  {"\x50", 0, 0xE99A},
  {"\x51", 0, 0x61D1},
  {"\x53", 0, 0x61F2},
  {"\x74", 0, 0x623B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page662 = {
  marc8_9page662_flat, 0
};
/* PAGE 661 */
struct yaz_iconv_trie_flat marc8_9page661_flat[] = {
  {"\x2A", 0, 0x6035},
  {"\x40", 0, 0x6046},
  {"\x5B", 0, 0x60C5},
  {"\x7E", 0, 0x60A9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page661 = {
  marc8_9page661_flat, 0
};
/* PAGE 660 */
struct yaz_iconv_trie_flat marc8_9page660_flat[] = {
  {"\x24", 0, 0x53A6},
  {"\x27", 0, 0x5EC3},
  {"\x2A", 0, 0x5EE3},
  {"\x2C", 0, 0x53B0},
  {"\x2F", 0, 0x5EF0},
  {"\x4B", 0, 0x5F3E},
  {"\x4C", 0, 0xE996},
  {"\x5C", 0, 0x5F83},
  {"\x67", 0, 0xE997},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page660 = {
  marc8_9page660_flat, 0
};
/* PAGE 659 */
struct yaz_iconv_trie_flat marc8_9page659_flat[] = {
  {"\x21", 0, 0x5D5C},
  {"\x23", 0, 0x5CE5},
  {"\x2B", 0, 0xE9C7},
  {"\x2F", 0, 0x5DBA},
  {"\x32", 0, 0x5DD3},
  {"\x33", 0, 0x5DCC},
  {"\x38", 0, 0x949C},
  {"\x53", 0, 0x5E2F},
  {"\x5E", 0, 0x5E64},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page659 = {
  marc8_9page659_flat, 0
};
/* PAGE 658 */
struct yaz_iconv_trie_flat marc8_9page658_flat[] = {
  {"\x22", 0, 0x51A6},
  {"\x31", 0, 0x5B9F},
  {"\x37", 0, 0x51A9},
  {"\x43", 0, 0x5BFE},
  {"\x52", 0, 0x8132},
  {"\x61", 0, 0x5C64},
  {"\x67", 0, 0x6B67},
  {"\x79", 0, 0x5D8C},
  {"\x7E", 0, 0x5D15},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page658 = {
  marc8_9page658_flat, 0
};
/* PAGE 657 */
struct yaz_iconv_trie_flat marc8_9page657_flat[] = {
  {"\x2F", 0, 0x805F},
  {"\x47", 0, 0x88CA},
  {"\x49", 0, 0x5B37},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page657 = {
  marc8_9page657_flat, 0
};
/* PAGE 656 */
struct yaz_iconv_trie_flat marc8_9page656_flat[] = {
  {"\x38", 0, 0x5942},
  {"\x3A", 0, 0x5F09},
  {"\x3E", 0, 0x5965},
  {"\x3F", 0, 0x5333},
  {"\x74", 0, 0x5B22},
  {"\x7B", 0, 0x5A2F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page656 = {
  marc8_9page656_flat, 0
};
/* PAGE 655 */
struct yaz_iconv_trie_flat marc8_9page655_flat[] = {
  {"\x2E", 0, 0x57C0},
  {"\x50", 0, 0xE995},
  {"\x50", 0, 0xE995},
  {"\x53", 0, 0xE9FB},
  {"\x5E", 0, 0x5897},
  {"\x64", 0, 0x58C7},
  {"\x69", 0, 0x5727},
  {"\x6C", 0, 0x5841},
  {"\x70", 0, 0x58CC},
  {"\x71", 0, 0x57BB},
  {"\x7D", 0, 0x591B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page655 = {
  marc8_9page655_flat, 0
};
/* PAGE 654 */
struct yaz_iconv_trie_flat marc8_9page654_flat[] = {
  {"\x2C", 0, 0x5606},
  {"\x2F", 0, 0x5C1C},
  {"\x49", 0, 0xE993},
  {"\x4C", 0, 0x5662},
  {"\x58", 0, 0xE994},
  {"\x5A", 0, 0x53B3},
  {"\x68", 0, 0x56D8},
  {"\x6F", 0, 0x56FD},
  {"\x72", 0, 0x5186},
  {"\x73", 0, 0x56E3},
  {"\x74", 0, 0x56F3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page654 = {
  marc8_9page654_flat, 0
};
/* PAGE 653 */
struct yaz_iconv_trie_flat marc8_9page653_flat[] = {
  {"\x22", 0, 0x8C18},
  {"\x42", 0, 0x8BF6},
  {"\x66", 0, 0x5A1A},
  {"\x68", 0, 0x5358},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page653 = {
  marc8_9page653_flat, 0
};
/* PAGE 652 */
struct yaz_iconv_trie_flat marc8_9page652_flat[] = {
  {"\x6A", 0, 0x55EC},
  {"\x7B", 0, 0x54CC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page652 = {
  marc8_9page652_flat, 0
};
/* PAGE 651 */
struct yaz_iconv_trie_flat marc8_9page651_flat[] = {
  {"\x21", 0, 0x5263},
  {"\x35", 0, 0x52B4},
  {"\x36", 0, 0x52F2},
  {"\x6B", 0, 0x5DF5},
  {"\x74", 0, 0xE992},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page651 = {
  marc8_9page651_flat, 0
};
/* PAGE 650 */
struct yaz_iconv_trie_flat marc8_9page650_flat[] = {
  {"\x21", 0, 0x5185},
  {"\x22", 0, 0xE990},
  {"\x24", 0, 0xE991},
  {"\x3E", 0, 0xF92E},
  {"\x51", 0, 0x5204},
  {"\x54", 0, 0x82C5},
  {"\x55", 0, 0x520B},
  {"\x5B", 0, 0x522B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page650 = {
  marc8_9page650_flat, 0
};
/* PAGE 649 */
struct yaz_iconv_trie_flat marc8_9page649_flat[] = {
  {"\x31", 0, 0x4EEE},
  {"\x48", 0, 0xE9FA},
  {"\x4E", 0, 0xE98F},
  {"\x5F", 0, 0x50BB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page649 = {
  marc8_9page649_flat, 0
};
/* PAGE 648 */
struct yaz_iconv_trie_flat marc8_9page648_flat[] = {
  {"\x2D", 0, 0x4F2B},
  {"\x30", 0, 0x4FAB},
  {"\x44", 0, 0xE98D},
  {"\x4C", 0, 0x5F95},
  {"\x6A", 0, 0x723C},
  {"\x78", 0, 0xE98E},
  {"\x7C", 0, 0x5024},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page648 = {
  marc8_9page648_flat, 0
};
/* PAGE 647 */
struct yaz_iconv_trie_flat marc8_9page647_flat[] = {
  {"\x21", 0, 0x58F1},
  {"\x50", 0, 0x4E8A},
  {"\x51", 0, 0x5F10},
  {"\x52", 0, 0x6275},
  {"\x57", 0, 0x4E99},
  {"\x6C", 0, 0x96E0},
  {"\x6E", 0, 0xE98C},
  {"\x72", 0, 0x4EED},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page647 = {
  marc8_9page647_flat, 0
};
/* PAGE 646 */
struct yaz_iconv_trie_dir marc8_9page646_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {647, 0, 0} /* 30 */,
  {648, 0, 0} /* 31 */,
  {649, 0, 0} /* 32 */,
  {650, 0, 0} /* 33 */,
  {651, 0, 0} /* 34 */,
  {652, 0, 0} /* 35 */,
  {653, 0, 0} /* 36 */,
  {654, 0, 0} /* 37 */,
  {655, 0, 0} /* 38 */,
  {656, 0, 0} /* 39 */,
  {657, 0, 0} /* 3A */,
  {658, 0, 0} /* 3B */,
  {659, 0, 0} /* 3C */,
  {660, 0, 0} /* 3D */,
  {661, 0, 0} /* 3E */,
  {662, 0, 0} /* 3F */,
  {663, 0, 0} /* 40 */,
  {664, 0, 0} /* 41 */,
  {665, 0, 0} /* 42 */,
  {666, 0, 0} /* 43 */,
  {667, 0, 0} /* 44 */,
  {668, 0, 0} /* 45 */,
  {669, 0, 0} /* 46 */,
  {670, 0, 0} /* 47 */,
  {671, 0, 0} /* 48 */,
  {672, 0, 0} /* 49 */,
  {673, 0, 0} /* 4A */,
  {674, 0, 0} /* 4B */,
  {675, 0, 0} /* 4C */,
  {676, 0, 0} /* 4D */,
  {677, 0, 0} /* 4E */,
  {678, 0, 0} /* 4F */,
  {679, 0, 0} /* 50 */,
  {680, 0, 0} /* 51 */,
  {681, 0, 0} /* 52 */,
  {682, 0, 0} /* 53 */,
  {683, 0, 0} /* 54 */,
  {684, 0, 0} /* 55 */,
  {685, 0, 0} /* 56 */,
  {686, 0, 0} /* 57 */,
  {687, 0, 0} /* 58 */,
  {688, 0, 0} /* 59 */,
  {689, 0, 0} /* 5A */,
  {690, 0, 0} /* 5B */,
  {691, 0, 0} /* 5C */,
  {692, 0, 0} /* 5D */,
  {693, 0, 0} /* 5E */,
  {694, 0, 0} /* 5F */,
  {695, 0, 0} /* 60 */,
  {696, 0, 0} /* 61 */,
  {697, 0, 0} /* 62 */,
  {698, 0, 0} /* 63 */,
  {699, 0, 0} /* 64 */,
  {-1, 0, 0},
  {700, 0, 0} /* 66 */,
  {-1, 0, 0},
  {701, 0, 0} /* 68 */,
  {-1, 0, 0},
  {702, 0, 0} /* 6A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {703, 0, 0} /* 74 */,
  {704, 0, 0} /* 75 */,
  {705, 0, 0} /* 76 */,
  {-1, 0, 0},
  {706, 0, 0} /* 78 */,
  {707, 0, 0} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {708, 0, 0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page646 = {
  0, marc8_9page646_dir
};
/* PAGE 645 */
struct yaz_iconv_trie_flat marc8_9page645_flat[] = {
  {"\x2C\x4D", 0, 0xE989},
  {"\x34\x22", 0, 0x8C2A},
  {"\x34\x7B", 0, 0x8C2B},
  {"\x35\x39", 0, 0x8B9E},
  {"\x36\x6F", 0, 0x8D4D},
  {"\x42\x36", 0, 0x949A},
  {"\x42\x70", 0, 0x94BC},
  {"\x49\x31", 0, 0x95F6},
  {"\x4E\x5C", 0, 0xE98A},
  {"\x52\x22", 0, 0x9957},
  {"\x57\x7A", 0, 0xE98B},
  {"\x59\x4E", 0, 0x9C3A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page645 = {
  marc8_9page645_flat, 0
};
/* PAGE 644 */
struct yaz_iconv_trie_flat marc8_9page644_flat[] = {
  {"\x28\x4C", 0, 0x5ED0},
  {"\x60\x74", 0, 0x76B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page644 = {
  marc8_9page644_flat, 0
};
/* PAGE 643 */
struct yaz_iconv_trie_flat marc8_9page643_flat[] = {
  {"\x30\x4C", 0, 0x69A6},
  {"\x30\x51", 0, 0x8D30},
  {"\x33\x36", 0, 0x5B82},
  {"\x34\x21", 0, 0x5271},
  {"\x36\x66", 0, 0x5AD0},
  {"\x37\x55", 0, 0x56AE},
  {"\x37\x68", 0, 0x5EFB},
  {"\x3D\x53", 0, 0x5F66},
  {"\x3F\x6D", 0, 0x52E0},
  {"\x41\x46", 0, 0x63DB},
  {"\x45\x6D", 0, 0x6A10},
  {"\x46\x2B", 0, 0x7688},
  {"\x46\x5B", 0, 0x6C2F},
  {"\x47\x38", 0, 0x6CFA},
  {"\x47\x74", 0, 0x6E15},
  {"\x4B\x7A", 0, 0x7523},
  {"\x4C\x3C", 0, 0x7589},
  {"\x4E\x43", 0, 0xE986},
  {"\x4E\x75", 0, 0x7984},
  {"\x4F\x45", 0, 0x9896},
  {"\x51\x22", 0, 0x7D0D},
  {"\x51\x64", 0, 0x53BF},
  {"\x55\x64", 0, 0x6FDB},
  {"\x56\x4B", 0, 0xE987},
  {"\x57\x46", 0, 0x672F},
  {"\x58\x37", 0, 0x8BA0},
  {"\x58\x47", 0, 0xE988},
  {"\x5D\x3E", 0, 0x9485},
  {"\x5E\x21", 0, 0x953A},
  {"\x5E\x60", 0, 0x95EB},
  {"\x5F\x35", 0, 0x9668},
  {"\x60\x36", 0, 0x97FF},
  {"\x60\x4E", 0, 0x984F},
  {"\x60\x64", 0, 0x9963},
  {"\x60\x6B", 0, 0x98F0},
  {"\x60\x76", 0, 0x9980},
  {"\x62\x60", 0, 0x5E7A},
  {"\x63\x24", 0, 0x9F61},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page643 = {
  marc8_9page643_flat, 0
};
/* PAGE 642 */
struct yaz_iconv_trie_flat marc8_9page642_flat[] = {
  {"\x30\x4C", 0, 0x5E79},
  {"\x30\x78", 0, 0x5023},
  {"\x34\x7D", 0, 0x84E1},
  {"\x35\x73", 0, 0x8B3C},
  {"\x37\x7B", 0, 0xE9D9},
  {"\x3D\x6F", 0, 0x8986},
  {"\x3E\x47", 0, 0x5379},
  {"\x3F\x24", 0, 0x614E},
  {"\x40\x4F", 0, 0x638A},
  {"\x42\x4F", 0, 0xE985},
  {"\x44\x72", 0, 0x7881},
  {"\x45\x6D", 0, 0x8263},
  {"\x46\x21", 0, 0x9A69},
  {"\x46\x29", 0, 0x4E97},
  {"\x46\x2B", 0, 0x5E30},
  {"\x47\x6F", 0, 0x51C8},
  {"\x49\x26", 0, 0x6E08},
  {"\x49\x56", 0, 0x7832},
  {"\x4A\x28", 0, 0x9DF0},
  {"\x4A\x60", 0, 0x7266},
  {"\x4C\x3C", 0, 0x7582},
  {"\x51\x6D", 0, 0x6403},
  {"\x55\x64", 0, 0x61DE},
  {"\x56\x31", 0, 0x517F},
  {"\x59\x59", 0, 0x8276},
  {"\x5E\x60", 0, 0x9586},
  {"\x5F\x34", 0, 0xE9F9},
  {"\x5F\x35", 0, 0x6B9E},
  {"\x5F\x49", 0, 0x7431},
  {"\x61\x4C", 0, 0x99C5},
  {"\x61\x79", 0, 0x5C1F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page642 = {
  marc8_9page642_flat, 0
};
/* PAGE 641 */
struct yaz_iconv_trie_flat marc8_9page641_flat[] = {
  {"\x2D\x44", 0, 0x8842},
  {"\x39\x22", 0, 0x8DB5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page641 = {
  marc8_9page641_flat, 0
};
/* PAGE 640 */
struct yaz_iconv_trie_flat marc8_9page640_flat[] = {
  {"\x28\x4C", 0, 0xE984},
  {"\x2F\x7C", 0, 0x64C0},
  {"\x3B\x7D", 0, 0x67B1},
  {"\x40\x34", 0, 0x6855},
  {"\x6A\x7C", 0, 0x7BEA},
  {"\x78\x7D", 0, 0x80FC},
  {"\x79\x70", 0, 0x81D5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page640 = {
  marc8_9page640_flat, 0
};
/* PAGE 639 */
struct yaz_iconv_trie_flat marc8_9page639_flat[] = {
  {"\x6B", 0, 0x60A4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page639 = {
  marc8_9page639_flat, 0
};
/* PAGE 638 */
struct yaz_iconv_trie_flat marc8_9page638_flat[] = {
  {"\x2F", 0, 0x521F},
  {"\x33", 0, 0xE9F8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page638 = {
  marc8_9page638_flat, 0
};
/* PAGE 637 */
struct yaz_iconv_trie_flat marc8_9page637_flat[] = {
  {"\x23", 0, 0xE983},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page637 = {
  marc8_9page637_flat, 0
};
/* PAGE 636 */
struct yaz_iconv_trie_flat marc8_9page636_flat[] = {
  {"\x67", 0, 0x9B2A},
  {"\x79", 0, 0x5C20},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page636 = {
  marc8_9page636_flat, 0
};
/* PAGE 635 */
struct yaz_iconv_trie_flat marc8_9page635_flat[] = {
  {"\x74", 0, 0x55B0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page635 = {
  marc8_9page635_flat, 0
};
/* PAGE 634 */
struct yaz_iconv_trie_flat marc8_9page634_flat[] = {
  {"\x49", 0, 0x5F6B},
  {"\x68", 0, 0x8987},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page634 = {
  marc8_9page634_flat, 0
};
/* PAGE 633 */
struct yaz_iconv_trie_flat marc8_9page633_flat[] = {
  {"\x2F", 0, 0x5277},
  {"\x3D", 0, 0x9295},
  {"\x42", 0, 0x9274},
  {"\x6F", 0, 0x7A7D},
  {"\x71", 0, 0x5742},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page633 = {
  marc8_9page633_flat, 0
};
/* PAGE 632 */
struct yaz_iconv_trie_flat marc8_9page632_flat[] = {
  {"\x23", 0, 0x91BB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page632 = {
  marc8_9page632_flat, 0
};
/* PAGE 631 */
struct yaz_iconv_trie_flat marc8_9page631_flat[] = {
  {"\x2F", 0, 0x58F2},
  {"\x36", 0, 0x983C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page631 = {
  marc8_9page631_flat, 0
};
/* PAGE 630 */
struct yaz_iconv_trie_flat marc8_9page630_flat[] = {
  {"\x3F", 0, 0x8A3C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page630 = {
  marc8_9page630_flat, 0
};
/* PAGE 629 */
struct yaz_iconv_trie_flat marc8_9page629_flat[] = {
  {"\x21", 0, 0x97E4},
  {"\x29", 0, 0x69FB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page629 = {
  marc8_9page629_flat, 0
};
/* PAGE 628 */
struct yaz_iconv_trie_flat marc8_9page628_flat[] = {
  {"\x73", 0, 0x7DAF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page628 = {
  marc8_9page628_flat, 0
};
/* PAGE 627 */
struct yaz_iconv_trie_flat marc8_9page627_flat[] = {
  {"\x3C", 0, 0x56CC},
  {"\x43", 0, 0x4E55},
  {"\x52", 0, 0x87A1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page627 = {
  marc8_9page627_flat, 0
};
/* PAGE 626 */
struct yaz_iconv_trie_flat marc8_9page626_flat[] = {
  {"\x3C", 0, 0x5D0B},
  {"\x64", 0, 0x6726},
  {"\x68", 0, 0x83DD},
  {"\x77", 0, 0x854B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page626 = {
  marc8_9page626_flat, 0
};
/* PAGE 625 */
struct yaz_iconv_trie_flat marc8_9page625_flat[] = {
  {"\x77", 0, 0x85A6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page625 = {
  marc8_9page625_flat, 0
};
/* PAGE 624 */
struct yaz_iconv_trie_flat marc8_9page624_flat[] = {
  {"\x30", 0, 0x5BD8},
  {"\x5B", 0, 0x66DC},
  {"\x6B", 0, 0x7094},
  {"\x6B", 0, 0x7094},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page624 = {
  marc8_9page624_flat, 0
};
/* PAGE 623 */
struct yaz_iconv_trie_flat marc8_9page623_flat[] = {
  {"\x79", 0, 0x7D75},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page623 = {
  marc8_9page623_flat, 0
};
/* PAGE 622 */
struct yaz_iconv_trie_flat marc8_9page622_flat[] = {
  {"\x50", 0, 0x7BED},
  {"\x5B", 0, 0x9B3B},
  {"\x63", 0, 0x9939},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page622 = {
  marc8_9page622_flat, 0
};
/* PAGE 621 */
struct yaz_iconv_trie_flat marc8_9page621_flat[] = {
  {"\x2D", 0, 0x7546},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page621 = {
  marc8_9page621_flat, 0
};
/* PAGE 620 */
struct yaz_iconv_trie_flat marc8_9page620_flat[] = {
  {"\x60", 0, 0x9AE6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page620 = {
  marc8_9page620_flat, 0
};
/* PAGE 619 */
struct yaz_iconv_trie_flat marc8_9page619_flat[] = {
  {"\x28", 0, 0x6D5C},
  {"\x44", 0, 0x6B12},
  {"\x56", 0, 0x792E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page619 = {
  marc8_9page619_flat, 0
};
/* PAGE 618 */
struct yaz_iconv_trie_flat marc8_9page618_flat[] = {
  {"\x3B", 0, 0x9061},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page618 = {
  marc8_9page618_flat, 0
};
/* PAGE 617 */
struct yaz_iconv_trie_flat marc8_9page617_flat[] = {
  {"\x35", 0, 0x6C3E},
  {"\x6F", 0, 0x51C0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page617 = {
  marc8_9page617_flat, 0
};
/* PAGE 616 */
struct yaz_iconv_trie_flat marc8_9page616_flat[] = {
  {"\x34", 0, 0xE982},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page616 = {
  marc8_9page616_flat, 0
};
/* PAGE 615 */
struct yaz_iconv_trie_flat marc8_9page615_flat[] = {
  {"\x6D", 0, 0x826B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page615 = {
  marc8_9page615_flat, 0
};
/* PAGE 614 */
struct yaz_iconv_trie_flat marc8_9page614_flat[] = {
  {"\x44", 0, 0x8988},
  {"\x7D", 0, 0x6AC2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page614 = {
  marc8_9page614_flat, 0
};
/* PAGE 613 */
struct yaz_iconv_trie_flat marc8_9page613_flat[] = {
  {"\x30", 0, 0x6644},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page613 = {
  marc8_9page613_flat, 0
};
/* PAGE 612 */
struct yaz_iconv_trie_flat marc8_9page612_flat[] = {
  {"\x43", 0, 0x4FF2},
  {"\x4F", 0, 0x5554},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page612 = {
  marc8_9page612_flat, 0
};
/* PAGE 611 */
struct yaz_iconv_trie_flat marc8_9page611_flat[] = {
  {"\x7C", 0, 0x62E0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page611 = {
  marc8_9page611_flat, 0
};
/* PAGE 610 */
struct yaz_iconv_trie_flat marc8_9page610_flat[] = {
  {"\x22", 0, 0x6443},
  {"\x42", 0, 0x646D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page610 = {
  marc8_9page610_flat, 0
};
/* PAGE 609 */
struct yaz_iconv_trie_flat marc8_9page609_flat[] = {
  {"\x47", 0, 0x8CC9},
  {"\x4C", 0, 0x6142},
  {"\x61", 0, 0x60AA},
  {"\x7D", 0, 0x7609},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page609 = {
  marc8_9page609_flat, 0
};
/* PAGE 608 */
struct yaz_iconv_trie_flat marc8_9page608_flat[] = {
  {"\x6F", 0, 0x8907},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page608 = {
  marc8_9page608_flat, 0
};
/* PAGE 607 */
struct yaz_iconv_trie_flat marc8_9page607_flat[] = {
  {"\x52", 0, 0x8D26},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page607 = {
  marc8_9page607_flat, 0
};
/* PAGE 606 */
struct yaz_iconv_trie_flat marc8_9page606_flat[] = {
  {"\x39", 0, 0x5BF3},
  {"\x6E", 0, 0x5C97},
  {"\x78", 0, 0xE922},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page606 = {
  marc8_9page606_flat, 0
};
/* PAGE 605 */
struct yaz_iconv_trie_flat marc8_9page605_flat[] = {
  {"\x44", 0, 0x59B3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page605 = {
  marc8_9page605_flat, 0
};
/* PAGE 604 */
struct yaz_iconv_trie_flat marc8_9page604_flat[] = {
  {"\x70", 0, 0x56F2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page604 = {
  marc8_9page604_flat, 0
};
/* PAGE 603 */
struct yaz_iconv_trie_flat marc8_9page603_flat[] = {
  {"\x5A", 0, 0x8AE0},
  {"\x5E", 0, 0x559E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page603 = {
  marc8_9page603_flat, 0
};
/* PAGE 602 */
struct yaz_iconv_trie_flat marc8_9page602_flat[] = {
  {"\x73", 0, 0x5611},
  {"\x77", 0, 0x9FA2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page602 = {
  marc8_9page602_flat, 0
};
/* PAGE 601 */
struct yaz_iconv_trie_flat marc8_9page601_flat[] = {
  {"\x28", 0, 0x5227},
  {"\x39", 0, 0x61C3},
  {"\x5B", 0, 0x965E},
  {"\x60", 0, 0x604A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page601 = {
  marc8_9page601_flat, 0
};
/* PAGE 600 */
struct yaz_iconv_trie_flat marc8_9page600_flat[] = {
  {"\x46", 0, 0x4F1D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page600 = {
  marc8_9page600_flat, 0
};
/* PAGE 599 */
struct yaz_iconv_trie_flat marc8_9page599_flat[] = {
  {"\x2D", 0, 0x534B},
  {"\x3A", 0, 0x5EFC},
  {"\x4C", 0, 0x4E81},
  {"\x52", 0, 0x65BC},
  {"\x54", 0, 0x4F0D},
  {"\x78", 0, 0x9AE3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page599 = {
  marc8_9page599_flat, 0
};
/* PAGE 598 */
struct yaz_iconv_trie_dir marc8_9page598_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {599, 0, 0} /* 30 */,
  {-1, 0, 0},
  {600, 0, 0} /* 32 */,
  {-1, 0, 0},
  {601, 0, 0} /* 34 */,
  {602, 0, 0} /* 35 */,
  {603, 0, 0} /* 36 */,
  {604, 0, 0} /* 37 */,
  {-1, 0, 0},
  {605, 0, 0} /* 39 */,
  {-1, 0, 0},
  {606, 0, 0} /* 3B */,
  {607, 0, 0} /* 3C */,
  {608, 0, 0} /* 3D */,
  {609, 0, 0} /* 3E */,
  {-1, 0, 0},
  {610, 0, 0} /* 40 */,
  {611, 0, 0} /* 41 */,
  {612, 0, 0} /* 42 */,
  {613, 0, 0} /* 43 */,
  {614, 0, 0} /* 44 */,
  {615, 0, 0} /* 45 */,
  {616, 0, 0} /* 46 */,
  {617, 0, 0} /* 47 */,
  {618, 0, 0} /* 48 */,
  {619, 0, 0} /* 49 */,
  {620, 0, 0} /* 4A */,
  {-1, 0, 0},
  {621, 0, 0} /* 4C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {622, 0, 0} /* 50 */,
  {623, 0, 0} /* 51 */,
  {624, 0, 0} /* 52 */,
  {-1, 0, 0},
  {625, 0, 0} /* 54 */,
  {626, 0, 0} /* 55 */,
  {627, 0, 0} /* 56 */,
  {628, 0, 0} /* 57 */,
  {629, 0, 0} /* 58 */,
  {630, 0, 0} /* 59 */,
  {631, 0, 0} /* 5A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {632, 0, 0} /* 5D */,
  {633, 0, 0} /* 5E */,
  {634, 0, 0} /* 5F */,
  {635, 0, 0} /* 60 */,
  {636, 0, 0} /* 61 */,
  {637, 0, 0} /* 62 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {638, 0, 0} /* 6B */,
  {639, 0, 0} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page598 = {
  0, marc8_9page598_dir
};
/* PAGE 597 */
struct yaz_iconv_trie_flat marc8_9page597_flat[] = {
  {"\x34\x4D", 0, 0x8B5B},
  {"\x34\x7B", 0, 0x8B2D},
  {"\x41\x56", 0, 0x91BE},
  {"\x50\x53", 0, 0x98C8},
  {"\x57\x39", 0, 0x9C76},
  {"\x5D\x5C", 0, 0x8C8E},
  {"\x5E\x76", 0, 0x82BE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page597 = {
  marc8_9page597_flat, 0
};
/* PAGE 596 */
struct yaz_iconv_trie_flat marc8_9page596_flat[] = {
  {"\x24\x53", 0, 0x5CBD},
  {"\x38\x75", 0, 0x5FDE},
  {"\x3A\x5B", 0, 0x572C},
  {"\x3E\x38", 0, 0x7BDA},
  {"\x41\x38", 0, 0x8022},
  {"\x41\x77", 0, 0x8264},
  {"\x49\x2F", 0, 0x6D34},
  {"\x51\x75", 0, 0x7162},
  {"\x54\x52", 0, 0x7118},
  {"\x5D\x6B", 0, 0x756D},
  {"\x5E\x3B", 0, 0x80AC},
  {"\x5E\x47", 0, 0x75FE},
  {"\x61\x26", 0, 0x6900},
  {"\x66\x22", 0, 0x589D},
  {"\x68\x2A", 0, 0x7C7C},
  {"\x71\x5A", 0, 0x7E1A},
  {"\x74\x31", 0, 0x58DC},
  {"\x78\x2A", 0, 0x90C5},
  {"\x7D\x24", 0, 0x83C7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page596 = {
  marc8_9page596_flat, 0
};
/* PAGE 595 */
struct yaz_iconv_trie_flat marc8_9page595_flat[] = {
  {"\x45", 0, 0x9F67},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page595 = {
  marc8_9page595_flat, 0
};
/* PAGE 594 */
struct yaz_iconv_trie_flat marc8_9page594_flat[] = {
  {"\x6B", 0, 0x6031},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page594 = {
  marc8_9page594_flat, 0
};
/* PAGE 593 */
struct yaz_iconv_trie_flat marc8_9page593_flat[] = {
  {"\x33", 0, 0x524F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page593 = {
  marc8_9page593_flat, 0
};
/* PAGE 592 */
struct yaz_iconv_trie_flat marc8_9page592_flat[] = {
  {"\x21", 0, 0x6B6F},
  {"\x2B", 0, 0x7ADC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page592 = {
  marc8_9page592_flat, 0
};
/* PAGE 591 */
struct yaz_iconv_trie_flat marc8_9page591_flat[] = {
  {"\x5E", 0, 0x9EAA},
  {"\x5F", 0, 0x8534},
  {"\x75", 0, 0x76BC},
  {"\x7D", 0, 0x6589},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page591 = {
  marc8_9page591_flat, 0
};
/* PAGE 590 */
struct yaz_iconv_trie_flat marc8_9page590_flat[] = {
  {"\x5A", 0, 0x8EB0},
  {"\x62", 0, 0x9A23},
  {"\x79", 0, 0x9C7B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page590 = {
  marc8_9page590_flat, 0
};
/* PAGE 589 */
struct yaz_iconv_trie_flat marc8_9page589_flat[] = {
  {"\x54", 0, 0x985B},
  {"\x58", 0, 0x9855},
  {"\x62", 0, 0x98C3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page589 = {
  marc8_9page589_flat, 0
};
/* PAGE 588 */
struct yaz_iconv_trie_flat marc8_9page588_flat[] = {
  {"\x34", 0, 0x90C4},
  {"\x3D", 0, 0x96B7},
  {"\x43", 0, 0x9D08},
  {"\x49", 0, 0x9D70},
  {"\x73", 0, 0x9759},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page588 = {
  marc8_9page588_flat, 0
};
/* PAGE 587 */
struct yaz_iconv_trie_flat marc8_9page587_flat[] = {
  {"\x21", 0, 0x9221},
  {"\x2F", 0, 0x5257},
  {"\x3D", 0, 0x9244},
  {"\x42", 0, 0x9452},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page587 = {
  marc8_9page587_flat, 0
};
/* PAGE 586 */
struct yaz_iconv_trie_flat marc8_9page586_flat[] = {
  {"\x23", 0, 0x8A76},
  {"\x3B", 0, 0x57DC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page586 = {
  marc8_9page586_flat, 0
};
/* PAGE 585 */
struct yaz_iconv_trie_flat marc8_9page585_flat[] = {
  {"\x70", 0, 0x5EF8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page585 = {
  marc8_9page585_flat, 0
};
/* PAGE 584 */
struct yaz_iconv_trie_flat marc8_9page584_flat[] = {
  {"\x7B", 0, 0x8E28},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page584 = {
  marc8_9page584_flat, 0
};
/* PAGE 583 */
struct yaz_iconv_trie_flat marc8_9page583_flat[] = {
  {"\x41", 0, 0x54D7},
  {"\x58", 0, 0x8C4A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page583 = {
  marc8_9page583_flat, 0
};
/* PAGE 582 */
struct yaz_iconv_trie_flat marc8_9page582_flat[] = {
  {"\x21", 0, 0x97C8},
  {"\x30", 0, 0x658D},
  {"\x34", 0, 0x89E7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page582 = {
  marc8_9page582_flat, 0
};
/* PAGE 581 */
struct yaz_iconv_trie_flat marc8_9page581_flat[] = {
  {"\x2E", 0, 0x880E},
  {"\x38", 0, 0x880F},
  {"\x60", 0, 0x88E0},
  {"\x72", 0, 0x8943},
  {"\x73", 0, 0x88B4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page581 = {
  marc8_9page581_flat, 0
};
/* PAGE 580 */
struct yaz_iconv_trie_flat marc8_9page580_flat[] = {
  {"\x35", 0, 0x85AC},
  {"\x52", 0, 0x87C1},
  {"\x7C", 0, 0x8671},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page580 = {
  marc8_9page580_flat, 0
};
/* PAGE 579 */
struct yaz_iconv_trie_flat marc8_9page579_flat[] = {
  {"\x61", 0, 0x8462},
  {"\x68", 0, 0x8406},
  {"\x77", 0, 0x8602},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page579 = {
  marc8_9page579_flat, 0
};
/* PAGE 578 */
struct yaz_iconv_trie_flat marc8_9page578_flat[] = {
  {"\x45", 0, 0x67C1},
  {"\x46", 0, 0x8221},
  {"\x61", 0, 0x6CD6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page578 = {
  marc8_9page578_flat, 0
};
/* PAGE 577 */
struct yaz_iconv_trie_flat marc8_9page577_flat[] = {
  {"\x33", 0, 0x80BB},
  {"\x47", 0, 0x81D9},
  {"\x7D", 0, 0x9AD5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page577 = {
  marc8_9page577_flat, 0
};
/* PAGE 576 */
struct yaz_iconv_trie_flat marc8_9page576_flat[] = {
  {"\x23", 0, 0x7E8E},
  {"\x28", 0, 0x94B5},
  {"\x30", 0, 0xE981},
  {"\x34", 0, 0x99E1},
  {"\x38", 0, 0x8989},
  {"\x3F", 0, 0x8B71},
  {"\x59", 0, 0x7E59},
  {"\x5B", 0, 0x71FF},
  {"\x76", 0, 0x8061},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page576 = {
  marc8_9page576_flat, 0
};
/* PAGE 575 */
struct yaz_iconv_trie_flat marc8_9page575_flat[] = {
  {"\x2E", 0, 0x7E8D},
  {"\x3C", 0, 0x7D4C},
  {"\x47", 0, 0x7EEE},
  {"\x4C", 0, 0x7DD1},
  {"\x5C", 0, 0x7DAB},
  {"\x6B", 0, 0x7DD0},
  {"\x6D", 0, 0x6374},
  {"\x72", 0, 0x7D89},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page575 = {
  marc8_9page575_flat, 0
};
/* PAGE 574 */
struct yaz_iconv_trie_flat marc8_9page574_flat[] = {
  {"\x2A", 0, 0x9257},
  {"\x2B", 0, 0x724B},
  {"\x65", 0, 0x7A45},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page574 = {
  marc8_9page574_flat, 0
};
/* PAGE 573 */
struct yaz_iconv_trie_flat marc8_9page573_flat[] = {
  {"\x37", 0, 0x5EE9},
  {"\x3A", 0, 0x7A49},
  {"\x59", 0, 0x7A93},
  {"\x5E", 0, 0x7A91},
  {"\x71", 0, 0x54B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page573 = {
  marc8_9page573_flat, 0
};
/* PAGE 572 */
struct yaz_iconv_trie_flat marc8_9page572_flat[] = {
  {"\x37", 0, 0x784E},
  {"\x73", 0, 0x79A5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page572 = {
  marc8_9page572_flat, 0
};
/* PAGE 571 */
struct yaz_iconv_trie_flat marc8_9page571_flat[] = {
  {"\x2C", 0, 0x754D},
  {"\x36", 0, 0xE980},
  {"\x37", 0, 0x8E6F},
  {"\x3E", 0, 0x8E08},
  {"\x7B", 0, 0x767A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page571 = {
  marc8_9page571_flat, 0
};
/* PAGE 570 */
struct yaz_iconv_trie_flat marc8_9page570_flat[] = {
  {"\x28", 0, 0x91BC},
  {"\x58", 0, 0x89DD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page570 = {
  marc8_9page570_flat, 0
};
/* PAGE 569 */
struct yaz_iconv_trie_flat marc8_9page569_flat[] = {
  {"\x2E", 0, 0x6F81},
  {"\x4A", 0, 0x70D6},
  {"\x68", 0, 0x7133},
  {"\x6A", 0, 0x934A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page569 = {
  marc8_9page569_flat, 0
};
/* PAGE 568 */
struct yaz_iconv_trie_flat marc8_9page568_flat[] = {
  {"\x3B", 0, 0x6CDD},
  {"\x5E", 0, 0x67D2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page568 = {
  marc8_9page568_flat, 0
};
/* PAGE 567 */
struct yaz_iconv_trie_flat marc8_9page567_flat[] = {
  {"\x29", 0, 0x6E2B},
  {"\x30", 0, 0x6E5F},
  {"\x40", 0, 0x6D1A},
  {"\x4A", 0, 0x6D1F},
  {"\x55", 0, 0x6FEC},
  {"\x5E", 0, 0x6FB9},
  {"\x5F", 0, 0x60BD},
  {"\x6F", 0, 0x6D44},
  {"\x70", 0, 0x5A6C},
  {"\x7B", 0, 0x904A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page567 = {
  marc8_9page567_flat, 0
};
/* PAGE 566 */
struct yaz_iconv_trie_flat marc8_9page566_flat[] = {
  {"\x21", 0, 0x8B99},
  {"\x33", 0, 0xE97F},
  {"\x3C", 0, 0x6BBB},
  {"\x65", 0, 0x6C61},
  {"\x74", 0, 0x76C5},
  {"\x7A", 0, 0x6CA1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page566 = {
  marc8_9page566_flat, 0
};
/* PAGE 565 */
struct yaz_iconv_trie_flat marc8_9page565_flat[] = {
  {"\x27", 0, 0x6918},
  {"\x50", 0, 0x7F47},
  {"\x6D", 0, 0x826A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page565 = {
  marc8_9page565_flat, 0
};
/* PAGE 564 */
struct yaz_iconv_trie_flat marc8_9page564_flat[] = {
  {"\x25", 0, 0x76C3},
  {"\x49", 0, 0x6144},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page564 = {
  marc8_9page564_flat, 0
};
/* PAGE 563 */
struct yaz_iconv_trie_flat marc8_9page563_flat[] = {
  {"\x2F", 0, 0x664B},
  {"\x3E", 0, 0x95C7},
  {"\x42", 0, 0x7156},
  {"\x57", 0, 0x6702},
  {"\x69", 0, 0x5932},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page563 = {
  marc8_9page563_flat, 0
};
/* PAGE 562 */
struct yaz_iconv_trie_flat marc8_9page562_flat[] = {
  {"\x2A", 0, 0x62E1},
  {"\x3D", 0, 0x53CE},
  {"\x43", 0, 0x52B9},
  {"\x44", 0, 0x6559},
  {"\x56", 0, 0x6B5B},
  {"\x60", 0, 0x89D4},
  {"\x77", 0, 0x65EF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page562 = {
  marc8_9page562_flat, 0
};
/* PAGE 561 */
struct yaz_iconv_trie_flat marc8_9page561_flat[] = {
  {"\x31", 0, 0x6425},
  {"\x7E", 0, 0x629E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page561 = {
  marc8_9page561_flat, 0
};
/* PAGE 560 */
struct yaz_iconv_trie_flat marc8_9page560_flat[] = {
  {"\x45", 0, 0x629B},
  {"\x50", 0, 0x62D5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page560 = {
  marc8_9page560_flat, 0
};
/* PAGE 559 */
struct yaz_iconv_trie_flat marc8_9page559_flat[] = {
  {"\x22", 0, 0xE97E},
  {"\x24", 0, 0x7718},
  {"\x3F", 0, 0x51F4},
  {"\x55", 0, 0x5B3E},
  {"\x58", 0, 0x61F4},
  {"\x5B", 0, 0x6133},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page559 = {
  marc8_9page559_flat, 0
};
/* PAGE 558 */
struct yaz_iconv_trie_flat marc8_9page558_flat[] = {
  {"\x7D", 0, 0x7652},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page558 = {
  marc8_9page558_flat, 0
};
/* PAGE 557 */
struct yaz_iconv_trie_flat marc8_9page557_flat[] = {
  {"\x28", 0, 0x53A8},
  {"\x2A", 0, 0x5E83},
  {"\x2F", 0, 0x5E81},
  {"\x42", 0, 0x7D43},
  {"\x48", 0, 0x5F3A},
  {"\x4C", 0, 0x7030},
  {"\x54", 0, 0x4EFD},
  {"\x75", 0, 0x5FB3},
  {"\x75", 0, 0x5FB3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page557 = {
  marc8_9page557_flat, 0
};
/* PAGE 556 */
struct yaz_iconv_trie_flat marc8_9page556_flat[] = {
  {"\x21", 0, 0x7895},
  {"\x52", 0, 0x8CEC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page556 = {
  marc8_9page556_flat, 0
};
/* PAGE 555 */
struct yaz_iconv_trie_flat marc8_9page555_flat[] = {
  {"\x2F", 0, 0x9029},
  {"\x44", 0, 0x5B2D},
  {"\x63", 0, 0x59C9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page555 = {
  marc8_9page555_flat, 0
};
/* PAGE 554 */
struct yaz_iconv_trie_flat marc8_9page554_flat[] = {
  {"\x6E", 0, 0x576F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page554 = {
  marc8_9page554_flat, 0
};
/* PAGE 553 */
struct yaz_iconv_trie_flat marc8_9page553_flat[] = {
  {"\x68", 0, 0x8FF4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page553 = {
  marc8_9page553_flat, 0
};
/* PAGE 552 */
struct yaz_iconv_trie_flat marc8_9page552_flat[] = {
  {"\x23", 0, 0x9F69},
  {"\x2A", 0, 0x9B28},
  {"\x42", 0, 0x8A92},
  {"\x5A", 0, 0x5405},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page552 = {
  marc8_9page552_flat, 0
};
/* PAGE 551 */
struct yaz_iconv_trie_flat marc8_9page551_flat[] = {
  {"\x29", 0, 0x53DC},
  {"\x4E", 0, 0x608B},
  {"\x56", 0, 0x9A03},
  {"\x5C", 0, 0x5449},
  {"\x64", 0, 0x5415},
  {"\x73", 0, 0x8656},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page551 = {
  marc8_9page551_flat, 0
};
/* PAGE 550 */
struct yaz_iconv_trie_flat marc8_9page550_flat[] = {
  {"\x21", 0, 0x91FC},
  {"\x23", 0, 0x5264},
  {"\x28", 0, 0x523C},
  {"\x75", 0, 0x9628},
  {"\x7D", 0, 0x53C1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page550 = {
  marc8_9page550_flat, 0
};
/* PAGE 549 */
struct yaz_iconv_trie_flat marc8_9page549_flat[] = {
  {"\x23", 0, 0x4E21},
  {"\x2A", 0, 0x4E93},
  {"\x30", 0, 0x518A},
  {"\x3C", 0, 0x6C37},
  {"\x44", 0, 0x51DB},
  {"\x4E", 0, 0x51FE},
  {"\x77", 0, 0x5270},
  {"\x7B", 0, 0x52E6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page549 = {
  marc8_9page549_flat, 0
};
/* PAGE 548 */
struct yaz_iconv_trie_flat marc8_9page548_flat[] = {
  {"\x40", 0, 0x4FFB},
  {"\x51", 0, 0x5FBA},
  {"\x5D", 0, 0x4FA1},
  {"\x7A", 0, 0x5150},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page548 = {
  marc8_9page548_flat, 0
};
/* PAGE 547 */
struct yaz_iconv_trie_flat marc8_9page547_flat[] = {
  {"\x4C", 0, 0x5FA0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page547 = {
  marc8_9page547_flat, 0
};
/* PAGE 546 */
struct yaz_iconv_trie_flat marc8_9page546_flat[] = {
  {"\x21", 0, 0x58F9},
  {"\x3A", 0, 0x8FFA},
  {"\x4C", 0, 0x4E79},
  {"\x51", 0, 0x8CB3},
  {"\x60", 0, 0x4EAF},
  {"\x66", 0, 0x5FC8},
  {"\x6C", 0, 0x8B90},
  {"\x78", 0, 0x5F77},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page546 = {
  marc8_9page546_flat, 0
};
/* PAGE 545 */
struct yaz_iconv_trie_dir marc8_9page545_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {546, 0, 0} /* 30 */,
  {547, 0, 0} /* 31 */,
  {548, 0, 0} /* 32 */,
  {549, 0, 0} /* 33 */,
  {550, 0, 0} /* 34 */,
  {551, 0, 0} /* 35 */,
  {552, 0, 0} /* 36 */,
  {553, 0, 0} /* 37 */,
  {554, 0, 0} /* 38 */,
  {555, 0, 0} /* 39 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {556, 0, 0} /* 3C */,
  {557, 0, 0} /* 3D */,
  {558, 0, 0} /* 3E */,
  {559, 0, 0} /* 3F */,
  {560, 0, 0} /* 40 */,
  {561, 0, 0} /* 41 */,
  {562, 0, 0} /* 42 */,
  {563, 0, 0} /* 43 */,
  {564, 0, 0} /* 44 */,
  {565, 0, 0} /* 45 */,
  {566, 0, 0} /* 46 */,
  {567, 0, 0} /* 47 */,
  {568, 0, 0} /* 48 */,
  {569, 0, 0} /* 49 */,
  {570, 0, 0} /* 4A */,
  {-1, 0, 0},
  {571, 0, 0} /* 4C */,
  {-1, 0, 0},
  {572, 0, 0} /* 4E */,
  {573, 0, 0} /* 4F */,
  {574, 0, 0} /* 50 */,
  {575, 0, 0} /* 51 */,
  {576, 0, 0} /* 52 */,
  {577, 0, 0} /* 53 */,
  {578, 0, 0} /* 54 */,
  {579, 0, 0} /* 55 */,
  {580, 0, 0} /* 56 */,
  {581, 0, 0} /* 57 */,
  {582, 0, 0} /* 58 */,
  {583, 0, 0} /* 59 */,
  {584, 0, 0} /* 5A */,
  {585, 0, 0} /* 5B */,
  {-1, 0, 0},
  {586, 0, 0} /* 5D */,
  {587, 0, 0} /* 5E */,
  {588, 0, 0} /* 5F */,
  {589, 0, 0} /* 60 */,
  {590, 0, 0} /* 61 */,
  {591, 0, 0} /* 62 */,
  {592, 0, 0} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {593, 0, 0} /* 6B */,
  {594, 0, 0} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {595, 0, 0} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page545 = {
  0, marc8_9page545_dir
};
/* PAGE 544 */
struct yaz_iconv_trie_flat marc8_9page544_flat[] = {
  {"\x25\x2D", 0, 0x6A22},
  {"\x25\x2E", 0, 0x8507},
  {"\x2A\x5A", 0, 0xE9D3},
  {"\x2A\x64", 0, 0x87B5},
  {"\x2A\x73", 0, 0x87CA},
  {"\x2D\x79", 0, 0x88B5},
  {"\x2F\x5D", 0, 0x7E48},
  {"\x31\x2B", 0, 0x89BB},
  {"\x31\x43", 0, 0xE9D4},
  {"\x31\x7D", 0, 0x8A7E},
  {"\x33\x63", 0, 0x8B1A},
  {"\x36\x39", 0, 0x8C7C},
  {"\x38\x33", 0, 0x8D91},
  {"\x38\x6F", 0, 0x8DD7},
  {"\x3A\x5E", 0, 0x8E6E},
  {"\x3B\x63", 0, 0xE9F7},
  {"\x3C\x2D", 0, 0x8F3C},
  {"\x3D\x5D", 0, 0x900E},
  {"\x40\x53", 0, 0x914F},
  {"\x42\x31", 0, 0xE9D5},
  {"\x44\x5F", 0, 0x941A},
  {"\x4A\x2E", 0, 0x90B4},
  {"\x4A\x4A", 0, 0x5F8F},
  {"\x51\x58", 0, 0x7CC7},
  {"\x54\x76", 0, 0x9AE1},
  {"\x57\x5F", 0, 0x9ABE},
  {"\x58\x5C", 0, 0xE9D6},
  {"\x58\x70", 0, 0x9C1B},
  {"\x59\x73", 0, 0x9CEC},
  {"\x5A\x48", 0, 0x9D44},
  {"\x5D\x3C", 0, 0x6EF7},
  {"\x5D\x49", 0, 0x9EA4},
  {"\x5D\x5C", 0, 0x730A},
  {"\x5E\x42", 0, 0x9EC9},
  {"\x5E\x66", 0, 0x9B12},
  {"\x5E\x7D", 0, 0x6641},
  {"\x5F\x45", 0, 0x86A1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page544 = {
  marc8_9page544_flat, 0
};
/* PAGE 543 */
struct yaz_iconv_trie_flat marc8_9page543_flat[] = {
  {"\x24", 0, 0x83F0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page543 = {
  marc8_9page543_flat, 0
};
/* PAGE 542 */
struct yaz_iconv_trie_flat marc8_9page542_flat[] = {
  {"\x2E", 0, 0x831C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page542 = {
  marc8_9page542_flat, 0
};
/* PAGE 541 */
struct yaz_iconv_trie_flat marc8_9page541_flat[] = {
  {"\x5F", 0, 0x8037},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page541 = {
  marc8_9page541_flat, 0
};
/* PAGE 540 */
struct yaz_iconv_trie_flat marc8_9page540_flat[] = {
  {"\x2E", 0, 0x7516},
  {"\x31", 0, 0x7F48},
  {"\x50", 0, 0x7F82},
  {"\x51", 0, 0x7F58},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page540 = {
  marc8_9page540_flat, 0
};
/* PAGE 539 */
struct yaz_iconv_trie_flat marc8_9page539_flat[] = {
  {"\x28", 0, 0x5FAD},
  {"\x5D", 0, 0x7D56},
  {"\x74", 0, 0x7E89},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page539 = {
  marc8_9page539_flat, 0
};
/* PAGE 538 */
struct yaz_iconv_trie_flat marc8_9page538_flat[] = {
  {"\x5A", 0, 0x7E27},
  {"\x7C", 0, 0x7D63},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page538 = {
  marc8_9page538_flat, 0
};
/* PAGE 537 */
struct yaz_iconv_trie_flat marc8_9page537_flat[] = {
  {"\x62", 0, 0x7D4F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page537 = {
  marc8_9page537_flat, 0
};
/* PAGE 536 */
struct yaz_iconv_trie_flat marc8_9page536_flat[] = {
  {"\x35", 0, 0x6CD4},
  {"\x43", 0, 0x9908},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page536 = {
  marc8_9page536_flat, 0
};
/* PAGE 535 */
struct yaz_iconv_trie_flat marc8_9page535_flat[] = {
  {"\x26", 0, 0x7BE0},
  {"\x27", 0, 0x7B2E},
  {"\x3E", 0, 0x7B59},
  {"\x46", 0, 0x7BE6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page535 = {
  marc8_9page535_flat, 0
};
/* PAGE 534 */
struct yaz_iconv_trie_flat marc8_9page534_flat[] = {
  {"\x54", 0, 0x7B04},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page534 = {
  marc8_9page534_flat, 0
};
/* PAGE 533 */
struct yaz_iconv_trie_flat marc8_9page533_flat[] = {
  {"\x4E", 0, 0x8020},
  {"\x6F", 0, 0x7A19},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page533 = {
  marc8_9page533_flat, 0
};
/* PAGE 532 */
struct yaz_iconv_trie_flat marc8_9page532_flat[] = {
  {"\x4F", 0, 0x772D},
  {"\x5F", 0, 0x77C1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page532 = {
  marc8_9page532_flat, 0
};
/* PAGE 531 */
struct yaz_iconv_trie_flat marc8_9page531_flat[] = {
  {"\x4A", 0, 0x7690},
  {"\x4A", 0, 0x7690},
  {"\x60", 0, 0x76A1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page531 = {
  marc8_9page531_flat, 0
};
/* PAGE 530 */
struct yaz_iconv_trie_flat marc8_9page530_flat[] = {
  {"\x6F", 0, 0x75B8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page530 = {
  marc8_9page530_flat, 0
};
/* PAGE 529 */
struct yaz_iconv_trie_flat marc8_9page529_flat[] = {
  {"\x40", 0, 0x73B3},
  {"\x78", 0, 0x74A2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page529 = {
  marc8_9page529_flat, 0
};
/* PAGE 528 */
struct yaz_iconv_trie_flat marc8_9page528_flat[] = {
  {"\x52", 0, 0x71FE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page528 = {
  marc8_9page528_flat, 0
};
/* PAGE 527 */
struct yaz_iconv_trie_flat marc8_9page527_flat[] = {
  {"\x5D", 0, 0x715B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page527 = {
  marc8_9page527_flat, 0
};
/* PAGE 526 */
struct yaz_iconv_trie_flat marc8_9page526_flat[] = {
  {"\x6D", 0, 0x70B1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page526 = {
  marc8_9page526_flat, 0
};
/* PAGE 525 */
struct yaz_iconv_trie_flat marc8_9page525_flat[] = {
  {"\x41", 0, 0x7032},
  {"\x56", 0, 0x9800},
  {"\x5D", 0, 0x6DE0},
  {"\x72", 0, 0x6F74},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page525 = {
  marc8_9page525_flat, 0
};
/* PAGE 524 */
struct yaz_iconv_trie_flat marc8_9page524_flat[] = {
  {"\x3D", 0, 0x6D38},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page524 = {
  marc8_9page524_flat, 0
};
/* PAGE 523 */
struct yaz_iconv_trie_flat marc8_9page523_flat[] = {
  {"\x35", 0, 0x6DE5},
  {"\x7B", 0, 0x6E86},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page523 = {
  marc8_9page523_flat, 0
};
/* PAGE 522 */
struct yaz_iconv_trie_flat marc8_9page522_flat[] = {
  {"\x6B", 0, 0x6EA6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page522 = {
  marc8_9page522_flat, 0
};
/* PAGE 521 */
struct yaz_iconv_trie_flat marc8_9page521_flat[] = {
  {"\x2F", 0, 0x6CD9},
  {"\x3B", 0, 0x6E7C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page521 = {
  marc8_9page521_flat, 0
};
/* PAGE 520 */
struct yaz_iconv_trie_flat marc8_9page520_flat[] = {
  {"\x73", 0, 0x6FA3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page520 = {
  marc8_9page520_flat, 0
};
/* PAGE 519 */
struct yaz_iconv_trie_flat marc8_9page519_flat[] = {
  {"\x31", 0, 0x6C73},
  {"\x39", 0, 0xE97D},
  {"\x47", 0, 0x6D64},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page519 = {
  marc8_9page519_flat, 0
};
/* PAGE 518 */
struct yaz_iconv_trie_flat marc8_9page518_flat[] = {
  {"\x70", 0, 0x6CD0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page518 = {
  marc8_9page518_flat, 0
};
/* PAGE 517 */
struct yaz_iconv_trie_flat marc8_9page517_flat[] = {
  {"\x74", 0, 0x6AA9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page517 = {
  marc8_9page517_flat, 0
};
/* PAGE 516 */
struct yaz_iconv_trie_flat marc8_9page516_flat[] = {
  {"\x3D", 0, 0x6AC1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page516 = {
  marc8_9page516_flat, 0
};
/* PAGE 515 */
struct yaz_iconv_trie_flat marc8_9page515_flat[] = {
  {"\x2D", 0, 0x69B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page515 = {
  marc8_9page515_flat, 0
};
/* PAGE 514 */
struct yaz_iconv_trie_flat marc8_9page514_flat[] = {
  {"\x3F", 0, 0x7BA0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page514 = {
  marc8_9page514_flat, 0
};
/* PAGE 513 */
struct yaz_iconv_trie_flat marc8_9page513_flat[] = {
  {"\x62", 0, 0x684A},
  {"\x73", 0, 0x7A1C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page513 = {
  marc8_9page513_flat, 0
};
/* PAGE 512 */
struct yaz_iconv_trie_flat marc8_9page512_flat[] = {
  {"\x22", 0, 0x690F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page512 = {
  marc8_9page512_flat, 0
};
/* PAGE 511 */
struct yaz_iconv_trie_flat marc8_9page511_flat[] = {
  {"\x26", 0, 0x661D},
  {"\x33", 0, 0x80AD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page511 = {
  marc8_9page511_flat, 0
};
/* PAGE 510 */
struct yaz_iconv_trie_flat marc8_9page510_flat[] = {
  {"\x36", 0, 0x66CD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page510 = {
  marc8_9page510_flat, 0
};
/* PAGE 509 */
struct yaz_iconv_trie_flat marc8_9page509_flat[] = {
  {"\x70", 0, 0x714A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page509 = {
  marc8_9page509_flat, 0
};
/* PAGE 508 */
struct yaz_iconv_trie_flat marc8_9page508_flat[] = {
  {"\x29", 0, 0x65B5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page508 = {
  marc8_9page508_flat, 0
};
/* PAGE 507 */
struct yaz_iconv_trie_flat marc8_9page507_flat[] = {
  {"\x3F", 0, 0x52C5},
  {"\x45", 0, 0x69E3},
  {"\x54", 0, 0x657F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page507 = {
  marc8_9page507_flat, 0
};
/* PAGE 506 */
struct yaz_iconv_trie_flat marc8_9page506_flat[] = {
  {"\x28", 0, 0x6528},
  {"\x7B", 0, 0x630E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page506 = {
  marc8_9page506_flat, 0
};
/* PAGE 505 */
struct yaz_iconv_trie_flat marc8_9page505_flat[] = {
  {"\x3A", 0, 0x6332},
  {"\x44", 0, 0x651F},
  {"\x72", 0, 0x5261},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page505 = {
  marc8_9page505_flat, 0
};
/* PAGE 504 */
struct yaz_iconv_trie_flat marc8_9page504_flat[] = {
  {"\x28", 0, 0x640B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page504 = {
  marc8_9page504_flat, 0
};
/* PAGE 503 */
struct yaz_iconv_trie_flat marc8_9page503_flat[] = {
  {"\x7A", 0, 0x6738},
  {"\x7C", 0, 0x634D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page503 = {
  marc8_9page503_flat, 0
};
/* PAGE 502 */
struct yaz_iconv_trie_flat marc8_9page502_flat[] = {
  {"\x79", 0, 0x6128},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page502 = {
  marc8_9page502_flat, 0
};
/* PAGE 501 */
struct yaz_iconv_trie_flat marc8_9page501_flat[] = {
  {"\x5B", 0, 0x605A},
  {"\x74", 0, 0x609B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page501 = {
  marc8_9page501_flat, 0
};
/* PAGE 500 */
struct yaz_iconv_trie_flat marc8_9page500_flat[] = {
  {"\x68", 0, 0x5F51},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page500 = {
  marc8_9page500_flat, 0
};
/* PAGE 499 */
struct yaz_iconv_trie_flat marc8_9page499_flat[] = {
  {"\x4C", 0, 0x5ECF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page499 = {
  marc8_9page499_flat, 0
};
/* PAGE 498 */
struct yaz_iconv_trie_flat marc8_9page498_flat[] = {
  {"\x7B", 0, 0x5D1F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page498 = {
  marc8_9page498_flat, 0
};
/* PAGE 497 */
struct yaz_iconv_trie_dir marc8_9page497_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {498, 0, 0} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {499, 0, 0} /* 28 */,
  {500, 0, 0} /* 29 */,
  {-1, 0, 0},
  {501, 0, 0} /* 2B */,
  {-1, 0, 0},
  {502, 0, 0} /* 2D */,
  {-1, 0, 0},
  {503, 0, 0} /* 2F */,
  {504, 0, 0} /* 30 */,
  {505, 0, 0} /* 31 */,
  {-1, 0, 0},
  {506, 0, 0} /* 33 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {507, 0, 0} /* 36 */,
  {508, 0, 0} /* 37 */,
  {509, 0, 0} /* 38 */,
  {510, 0, 0} /* 39 */,
  {511, 0, 0} /* 3A */,
  {512, 0, 0} /* 3B */,
  {-1, 0, 0},
  {513, 0, 0} /* 3D */,
  {514, 0, 0} /* 3E */,
  {515, 0, 0} /* 3F */,
  {516, 0, 0} /* 40 */,
  {517, 0, 0} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {518, 0, 0} /* 46 */,
  {519, 0, 0} /* 47 */,
  {520, 0, 0} /* 48 */,
  {521, 0, 0} /* 49 */,
  {522, 0, 0} /* 4A */,
  {-1, 0, 0},
  {523, 0, 0} /* 4C */,
  {524, 0, 0} /* 4D */,
  {525, 0, 0} /* 4E */,
  {-1, 0, 0},
  {526, 0, 0} /* 50 */,
  {-1, 0, 0},
  {527, 0, 0} /* 52 */,
  {-1, 0, 0},
  {528, 0, 0} /* 54 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {529, 0, 0} /* 5A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {530, 0, 0} /* 5F */,
  {531, 0, 0} /* 60 */,
  {-1, 0, 0},
  {532, 0, 0} /* 62 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {533, 0, 0} /* 68 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {534, 0, 0} /* 6B */,
  {535, 0, 0} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {536, 0, 0} /* 6F */,
  {537, 0, 0} /* 70 */,
  {538, 0, 0} /* 71 */,
  {-1, 0, 0},
  {539, 0, 0} /* 73 */,
  {540, 0, 0} /* 74 */,
  {-1, 0, 0},
  {541, 0, 0} /* 76 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {542, 0, 0} /* 7C */,
  {543, 0, 0} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page497 = {
  0, marc8_9page497_dir
};
/* PAGE 496 */
struct yaz_iconv_trie_flat marc8_9page496_flat[] = {
  {"\x6A", 0, 0x51A4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page496 = {
  marc8_9page496_flat, 0
};
/* PAGE 495 */
struct yaz_iconv_trie_flat marc8_9page495_flat[] = {
  {"\x44", 0, 0x598D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page495 = {
  marc8_9page495_flat, 0
};
/* PAGE 494 */
struct yaz_iconv_trie_flat marc8_9page494_flat[] = {
  {"\x3A", 0, 0x9654},
  {"\x52", 0, 0x579B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page494 = {
  marc8_9page494_flat, 0
};
/* PAGE 493 */
struct yaz_iconv_trie_flat marc8_9page493_flat[] = {
  {"\x45", 0, 0x56D3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page493 = {
  marc8_9page493_flat, 0
};
/* PAGE 492 */
struct yaz_iconv_trie_flat marc8_9page492_flat[] = {
  {"\x43", 0, 0x55E2},
  {"\x64", 0, 0xE97C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page492 = {
  marc8_9page492_flat, 0
};
/* PAGE 491 */
struct yaz_iconv_trie_flat marc8_9page491_flat[] = {
  {"\x7D", 0, 0x8123},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page491 = {
  marc8_9page491_flat, 0
};
/* PAGE 490 */
struct yaz_iconv_trie_flat marc8_9page490_flat[] = {
  {"\x33", 0, 0xE9F6},
  {"\x5F", 0, 0x5273},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page490 = {
  marc8_9page490_flat, 0
};
/* PAGE 489 */
struct yaz_iconv_trie_flat marc8_9page489_flat[] = {
  {"\x2B", 0, 0x5C28},
  {"\x2D", 0, 0x4E80},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page489 = {
  marc8_9page489_flat, 0
};
/* PAGE 488 */
struct yaz_iconv_trie_flat marc8_9page488_flat[] = {
  {"\x22", 0, 0x9C0C},
  {"\x29", 0, 0x9C53},
  {"\x2C", 0, 0x9F08},
  {"\x35", 0, 0x9D76},
  {"\x41", 0, 0x9D5E},
  {"\x51", 0, 0x5869},
  {"\x52", 0, 0x78B1},
  {"\x5F", 0, 0x83FB},
  {"\x60", 0, 0x5E85},
  {"\x62", 0, 0x9EC4},
  {"\x75", 0, 0x76B7},
  {"\x7E", 0, 0x658B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page488 = {
  marc8_9page488_flat, 0
};
/* PAGE 487 */
struct yaz_iconv_trie_flat marc8_9page487_flat[] = {
  {"\x32", 0, 0x99EE},
  {"\x34", 0, 0x99DE},
  {"\x47", 0, 0x99C8},
  {"\x59", 0, 0x9AC4},
  {"\x5A", 0, 0x8EC6},
  {"\x62", 0, 0x9A0C},
  {"\x6A", 0, 0x6B1D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page487 = {
  marc8_9page487_flat, 0
};
/* PAGE 486 */
struct yaz_iconv_trie_flat marc8_9page486_flat[] = {
  {"\x21", 0, 0x978C},
  {"\x2D", 0, 0x976D},
  {"\x30", 0, 0x97EE},
  {"\x56", 0, 0x980B},
  {"\x78", 0, 0x9920},
  {"\x79", 0, 0x8218},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page486 = {
  marc8_9page486_flat, 0
};
/* PAGE 485 */
struct yaz_iconv_trie_flat marc8_9page485_flat[] = {
  {"\x28", 0, 0x9665},
  {"\x2C", 0, 0x5826},
  {"\x2D", 0, 0x964F},
  {"\x2E", 0, 0x661C},
  {"\x35", 0, 0x78D2},
  {"\x3B", 0, 0x96A0},
  {"\x43", 0, 0x9CEB},
  {"\x46", 0, 0x96BD},
  {"\x4B", 0, 0x96D1},
  {"\x4C", 0, 0x9DC4},
  {"\x63", 0, 0x873A},
  {"\x73", 0, 0xE9D2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page485 = {
  marc8_9page485_flat, 0
};
/* PAGE 484 */
struct yaz_iconv_trie_flat marc8_9page484_flat[] = {
  {"\x21", 0, 0x9418},
  {"\x24", 0, 0x7145},
  {"\x26", 0, 0x7194},
  {"\x28", 0, 0x93C1},
  {"\x3B", 0, 0x92B9},
  {"\x43", 0, 0x92F3},
  {"\x4A", 0, 0x945A},
  {"\x50", 0, 0x9587},
  {"\x61", 0, 0x6FF6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page484 = {
  marc8_9page484_flat, 0
};
/* PAGE 483 */
struct yaz_iconv_trie_flat marc8_9page483_flat[] = {
  {"\x23", 0, 0x9167},
  {"\x2F", 0, 0x9196},
  {"\x56", 0, 0x920E},
  {"\x65", 0, 0x8216},
  {"\x68", 0, 0x8021},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page483 = {
  marc8_9page483_flat, 0
};
/* PAGE 482 */
struct yaz_iconv_trie_flat marc8_9page482_flat[] = {
  {"\x2F", 0, 0x8FE8},
  {"\x3F", 0, 0x5FA7},
  {"\x40", 0, 0x5FA8},
  {"\x48", 0, 0x9013},
  {"\x5A", 0, 0x8FE9},
  {"\x5B", 0, 0x9089},
  {"\x74", 0, 0x96A3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page482 = {
  marc8_9page482_flat, 0
};
/* PAGE 481 */
struct yaz_iconv_trie_flat marc8_9page481_flat[] = {
  {"\x2F", 0, 0x8EB1},
  {"\x42", 0, 0x8F19},
  {"\x43", 0, 0x8EFD},
  {"\x5D", 0, 0x8FA2},
  {"\x5E", 0, 0x8FA7},
  {"\x69", 0, 0x5EF5},
  {"\x7A", 0, 0x8FEF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page481 = {
  marc8_9page481_flat, 0
};
/* PAGE 480 */
struct yaz_iconv_trie_flat marc8_9page480_flat[] = {
  {"\x34", 0, 0x8CAD},
  {"\x3D", 0, 0x8CDB},
  {"\x48", 0, 0x8D71},
  {"\x4E", 0, 0x8D82},
  {"\x5F", 0, 0x8E5F},
  {"\x63", 0, 0x8DE5},
  {"\x7E", 0, 0x8E7B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page480 = {
  marc8_9page480_flat, 0
};
/* PAGE 479 */
struct yaz_iconv_trie_flat marc8_9page479_flat[] = {
  {"\x27", 0, 0x8ACC},
  {"\x2C", 0, 0x8B01},
  {"\x3D", 0, 0x8AE9},
  {"\x41", 0, 0x5629},
  {"\x4C", 0, 0x8B72},
  {"\x4F", 0, 0x8B83},
  {"\x57", 0, 0x7AEA},
  {"\x59", 0, 0x8277},
  {"\x5F", 0, 0x732A},
  {"\x60", 0, 0x72B2},
  {"\x63", 0, 0x8C98},
  {"\x65", 0, 0x72F8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page479 = {
  marc8_9page479_flat, 0
};
/* PAGE 478 */
struct yaz_iconv_trie_flat marc8_9page478_flat[] = {
  {"\x31", 0, 0x89A7},
  {"\x33", 0, 0x752A},
  {"\x36", 0, 0x89E6},
  {"\x4D", 0, 0x548F},
  {"\x56", 0, 0x612C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page478 = {
  marc8_9page478_flat, 0
};
/* PAGE 477 */
struct yaz_iconv_trie_flat marc8_9page477_flat[] = {
  {"\x2B", 0, 0x8797},
  {"\x2D", 0, 0x8748},
  {"\x30", 0, 0x87C7},
  {"\x3B", 0, 0x60F7},
  {"\x49", 0, 0x885E},
  {"\x58", 0, 0x890E},
  {"\x5B", 0, 0x886E},
  {"\x60", 0, 0x5E2C},
  {"\x63", 0, 0x88E1},
  {"\x73", 0, 0x7D5D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page477 = {
  marc8_9page477_flat, 0
};
/* PAGE 476 */
struct yaz_iconv_trie_flat marc8_9page476_flat[] = {
  {"\x2E", 0, 0x8024},
  {"\x35", 0, 0x846F},
  {"\x3C", 0, 0x8613},
  {"\x3F", 0, 0x6A97},
  {"\x64", 0, 0x9F04},
  {"\x75", 0, 0x9F05},
  {"\x7B", 0, 0x8717},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page476 = {
  marc8_9page476_flat, 0
};
/* PAGE 475 */
struct yaz_iconv_trie_flat marc8_9page475_flat[] = {
  {"\x29", 0, 0xE97A},
  {"\x2D", 0, 0x8358},
  {"\x2E", 0, 0xE97B},
  {"\x47", 0, 0x837D},
  {"\x50", 0, 0x585F},
  {"\x54", 0, 0x855A},
  {"\x5A", 0, 0x8386},
  {"\x5B", 0, 0x8385},
  {"\x61", 0, 0x76D6},
  {"\x73", 0, 0x83D4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page475 = {
  marc8_9page475_flat, 0
};
/* PAGE 474 */
struct yaz_iconv_trie_flat marc8_9page474_flat[] = {
  {"\x21", 0, 0x9AD7},
  {"\x24", 0, 0x5367},
  {"\x34", 0, 0x64E7},
  {"\x40", 0, 0x6841},
  {"\x46", 0, 0x8229},
  {"\x47", 0, 0x824A},
  {"\x61", 0, 0x8306},
  {"\x68", 0, 0x6959},
  {"\x6F", 0, 0x83C0},
  {"\x76", 0, 0x8318},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page474 = {
  marc8_9page474_flat, 0
};
/* PAGE 473 */
struct yaz_iconv_trie_flat marc8_9page473_flat[] = {
  {"\x21", 0, 0x7C9B},
  {"\x23", 0, 0x5B8D},
  {"\x2C", 0, 0x6BD3},
  {"\x40", 0, 0x812C},
  {"\x44", 0, 0x8107},
  {"\x4B", 0, 0x80F7},
  {"\x5E", 0, 0x8193},
  {"\x61", 0, 0x811A},
  {"\x7E", 0, 0x81C8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page473 = {
  marc8_9page473_flat, 0
};
/* PAGE 472 */
struct yaz_iconv_trie_flat marc8_9page472_flat[] = {
  {"\x28", 0, 0x9262},
  {"\x2B", 0, 0x9475},
  {"\x32", 0, 0x8FA0},
  {"\x33", 0, 0x7F78},
  {"\x38", 0, 0x898A},
  {"\x40", 0, 0x7FA1},
  {"\x41", 0, 0x7FA3},
  {"\x4A", 0, 0x7FC4},
  {"\x59", 0, 0x98DC},
  {"\x5D", 0, 0x6537},
  {"\x65", 0, 0x79D0},
  {"\x67", 0, 0x79CF},
  {"\x6B", 0, 0x7085},
  {"\x6C", 0, 0x8EAD},
  {"\x7B", 0, 0x8074},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page472 = {
  marc8_9page472_flat, 0
};
/* PAGE 471 */
struct yaz_iconv_trie_flat marc8_9page471_flat[] = {
  {"\x24", 0, 0x5E0B},
  {"\x29", 0, 0x7D25},
  {"\x4A", 0, 0x6DD6},
  {"\x4D", 0, 0x7D2C},
  {"\x6A", 0, 0x7DB3},
  {"\x79", 0, 0x7E62},
  {"\x7D", 0, 0x7D99},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page471 = {
  marc8_9page471_flat, 0
};
/* PAGE 470 */
struct yaz_iconv_trie_flat marc8_9page470_flat[] = {
  {"\x2B", 0, 0x693E},
  {"\x2D", 0, 0x7B5D},
  {"\x36", 0, 0x84D1},
  {"\x4F", 0, 0x7C58},
  {"\x6F", 0, 0x7CFA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page470 = {
  marc8_9page470_flat, 0
};
/* PAGE 469 */
struct yaz_iconv_trie_flat marc8_9page469_flat[] = {
  {"\x29", 0, 0x9F9D},
  {"\x37", 0, 0x7980},
  {"\x3E", 0, 0x7A3E},
  {"\x41", 0, 0x4E69},
  {"\x45", 0, 0x9834},
  {"\x48", 0, 0x7A42},
  {"\x5E", 0, 0x7AB0},
  {"\x6B", 0, 0x7AF8},
  {"\x7C", 0, 0x7B5E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page469 = {
  marc8_9page469_flat, 0
};
/* PAGE 468 */
struct yaz_iconv_trie_flat marc8_9page468_flat[] = {
  {"\x24", 0, 0x6998},
  {"\x33", 0, 0x78AA},
  {"\x5B", 0, 0x945B},
  {"\x79", 0, 0x5FA1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page468 = {
  marc8_9page468_flat, 0
};
/* PAGE 467 */
struct yaz_iconv_trie_flat marc8_9page467_flat[] = {
  {"\x21", 0, 0x7681},
  {"\x34", 0, 0x76C7},
  {"\x38", 0, 0x76D7},
  {"\x4F", 0, 0x771F},
  {"\x5F", 0, 0x7741},
  {"\x65", 0, 0x53E1},
  {"\x6D", 0, 0x7792},
  {"\x71", 0, 0x7719},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page467 = {
  marc8_9page467_flat, 0
};
/* PAGE 466 */
struct yaz_iconv_trie_flat marc8_9page466_flat[] = {
  {"\x2C", 0, 0x583A},
  {"\x2D", 0, 0x756E},
  {"\x35", 0, 0x7567},
  {"\x3C", 0, 0x53E0},
  {"\x3E", 0, 0x758E},
  {"\x5D", 0, 0x7661},
  {"\x7E", 0, 0x4F70},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page466 = {
  marc8_9page466_flat, 0
};
/* PAGE 465 */
struct yaz_iconv_trie_flat marc8_9page465_flat[] = {
  {"\x22", 0, 0x736A},
  {"\x35", 0, 0x73C9},
  {"\x3F", 0, 0x73CE},
  {"\x43", 0, 0x746F},
  {"\x45", 0, 0x6BEC},
  {"\x5B", 0, 0x78AF},
  {"\x71", 0, 0x7F3E},
  {"\x72", 0, 0x7506},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page465 = {
  marc8_9page465_flat, 0
};
/* PAGE 464 */
struct yaz_iconv_trie_flat marc8_9page464_flat[] = {
  {"\x26", 0, 0x713C},
  {"\x28", 0, 0x8B8C},
  {"\x34", 0, 0x718F},
  {"\x3B", 0, 0x4E89},
  {"\x45", 0, 0x5C12},
  {"\x46", 0, 0x58BB},
  {"\x58", 0, 0x7F9D},
  {"\x5B", 0, 0x7282},
  {"\x60", 0, 0x6C02},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page464 = {
  marc8_9page464_flat, 0
};
/* PAGE 463 */
struct yaz_iconv_trie_flat marc8_9page463_flat[] = {
  {"\x3A", 0, 0x702C},
  {"\x47", 0, 0x7AC8},
  {"\x54", 0, 0x70F1},
  {"\x56", 0, 0x70B0},
  {"\x6B", 0, 0x70DF},
  {"\x71", 0, 0x70A4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page463 = {
  marc8_9page463_flat, 0
};
/* PAGE 462 */
struct yaz_iconv_trie_flat marc8_9page462_flat[] = {
  {"\x29", 0, 0x51CF},
  {"\x2F", 0, 0x6E07},
  {"\x44", 0, 0x6FD5},
  {"\x45", 0, 0x6E29},
  {"\x50", 0, 0x6EDA},
  {"\x53", 0, 0x7001},
  {"\x5C", 0, 0x6F44},
  {"\x6B", 0, 0x6F82},
  {"\x6E", 0, 0xE9F5},
  {"\x74", 0, 0x6F5C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page462 = {
  marc8_9page462_flat, 0
};
/* PAGE 461 */
struct yaz_iconv_trie_flat marc8_9page461_flat[] = {
  {"\x29", 0, 0x6D29},
  {"\x30", 0, 0x51B5},
  {"\x35", 0, 0x6C4E},
  {"\x38", 0, 0x6FFC},
  {"\x46", 0, 0x6C79},
  {"\x56", 0, 0x6F94},
  {"\x5B", 0, 0x51C9},
  {"\x5F", 0, 0x51C4},
  {"\x68", 0, 0xE979},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page461 = {
  marc8_9page461_flat, 0
};
/* PAGE 460 */
struct yaz_iconv_trie_flat marc8_9page460_flat[] = {
  {"\x21", 0, 0x61FD},
  {"\x2C", 0, 0x6B7A},
  {"\x47", 0, 0x6BD8},
  {"\x6D", 0, 0x51B3},
  {"\x74", 0, 0x51B2},
  {"\x7C", 0, 0x6CB2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page460 = {
  marc8_9page460_flat, 0
};
/* PAGE 459 */
struct yaz_iconv_trie_flat marc8_9page459_flat[] = {
  {"\x39", 0, 0x6406},
  {"\x3A", 0, 0x6760},
  {"\x43", 0, 0x6901},
  {"\x4E", 0, 0x697D},
  {"\x50", 0, 0x58AB},
  {"\x62", 0, 0x681D},
  {"\x64", 0, 0x68B9},
  {"\x69", 0, 0x6AC9},
  {"\x74", 0, 0x5FFB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page459 = {
  marc8_9page459_flat, 0
};
/* PAGE 458 */
struct yaz_iconv_trie_flat marc8_9page458_flat[] = {
  {"\x25", 0, 0x686E},
  {"\x2D", 0, 0x6780},
  {"\x37", 0, 0x67FE},
  {"\x3A", 0, 0x6942},
  {"\x40", 0, 0x6822},
  {"\x44", 0, 0x69C5},
  {"\x4B", 0, 0x6852},
  {"\x50", 0, 0x8308},
  {"\x61", 0, 0x6746},
  {"\x66", 0, 0x6973},
  {"\x6B", 0, 0x6936},
  {"\x72", 0, 0x68CA},
  {"\x74", 0, 0xE978},
  {"\x7D", 0, 0x684C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page458 = {
  marc8_9page458_flat, 0
};
/* PAGE 457 */
struct yaz_iconv_trie_flat marc8_9page457_flat[] = {
  {"\x27", 0, 0x6630},
  {"\x29", 0, 0x668E},
  {"\x2E", 0, 0x66EC},
  {"\x3B", 0, 0x6662},
  {"\x3E", 0, 0x667B},
  {"\x43", 0, 0x6636},
  {"\x48", 0, 0x6681},
  {"\x49", 0, 0x66A6},
  {"\x5F", 0, 0x6716},
  {"\x62", 0, 0x6722},
  {"\x64", 0, 0x671E},
  {"\x70", 0, 0x6736},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page457 = {
  marc8_9page457_flat, 0
};
/* PAGE 456 */
struct yaz_iconv_trie_flat marc8_9page456_flat[] = {
  {"\x28", 0, 0x5117},
  {"\x49", 0, 0x53D9},
  {"\x4F", 0, 0x555F},
  {"\x72", 0, 0x65E3},
  {"\x77", 0, 0x65EE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page456 = {
  marc8_9page456_flat, 0
};
/* PAGE 455 */
struct yaz_iconv_trie_flat marc8_9page455_flat[] = {
  {"\x22", 0, 0x6485},
  {"\x32", 0, 0x642F},
  {"\x41", 0, 0x63B2},
  {"\x47", 0, 0x6271},
  {"\x50", 0, 0x6428},
  {"\x52", 0, 0x6447},
  {"\x53", 0, 0x64E3},
  {"\x54", 0, 0x635C},
  {"\x6E", 0, 0x6534},
  {"\x71", 0, 0x62CA},
  {"\x76", 0, 0x6483},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page455 = {
  marc8_9page455_flat, 0
};
/* PAGE 454 */
struct yaz_iconv_trie_flat marc8_9page454_flat[] = {
  {"\x29", 0, 0x5214},
  {"\x31", 0, 0x64A6},
  {"\x39", 0, 0x67C6},
  {"\x3F", 0, 0x6255},
  {"\x49", 0, 0x67B4},
  {"\x4C", 0, 0x6283},
  {"\x4F", 0, 0x6294},
  {"\x66", 0, 0x63CE},
  {"\x67", 0, 0x62CF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page454 = {
  marc8_9page454_flat, 0
};
/* PAGE 453 */
struct yaz_iconv_trie_flat marc8_9page453_flat[] = {
  {"\x24", 0, 0x661A},
  {"\x27", 0, 0x6120},
  {"\x2A", 0, 0x5ABF},
  {"\x31", 0, 0x6159},
  {"\x3A", 0, 0x6185},
  {"\x54", 0, 0x61D0},
  {"\x67", 0, 0x621E},
  {"\x6E", 0, 0x6226},
  {"\x6F", 0, 0x622F},
  {"\x76", 0, 0x78A5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page453 = {
  marc8_9page453_flat, 0
};
/* PAGE 452 */
struct yaz_iconv_trie_flat marc8_9page452_flat[] = {
  {"\x2B", 0, 0x6060},
  {"\x3C", 0, 0x803B},
  {"\x40", 0, 0x6052},
  {"\x60", 0, 0x6075},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page452 = {
  marc8_9page452_flat, 0
};
/* PAGE 451 */
struct yaz_iconv_trie_flat marc8_9page451_flat[] = {
  {"\x29", 0, 0x53AE},
  {"\x2B", 0, 0x5EBF},
  {"\x2D", 0, 0x5396},
  {"\x2F", 0, 0x539B},
  {"\x34", 0, 0x5EFE},
  {"\x48", 0, 0x5F4A},
  {"\x4E", 0, 0x7BF2},
  {"\x50", 0, 0x5F5C},
  {"\x5E", 0, 0x9AF4},
  {"\x67", 0, 0x9015},
  {"\x6C", 0, 0x5F93},
  {"\x75", 0, 0x60EA},
  {"\x76", 0, 0x5FB4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page451 = {
  marc8_9page451_flat, 0
};
/* PAGE 450 */
struct yaz_iconv_trie_flat marc8_9page450_flat[] = {
  {"\x21", 0, 0x57FC},
  {"\x22", 0, 0x5D10},
  {"\x26", 0, 0x5D18},
  {"\x36", 0, 0x5DE3},
  {"\x38", 0, 0x9245},
  {"\x49", 0, 0x83F7},
  {"\x5F", 0, 0x6A66},
  {"\x61", 0, 0x5E47},
  {"\x65", 0, 0x79CA},
  {"\x6A", 0, 0x51FC},
  {"\x6D", 0, 0xE921},
  {"\x6E", 0, 0x7240},
  {"\x70", 0, 0x576B},
  {"\x7C", 0, 0x83F4},
  {"\x7D", 0, 0x53A2},
  {"\x7E", 0, 0x53A0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page450 = {
  marc8_9page450_flat, 0
};
/* PAGE 449 */
struct yaz_iconv_trie_flat marc8_9page449_flat[] = {
  {"\x27", 0, 0x51A8},
  {"\x2A", 0, 0x5EBD},
  {"\x33", 0, 0x8A67},
  {"\x3F", 0, 0x5C02},
  {"\x40", 0, 0xE977},
  {"\x52", 0, 0x6EBA},
  {"\x54", 0, 0x5C4A},
  {"\x6E", 0, 0x5D17},
  {"\x77", 0, 0x5CE9},
  {"\x78", 0, 0x5CEF},
  {"\x79", 0, 0x5D8B},
  {"\x7B", 0, 0x5D08},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page449 = {
  marc8_9page449_flat, 0
};
/* PAGE 448 */
struct yaz_iconv_trie_flat marc8_9page448_flat[] = {
  {"\x26", 0, 0x5A3F},
  {"\x2F", 0, 0x58FB},
  {"\x41", 0, 0x5AFA},
  {"\x47", 0, 0x5ACB},
  {"\x60", 0, 0x6588},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page448 = {
  marc8_9page448_flat, 0
};
/* PAGE 447 */
struct yaz_iconv_trie_flat marc8_9page447_flat[] = {
  {"\x21", 0, 0x591F},
  {"\x29", 0, 0x6B80},
  {"\x2F", 0, 0x7287},
  {"\x31", 0, 0x67F0},
  {"\x32", 0, 0x7AD2},
  {"\x44", 0, 0x511E},
  {"\x4D", 0, 0x59AC},
  {"\x54", 0, 0x7385},
  {"\x56", 0, 0x59D9},
  {"\x6E", 0, 0x4F84},
  {"\x70", 0, 0x5A63},
  {"\x74", 0, 0x5B43},
  {"\x7B", 0, 0x5A31},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page447 = {
  marc8_9page447_flat, 0
};
/* PAGE 446 */
struct yaz_iconv_trie_flat marc8_9page446_flat[] = {
  {"\x21", 0, 0x962F},
  {"\x30", 0, 0x573B},
  {"\x3F", 0, 0x575A},
  {"\x4A", 0, 0x5872},
  {"\x52", 0, 0x51A2},
  {"\x54", 0, 0x5896},
  {"\x6E", 0, 0x58CA},
  {"\x76", 0, 0x58F7},
  {"\x77", 0, 0x5900},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page446 = {
  marc8_9page446_flat, 0
};
/* PAGE 445 */
struct yaz_iconv_trie_flat marc8_9page445_flat[] = {
  {"\x30", 0, 0x751E},
  {"\x48", 0, 0x8B5F},
  {"\x49", 0, 0x5650},
  {"\x58", 0, 0x54BD},
  {"\x65", 0, 0x8086},
  {"\x68", 0, 0x56EC},
  {"\x6F", 0, 0x5700},
  {"\x7C", 0, 0x962C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page445 = {
  marc8_9page445_flat, 0
};
/* PAGE 444 */
struct yaz_iconv_trie_flat marc8_9page444_flat[] = {
  {"\x22", 0, 0x8AEE},
  {"\x2A", 0, 0x95A7},
  {"\x32", 0, 0x8A7B},
  {"\x42", 0, 0x6B38},
  {"\x44", 0, 0x5557},
  {"\x61", 0, 0x6199},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page444 = {
  marc8_9page444_flat, 0
};
/* PAGE 443 */
struct yaz_iconv_trie_flat marc8_9page443_flat[] = {
  {"\x39", 0, 0x52FE},
  {"\x3C", 0, 0x6B62},
  {"\x43", 0, 0x4EDD},
  {"\x47", 0, 0x55AB},
  {"\x56", 0, 0x7343},
  {"\x5C", 0, 0x5434},
  {"\x6A", 0, 0x8A36},
  {"\x71", 0, 0x546A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page443 = {
  marc8_9page443_flat, 0
};
/* PAGE 442 */
struct yaz_iconv_trie_flat marc8_9page442_flat[] = {
  {"\x21", 0, 0x5294},
  {"\x28", 0, 0x5226},
  {"\x2E", 0, 0x8274},
  {"\x36", 0, 0x52F3},
  {"\x3C", 0, 0x52A2},
  {"\x3D", 0, 0x52E7},
  {"\x53", 0, 0x758B},
  {"\x57", 0, 0x62FE},
  {"\x58", 0, 0x4EDF},
  {"\x5B", 0, 0x6607},
  {"\x5D", 0, 0x5349},
  {"\x64", 0, 0x613D},
  {"\x6A", 0, 0x5918},
  {"\x6E", 0, 0x5373},
  {"\x6E", 0, 0x5373},
  {"\x73", 0, 0x5374},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page442 = {
  marc8_9page442_flat, 0
};
/* PAGE 441 */
struct yaz_iconv_trie_flat marc8_9page441_flat[] = {
  {"\x24", 0, 0x634C},
  {"\x2A", 0, 0x4E0C},
  {"\x32", 0, 0x5190},
  {"\x4F", 0, 0x5202},
  {"\x56", 0, 0xE9F4},
  {"\x5F", 0, 0x52B5},
  {"\x66", 0, 0x5234},
  {"\x6B", 0, 0x5C05},
  {"\x72", 0, 0x5265},
  {"\x77", 0, 0x8CF8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page441 = {
  marc8_9page441_flat, 0
};
/* PAGE 440 */
struct yaz_iconv_trie_flat marc8_9page440_flat[] = {
  {"\x24", 0, 0x7B87},
  {"\x51", 0, 0x510C},
  {"\x53", 0, 0x50E3},
  {"\x5F", 0, 0xE976},
  {"\x61", 0, 0x5039},
  {"\x63", 0, 0x4FAD},
  {"\x72", 0, 0x706E},
  {"\x79", 0, 0x514E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page440 = {
  marc8_9page440_flat, 0
};
/* PAGE 439 */
struct yaz_iconv_trie_flat marc8_9page439_flat[] = {
  {"\x32", 0, 0x4ECF},
  {"\x3A", 0, 0x62BB},
  {"\x40", 0, 0x4F32},
  {"\x47", 0, 0x5002},
  {"\x4C", 0, 0x5008},
  {"\x5F", 0, 0x4FA3},
  {"\x64", 0, 0x7AE2},
  {"\x65", 0, 0xEA04},
  {"\x77", 0, 0x5E78},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page439 = {
  marc8_9page439_flat, 0
};
/* PAGE 438 */
struct yaz_iconv_trie_flat marc8_9page438_flat[] = {
  {"\x21", 0, 0x5F0C},
  {"\x2D", 0, 0x4E17},
  {"\x32", 0, 0x7ADD},
  {"\x45", 0, 0x4E57},
  {"\x51", 0, 0x5F0D},
  {"\x53", 0, 0x4E3C},
  {"\x58", 0, 0x4E9C},
  {"\x5B", 0, 0x4EBE},
  {"\x61", 0, 0x4EB0},
  {"\x6C", 0, 0x8B8E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page438 = {
  marc8_9page438_flat, 0
};
/* PAGE 437 */
struct yaz_iconv_trie_dir marc8_9page437_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {438, 0, 0} /* 30 */,
  {439, 0, 0} /* 31 */,
  {440, 0, 0} /* 32 */,
  {441, 0, 0} /* 33 */,
  {442, 0, 0} /* 34 */,
  {443, 0, 0} /* 35 */,
  {444, 0, 0} /* 36 */,
  {445, 0, 0} /* 37 */,
  {446, 0, 0} /* 38 */,
  {447, 0, 0} /* 39 */,
  {448, 0, 0} /* 3A */,
  {449, 0, 0} /* 3B */,
  {450, 0, 0} /* 3C */,
  {451, 0, 0} /* 3D */,
  {452, 0, 0} /* 3E */,
  {453, 0, 0} /* 3F */,
  {454, 0, 0} /* 40 */,
  {455, 0, 0} /* 41 */,
  {456, 0, 0} /* 42 */,
  {457, 0, 0} /* 43 */,
  {458, 0, 0} /* 44 */,
  {459, 0, 0} /* 45 */,
  {460, 0, 0} /* 46 */,
  {461, 0, 0} /* 47 */,
  {462, 0, 0} /* 48 */,
  {463, 0, 0} /* 49 */,
  {464, 0, 0} /* 4A */,
  {465, 0, 0} /* 4B */,
  {466, 0, 0} /* 4C */,
  {467, 0, 0} /* 4D */,
  {468, 0, 0} /* 4E */,
  {469, 0, 0} /* 4F */,
  {470, 0, 0} /* 50 */,
  {471, 0, 0} /* 51 */,
  {472, 0, 0} /* 52 */,
  {473, 0, 0} /* 53 */,
  {474, 0, 0} /* 54 */,
  {475, 0, 0} /* 55 */,
  {476, 0, 0} /* 56 */,
  {477, 0, 0} /* 57 */,
  {478, 0, 0} /* 58 */,
  {479, 0, 0} /* 59 */,
  {480, 0, 0} /* 5A */,
  {481, 0, 0} /* 5B */,
  {482, 0, 0} /* 5C */,
  {483, 0, 0} /* 5D */,
  {484, 0, 0} /* 5E */,
  {485, 0, 0} /* 5F */,
  {486, 0, 0} /* 60 */,
  {487, 0, 0} /* 61 */,
  {488, 0, 0} /* 62 */,
  {489, 0, 0} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {490, 0, 0} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {491, 0, 0} /* 6F */,
  {-1, 0, 0},
  {492, 0, 0} /* 71 */,
  {-1, 0, 0},
  {493, 0, 0} /* 73 */,
  {-1, 0, 0},
  {494, 0, 0} /* 75 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {495, 0, 0} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {496, 0, 0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page437 = {
  0, marc8_9page437_dir
};
/* PAGE 436 */
struct yaz_iconv_trie_flat marc8_9page436_flat[] = {
  {"\x28", 0, 0x9F86},
  {"\x2B", 0, 0x9F85},
  {"\x62", 0, 0x9F9B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page436 = {
  marc8_9page436_flat, 0
};
/* PAGE 435 */
struct yaz_iconv_trie_flat marc8_9page435_flat[] = {
  {"\x2B", 0, 0x9F0D},
  {"\x7B", 0, 0x9F51},
  {"\x7C", 0, 0x9F80},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page435 = {
  marc8_9page435_flat, 0
};
/* PAGE 434 */
struct yaz_iconv_trie_flat marc8_9page434_flat[] = {
  {"\x6A", 0, 0x9EEA},
  {"\x7A", 0, 0x9EFE},
  {"\x7C", 0, 0x9F0B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page434 = {
  marc8_9page434_flat, 0
};
/* PAGE 433 */
struct yaz_iconv_trie_flat marc8_9page433_flat[] = {
  {"\x29", 0, 0x9E71},
  {"\x36", 0, 0x9E2C},
  {"\x3A", 0, 0x9E73},
  {"\x3B", 0, 0x9E42},
  {"\x3C", 0, 0x5364},
  {"\x42", 0, 0x9E7E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page433 = {
  marc8_9page433_flat, 0
};
/* PAGE 432 */
struct yaz_iconv_trie_flat marc8_9page432_flat[] = {
  {"\x28", 0, 0x9E58},
  {"\x3E", 0, 0x9E37},
  {"\x47", 0, 0x9E68},
  {"\x49", 0, 0x9E47},
  {"\x57", 0, 0x9E6B},
  {"\x5B", 0, 0x9E6C},
  {"\x65", 0, 0x9E69},
  {"\x6C", 0, 0x9E6A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page432 = {
  marc8_9page432_flat, 0
};
/* PAGE 431 */
struct yaz_iconv_trie_flat marc8_9page431_flat[] = {
  {"\x2A", 0, 0x9E46},
  {"\x35", 0, 0x9E2B},
  {"\x52", 0, 0x9E4E},
  {"\x59", 0, 0x9E5C},
  {"\x5C", 0, 0x9E5B},
  {"\x60", 0, 0x9E55},
  {"\x6B", 0, 0x9E57},
  {"\x6C", 0, 0x9E4B},
  {"\x77", 0, 0x9E63},
  {"\x79", 0, 0x9E5A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page431 = {
  marc8_9page431_flat, 0
};
/* PAGE 430 */
struct yaz_iconv_trie_flat marc8_9page430_flat[] = {
  {"\x28", 0, 0x9E28},
  {"\x44", 0, 0x9E32},
  {"\x48", 0, 0x9E31},
  {"\x59", 0, 0x9E38},
  {"\x65", 0, 0x9E39},
  {"\x68", 0, 0x9E3A},
  {"\x70", 0, 0x9E48},
  {"\x75", 0, 0x9E41},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page430 = {
  marc8_9page430_flat, 0
};
/* PAGE 429 */
struct yaz_iconv_trie_flat marc8_9page429_flat[] = {
  {"\x21", 0, 0x9CD9},
  {"\x25", 0, 0x9CCC},
  {"\x28", 0, 0x9CD5},
  {"\x29", 0, 0x9CA3},
  {"\x2A", 0, 0x9CD3},
  {"\x32", 0, 0x9CD8},
  {"\x38", 0, 0x9CDF},
  {"\x3A", 0, 0x9C85},
  {"\x3B", 0, 0x9C9F},
  {"\x40", 0, 0x9CBC},
  {"\x4F", 0, 0x9CE2},
  {"\x55", 0, 0x9C8E},
  {"\x58", 0, 0x9C9A},
  {"\x6B", 0, 0x9CA1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page429 = {
  marc8_9page429_flat, 0
};
/* PAGE 428 */
struct yaz_iconv_trie_flat marc8_9page428_flat[] = {
  {"\x22", 0, 0x9CAE},
  {"\x25", 0, 0x9CBA},
  {"\x27", 0, 0x9CB2},
  {"\x28", 0, 0x9CB4},
  {"\x2C", 0, 0x9CB1},
  {"\x2D", 0, 0x9CB7},
  {"\x2F", 0, 0x9CB5},
  {"\x31", 0, 0x9CB6},
  {"\x34", 0, 0x9CBB},
  {"\x3E", 0, 0x9CCA},
  {"\x4B", 0, 0x9CBD},
  {"\x54", 0, 0x9CC4},
  {"\x59", 0, 0x9CC6},
  {"\x5C", 0, 0x9CC7},
  {"\x6A", 0, 0x9CCB},
  {"\x6E", 0, 0x9CA5},
  {"\x71", 0, 0x9CCE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page428 = {
  marc8_9page428_flat, 0
};
/* PAGE 427 */
struct yaz_iconv_trie_flat marc8_9page427_flat[] = {
  {"\x21", 0, 0x9C86},
  {"\x29", 0, 0x9C87},
  {"\x2B", 0, 0x9C90},
  {"\x31", 0, 0x9C8B},
  {"\x39", 0, 0x9C9E},
  {"\x3C", 0, 0x9C91},
  {"\x3D", 0, 0x9C92},
  {"\x42", 0, 0x9C95},
  {"\x56", 0, 0x9CA9},
  {"\x5F", 0, 0x9CA0},
  {"\x6E", 0, 0x9CA7},
  {"\x7A", 0, 0x9CAD},
  {"\x7C", 0, 0x9CB0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page427 = {
  marc8_9page427_flat, 0
};
/* PAGE 426 */
struct yaz_iconv_trie_flat marc8_9page426_flat[] = {
  {"\x3C", 0, 0x9B49},
  {"\x5D", 0, 0x9C82},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page426 = {
  marc8_9page426_flat, 0
};
/* PAGE 425 */
struct yaz_iconv_trie_flat marc8_9page425_flat[] = {
  {"\x6C", 0, 0x960B},
  {"\x74", 0, 0x9604},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page425 = {
  marc8_9page425_flat, 0
};
/* PAGE 424 */
struct yaz_iconv_trie_flat marc8_9page424_flat[] = {
  {"\x21", 0, 0x9AA3},
  {"\x22", 0, 0x9A81},
  {"\x27", 0, 0x9A85},
  {"\x33", 0, 0x9AA7},
  {"\x6D", 0, 0x9ACB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page424 = {
  marc8_9page424_flat, 0
};
/* PAGE 423 */
struct yaz_iconv_trie_flat marc8_9page423_flat[] = {
  {"\x3D", 0, 0x9A90},
  {"\x40", 0, 0x9A92},
  {"\x47", 0, 0x9A93},
  {"\x5A", 0, 0x9A9F},
  {"\x60", 0, 0x9A98},
  {"\x69", 0, 0x9A7A},
  {"\x6A", 0, 0x9A9D},
  {"\x70", 0, 0x9A9C},
  {"\x79", 0, 0x9A96},
  {"\x7A", 0, 0x9AA2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page423 = {
  marc8_9page423_flat, 0
};
/* PAGE 422 */
struct yaz_iconv_trie_flat marc8_9page422_flat[] = {
  {"\x22", 0, 0x98E8},
  {"\x63", 0, 0x9A75},
  {"\x69", 0, 0x9A80},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page422 = {
  marc8_9page422_flat, 0
};
/* PAGE 421 */
struct yaz_iconv_trie_flat marc8_9page421_flat[] = {
  {"\x32", 0, 0x997D},
  {"\x53", 0, 0x9967},
  {"\x66", 0, 0x9969},
  {"\x6A", 0, 0x9990},
  {"\x6D", 0, 0x9991},
  {"\x70", 0, 0x998D},
  {"\x72", 0, 0x9994},
  {"\x75", 0, 0x9993},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page421 = {
  marc8_9page421_flat, 0
};
/* PAGE 420 */
struct yaz_iconv_trie_flat marc8_9page420_flat[] = {
  {"\x21", 0, 0x98A2},
  {"\x29", 0, 0x98A5},
  {"\x30", 0, 0x989E},
  {"\x31", 0, 0x98A7},
  {"\x53", 0, 0x98D9},
  {"\x6C", 0, 0x996B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page420 = {
  marc8_9page420_flat, 0
};
/* PAGE 419 */
struct yaz_iconv_trie_flat marc8_9page419_flat[] = {
  {"\x23", 0, 0x9880},
  {"\x2C", 0, 0x988F},
  {"\x6B", 0, 0x98A1},
  {"\x77", 0, 0x989F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page419 = {
  marc8_9page419_flat, 0
};
/* PAGE 418 */
struct yaz_iconv_trie_flat marc8_9page418_flat[] = {
  {"\x43", 0, 0x97AF},
  {"\x54", 0, 0x97EA},
  {"\x5C", 0, 0x97EB},
  {"\x79", 0, 0x9878},
  {"\x7B", 0, 0x9883},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page418 = {
  marc8_9page418_flat, 0
};
/* PAGE 417 */
struct yaz_iconv_trie_flat marc8_9page417_flat[] = {
  {"\x76", 0, 0x9753},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page417 = {
  marc8_9page417_flat, 0
};
/* PAGE 416 */
struct yaz_iconv_trie_flat marc8_9page416_flat[] = {
  {"\x44", 0, 0x9655},
  {"\x46", 0, 0x9649},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page416 = {
  marc8_9page416_flat, 0
};
/* PAGE 415 */
struct yaz_iconv_trie_flat marc8_9page415_flat[] = {
  {"\x36", 0, 0x95F3},
  {"\x42", 0, 0x9606},
  {"\x44", 0, 0x9603},
  {"\x48", 0, 0x960F},
  {"\x49", 0, 0x9608},
  {"\x4D", 0, 0x9609},
  {"\x4F", 0, 0x960A},
  {"\x50", 0, 0x960C},
  {"\x52", 0, 0x960D},
  {"\x5A", 0, 0x9612},
  {"\x60", 0, 0x9619},
  {"\x69", 0, 0x961A},
  {"\x6F", 0, 0x95FC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page415 = {
  marc8_9page415_flat, 0
};
/* PAGE 414 */
struct yaz_iconv_trie_flat marc8_9page414_flat[] = {
  {"\x3E", 0, 0x9554},
  {"\x3F", 0, 0x9572},
  {"\x4A", 0, 0x956C},
  {"\x5C", 0, 0x9565},
  {"\x69", 0, 0x9567},
  {"\x6F", 0, 0x9569},
  {"\x71", 0, 0x954A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page414 = {
  marc8_9page414_flat, 0
};
/* PAGE 413 */
struct yaz_iconv_trie_flat marc8_9page413_flat[] = {
  {"\x2F", 0, 0x94E9},
  {"\x32", 0, 0x94F4},
  {"\x34", 0, 0x9566},
  {"\x3C", 0, 0x9568},
  {"\x3E", 0, 0x94F9},
  {"\x4D", 0, 0x956B},
  {"\x50", 0, 0x950E},
  {"\x51", 0, 0x950F},
  {"\x58", 0, 0x9561},
  {"\x5E", 0, 0x9562},
  {"\x60", 0, 0x9563},
  {"\x67", 0, 0x94E7},
  {"\x69", 0, 0x9564},
  {"\x74", 0, 0x9571},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page413 = {
  marc8_9page413_flat, 0
};
/* PAGE 412 */
struct yaz_iconv_trie_flat marc8_9page412_flat[] = {
  {"\x21", 0, 0x9553},
  {"\x28", 0, 0x9552},
  {"\x29", 0, 0x84E5},
  {"\x2D", 0, 0x9549},
  {"\x42", 0, 0x94E0},
  {"\x47", 0, 0x954F},
  {"\x4A", 0, 0x953C},
  {"\x56", 0, 0x955B},
  {"\x5A", 0, 0x955F},
  {"\x62", 0, 0x956A},
  {"\x66", 0, 0x933E},
  {"\x7C", 0, 0x9546},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page412 = {
  marc8_9page412_flat, 0
};
/* PAGE 411 */
struct yaz_iconv_trie_flat marc8_9page411_flat[] = {
  {"\x31", 0, 0x9528},
  {"\x32", 0, 0x9531},
  {"\x4D", 0, 0x9534},
  {"\x4E", 0, 0x9545},
  {"\x51", 0, 0x9517},
  {"\x5E", 0, 0x94E1},
  {"\x64", 0, 0x9536},
  {"\x67", 0, 0x9537},
  {"\x68", 0, 0x9518},
  {"\x6F", 0, 0x9538},
  {"\x7A", 0, 0x9550},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page411 = {
  marc8_9page411_flat, 0
};
/* PAGE 410 */
struct yaz_iconv_trie_flat marc8_9page410_flat[] = {
  {"\x27", 0, 0x94D7},
  {"\x2B", 0, 0x9503},
  {"\x2D", 0, 0x94A1},
  {"\x2E", 0, 0x9502},
  {"\x35", 0, 0x950A},
  {"\x3E", 0, 0x94E4},
  {"\x40", 0, 0x9506},
  {"\x41", 0, 0x9507},
  {"\x4D", 0, 0x952B},
  {"\x57", 0, 0x9529},
  {"\x58", 0, 0x952C},
  {"\x5B", 0, 0x9516},
  {"\x66", 0, 0x9515},
  {"\x69", 0, 0x94FC},
  {"\x6D", 0, 0x951B},
  {"\x71", 0, 0x951D},
  {"\x72", 0, 0x951E},
  {"\x74", 0, 0x951F},
  {"\x75", 0, 0x9494},
  {"\x78", 0, 0x9522},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page410 = {
  marc8_9page410_flat, 0
};
/* PAGE 409 */
struct yaz_iconv_trie_flat marc8_9page409_flat[] = {
  {"\x2B", 0, 0x94C6},
  {"\x2F", 0, 0x94F3},
  {"\x31", 0, 0x94F1},
  {"\x35", 0, 0x94F5},
  {"\x40", 0, 0x94D6},
  {"\x43", 0, 0x94D2},
  {"\x46", 0, 0x94D1},
  {"\x49", 0, 0x94D5},
  {"\x4F", 0, 0x94DE},
  {"\x50", 0, 0x94DF},
  {"\x55", 0, 0x94EB},
  {"\x58", 0, 0x94EF},
  {"\x59", 0, 0x94E5},
  {"\x5B", 0, 0x94E3},
  {"\x62", 0, 0x94EA},
  {"\x64", 0, 0x94F7},
  {"\x6A", 0, 0x9512},
  {"\x6C", 0, 0x950D},
  {"\x71", 0, 0x94FD},
  {"\x72", 0, 0x9513},
  {"\x75", 0, 0x9514},
  {"\x7D", 0, 0x94D8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page409 = {
  marc8_9page409_flat, 0
};
/* PAGE 408 */
struct yaz_iconv_trie_flat marc8_9page408_flat[] = {
  {"\x21", 0, 0x9495},
  {"\x22", 0, 0x9490},
  {"\x23", 0, 0x94AD},
  {"\x24", 0, 0x94AA},
  {"\x25", 0, 0x94AB},
  {"\x28", 0, 0x94AC},
  {"\x31", 0, 0x94AF},
  {"\x37", 0, 0x949B},
  {"\x4B", 0, 0x94A3},
  {"\x51", 0, 0x94C8},
  {"\x52", 0, 0x94C9},
  {"\x54", 0, 0x94CB},
  {"\x55", 0, 0x94CA},
  {"\x58", 0, 0x94B0},
  {"\x5C", 0, 0x94CC},
  {"\x5F", 0, 0x94B6},
  {"\x60", 0, 0x94B7},
  {"\x61", 0, 0x94B2},
  {"\x64", 0, 0x94BA},
  {"\x6D", 0, 0x94CD},
  {"\x6F", 0, 0x94BD},
  {"\x74", 0, 0x94BF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page408 = {
  marc8_9page408_flat, 0
};
/* PAGE 407 */
struct yaz_iconv_trie_flat marc8_9page407_flat[] = {
  {"\x5C", 0, 0x917E},
  {"\x5D", 0, 0x917D},
  {"\x61", 0, 0x9487},
  {"\x62", 0, 0x9486},
  {"\x63", 0, 0x948C},
  {"\x64", 0, 0x948B},
  {"\x6A", 0, 0x948D},
  {"\x6B", 0, 0x948E},
  {"\x79", 0, 0x9492},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page407 = {
  marc8_9page407_flat, 0
};
/* PAGE 406 */
struct yaz_iconv_trie_flat marc8_9page406_flat[] = {
  {"\x21", 0, 0x90F8},
  {"\x2B", 0, 0x90BA},
  {"\x2C", 0, 0x90D0},
  {"\x31", 0, 0x909D},
  {"\x40", 0, 0x90E6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page406 = {
  marc8_9page406_flat, 0
};
/* PAGE 405 */
struct yaz_iconv_trie_flat marc8_9page405_flat[] = {
  {"\x23", 0, 0x90CF},
  {"\x4C", 0, 0x90D3},
  {"\x5A", 0, 0x90E7},
  {"\x5C", 0, 0x90AC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page405 = {
  marc8_9page405_flat, 0
};
/* PAGE 404 */
struct yaz_iconv_trie_flat marc8_9page404_flat[] = {
  {"\x4E", 0, 0x8FF8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page404 = {
  marc8_9page404_flat, 0
};
/* PAGE 403 */
struct yaz_iconv_trie_flat marc8_9page403_flat[] = {
  {"\x30", 0, 0x8F98},
  {"\x57", 0, 0x8F79},
  {"\x5A", 0, 0x8F73},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page403 = {
  marc8_9page403_flat, 0
};
/* PAGE 402 */
struct yaz_iconv_trie_flat marc8_9page402_flat[] = {
  {"\x3E", 0, 0x8F71},
  {"\x3F", 0, 0x8F7A},
  {"\x42", 0, 0x8F75},
  {"\x47", 0, 0x8F77},
  {"\x4F", 0, 0x8F78},
  {"\x59", 0, 0x8F82},
  {"\x5B", 0, 0x8F81},
  {"\x6B", 0, 0x8F8B},
  {"\x6D", 0, 0x8F8A},
  {"\x7A", 0, 0x8F8F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page402 = {
  marc8_9page402_flat, 0
};
/* PAGE 401 */
struct yaz_iconv_trie_flat marc8_9page401_flat[] = {
  {"\x2E", 0, 0x8DC4},
  {"\x40", 0, 0x8DF8},
  {"\x46", 0, 0x8E70},
  {"\x57", 0, 0x8DFB},
  {"\x5E", 0, 0x8DF9},
  {"\x5F", 0, 0x8DDE},
  {"\x60", 0, 0x8E2C},
  {"\x6B", 0, 0x8E7F},
  {"\x70", 0, 0x8E9C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page401 = {
  marc8_9page401_flat, 0
};
/* PAGE 400 */
struct yaz_iconv_trie_flat marc8_9page400_flat[] = {
  {"\x66", 0, 0x8DB1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page400 = {
  marc8_9page400_flat, 0
};
/* PAGE 399 */
struct yaz_iconv_trie_flat marc8_9page399_flat[] = {
  {"\x25", 0, 0x8D3D},
  {"\x26", 0, 0x8D5C},
  {"\x3A", 0, 0x8D46},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page399 = {
  marc8_9page399_flat, 0
};
/* PAGE 398 */
struct yaz_iconv_trie_flat marc8_9page398_flat[] = {
  {"\x4E", 0, 0x8D33},
  {"\x51", 0, 0x8D36},
  {"\x5F", 0, 0x8D47},
  {"\x6A", 0, 0x8D53},
  {"\x6B", 0, 0x8D55},
  {"\x70", 0, 0x8D49},
  {"\x7E", 0, 0x8D59},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page398 = {
  marc8_9page398_flat, 0
};
/* PAGE 397 */
struct yaz_iconv_trie_flat marc8_9page397_flat[] = {
  {"\x2D", 0, 0x8C30},
  {"\x37", 0, 0x8C20},
  {"\x39", 0, 0x8C33},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page397 = {
  marc8_9page397_flat, 0
};
/* PAGE 396 */
struct yaz_iconv_trie_flat marc8_9page396_flat[] = {
  {"\x30", 0, 0x8BB4},
  {"\x38", 0, 0x8C29},
  {"\x4D", 0, 0x8C2E},
  {"\x59", 0, 0x8C2F},
  {"\x68", 0, 0x8C35},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page396 = {
  marc8_9page396_flat, 0
};
/* PAGE 395 */
struct yaz_iconv_trie_flat marc8_9page395_flat[] = {
  {"\x25", 0, 0x8BF9},
  {"\x2C", 0, 0x8BFC},
  {"\x36", 0, 0x8BE4},
  {"\x38", 0, 0x8BFD},
  {"\x3B", 0, 0x8C00},
  {"\x40", 0, 0x8C02},
  {"\x44", 0, 0x8C19},
  {"\x45", 0, 0x8BE8},
  {"\x4E", 0, 0x8C0C},
  {"\x57", 0, 0x8C14},
  {"\x59", 0, 0x8C11},
  {"\x5D", 0, 0x8C16},
  {"\x62", 0, 0x8C1D},
  {"\x73", 0, 0x8C21},
  {"\x7A", 0, 0x8BCC},
  {"\x7D", 0, 0x8C27},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page395 = {
  marc8_9page395_flat, 0
};
/* PAGE 394 */
struct yaz_iconv_trie_flat marc8_9page394_flat[] = {
  {"\x2A", 0, 0x8BB5},
  {"\x3B", 0, 0x8BCE},
  {"\x3C", 0, 0x8BD2},
  {"\x3C", 0, 0x8BD2},
  {"\x4F", 0, 0x8BD6},
  {"\x50", 0, 0x8BD3},
  {"\x56", 0, 0x8BE9},
  {"\x5D", 0, 0x8BD4},
  {"\x5E", 0, 0x8BDC},
  {"\x71", 0, 0x8BEE},
  {"\x7E", 0, 0x8C07},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page394 = {
  marc8_9page394_flat, 0
};
/* PAGE 393 */
struct yaz_iconv_trie_flat marc8_9page393_flat[] = {
  {"\x2B", 0, 0x89D1},
  {"\x32", 0, 0x89CC},
  {"\x60", 0, 0x89EF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page393 = {
  marc8_9page393_flat, 0
};
/* PAGE 392 */
struct yaz_iconv_trie_flat marc8_9page392_flat[] = {
  {"\x2D", 0, 0x88E3},
  {"\x32", 0, 0x7962},
  {"\x66", 0, 0x89C7},
  {"\x6F", 0, 0x89CB},
  {"\x7D", 0, 0x89CF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page392 = {
  marc8_9page392_flat, 0
};
/* PAGE 391 */
struct yaz_iconv_trie_flat marc8_9page391_flat[] = {
  {"\x60", 0, 0x88E2},
  {"\x72", 0, 0x88E5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page391 = {
  marc8_9page391_flat, 0
};
/* PAGE 390 */
struct yaz_iconv_trie_flat marc8_9page390_flat[] = {
  {"\x51", 0, 0x8511},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page390 = {
  marc8_9page390_flat, 0
};
/* PAGE 389 */
struct yaz_iconv_trie_flat marc8_9page389_flat[] = {
  {"\x4C", 0, 0x866E},
  {"\x55", 0, 0x86CF},
  {"\x5D", 0, 0x867F},
  {"\x61", 0, 0x86F4},
  {"\x64", 0, 0x877E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page389 = {
  marc8_9page389_flat, 0
};
/* PAGE 388 */
struct yaz_iconv_trie_flat marc8_9page388_flat[] = {
  {"\x55", 0, 0x86F3},
  {"\x6E", 0, 0x86F0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page388 = {
  marc8_9page388_flat, 0
};
/* PAGE 387 */
struct yaz_iconv_trie_flat marc8_9page387_flat[] = {
  {"\x2F", 0, 0x86F1},
  {"\x34", 0, 0x86AC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page387 = {
  marc8_9page387_flat, 0
};
/* PAGE 386 */
struct yaz_iconv_trie_flat marc8_9page386_flat[] = {
  {"\x2A", 0, 0x8539},
  {"\x40", 0, 0x84E0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page386 = {
  marc8_9page386_flat, 0
};
/* PAGE 385 */
struct yaz_iconv_trie_flat marc8_9page385_flat[] = {
  {"\x52", 0, 0x830F},
  {"\x65", 0, 0x82C8},
  {"\x68", 0, 0x8572},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page385 = {
  marc8_9page385_flat, 0
};
/* PAGE 384 */
struct yaz_iconv_trie_flat marc8_9page384_flat[] = {
  {"\x33", 0, 0x84E3},
  {"\x51", 0, 0x84DF},
  {"\x57", 0, 0x835F},
  {"\x58", 0, 0x83B6},
  {"\x61", 0, 0x8360},
  {"\x68", 0, 0x8369},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page384 = {
  marc8_9page384_flat, 0
};
/* PAGE 383 */
struct yaz_iconv_trie_flat marc8_9page383_flat[] = {
  {"\x24", 0, 0x848C},
  {"\x2D", 0, 0x8311},
  {"\x35", 0, 0x82C1},
  {"\x46", 0, 0x8368},
  {"\x4B", 0, 0x835B},
  {"\x5A", 0, 0x8487},
  {"\x64", 0, 0x8489},
  {"\x67", 0, 0x836C},
  {"\x71", 0, 0x835E},
  {"\x74", 0, 0x83B8},
  {"\x77", 0, 0x8297},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page383 = {
  marc8_9page383_flat, 0
};
/* PAGE 382 */
struct yaz_iconv_trie_flat marc8_9page382_flat[] = {
  {"\x33", 0, 0xE920},
  {"\x3A", 0, 0x83BC},
  {"\x7D", 0, 0x835C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page382 = {
  marc8_9page382_flat, 0
};
/* PAGE 381 */
struct yaz_iconv_trie_flat marc8_9page381_flat[] = {
  {"\x3C", 0, 0x836D},
  {"\x3D", 0, 0x836E},
  {"\x75", 0, 0x83B3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page381 = {
  marc8_9page381_flat, 0
};
/* PAGE 380 */
struct yaz_iconv_trie_dir marc8_9page380_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {381, 0, 0} /* 23 */,
  {382, 0, 0} /* 24 */,
  {383, 0, 0} /* 25 */,
  {384, 0, 0} /* 26 */,
  {385, 0, 0} /* 27 */,
  {386, 0, 0} /* 28 */,
  {-1, 0, 0},
  {387, 0, 0} /* 2A */,
  {388, 0, 0} /* 2B */,
  {389, 0, 0} /* 2C */,
  {390, 0, 0} /* 2D */,
  {-1, 0, 0},
  {391, 0, 0} /* 2F */,
  {392, 0, 0} /* 30 */,
  {393, 0, 0} /* 31 */,
  {394, 0, 0} /* 32 */,
  {395, 0, 0} /* 33 */,
  {396, 0, 0} /* 34 */,
  {397, 0, 0} /* 35 */,
  {398, 0, 0} /* 36 */,
  {399, 0, 0} /* 37 */,
  {400, 0, 0} /* 38 */,
  {-1, 0, 0},
  {401, 0, 0} /* 3A */,
  {402, 0, 0} /* 3B */,
  {403, 0, 0} /* 3C */,
  {404, 0, 0} /* 3D */,
  {-1, 0, 0},
  {405, 0, 0} /* 3F */,
  {406, 0, 0} /* 40 */,
  {407, 0, 0} /* 41 */,
  {408, 0, 0} /* 42 */,
  {409, 0, 0} /* 43 */,
  {410, 0, 0} /* 44 */,
  {411, 0, 0} /* 45 */,
  {412, 0, 0} /* 46 */,
  {413, 0, 0} /* 47 */,
  {414, 0, 0} /* 48 */,
  {415, 0, 0} /* 49 */,
  {416, 0, 0} /* 4A */,
  {-1, 0, 0},
  {417, 0, 0} /* 4C */,
  {-1, 0, 0},
  {418, 0, 0} /* 4E */,
  {419, 0, 0} /* 4F */,
  {420, 0, 0} /* 50 */,
  {421, 0, 0} /* 51 */,
  {422, 0, 0} /* 52 */,
  {423, 0, 0} /* 53 */,
  {424, 0, 0} /* 54 */,
  {425, 0, 0} /* 55 */,
  {426, 0, 0} /* 56 */,
  {427, 0, 0} /* 57 */,
  {428, 0, 0} /* 58 */,
  {429, 0, 0} /* 59 */,
  {430, 0, 0} /* 5A */,
  {431, 0, 0} /* 5B */,
  {432, 0, 0} /* 5C */,
  {433, 0, 0} /* 5D */,
  {434, 0, 0} /* 5E */,
  {435, 0, 0} /* 5F */,
  {436, 0, 0} /* 60 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page380 = {
  0, marc8_9page380_dir
};
/* PAGE 379 */
struct yaz_iconv_trie_flat marc8_9page379_flat[] = {
  {"\x61", 0, 0x82CC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page379 = {
  marc8_9page379_flat, 0
};
/* PAGE 378 */
struct yaz_iconv_trie_flat marc8_9page378_flat[] = {
  {"\x56", 0, 0x8114},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page378 = {
  marc8_9page378_flat, 0
};
/* PAGE 377 */
struct yaz_iconv_trie_flat marc8_9page377_flat[] = {
  {"\x41", 0, 0x8136},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page377 = {
  marc8_9page377_flat, 0
};
/* PAGE 376 */
struct yaz_iconv_trie_flat marc8_9page376_flat[] = {
  {"\x55", 0, 0x80EB},
  {"\x6E", 0, 0x80E8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page376 = {
  marc8_9page376_flat, 0
};
/* PAGE 375 */
struct yaz_iconv_trie_flat marc8_9page375_flat[] = {
  {"\x39", 0, 0x8069},
  {"\x3F", 0, 0x804D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page375 = {
  marc8_9page375_flat, 0
};
/* PAGE 374 */
struct yaz_iconv_trie_flat marc8_9page374_flat[] = {
  {"\x55", 0, 0x8027},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page374 = {
  marc8_9page374_flat, 0
};
/* PAGE 373 */
struct yaz_iconv_trie_flat marc8_9page373_flat[] = {
  {"\x31", 0, 0x7F9F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page373 = {
  marc8_9page373_flat, 0
};
/* PAGE 372 */
struct yaz_iconv_trie_flat marc8_9page372_flat[] = {
  {"\x2E", 0, 0x7F42},
  {"\x31", 0, 0xE91F},
  {"\x72", 0, 0x7F74},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page372 = {
  marc8_9page372_flat, 0
};
/* PAGE 371 */
struct yaz_iconv_trie_flat marc8_9page371_flat[] = {
  {"\x21", 0, 0x7F26},
  {"\x2D", 0, 0x7F2F},
  {"\x49", 0, 0x7F30},
  {"\x4E", 0, 0x7F32},
  {"\x51", 0, 0x7F33},
  {"\x52", 0, 0x7F34},
  {"\x59", 0, 0x7F31},
  {"\x5D", 0, 0x7EA9},
  {"\x60", 0, 0x7F2C},
  {"\x6D", 0, 0x624D},
  {"\x74", 0, 0x7F35},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page371 = {
  marc8_9page371_flat, 0
};
/* PAGE 370 */
struct yaz_iconv_trie_flat marc8_9page370_flat[] = {
  {"\x29", 0, 0x7F17},
  {"\x2A", 0, 0x7F02},
  {"\x31", 0, 0x7F03},
  {"\x36", 0, 0x7F07},
  {"\x3C", 0, 0x7F08},
  {"\x3E", 0, 0x7F0C},
  {"\x47", 0, 0x7F11},
  {"\x48", 0, 0x7F0F},
  {"\x51", 0, 0x7F1F},
  {"\x53", 0, 0x7F12},
  {"\x5D", 0, 0x7F1C},
  {"\x5E", 0, 0x7F19},
  {"\x5F", 0, 0x7F1B},
  {"\x69", 0, 0x7EC9},
  {"\x71", 0, 0xE91E},
  {"\x72", 0, 0x7F21},
  {"\x75", 0, 0x7D77},
  {"\x79", 0, 0x7F25},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page370 = {
  marc8_9page370_flat, 0
};
/* PAGE 369 */
struct yaz_iconv_trie_flat marc8_9page369_flat[] = {
  {"\x30", 0, 0x7EDB},
  {"\x34", 0, 0x7ED7},
  {"\x39", 0, 0x7EE8},
  {"\x44", 0, 0x7EE0},
  {"\x4D", 0, 0x7EE1},
  {"\x61", 0, 0x7EFB},
  {"\x67", 0, 0x7EEF},
  {"\x74", 0, 0x7EF2},
  {"\x78", 0, 0x7EF6},
  {"\x7D", 0, 0x7EFA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page369 = {
  marc8_9page369_flat, 0
};
/* PAGE 368 */
struct yaz_iconv_trie_flat marc8_9page368_flat[] = {
  {"\x22", 0, 0x7CC1},
  {"\x2E", 0, 0xE91D},
  {"\x30", 0, 0x7C9D},
  {"\x35", 0, 0x7C74},
  {"\x42", 0, 0x7EA1},
  {"\x45", 0, 0x7EA8},
  {"\x4A", 0, 0x7EBE},
  {"\x61", 0, 0x7EC0},
  {"\x62", 0, 0x7EC1},
  {"\x65", 0, 0x7EC2},
  {"\x6A", 0, 0x7ED0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page368 = {
  marc8_9page368_flat, 0
};
/* PAGE 367 */
struct yaz_iconv_trie_flat marc8_9page367_flat[] = {
  {"\x56", 0, 0x7BA8},
  {"\x68", 0, 0x7B3E},
  {"\x69", 0, 0x7C16},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page367 = {
  marc8_9page367_flat, 0
};
/* PAGE 366 */
struct yaz_iconv_trie_flat marc8_9page366_flat[] = {
  {"\x47", 0, 0x7BA6},
  {"\x54", 0, 0x7B5A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page366 = {
  marc8_9page366_flat, 0
};
/* PAGE 365 */
struct yaz_iconv_trie_flat marc8_9page365_flat[] = {
  {"\x58", 0, 0x7BA7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page365 = {
  marc8_9page365_flat, 0
};
/* PAGE 364 */
struct yaz_iconv_trie_flat marc8_9page364_flat[] = {
  {"\x7C", 0, 0x7B15},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page364 = {
  marc8_9page364_flat, 0
};
/* PAGE 363 */
struct yaz_iconv_trie_flat marc8_9page363_flat[] = {
  {"\x3C", 0, 0x7AAD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page363 = {
  marc8_9page363_flat, 0
};
/* PAGE 362 */
struct yaz_iconv_trie_flat marc8_9page362_flat[] = {
  {"\x22", 0, 0x7857},
  {"\x55", 0, 0x783B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page362 = {
  marc8_9page362_flat, 0
};
/* PAGE 361 */
struct yaz_iconv_trie_flat marc8_9page361_flat[] = {
  {"\x40", 0, 0x7800},
  {"\x6A", 0, 0x789B},
  {"\x77", 0, 0x789C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page361 = {
  marc8_9page361_flat, 0
};
/* PAGE 360 */
struct yaz_iconv_trie_flat marc8_9page360_flat[] = {
  {"\x5A", 0, 0x7817},
  {"\x60", 0, 0x7856},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page360 = {
  marc8_9page360_flat, 0
};
/* PAGE 359 */
struct yaz_iconv_trie_flat marc8_9page359_flat[] = {
  {"\x2C", 0, 0x7751},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page359 = {
  marc8_9page359_flat, 0
};
/* PAGE 358 */
struct yaz_iconv_trie_flat marc8_9page358_flat[] = {
  {"\x22", 0, 0x7726},
  {"\x72", 0, 0x770D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page358 = {
  marc8_9page358_flat, 0
};
/* PAGE 357 */
struct yaz_iconv_trie_flat marc8_9page357_flat[] = {
  {"\x2B", 0, 0x762A},
  {"\x32", 0, 0x75AC},
  {"\x37", 0, 0x763F},
  {"\x3A", 0, 0x75C8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page357 = {
  marc8_9page357_flat, 0
};
/* PAGE 356 */
struct yaz_iconv_trie_flat marc8_9page356_flat[] = {
  {"\x48", 0, 0x7617},
  {"\x5E", 0, 0x7618},
  {"\x6F", 0, 0x7605},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page356 = {
  marc8_9page356_flat, 0
};
/* PAGE 355 */
struct yaz_iconv_trie_flat marc8_9page355_flat[] = {
  {"\x7A", 0, 0x75D6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page355 = {
  marc8_9page355_flat, 0
};
/* PAGE 354 */
struct yaz_iconv_trie_flat marc8_9page354_flat[] = {
  {"\x6B", 0, 0x7572},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page354 = {
  marc8_9page354_flat, 0
};
/* PAGE 353 */
struct yaz_iconv_trie_flat marc8_9page353_flat[] = {
  {"\x3A", 0, 0x748E},
  {"\x40", 0, 0x74D2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page353 = {
  marc8_9page353_flat, 0
};
/* PAGE 352 */
struct yaz_iconv_trie_flat marc8_9page352_flat[] = {
  {"\x21", 0, 0x740F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page352 = {
  marc8_9page352_flat, 0
};
/* PAGE 351 */
struct yaz_iconv_trie_flat marc8_9page351_flat[] = {
  {"\x47", 0, 0x73AE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page351 = {
  marc8_9page351_flat, 0
};
/* PAGE 350 */
struct yaz_iconv_trie_flat marc8_9page350_flat[] = {
  {"\x2B", 0, 0x7303},
  {"\x36", 0, 0x7315},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page350 = {
  marc8_9page350_flat, 0
};
/* PAGE 349 */
struct yaz_iconv_trie_flat marc8_9page349_flat[] = {
  {"\x5E", 0, 0x72B8},
  {"\x5F", 0, 0x72F2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page349 = {
  marc8_9page349_flat, 0
};
/* PAGE 348 */
struct yaz_iconv_trie_flat marc8_9page348_flat[] = {
  {"\x24", 0, 0x70E8},
  {"\x4F", 0, 0x70EC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page348 = {
  marc8_9page348_flat, 0
};
/* PAGE 347 */
struct yaz_iconv_trie_flat marc8_9page347_flat[] = {
  {"\x23", 0, 0x8367},
  {"\x3C", 0, 0x709D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page347 = {
  marc8_9page347_flat, 0
};
/* PAGE 346 */
struct yaz_iconv_trie_flat marc8_9page346_flat[] = {
  {"\x52", 0, 0x709C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page346 = {
  marc8_9page346_flat, 0
};
/* PAGE 345 */
struct yaz_iconv_trie_flat marc8_9page345_flat[] = {
  {"\x50", 0, 0x70C3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page345 = {
  marc8_9page345_flat, 0
};
/* PAGE 344 */
struct yaz_iconv_trie_flat marc8_9page344_flat[] = {
  {"\x29", 0, 0x6EDF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page344 = {
  marc8_9page344_flat, 0
};
/* PAGE 343 */
struct yaz_iconv_trie_flat marc8_9page343_flat[] = {
  {"\x26", 0, 0x6CF7},
  {"\x39", 0, 0x6CF8},
  {"\x5D", 0, 0x6CA3},
  {"\x61", 0, 0x6EE0},
  {"\x6B", 0, 0x6F13},
  {"\x7D", 0, 0x704F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page343 = {
  marc8_9page343_flat, 0
};
/* PAGE 342 */
struct yaz_iconv_trie_flat marc8_9page342_flat[] = {
  {"\x30", 0, 0x6E11},
  {"\x3E", 0, 0x6CF6},
  {"\x41", 0, 0x6F4B},
  {"\x42", 0, 0x6D4D},
  {"\x62", 0, 0x6F4D},
  {"\x66", 0, 0x6EE2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page342 = {
  marc8_9page342_flat, 0
};
/* PAGE 341 */
struct yaz_iconv_trie_flat marc8_9page341_flat[] = {
  {"\x27", 0, 0x6D9D},
  {"\x2B", 0, 0x6D54},
  {"\x49", 0, 0x6DA0},
  {"\x58", 0, 0x6CA9},
  {"\x59", 0, 0x6ED7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page341 = {
  marc8_9page341_flat, 0
};
/* PAGE 340 */
struct yaz_iconv_trie_flat marc8_9page340_flat[] = {
  {"\x2E", 0, 0x6D52},
  {"\x41", 0, 0x6CA4},
  {"\x62", 0, 0x988D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page340 = {
  marc8_9page340_flat, 0
};
/* PAGE 339 */
struct yaz_iconv_trie_flat marc8_9page339_flat[] = {
  {"\x28", 0, 0x6D48},
  {"\x43", 0, 0x8365},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page339 = {
  marc8_9page339_flat, 0
};
/* PAGE 338 */
struct yaz_iconv_trie_flat marc8_9page338_flat[] = {
  {"\x34", 0, 0x6D43},
  {"\x71", 0, 0x6D9E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page338 = {
  marc8_9page338_flat, 0
};
/* PAGE 337 */
struct yaz_iconv_trie_flat marc8_9page337_flat[] = {
  {"\x42", 0, 0x6BF5},
  {"\x4C", 0, 0x6BE1},
  {"\x51", 0, 0x6C07},
  {"\x68", 0, 0x6C29},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page337 = {
  marc8_9page337_flat, 0
};
/* PAGE 336 */
struct yaz_iconv_trie_flat marc8_9page336_flat[] = {
  {"\x39", 0, 0x6B9A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page336 = {
  marc8_9page336_flat, 0
};
/* PAGE 335 */
struct yaz_iconv_trie_flat marc8_9page335_flat[] = {
  {"\x33", 0, 0x680E},
  {"\x35", 0, 0x6A7C},
  {"\x37", 0, 0x6987},
  {"\x39", 0, 0x680A},
  {"\x3A", 0, 0x69E0},
  {"\x40", 0, 0x67A5},
  {"\x45", 0, 0x680C},
  {"\x50", 0, 0x68C2},
  {"\x59", 0, 0x6989},
  {"\x66", 0, 0x6924},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page335 = {
  marc8_9page335_flat, 0
};
/* PAGE 334 */
struct yaz_iconv_trie_flat marc8_9page334_flat[] = {
  {"\x2B", 0, 0x6A2F},
  {"\x57", 0, 0x68BC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page334 = {
  marc8_9page334_flat, 0
};
/* PAGE 333 */
struct yaz_iconv_trie_flat marc8_9page333_flat[] = {
  {"\x40", 0, 0x6861},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page333 = {
  marc8_9page333_flat, 0
};
/* PAGE 332 */
struct yaz_iconv_trie_flat marc8_9page332_flat[] = {
  {"\x27", 0, 0x6864},
  {"\x27", 0, 0x6864},
  {"\x56", 0, 0x6920},
  {"\x5E", 0, 0x67FD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page332 = {
  marc8_9page332_flat, 0
};
/* PAGE 331 */
struct yaz_iconv_trie_flat marc8_9page331_flat[] = {
  {"\x30", 0, 0x6966},
  {"\x5C", 0, 0x6769},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page331 = {
  marc8_9page331_flat, 0
};
/* PAGE 330 */
struct yaz_iconv_trie_flat marc8_9page330_flat[] = {
  {"\x30", 0, 0x67A7},
  {"\x6E", 0, 0x67A8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page330 = {
  marc8_9page330_flat, 0
};
/* PAGE 329 */
struct yaz_iconv_trie_flat marc8_9page329_flat[] = {
  {"\x22", 0, 0x4E2B},
  {"\x7D", 0, 0xE91C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page329 = {
  marc8_9page329_flat, 0
};
/* PAGE 328 */
struct yaz_iconv_trie_flat marc8_9page328_flat[] = {
  {"\x55", 0, 0x6619},
  {"\x5C", 0, 0x6654},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page328 = {
  marc8_9page328_flat, 0
};
/* PAGE 327 */
struct yaz_iconv_trie_flat marc8_9page327_flat[] = {
  {"\x71", 0, 0x6593},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page327 = {
  marc8_9page327_flat, 0
};
/* PAGE 326 */
struct yaz_iconv_trie_flat marc8_9page326_flat[] = {
  {"\x2A", 0, 0x6448},
  {"\x42", 0, 0x64B7},
  {"\x46", 0, 0x6445},
  {"\x5B", 0, 0x6484},
  {"\x61", 0, 0x64BA},
  {"\x6D", 0, 0x6512},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page326 = {
  marc8_9page326_flat, 0
};
/* PAGE 325 */
struct yaz_iconv_trie_flat marc8_9page325_flat[] = {
  {"\x2C", 0, 0x63BA},
  {"\x2E", 0, 0x63BC},
  {"\x57", 0, 0x63B8},
  {"\x62", 0, 0x6322},
  {"\x66", 0, 0x63FF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page325 = {
  marc8_9page325_flat, 0
};
/* PAGE 324 */
struct yaz_iconv_trie_flat marc8_9page324_flat[] = {
  {"\x6F", 0, 0x629F},
  {"\x7B", 0, 0x62A0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page324 = {
  marc8_9page324_flat, 0
};
/* PAGE 323 */
struct yaz_iconv_trie_flat marc8_9page323_flat[] = {
  {"\x43", 0, 0x6206},
  {"\x47", 0, 0x620B},
  {"\x66", 0, 0x6217},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page323 = {
  marc8_9page323_flat, 0
};
/* PAGE 322 */
struct yaz_iconv_trie_flat marc8_9page322_flat[] = {
  {"\x4C", 0, 0x6126},
  {"\x52", 0, 0x6003},
  {"\x5C", 0, 0x603F},
  {"\x79", 0, 0x6079},
  {"\x7E", 0, 0x603C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page322 = {
  marc8_9page322_flat, 0
};
/* PAGE 321 */
struct yaz_iconv_trie_flat marc8_9page321_flat[] = {
  {"\x34", 0, 0x607D},
  {"\x5E", 0, 0x607A},
  {"\x74", 0, 0x6004},
  {"\x77", 0, 0x60AD},
  {"\x79", 0, 0x60AB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page321 = {
  marc8_9page321_flat, 0
};
/* PAGE 320 */
struct yaz_iconv_trie_flat marc8_9page320_flat[] = {
  {"\x51", 0, 0x5F2A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page320 = {
  marc8_9page320_flat, 0
};
/* PAGE 319 */
struct yaz_iconv_trie_flat marc8_9page319_flat[] = {
  {"\x68", 0, 0x5E91},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page319 = {
  marc8_9page319_flat, 0
};
/* PAGE 318 */
struct yaz_iconv_trie_flat marc8_9page318_flat[] = {
  {"\x36", 0, 0x5E0F},
  {"\x47", 0, 0x5E3B},
  {"\x5F", 0, 0x5E31},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page318 = {
  marc8_9page318_flat, 0
};
/* PAGE 317 */
struct yaz_iconv_trie_flat marc8_9page317_flat[] = {
  {"\x26", 0, 0x5CC4},
  {"\x32", 0, 0x5D58},
  {"\x47", 0, 0x5CBF},
  {"\x59", 0, 0x5DEF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page317 = {
  marc8_9page317_flat, 0
};
/* PAGE 316 */
struct yaz_iconv_trie_flat marc8_9page316_flat[] = {
  {"\x5A", 0, 0x5D5D},
  {"\x69", 0, 0x5D02},
  {"\x77", 0, 0x5CE4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page316 = {
  marc8_9page316_flat, 0
};
/* PAGE 315 */
struct yaz_iconv_trie_flat marc8_9page315_flat[] = {
  {"\x41", 0, 0x5C98},
  {"\x58", 0, 0x5D03},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page315 = {
  marc8_9page315_flat, 0
};
/* PAGE 314 */
struct yaz_iconv_trie_flat marc8_9page314_flat[] = {
  {"\x2B", 0, 0x5C66},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page314 = {
  marc8_9page314_flat, 0
};
/* PAGE 313 */
struct yaz_iconv_trie_dir marc8_9page313_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {314, 0, 0} /* 23 */,
  {315, 0, 0} /* 24 */,
  {316, 0, 0} /* 25 */,
  {317, 0, 0} /* 26 */,
  {318, 0, 0} /* 27 */,
  {319, 0, 0} /* 28 */,
  {320, 0, 0} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {321, 0, 0} /* 2D */,
  {322, 0, 0} /* 2E */,
  {323, 0, 0} /* 2F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {324, 0, 0} /* 33 */,
  {325, 0, 0} /* 34 */,
  {326, 0, 0} /* 35 */,
  {327, 0, 0} /* 36 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {328, 0, 0} /* 39 */,
  {-1, 0, 0},
  {329, 0, 0} /* 3B */,
  {-1, 0, 0},
  {330, 0, 0} /* 3D */,
  {-1, 0, 0},
  {331, 0, 0} /* 3F */,
  {332, 0, 0} /* 40 */,
  {333, 0, 0} /* 41 */,
  {334, 0, 0} /* 42 */,
  {335, 0, 0} /* 43 */,
  {-1, 0, 0},
  {336, 0, 0} /* 45 */,
  {337, 0, 0} /* 46 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {338, 0, 0} /* 49 */,
  {-1, 0, 0},
  {339, 0, 0} /* 4B */,
  {340, 0, 0} /* 4C */,
  {341, 0, 0} /* 4D */,
  {342, 0, 0} /* 4E */,
  {343, 0, 0} /* 4F */,
  {344, 0, 0} /* 50 */,
  {345, 0, 0} /* 51 */,
  {346, 0, 0} /* 52 */,
  {347, 0, 0} /* 53 */,
  {348, 0, 0} /* 54 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {349, 0, 0} /* 57 */,
  {350, 0, 0} /* 58 */,
  {-1, 0, 0},
  {351, 0, 0} /* 5A */,
  {352, 0, 0} /* 5B */,
  {353, 0, 0} /* 5C */,
  {354, 0, 0} /* 5D */,
  {355, 0, 0} /* 5E */,
  {356, 0, 0} /* 5F */,
  {357, 0, 0} /* 60 */,
  {-1, 0, 0},
  {358, 0, 0} /* 62 */,
  {359, 0, 0} /* 63 */,
  {360, 0, 0} /* 64 */,
  {361, 0, 0} /* 65 */,
  {362, 0, 0} /* 66 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {363, 0, 0} /* 6A */,
  {364, 0, 0} /* 6B */,
  {365, 0, 0} /* 6C */,
  {366, 0, 0} /* 6D */,
  {367, 0, 0} /* 6E */,
  {-1, 0, 0},
  {368, 0, 0} /* 70 */,
  {369, 0, 0} /* 71 */,
  {370, 0, 0} /* 72 */,
  {371, 0, 0} /* 73 */,
  {372, 0, 0} /* 74 */,
  {373, 0, 0} /* 75 */,
  {374, 0, 0} /* 76 */,
  {375, 0, 0} /* 77 */,
  {376, 0, 0} /* 78 */,
  {377, 0, 0} /* 79 */,
  {378, 0, 0} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {379, 0, 0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page313 = {
  0, marc8_9page313_dir
};
/* PAGE 312 */
struct yaz_iconv_trie_flat marc8_9page312_flat[] = {
  {"\x2B", 0, 0x5A06},
  {"\x40", 0, 0x5AF1},
  {"\x48", 0, 0x5AD2},
  {"\x74", 0, 0x5A08},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page312 = {
  marc8_9page312_flat, 0
};
/* PAGE 311 */
struct yaz_iconv_trie_flat marc8_9page311_flat[] = {
  {"\x24", 0, 0x5A32},
  {"\x36", 0, 0x59AB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page311 = {
  marc8_9page311_flat, 0
};
/* PAGE 310 */
struct yaz_iconv_trie_flat marc8_9page310_flat[] = {
  {"\x3C", 0, 0x5A05},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page310 = {
  marc8_9page310_flat, 0
};
/* PAGE 309 */
struct yaz_iconv_trie_flat marc8_9page309_flat[] = {
  {"\x54", 0, 0x5956},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page309 = {
  marc8_9page309_flat, 0
};
/* PAGE 308 */
struct yaz_iconv_trie_flat marc8_9page308_flat[] = {
  {"\x5A", 0, 0x5785},
  {"\x5E", 0, 0x5786},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page308 = {
  marc8_9page308_flat, 0
};
/* PAGE 307 */
struct yaz_iconv_trie_flat marc8_9page307_flat[] = {
  {"\x42", 0, 0x57D8},
  {"\x45", 0, 0x57D9},
  {"\x48", 0, 0x57B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page307 = {
  marc8_9page307_flat, 0
};
/* PAGE 306 */
struct yaz_iconv_trie_flat marc8_9page306_flat[] = {
  {"\x38", 0, 0x57AD},
  {"\x7A", 0, 0x57DA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page306 = {
  marc8_9page306_flat, 0
};
/* PAGE 305 */
struct yaz_iconv_trie_flat marc8_9page305_flat[] = {
  {"\x2E", 0, 0x56F5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page305 = {
  marc8_9page305_flat, 0
};
/* PAGE 304 */
struct yaz_iconv_trie_flat marc8_9page304_flat[] = {
  {"\x28", 0, 0x54DC},
  {"\x45", 0, 0x556E},
  {"\x4C", 0, 0x5456},
  {"\x5A", 0, 0x55BE},
  {"\x60", 0, 0x5181},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page304 = {
  marc8_9page304_flat, 0
};
/* PAGE 303 */
struct yaz_iconv_trie_flat marc8_9page303_flat[] = {
  {"\x34", 0, 0x551B},
  {"\x39", 0, 0x54D4},
  {"\x55", 0, 0x54D3},
  {"\x58", 0, 0xE91B},
  {"\x67", 0, 0x5452},
  {"\x72", 0, 0x54D2},
  {"\x7A", 0, 0x54D5},
  {"\x7E", 0, 0x54D9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page303 = {
  marc8_9page303_flat, 0
};
/* PAGE 302 */
struct yaz_iconv_trie_flat marc8_9page302_flat[] = {
  {"\x69", 0, 0x5522},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page302 = {
  marc8_9page302_flat, 0
};
/* PAGE 301 */
struct yaz_iconv_trie_flat marc8_9page301_flat[] = {
  {"\x30", 0, 0x5457},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page301 = {
  marc8_9page301_flat, 0
};
/* PAGE 300 */
struct yaz_iconv_trie_flat marc8_9page300_flat[] = {
  {"\x69", 0, 0x5459},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page300 = {
  marc8_9page300_flat, 0
};
/* PAGE 299 */
struct yaz_iconv_trie_flat marc8_9page299_flat[] = {
  {"\x2A", 0, 0x53A3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page299 = {
  marc8_9page299_flat, 0
};
/* PAGE 298 */
struct yaz_iconv_trie_flat marc8_9page298_flat[] = {
  {"\x2E", 0, 0x5326},
  {"\x6D", 0, 0x538D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page298 = {
  marc8_9page298_flat, 0
};
/* PAGE 297 */
struct yaz_iconv_trie_flat marc8_9page297_flat[] = {
  {"\x3E", 0, 0x522D},
  {"\x5B", 0, 0x5250},
  {"\x5F", 0, 0x672D},
  {"\x79", 0, 0x523F},
  {"\x7A", 0, 0x523D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page297 = {
  marc8_9page297_flat, 0
};
/* PAGE 296 */
struct yaz_iconv_trie_flat marc8_9page296_flat[] = {
  {"\x44", 0, 0x50A9},
  {"\x48", 0, 0x50A5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page296 = {
  marc8_9page296_flat, 0
};
/* PAGE 295 */
struct yaz_iconv_trie_flat marc8_9page295_flat[] = {
  {"\x22", 0, 0x507B},
  {"\x42", 0, 0x507E},
  {"\x71", 0, 0x4FAA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page295 = {
  marc8_9page295_flat, 0
};
/* PAGE 294 */
struct yaz_iconv_trie_flat marc8_9page294_flat[] = {
  {"\x75", 0, 0x4F65},
  {"\x7C", 0, 0x4F1B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page294 = {
  marc8_9page294_flat, 0
};
/* PAGE 293 */
struct yaz_iconv_trie_flat marc8_9page293_flat[] = {
  {"\x49", 0, 0x4F1C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page293 = {
  marc8_9page293_flat, 0
};
/* PAGE 292 */
struct yaz_iconv_trie_flat marc8_9page292_flat[] = {
  {"\x21", 0, 0x9F7F},
  {"\x22", 0, 0x9F83},
  {"\x24", 0, 0x9F84},
  {"\x25", 0, 0x9F88},
  {"\x26", 0, 0x9F87},
  {"\x27", 0, 0x9F89},
  {"\x28", 0, 0x9F8A},
  {"\x29", 0, 0x9F8C},
  {"\x2A", 0, 0x9F8B},
  {"\x2B", 0, 0x9F99},
  {"\x2C", 0, 0x9F9A},
  {"\x2D", 0, 0x9F9F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page292 = {
  marc8_9page292_flat, 0
};
/* PAGE 291 */
struct yaz_iconv_trie_dir marc8_9page291_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9CC3} /* 21 */,
  {-1, 0, 0x9CC5} /* 22 */,
  {-1, 0, 0x9CAB} /* 23 */,
  {-1, 0, 0x9CCD} /* 24 */,
  {-1, 0, 0x9CCF} /* 25 */,
  {-1, 0, 0x9CA2} /* 26 */,
  {-1, 0, 0x9CD4} /* 27 */,
  {-1, 0, 0x9CD7} /* 28 */,
  {-1, 0, 0x9CDD} /* 29 */,
  {-1, 0, 0x9CDE} /* 2A */,
  {-1, 0, 0x9CDC} /* 2B */,
  {-1, 0, 0x9CD6} /* 2C */,
  {-1, 0, 0},
  {-1, 0, 0x9C88} /* 2E */,
  {-1, 0, 0x9E1F} /* 2F */,
  {-1, 0, 0x9E20} /* 30 */,
  {-1, 0, 0x9E22} /* 31 */,
  {-1, 0, 0x9E23} /* 32 */,
  {-1, 0, 0x51E4} /* 33 */,
  {-1, 0, 0x9E29} /* 34 */,
  {-1, 0, 0x9E26} /* 35 */,
  {-1, 0, 0x9E35} /* 36 */,
  {-1, 0, 0x9E2A} /* 37 */,
  {-1, 0, 0x9E2D} /* 38 */,
  {-1, 0, 0x9E2F} /* 39 */,
  {-1, 0, 0x9E33} /* 3A */,
  {-1, 0, 0},
  {-1, 0, 0x9E3F} /* 3C */,
  {-1, 0, 0x9E3D} /* 3D */,
  {-1, 0, 0x9E49} /* 3E */,
  {-1, 0, 0x9E43} /* 3F */,
  {-1, 0, 0x9E44} /* 40 */,
  {-1, 0, 0x9E45} /* 41 */,
  {-1, 0, 0x9E51} /* 42 */,
  {-1, 0, 0x9E4A} /* 43 */,
  {-1, 0, 0x9E4C} /* 44 */,
  {-1, 0, 0x9E4F} /* 45 */,
  {-1, 0, 0x9E64} /* 46 */,
  {-1, 0, 0x83BA} /* 47 */,
  {-1, 0, 0x9E5E} /* 48 */,
  {-1, 0, 0x9E67} /* 49 */,
  {-1, 0, 0x9E25} /* 4A */,
  {-1, 0, 0x9E36} /* 4B */,
  {-1, 0, 0x9E70} /* 4C */,
  {-1, 0, 0x9E6D} /* 4D */,
  {-1, 0, 0x9E66} /* 4E */,
  {-1, 0, 0x9E3E} /* 4F */,
  {-1, 0, 0x54B8} /* 50 */,
  {-1, 0, 0x76D0} /* 51 */,
  {-1, 0, 0x7877} /* 52 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4E3D} /* 56 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9EA6} /* 5B */,
  {-1, 0, 0x9EB8} /* 5C */,
  {-1, 0, 0},
  {-1, 0, 0x9762} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0x4E48} /* 60 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x70B9} /* 6A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x515A} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9EE9} /* 72 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x51AC} /* 76 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9F50} /* 7D */,
  {-1, 0, 0x658E} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page291 = {
  0, marc8_9page291_dir
};
/* PAGE 290 */
struct yaz_iconv_trie_dir marc8_9page290_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x998A} /* 21 */,
  {-1, 0, 0},
  {-1, 0, 0x9992} /* 23 */,
  {-1, 0, 0x9976} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x990D} /* 26 */,
  {-1, 0, 0x998B} /* 27 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9A6C} /* 2C */,
  {-1, 0, 0x51AF} /* 2D */,
  {-1, 0, 0x9A6D} /* 2E */,
  {-1, 0, 0x9A70} /* 2F */,
  {-1, 0, 0x9A6E} /* 30 */,
  {-1, 0, 0x9A6F} /* 31 */,
  {-1, 0, 0x9A73} /* 32 */,
  {-1, 0, 0x9A7B} /* 33 */,
  {-1, 0, 0x9A7C} /* 34 */,
  {-1, 0, 0x9A7E} /* 35 */,
  {-1, 0, 0x9A77} /* 36 */,
  {-1, 0, 0x9A76} /* 37 */,
  {-1, 0, 0x9A79} /* 38 */,
  {-1, 0, 0x9A78} /* 39 */,
  {-1, 0, 0x9A7D} /* 3A */,
  {-1, 0, 0x9A87} /* 3B */,
  {-1, 0, 0x9A86} /* 3C */,
  {-1, 0, 0x9A8B} /* 3D */,
  {-1, 0, 0x9A8F} /* 3E */,
  {-1, 0, 0x9A88} /* 3F */,
  {-1, 0, 0x9A91} /* 40 */,
  {-1, 0, 0x9A97} /* 41 */,
  {-1, 0, 0x9A9B} /* 42 */,
  {-1, 0, 0x9A9E} /* 43 */,
  {-1, 0, 0x817E} /* 44 */,
  {-1, 0, 0x9A9A} /* 45 */,
  {-1, 0, 0x9AA0} /* 46 */,
  {-1, 0, 0x9A71} /* 47 */,
  {-1, 0, 0x84E6} /* 48 */,
  {-1, 0, 0x9AA1} /* 49 */,
  {-1, 0, 0x9A84} /* 4A */,
  {-1, 0, 0x60CA} /* 4B */,
  {-1, 0, 0x9A7F} /* 4C */,
  {-1, 0, 0x9A8C} /* 4D */,
  {-1, 0, 0x9AA4} /* 4E */,
  {-1, 0, 0x9A74} /* 4F */,
  {-1, 0, 0x9AA5} /* 50 */,
  {-1, 0, 0x9A8A} /* 51 */,
  {-1, 0, 0},
  {-1, 0, 0x80AE} /* 53 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9AC5} /* 58 */,
  {-1, 0, 0},
  {-1, 0, 0x4F53} /* 5A */,
  {-1, 0, 0x810F} /* 5B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xE917} /* 5F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0xE918} /* 63 */,
  {-1, 0, 0xE919} /* 64 */,
  {-1, 0, 0xE91A} /* 65 */,
  {-1, 0, 0x9B13} /* 66 */,
  {-1, 0, 0x6597} /* 67 */,
  {-1, 0, 0x95F9} /* 68 */,
  {-1, 0, 0},
  {-1, 0, 0x90C1} /* 6A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9B47} /* 73 */,
  {-1, 0, 0x9C7C} /* 74 */,
  {-1, 0, 0x9C7F} /* 75 */,
  {-1, 0, 0x9C81} /* 76 */,
  {-1, 0, 0x9C8D} /* 77 */,
  {-1, 0, 0x9C9B} /* 78 */,
  {-1, 0, 0x9C9C} /* 79 */,
  {-1, 0, 0x9C94} /* 7A */,
  {-1, 0, 0x9CA8} /* 7B */,
  {-1, 0, 0x9CA4} /* 7C */,
  {-1, 0, 0x9CB8} /* 7D */,
  {-1, 0, 0x9CB3} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page290 = {
  0, marc8_9page290_dir
};
/* PAGE 289 */
struct yaz_iconv_trie_dir marc8_9page289_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5DE9} /* 23 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9791} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x97E6} /* 2C */,
  {-1, 0, 0x97E7} /* 2D */,
  {-1, 0, 0x97E9} /* 2E */,
  {-1, 0, 0x97EC} /* 2F */,
  {-1, 0, 0x827D} /* 30 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x54CD} /* 36 */,
  {-1, 0, 0x9875} /* 37 */,
  {-1, 0, 0x9876} /* 38 */,
  {-1, 0, 0x9877} /* 39 */,
  {-1, 0, 0x9879} /* 3A */,
  {-1, 0, 0x987A} /* 3B */,
  {-1, 0, 0x987B} /* 3C */,
  {-1, 0, 0x9884} /* 3D */,
  {-1, 0, 0x987C} /* 3E */,
  {-1, 0, 0x987D} /* 3F */,
  {-1, 0, 0x987F} /* 40 */,
  {-1, 0, 0x9881} /* 41 */,
  {-1, 0, 0x9882} /* 42 */,
  {-1, 0, 0x9887} /* 43 */,
  {-1, 0, 0x9886} /* 44 */,
  {-1, 0, 0x9889} /* 45 */,
  {-1, 0, 0x5934} /* 46 */,
  {-1, 0, 0x988A} /* 47 */,
  {-1, 0, 0x9888} /* 48 */,
  {-1, 0, 0x9891} /* 49 */,
  {-1, 0, 0x9893} /* 4A */,
  {-1, 0, 0x9894} /* 4B */,
  {-1, 0, 0x9890} /* 4C */,
  {-1, 0, 0x9897} /* 4D */,
  {-1, 0, 0x989C} /* 4E */,
  {-1, 0, 0x989D} /* 4F */,
  {-1, 0, 0x9898} /* 50 */,
  {-1, 0, 0x989A} /* 51 */,
  {-1, 0, 0x989B} /* 52 */,
  {-1, 0, 0x7C7B} /* 53 */,
  {-1, 0, 0x98A0} /* 54 */,
  {-1, 0, 0x613F} /* 55 */,
  {-1, 0, 0x987E} /* 56 */,
  {-1, 0, 0x98A4} /* 57 */,
  {-1, 0, 0x663E} /* 58 */,
  {-1, 0, 0x9885} /* 59 */,
  {-1, 0, 0x98A6} /* 5A */,
  {-1, 0, 0x98CE} /* 5B */,
  {-1, 0, 0x98D2} /* 5C */,
  {-1, 0, 0xE916} /* 5D */,
  {-1, 0, 0x522E} /* 5E */,
  {-1, 0, 0x98D3} /* 5F */,
  {-1, 0, 0},
  {-1, 0, 0x98D5} /* 61 */,
  {-1, 0, 0x98D8} /* 62 */,
  {-1, 0, 0x98DE} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x9965} /* 65 */,
  {-1, 0, 0},
  {-1, 0, 0x9968} /* 67 */,
  {-1, 0, 0x996C} /* 68 */,
  {-1, 0, 0x996A} /* 69 */,
  {-1, 0, 0x996E} /* 6A */,
  {-1, 0, 0x996D} /* 6B */,
  {-1, 0, 0x9972} /* 6C */,
  {-1, 0, 0x9974} /* 6D */,
  {-1, 0, 0x9971} /* 6E */,
  {-1, 0, 0x9970} /* 6F */,
  {-1, 0, 0x997A} /* 70 */,
  {-1, 0, 0x517B} /* 71 */,
  {-1, 0, 0x9975} /* 72 */,
  {-1, 0, 0x9977} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0x9981} /* 75 */,
  {-1, 0, 0x4F59} /* 76 */,
  {-1, 0, 0x997F} /* 77 */,
  {-1, 0, 0x997C} /* 78 */,
  {-1, 0, 0x9986} /* 79 */,
  {-1, 0, 0x996F} /* 7A */,
  {-1, 0, 0x9984} /* 7B */,
  {-1, 0, 0x9985} /* 7C */,
  {-1, 0, 0},
  {-1, 0, 0x998F} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page289 = {
  0, marc8_9page289_dir
};
/* PAGE 288 */
struct yaz_iconv_trie_flat marc8_9page288_flat[] = {
  {"\x23", 0, 0x9648},
  {"\x24", 0, 0x9646},
  {"\x2A", 0, 0x9634},
  {"\x2B", 0, 0x961F},
  {"\x2C", 0, 0x9636},
  {"\x2E", 0, 0x9633},
  {"\x37", 0, 0x9645},
  {"\x39", 0, 0x968F},
  {"\x3A", 0, 0x9669},
  {"\x3B", 0, 0x9690},
  {"\x3C", 0, 0x9647},
  {"\x3D", 0, 0x96B6},
  {"\x3E", 0, 0xE915},
  {"\x4A", 0, 0x867D},
  {"\x4B", 0, 0x6742},
  {"\x4C", 0, 0x9E21},
  {"\x4D", 0, 0x96CF},
  {"\x4E", 0, 0x53CC},
  {"\x4F", 0, 0x79BB},
  {"\x50", 0, 0x96BE},
  {"\x54", 0, 0x4E91},
  {"\x55", 0, 0x7535},
  {"\x67", 0, 0x96FE},
  {"\x6B", 0, 0x9701},
  {"\x6D", 0, 0x972D},
  {"\x6E", 0, 0x96F3},
  {"\x6F", 0, 0x7075},
  {"\x79", 0, 0x9765},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page288 = {
  marc8_9page288_flat, 0
};
/* PAGE 287 */
struct yaz_iconv_trie_dir marc8_9page287_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x949F} /* 21 */,
  {-1, 0, 0x9524} /* 22 */,
  {-1, 0, 0x9539} /* 23 */,
  {-1, 0, 0x953B} /* 24 */,
  {-1, 0, 0x9551} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0x9547} /* 27 */,
  {-1, 0, 0x9501} /* 28 */,
  {-1, 0, 0x94A8} /* 29 */,
  {-1, 0, 0x954D} /* 2A */,
  {-1, 0, 0x955C} /* 2B */,
  {-1, 0, 0x955D} /* 2C */,
  {-1, 0, 0},
  {-1, 0, 0x955E} /* 2E */,
  {-1, 0, 0x94F2} /* 2F */,
  {-1, 0, 0x94FF} /* 30 */,
  {-1, 0, 0x94FE} /* 31 */,
  {-1, 0, 0x9556} /* 32 */,
  {-1, 0, 0x9557} /* 33 */,
  {-1, 0, 0x9542} /* 34 */,
  {-1, 0, 0x9558} /* 35 */,
  {-1, 0, 0x9559} /* 36 */,
  {-1, 0, 0x9535} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0x94D9} /* 39 */,
  {-1, 0, 0x9570} /* 3A */,
  {-1, 0, 0x9508} /* 3B */,
  {-1, 0, 0x956D} /* 3C */,
  {-1, 0, 0x94C1} /* 3D */,
  {-1, 0, 0x94DB} /* 3E */,
  {-1, 0, 0x94CE} /* 3F */,
  {-1, 0, 0x956F} /* 40 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x94F8} /* 43 */,
  {-1, 0, 0x9573} /* 44 */,
  {-1, 0, 0x94C4} /* 45 */,
  {-1, 0, 0x9576} /* 46 */,
  {-1, 0, 0x94A5} /* 47 */,
  {-1, 0, 0x92AE} /* 48 */,
  {-1, 0, 0x9523} /* 49 */,
  {-1, 0, 0x94BB} /* 4A */,
  {-1, 0, 0x51FF} /* 4B */,
  {-1, 0, 0x957F} /* 4C */,
  {-1, 0, 0x95E8} /* 4D */,
  {-1, 0, 0x95E9} /* 4E */,
  {-1, 0, 0x95EA} /* 4F */,
  {-1, 0, 0x95ED} /* 50 */,
  {-1, 0, 0x95F5} /* 51 */,
  {-1, 0, 0x95F0} /* 52 */,
  {-1, 0, 0x5F00} /* 53 */,
  {-1, 0, 0x95F2} /* 54 */,
  {-1, 0, 0x95F4} /* 55 */,
  {-1, 0, 0},
  {-1, 0, 0x95F8} /* 57 */,
  {-1, 0, 0x9602} /* 58 */,
  {-1, 0, 0x95FA} /* 59 */,
  {-1, 0, 0x95FD} /* 5A */,
  {-1, 0, 0x9601} /* 5B */,
  {-1, 0, 0x9600} /* 5C */,
  {-1, 0, 0x5408} /* 5D */,
  {-1, 0, 0x9605} /* 5E */,
  {-1, 0, 0x95FE} /* 5F */,
  {-1, 0, 0x960E} /* 60 */,
  {-1, 0, 0x9614} /* 61 */,
  {-1, 0, 0x9615} /* 62 */,
  {-1, 0, 0x9611} /* 63 */,
  {-1, 0, 0x95F1} /* 64 */,
  {-1, 0, 0x677F} /* 65 */,
  {-1, 0, 0},
  {-1, 0, 0x95EF} /* 67 */,
  {-1, 0, 0x9617} /* 68 */,
  {-1, 0, 0x5173} /* 69 */,
  {-1, 0, 0x9610} /* 6A */,
  {-1, 0, 0xE914} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9635} /* 7B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page287 = {
  0, marc8_9page287_dir
};
/* PAGE 286 */
struct yaz_iconv_trie_dir marc8_9page286_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9154} /* 2A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x915D} /* 2F */,
  {-1, 0, 0x4E11} /* 30 */,
  {-1, 0, 0x533B} /* 31 */,
  {-1, 0, 0x9171} /* 32 */,
  {-1, 0, 0},
  {-1, 0, 0x917F} /* 34 */,
  {-1, 0, 0x8845} /* 35 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x91CA} /* 38 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5398} /* 3D */,
  {-1, 0, 0},
  {-1, 0, 0x9488} /* 3F */,
  {-1, 0, 0x9489} /* 40 */,
  {-1, 0, 0x948A} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0x9497} /* 43 */,
  {-1, 0, 0},
  {-1, 0, 0x9493} /* 45 */,
  {-1, 0, 0x948F} /* 46 */,
  {-1, 0, 0x9499} /* 47 */,
  {-1, 0, 0x949D} /* 48 */,
  {-1, 0, 0x94AE} /* 49 */,
  {-1, 0, 0x94A0} /* 4A */,
  {-1, 0, 0x949E} /* 4B */,
  {-1, 0, 0x94A7} /* 4C */,
  {-1, 0, 0x94A4} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0x94B4} /* 4F */,
  {-1, 0, 0x94B9} /* 50 */,
  {-1, 0, 0x94B8} /* 51 */,
  {-1, 0, 0x94C0} /* 52 */,
  {-1, 0, 0x94BE} /* 53 */,
  {-1, 0, 0},
  {-1, 0, 0x94C5} /* 55 */,
  {-1, 0, 0x94A9} /* 56 */,
  {-1, 0, 0x94C2} /* 57 */,
  {-1, 0, 0x94C3} /* 58 */,
  {-1, 0, 0x94F0} /* 59 */,
  {-1, 0, 0x94F6} /* 5A */,
  {-1, 0, 0x94D0} /* 5B */,
  {-1, 0, 0x94DC} /* 5C */,
  {-1, 0, 0x94ED} /* 5D */,
  {-1, 0, 0x94E2} /* 5E */,
  {-1, 0, 0x94EC} /* 5F */,
  {-1, 0, 0x94E8} /* 60 */,
  {-1, 0, 0x8854} /* 61 */,
  {-1, 0, 0x950C} /* 62 */,
  {-1, 0, 0x9511} /* 63 */,
  {-1, 0, 0x9510} /* 64 */,
  {-1, 0, 0x94FA} /* 65 */,
  {-1, 0, 0x9500} /* 66 */,
  {-1, 0, 0x94DD} /* 67 */,
  {-1, 0, 0x9504} /* 68 */,
  {-1, 0, 0x9509} /* 69 */,
  {-1, 0, 0x950B} /* 6A */,
  {-1, 0, 0x952D} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0x952F} /* 6D */,
  {-1, 0, 0x9530} /* 6E */,
  {-1, 0, 0x9519} /* 6F */,
  {-1, 0, 0x94B1} /* 70 */,
  {-1, 0, 0x94A2} /* 71 */,
  {-1, 0, 0x9521} /* 72 */,
  {-1, 0, 0x94EE} /* 73 */,
  {-1, 0, 0x5F55} /* 74 */,
  {-1, 0, 0x9525} /* 75 */,
  {-1, 0, 0x9526} /* 76 */,
  {-1, 0, 0x9540} /* 77 */,
  {-1, 0, 0x9541} /* 78 */,
  {-1, 0, 0x952E} /* 79 */,
  {-1, 0, 0x9532} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0x9505} /* 7C */,
  {-1, 0, 0x951A} /* 7D */,
  {-1, 0, 0x953E} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page286 = {
  0, marc8_9page286_dir
};
/* PAGE 285 */
struct yaz_iconv_trie_flat marc8_9page285_flat[] = {
  {"\x33", 0, 0x8FDB},
  {"\x34", 0, 0x8FD0},
  {"\x39", 0, 0x8FBE},
  {"\x3A", 0, 0x8FDD},
  {"\x3C", 0, 0x8FC2},
  {"\x3E", 0, 0x8FC7},
  {"\x44", 0, 0x8FDC},
  {"\x45", 0, 0x900A},
  {"\x48", 0, 0x9012},
  {"\x49", 0, 0x9002},
  {"\x4F", 0, 0x9009},
  {"\x50", 0, 0x8FDF},
  {"\x51", 0, 0x8FC1},
  {"\x52", 0, 0x8FBD},
  {"\x53", 0, 0x9057},
  {"\x56", 0, 0x8FC8},
  {"\x57", 0, 0x8FD8},
  {"\x5A", 0, 0xE975},
  {"\x5B", 0, 0x8FB9},
  {"\x5C", 0, 0x9026},
  {"\x5D", 0, 0x903B},
  {"\x6B", 0, 0x5369},
  {"\x6D", 0, 0x90AE},
  {"\x70", 0, 0x4E61},
  {"\x71", 0, 0x90B9},
  {"\x73", 0, 0x90D1},
  {"\x74", 0, 0x90BB},
  {"\x75", 0, 0x9093},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page285 = {
  marc8_9page285_flat, 0
};
/* PAGE 284 */
struct yaz_iconv_trie_dir marc8_9page284_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8DB8} /* 26 */,
  {-1, 0, 0},
  {-1, 0, 0x8E0C} /* 28 */,
  {-1, 0, 0x8DC3} /* 29 */,
  {-1, 0, 0x8E2F} /* 2A */,
  {-1, 0, 0x8E51} /* 2B */,
  {-1, 0, 0x8E8F} /* 2C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8EAF} /* 31 */,
  {-1, 0, 0x8F66} /* 32 */,
  {-1, 0, 0x8F67} /* 33 */,
  {-1, 0, 0x519B} /* 34 */,
  {-1, 0, 0x8F68} /* 35 */,
  {-1, 0, 0x8F69} /* 36 */,
  {-1, 0, 0x8F6B} /* 37 */,
  {-1, 0, 0x8F6F} /* 38 */,
  {-1, 0, 0x8F6D} /* 39 */,
  {-1, 0, 0x8F72} /* 3A */,
  {-1, 0, 0x8F74} /* 3B */,
  {-1, 0, 0x8F76} /* 3C */,
  {-1, 0, 0x8F83} /* 3D */,
  {-1, 0, 0x8F7C} /* 3E */,
  {-1, 0, 0x8F7D} /* 3F */,
  {-1, 0, 0x8F7E} /* 40 */,
  {-1, 0, 0x8F85} /* 41 */,
  {-1, 0, 0x8F84} /* 42 */,
  {-1, 0, 0x8F7B} /* 43 */,
  {-1, 0, 0},
  {-1, 0, 0x8F87} /* 45 */,
  {-1, 0, 0x8F86} /* 46 */,
  {-1, 0, 0x8F8D} /* 47 */,
  {-1, 0, 0x8F89} /* 48 */,
  {-1, 0, 0x8F88} /* 49 */,
  {-1, 0, 0x8F6E} /* 4A */,
  {-1, 0, 0x8F8E} /* 4B */,
  {-1, 0, 0x8F90} /* 4C */,
  {-1, 0, 0x8F91} /* 4D */,
  {-1, 0, 0x8F93} /* 4E */,
  {-1, 0, 0x8F96} /* 4F */,
  {-1, 0, 0x8F97} /* 50 */,
  {-1, 0, 0x8F95} /* 51 */,
  {-1, 0, 0x6BC2} /* 52 */,
  {-1, 0, 0x8206} /* 53 */,
  {-1, 0, 0x8F99} /* 54 */,
  {-1, 0, 0x8F6C} /* 55 */,
  {-1, 0, 0x8F9A} /* 56 */,
  {-1, 0, 0x8F7F} /* 57 */,
  {-1, 0, 0x8F70} /* 58 */,
  {-1, 0, 0x8F94} /* 59 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x529E} /* 5F */,
  {-1, 0, 0x8F9E} /* 60 */,
  {-1, 0, 0x8FA9} /* 61 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x519C} /* 64 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8FF0} /* 6D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8FD9} /* 7D */,
  {-1, 0, 0x8FDE} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page284 = {
  0, marc8_9page284_dir
};
/* PAGE 283 */
struct yaz_iconv_trie_flat marc8_9page283_flat[] = {
  {"\x21", 0, 0x8D45},
  {"\x22", 0, 0x8D44},
  {"\x23", 0, 0x8D3C},
  {"\x24", 0, 0x8D3E},
  {"\x25", 0, 0x8D3F},
  {"\x26", 0, 0x8D40},
  {"\x27", 0, 0x8D41},
  {"\x28", 0, 0x8D42},
  {"\x29", 0, 0x5BBE},
  {"\x2A", 0, 0x8D48},
  {"\x2B", 0, 0x8D4A},
  {"\x2C", 0, 0x8D54},
  {"\x2D", 0, 0x8D4B},
  {"\x2F", 0, 0x5356},
  {"\x30", 0, 0x8D24},
  {"\x31", 0, 0x8D31},
  {"\x32", 0, 0x8D4F},
  {"\x33", 0, 0x8D50},
  {"\x34", 0, 0x8D28},
  {"\x35", 0, 0x8D4C},
  {"\x36", 0, 0x8D56},
  {"\x37", 0, 0x8D5B},
  {"\x38", 0, 0x8D5A},
  {"\x39", 0, 0x8D58},
  {"\x3A", 0, 0x8D2D},
  {"\x3B", 0, 0x8D60},
  {"\x3C", 0, 0x8D5D},
  {"\x3D", 0, 0x8D5E},
  {"\x3E", 0, 0x8D62},
  {"\x3F", 0, 0x8D61},
  {"\x40", 0, 0x8D43},
  {"\x41", 0, 0x8D4E},
  {"\x42", 0, 0x8D63},
  {"\x4F", 0, 0x8D75},
  {"\x50", 0, 0x8D76},
  {"\x53", 0, 0x8D8B},
  {"\x68", 0, 0x8DF5},
  {"\x71", 0, 0x8E0A},
  {"\x78", 0, 0x8E52},
  {"\x7E", 0, 0x8DF7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page283 = {
  marc8_9page283_flat, 0
};
/* PAGE 282 */
struct yaz_iconv_trie_dir marc8_9page282_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8C04} /* 21 */,
  {-1, 0, 0x8C01} /* 22 */,
  {-1, 0, 0x8BDE} /* 23 */,
  {-1, 0, 0x8BBA} /* 24 */,
  {-1, 0, 0x8C1B} /* 25 */,
  {-1, 0, 0x8C1A} /* 26 */,
  {-1, 0, 0x8C0F} /* 27 */,
  {-1, 0, 0x8BB3} /* 28 */,
  {-1, 0, 0x8C10} /* 29 */,
  {-1, 0, 0x8C0D} /* 2A */,
  {-1, 0, 0x8C0B} /* 2B */,
  {-1, 0, 0x8C12} /* 2C */,
  {-1, 0, 0x8C13} /* 2D */,
  {-1, 0, 0x8BFA} /* 2E */,
  {-1, 0, 0x8BBD} /* 2F */,
  {-1, 0, 0x8C15} /* 30 */,
  {-1, 0, 0x8C24} /* 31 */,
  {-1, 0, 0x8C26} /* 32 */,
  {-1, 0, 0x8C1C} /* 33 */,
  {-1, 0, 0x8BB2} /* 34 */,
  {-1, 0, 0x8C0E} /* 35 */,
  {-1, 0, 0x8C23} /* 36 */,
  {-1, 0, 0x8A8A} /* 37 */,
  {-1, 0, 0x8C22} /* 38 */,
  {-1, 0, 0x8C28} /* 39 */,
  {-1, 0, 0x8C2C} /* 3A */,
  {-1, 0, 0x8C1F} /* 3B */,
  {-1, 0, 0x8BC6} /* 3C */,
  {-1, 0, 0x8C31} /* 3D */,
  {-1, 0, 0x8C32} /* 3E */,
  {-1, 0, 0x8BC1} /* 3F */,
  {-1, 0, 0x8C2D} /* 40 */,
  {-1, 0, 0},
  {-1, 0, 0x8BA5} /* 42 */,
  {-1, 0, 0x8BAE} /* 43 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8BD1} /* 46 */,
  {-1, 0, 0x8C34} /* 47 */,
  {-1, 0, 0x62A4} /* 48 */,
  {-1, 0, 0x8A89} /* 49 */,
  {-1, 0, 0x8BFB} /* 4A */,
  {-1, 0, 0x53D8} /* 4B */,
  {-1, 0, 0x8BA9} /* 4C */,
  {-1, 0, 0x8C36} /* 4D */,
  {-1, 0, 0x8C17} /* 4E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5C82} /* 54 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7AD6} /* 57 */,
  {-1, 0, 0x4E30} /* 58 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4E88} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7683} /* 66 */,
  {-1, 0, 0},
  {-1, 0, 0x8D1D} /* 68 */,
  {-1, 0, 0x8D1E} /* 69 */,
  {-1, 0, 0x8D1F} /* 6A */,
  {-1, 0, 0x8D21} /* 6B */,
  {-1, 0, 0x8D22} /* 6C */,
  {-1, 0, 0x8D23} /* 6D */,
  {-1, 0, 0x8D2F} /* 6E */,
  {-1, 0, 0x8D27} /* 6F */,
  {-1, 0, 0x8D2A} /* 70 */,
  {-1, 0, 0x8D2B} /* 71 */,
  {-1, 0, 0x8D29} /* 72 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8D39} /* 75 */,
  {-1, 0, 0x8D32} /* 76 */,
  {-1, 0, 0x8D3A} /* 77 */,
  {-1, 0, 0x8D35} /* 78 */,
  {-1, 0, 0x8D34} /* 79 */,
  {-1, 0, 0x4E70} /* 7A */,
  {-1, 0, 0x8D2C} /* 7B */,
  {-1, 0, 0x8D3B} /* 7C */,
  {-1, 0, 0x8D37} /* 7D */,
  {-1, 0, 0x8D38} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page282 = {
  0, marc8_9page282_dir
};
/* PAGE 281 */
struct yaz_iconv_trie_dir marc8_9page281_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x889C} /* 21 */,
  {-1, 0, 0x886C} /* 22 */,
  {-1, 0, 0x88AD} /* 23 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x89C1} /* 28 */,
  {-1, 0, 0x89C4} /* 29 */,
  {-1, 0, 0x89C5} /* 2A */,
  {-1, 0, 0x89C6} /* 2B */,
  {-1, 0, 0x4EB2} /* 2C */,
  {-1, 0, 0x89CE} /* 2D */,
  {-1, 0, 0x89CA} /* 2E */,
  {-1, 0, 0x89D0} /* 2F */,
  {-1, 0, 0x89C9} /* 30 */,
  {-1, 0, 0x89C8} /* 31 */,
  {-1, 0, 0x89C2} /* 32 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x89DE} /* 35 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8BA1} /* 38 */,
  {-1, 0, 0x8BA2} /* 39 */,
  {-1, 0, 0x8BA3} /* 3A */,
  {-1, 0, 0x8BA6} /* 3B */,
  {-1, 0, 0x8BB0} /* 3C */,
  {-1, 0, 0x8BA8} /* 3D */,
  {-1, 0, 0x8BA7} /* 3E */,
  {-1, 0, 0x8BAA} /* 3F */,
  {-1, 0, 0x8BAF} /* 40 */,
  {-1, 0, 0x8BAB} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0x8BAD} /* 43 */,
  {-1, 0, 0x8BBF} /* 44 */,
  {-1, 0, 0x8BC0} /* 45 */,
  {-1, 0, 0x8BB6} /* 46 */,
  {-1, 0, 0x8BB7} /* 47 */,
  {-1, 0, 0x8BB8} /* 48 */,
  {-1, 0, 0x8BBE} /* 49 */,
  {-1, 0, 0x8BB9} /* 4A */,
  {-1, 0, 0x8BBC} /* 4B */,
  {-1, 0, 0x6CE8} /* 4C */,
  {-1, 0, 0},
  {-1, 0, 0x8BC4} /* 4E */,
  {-1, 0, 0x8BCD} /* 4F */,
  {-1, 0, 0},
  {-1, 0, 0x8BC2} /* 51 */,
  {-1, 0, 0x8BCF} /* 52 */,
  {-1, 0, 0x8BC5} /* 53 */,
  {-1, 0, 0x8BC8} /* 54 */,
  {-1, 0, 0x8BCB} /* 55 */,
  {-1, 0, 0x8BC9} /* 56 */,
  {-1, 0, 0x8BCA} /* 57 */,
  {-1, 0, 0x8BE7} /* 58 */,
  {-1, 0, 0x8BE5} /* 59 */,
  {-1, 0, 0x8BE6} /* 5A */,
  {-1, 0, 0x8BD5} /* 5B */,
  {-1, 0, 0x8BD7} /* 5C */,
  {-1, 0, 0x8BD8} /* 5D */,
  {-1, 0, 0x8BE3} /* 5E */,
  {-1, 0, 0x8BD9} /* 5F */,
  {-1, 0, 0x8BDA} /* 60 */,
  {-1, 0, 0x5938} /* 61 */,
  {-1, 0, 0x8BDB} /* 62 */,
  {-1, 0, 0x8BE1} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x8BE2} /* 65 */,
  {-1, 0, 0x8BDD} /* 66 */,
  {-1, 0, 0x8BE0} /* 67 */,
  {-1, 0, 0x8BDF} /* 68 */,
  {-1, 0, 0x8BF4} /* 69 */,
  {-1, 0, 0x8BF5} /* 6A */,
  {-1, 0, 0x8BEB} /* 6B */,
  {-1, 0, 0x8BED} /* 6C */,
  {-1, 0, 0x5FD7} /* 6D */,
  {-1, 0, 0},
  {-1, 0, 0x8BEC} /* 6F */,
  {-1, 0, 0x8BA4} /* 70 */,
  {-1, 0, 0x8BEF} /* 71 */,
  {-1, 0, 0x8BF2} /* 72 */,
  {-1, 0, 0x8BF0} /* 73 */,
  {-1, 0, 0x8BF1} /* 74 */,
  {-1, 0, 0x8BF3} /* 75 */,
  {-1, 0, 0x8C0A} /* 76 */,
  {-1, 0, 0x8C06} /* 77 */,
  {-1, 0, 0x8C05} /* 78 */,
  {-1, 0, 0x8C08} /* 79 */,
  {-1, 0, 0x8BF7} /* 7A */,
  {-1, 0, 0x8BF8} /* 7B */,
  {-1, 0, 0x8BFE} /* 7C */,
  {-1, 0, 0x8C03} /* 7D */,
  {-1, 0, 0x8BFF} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page281 = {
  0, marc8_9page281_dir
};
/* PAGE 280 */
struct yaz_iconv_trie_flat marc8_9page280_flat[] = {
  {"\x24", 0, 0x8424},
  {"\x25", 0, 0x8682},
  {"\x2C", 0, 0x877C},
  {"\x32", 0, 0x86F2},
  {"\x33", 0, 0x866B},
  {"\x34", 0, 0x8749},
  {"\x35", 0, 0x8681},
  {"\x36", 0, 0x8747},
  {"\x3C", 0, 0x86CE},
  {"\x3E", 0, 0x8721},
  {"\x3F", 0, 0x86CA},
  {"\x41", 0, 0x8695},
  {"\x42", 0, 0x86EE},
  {"\x46", 0, 0x672E},
  {"\x47", 0, 0x4E8D},
  {"\x49", 0, 0x536B},
  {"\x4A", 0, 0xE913},
  {"\x62", 0, 0x8865},
  {"\x63", 0, 0x91CC},
  {"\x65", 0, 0x88C5},
  {"\x6C", 0, 0x5236},
  {"\x71", 0, 0x8934},
  {"\x73", 0, 0x88E4},
  {"\x77", 0, 0x4EB5},
  {"\x79", 0, 0x891B},
  {"\x7C", 0, 0x88C6},
  {"\x7D", 0, 0x8884},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page280 = {
  marc8_9page280_flat, 0
};
/* PAGE 279 */
struct yaz_iconv_trie_flat marc8_9page279_flat[] = {
  {"\x22", 0, 0x8427},
  {"\x24", 0, 0x59DC},
  {"\x26", 0, 0x8537},
  {"\x29", 0, 0x84DD},
  {"\x2A", 0, 0x8428},
  {"\x2E", 0, 0x501F},
  {"\x31", 0, 0x827A},
  {"\x32", 0, 0x85AE},
  {"\x35", 0, 0x836F},
  {"\x37", 0, 0x853C},
  {"\x39", 0, 0x853A},
  {"\x3A", 0, 0x82A6},
  {"\x3B", 0, 0x82F9},
  {"\x3C", 0, 0x82CF},
  {"\x3D", 0, 0x8574},
  {"\x3E", 0, 0x5170},
  {"\x40", 0, 0x85D3},
  {"\x42", 0, 0x841D},
  {"\x44", 0, 0x4E47},
  {"\x47", 0, 0x5904},
  {"\x48", 0, 0x864F},
  {"\x4A", 0, 0x53F7},
  {"\x4C", 0, 0x4E8F},
  {"\x5A", 0, 0x65E6},
  {"\x76", 0, 0x8680},
  {"\x79", 0, 0xE912},
  {"\x7A", 0, 0x867E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page279 = {
  marc8_9page279_flat, 0
};
/* PAGE 278 */
struct yaz_iconv_trie_flat marc8_9page278_flat[] = {
  {"\x28", 0, 0x835A},
  {"\x29", 0, 0x830E},
  {"\x2A", 0, 0x82CB},
  {"\x2D", 0, 0x5E84},
  {"\x3C", 0, 0x534E},
  {"\x41", 0, 0x83B1},
  {"\x4D", 0, 0x82C7},
  {"\x4F", 0, 0x53F6},
  {"\x51", 0, 0xE911},
  {"\x53", 0, 0x8364},
  {"\x55", 0, 0x83B4},
  {"\x5D", 0, 0x5E2D},
  {"\x63", 0, 0x836A},
  {"\x64", 0, 0x82CE},
  {"\x67", 0, 0x82CD},
  {"\x68", 0, 0x8298},
  {"\x6C", 0, 0x83B2},
  {"\x6E", 0, 0x836B},
  {"\x71", 0, 0x848B},
  {"\x73", 0, 0x535C},
  {"\x76", 0, 0x8361},
  {"\x7C", 0, 0x829C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page278 = {
  marc8_9page278_flat, 0
};
/* PAGE 277 */
struct yaz_iconv_trie_flat marc8_9page277_flat[] = {
  {"\x21", 0, 0x80EA},
  {"\x22", 0, 0xE90F},
  {"\x25", 0, 0x4E34},
  {"\x2B", 0, 0x53F0},
  {"\x32", 0, 0x4E0E},
  {"\x33", 0, 0x5174},
  {"\x34", 0, 0x4E3E},
  {"\x35", 0, 0x65E7},
  {"\x4A", 0, 0x8231},
  {"\x4B", 0, 0x8230},
  {"\x4E", 0, 0x8270},
  {"\x58", 0, 0xE910},
  {"\x5C", 0, 0x520D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page277 = {
  marc8_9page277_flat, 0
};
/* PAGE 276 */
struct yaz_iconv_trie_flat marc8_9page276_flat[] = {
  {"\x21", 0, 0x8083},
  {"\x44", 0, 0x80C1},
  {"\x4A", 0, 0x8090},
  {"\x4D", 0, 0x8109},
  {"\x58", 0, 0x80BE},
  {"\x59", 0, 0x80C0},
  {"\x5E", 0, 0x80A0},
  {"\x62", 0, 0x80BF},
  {"\x65", 0, 0x8111},
  {"\x6C", 0, 0x80F6},
  {"\x6E", 0, 0x80A4},
  {"\x71", 0, 0x817B},
  {"\x78", 0, 0x8113},
  {"\x79", 0, 0x80C6},
  {"\x7A", 0, 0x8138},
  {"\x7B", 0, 0x810D},
  {"\x7C", 0, 0x8110},
  {"\x7D", 0, 0x8191},
  {"\x7E", 0, 0x814A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page276 = {
  marc8_9page276_flat, 0
};
/* PAGE 275 */
struct yaz_iconv_trie_flat marc8_9page275_flat[] = {
  {"\x21", 0, 0x7EED},
  {"\x22", 0, 0x7F28},
  {"\x23", 0, 0x7EA4},
  {"\x24", 0, 0x7F06},
  {"\x33", 0, 0x7F5A},
  {"\x34", 0, 0x9A82},
  {"\x35", 0, 0x7F62},
  {"\x37", 0, 0x7F57},
  {"\x38", 0, 0x7F81},
  {"\x42", 0, 0x4E49},
  {"\x4D", 0, 0x4E60},
  {"\x51", 0, 0x7FC6},
  {"\x58", 0, 0x7FD8},
  {"\x6F", 0, 0x5723},
  {"\x71", 0, 0x95FB},
  {"\x74", 0, 0x58F0},
  {"\x75", 0, 0x8038},
  {"\x76", 0, 0x806A},
  {"\x77", 0, 0x8054},
  {"\x78", 0, 0x804C},
  {"\x79", 0, 0x8042},
  {"\x7A", 0, 0x804B},
  {"\x7B", 0, 0x542C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page275 = {
  marc8_9page275_flat, 0
};
/* PAGE 274 */
struct yaz_iconv_trie_dir marc8_9page274_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7EB1} /* 21 */,
  {-1, 0, 0x7EB3} /* 22 */,
  {-1, 0, 0x7EA7} /* 23 */,
  {-1, 0, 0x7EB8} /* 24 */,
  {-1, 0, 0x7EB7} /* 25 */,
  {-1, 0, 0x7ECA} /* 26 */,
  {-1, 0, 0},
  {-1, 0, 0x7ECB} /* 28 */,
  {-1, 0, 0x624E} /* 29 */,
  {-1, 0, 0x7ECD} /* 2A */,
  {-1, 0, 0x7EC4} /* 2B */,
  {-1, 0, 0x7EC6} /* 2C */,
  {-1, 0, 0x7EC5} /* 2D */,
  {-1, 0, 0},
  {-1, 0, 0x7ECC} /* 2F */,
  {-1, 0, 0x7EC8} /* 30 */,
  {-1, 0, 0x7EDF} /* 31 */,
  {-1, 0, 0x7EDE} /* 32 */,
  {-1, 0, 0x7ED2} /* 33 */,
  {-1, 0, 0x7ED3} /* 34 */,
  {-1, 0, 0},
  {-1, 0, 0x7EDA} /* 36 */,
  {-1, 0, 0x7EDD} /* 37 */,
  {-1, 0, 0x7EDC} /* 38 */,
  {-1, 0, 0x7ED9} /* 39 */,
  {-1, 0, 0},
  {-1, 0, 0x4E1D} /* 3B */,
  {-1, 0, 0x7ECF} /* 3C */,
  {-1, 0, 0x6346} /* 3D */,
  {-1, 0, 0x7EE2} /* 3E */,
  {-1, 0, 0x7EE5} /* 3F */,
  {-1, 0, 0x7ED1} /* 40 */,
  {-1, 0, 0x7EFC} /* 41 */,
  {-1, 0, 0x7EFD} /* 42 */,
  {-1, 0, 0x7EFE} /* 43 */,
  {-1, 0, 0x7D27} /* 44 */,
  {-1, 0, 0x7EEB} /* 45 */,
  {-1, 0, 0x7F00} /* 46 */,
  {-1, 0, 0},
  {-1, 0, 0x7F51} /* 48 */,
  {-1, 0, 0x7EB2} /* 49 */,
  {-1, 0, 0x7EF0} /* 4A */,
  {-1, 0, 0},
  {-1, 0, 0x7EFF} /* 4C */,
  {-1, 0, 0x7EF8} /* 4D */,
  {-1, 0, 0x7EF4} /* 4E */,
  {-1, 0, 0x7EF5} /* 4F */,
  {-1, 0, 0x7EB6} /* 50 */,
  {-1, 0, 0x7F01} /* 51 */,
  {-1, 0, 0x7F14} /* 52 */,
  {-1, 0, 0x7EAC} /* 53 */,
  {-1, 0, 0x7EC3} /* 54 */,
  {-1, 0, 0x7EEA} /* 55 */,
  {-1, 0, 0x7F04} /* 56 */,
  {-1, 0, 0x7F05} /* 57 */,
  {-1, 0, 0x7F09} /* 58 */,
  {-1, 0, 0x7F13} /* 59 */,
  {-1, 0, 0x7F18} /* 5A */,
  {-1, 0, 0x7F16} /* 5B */,
  {-1, 0, 0x7EBF} /* 5C */,
  {-1, 0, 0x7F0D} /* 5D */,
  {-1, 0, 0x7F0E} /* 5E */,
  {-1, 0, 0x7F23} /* 5F */,
  {-1, 0, 0x7F22} /* 60 */,
  {-1, 0, 0x8426} /* 61 */,
  {-1, 0, 0x7F1A} /* 62 */,
  {-1, 0, 0x81F4} /* 63 */,
  {-1, 0, 0xE974} /* 64 */,
  {-1, 0, 0x7F29} /* 65 */,
  {-1, 0, 0x7EE9} /* 66 */,
  {-1, 0, 0x7F2A} /* 67 */,
  {-1, 0, 0x7F15} /* 68 */,
  {-1, 0, 0x7F27} /* 69 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7F1D} /* 6C */,
  {-1, 0, 0x603B} /* 6D */,
  {-1, 0, 0x7EB5} /* 6E */,
  {-1, 0, 0x7F2B} /* 6F */,
  {-1, 0, 0x7F2E} /* 70 */,
  {-1, 0, 0x7EC7} /* 71 */,
  {-1, 0, 0x7EE3} /* 72 */,
  {-1, 0, 0x7ED5} /* 73 */,
  {-1, 0, 0x7F2D} /* 74 */,
  {-1, 0, 0xE90E} /* 75 */,
  {-1, 0, 0x7EF3} /* 76 */,
  {-1, 0, 0x8327} /* 77 */,
  {-1, 0, 0x7ECE} /* 78 */,
  {-1, 0, 0x7ED8} /* 79 */,
  {-1, 0, 0x8FAB} /* 7A */,
  {-1, 0, 0x7F24} /* 7B */,
  {-1, 0, 0},
  {-1, 0, 0x7EE7} /* 7D */,
  {-1, 0, 0x7F20} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page274 = {
  0, marc8_9page274_dir
};
/* PAGE 273 */
struct yaz_iconv_trie_flat marc8_9page273_flat[] = {
  {"\x21", 0, 0x7B0B},
  {"\x23", 0, 0x8345},
  {"\x2A", 0, 0x94B3},
  {"\x2B", 0, 0x7B3A},
  {"\x30", 0, 0x8303},
  {"\x33", 0, 0x8282},
  {"\x38", 0, 0x7BAC},
  {"\x39", 0, 0x7B03},
  {"\x3A", 0, 0x7B51},
  {"\x3C", 0, 0x7B5B},
  {"\x3E", 0, 0x7BD3},
  {"\x41", 0, 0x7B80},
  {"\x42", 0, 0x7BAB},
  {"\x45", 0, 0x7BAA},
  {"\x46", 0, 0x7BD1},
  {"\x48", 0, 0x5E18},
  {"\x4B", 0, 0x7B7E},
  {"\x4C", 0, 0x7BEE},
  {"\x4D", 0, 0x7B79},
  {"\x50", 0, 0x7B3C},
  {"\x51", 0, 0x7C41},
  {"\x52", 0, 0xE90C},
  {"\x53", 0, 0x7BF1},
  {"\x54", 0, 0x7BA9},
  {"\x55", 0, 0x5401},
  {"\x60", 0, 0x7C8B},
  {"\x62", 0, 0xE90D},
  {"\x68", 0, 0x7CAA},
  {"\x6B", 0, 0x7CAE},
  {"\x6F", 0, 0x7EA0},
  {"\x70", 0, 0x7EAA},
  {"\x71", 0, 0x7EA3},
  {"\x72", 0, 0x7EA2},
  {"\x73", 0, 0x7EAB},
  {"\x74", 0, 0x7EA6},
  {"\x75", 0, 0x7EA5},
  {"\x76", 0, 0x7EBA},
  {"\x77", 0, 0x7EB9},
  {"\x7A", 0, 0x7EAD},
  {"\x7C", 0, 0x7EB0},
  {"\x7D", 0, 0x7EAF},
  {"\x7E", 0, 0x7EBD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page273 = {
  marc8_9page273_flat, 0
};
/* PAGE 272 */
struct yaz_iconv_trie_flat marc8_9page272_flat[] = {
  {"\x22", 0, 0x4E07},
  {"\x25", 0, 0x53B6},
  {"\x36", 0, 0x5E0C},
  {"\x3C", 0, 0x79F0},
  {"\x3D", 0, 0x79CD},
  {"\x40", 0, 0x8C37},
  {"\x44", 0, 0x79EF},
  {"\x46", 0, 0x7A23},
  {"\x49", 0, 0x7A51},
  {"\x4A", 0, 0x79FD},
  {"\x4B", 0, 0xE90A},
  {"\x4C", 0, 0x7A33},
  {"\x5C", 0, 0x6D3C},
  {"\x5D", 0, 0x7A9D},
  {"\x5F", 0, 0x7A77},
  {"\x60", 0, 0x7AA5},
  {"\x61", 0, 0x7A8D},
  {"\x62", 0, 0x7A9C},
  {"\x63", 0, 0x7AA6},
  {"\x64", 0, 0x7A83},
  {"\x6B", 0, 0x7ADE},
  {"\x70", 0, 0xE90B},
  {"\x79", 0, 0x7B14},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page272 = {
  marc8_9page272_flat, 0
};
/* PAGE 271 */
struct yaz_iconv_trie_flat marc8_9page271_flat[] = {
  {"\x27", 0, 0x77EB},
  {"\x3B", 0, 0x781A},
  {"\x3E", 0, 0x7815},
  {"\x45", 0, 0x7855},
  {"\x49", 0, 0x786E},
  {"\x4C", 0, 0x7801},
  {"\x53", 0, 0x7816},
  {"\x58", 0, 0x77F6},
  {"\x59", 0, 0x7840},
  {"\x5A", 0, 0x788D},
  {"\x5B", 0, 0x77FF},
  {"\x5C", 0, 0x77FE},
  {"\x5D", 0, 0x783A},
  {"\x5E", 0, 0x783E},
  {"\x6F", 0, 0xE909},
  {"\x77", 0, 0x7978},
  {"\x78", 0, 0x796F},
  {"\x7B", 0, 0x7985},
  {"\x7C", 0, 0x793C},
  {"\x7D", 0, 0x7977},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page271 = {
  marc8_9page271_flat, 0
};
/* PAGE 270 */
struct yaz_iconv_trie_flat marc8_9page270_flat[] = {
  {"\x29", 0, 0x7691},
  {"\x2D", 0, 0x76B1},
  {"\x3A", 0, 0x76CF},
  {"\x3C", 0, 0x5C3D},
  {"\x3D", 0, 0x76D1},
  {"\x3E", 0, 0x76D8},
  {"\x3F", 0, 0x5362},
  {"\x56", 0, 0x4F17},
  {"\x57", 0, 0x56F0},
  {"\x5D", 0, 0x7750},
  {"\x73", 0, 0x4E86},
  {"\x7C", 0, 0x77A9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page270 = {
  marc8_9page270_flat, 0
};
/* PAGE 269 */
struct yaz_iconv_trie_flat marc8_9page269_flat[] = {
  {"\x2D", 0, 0x4EA9},
  {"\x31", 0, 0x7544},
  {"\x33", 0, 0x6BD5},
  {"\x34", 0, 0x5F02},
  {"\x36", 0, 0x753B},
  {"\x39", 0, 0x5F53},
  {"\x3B", 0, 0x7574},
  {"\x3C", 0, 0x8FED},
  {"\x56", 0, 0x75C9},
  {"\x60", 0, 0x75A1},
  {"\x61", 0, 0x759F},
  {"\x62", 0, 0x75EA},
  {"\x63", 0, 0x75AF},
  {"\x6A", 0, 0x75AE},
  {"\x6D", 0, 0x75E8},
  {"\x6E", 0, 0x7597},
  {"\x71", 0, 0x75A0},
  {"\x73", 0, 0x75D2},
  {"\x75", 0, 0x765E},
  {"\x76", 0, 0x763E},
  {"\x77", 0, 0x7663},
  {"\x78", 0, 0x762B},
  {"\x79", 0, 0x766B},
  {"\x7B", 0, 0x53D1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page269 = {
  marc8_9page269_flat, 0
};
/* PAGE 268 */
struct yaz_iconv_trie_flat marc8_9page268_flat[] = {
  {"\x22", 0, 0x72EF},
  {"\x23", 0, 0x72EE},
  {"\x27", 0, 0x72EC},
  {"\x28", 0, 0x72DE},
  {"\x29", 0, 0x83B7},
  {"\x2A", 0, 0x72B7},
  {"\x2B", 0, 0x517D},
  {"\x2C", 0, 0x730E},
  {"\x2D", 0, 0x736D},
  {"\x2E", 0, 0x732E},
  {"\x2F", 0, 0x7321},
  {"\x47", 0, 0x73B0},
  {"\x57", 0, 0x73F2},
  {"\x5E", 0, 0x739B},
  {"\x5F", 0, 0x7410},
  {"\x64", 0, 0x7391},
  {"\x67", 0, 0x73AF},
  {"\x68", 0, 0x7477},
  {"\x69", 0, 0x73BA},
  {"\x6B", 0, 0x73D1},
  {"\x74", 0, 0x74EF},
  {"\x7A", 0, 0x4EA7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page268 = {
  marc8_9page268_flat, 0
};
/* PAGE 267 */
struct yaz_iconv_trie_flat marc8_9page267_flat[] = {
  {"\x21", 0, 0x70BD},
  {"\x22", 0, 0x7096},
  {"\x24", 0, 0x706F},
  {"\x25", 0, 0x7116},
  {"\x26", 0, 0x70E7},
  {"\x2E", 0, 0x8425},
  {"\x30", 0, 0x70DB},
  {"\x31", 0, 0x707F},
  {"\x33", 0, 0x70E9},
  {"\x36", 0, 0x70C1},
  {"\x37", 0, 0x7089},
  {"\x38", 0, 0x70C2},
  {"\x42", 0, 0x7237},
  {"\x45", 0, 0x5C14},
  {"\x46", 0, 0x5899},
  {"\x4C", 0, 0x724D},
  {"\x53", 0, 0x5B83},
  {"\x5A", 0, 0x7275},
  {"\x5E", 0, 0x8366},
  {"\x61", 0, 0x728A},
  {"\x62", 0, 0x727A},
  {"\x68", 0, 0x72B6},
  {"\x70", 0, 0x72ED},
  {"\x72", 0, 0x72C8},
  {"\x79", 0, 0x72B9},
  {"\x7E", 0, 0x72F1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page267 = {
  marc8_9page267_flat, 0
};
/* PAGE 266 */
struct yaz_iconv_trie_flat marc8_9page266_flat[] = {
  {"\x21", 0, 0x6CFD},
  {"\x22", 0, 0x6D4A},
  {"\x26", 0, 0x6D4E},
  {"\x27", 0, 0x6CDE},
  {"\x28", 0, 0x6EE8},
  {"\x2B", 0, 0x6EE5},
  {"\x2D", 0, 0x6D9B},
  {"\x2E", 0, 0x6DA9},
  {"\x31", 0, 0x6C88},
  {"\x32", 0, 0x6CFB},
  {"\x33", 0, 0x6E0E},
  {"\x34", 0, 0x6E85},
  {"\x36", 0, 0x6EE4},
  {"\x37", 0, 0x6D4F},
  {"\x3A", 0, 0x6FD1},
  {"\x3B", 0, 0x6CA5},
  {"\x3C", 0, 0x6FD2},
  {"\x3D", 0, 0x6F47},
  {"\x3F", 0, 0x6F9C},
  {"\x41", 0, 0x6D12},
  {"\x42", 0, 0x6EE9},
  {"\x43", 0, 0x6E7E},
  {"\x44", 0, 0x6EE6},
  {"\x4A", 0, 0x707E},
  {"\x51", 0, 0x4E3A},
  {"\x5D", 0, 0x4E4C},
  {"\x66", 0, 0x65E0},
  {"\x6A", 0, 0x70BC},
  {"\x6D", 0, 0x70E6},
  {"\x6F", 0, 0x7080},
  {"\x75", 0, 0x6247},
  {"\x7D", 0, 0x70ED},
  {"\x7E", 0, 0x70EB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page266 = {
  marc8_9page266_flat, 0
};
/* PAGE 265 */
struct yaz_iconv_trie_flat marc8_9page265_flat[] = {
  {"\x2D", 0, 0x6C64},
  {"\x30", 0, 0x6D4B},
  {"\x31", 0, 0x6DA1},
  {"\x33", 0, 0x6D51},
  {"\x3D", 0, 0x6C9F},
  {"\x41", 0, 0x6C85},
  {"\x42", 0, 0x706D},
  {"\x44", 0, 0x6E7F},
  {"\x48", 0, 0x6CA7},
  {"\x4B", 0, 0x51C6},
  {"\x4F", 0, 0x6CAA},
  {"\x54", 0, 0x6E0D},
  {"\x55", 0, 0x6DA8},
  {"\x57", 0, 0x6C49},
  {"\x58", 0, 0x6EE1},
  {"\x59", 0, 0x6D9F},
  {"\x5A", 0, 0x6E10},
  {"\x5F", 0, 0x6EDE},
  {"\x63", 0, 0x6D46},
  {"\x64", 0, 0x6E17},
  {"\x65", 0, 0x6E14},
  {"\x6C", 0, 0x6CFC},
  {"\x6D", 0, 0x6DA6},
  {"\x6E", 0, 0x6DA7},
  {"\x6F", 0, 0x6D01},
  {"\x71", 0, 0x6D47},
  {"\x78", 0, 0x6E83},
  {"\x7B", 0, 0x6DC0},
  {"\x7C", 0, 0x6D53},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page265 = {
  marc8_9page265_flat, 0
};
/* PAGE 264 */
struct yaz_iconv_trie_flat marc8_9page264_flat[] = {
  {"\x4E", 0, 0x6CFE},
  {"\x59", 0, 0x6CEA},
  {"\x68", 0, 0x6D45},
  {"\x74", 0, 0x6E0A},
  {"\x77", 0, 0x6CA6},
  {"\x7D", 0, 0x6D8C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page264 = {
  marc8_9page264_flat, 0
};
/* PAGE 263 */
struct yaz_iconv_trie_flat marc8_9page263_flat[] = {
  {"\x21", 0, 0x6B22},
  {"\x29", 0, 0x5C81},
  {"\x2A", 0, 0x5386},
  {"\x2B", 0, 0x5F52},
  {"\x33", 0, 0x6B8B},
  {"\x35", 0, 0x6B87},
  {"\x36", 0, 0x6B93},
  {"\x37", 0, 0x6BA1},
  {"\x38", 0, 0x6B7C},
  {"\x3B", 0, 0x6740},
  {"\x3C", 0, 0x58F3},
  {"\x40", 0, 0x6BB4},
  {"\x55", 0, 0x6C14},
  {"\x58", 0, 0x6C22},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page263 = {
  marc8_9page263_flat, 0
};
/* PAGE 262 */
struct yaz_iconv_trie_flat marc8_9page262_flat[] = {
  {"\x26", 0, 0x6781},
  {"\x2A", 0, 0x6768},
  {"\x2B", 0, 0x6862},
  {"\x2D", 0, 0x4E1A},
  {"\x2F", 0, 0x67AB},
  {"\x37", 0, 0x8363},
  {"\x39", 0, 0x6784},
  {"\x40", 0, 0x67AA},
  {"\x44", 0, 0x6837},
  {"\x46", 0, 0x6869},
  {"\x47", 0, 0x6807},
  {"\x49", 0, 0x67A2},
  {"\x4A", 0, 0x697C},
  {"\x4C", 0, 0x6868},
  {"\x4E", 0, 0x4E50},
  {"\x4F", 0, 0x679E},
  {"\x53", 0, 0x692D},
  {"\x55", 0, 0x6811},
  {"\x57", 0, 0x6866},
  {"\x58", 0, 0x6734},
  {"\x5B", 0, 0x6865},
  {"\x5D", 0, 0x673A},
  {"\x5F", 0, 0x6863},
  {"\x61", 0, 0x68C0},
  {"\x62", 0, 0x6867},
  {"\x63", 0, 0x67E0},
  {"\x64", 0, 0x69DF},
  {"\x65", 0, 0x67DC},
  {"\x66", 0, 0x69DB},
  {"\x6A", 0, 0x6988},
  {"\x6B", 0, 0x691F},
  {"\x6C", 0, 0x6809},
  {"\x6D", 0, 0x6A79},
  {"\x6E", 0, 0x680F},
  {"\x6F", 0, 0x6A31},
  {"\x70", 0, 0x6743},
  {"\x71", 0, 0x6984},
  {"\x78", 0, 0x94A6},
  {"\x7A", 0, 0xE908},
  {"\x7C", 0, 0x6B27},
  {"\x7E", 0, 0x6B24},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page262 = {
  marc8_9page262_flat, 0
};
/* PAGE 261 */
struct yaz_iconv_trie_flat marc8_9page261_flat[] = {
  {"\x26", 0, 0x4E1C},
  {"\x63", 0, 0x6761},
  {"\x68", 0, 0x67AD},
  {"\x69", 0, 0x6800},
  {"\x6D", 0, 0x5F03},
  {"\x6E", 0, 0x6816},
  {"\x71", 0, 0x680B},
  {"\x76", 0, 0x6808},
  {"\x7A", 0, 0x67A3},
  {"\x7C", 0, 0x832D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page261 = {
  marc8_9page261_flat, 0
};
/* PAGE 260 */
struct yaz_iconv_trie_flat marc8_9page260_flat[] = {
  {"\x2D", 0, 0x65F6},
  {"\x32", 0, 0x663C},
  {"\x40", 0, 0x6656},
  {"\x41", 0, 0x6655},
  {"\x43", 0, 0x7545},
  {"\x44", 0, 0x6682},
  {"\x48", 0, 0x6653},
  {"\x49", 0, 0xE907},
  {"\x4B", 0, 0x66A7},
  {"\x4D", 0, 0x65F7},
  {"\x55", 0, 0x4E66},
  {"\x5A", 0, 0x4F1A},
  {"\x66", 0, 0x80E7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page260 = {
  marc8_9page260_flat, 0
};
/* PAGE 259 */
struct yaz_iconv_trie_flat marc8_9page259_flat[] = {
  {"\x22", 0, 0x62C5},
  {"\x24", 0, 0x6361},
  {"\x25", 0, 0x6324},
  {"\x26", 0, 0x62E7},
  {"\x28", 0, 0x62DF},
  {"\x29", 0, 0x6401},
  {"\x2A", 0, 0x6269},
  {"\x2B", 0, 0x63B7},
  {"\x2C", 0, 0x64B5},
  {"\x2E", 0, 0x6270},
  {"\x2F", 0, 0x64DE},
  {"\x30", 0, 0x6446},
  {"\x31", 0, 0x62E2},
  {"\x33", 0, 0x62E6},
  {"\x34", 0, 0x6400},
  {"\x35", 0, 0x6444},
  {"\x37", 0, 0x631B},
  {"\x38", 0, 0x644A},
  {"\x3A", 0, 0x6405},
  {"\x3B", 0, 0x63FD},
  {"\x47", 0, 0x8D25},
  {"\x4F", 0, 0x542F},
  {"\x52", 0, 0x654C},
  {"\x54", 0, 0x6570},
  {"\x56", 0, 0x655B},
  {"\x57", 0, 0x6BD9},
  {"\x63", 0, 0x65A9},
  {"\x66", 0, 0x65AD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page259 = {
  marc8_9page259_flat, 0
};
/* PAGE 258 */
struct yaz_iconv_trie_flat marc8_9page258_flat[] = {
  {"\x23", 0, 0x6302},
  {"\x36", 0, 0x62A1},
  {"\x3C", 0, 0x62E3},
  {"\x3F", 0, 0x626C},
  {"\x42", 0, 0x6325},
  {"\x4F", 0, 0x635F},
  {"\x53", 0, 0x6363},
  {"\x55", 0, 0x62A2},
  {"\x5A", 0, 0x5C4F},
  {"\x5B", 0, 0x631A},
  {"\x5F", 0, 0x6402},
  {"\x60", 0, 0x63B4},
  {"\x65", 0, 0x635E},
  {"\x66", 0, 0x62E8},
  {"\x68", 0, 0x6320},
  {"\x6E", 0, 0x6251},
  {"\x71", 0, 0x629A},
  {"\x74", 0, 0x62E5},
  {"\x76", 0, 0x51FB},
  {"\x77", 0, 0x631E},
  {"\x7A", 0, 0x6321},
  {"\x7C", 0, 0x636E},
  {"\x7D", 0, 0x63B3},
  {"\x7E", 0, 0x62E9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page258 = {
  marc8_9page258_flat, 0
};
/* PAGE 257 */
struct yaz_iconv_trie_flat marc8_9page257_flat[] = {
  {"\x6C", 0, 0x631F},
  {"\x7B", 0, 0x5377},
  {"\x7D", 0, 0x626B},
  {"\x7E", 0, 0x626A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page257 = {
  marc8_9page257_flat, 0
};
/* PAGE 256 */
struct yaz_iconv_trie_flat marc8_9page256_flat[] = {
  {"\x28", 0, 0x6001},
  {"\x29", 0, 0x5FFE},
  {"\x2B", 0, 0x6006},
  {"\x2E", 0, 0x5E86},
  {"\x31", 0, 0x60ED},
  {"\x33", 0, 0x5FE7},
  {"\x36", 0, 0x8651},
  {"\x38", 0, 0x60E8},
  {"\x39", 0, 0x60EF},
  {"\x3A", 0, 0x6078},
  {"\x3B", 0, 0x6002},
  {"\x3C", 0, 0x6B32},
  {"\x3E", 0, 0x5BAA},
  {"\x3F", 0, 0x51ED},
  {"\x41", 0, 0x60AF},
  {"\x42", 0, 0x6124},
  {"\x44", 0, 0x60EE},
  {"\x45", 0, 0x6187},
  {"\x47", 0, 0x60EB},
  {"\x48", 0, 0x5FC6},
  {"\x4A", 0, 0x5E94},
  {"\x4B", 0, 0x601C},
  {"\x4E", 0, 0x6073},
  {"\x54", 0, 0x6000},
  {"\x55", 0, 0x61D2},
  {"\x56", 0, 0x60AC},
  {"\x58", 0, 0x5FCF},
  {"\x59", 0, 0x6151},
  {"\x5B", 0, 0x60E7},
  {"\x5C", 0, 0x604B},
  {"\x6E", 0, 0x6218},
  {"\x6F", 0, 0x620F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page256 = {
  marc8_9page256_flat, 0
};
/* PAGE 255 */
struct yaz_iconv_trie_flat marc8_9page255_flat[] = {
  {"\x57", 0, 0x5FF0},
  {"\x5C", 0, 0x95F7},
  {"\x5E", 0, 0x6005},
  {"\x61", 0, 0x6076},
  {"\x6C", 0, 0x60EC},
  {"\x70", 0, 0x607B},
  {"\x77", 0, 0x7231},
  {"\x7E", 0, 0x607C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page255 = {
  marc8_9page255_flat, 0
};
/* PAGE 254 */
struct yaz_iconv_trie_flat marc8_9page254_flat[] = {
  {"\x27", 0, 0x5E9F},
  {"\x2A", 0, 0x5E7F},
  {"\x2B", 0, 0x5E99},
  {"\x2C", 0, 0x5382},
  {"\x2D", 0, 0x5E9E},
  {"\x2E", 0, 0x5E90},
  {"\x2F", 0, 0x5385},
  {"\x47", 0, 0x5F20},
  {"\x4B", 0, 0x5F39},
  {"\x4C", 0, 0x5F25},
  {"\x4D", 0, 0x5F2F},
  {"\x4F", 0, 0xE906},
  {"\x65", 0, 0x540E},
  {"\x67", 0, 0x5F84},
  {"\x6C", 0, 0x4ECE},
  {"\x6F", 0, 0x590D},
  {"\x74", 0, 0x5F7B},
  {"\x76", 0, 0x5F81},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page254 = {
  marc8_9page254_flat, 0
};
/* PAGE 253 */
struct yaz_iconv_trie_flat marc8_9page253_flat[] = {
  {"\x28", 0, 0x5C9A},
  {"\x2A", 0, 0x5D2D},
  {"\x2B", 0, 0x5C96},
  {"\x2D", 0, 0x5C7F},
  {"\x2E", 0, 0x5CB3},
  {"\x31", 0, 0x5CE6},
  {"\x32", 0, 0x5DC5},
  {"\x33", 0, 0x5CA9},
  {"\x4F", 0, 0x5E05},
  {"\x51", 0, 0x5E08},
  {"\x52", 0, 0x5E10},
  {"\x53", 0, 0x5E26},
  {"\x58", 0, 0x5E27},
  {"\x5C", 0, 0x5E3C},
  {"\x5E", 0, 0x5E01},
  {"\x60", 0, 0x5E1C},
  {"\x61", 0, 0x5E2E},
  {"\x67", 0, 0xE9D8},
  {"\x6B", 0, 0x51E0},
  {"\x76", 0, 0x5E93},
  {"\x77", 0, 0x5750},
  {"\x7E", 0, 0x5395},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page253 = {
  marc8_9page253_flat, 0
};
/* PAGE 252 */
struct yaz_iconv_trie_flat marc8_9page252_flat[] = {
  {"\x2E", 0, 0x5BDD},
  {"\x31", 0, 0x5B9E},
  {"\x32", 0, 0x5B81},
  {"\x35", 0, 0x5BBD},
  {"\x36", 0, 0x5BA1},
  {"\x37", 0, 0x5199},
  {"\x38", 0, 0x5BA0},
  {"\x39", 0, 0x5B9D},
  {"\x3F", 0, 0x4E13},
  {"\x40", 0, 0x5C06},
  {"\x42", 0, 0x5BFB},
  {"\x43", 0, 0x5BF9},
  {"\x44", 0, 0x5BFC},
  {"\x4C", 0, 0x5C34},
  {"\x60", 0, 0x5C61},
  {"\x61", 0, 0x5C42},
  {"\x63", 0, 0x5C5E},
  {"\x6E", 0, 0x5188},
  {"\x74", 0, 0x5CE1},
  {"\x79", 0, 0x5C9B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page252 = {
  marc8_9page252_flat, 0
};
/* PAGE 251 */
struct yaz_iconv_trie_flat marc8_9page251_flat[] = {
  {"\x27", 0, 0x5987},
  {"\x28", 0, 0x5A04},
  {"\x36", 0, 0x5988},
  {"\x3B", 0, 0x59AA},
  {"\x41", 0, 0x5A34},
  {"\x43", 0, 0x5A75},
  {"\x44", 0, 0x5A07},
  {"\x45", 0, 0x59A9},
  {"\x48", 0, 0x5AD4},
  {"\x4A", 0, 0x5A74},
  {"\x4B", 0, 0x5A76},
  {"\x5B", 0, 0x5B59},
  {"\x5F", 0, 0x5B5A},
  {"\x60", 0, 0x5B66},
  {"\x63", 0, 0x5B6A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page251 = {
  marc8_9page251_flat, 0
};
/* PAGE 250 */
struct yaz_iconv_trie_flat marc8_9page250_flat[] = {
  {"\x23", 0, 0x4F19},
  {"\x24", 0, 0x68A6},
  {"\x2E", 0, 0x5939},
  {"\x3F", 0, 0x5941},
  {"\x40", 0, 0x593A},
  {"\x41", 0, 0x594B},
  {"\x53", 0, 0x5986},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page250 = {
  marc8_9page250_flat, 0
};
/* PAGE 249 */
struct yaz_iconv_trie_flat marc8_9page249_flat[] = {
  {"\x3B", 0, 0x6267},
  {"\x3E", 0, 0x57A9},
  {"\x44", 0, 0x62A5},
  {"\x45", 0, 0x5C27},
  {"\x4A", 0, 0x573A},
  {"\x4D", 0, 0x6D82},
  {"\x55", 0, 0x575E},
  {"\x56", 0, 0x5757},
  {"\x59", 0, 0x5C18},
  {"\x5A", 0, 0x57AB},
  {"\x5B", 0, 0x5811},
  {"\x60", 0, 0x575F},
  {"\x61", 0, 0x5760},
  {"\x62", 0, 0x5815},
  {"\x64", 0, 0x575B},
  {"\x67", 0, 0x57A6},
  {"\x69", 0, 0x538B},
  {"\x6B", 0, 0x5739},
  {"\x6C", 0, 0x5792},
  {"\x6D", 0, 0x5784},
  {"\x6E", 0, 0x574F},
  {"\x6F", 0, 0x575C},
  {"\x71", 0, 0x575D},
  {"\x74", 0, 0x58EE},
  {"\x76", 0, 0x58F6},
  {"\x77", 0, 0x5BFF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page249 = {
  marc8_9page249_flat, 0
};
/* PAGE 248 */
struct yaz_iconv_trie_flat marc8_9page248_flat[] = {
  {"\x21", 0, 0x545C},
  {"\x22", 0, 0x545B},
  {"\x27", 0, 0x5567},
  {"\x2C", 0, 0x53F9},
  {"\x2E", 0, 0x5455},
  {"\x30", 0, 0x5C1D},
  {"\x31", 0, 0x55BD},
  {"\x32", 0, 0x5520},
  {"\x33", 0, 0x5578},
  {"\x3D", 0, 0x5480},
  {"\x40", 0, 0x53FD},
  {"\x44", 0, 0x5428},
  {"\x45", 0, 0x55B7},
  {"\x46", 0, 0xE904},
  {"\x47", 0, 0x54DD},
  {"\x4B", 0, 0x55F3},
  {"\x4E", 0, 0x549B},
  {"\x51", 0, 0x5413},
  {"\x54", 0, 0x565C},
  {"\x55", 0, 0x5411},
  {"\x56", 0, 0x5499},
  {"\x5A", 0, 0x4E25},
  {"\x5B", 0, 0x5624},
  {"\x5C", 0, 0x556D},
  {"\x5D", 0, 0x55EB},
  {"\x5E", 0, 0x56A3},
  {"\x61", 0, 0xE905},
  {"\x62", 0, 0x5453},
  {"\x64", 0, 0x5631},
  {"\x6F", 0, 0x56EF},
  {"\x70", 0, 0x56F4},
  {"\x71", 0, 0x56ED},
  {"\x72", 0, 0x5706},
  {"\x73", 0, 0x56E2},
  {"\x74", 0, 0x56FE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page248 = {
  marc8_9page248_flat, 0
};
/* PAGE 247 */
struct yaz_iconv_trie_flat marc8_9page247_flat[] = {
  {"\x3E", 0, 0x5458},
  {"\x48", 0, 0x95EE},
  {"\x49", 0, 0x54D1},
  {"\x63", 0, 0x4E27},
  {"\x68", 0, 0x5355},
  {"\x6D", 0, 0x5524},
  {"\x6F", 0, 0x4E54},
  {"\x71", 0, 0x54DF},
  {"\x78", 0, 0x556C},
  {"\x7A", 0, 0x5417},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page247 = {
  marc8_9page247_flat, 0
};
/* PAGE 246 */
struct yaz_iconv_trie_flat marc8_9page246_flat[] = {
  {"\x2B", 0, 0x4E1B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page246 = {
  marc8_9page246_flat, 0
};
/* PAGE 245 */
struct yaz_iconv_trie_flat marc8_9page245_flat[] = {
  {"\x21", 0, 0x5251},
  {"\x22", 0, 0x5218},
  {"\x23", 0, 0x5242},
  {"\x2F", 0, 0x52B2},
  {"\x33", 0, 0x52A1},
  {"\x34", 0, 0x52A8},
  {"\x35", 0, 0x52B3},
  {"\x36", 0, 0x52CB},
  {"\x37", 0, 0x80DC},
  {"\x38", 0, 0x52BF},
  {"\x3C", 0, 0x52B1},
  {"\x3D", 0, 0x529D},
  {"\x51", 0, 0x6C47},
  {"\x52", 0, 0x532E},
  {"\x55", 0, 0x533A},
  {"\x5F", 0, 0x5346},
  {"\x60", 0, 0x534F},
  {"\x7A", 0, 0x538C},
  {"\x7B", 0, 0x5389},
  {"\x7D", 0, 0x53C2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page245 = {
  marc8_9page245_flat, 0
};
/* PAGE 244 */
struct yaz_iconv_trie_flat marc8_9page244_flat[] = {
  {"\x23", 0, 0x4E24},
  {"\x40", 0, 0x51BB},
  {"\x48", 0, 0x51EF},
  {"\x6B", 0, 0x514B},
  {"\x6D", 0, 0x5219},
  {"\x70", 0, 0x521A},
  {"\x76", 0, 0x5240},
  {"\x78", 0, 0x521B},
  {"\x7C", 0, 0x5212},
  {"\x7E", 0, 0x5267},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page244 = {
  marc8_9page244_flat, 0
};
/* PAGE 243 */
struct yaz_iconv_trie_flat marc8_9page243_flat[] = {
  {"\x24", 0, 0x4E2A},
  {"\x26", 0, 0x4F25},
  {"\x2D", 0, 0x4F26},
  {"\x2E", 0, 0xE902},
  {"\x33", 0, 0x4F1F},
  {"\x35", 0, 0x4FA7},
  {"\x38", 0, 0x4FA6},
  {"\x3E", 0, 0x5BB6},
  {"\x40", 0, 0x5907},
  {"\x41", 0, 0x6770},
  {"\x43", 0, 0x4F27},
  {"\x44", 0, 0x4F1E},
  {"\x46", 0, 0x4F20},
  {"\x47", 0, 0x503A},
  {"\x49", 0, 0x4EC5},
  {"\x4A", 0, 0x503E},
  {"\x4C", 0, 0x4F24},
  {"\x51", 0, 0x4FA5},
  {"\x55", 0, 0x4EC6},
  {"\x56", 0, 0x4F2A},
  {"\x57", 0, 0x8C61},
  {"\x58", 0, 0x4FA8},
  {"\x59", 0, 0x4EEA},
  {"\x5A", 0, 0x4EBF},
  {"\x5D", 0, 0x4EF7},
  {"\x5E", 0, 0x4FAC},
  {"\x60", 0, 0x4FA9},
  {"\x61", 0, 0x4FED},
  {"\x62", 0, 0x50A7},
  {"\x63", 0, 0xE903},
  {"\x65", 0, 0x4FE6},
  {"\x66", 0, 0x4F18},
  {"\x67", 0, 0x507F},
  {"\x69", 0, 0x50A8},
  {"\x6A", 0, 0x4FEA},
  {"\x6B", 0, 0x4FE8},
  {"\x73", 0, 0x51F6},
  {"\x7A", 0, 0x513F},
  {"\x7A", 0, 0x513F},
  {"\x7B", 0, 0x5156},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page243 = {
  marc8_9page243_flat, 0
};
/* PAGE 242 */
struct yaz_iconv_trie_flat marc8_9page242_flat[] = {
  {"\x38", 0, 0x5E03},
  {"\x3C", 0, 0x5360},
  {"\x4C", 0, 0x6765},
  {"\x4F", 0, 0x4ED1},
  {"\x5D", 0, 0x4FA0},
  {"\x69", 0, 0xE901},
  {"\x6C", 0, 0x4ED3},
  {"\x73", 0, 0x4EEC},
  {"\x79", 0, 0x4FE9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page242 = {
  marc8_9page242_flat, 0
};
/* PAGE 241 */
struct yaz_iconv_trie_flat marc8_9page241_flat[] = {
  {"\x32", 0, 0x5E76},
  {"\x4C", 0, 0x5E72},
  {"\x4D", 0, 0x4E71},
  {"\x58", 0, 0x4E9A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page241 = {
  marc8_9page241_flat, 0
};
/* PAGE 240 */
struct yaz_iconv_trie_dir marc8_9page240_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {241, 0, 0} /* 30 */,
  {242, 0, 0} /* 31 */,
  {243, 0, 0} /* 32 */,
  {244, 0, 0} /* 33 */,
  {245, 0, 0} /* 34 */,
  {246, 0, 0} /* 35 */,
  {247, 0, 0} /* 36 */,
  {248, 0, 0} /* 37 */,
  {249, 0, 0} /* 38 */,
  {250, 0, 0} /* 39 */,
  {251, 0, 0} /* 3A */,
  {252, 0, 0} /* 3B */,
  {253, 0, 0} /* 3C */,
  {254, 0, 0} /* 3D */,
  {255, 0, 0} /* 3E */,
  {256, 0, 0} /* 3F */,
  {257, 0, 0} /* 40 */,
  {258, 0, 0} /* 41 */,
  {259, 0, 0} /* 42 */,
  {260, 0, 0} /* 43 */,
  {261, 0, 0} /* 44 */,
  {262, 0, 0} /* 45 */,
  {263, 0, 0} /* 46 */,
  {264, 0, 0} /* 47 */,
  {265, 0, 0} /* 48 */,
  {266, 0, 0} /* 49 */,
  {267, 0, 0} /* 4A */,
  {268, 0, 0} /* 4B */,
  {269, 0, 0} /* 4C */,
  {270, 0, 0} /* 4D */,
  {271, 0, 0} /* 4E */,
  {272, 0, 0} /* 4F */,
  {273, 0, 0} /* 50 */,
  {274, 0, 0} /* 51 */,
  {275, 0, 0} /* 52 */,
  {276, 0, 0} /* 53 */,
  {277, 0, 0} /* 54 */,
  {278, 0, 0} /* 55 */,
  {279, 0, 0} /* 56 */,
  {280, 0, 0} /* 57 */,
  {281, 0, 0} /* 58 */,
  {282, 0, 0} /* 59 */,
  {283, 0, 0} /* 5A */,
  {284, 0, 0} /* 5B */,
  {285, 0, 0} /* 5C */,
  {286, 0, 0} /* 5D */,
  {287, 0, 0} /* 5E */,
  {288, 0, 0} /* 5F */,
  {289, 0, 0} /* 60 */,
  {290, 0, 0} /* 61 */,
  {291, 0, 0} /* 62 */,
  {292, 0, 0} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {293, 0, 0} /* 66 */,
  {294, 0, 0} /* 67 */,
  {295, 0, 0} /* 68 */,
  {296, 0, 0} /* 69 */,
  {-1, 0, 0},
  {297, 0, 0} /* 6B */,
  {-1, 0, 0},
  {298, 0, 0} /* 6D */,
  {299, 0, 0} /* 6E */,
  {300, 0, 0} /* 6F */,
  {301, 0, 0} /* 70 */,
  {302, 0, 0} /* 71 */,
  {303, 0, 0} /* 72 */,
  {304, 0, 0} /* 73 */,
  {305, 0, 0} /* 74 */,
  {-1, 0, 0},
  {306, 0, 0} /* 76 */,
  {307, 0, 0} /* 77 */,
  {308, 0, 0} /* 78 */,
  {309, 0, 0} /* 79 */,
  {-1, 0, 0},
  {310, 0, 0} /* 7B */,
  {311, 0, 0} /* 7C */,
  {312, 0, 0} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page240 = {
  0, marc8_9page240_dir
};
/* PAGE 239 */
struct yaz_iconv_trie_flat marc8_9page239_flat[] = {
  {"\x23", 0, 0x9F57},
  {"\x28", 0, 0x9F60},
  {"\x3F", 0, 0x9F6E},
  {"\x40", 0, 0x9F6F},
  {"\x47", 0, 0x9F76},
  {"\x5B", 0, 0x9F8E},
  {"\x61", 0, 0x9F93},
  {"\x62", 0, 0x9F95},
  {"\x6B", 0, 0x9FA0},
  {"\x71", 0, 0x9FA5},
  {"\x72", 0, 0x9FA4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page239 = {
  marc8_9page239_flat, 0
};
/* PAGE 238 */
struct yaz_iconv_trie_flat marc8_9page238_flat[] = {
  {"\x2F", 0, 0x9F0F},
  {"\x31", 0, 0x9F10},
  {"\x32", 0, 0x9F12},
  {"\x33", 0, 0x9F16},
  {"\x34", 0, 0x9F17},
  {"\x37", 0, 0x9F1A},
  {"\x45", 0, 0x9F22},
  {"\x48", 0, 0x9F2B},
  {"\x49", 0, 0x9F26},
  {"\x53", 0, 0x9F2F},
  {"\x5E", 0, 0x9F39},
  {"\x5F", 0, 0x9F37},
  {"\x64", 0, 0x9F3D},
  {"\x69", 0, 0x9F41},
  {"\x6D", 0, 0x9F45},
  {"\x6F", 0, 0x9F46},
  {"\x71", 0, 0x9F48},
  {"\x73", 0, 0x9F49},
  {"\x79", 0, 0x9F4E},
  {"\x7B", 0, 0x9F4F},
  {"\x7C", 0, 0x9F54},
  {"\x7E", 0, 0x9F55},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page238 = {
  marc8_9page238_flat, 0
};
/* PAGE 237 */
struct yaz_iconv_trie_flat marc8_9page237_flat[] = {
  {"\x30", 0, 0x9EC1},
  {"\x35", 0, 0x9EC6},
  {"\x37", 0, 0x9EC8},
  {"\x42", 0, 0x9ECC},
  {"\x4A", 0, 0x9ED0},
  {"\x4C", 0, 0x9ED3},
  {"\x53", 0, 0x9EDA},
  {"\x55", 0, 0x9EDF},
  {"\x57", 0, 0x9EE3},
  {"\x59", 0, 0x9EE5},
  {"\x5C", 0, 0x9EE7},
  {"\x60", 0, 0x9EEE},
  {"\x66", 0, 0x9EF0},
  {"\x6F", 0, 0x9EF6},
  {"\x74", 0, 0x9EF9},
  {"\x76", 0, 0x9EFB},
  {"\x77", 0, 0x9EFC},
  {"\x7A", 0, 0x9EFD},
  {"\x7B", 0, 0xE9F3},
  {"\x7C", 0, 0x9EFF},
  {"\x7D", 0, 0x9F02},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page237 = {
  marc8_9page237_flat, 0
};
/* PAGE 236 */
struct yaz_iconv_trie_flat marc8_9page236_flat[] = {
  {"\x27", 0, 0x9E0E},
  {"\x2B", 0, 0x9E11},
  {"\x36", 0, 0x9E15},
  {"\x37", 0, 0x9E18},
  {"\x39", 0, 0x9E1C},
  {"\x3A", 0, 0x9E1B},
  {"\x3B", 0, 0x9E1D},
  {"\x3C", 0, 0x9E75},
  {"\x42", 0, 0x9E7A},
  {"\x43", 0, 0x9E7B},
  {"\x47", 0, 0x9E80},
  {"\x48", 0, 0x9E83},
  {"\x49", 0, 0x9E84},
  {"\x4B", 0, 0x9E88},
  {"\x4F", 0, 0x9E87},
  {"\x55", 0, 0x9E90},
  {"\x58", 0, 0x9E8C},
  {"\x5A", 0, 0x9E95},
  {"\x5C", 0, 0x9E91},
  {"\x5D", 0, 0x9E9B},
  {"\x66", 0, 0x9E9E},
  {"\x77", 0, 0x9EAD},
  {"\x79", 0, 0x9EAF},
  {"\x7A", 0, 0x9EB0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page236 = {
  marc8_9page236_flat, 0
};
/* PAGE 235 */
struct yaz_iconv_trie_flat marc8_9page235_flat[] = {
  {"\x22", 0, 0x9DC7},
  {"\x27", 0, 0x9DC3},
  {"\x28", 0, 0x9DBB},
  {"\x32", 0, 0x9DB9},
  {"\x34", 0, 0x9DAC},
  {"\x36", 0, 0x9DB2},
  {"\x3A", 0, 0x9DDF},
  {"\x3E", 0, 0x9DD9},
  {"\x45", 0, 0x9DD6},
  {"\x46", 0, 0x9DDE},
  {"\x4F", 0, 0x9DE9},
  {"\x57", 0, 0x9DF2},
  {"\x5B", 0, 0x9DF8},
  {"\x5C", 0, 0x9DFC},
  {"\x5F", 0, 0x9DEB},
  {"\x65", 0, 0x9DEF},
  {"\x6A", 0, 0x9DED},
  {"\x6C", 0, 0x9DE6},
  {"\x6D", 0, 0x9DEE},
  {"\x71", 0, 0x9E07},
  {"\x7E", 0, 0x9DFD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page235 = {
  marc8_9page235_flat, 0
};
/* PAGE 234 */
struct yaz_iconv_trie_flat marc8_9page234_flat[] = {
  {"\x26", 0, 0x9D5A},
  {"\x2A", 0, 0x9D52},
  {"\x2C", 0, 0x9D77},
  {"\x2E", 0, 0x9D8A},
  {"\x2F", 0, 0x9D7A},
  {"\x35", 0, 0x9D87},
  {"\x3F", 0, 0x9D78},
  {"\x42", 0, 0x9D7E},
  {"\x47", 0, 0x9D69},
  {"\x4D", 0, 0x9D7B},
  {"\x4F", 0, 0x9D83},
  {"\x52", 0, 0x9D6F},
  {"\x59", 0, 0x9DA9},
  {"\x5E", 0, 0x9D92},
  {"\x60", 0, 0x9D98},
  {"\x66", 0, 0x9DA4},
  {"\x67", 0, 0x9DAA},
  {"\x6A", 0, 0x9DA1},
  {"\x6B", 0, 0x9D9A},
  {"\x70", 0, 0x9D96},
  {"\x74", 0, 0x9DB1},
  {"\x76", 0, 0x9DB6},
  {"\x77", 0, 0x9DBC},
  {"\x79", 0, 0x9DC0},
  {"\x7A", 0, 0x9DC1},
  {"\x7B", 0, 0x9DB8},
  {"\x7C", 0, 0x9DBA},
  {"\x7E", 0, 0x9DCF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page234 = {
  marc8_9page234_flat, 0
};
/* PAGE 233 */
struct yaz_iconv_trie_flat marc8_9page233_flat[] = {
  {"\x21", 0, 0x9D02},
  {"\x22", 0, 0x9D03},
  {"\x23", 0, 0x9CF7},
  {"\x24", 0, 0x9D04},
  {"\x28", 0, 0x9D07},
  {"\x2C", 0, 0x9CF8},
  {"\x2F", 0, 0x9D2A},
  {"\x30", 0, 0x9D25},
  {"\x3F", 0, 0x9D1E},
  {"\x44", 0, 0x9D1D},
  {"\x48", 0, 0x9D1F},
  {"\x4F", 0, 0x9D41},
  {"\x53", 0, 0x9D36},
  {"\x63", 0, 0x9D3E},
  {"\x65", 0, 0x9D30},
  {"\x68", 0, 0x9D42},
  {"\x69", 0, 0x9D40},
  {"\x6B", 0, 0x9D3D},
  {"\x70", 0, 0x9D5C},
  {"\x75", 0, 0x9D53},
  {"\x7B", 0, 0x9D59},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page233 = {
  marc8_9page233_flat, 0
};
/* PAGE 232 */
struct yaz_iconv_trie_flat marc8_9page232_flat[] = {
  {"\x25", 0, 0x9C32},
  {"\x26", 0, 0x9C44},
  {"\x28", 0, 0x9C48},
  {"\x29", 0, 0x9C39},
  {"\x2A", 0, 0x9C33},
  {"\x30", 0, 0x9C47},
  {"\x32", 0, 0x9C35},
  {"\x34", 0, 0x9C37},
  {"\x38", 0, 0x9C52},
  {"\x3B", 0, 0x9C58},
  {"\x45", 0, 0x9C51},
  {"\x49", 0, 0x9C63},
  {"\x4F", 0, 0x9C67},
  {"\x55", 0, 0x9C5F},
  {"\x56", 0, 0x9C60},
  {"\x58", 0, 0x9C6D},
  {"\x5B", 0, 0x9C68},
  {"\x5C", 0, 0x9C6F},
  {"\x5E", 0, 0x9C6E},
  {"\x6B", 0, 0x9C7A},
  {"\x73", 0, 0x9CE7},
  {"\x74", 0, 0x9CF0},
  {"\x77", 0, 0x9CF2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page232 = {
  marc8_9page232_flat, 0
};
/* PAGE 231 */
struct yaz_iconv_trie_flat marc8_9page231_flat[] = {
  {"\x23", 0, 0x9BD5},
  {"\x27", 0, 0x9BE4},
  {"\x2B", 0, 0x9BF1},
  {"\x2C", 0, 0x9BE1},
  {"\x2D", 0, 0x9BDB},
  {"\x2F", 0, 0x9BE2},
  {"\x31", 0, 0x9BF0},
  {"\x34", 0, 0x9BD4},
  {"\x3E", 0, 0x9BFF},
  {"\x43", 0, 0x9C06},
  {"\x44", 0, 0x9C15},
  {"\x49", 0, 0x9C0A},
  {"\x4B", 0, 0x9C08},
  {"\x4C", 0, 0x9C14},
  {"\x4D", 0, 0x9C04},
  {"\x52", 0, 0x9C02},
  {"\x54", 0, 0x9C10},
  {"\x59", 0, 0x9C12},
  {"\x5C", 0, 0x9C09},
  {"\x66", 0, 0x9C1C},
  {"\x69", 0, 0x9C2F},
  {"\x6E", 0, 0x9C23},
  {"\x70", 0, 0x9C2E},
  {"\x71", 0, 0x9C28},
  {"\x78", 0, 0x9C21},
  {"\x79", 0, 0x9C24},
  {"\x7E", 0, 0x9C46},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page231 = {
  marc8_9page231_flat, 0
};
/* PAGE 230 */
struct yaz_iconv_trie_flat marc8_9page230_flat[] = {
  {"\x21", 0, 0x9B83},
  {"\x29", 0, 0x9B8E},
  {"\x2B", 0, 0x9B90},
  {"\x2E", 0, 0x9B93},
  {"\x2F", 0, 0x9B97},
  {"\x31", 0, 0x9B92},
  {"\x32", 0, 0x9B98},
  {"\x36", 0, 0x9B9F},
  {"\x39", 0, 0x9B9D},
  {"\x3C", 0, 0x9BAD},
  {"\x3D", 0, 0x9B9A},
  {"\x3F", 0, 0x9BA8},
  {"\x42", 0, 0x9B9E},
  {"\x43", 0, 0x9B99},
  {"\x49", 0, 0x9B86},
  {"\x4E", 0, 0x9BA0},
  {"\x56", 0, 0x9BC7},
  {"\x59", 0, 0x9BD2},
  {"\x5D", 0, 0x9BC6},
  {"\x5E", 0, 0x9BBF},
  {"\x5F", 0, 0x9BC1},
  {"\x66", 0, 0x9BB9},
  {"\x6B", 0, 0x9BBB},
  {"\x6C", 0, 0x9BD3},
  {"\x6E", 0, 0x9BC0},
  {"\x72", 0, 0x9BC8},
  {"\x77", 0, 0x9BD7},
  {"\x7A", 0, 0x9BD6},
  {"\x7C", 0, 0x9BEB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page230 = {
  marc8_9page230_flat, 0
};
/* PAGE 229 */
struct yaz_iconv_trie_flat marc8_9page229_flat[] = {
  {"\x22", 0, 0x9B35},
  {"\x23", 0, 0x9B37},
  {"\x36", 0, 0x9B43},
  {"\x3A", 0, 0x9B48},
  {"\x3C", 0, 0x9B4E},
  {"\x3E", 0, 0x9B4D},
  {"\x41", 0, 0x9B4B},
  {"\x47", 0, 0x9B51},
  {"\x5D", 0, 0x9B74},
  {"\x63", 0, 0x9B68},
  {"\x72", 0, 0x9B80},
  {"\x73", 0, 0x9B8C},
  {"\x7A", 0, 0x9B95},
  {"\x7B", 0, 0x9B7D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page229 = {
  marc8_9page229_flat, 0
};
/* PAGE 228 */
struct yaz_iconv_trie_flat marc8_9page228_flat[] = {
  {"\x21", 0, 0x9AE7},
  {"\x27", 0, 0x9AEB},
  {"\x28", 0, 0x9AF2},
  {"\x2A", 0, 0x9AEF},
  {"\x32", 0, 0x9AF9},
  {"\x35", 0, 0x9AFD},
  {"\x36", 0, 0x9B01},
  {"\x38", 0, 0x9B02},
  {"\x3B", 0, 0x9B00},
  {"\x3C", 0, 0x9B08},
  {"\x3E", 0, 0x9B04},
  {"\x41", 0, 0x9B05},
  {"\x43", 0, 0x9B0B},
  {"\x47", 0, 0x9B0E},
  {"\x4E", 0, 0x9B11},
  {"\x4F", 0, 0x9B10},
  {"\x54", 0, 0x9B18},
  {"\x56", 0, 0x9B1D},
  {"\x5E", 0, 0x9B1F},
  {"\x66", 0, 0x9B23},
  {"\x6C", 0, 0x9B29},
  {"\x73", 0, 0x9B2D},
  {"\x74", 0, 0xE9F2},
  {"\x76", 0, 0x9B2F},
  {"\x7D", 0, 0x9B34},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page228 = {
  marc8_9page228_flat, 0
};
/* PAGE 227 */
struct yaz_iconv_trie_flat marc8_9page227_flat[] = {
  {"\x22", 0, 0x9A4D},
  {"\x24", 0, 0x9A52},
  {"\x27", 0, 0x9A4A},
  {"\x2A", 0, 0x9A58},
  {"\x2C", 0, 0x9A56},
  {"\x33", 0, 0x9A64},
  {"\x34", 0, 0x9A66},
  {"\x3A", 0, 0x9A6B},
  {"\x3F", 0, 0x9AAD},
  {"\x41", 0, 0x9AAB},
  {"\x43", 0, 0x9AB1},
  {"\x45", 0, 0x9AB3},
  {"\x49", 0, 0x9AB6},
  {"\x4C", 0, 0x9ABB},
  {"\x50", 0, 0x9ABA},
  {"\x54", 0, 0x9ABD},
  {"\x57", 0, 0x9AC1},
  {"\x59", 0, 0x9AC0},
  {"\x5A", 0, 0x9AC2},
  {"\x5D", 0, 0x9AC8},
  {"\x66", 0, 0x9AD0},
  {"\x6A", 0, 0x9AD1},
  {"\x6D", 0, 0x9AD6},
  {"\x72", 0, 0x9ADC},
  {"\x74", 0, 0x9ADF},
  {"\x76", 0, 0x9AE0},
  {"\x77", 0, 0x9AE2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page227 = {
  marc8_9page227_flat, 0
};
/* PAGE 226 */
struct yaz_iconv_trie_flat marc8_9page226_flat[] = {
  {"\x24", 0, 0x9A02},
  {"\x29", 0, 0x99F8},
  {"\x2A", 0, 0x99F4},
  {"\x30", 0, 0x99FB},
  {"\x31", 0, 0x99FD},
  {"\x3D", 0, 0x9A0F},
  {"\x3E", 0, 0x9A0B},
  {"\x3F", 0, 0x9A09},
  {"\x44", 0, 0x9A04},
  {"\x45", 0, 0x9A11},
  {"\x47", 0, 0x9A05},
  {"\x48", 0, 0x9A10},
  {"\x4C", 0, 0x9A24},
  {"\x4D", 0, 0x9A22},
  {"\x4F", 0, 0x9A20},
  {"\x52", 0, 0x9A27},
  {"\x59", 0, 0x9A2F},
  {"\x5A", 0, 0x9A38},
  {"\x60", 0, 0x9A2D},
  {"\x61", 0, 0x9A35},
  {"\x64", 0, 0x9A32},
  {"\x69", 0, 0x9A36},
  {"\x6A", 0, 0x9A2E},
  {"\x70", 0, 0x9A41},
  {"\x74", 0, 0x9A3B},
  {"\x79", 0, 0x9A42},
  {"\x7A", 0, 0x9A44},
  {"\x7D", 0, 0x9A48},
  {"\x7E", 0, 0x9A4C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page226 = {
  marc8_9page226_flat, 0
};
/* PAGE 225 */
struct yaz_iconv_trie_flat marc8_9page225_flat[] = {
  {"\x22", 0, 0xE973},
  {"\x29", 0, 0x995D},
  {"\x2B", 0, 0x995F},
  {"\x2F", 0, 0x9997},
  {"\x30", 0, 0x9998},
  {"\x3B", 0, 0x99A3},
  {"\x3C", 0, 0x99A1},
  {"\x3E", 0, 0x99A6},
  {"\x41", 0, 0x99A9},
  {"\x42", 0, 0x99AA},
  {"\x49", 0, 0x99B5},
  {"\x4D", 0, 0x99BF},
  {"\x4E", 0, 0x99BC},
  {"\x4F", 0, 0x99C3},
  {"\x53", 0, 0x99B9},
  {"\x54", 0, 0x99BD},
  {"\x61", 0, 0x99D3},
  {"\x63", 0, 0x99D4},
  {"\x65", 0, 0x99C9},
  {"\x69", 0, 0x99D8},
  {"\x74", 0, 0x99EC},
  {"\x7A", 0, 0x99F0},
  {"\x7B", 0, 0x99E3},
  {"\x7C", 0, 0x99EA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page225 = {
  marc8_9page225_flat, 0
};
/* PAGE 224 */
struct yaz_iconv_trie_flat marc8_9page224_flat[] = {
  {"\x24", 0, 0x9907},
  {"\x28", 0, 0x9902},
  {"\x2F", 0, 0x9916},
  {"\x30", 0, 0x9914},
  {"\x31", 0, 0x9917},
  {"\x32", 0, 0x9911},
  {"\x38", 0, 0x9915},
  {"\x3A", 0, 0x9924},
  {"\x3B", 0, 0x991F},
  {"\x40", 0, 0x991C},
  {"\x43", 0, 0x9929},
  {"\x45", 0, 0x9927},
  {"\x47", 0, 0x991A},
  {"\x4F", 0, 0x992E},
  {"\x50", 0, 0x992C},
  {"\x51", 0, 0x992A},
  {"\x53", 0, 0x9933},
  {"\x54", 0, 0xE972},
  {"\x55", 0, 0x9932},
  {"\x56", 0, 0x992B},
  {"\x58", 0, 0x9931},
  {"\x5C", 0, 0x993B},
  {"\x60", 0, 0x993A},
  {"\x61", 0, 0x9941},
  {"\x64", 0, 0x9940},
  {"\x66", 0, 0x993C},
  {"\x6A", 0, 0x9948},
  {"\x6C", 0, 0x9947},
  {"\x6D", 0, 0x9949},
  {"\x70", 0, 0x9943},
  {"\x71", 0, 0x994D},
  {"\x72", 0, 0x994C},
  {"\x73", 0, 0x994E},
  {"\x74", 0, 0x9950},
  {"\x7A", 0, 0x9958},
  {"\x7B", 0, 0x9954},
  {"\x7E", 0, 0x9955},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page224 = {
  marc8_9page224_flat, 0
};
/* PAGE 223 */
struct yaz_iconv_trie_flat marc8_9page223_flat[] = {
  {"\x21", 0, 0x9865},
  {"\x22", 0, 0x9866},
  {"\x29", 0, 0x986C},
  {"\x30", 0, 0x9873},
  {"\x31", 0, 0x9874},
  {"\x39", 0, 0x98AD},
  {"\x40", 0, 0x98B4},
  {"\x48", 0, 0x98B8},
  {"\x4A", 0, 0x98BF},
  {"\x4D", 0, 0x98BB},
  {"\x4E", 0, 0x98C0},
  {"\x53", 0, 0x98C6},
  {"\x5F", 0, 0x98E1},
  {"\x60", 0, 0x98E3},
  {"\x61", 0, 0x98E4},
  {"\x63", 0, 0x98E5},
  {"\x68", 0, 0x98F1},
  {"\x6C", 0, 0x98EB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page223 = {
  marc8_9page223_flat, 0
};
/* PAGE 222 */
struct yaz_iconv_trie_flat marc8_9page222_flat[] = {
  {"\x23", 0, 0x980E},
  {"\x26", 0, 0x9816},
  {"\x2C", 0, 0x9826},
  {"\x2D", 0, 0x981E},
  {"\x34", 0, 0x982B},
  {"\x37", 0, 0x9820},
  {"\x38", 0, 0x981F},
  {"\x3D", 0, 0x9833},
  {"\x40", 0, 0x982E},
  {"\x44", 0, 0x982F},
  {"\x45", 0, 0x9832},
  {"\x4B", 0, 0x9847},
  {"\x4E", 0, 0x9844},
  {"\x60", 0, 0x9852},
  {"\x62", 0, 0x984B},
  {"\x66", 0, 0x983F},
  {"\x6A", 0, 0x985C},
  {"\x6B", 0, 0x9859},
  {"\x6F", 0, 0x9857},
  {"\x72", 0, 0x9856},
  {"\x77", 0, 0x9862},
  {"\x7E", 0, 0x9868},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page222 = {
  marc8_9page222_flat, 0
};
/* PAGE 221 */
struct yaz_iconv_trie_flat marc8_9page221_flat[] = {
  {"\x24", 0, 0x97B3},
  {"\x26", 0, 0x97B5},
  {"\x29", 0, 0x97B9},
  {"\x2D", 0, 0x97B8},
  {"\x35", 0, 0x97BE},
  {"\x38", 0, 0x97C0},
  {"\x3B", 0, 0x97C5},
  {"\x43", 0, 0x97C9},
  {"\x4B", 0, 0x97CE},
  {"\x4C", 0, 0x97CD},
  {"\x4E", 0, 0x97D0},
  {"\x51", 0, 0x97D4},
  {"\x53", 0, 0x97D8},
  {"\x54", 0, 0x97D9},
  {"\x59", 0, 0x97DD},
  {"\x5C", 0, 0x97DE},
  {"\x5E", 0, 0x97E0},
  {"\x60", 0, 0x97E1},
  {"\x6C", 0, 0x97F5},
  {"\x73", 0, 0x97FA},
  {"\x79", 0, 0x9807},
  {"\x7B", 0, 0x980F},
  {"\x7E", 0, 0x980D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page221 = {
  marc8_9page221_flat, 0
};
/* PAGE 220 */
struct yaz_iconv_trie_flat marc8_9page220_flat[] = {
  {"\x25", 0, 0x9767},
  {"\x2C", 0, 0x976B},
  {"\x30", 0, 0x976E},
  {"\x31", 0, 0x9777},
  {"\x32", 0, 0x9778},
  {"\x35", 0, 0x9773},
  {"\x37", 0, 0x9783},
  {"\x38", 0, 0x977A},
  {"\x3A", 0, 0x9780},
  {"\x3C", 0, 0x9781},
  {"\x40", 0, 0x9784},
  {"\x43", 0, 0x977F},
  {"\x49", 0, 0x9789},
  {"\x54", 0, 0x9794},
  {"\x59", 0, 0x979B},
  {"\x5A", 0, 0x979F},
  {"\x5C", 0, 0x979A},
  {"\x62", 0, 0x979C},
  {"\x6A", 0, 0x97AC},
  {"\x70", 0, 0x97AE},
  {"\x71", 0, 0x97A8},
  {"\x74", 0, 0x97AB},
  {"\x78", 0, 0x97A5},
  {"\x7A", 0, 0x97B2},
  {"\x7C", 0, 0x97B4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page220 = {
  marc8_9page220_flat, 0
};
/* PAGE 219 */
struct yaz_iconv_trie_flat marc8_9page219_flat[] = {
  {"\x22", 0, 0x96FF},
  {"\x27", 0, 0x9702},
  {"\x29", 0, 0x9708},
  {"\x2A", 0, 0x9705},
  {"\x38", 0, 0x971B},
  {"\x3D", 0, 0x971D},
  {"\x3E", 0, 0x9719},
  {"\x47", 0, 0x9723},
  {"\x49", 0, 0x9722},
  {"\x4A", 0, 0x9724},
  {"\x4E", 0, 0x9728},
  {"\x50", 0, 0x9726},
  {"\x52", 0, 0x9731},
  {"\x58", 0, 0x9730},
  {"\x5C", 0, 0x9736},
  {"\x6A", 0, 0x9741},
  {"\x6B", 0, 0x9747},
  {"\x6C", 0, 0x9746},
  {"\x6E", 0, 0x9749},
  {"\x75", 0, 0x9758},
  {"\x76", 0, 0x975A},
  {"\x78", 0, 0x975D},
  {"\x7B", 0, 0x975F},
  {"\x7D", 0, 0x9764},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page219 = {
  marc8_9page219_flat, 0
};
/* PAGE 218 */
struct yaz_iconv_trie_flat marc8_9page218_flat[] = {
  {"\x2F", 0, 0x96A4},
  {"\x35", 0, 0x96A9},
  {"\x37", 0, 0x96AE},
  {"\x3B", 0, 0x96B0},
  {"\x3C", 0, 0x96B2},
  {"\x3E", 0, 0x96B3},
  {"\x48", 0, 0x96B9},
  {"\x49", 0, 0x96BC},
  {"\x52", 0, 0x96CE},
  {"\x53", 0, 0x96CA},
  {"\x57", 0, 0x96D2},
  {"\x64", 0, 0x96DF},
  {"\x66", 0, 0x96D8},
  {"\x67", 0, 0x96DD},
  {"\x71", 0, 0x96E9},
  {"\x74", 0, 0x96F1},
  {"\x76", 0, 0x96F0},
  {"\x77", 0, 0x96F4},
  {"\x78", 0, 0x96FA},
  {"\x7A", 0, 0x96F5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page218 = {
  marc8_9page218_flat, 0
};
/* PAGE 217 */
struct yaz_iconv_trie_flat marc8_9page217_flat[] = {
  {"\x21", 0, 0x9627},
  {"\x2F", 0, 0x9642},
  {"\x30", 0, 0x963D},
  {"\x32", 0, 0x963C},
  {"\x3C", 0, 0x9651},
  {"\x42", 0, 0x9660},
  {"\x44", 0, 0x965C},
  {"\x46", 0, 0x9658},
  {"\x4A", 0, 0x965F},
  {"\x4B", 0, 0x9656},
  {"\x51", 0, 0x966C},
  {"\x5D", 0, 0x967B},
  {"\x5E", 0, 0x967F},
  {"\x62", 0, 0x967E},
  {"\x63", 0, 0x9684},
  {"\x65", 0, 0x9688},
  {"\x6C", 0, 0x9689},
  {"\x6D", 0, 0x9682},
  {"\x6E", 0, 0x9683},
  {"\x79", 0, 0x9696},
  {"\x7A", 0, 0x9697},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page217 = {
  marc8_9page217_flat, 0
};
/* PAGE 216 */
struct yaz_iconv_trie_flat marc8_9page216_flat[] = {
  {"\x2E", 0, 0x9585},
  {"\x30", 0, 0x9588},
  {"\x31", 0, 0x958C},
  {"\x34", 0, 0x9597},
  {"\x36", 0, 0x958E},
  {"\x38", 0, 0x959F},
  {"\x3A", 0, 0x95A0},
  {"\x42", 0, 0x95AC},
  {"\x44", 0, 0x95AB},
  {"\x48", 0, 0x95BC},
  {"\x49", 0, 0x95BE},
  {"\x4A", 0, 0x95CD},
  {"\x4D", 0, 0x95B9},
  {"\x4E", 0, 0x95BA},
  {"\x4F", 0, 0x95B6},
  {"\x50", 0, 0x95BF},
  {"\x52", 0, 0x95BD},
  {"\x59", 0, 0x95C9},
  {"\x5D", 0, 0x95CE},
  {"\x60", 0, 0x95D5},
  {"\x62", 0, 0x95D2},
  {"\x63", 0, 0x95D3},
  {"\x64", 0, 0x95D1},
  {"\x65", 0, 0x95C3},
  {"\x66", 0, 0x95DA},
  {"\x69", 0, 0x95DE},
  {"\x6A", 0, 0x95E0},
  {"\x6F", 0, 0x95E5},
  {"\x72", 0, 0x95E4},
  {"\x76", 0, 0x95E7},
  {"\x7A", 0, 0x961E},
  {"\x7B", 0, 0x9624},
  {"\x7C", 0, 0x9622},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page216 = {
  marc8_9page216_flat, 0
};
/* PAGE 215 */
struct yaz_iconv_trie_flat marc8_9page215_flat[] = {
  {"\x27", 0, 0x93F4},
  {"\x28", 0, 0x9436},
  {"\x2B", 0, 0x943B},
  {"\x2D", 0, 0x9424},
  {"\x30", 0, 0x9437},
  {"\x32", 0, 0x9440},
  {"\x35", 0, 0x942B},
  {"\x36", 0, 0x942D},
  {"\x37", 0, 0x9441},
  {"\x38", 0, 0x9431},
  {"\x3D", 0, 0x9467},
  {"\x3E", 0, 0x944C},
  {"\x40", 0, 0x9445},
  {"\x42", 0, 0x9450},
  {"\x4A", 0, 0x944A},
  {"\x53", 0, 0x9466},
  {"\x57", 0, 0x9464},
  {"\x58", 0, 0x9462},
  {"\x5C", 0, 0x9465},
  {"\x5D", 0, 0x9455},
  {"\x5E", 0, 0x945E},
  {"\x62", 0, 0x946A},
  {"\x68", 0, 0x946B},
  {"\x69", 0, 0x946D},
  {"\x6C", 0, 0x946F},
  {"\x6D", 0, 0x9471},
  {"\x71", 0, 0x9477},
  {"\x7B", 0, 0x9482},
  {"\x7C", 0, 0x9481},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page215 = {
  marc8_9page215_flat, 0
};
/* PAGE 214 */
struct yaz_iconv_trie_flat marc8_9page214_flat[] = {
  {"\x2C", 0, 0x93D3},
  {"\x2F", 0, 0x93A9},
  {"\x30", 0, 0x93E6},
  {"\x32", 0, 0x940B},
  {"\x34", 0, 0x9413},
  {"\x3B", 0, 0x940F},
  {"\x3C", 0, 0xE9F1},
  {"\x3D", 0, 0x93FB},
  {"\x49", 0, 0x93FA},
  {"\x4D", 0, 0x9419},
  {"\x4E", 0, 0x940D},
  {"\x50", 0, 0x9426},
  {"\x51", 0, 0x9427},
  {"\x55", 0, 0x9409},
  {"\x58", 0, 0x9414},
  {"\x59", 0, 0x9404},
  {"\x5C", 0, 0x9422},
  {"\x5D", 0, 0x9406},
  {"\x60", 0, 0x9410},
  {"\x62", 0, 0x9423},
  {"\x67", 0, 0x93F5},
  {"\x69", 0, 0x93F7},
  {"\x6A", 0, 0x9407},
  {"\x6F", 0, 0x940E},
  {"\x71", 0, 0x9411},
  {"\x74", 0, 0x943F},
  {"\x79", 0, 0x9429},
  {"\x7C", 0, 0x943D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page214 = {
  marc8_9page214_flat, 0
};
/* PAGE 213 */
struct yaz_iconv_trie_flat marc8_9page213_flat[] = {
  {"\x21", 0, 0x93B5},
  {"\x22", 0, 0x938C},
  {"\x23", 0, 0x9388},
  {"\x25", 0, 0x93B9},
  {"\x27", 0, 0x93A1},
  {"\x28", 0, 0x93B0},
  {"\x29", 0, 0x93A3},
  {"\x2A", 0, 0x93B7},
  {"\x2B", 0, 0x939B},
  {"\x2D", 0, 0x9398},
  {"\x3C", 0, 0x9389},
  {"\x3D", 0, 0x93A4},
  {"\x40", 0, 0x93BC},
  {"\x42", 0, 0x93A7},
  {"\x44", 0, 0x93BD},
  {"\x47", 0, 0x93A6},
  {"\x48", 0, 0x939A},
  {"\x4A", 0, 0x93AA},
  {"\x4D", 0, 0x939E},
  {"\x4F", 0, 0x9397},
  {"\x51", 0, 0x93BB},
  {"\x53", 0, 0x93F1},
  {"\x56", 0, 0x93DE},
  {"\x57", 0, 0x93EE},
  {"\x5A", 0, 0x93C7},
  {"\x5B", 0, 0x93F2},
  {"\x5D", 0, 0x93D4},
  {"\x5F", 0, 0x93E5},
  {"\x62", 0, 0x93F9},
  {"\x63", 0, 0x93CA},
  {"\x64", 0, 0x93C4},
  {"\x66", 0, 0x93E8},
  {"\x67", 0, 0x93E7},
  {"\x72", 0, 0x93DA},
  {"\x73", 0, 0x93D0},
  {"\x74", 0, 0x93EF},
  {"\x75", 0, 0x93DB},
  {"\x7C", 0, 0x93CC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page213 = {
  marc8_9page213_flat, 0
};
/* PAGE 212 */
struct yaz_iconv_trie_flat marc8_9page212_flat[] = {
  {"\x22", 0, 0x9314},
  {"\x28", 0, 0x92FE},
  {"\x2F", 0, 0x9342},
  {"\x31", 0, 0x9341},
  {"\x32", 0, 0x9319},
  {"\x35", 0, 0x934C},
  {"\x41", 0, 0x9379},
  {"\x44", 0, 0x9386},
  {"\x47", 0, 0x936A},
  {"\x48", 0, 0x935C},
  {"\x4C", 0, 0x934F},
  {"\x4D", 0, 0x9347},
  {"\x51", 0, 0x937A},
  {"\x53", 0, 0x9356},
  {"\x54", 0, 0x9371},
  {"\x56", 0, 0x937C},
  {"\x5C", 0, 0x9377},
  {"\x5D", 0, 0x9349},
  {"\x5E", 0, 0x9358},
  {"\x5F", 0, 0x935A},
  {"\x60", 0, 0xE9F0},
  {"\x62", 0, 0x935F},
  {"\x64", 0, 0x9376},
  {"\x66", 0, 0x9355},
  {"\x67", 0, 0x9354},
  {"\x6A", 0, 0x9348},
  {"\x6B", 0, 0x9374},
  {"\x6E", 0, 0x9351},
  {"\x6F", 0, 0x9364},
  {"\x71", 0, 0x936B},
  {"\x72", 0, 0x936D},
  {"\x73", 0, 0x9360},
  {"\x77", 0, 0x936E},
  {"\x79", 0, 0x938F},
  {"\x7A", 0, 0x93AC},
  {"\x7B", 0, 0x9395},
  {"\x7E", 0, 0x938B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page212 = {
  marc8_9page212_flat, 0
};
/* PAGE 211 */
struct yaz_iconv_trie_flat marc8_9page211_flat[] = {
  {"\x21", 0, 0x92C6},
  {"\x25", 0, 0x92F4},
  {"\x27", 0, 0x92CF},
  {"\x2A", 0, 0x92B2},
  {"\x2C", 0, 0x92E7},
  {"\x2D", 0, 0x92C7},
  {"\x2E", 0, 0x92F0},
  {"\x2F", 0, 0x92DB},
  {"\x30", 0, 0x92DC},
  {"\x31", 0, 0x92D8},
  {"\x33", 0, 0x92E9},
  {"\x35", 0, 0x92DD},
  {"\x39", 0, 0x92D1},
  {"\x3A", 0, 0x92CA},
  {"\x3C", 0, 0x92C2},
  {"\x3E", 0, 0x92CC},
  {"\x40", 0, 0x92EF},
  {"\x41", 0, 0x92E8},
  {"\x43", 0, 0x92EB},
  {"\x45", 0, 0x92F5},
  {"\x48", 0, 0x92F2},
  {"\x4C", 0, 0x9303},
  {"\x4D", 0, 0x9307},
  {"\x4E", 0, 0x931E},
  {"\x4F", 0, 0x9344},
  {"\x53", 0, 0x931D},
  {"\x54", 0, 0x92FA},
  {"\x58", 0, 0x931F},
  {"\x5A", 0, 0x9331},
  {"\x5B", 0, 0x9306},
  {"\x5D", 0, 0x92F9},
  {"\x5F", 0, 0x930F},
  {"\x62", 0, 0x9302},
  {"\x64", 0, 0x9324},
  {"\x66", 0, 0x9312},
  {"\x69", 0, 0x9338},
  {"\x6A", 0, 0x9323},
  {"\x6C", 0, 0x9321},
  {"\x71", 0, 0x9340},
  {"\x72", 0, 0x9301},
  {"\x74", 0, 0x9315},
  {"\x76", 0, 0x9329},
  {"\x78", 0, 0x932E},
  {"\x79", 0, 0x932A},
  {"\x7B", 0, 0x933F},
  {"\x7C", 0, 0x933A},
  {"\x7E", 0, 0x9335},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page211 = {
  marc8_9page211_flat, 0
};
/* PAGE 210 */
struct yaz_iconv_trie_flat marc8_9page210_flat[] = {
  {"\x23", 0, 0x924E},
  {"\x26", 0, 0x924C},
  {"\x27", 0, 0x9256},
  {"\x2B", 0, 0x925A},
  {"\x2E", 0, 0x9241},
  {"\x2F", 0, 0x9283},
  {"\x31", 0, 0x92A5},
  {"\x33", 0, 0x9282},
  {"\x35", 0, 0x92A8},
  {"\x37", 0, 0x927C},
  {"\x38", 0, 0x92A4},
  {"\x3E", 0, 0x9276},
  {"\x3F", 0, 0x928D},
  {"\x40", 0, 0x92EE},
  {"\x42", 0, 0x9288},
  {"\x43", 0, 0x927A},
  {"\x45", 0, 0x928E},
  {"\x46", 0, 0x92A0},
  {"\x47", 0, 0x9277},
  {"\x49", 0, 0x92AA},
  {"\x50", 0, 0x92A6},
  {"\x54", 0, 0x927E},
  {"\x55", 0, 0x929A},
  {"\x58", 0, 0x92AB},
  {"\x5B", 0, 0x9291},
  {"\x5D", 0, 0x929B},
  {"\x62", 0, 0x927F},
  {"\x64", 0, 0x92A3},
  {"\x66", 0, 0x92C8},
  {"\x6A", 0, 0x92C3},
  {"\x6F", 0, 0x92D0},
  {"\x71", 0, 0x92F1},
  {"\x72", 0, 0x92DF},
  {"\x75", 0, 0x92E6},
  {"\x76", 0, 0x92B6},
  {"\x77", 0, 0x92C0},
  {"\x79", 0, 0x92BE},
  {"\x7A", 0, 0x92D9},
  {"\x7E", 0, 0x92D5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page210 = {
  marc8_9page210_flat, 0
};
/* PAGE 209 */
struct yaz_iconv_trie_flat marc8_9page209_flat[] = {
  {"\x21", 0, 0x91F9},
  {"\x22", 0, 0x91E4},
  {"\x23", 0, 0x9204},
  {"\x25", 0, 0x9201},
  {"\x26", 0, 0x922B},
  {"\x27", 0, 0x920A},
  {"\x28", 0, 0x9225},
  {"\x2A", 0, 0x9292},
  {"\x2C", 0, 0x9228},
  {"\x2E", 0, 0x9207},
  {"\x2F", 0, 0x9203},
  {"\x31", 0, 0x9200},
  {"\x32", 0, 0x9218},
  {"\x33", 0, 0x91FE},
  {"\x36", 0, 0x9208},
  {"\x37", 0, 0x9226},
  {"\x38", 0, 0x921C},
  {"\x3B", 0, 0x9224},
  {"\x43", 0, 0x9212},
  {"\x48", 0, 0x91FF},
  {"\x4A", 0, 0x9216},
  {"\x4B", 0, 0x9211},
  {"\x4E", 0, 0x9206},
  {"\x4F", 0, 0x92A2},
  {"\x51", 0, 0x9230},
  {"\x52", 0, 0x9249},
  {"\x54", 0, 0x924D},
  {"\x55", 0, 0x9248},
  {"\x58", 0, 0x923A},
  {"\x5C", 0, 0x922E},
  {"\x5F", 0, 0x9233},
  {"\x61", 0, 0x9266},
  {"\x64", 0, 0x925E},
  {"\x68", 0, 0x9235},
  {"\x6B", 0, 0x9250},
  {"\x6C", 0, 0x926B},
  {"\x6D", 0, 0x9239},
  {"\x6F", 0, 0x926D},
  {"\x70", 0, 0x926C},
  {"\x71", 0, 0x924F},
  {"\x74", 0, 0x923F},
  {"\x77", 0, 0x9260},
  {"\x7E", 0, 0x9236},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page209 = {
  marc8_9page209_flat, 0
};
/* PAGE 208 */
struct yaz_iconv_trie_flat marc8_9page208_flat[] = {
  {"\x24", 0, 0x918D},
  {"\x25", 0, 0x9193},
  {"\x2B", 0, 0x919D},
  {"\x2C", 0, 0x919A},
  {"\x30", 0, 0x91A2},
  {"\x34", 0, 0xE971},
  {"\x37", 0, 0x91A8},
  {"\x3D", 0, 0x91AA},
  {"\x41", 0, 0x91AF},
  {"\x42", 0, 0x91B1},
  {"\x47", 0, 0x91AD},
  {"\x48", 0, 0x91AE},
  {"\x4B", 0, 0x91B4},
  {"\x4C", 0, 0x91B2},
  {"\x4D", 0, 0x91B5},
  {"\x56", 0, 0x91BF},
  {"\x57", 0, 0x91BD},
  {"\x5A", 0, 0x91C2},
  {"\x5B", 0, 0x91C4},
  {"\x5C", 0, 0x91C3},
  {"\x61", 0, 0x91D4},
  {"\x62", 0, 0x91D3},
  {"\x63", 0, 0x91D5},
  {"\x64", 0, 0x91D9},
  {"\x68", 0, 0x91E2},
  {"\x69", 0, 0x91ED},
  {"\x6A", 0, 0x91F7},
  {"\x6B", 0, 0x91FA},
  {"\x6F", 0, 0x91F2},
  {"\x71", 0, 0x91E8},
  {"\x72", 0, 0x91F6},
  {"\x73", 0, 0x91EE},
  {"\x74", 0, 0x91F4},
  {"\x77", 0, 0x91F1},
  {"\x79", 0, 0x91E9},
  {"\x7A", 0, 0x91F8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page208 = {
  marc8_9page208_flat, 0
};
/* PAGE 207 */
struct yaz_iconv_trie_flat marc8_9page207_flat[] = {
  {"\x21", 0, 0x9132},
  {"\x24", 0, 0x9126},
  {"\x2B", 0, 0x9134},
  {"\x2C", 0, 0x9136},
  {"\x31", 0, 0x913A},
  {"\x32", 0, 0x913B},
  {"\x3B", 0, 0x9143},
  {"\x3E", 0, 0x9146},
  {"\x3F", 0, 0x9145},
  {"\x40", 0, 0x9148},
  {"\x41", 0, 0x9147},
  {"\x42", 0, 0x9150},
  {"\x43", 0, 0x914E},
  {"\x48", 0, 0x9159},
  {"\x49", 0, 0x915C},
  {"\x4D", 0, 0x9156},
  {"\x50", 0, 0x9158},
  {"\x52", 0, 0x915A},
  {"\x53", 0, 0x9161},
  {"\x56", 0, 0x9164},
  {"\x61", 0, 0x916F},
  {"\x62", 0, 0x916E},
  {"\x66", 0, 0x917A},
  {"\x68", 0, 0x9172},
  {"\x69", 0, 0x9179},
  {"\x6A", 0, 0x9176},
  {"\x6B", 0, 0x9174},
  {"\x6C", 0, 0x9173},
  {"\x6D", 0, 0x9185},
  {"\x6F", 0, 0x9182},
  {"\x70", 0, 0x918A},
  {"\x71", 0, 0x9186},
  {"\x72", 0, 0x918C},
  {"\x73", 0, 0x9181},
  {"\x7B", 0, 0x9191},
  {"\x7D", 0, 0x9190},
  {"\x7E", 0, 0x918E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page207 = {
  marc8_9page207_flat, 0
};
/* PAGE 206 */
struct yaz_iconv_trie_flat marc8_9page206_flat[] = {
  {"\x22", 0, 0x90DD},
  {"\x23", 0, 0x90DF},
  {"\x26", 0, 0x90E2},
  {"\x27", 0, 0x90D8},
  {"\x28", 0, 0x90DB},
  {"\x2A", 0, 0x90DC},
  {"\x2C", 0, 0x90D7},
  {"\x2D", 0, 0x90E4},
  {"\x2E", 0, 0x90EF},
  {"\x2F", 0, 0x90EA},
  {"\x32", 0, 0x90F0},
  {"\x33", 0, 0x90F4},
  {"\x34", 0, 0x90F2},
  {"\x3E", 0, 0x90EB},
  {"\x3F", 0, 0x90F3},
  {"\x46", 0, 0x90FC},
  {"\x47", 0, 0x90FE},
  {"\x49", 0, 0x9104},
  {"\x4A", 0, 0x90FF},
  {"\x4C", 0, 0x9106},
  {"\x4E", 0, 0x9100},
  {"\x50", 0, 0x9107},
  {"\x57", 0, 0x910F},
  {"\x58", 0, 0x9111},
  {"\x5A", 0, 0x9116},
  {"\x5C", 0, 0x9114},
  {"\x60", 0, 0x910B},
  {"\x62", 0, 0x9123},
  {"\x63", 0, 0x9118},
  {"\x64", 0, 0x911C},
  {"\x66", 0, 0x9120},
  {"\x67", 0, 0x9122},
  {"\x6A", 0, 0x911E},
  {"\x71", 0, 0x9124},
  {"\x72", 0, 0x911A},
  {"\x74", 0, 0x9125},
  {"\x77", 0, 0x912F},
  {"\x79", 0, 0x912B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page206 = {
  marc8_9page206_flat, 0
};
/* PAGE 205 */
struct yaz_iconv_trie_flat marc8_9page205_flat[] = {
  {"\x21", 0, 0x9070},
  {"\x25", 0, 0x906F},
  {"\x26", 0, 0x9079},
  {"\x28", 0, 0x9076},
  {"\x2A", 0, 0x907B},
  {"\x2C", 0, 0x9085},
  {"\x34", 0, 0x9083},
  {"\x37", 0, 0x9088},
  {"\x3A", 0, 0x908B},
  {"\x3F", 0, 0x9099},
  {"\x40", 0, 0x9097},
  {"\x43", 0, 0x909B},
  {"\x44", 0, 0x909C},
  {"\x48", 0, 0x90A1},
  {"\x51", 0, 0x90A8},
  {"\x54", 0, 0x90A0},
  {"\x58", 0, 0x90AF},
  {"\x59", 0, 0x90B3},
  {"\x5B", 0, 0x90B6},
  {"\x5D", 0, 0x90B0},
  {"\x5F", 0, 0x90AD},
  {"\x61", 0, 0x90B2},
  {"\x68", 0, 0x90C9},
  {"\x6A", 0, 0x90BD},
  {"\x6F", 0, 0x90D5},
  {"\x72", 0, 0x90BE},
  {"\x75", 0, 0x90C7},
  {"\x78", 0, 0x90C8},
  {"\x79", 0, 0x90C3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page205 = {
  marc8_9page205_flat, 0
};
/* PAGE 204 */
struct yaz_iconv_trie_flat marc8_9page204_flat[] = {
  {"\x21", 0, 0x8FDA},
  {"\x22", 0, 0x8FD5},
  {"\x2F", 0, 0x8FE4},
  {"\x30", 0, 0x8FEE},
  {"\x35", 0, 0x8FF9},
  {"\x3C", 0, 0x8FFB},
  {"\x3F", 0, 0x9004},
  {"\x40", 0, 0x9008},
  {"\x44", 0, 0x9011},
  {"\x45", 0, 0x900B},
  {"\x48", 0, 0x900C},
  {"\x49", 0, 0x9021},
  {"\x4A", 0, 0x902D},
  {"\x4E", 0, 0x902C},
  {"\x56", 0, 0x9037},
  {"\x57", 0, 0x9034},
  {"\x58", 0, 0x902F},
  {"\x59", 0, 0x9036},
  {"\x5B", 0, 0x9046},
  {"\x5D", 0, 0x9052},
  {"\x67", 0, 0x9049},
  {"\x6A", 0, 0x9044},
  {"\x74", 0, 0x9062},
  {"\x75", 0, 0x905D},
  {"\x78", 0, 0x905B},
  {"\x7B", 0, 0x906B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page204 = {
  marc8_9page204_flat, 0
};
/* PAGE 203 */
struct yaz_iconv_trie_flat marc8_9page203_flat[] = {
  {"\x26", 0, 0x8F39},
  {"\x27", 0, 0x8F34},
  {"\x2D", 0, 0x8F40},
  {"\x30", 0, 0x8F46},
  {"\x31", 0, 0x8F4A},
  {"\x33", 0, 0x8F47},
  {"\x3D", 0, 0x8F52},
  {"\x48", 0, 0x8F56},
  {"\x49", 0, 0x8F57},
  {"\x4B", 0, 0x8F55},
  {"\x4C", 0, 0x8F58},
  {"\x4D", 0, 0x8F5C},
  {"\x4E", 0, 0x8F5E},
  {"\x53", 0, 0x8F5D},
  {"\x57", 0, 0x8F62},
  {"\x59", 0, 0x8F63},
  {"\x5A", 0, 0x8F64},
  {"\x65", 0, 0x8FA4},
  {"\x66", 0, 0x8FA5},
  {"\x6C", 0, 0x8FB5},
  {"\x6D", 0, 0x8FB7},
  {"\x6E", 0, 0x8FBB},
  {"\x70", 0, 0x8FBC},
  {"\x74", 0, 0x8FBF},
  {"\x75", 0, 0x8FD2},
  {"\x77", 0, 0x8FCB},
  {"\x7A", 0, 0x8FCA},
  {"\x7B", 0, 0x8FD3},
  {"\x7D", 0, 0x8FCD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page203 = {
  marc8_9page203_flat, 0
};
/* PAGE 202 */
struct yaz_iconv_trie_flat marc8_9page202_flat[] = {
  {"\x2E", 0, 0x8EC9},
  {"\x2F", 0, 0x8ECF},
  {"\x31", 0, 0x8ECE},
  {"\x33", 0, 0x8ED5},
  {"\x3F", 0, 0x8EFA},
  {"\x42", 0, 0x8EF9},
  {"\x4B", 0, 0x8EE8},
  {"\x4F", 0, 0x8EEB},
  {"\x51", 0, 0x8EFF},
  {"\x56", 0, 0x8F00},
  {"\x59", 0, 0x8F05},
  {"\x5A", 0, 0x8F08},
  {"\x5B", 0, 0x8F07},
  {"\x63", 0, 0x8F27},
  {"\x64", 0, 0x8F2C},
  {"\x6B", 0, 0x8F1E},
  {"\x6D", 0, 0x8F25},
  {"\x6E", 0, 0x8F20},
  {"\x75", 0, 0x8F17},
  {"\x78", 0, 0x8F36},
  {"\x79", 0, 0x8F2E},
  {"\x7A", 0, 0x8F33},
  {"\x7D", 0, 0x8F2D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page202 = {
  marc8_9page202_flat, 0
};
/* PAGE 201 */
struct yaz_iconv_trie_flat marc8_9page201_flat[] = {
  {"\x21", 0, 0x8E30},
  {"\x24", 0, 0x8E47},
  {"\x26", 0, 0x8E46},
  {"\x2E", 0, 0x8E4C},
  {"\x30", 0, 0x8E50},
  {"\x32", 0, 0x8E4F},
  {"\x34", 0, 0x8E5C},
  {"\x35", 0, 0x8E62},
  {"\x36", 0, 0x8E60},
  {"\x3A", 0, 0x8E54},
  {"\x3B", 0, 0x8E67},
  {"\x3E", 0, 0x8E5A},
  {"\x3F", 0, 0x8E5E},
  {"\x40", 0, 0x8E55},
  {"\x41", 0, 0x8E61},
  {"\x43", 0, 0x8E5D},
  {"\x44", 0, 0x8E75},
  {"\x45", 0, 0x8E74},
  {"\x46", 0, 0x8E95},
  {"\x48", 0, 0x8E6D},
  {"\x4B", 0, 0x8E69},
  {"\x52", 0, 0x8E83},
  {"\x53", 0, 0x8E84},
  {"\x57", 0, 0x8E8B},
  {"\x5D", 0, 0x8E94},
  {"\x5E", 0, 0x8E9A},
  {"\x5F", 0, 0x8E92},
  {"\x60", 0, 0x8E93},
  {"\x62", 0, 0x8E90},
  {"\x63", 0, 0x8E98},
  {"\x64", 0, 0x8E9E},
  {"\x6B", 0, 0x8EA5},
  {"\x6F", 0, 0x8EA7},
  {"\x71", 0, 0x8EA9},
  {"\x72", 0, 0x8E99},
  {"\x78", 0, 0x8EB3},
  {"\x7A", 0, 0x8EBC},
  {"\x7D", 0, 0x8EB6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page201 = {
  marc8_9page201_flat, 0
};
/* PAGE 200 */
struct yaz_iconv_trie_flat marc8_9page200_flat[] = {
  {"\x21", 0, 0x8DCF},
  {"\x22", 0, 0x8DD6},
  {"\x27", 0, 0x8DD0},
  {"\x2B", 0, 0x8DC5},
  {"\x2F", 0, 0x8DE4},
  {"\x34", 0, 0x8DEC},
  {"\x35", 0, 0x8DEB},
  {"\x36", 0, 0x8DF4},
  {"\x38", 0, 0x8DE9},
  {"\x3A", 0, 0x8DE6},
  {"\x3B", 0, 0x8DE3},
  {"\x3D", 0, 0x8DE7},
  {"\x3E", 0, 0x8DF2},
  {"\x3F", 0, 0x8E09},
  {"\x41", 0, 0x8DFD},
  {"\x44", 0, 0x8DFF},
  {"\x46", 0, 0x8E05},
  {"\x49", 0, 0x8E01},
  {"\x4E", 0, 0x8E04},
  {"\x50", 0, 0x8E06},
  {"\x52", 0, 0x8E2A},
  {"\x54", 0, 0x8E23},
  {"\x57", 0, 0x8E2E},
  {"\x58", 0, 0x8E21},
  {"\x5C", 0, 0x8E1E},
  {"\x64", 0, 0x8E16},
  {"\x66", 0, 0x8E26},
  {"\x67", 0, 0x8E27},
  {"\x68", 0, 0x8E14},
  {"\x69", 0, 0x8E18},
  {"\x6F", 0, 0x8E41},
  {"\x77", 0, 0x8E40},
  {"\x79", 0, 0x8E36},
  {"\x7E", 0, 0x8E3D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page200 = {
  marc8_9page200_flat, 0
};
/* PAGE 199 */
struct yaz_iconv_trie_flat marc8_9page199_flat[] = {
  {"\x22", 0, 0x8D96},
  {"\x2F", 0, 0x8DA1},
  {"\x33", 0, 0x8DA6},
  {"\x52", 0, 0x8DAB},
  {"\x59", 0, 0x8DAF},
  {"\x5A", 0, 0x8DB0},
  {"\x66", 0, 0x8DB2},
  {"\x6E", 0, 0x8DBC},
  {"\x6F", 0, 0x8DBA},
  {"\x70", 0, 0x8DB9},
  {"\x71", 0, 0x8DC2},
  {"\x72", 0, 0x8DC1},
  {"\x73", 0, 0x8DBF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page199 = {
  marc8_9page199_flat, 0
};
/* PAGE 198 */
struct yaz_iconv_trie_flat marc8_9page198_flat[] = {
  {"\x21", 0, 0x8CF7},
  {"\x25", 0, 0x8D04},
  {"\x26", 0, 0x8CFE},
  {"\x2B", 0, 0x8D07},
  {"\x2D", 0, 0x8D09},
  {"\x32", 0, 0x8D0C},
  {"\x39", 0, 0x8D11},
  {"\x3A", 0, 0x8D10},
  {"\x3B", 0, 0x8D12},
  {"\x3D", 0, 0x8D14},
  {"\x3E", 0, 0x8D18},
  {"\x48", 0, 0x8D6C},
  {"\x52", 0, 0x8D78},
  {"\x5C", 0, 0x8D7A},
  {"\x61", 0, 0x8D84},
  {"\x71", 0, 0x8D94},
  {"\x75", 0, 0x8D8D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page198 = {
  marc8_9page198_flat, 0
};
/* PAGE 197 */
struct yaz_iconv_trie_flat marc8_9page197_flat[] = {
  {"\x2A", 0, 0x8C86},
  {"\x2D", 0, 0x8C85},
  {"\x2E", 0, 0x8C88},
  {"\x39", 0, 0x8C94},
  {"\x41", 0, 0x8C9B},
  {"\x43", 0, 0x8C9F},
  {"\x44", 0, 0x8CA4},
  {"\x4E", 0, 0x8CB0},
  {"\x51", 0, 0x8CBA},
  {"\x52", 0, 0x8CB5},
  {"\x53", 0, 0x8CB9},
  {"\x57", 0, 0x8CCD},
  {"\x5E", 0, 0x8CD8},
  {"\x5F", 0, 0x8CD5},
  {"\x67", 0, 0x8CE8},
  {"\x68", 0, 0x8CE9},
  {"\x6A", 0, 0x8CE1},
  {"\x6F", 0, 0x8CEB},
  {"\x70", 0, 0x8CDA},
  {"\x72", 0, 0x8CDD},
  {"\x74", 0, 0x8CD9},
  {"\x76", 0, 0x8CEE},
  {"\x7B", 0, 0x8CF1},
  {"\x7C", 0, 0x8CF5},
  {"\x7E", 0, 0x8CFB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page197 = {
  marc8_9page197_flat, 0
};
/* PAGE 196 */
struct yaz_iconv_trie_flat marc8_9page196_flat[] = {
  {"\x23", 0, 0x8B8B},
  {"\x26", 0, 0x8B87},
  {"\x2D", 0, 0x8B95},
  {"\x2E", 0, 0x8B94},
  {"\x37", 0, 0x8B9C},
  {"\x3A", 0, 0x8B9F},
  {"\x3D", 0, 0x8C3A},
  {"\x44", 0, 0x8C40},
  {"\x45", 0, 0x8C42},
  {"\x4B", 0, 0x8C47},
  {"\x4D", 0, 0x8C4B},
  {"\x50", 0, 0x8C4F},
  {"\x52", 0, 0x8C55},
  {"\x54", 0, 0x8C57},
  {"\x55", 0, 0x8C5C},
  {"\x56", 0, 0x8C5D},
  {"\x5C", 0, 0x86C3},
  {"\x63", 0, 0x8C68},
  {"\x65", 0, 0x8C6D},
  {"\x6D", 0, 0x8C73},
  {"\x6F", 0, 0x8C74},
  {"\x71", 0, 0x8C75},
  {"\x73", 0, 0x8C77},
  {"\x74", 0, 0x8C76},
  {"\x7B", 0, 0x8C78},
  {"\x7D", 0, 0x8C7B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page196 = {
  marc8_9page196_flat, 0
};
/* PAGE 195 */
struct yaz_iconv_trie_flat marc8_9page195_flat[] = {
  {"\x22", 0, 0x8B2B},
  {"\x2A", 0, 0x8B37},
  {"\x2D", 0, 0x8B26},
  {"\x30", 0, 0x8B33},
  {"\x38", 0, 0x8B3E},
  {"\x3A", 0, 0x8B29},
  {"\x42", 0, 0x8B48},
  {"\x44", 0, 0x8B54},
  {"\x48", 0, 0x8B53},
  {"\x49", 0, 0x8B4A},
  {"\x4A", 0, 0x8B46},
  {"\x4D", 0, 0x8B56},
  {"\x4F", 0, 0x8B3F},
  {"\x59", 0, 0x8B59},
  {"\x5F", 0, 0x8B4D},
  {"\x68", 0, 0x8B6B},
  {"\x6B", 0, 0x8B6D},
  {"\x70", 0, 0x8B78},
  {"\x73", 0, 0x8B45},
  {"\x78", 0, 0x8B85},
  {"\x79", 0, 0x8B81},
  {"\x7B", 0, 0x8B7E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page195 = {
  marc8_9page195_flat, 0
};
/* PAGE 194 */
struct yaz_iconv_trie_flat marc8_9page194_flat[] = {
  {"\x21", 0, 0x8ABE},
  {"\x25", 0, 0x8ACF},
  {"\x27", 0, 0x8AC6},
  {"\x2C", 0, 0x8AD1},
  {"\x2D", 0, 0x8AD3},
  {"\x31", 0, 0x8AAF},
  {"\x33", 0, 0x8AD4},
  {"\x36", 0, 0x8ACD},
  {"\x38", 0, 0x8AB9},
  {"\x3B", 0, 0x8ADB},
  {"\x3F", 0, 0x8AD0},
  {"\x40", 0, 0x8AD7},
  {"\x44", 0, 0x8AF3},
  {"\x45", 0, 0x8AE2},
  {"\x49", 0, 0x8B4C},
  {"\x4C", 0, 0x8ADD},
  {"\x4E", 0, 0x8AF6},
  {"\x4F", 0, 0x8AF4},
  {"\x50", 0, 0x8AF5},
  {"\x53", 0, 0x8ADF},
  {"\x56", 0, 0x8B03},
  {"\x57", 0, 0x8AE4},
  {"\x59", 0, 0x8B14},
  {"\x5D", 0, 0x8AFC},
  {"\x62", 0, 0x8ADE},
  {"\x63", 0, 0x8AE1},
  {"\x64", 0, 0x8B07},
  {"\x6B", 0, 0x8B0C},
  {"\x6F", 0, 0x8B1C},
  {"\x73", 0, 0x8B16},
  {"\x76", 0, 0x8B1F},
  {"\x78", 0, 0x8B0B},
  {"\x79", 0, 0x8B06},
  {"\x7A", 0, 0x8B05},
  {"\x7C", 0, 0x8B0F},
  {"\x7D", 0, 0x8B10},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page194 = {
  marc8_9page194_flat, 0
};
/* PAGE 193 */
struct yaz_iconv_trie_flat marc8_9page193_flat[] = {
  {"\x25", 0, 0x8A22},
  {"\x27", 0, 0x8A51},
  {"\x28", 0, 0x8A4A},
  {"\x2A", 0, 0x8A4E},
  {"\x30", 0, 0x8A56},
  {"\x37", 0, 0x8A57},
  {"\x39", 0, 0x8A48},
  {"\x3B", 0, 0x8A58},
  {"\x3C", 0, 0x8A52},
  {"\x40", 0, 0x8A3D},
  {"\x42", 0, 0x8A45},
  {"\x4F", 0, 0x8A7F},
  {"\x50", 0, 0x8A86},
  {"\x56", 0, 0x8A61},
  {"\x58", 0, 0x8A3E},
  {"\x59", 0, 0x8A82},
  {"\x5D", 0, 0x8A84},
  {"\x5E", 0, 0x8A75},
  {"\x69", 0, 0x8A8F},
  {"\x6F", 0, 0x8A96},
  {"\x71", 0, 0x8A9A},
  {"\x7E", 0, 0x8AB6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page193 = {
  marc8_9page193_flat, 0
};
/* PAGE 192 */
struct yaz_iconv_trie_flat marc8_9page192_flat[] = {
  {"\x2A", 0, 0x89B8},
  {"\x2B", 0, 0x89B7},
  {"\x2C", 0, 0x89B6},
  {"\x2F", 0, 0x89BC},
  {"\x32", 0, 0x89BF},
  {"\x3A", 0, 0x89D6},
  {"\x3B", 0, 0x89D5},
  {"\x3F", 0, 0x89DA},
  {"\x43", 0, 0x89E5},
  {"\x45", 0, 0x89DC},
  {"\x47", 0, 0x89E1},
  {"\x4C", 0, 0x89E9},
  {"\x4D", 0, 0x89EB},
  {"\x53", 0, 0x89ED},
  {"\x58", 0, 0x89F1},
  {"\x5C", 0, 0x89F3},
  {"\x5E", 0, 0x89F5},
  {"\x60", 0, 0x89F6},
  {"\x64", 0, 0x89F7},
  {"\x6B", 0, 0x89FF},
  {"\x6C", 0, 0x8A06},
  {"\x6D", 0, 0x8A07},
  {"\x6E", 0, 0x8A04},
  {"\x70", 0, 0x8A0F},
  {"\x71", 0, 0x8A11},
  {"\x72", 0, 0x8A12},
  {"\x73", 0, 0x8A0D},
  {"\x7A", 0, 0x8A27},
  {"\x7D", 0, 0x8A29},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page192 = {
  marc8_9page192_flat, 0
};
/* PAGE 191 */
struct yaz_iconv_trie_flat marc8_9page191_flat[] = {
  {"\x21", 0, 0x894D},
  {"\x23", 0, 0x8962},
  {"\x24", 0, 0x895A},
  {"\x25", 0, 0x895E},
  {"\x29", 0, 0x895B},
  {"\x2C", 0, 0x895C},
  {"\x2D", 0, 0x895D},
  {"\x31", 0, 0x8966},
  {"\x37", 0, 0x896D},
  {"\x3A", 0, 0x896B},
  {"\x3B", 0, 0x896E},
  {"\x3C", 0, 0x896C},
  {"\x41", 0, 0x8976},
  {"\x42", 0, 0x8974},
  {"\x49", 0, 0x897B},
  {"\x4A", 0, 0x897C},
  {"\x53", 0, 0x8984},
  {"\x55", 0, 0x8985},
  {"\x62", 0, 0x8991},
  {"\x64", 0, 0x8997},
  {"\x66", 0, 0x8998},
  {"\x6B", 0, 0x899C},
  {"\x6F", 0, 0x89A1},
  {"\x76", 0, 0x89A5},
  {"\x79", 0, 0x89A9},
  {"\x7D", 0, 0x89AF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page191 = {
  marc8_9page191_flat, 0
};
/* PAGE 190 */
struct yaz_iconv_trie_flat marc8_9page190_flat[] = {
  {"\x21", 0, 0x88FC},
  {"\x23", 0, 0x88EF},
  {"\x24", 0, 0x8903},
  {"\x2D", 0, 0x8909},
  {"\x2F", 0, 0x8918},
  {"\x35", 0, 0x8906},
  {"\x36", 0, 0x890C},
  {"\x37", 0, 0x8919},
  {"\x3D", 0, 0x890A},
  {"\x43", 0, 0x8915},
  {"\x45", 0, 0x892F},
  {"\x47", 0, 0x8930},
  {"\x4E", 0, 0x8921},
  {"\x4F", 0, 0x8927},
  {"\x51", 0, 0x891F},
  {"\x53", 0, 0x8931},
  {"\x54", 0, 0x891E},
  {"\x56", 0, 0x8926},
  {"\x57", 0, 0x8922},
  {"\x5A", 0, 0x8935},
  {"\x5D", 0, 0x8941},
  {"\x60", 0, 0x8933},
  {"\x66", 0, 0x8954},
  {"\x6F", 0, 0x894F},
  {"\x72", 0, 0x8947},
  {"\x7A", 0, 0x894C},
  {"\x7B", 0, 0x8946},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page190 = {
  marc8_9page190_flat, 0
};
/* PAGE 189 */
struct yaz_iconv_trie_flat marc8_9page189_flat[] = {
  {"\x28", 0, 0x88A2},
  {"\x2A", 0, 0x88A4},
  {"\x2F", 0, 0x88AA},
  {"\x34", 0, 0x889A},
  {"\x3A", 0, 0x8890},
  {"\x3B", 0, 0x888C},
  {"\x3D", 0, 0x88A0},
  {"\x40", 0, 0x8899},
  {"\x45", 0, 0x8897},
  {"\x48", 0, 0x88C9},
  {"\x49", 0, 0x88BF},
  {"\x4A", 0, 0x88BA},
  {"\x4F", 0, 0x88C0},
  {"\x51", 0, 0x88B2},
  {"\x54", 0, 0x88BC},
  {"\x57", 0, 0x88B7},
  {"\x59", 0, 0x88BD},
  {"\x5A", 0, 0x88C4},
  {"\x5E", 0, 0x88CB},
  {"\x60", 0, 0x88CC},
  {"\x62", 0, 0x88DB},
  {"\x64", 0, 0x88CE},
  {"\x68", 0, 0x88D2},
  {"\x71", 0, 0x88F1},
  {"\x72", 0, 0x88FE},
  {"\x75", 0, 0x88F2},
  {"\x78", 0, 0x8900},
  {"\x7A", 0, 0x88F0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page189 = {
  marc8_9page189_flat, 0
};
/* PAGE 188 */
struct yaz_iconv_trie_flat marc8_9page188_flat[] = {
  {"\x23", 0, 0x8828},
  {"\x2A", 0, 0x8832},
  {"\x2E", 0, 0x882E},
  {"\x32", 0, 0x882D},
  {"\x3C", 0, 0x883C},
  {"\x41", 0, 0x8841},
  {"\x42", 0, 0xE9EF},
  {"\x44", 0, 0x8844},
  {"\x4B", 0, 0x8847},
  {"\x51", 0, 0x884A},
  {"\x53", 0, 0x884E},
  {"\x56", 0, 0x8852},
  {"\x57", 0, 0x8850},
  {"\x59", 0, 0x8856},
  {"\x5A", 0, 0x8855},
  {"\x5E", 0, 0x885C},
  {"\x5F", 0, 0x885A},
  {"\x69", 0, 0x8869},
  {"\x6D", 0, 0x886D},
  {"\x6E", 0, 0x887A},
  {"\x71", 0, 0x8875},
  {"\x75", 0, 0x8872},
  {"\x79", 0, 0x887D},
  {"\x7C", 0, 0x8879},
  {"\x7D", 0, 0x887F},
  {"\x7E", 0, 0x887E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page188 = {
  marc8_9page188_flat, 0
};
/* PAGE 187 */
struct yaz_iconv_trie_flat marc8_9page187_flat[] = {
  {"\x24", 0, 0x87BD},
  {"\x2C", 0, 0x87EE},
  {"\x30", 0, 0x87F3},
  {"\x31", 0, 0x87F0},
  {"\x34", 0, 0x87EA},
  {"\x36", 0, 0x87DB},
  {"\x37", 0, 0x87E2},
  {"\x39", 0, 0x87EB},
  {"\x3A", 0, 0x87D6},
  {"\x3F", 0, 0x87F5},
  {"\x47", 0, 0x87E0},
  {"\x48", 0, 0x87D3},
  {"\x49", 0, 0x87DC},
  {"\x4C", 0, 0x87E3},
  {"\x4D", 0, 0x8801},
  {"\x4F", 0, 0x8803},
  {"\x50", 0, 0x880A},
  {"\x55", 0, 0x87F6},
  {"\x57", 0, 0x87F7},
  {"\x5C", 0, 0x880B},
  {"\x5D", 0, 0x8806},
  {"\x5F", 0, 0x87FE},
  {"\x61", 0, 0x8810},
  {"\x63", 0, 0x8819},
  {"\x64", 0, 0x8811},
  {"\x66", 0, 0x8818},
  {"\x6A", 0, 0x8813},
  {"\x6B", 0, 0x8816},
  {"\x72", 0, 0x8834},
  {"\x73", 0, 0x881C},
  {"\x7A", 0, 0x881B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page187 = {
  marc8_9page187_flat, 0
};
/* PAGE 186 */
struct yaz_iconv_trie_flat marc8_9page186_flat[] = {
  {"\x21", 0, 0x8761},
  {"\x24", 0, 0x876A},
  {"\x27", 0, 0x874E},
  {"\x28", 0, 0x875F},
  {"\x2D", 0, 0x876F},
  {"\x2E", 0, 0x875D},
  {"\x30", 0, 0x876E},
  {"\x33", 0, 0x874D},
  {"\x35", 0, 0x8753},
  {"\x3A", 0, 0x87A3},
  {"\x3D", 0, 0x8793},
  {"\x45", 0, 0x8799},
  {"\x48", 0, 0x8788},
  {"\x4C", 0, 0x8798},
  {"\x53", 0, 0x8785},
  {"\x54", 0, 0x878B},
  {"\x55", 0, 0x8784},
  {"\x58", 0, 0x87A9},
  {"\x5D", 0, 0x8789},
  {"\x60", 0, 0x87AD},
  {"\x66", 0, 0x87BE},
  {"\x6E", 0, 0x87C4},
  {"\x6F", 0, 0x87AF},
  {"\x72", 0, 0x87AC},
  {"\x78", 0, 0x87AE},
  {"\x7E", 0, 0x87BF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page186 = {
  marc8_9page186_flat, 0
};
/* PAGE 185 */
struct yaz_iconv_trie_flat marc8_9page185_flat[] = {
  {"\x25", 0, 0x870B},
  {"\x2F", 0, 0x86FA},
  {"\x33", 0, 0x86F8},
  {"\x34", 0, 0x8706},
  {"\x36", 0, 0x870E},
  {"\x38", 0, 0x8709},
  {"\x3A", 0, 0x870A},
  {"\x3E", 0, 0x870D},
  {"\x42", 0, 0x874A},
  {"\x43", 0, 0x8723},
  {"\x44", 0, 0x8737},
  {"\x45", 0, 0x8728},
  {"\x49", 0, 0x8740},
  {"\x4B", 0, 0x872E},
  {"\x4C", 0, 0x873D},
  {"\x4E", 0, 0x871E},
  {"\x53", 0, 0x8743},
  {"\x55", 0, 0x8744},
  {"\x57", 0, 0x873E},
  {"\x59", 0, 0x8729},
  {"\x5A", 0, 0x8739},
  {"\x5F", 0, 0x871A},
  {"\x64", 0, 0x8731},
  {"\x65", 0, 0x8711},
  {"\x66", 0, 0x8712},
  {"\x6B", 0, 0x874F},
  {"\x6C", 0, 0x8771},
  {"\x6D", 0, 0x8763},
  {"\x71", 0, 0x8764},
  {"\x73", 0, 0x8765},
  {"\x74", 0, 0x877D},
  {"\x79", 0, 0x8758},
  {"\x7B", 0, 0x877B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page185 = {
  marc8_9page185_flat, 0
};
/* PAGE 184 */
struct yaz_iconv_trie_flat marc8_9page184_flat[] = {
  {"\x25", 0, 0x867A},
  {"\x26", 0, 0x8673},
  {"\x27", 0, 0x867C},
  {"\x2E", 0, 0x8696},
  {"\x2F", 0, 0x86A8},
  {"\x36", 0, 0x8691},
  {"\x37", 0, 0x869C},
  {"\x39", 0, 0x8698},
  {"\x3C", 0, 0x868D},
  {"\x3D", 0, 0x868B},
  {"\x40", 0, 0x86A6},
  {"\x42", 0, 0x869D},
  {"\x46", 0, 0x86A0},
  {"\x48", 0, 0x86A7},
  {"\x4B", 0, 0x86BF},
  {"\x58", 0, 0x86BA},
  {"\x59", 0, 0x86B0},
  {"\x60", 0, 0x86B3},
  {"\x62", 0, 0x86C9},
  {"\x63", 0, 0x86B4},
  {"\x67", 0, 0x86D8},
  {"\x6E", 0, 0x86E3},
  {"\x6F", 0, 0x86E9},
  {"\x71", 0, 0x86EC},
  {"\x74", 0, 0x86D5},
  {"\x77", 0, 0x86D0},
  {"\x7A", 0, 0x86D1},
  {"\x7E", 0, 0x86DE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page184 = {
  marc8_9page184_flat, 0
};
/* PAGE 183 */
struct yaz_iconv_trie_flat marc8_9page183_flat[] = {
  {"\x22", 0, 0x8627},
  {"\x26", 0, 0x8629},
  {"\x32", 0, 0x8637},
  {"\x38", 0, 0x8636},
  {"\x3E", 0, 0x863C},
  {"\x3F", 0, 0x8640},
  {"\x40", 0, 0x863A},
  {"\x4C", 0, 0x8645},
  {"\x59", 0, 0x864D},
  {"\x5A", 0, 0x8653},
  {"\x5E", 0, 0x8659},
  {"\x66", 0, 0x8661},
  {"\x69", 0, 0x8662},
  {"\x6A", 0, 0x8663},
  {"\x71", 0, 0x8669},
  {"\x78", 0, 0x866C},
  {"\x7B", 0, 0x8672},
  {"\x7C", 0, 0x866F},
  {"\x7E", 0, 0x867B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page183 = {
  marc8_9page183_flat, 0
};
/* PAGE 182 */
struct yaz_iconv_trie_flat marc8_9page182_flat[] = {
  {"\x24", 0, 0x8624},
  {"\x28", 0, 0x85F7},
  {"\x2C", 0, 0x85E6},
  {"\x2E", 0, 0x85D4},
  {"\x31", 0, 0x85ED},
  {"\x39", 0, 0x85DA},
  {"\x43", 0, 0x85DF},
  {"\x45", 0, 0x85D8},
  {"\x4C", 0, 0x85DC},
  {"\x4E", 0, 0x85F5},
  {"\x52", 0, 0x8622},
  {"\x54", 0, 0x8610},
  {"\x57", 0, 0x85FC},
  {"\x5B", 0, 0x85FF},
  {"\x5E", 0, 0x85FE},
  {"\x60", 0, 0x8600},
  {"\x68", 0, 0x8604},
  {"\x71", 0, 0x8605},
  {"\x75", 0, 0x862B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page182 = {
  marc8_9page182_flat, 0
};
/* PAGE 181 */
struct yaz_iconv_trie_flat marc8_9page181_flat[] = {
  {"\x25", 0, 0x8580},
  {"\x28", 0, 0x858F},
  {"\x2D", 0, 0x8579},
  {"\x32", 0, 0x857F},
  {"\x33", 0, 0x8577},
  {"\x34", 0, 0x8578},
  {"\x35", 0, 0x8598},
  {"\x36", 0, 0x857B},
  {"\x3D", 0, 0x85A4},
  {"\x42", 0, 0x857A},
  {"\x44", 0, 0x8597},
  {"\x45", 0, 0x8557},
  {"\x49", 0, 0x85A8},
  {"\x4E", 0, 0x8586},
  {"\x50", 0, 0x8599},
  {"\x51", 0, 0x858A},
  {"\x52", 0, 0x85A2},
  {"\x54", 0, 0x8590},
  {"\x56", 0, 0x8585},
  {"\x57", 0, 0x8588},
  {"\x5A", 0, 0x85B8},
  {"\x5D", 0, 0x85C1},
  {"\x61", 0, 0x85BA},
  {"\x68", 0, 0x85CE},
  {"\x6A", 0, 0x85C2},
  {"\x6B", 0, 0x85B7},
  {"\x6C", 0, 0x85B9},
  {"\x6E", 0, 0x85B3},
  {"\x6F", 0, 0x85BD},
  {"\x70", 0, 0x85C4},
  {"\x72", 0, 0x85BF},
  {"\x75", 0, 0x85BE},
  {"\x7E", 0, 0x85B6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page181 = {
  marc8_9page181_flat, 0
};
/* PAGE 180 */
struct yaz_iconv_trie_flat marc8_9page180_flat[] = {
  {"\x24", 0, 0x851E},
  {"\x2A", 0, 0x8518},
  {"\x2D", 0, 0x8526},
  {"\x2E", 0, 0xE970},
  {"\x2F", 0, 0x84E7},
  {"\x34", 0, 0x84F0},
  {"\x35", 0, 0x84EF},
  {"\x36", 0, 0x8556},
  {"\x46", 0, 0x8541},
  {"\x4B", 0, 0x8558},
  {"\x4D", 0, 0x8553},
  {"\x4E", 0, 0x8561},
  {"\x4F", 0, 0x8540},
  {"\x5A", 0, 0x8546},
  {"\x5C", 0, 0x8564},
  {"\x5D", 0, 0x855E},
  {"\x5E", 0, 0x8573},
  {"\x5F", 0, 0x8551},
  {"\x64", 0, 0x8562},
  {"\x6B", 0, 0x8563},
  {"\x6C", 0, 0x848D},
  {"\x6D", 0, 0x8542},
  {"\x71", 0, 0x854E},
  {"\x74", 0, 0x8555},
  {"\x76", 0, 0x855D},
  {"\x77", 0, 0x858C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page180 = {
  marc8_9page180_flat, 0
};
/* PAGE 179 */
struct yaz_iconv_trie_flat marc8_9page179_flat[] = {
  {"\x21", 0, 0x8495},
  {"\x27", 0, 0x84AF},
  {"\x29", 0, 0x84AD},
  {"\x32", 0, 0x84A8},
  {"\x33", 0, 0x84D6},
  {"\x35", 0, 0x84DA},
  {"\x3A", 0, 0x8493},
  {"\x3F", 0, 0x84CF},
  {"\x41", 0, 0x84CA},
  {"\x46", 0, 0x8506},
  {"\x47", 0, 0x850B},
  {"\x4D", 0, 0x8500},
  {"\x59", 0, 0x851F},
  {"\x5C", 0, 0x853B},
  {"\x5F", 0, 0x84EA},
  {"\x66", 0, 0x84F4},
  {"\x6A", 0, 0x850C},
  {"\x72", 0, 0x852F},
  {"\x75", 0, 0x8515},
  {"\x77", 0, 0x84F7},
  {"\x7A", 0, 0x84FC},
  {"\x7C", 0, 0x84EB},
  {"\x7D", 0, 0x84FD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page179 = {
  marc8_9page179_flat, 0
};
/* PAGE 178 */
struct yaz_iconv_trie_flat marc8_9page178_flat[] = {
  {"\x24", 0, 0x8432},
  {"\x29", 0, 0x845C},
  {"\x2D", 0, 0x842A},
  {"\x2E", 0, 0x8429},
  {"\x32", 0, 0x8471},
  {"\x35", 0, 0x845F},
  {"\x36", 0, 0x8460},
  {"\x37", 0, 0x846E},
  {"\x3A", 0, 0x8446},
  {"\x3C", 0, 0x8452},
  {"\x3F", 0, 0x844A},
  {"\x45", 0, 0x844E},
  {"\x49", 0, 0x8497},
  {"\x50", 0, 0x84A1},
  {"\x53", 0, 0x849F},
  {"\x56", 0, 0x84BA},
  {"\x58", 0, 0x84B9},
  {"\x5C", 0, 0x84B4},
  {"\x5E", 0, 0x84C1},
  {"\x5F", 0, 0x84BB},
  {"\x68", 0, 0x84CD},
  {"\x70", 0, 0x84B1},
  {"\x71", 0, 0x849D},
  {"\x72", 0, 0x84D0},
  {"\x75", 0, 0x8494},
  {"\x79", 0, 0x84C7},
  {"\x79", 0, 0x84C7},
  {"\x7A", 0, 0x84BD},
  {"\x7C", 0, 0x84C2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page178 = {
  marc8_9page178_flat, 0
};
/* PAGE 177 */
struct yaz_iconv_trie_flat marc8_9page177_flat[] = {
  {"\x23", 0, 0x83FD},
  {"\x25", 0, 0x841E},
  {"\x29", 0, 0x83C9},
  {"\x2A", 0, 0x83DF},
  {"\x2C", 0, 0x841F},
  {"\x2E", 0, 0x840F},
  {"\x30", 0, 0x8411},
  {"\x36", 0, 0x839A},
  {"\x3C", 0, 0x83F3},
  {"\x43", 0, 0x83D1},
  {"\x48", 0, 0x8453},
  {"\x4A", 0, 0x848E},
  {"\x4C", 0, 0x8439},
  {"\x4D", 0, 0x8476},
  {"\x4E", 0, 0x8479},
  {"\x5C", 0, 0x8451},
  {"\x5F", 0, 0x847D},
  {"\x62", 0, 0x845A},
  {"\x66", 0, 0x8459},
  {"\x69", 0, 0x8473},
  {"\x6E", 0, 0x843E},
  {"\x71", 0, 0x846D},
  {"\x78", 0, 0x847A},
  {"\x7B", 0, 0x8484},
  {"\x7C", 0, 0x8478},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page177 = {
  marc8_9page177_flat, 0
};
/* PAGE 176 */
struct yaz_iconv_trie_dir marc8_9page176_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {177, 0, 0} /* 22 */,
  {178, 0, 0} /* 23 */,
  {179, 0, 0} /* 24 */,
  {180, 0, 0} /* 25 */,
  {181, 0, 0} /* 26 */,
  {182, 0, 0} /* 27 */,
  {183, 0, 0} /* 28 */,
  {184, 0, 0} /* 29 */,
  {185, 0, 0} /* 2A */,
  {186, 0, 0} /* 2B */,
  {187, 0, 0} /* 2C */,
  {188, 0, 0} /* 2D */,
  {189, 0, 0} /* 2E */,
  {190, 0, 0} /* 2F */,
  {191, 0, 0} /* 30 */,
  {192, 0, 0} /* 31 */,
  {193, 0, 0} /* 32 */,
  {194, 0, 0} /* 33 */,
  {195, 0, 0} /* 34 */,
  {196, 0, 0} /* 35 */,
  {197, 0, 0} /* 36 */,
  {198, 0, 0} /* 37 */,
  {199, 0, 0} /* 38 */,
  {200, 0, 0} /* 39 */,
  {201, 0, 0} /* 3A */,
  {202, 0, 0} /* 3B */,
  {203, 0, 0} /* 3C */,
  {204, 0, 0} /* 3D */,
  {205, 0, 0} /* 3E */,
  {206, 0, 0} /* 3F */,
  {207, 0, 0} /* 40 */,
  {208, 0, 0} /* 41 */,
  {209, 0, 0} /* 42 */,
  {210, 0, 0} /* 43 */,
  {211, 0, 0} /* 44 */,
  {212, 0, 0} /* 45 */,
  {213, 0, 0} /* 46 */,
  {214, 0, 0} /* 47 */,
  {215, 0, 0} /* 48 */,
  {216, 0, 0} /* 49 */,
  {217, 0, 0} /* 4A */,
  {218, 0, 0} /* 4B */,
  {219, 0, 0} /* 4C */,
  {220, 0, 0} /* 4D */,
  {221, 0, 0} /* 4E */,
  {222, 0, 0} /* 4F */,
  {223, 0, 0} /* 50 */,
  {224, 0, 0} /* 51 */,
  {225, 0, 0} /* 52 */,
  {226, 0, 0} /* 53 */,
  {227, 0, 0} /* 54 */,
  {228, 0, 0} /* 55 */,
  {229, 0, 0} /* 56 */,
  {230, 0, 0} /* 57 */,
  {231, 0, 0} /* 58 */,
  {232, 0, 0} /* 59 */,
  {233, 0, 0} /* 5A */,
  {234, 0, 0} /* 5B */,
  {235, 0, 0} /* 5C */,
  {236, 0, 0} /* 5D */,
  {237, 0, 0} /* 5E */,
  {238, 0, 0} /* 5F */,
  {239, 0, 0} /* 60 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page176 = {
  0, marc8_9page176_dir
};
/* PAGE 175 */
struct yaz_iconv_trie_flat marc8_9page175_flat[] = {
  {"\x21", 0, 0x837F},
  {"\x22", 0, 0x8399},
  {"\x23", 0, 0x83A6},
  {"\x25", 0, 0x8387},
  {"\x26", 0, 0x83B9},
  {"\x2B", 0, 0x83A9},
  {"\x2F", 0, 0x839B},
  {"\x33", 0, 0x83AA},
  {"\x37", 0, 0x839C},
  {"\x38", 0, 0x839F},
  {"\x41", 0, 0x83CF},
  {"\x43", 0, 0x83F9},
  {"\x45", 0, 0x8421},
  {"\x51", 0, 0x8423},
  {"\x52", 0, 0x83EA},
  {"\x53", 0, 0x8413},
  {"\x56", 0, 0x83FC},
  {"\x57", 0, 0x83F6},
  {"\x59", 0, 0x8410},
  {"\x5A", 0, 0x83E1},
  {"\x60", 0, 0x83C6},
  {"\x61", 0, 0x8407},
  {"\x63", 0, 0x83EB},
  {"\x6A", 0, 0x83BF},
  {"\x6B", 0, 0x83E2},
  {"\x6D", 0, 0x8401},
  {"\x71", 0, 0x83D8},
  {"\x72", 0, 0x83E5},
  {"\x74", 0, 0x8418},
  {"\x79", 0, 0x83CE},
  {"\x7B", 0, 0x83D3},
  {"\x7D", 0, 0x83D6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page175 = {
  marc8_9page175_flat, 0
};
/* PAGE 174 */
struct yaz_iconv_trie_flat marc8_9page174_flat[] = {
  {"\x21", 0, 0x830C},
  {"\x22", 0, 0x82FB},
  {"\x24", 0, 0x82FD},
  {"\x26", 0, 0x8333},
  {"\x29", 0, 0x8328},
  {"\x2B", 0, 0x8344},
  {"\x2E", 0, 0x8351},
  {"\x35", 0, 0x831B},
  {"\x3B", 0, 0x8356},
  {"\x3F", 0, 0x8322},
  {"\x40", 0, 0x832C},
  {"\x48", 0, 0x833C},
  {"\x4A", 0, 0x834D},
  {"\x4D", 0, 0xE96F},
  {"\x52", 0, 0x832F},
  {"\x53", 0, 0x8348},
  {"\x54", 0, 0x8312},
  {"\x56", 0, 0x8316},
  {"\x58", 0, 0x831A},
  {"\x5F", 0, 0x8347},
  {"\x62", 0, 0x83A8},
  {"\x67", 0, 0x83AD},
  {"\x6D", 0, 0x8373},
  {"\x72", 0, 0x83B0},
  {"\x76", 0, 0x831D},
  {"\x7A", 0, 0x838F},
  {"\x7C", 0, 0x8395},
  {"\x7E", 0, 0x8375},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page174 = {
  marc8_9page174_flat, 0
};
/* PAGE 173 */
struct yaz_iconv_trie_flat marc8_9page173_flat[] = {
  {"\x24", 0, 0x828E},
  {"\x25", 0, 0x8291},
  {"\x27", 0, 0x828F},
  {"\x28", 0, 0x8284},
  {"\x2D", 0, 0x8283},
  {"\x2E", 0, 0x828A},
  {"\x31", 0, 0x82AF},
  {"\x34", 0, 0x82A7},
  {"\x38", 0, 0x82AB},
  {"\x3A", 0, 0x82B0},
  {"\x3C", 0, 0x82A4},
  {"\x3F", 0, 0x829A},
  {"\x42", 0, 0x82A3},
  {"\x44", 0, 0x82B7},
  {"\x45", 0, 0xE96E},
  {"\x46", 0, 0x82A9},
  {"\x49", 0, 0x82BC},
  {"\x4C", 0, 0x82A8},
  {"\x4E", 0, 0x82B4},
  {"\x50", 0, 0x82A1},
  {"\x53", 0, 0x82AA},
  {"\x55", 0, 0x82D9},
  {"\x57", 0, 0x82FE},
  {"\x5A", 0, 0x82E0},
  {"\x5B", 0, 0x82D0},
  {"\x5C", 0, 0x8300},
  {"\x5F", 0, 0x82EA},
  {"\x60", 0, 0x82F7},
  {"\x62", 0, 0x82EF},
  {"\x63", 0, 0x833A},
  {"\x64", 0, 0x82E4},
  {"\x65", 0, 0x82D5},
  {"\x67", 0, 0x8307},
  {"\x68", 0, 0x82FA},
  {"\x69", 0, 0x82F4},
  {"\x6A", 0, 0x82E2},
  {"\x6D", 0, 0x82D2},
  {"\x6E", 0, 0x8314},
  {"\x71", 0, 0x82EB},
  {"\x72", 0, 0x82D8},
  {"\x73", 0, 0x82E1},
  {"\x75", 0, 0x82F6},
  {"\x7B", 0, 0x8310},
  {"\x7C", 0, 0x82F3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page173 = {
  marc8_9page173_flat, 0
};
/* PAGE 172 */
struct yaz_iconv_trie_flat marc8_9page172_flat[] = {
  {"\x27", 0, 0x821D},
  {"\x29", 0, 0x8220},
  {"\x2E", 0, 0x822D},
  {"\x2F", 0, 0x822F},
  {"\x32", 0, 0x8238},
  {"\x34", 0, 0x823A},
  {"\x35", 0, 0x8233},
  {"\x36", 0, 0x8234},
  {"\x3A", 0, 0x8232},
  {"\x42", 0, 0x8248},
  {"\x43", 0, 0x8249},
  {"\x45", 0, 0x8244},
  {"\x47", 0, 0x8240},
  {"\x48", 0, 0x8241},
  {"\x4A", 0, 0x8245},
  {"\x4B", 0, 0x824B},
  {"\x50", 0, 0x824F},
  {"\x53", 0, 0x824E},
  {"\x56", 0, 0x8256},
  {"\x57", 0, 0x8257},
  {"\x5E", 0, 0x825A},
  {"\x62", 0, 0x825F},
  {"\x67", 0, 0x8262},
  {"\x6B", 0, 0x8268},
  {"\x6F", 0, 0x826D},
  {"\x77", 0, 0x8278},
  {"\x7D", 0, 0x827F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page172 = {
  marc8_9page172_flat, 0
};
/* PAGE 171 */
struct yaz_iconv_trie_flat marc8_9page171_flat[] = {
  {"\x2C", 0, 0x81B5},
  {"\x2E", 0, 0x81B0},
  {"\x2F", 0, 0x81B4},
  {"\x33", 0, 0x81B7},
  {"\x37", 0, 0x81BB},
  {"\x38", 0, 0x81C1},
  {"\x39", 0, 0x81CC},
  {"\x3A", 0, 0x81CA},
  {"\x3B", 0, 0x81C4},
  {"\x40", 0, 0x81D1},
  {"\x41", 0, 0x81CE},
  {"\x43", 0, 0x81D0},
  {"\x4B", 0, 0x81DB},
  {"\x4F", 0, 0x81DD},
  {"\x53", 0, 0x81DE},
  {"\x56", 0, 0x81E0},
  {"\x57", 0, 0x81E2},
  {"\x5B", 0, 0x81E7},
  {"\x60", 0, 0x81EF},
  {"\x65", 0, 0x81F2},
  {"\x68", 0, 0x81F6},
  {"\x70", 0, 0x8201},
  {"\x72", 0, 0xE9EE},
  {"\x74", 0, 0x8203},
  {"\x75", 0, 0x8204},
  {"\x77", 0, 0x820B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page171 = {
  marc8_9page171_flat, 0
};
/* PAGE 170 */
struct yaz_iconv_trie_flat marc8_9page170_flat[] = {
  {"\x25", 0, 0x814D},
  {"\x2E", 0, 0x6720},
  {"\x32", 0, 0x8160},
  {"\x3B", 0, 0x8169},
  {"\x3C", 0, 0x817C},
  {"\x41", 0, 0x8161},
  {"\x46", 0, 0x8176},
  {"\x47", 0, 0x8174},
  {"\x48", 0, 0x8167},
  {"\x4B", 0, 0x816F},
  {"\x4D", 0, 0x8182},
  {"\x51", 0, 0x818B},
  {"\x52", 0, 0x8186},
  {"\x59", 0, 0x8183},
  {"\x6A", 0, 0x819F},
  {"\x6B", 0, 0x81A3},
  {"\x70", 0, 0x8198},
  {"\x75", 0, 0x8195},
  {"\x77", 0, 0x8197},
  {"\x7C", 0, 0x81AA},
  {"\x7D", 0, 0x81A6},
  {"\x7E", 0, 0x6725},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page170 = {
  marc8_9page170_flat, 0
};
/* PAGE 169 */
struct yaz_iconv_trie_flat marc8_9page169_flat[] = {
  {"\x27", 0, 0x80D9},
  {"\x2A", 0, 0x80DD},
  {"\x2D", 0, 0x80CF},
  {"\x2F", 0, 0x80CD},
  {"\x30", 0, 0x80D7},
  {"\x33", 0, 0x80F2},
  {"\x34", 0, 0x80FA},
  {"\x38", 0, 0x80FE},
  {"\x3C", 0, 0x8103},
  {"\x40", 0, 0x80F9},
  {"\x41", 0, 0x80EF},
  {"\x42", 0, 0x80D4},
  {"\x49", 0, 0x811D},
  {"\x4B", 0, 0x8118},
  {"\x50", 0, 0x8130},
  {"\x54", 0, 0x8124},
  {"\x55", 0, 0x811B},
  {"\x60", 0, 0x812A},
  {"\x61", 0, 0x811E},
  {"\x64", 0, 0x8121},
  {"\x66", 0, 0x8117},
  {"\x69", 0, 0x813A},
  {"\x6A", 0, 0x815A},
  {"\x6D", 0, 0x8148},
  {"\x77", 0, 0x814C},
  {"\x7C", 0, 0x8153},
  {"\x7D", 0, 0x8141},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page169 = {
  marc8_9page169_flat, 0
};
/* PAGE 168 */
struct yaz_iconv_trie_flat marc8_9page168_flat[] = {
  {"\x28", 0, 0x8063},
  {"\x32", 0, 0x806C},
  {"\x39", 0, 0x8075},
  {"\x3E", 0, 0x807B},
  {"\x3F", 0, 0x8079},
  {"\x47", 0, 0x808A},
  {"\x49", 0, 0x808E},
  {"\x4E", 0, 0x809F},
  {"\x5C", 0, 0x670A},
  {"\x60", 0, 0x80A7},
  {"\x61", 0, 0x80B0},
  {"\x68", 0, 0x80B8},
  {"\x69", 0, 0x80B5},
  {"\x6A", 0, 0x80A6},
  {"\x73", 0, 0x80E0},
  {"\x75", 0, 0x6711},
  {"\x7B", 0, 0x80DF},
  {"\x7D", 0, 0x80C2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page168 = {
  marc8_9page168_flat, 0
};
/* PAGE 167 */
struct yaz_iconv_trie_flat marc8_9page167_flat[] = {
  {"\x29", 0, 0x7FFD},
  {"\x2A", 0, 0x7FFE},
  {"\x2C", 0, 0x7FFF},
  {"\x2E", 0, 0x8004},
  {"\x31", 0, 0x8008},
  {"\x33", 0, 0x800B},
  {"\x34", 0, 0x800E},
  {"\x35", 0, 0x8011},
  {"\x36", 0, 0x800F},
  {"\x37", 0, 0x8014},
  {"\x39", 0, 0x8016},
  {"\x3B", 0, 0x801F},
  {"\x3D", 0, 0x801E},
  {"\x3E", 0, 0x801D},
  {"\x4B", 0, 0x8025},
  {"\x4C", 0, 0x8026},
  {"\x4D", 0, 0x802A},
  {"\x4E", 0, 0x8029},
  {"\x4F", 0, 0x8028},
  {"\x5B", 0, 0x8030},
  {"\x5D", 0, 0x8031},
  {"\x60", 0, 0x8035},
  {"\x69", 0, 0x8039},
  {"\x6B", 0, 0x8041},
  {"\x70", 0, 0x8043},
  {"\x7B", 0, 0x8052},
  {"\x7E", 0, 0x8062},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page167 = {
  marc8_9page167_flat, 0
};
/* PAGE 166 */
struct yaz_iconv_trie_flat marc8_9page166_flat[] = {
  {"\x23", 0, 0x7F97},
  {"\x24", 0, 0x7F95},
  {"\x2C", 0, 0x7FA2},
  {"\x33", 0, 0x7FA7},
  {"\x3B", 0, 0x7FB0},
  {"\x3C", 0, 0x7FAD},
  {"\x3F", 0, 0x7FB1},
  {"\x40", 0, 0x7FB4},
  {"\x42", 0, 0x7FB5},
  {"\x4A", 0, 0x7FBC},
  {"\x4C", 0, 0x7FBE},
  {"\x51", 0, 0x7FC3},
  {"\x57", 0, 0x7FCA},
  {"\x67", 0, 0x7FDB},
  {"\x68", 0, 0x7FE3},
  {"\x6C", 0, 0x7FE6},
  {"\x6F", 0, 0x7FE5},
  {"\x72", 0, 0x7FEC},
  {"\x73", 0, 0x7FEB},
  {"\x77", 0, 0x7FEF},
  {"\x7A", 0, 0x7FEE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page166 = {
  marc8_9page166_flat, 0
};
/* PAGE 165 */
struct yaz_iconv_trie_flat marc8_9page165_flat[] = {
  {"\x25", 0, 0x7F43},
  {"\x27", 0, 0x7F46},
  {"\x28", 0, 0x7F45},
  {"\x2B", 0, 0x7F4B},
  {"\x2E", 0, 0x7F4C},
  {"\x2F", 0, 0x7F4D},
  {"\x31", 0, 0x7F4E},
  {"\x32", 0, 0x7F4F},
  {"\x3E", 0, 0x7F60},
  {"\x3F", 0, 0x7F61},
  {"\x43", 0, 0x7F5D},
  {"\x45", 0, 0x7F5B},
  {"\x47", 0, 0x7F63},
  {"\x50", 0, 0x7F65},
  {"\x51", 0, 0x7F66},
  {"\x53", 0, 0x7F6D},
  {"\x54", 0, 0x7F6B},
  {"\x55", 0, 0x7F67},
  {"\x57", 0, 0x7F68},
  {"\x5E", 0, 0x7F71},
  {"\x60", 0, 0x7F73},
  {"\x63", 0, 0x7F76},
  {"\x6A", 0, 0x7F7F},
  {"\x6B", 0, 0x7F7E},
  {"\x6C", 0, 0x7F7D},
  {"\x72", 0, 0x7F86},
  {"\x7A", 0, 0x7F91},
  {"\x7E", 0, 0x7F96},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page165 = {
  marc8_9page165_flat, 0
};
/* PAGE 164 */
struct yaz_iconv_trie_flat marc8_9page164_flat[] = {
  {"\x21", 0, 0x7E35},
  {"\x26", 0, 0x7E3F},
  {"\x28", 0, 0x7E47},
  {"\x2D", 0, 0x7E52},
  {"\x2F", 0, 0x7E51},
  {"\x33", 0, 0x7E50},
  {"\x34", 0, 0x7E67},
  {"\x37", 0, 0x7E56},
  {"\x48", 0, 0x7E68},
  {"\x49", 0, 0x7E6E},
  {"\x4E", 0, 0x7E70},
  {"\x51", 0, 0x7E6F},
  {"\x52", 0, 0x7E73},
  {"\x58", 0, 0x7E7B},
  {"\x59", 0, 0x7E7E},
  {"\x5B", 0, 0x7E81},
  {"\x5D", 0, 0x7E8A},
  {"\x5E", 0, 0x7E87},
  {"\x60", 0, 0x7E88},
  {"\x64", 0, 0x7E86},
  {"\x6A", 0, 0x7E91},
  {"\x6B", 0, 0x7E95},
  {"\x6D", 0, 0x7E94},
  {"\x70", 0, 0x7E9B},
  {"\x71", 0, 0x7E9A},
  {"\x73", 0, 0x7E99},
  {"\x74", 0, 0x7E98},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page164 = {
  marc8_9page164_flat, 0
};
/* PAGE 163 */
struct yaz_iconv_trie_flat marc8_9page163_flat[] = {
  {"\x22", 0, 0x7D9F},
  {"\x29", 0, 0x7DE1},
  {"\x2A", 0, 0x7DD9},
  {"\x2B", 0, 0x7DE4},
  {"\x31", 0, 0x7DD7},
  {"\x36", 0, 0x7DF9},
  {"\x3A", 0, 0x7E06},
  {"\x3C", 0, 0x7DF2},
  {"\x3E", 0, 0x7DE6},
  {"\x46", 0, 0x7DDC},
  {"\x47", 0, 0x7DF1},
  {"\x48", 0, 0x7DF6},
  {"\x49", 0, 0x7DE5},
  {"\x4B", 0, 0x7DF5},
  {"\x50", 0, 0x7E17},
  {"\x51", 0, 0x7E1E},
  {"\x52", 0, 0x7E21},
  {"\x53", 0, 0x7E0B},
  {"\x55", 0, 0x7E12},
  {"\x56", 0, 0x7E22},
  {"\x5B", 0, 0x7E20},
  {"\x5D", 0, 0x7E1D},
  {"\x5E", 0, 0x7E09},
  {"\x5F", 0, 0x7E1F},
  {"\x65", 0, 0x7E15},
  {"\x69", 0, 0x7E10},
  {"\x6A", 0, 0x7E0F},
  {"\x6D", 0, 0x7E3B},
  {"\x71", 0, 0x7E34},
  {"\x72", 0, 0x7E2D},
  {"\x73", 0, 0x7E2F},
  {"\x75", 0, 0x7E36},
  {"\x77", 0, 0x7E3A},
  {"\x79", 0, 0x7E39},
  {"\x7D", 0, 0x7E44},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page163 = {
  marc8_9page163_flat, 0
};
/* PAGE 162 */
struct yaz_iconv_trie_flat marc8_9page162_flat[] = {
  {"\x22", 0, 0x7D70},
  {"\x29", 0, 0x7D67},
  {"\x2B", 0, 0x7D6A},
  {"\x2C", 0, 0x7D6B},
  {"\x30", 0, 0x7D73},
  {"\x34", 0, 0x7D4E},
  {"\x37", 0, 0x7D8B},
  {"\x39", 0, 0x7D88},
  {"\x3B", 0, 0x7D85},
  {"\x3D", 0, 0x7D8E},
  {"\x42", 0, 0x7D7F},
  {"\x44", 0, 0x7D86},
  {"\x48", 0, 0x7D8D},
  {"\x4B", 0, 0x7D9B},
  {"\x4D", 0, 0x7D83},
  {"\x4F", 0, 0x7D7D},
  {"\x54", 0, 0x7D7B},
  {"\x58", 0, 0x7D7A},
  {"\x59", 0, 0x7D96},
  {"\x5A", 0, 0x7D5B},
  {"\x5B", 0, 0x7D8C},
  {"\x61", 0, 0x7DA3},
  {"\x62", 0, 0x7DAE},
  {"\x67", 0, 0x7DCB},
  {"\x69", 0, 0x7DAA},
  {"\x6A", 0, 0x7DCE},
  {"\x6B", 0, 0x7DC9},
  {"\x6E", 0, 0x7DC5},
  {"\x6F", 0, 0x7DA6},
  {"\x74", 0, 0x7DC4},
  {"\x78", 0, 0x7DAC},
  {"\x7D", 0, 0x7DB9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page162 = {
  marc8_9page162_flat, 0
};
/* PAGE 161 */
struct yaz_iconv_trie_flat marc8_9page161_flat[] = {
  {"\x22", 0, 0x7CDD},
  {"\x28", 0, 0x7CED},
  {"\x2E", 0, 0x7CF0},
  {"\x30", 0, 0x7CF2},
  {"\x35", 0, 0x7CF4},
  {"\x39", 0, 0x7CF6},
  {"\x42", 0, 0x7D06},
  {"\x44", 0, 0x7D03},
  {"\x45", 0, 0x7D08},
  {"\x49", 0, 0x7D0F},
  {"\x4A", 0, 0x7D13},
  {"\x50", 0, 0x7D18},
  {"\x51", 0, 0x7D1E},
  {"\x52", 0, 0x7D1D},
  {"\x59", 0, 0x7D35},
  {"\x5A", 0, 0x7D3D},
  {"\x61", 0, 0x7D3A},
  {"\x62", 0, 0x7D32},
  {"\x65", 0, 0x7D31},
  {"\x68", 0, 0x7D45},
  {"\x6A", 0, 0x7D3F},
  {"\x6C", 0, 0x7D29},
  {"\x6F", 0, 0x7D41},
  {"\x71", 0, 0x7D3E},
  {"\x7A", 0, 0x7D5C},
  {"\x7C", 0, 0x7D53},
  {"\x7E", 0, 0x7D5A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page161 = {
  marc8_9page161_flat, 0
};
/* PAGE 160 */
struct yaz_iconv_trie_flat marc8_9page160_flat[] = {
  {"\x21", 0, 0x7C81},
  {"\x28", 0, 0x7C8E},
  {"\x29", 0, 0x7C91},
  {"\x2A", 0, 0x7C83},
  {"\x2C", 0, 0x7C8D},
  {"\x3A", 0, 0x7C99},
  {"\x3B", 0, 0x7C98},
  {"\x3E", 0, 0x7C9C},
  {"\x40", 0, 0x7C95},
  {"\x42", 0, 0x7CA7},
  {"\x43", 0, 0x7CA2},
  {"\x45", 0, 0x7C9E},
  {"\x46", 0, 0x7CA9},
  {"\x48", 0, 0x7CA8},
  {"\x49", 0, 0x7CA1},
  {"\x4A", 0, 0x7CAC},
  {"\x4C", 0, 0x7CA6},
  {"\x54", 0, 0x7CB2},
  {"\x58", 0, 0x7CBB},
  {"\x59", 0, 0x7CBF},
  {"\x5E", 0, 0x7CBA},
  {"\x5F", 0, 0x7CBC},
  {"\x64", 0, 0x7CC2},
  {"\x66", 0, 0x7CCE},
  {"\x68", 0, 0x7CC8},
  {"\x69", 0, 0x7CC5},
  {"\x6D", 0, 0x7CCC},
  {"\x6F", 0, 0x7CC9},
  {"\x71", 0, 0x7CD2},
  {"\x75", 0, 0x7CD7},
  {"\x77", 0, 0x7CE1},
  {"\x7B", 0, 0xE96D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page160 = {
  marc8_9page160_flat, 0
};
/* PAGE 159 */
struct yaz_iconv_trie_flat marc8_9page159_flat[] = {
  {"\x27", 0, 0x7C35},
  {"\x2A", 0, 0x7C40},
  {"\x30", 0, 0x7C39},
  {"\x34", 0, 0x7C3B},
  {"\x35", 0, 0x7C34},
  {"\x3B", 0, 0x7C42},
  {"\x46", 0, 0x7C4E},
  {"\x54", 0, 0x7C5D},
  {"\x56", 0, 0x7C5C},
  {"\x57", 0, 0x7C5A},
  {"\x58", 0, 0x7C5B},
  {"\x59", 0, 0x7C59},
  {"\x5B", 0, 0x7C5E},
  {"\x5C", 0, 0x7C67},
  {"\x5E", 0, 0x7C63},
  {"\x61", 0, 0x7C68},
  {"\x62", 0, 0x7C65},
  {"\x6F", 0, 0x7C6F},
  {"\x75", 0, 0x7C75},
  {"\x79", 0, 0x7C7E},
  {"\x7A", 0, 0x7C78},
  {"\x7D", 0, 0x7C7D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page159 = {
  marc8_9page159_flat, 0
};
/* PAGE 158 */
struct yaz_iconv_trie_flat marc8_9page158_flat[] = {
  {"\x22", 0, 0x7BDD},
  {"\x24", 0, 0x7BE5},
  {"\x29", 0, 0x7BE8},
  {"\x2E", 0, 0x7BF9},
  {"\x2F", 0, 0x7BD4},
  {"\x32", 0, 0x7BDF},
  {"\x35", 0, 0x7BD8},
  {"\x37", 0, 0xE9D1},
  {"\x3B", 0, 0x7C06},
  {"\x3E", 0, 0x7BF0},
  {"\x41", 0, 0x7C0F},
  {"\x46", 0, 0x7C0B},
  {"\x47", 0, 0x7C00},
  {"\x4B", 0, 0x7C0C},
  {"\x4F", 0, 0x7BF4},
  {"\x54", 0, 0x7BF3},
  {"\x5A", 0, 0x7C09},
  {"\x5B", 0, 0x7C03},
  {"\x5C", 0, 0x7BFC},
  {"\x5F", 0, 0x7C1C},
  {"\x61", 0, 0x7C26},
  {"\x62", 0, 0x7C28},
  {"\x63", 0, 0x7C20},
  {"\x66", 0, 0x7C1F},
  {"\x68", 0, 0x7C2F},
  {"\x75", 0, 0x7C30},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page158 = {
  marc8_9page158_flat, 0
};
/* PAGE 157 */
struct yaz_iconv_trie_flat marc8_9page157_flat[] = {
  {"\x26", 0, 0x7B71},
  {"\x27", 0, 0x7B70},
  {"\x29", 0, 0x7B73},
  {"\x2D", 0, 0x7B9C},
  {"\x33", 0, 0x7B92},
  {"\x34", 0, 0x7B91},
  {"\x35", 0, 0x7B90},
  {"\x38", 0, 0x7BA3},
  {"\x3A", 0, 0x7B8D},
  {"\x41", 0, 0x7B85},
  {"\x43", 0, 0x7B8E},
  {"\x44", 0, 0x7B98},
  {"\x46", 0, 0x7B86},
  {"\x48", 0, 0x7B99},
  {"\x52", 0, 0x7BB2},
  {"\x58", 0, 0x7BCB},
  {"\x59", 0, 0x7BB8},
  {"\x5A", 0, 0x7BCF},
  {"\x5C", 0, 0x7BD0},
  {"\x60", 0, 0x7BBE},
  {"\x6F", 0, 0x7BCC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page157 = {
  marc8_9page157_flat, 0
};
/* PAGE 156 */
struct yaz_iconv_trie_flat marc8_9page156_flat[] = {
  {"\x27", 0, 0x7B39},
  {"\x2D", 0, 0x7B0F},
  {"\x2E", 0, 0x7B08},
  {"\x33", 0, 0x7B0A},
  {"\x35", 0, 0x7B35},
  {"\x36", 0, 0x7B25},
  {"\x39", 0, 0x7B38},
  {"\x3B", 0, 0x7B3B},
  {"\x3F", 0, 0x7B24},
  {"\x40", 0, 0x7B33},
  {"\x42", 0, 0x7B2A},
  {"\x44", 0, 0x7B18},
  {"\x47", 0, 0x7B31},
  {"\x4A", 0, 0x7B2B},
  {"\x4B", 0, 0x7B37},
  {"\x4D", 0, 0x7B1F},
  {"\x52", 0, 0x7B4A},
  {"\x53", 0, 0xE9ED},
  {"\x54", 0, 0xE96C},
  {"\x55", 0, 0x7B47},
  {"\x59", 0, 0x7B58},
  {"\x5B", 0, 0x7B6C},
  {"\x60", 0, 0x7B48},
  {"\x61", 0, 0x7B45},
  {"\x62", 0, 0x7B4C},
  {"\x63", 0, 0x7B4E},
  {"\x68", 0, 0x7B66},
  {"\x6C", 0, 0x7B64},
  {"\x6E", 0, 0x7B69},
  {"\x70", 0, 0x7B6D},
  {"\x74", 0, 0x7B62},
  {"\x75", 0, 0x7B6E},
  {"\x76", 0, 0x7B74},
  {"\x79", 0, 0x7B72},
  {"\x7A", 0, 0x7B78},
  {"\x7B", 0, 0x7B6F},
  {"\x7C", 0, 0x7B67},
  {"\x7E", 0, 0x7B65},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page156 = {
  marc8_9page156_flat, 0
};
/* PAGE 155 */
struct yaz_iconv_trie_flat marc8_9page155_flat[] = {
  {"\x28", 0, 0x7AA3},
  {"\x2B", 0, 0x7A9E},
  {"\x2C", 0, 0x7AA7},
  {"\x2E", 0, 0x7AA8},
  {"\x31", 0, 0x7AAC},
  {"\x36", 0, 0x7AB3},
  {"\x3A", 0, 0x7ABD},
  {"\x3C", 0, 0x7AB6},
  {"\x3D", 0, 0x7AB8},
  {"\x3E", 0, 0x7AB5},
  {"\x3F", 0, 0x7ABB},
  {"\x43", 0, 0x7ABF},
  {"\x49", 0, 0x7ACD},
  {"\x4B", 0, 0x7ACF},
  {"\x4F", 0, 0x7AD1},
  {"\x51", 0, 0x7AD3},
  {"\x52", 0, 0x7AD4},
  {"\x54", 0, 0x7AD5},
  {"\x55", 0, 0x7ADA},
  {"\x5A", 0, 0x7AE1},
  {"\x5E", 0, 0x7AE6},
  {"\x66", 0, 0x7AEB},
  {"\x6B", 0, 0x7AF0},
  {"\x76", 0, 0x7AF5},
  {"\x7C", 0, 0x7AFE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page155 = {
  marc8_9page155_flat, 0
};
/* PAGE 154 */
struct yaz_iconv_trie_flat marc8_9page154_flat[] = {
  {"\x22", 0, 0x7A2C},
  {"\x39", 0, 0x7A48},
  {"\x3D", 0, 0x7A4B},
  {"\x3E", 0, 0x7A47},
  {"\x3F", 0, 0x7A44},
  {"\x40", 0, 0x7A5C},
  {"\x4D", 0, 0x7A5F},
  {"\x4F", 0, 0x7A60},
  {"\x57", 0, 0x7A6E},
  {"\x5F", 0, 0x7A70},
  {"\x66", 0, 0x7A75},
  {"\x69", 0, 0x7A78},
  {"\x6B", 0, 0x7A80},
  {"\x70", 0, 0x7A85},
  {"\x75", 0, 0x7A86},
  {"\x78", 0, 0x7A8A},
  {"\x7A", 0, 0x7A94},
  {"\x7E", 0, 0x68A5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page154 = {
  marc8_9page154_flat, 0
};
/* PAGE 153 */
struct yaz_iconv_trie_flat marc8_9page153_flat[] = {
  {"\x22", 0, 0x79B8},
  {"\x23", 0, 0x79BA},
  {"\x25", 0, 0x79BC},
  {"\x28", 0, 0x79C6},
  {"\x2A", 0, 0x79C8},
  {"\x2D", 0, 0x79D4},
  {"\x2E", 0, 0x79D5},
  {"\x32", 0, 0x79D6},
  {"\x3D", 0, 0x79EC},
  {"\x3E", 0, 0xE96A},
  {"\x42", 0, 0x79E1},
  {"\x44", 0, 0x79DD},
  {"\x45", 0, 0x79ED},
  {"\x48", 0, 0x79F8},
  {"\x4F", 0, 0x7A02},
  {"\x50", 0, 0x7A0A},
  {"\x54", 0, 0x7A09},
  {"\x5C", 0, 0x7A03},
  {"\x61", 0, 0x7A0C},
  {"\x6B", 0, 0x7A11},
  {"\x6C", 0, 0x7A18},
  {"\x6F", 0, 0xE96B},
  {"\x71", 0, 0x7A1E},
  {"\x76", 0, 0x7A17},
  {"\x7E", 0, 0x7A2D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page153 = {
  marc8_9page153_flat, 0
};
/* PAGE 152 */
struct yaz_iconv_trie_flat marc8_9page152_flat[] = {
  {"\x21", 0, 0x7951},
  {"\x23", 0, 0x7954},
  {"\x2A", 0, 0x7967},
  {"\x2D", 0, 0x796B},
  {"\x30", 0, 0x7972},
  {"\x3E", 0, 0x797C},
  {"\x4A", 0, 0x7998},
  {"\x4B", 0, 0x798A},
  {"\x4D", 0, 0x7999},
  {"\x4E", 0, 0x7995},
  {"\x4F", 0, 0x798B},
  {"\x50", 0, 0x7996},
  {"\x54", 0, 0x7994},
  {"\x55", 0, 0x7993},
  {"\x5C", 0, 0x799A},
  {"\x5F", 0, 0x79A1},
  {"\x60", 0, 0x799B},
  {"\x61", 0, 0x79A3},
  {"\x64", 0, 0x799D},
  {"\x6E", 0, 0x79A9},
  {"\x70", 0, 0x79AB},
  {"\x71", 0, 0x79A8},
  {"\x75", 0, 0x79B0},
  {"\x7A", 0, 0x79B3},
  {"\x7B", 0, 0x79B4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page152 = {
  marc8_9page152_flat, 0
};
/* PAGE 151 */
struct yaz_iconv_trie_flat marc8_9page151_flat[] = {
  {"\x21", 0, 0x78F9},
  {"\x22", 0, 0x78FD},
  {"\x27", 0, 0x78FE},
  {"\x29", 0, 0x78FB},
  {"\x2B", 0, 0x7904},
  {"\x2E", 0, 0x7912},
  {"\x32", 0, 0x790C},
  {"\x34", 0, 0x7913},
  {"\x35", 0, 0x7911},
  {"\x43", 0, 0x791E},
  {"\x46", 0, 0x7922},
  {"\x4C", 0, 0x7924},
  {"\x4D", 0, 0x7927},
  {"\x50", 0, 0x7929},
  {"\x55", 0, 0x7931},
  {"\x5D", 0, 0x7934},
  {"\x60", 0, 0x7936},
  {"\x65", 0, 0x793D},
  {"\x67", 0, 0x7942},
  {"\x68", 0, 0x793F},
  {"\x6A", 0, 0x794A},
  {"\x6B", 0, 0x794D},
  {"\x75", 0, 0x7946},
  {"\x77", 0, 0x7958},
  {"\x79", 0, 0x795B},
  {"\x7A", 0, 0x795C},
  {"\x7B", 0, 0x794F},
  {"\x7C", 0, 0x7953},
  {"\x7D", 0, 0xE9D0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page151 = {
  marc8_9page151_flat, 0
};
/* PAGE 150 */
struct yaz_iconv_trie_flat marc8_9page150_flat[] = {
  {"\x29", 0, 0x7893},
  {"\x2C", 0, 0x7892},
  {"\x2D", 0, 0x7896},
  {"\x2F", 0, 0x78B2},
  {"\x31", 0, 0x78A1},
  {"\x32", 0, 0x78B6},
  {"\x39", 0, 0x78B7},
  {"\x3B", 0, 0x78A4},
  {"\x3E", 0, 0x78B4},
  {"\x40", 0, 0x78AD},
  {"\x41", 0, 0x78A3},
  {"\x43", 0, 0x789E},
  {"\x44", 0, 0x78A8},
  {"\x48", 0, 0x78AB},
  {"\x4E", 0, 0x78BB},
  {"\x55", 0, 0x78CC},
  {"\x56", 0, 0x78C9},
  {"\x58", 0, 0x78D1},
  {"\x5A", 0, 0x78D8},
  {"\x5E", 0, 0x78C8},
  {"\x60", 0, 0x78D4},
  {"\x68", 0, 0x78DF},
  {"\x6A", 0, 0x78E7},
  {"\x6E", 0, 0x78DB},
  {"\x6F", 0, 0x78E1},
  {"\x73", 0, 0x78E0},
  {"\x76", 0, 0x78EE},
  {"\x77", 0, 0x78E3},
  {"\x79", 0, 0x78F2},
  {"\x7E", 0, 0x7905},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page150 = {
  marc8_9page150_flat, 0
};
/* PAGE 149 */
struct yaz_iconv_trie_flat marc8_9page149_flat[] = {
  {"\x24", 0, 0x781B},
  {"\x26", 0, 0x782C},
  {"\x27", 0, 0x7823},
  {"\x28", 0, 0x782B},
  {"\x2A", 0, 0x7829},
  {"\x2D", 0, 0x7822},
  {"\x31", 0, 0x7835},
  {"\x32", 0, 0x7833},
  {"\x33", 0, 0x782E},
  {"\x35", 0, 0x7820},
  {"\x38", 0, 0x783D},
  {"\x3B", 0, 0x781F},
  {"\x3D", 0, 0x7831},
  {"\x44", 0, 0x784D},
  {"\x48", 0, 0x7848},
  {"\x49", 0, 0x7853},
  {"\x4A", 0, 0x7854},
  {"\x4B", 0, 0x7845},
  {"\x4C", 0, 0x7852},
  {"\x4E", 0, 0x7850},
  {"\x4F", 0, 0x7858},
  {"\x50", 0, 0x7826},
  {"\x52", 0, 0x7847},
  {"\x56", 0, 0x784C},
  {"\x5A", 0, 0x7868},
  {"\x5B", 0, 0x786D},
  {"\x60", 0, 0x7864},
  {"\x61", 0, 0x785C},
  {"\x64", 0, 0x7876},
  {"\x66", 0, 0x786A},
  {"\x69", 0, 0x7886},
  {"\x6B", 0, 0x789A},
  {"\x6C", 0, 0x787F},
  {"\x6D", 0, 0x7887},
  {"\x70", 0, 0x7894},
  {"\x76", 0, 0x788F},
  {"\x7E", 0, 0x7899},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page149 = {
  marc8_9page149_flat, 0
};
/* PAGE 148 */
struct yaz_iconv_trie_flat marc8_9page148_flat[] = {
  {"\x23", 0, 0x77B6},
  {"\x29", 0, 0x77BE},
  {"\x2B", 0, 0x77B9},
  {"\x2C", 0, 0x77BC},
  {"\x35", 0, 0x77CD},
  {"\x3A", 0, 0x77D1},
  {"\x45", 0, 0x77DE},
  {"\x46", 0, 0x77DF},
  {"\x4F", 0, 0x77E7},
  {"\x52", 0, 0x77E6},
  {"\x55", 0, 0x77EC},
  {"\x59", 0, 0x77F0},
  {"\x5A", 0, 0x77F1},
  {"\x5C", 0, 0x77F4},
  {"\x60", 0, 0x77FC},
  {"\x67", 0, 0x77F8},
  {"\x68", 0, 0x77FB},
  {"\x70", 0, 0x7809},
  {"\x71", 0, 0x7806},
  {"\x73", 0, 0x7819},
  {"\x74", 0, 0x7811},
  {"\x78", 0, 0x7812},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page148 = {
  marc8_9page148_flat, 0
};
/* PAGE 147 */
struct yaz_iconv_trie_flat marc8_9page147_flat[] = {
  {"\x22", 0, 0x7725},
  {"\x25", 0, 0x7735},
  {"\x26", 0, 0x7734},
  {"\x2D", 0, 0x7747},
  {"\x31", 0, 0x7745},
  {"\x32", 0, 0x774D},
  {"\x33", 0, 0x774A},
  {"\x35", 0, 0x7743},
  {"\x37", 0, 0x774E},
  {"\x3A", 0, 0x775F},
  {"\x3D", 0, 0x7760},
  {"\x3E", 0, 0x7752},
  {"\x42", 0, 0x7758},
  {"\x44", 0, 0x7756},
  {"\x45", 0, 0x775A},
  {"\x4F", 0, 0x7762},
  {"\x52", 0, 0x7780},
  {"\x56", 0, 0x776F},
  {"\x5D", 0, 0x777E},
  {"\x5F", 0, 0x7785},
  {"\x60", 0, 0x777A},
  {"\x66", 0, 0xE969},
  {"\x6A", 0, 0x778D},
  {"\x72", 0, 0x7798},
  {"\x73", 0, 0x7796},
  {"\x75", 0, 0x77A2},
  {"\x76", 0, 0x7799},
  {"\x7A", 0, 0x77B5},
  {"\x7D", 0, 0x77B7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page147 = {
  marc8_9page147_flat, 0
};
/* PAGE 146 */
struct yaz_iconv_trie_flat marc8_9page146_flat[] = {
  {"\x23", 0, 0x76CB},
  {"\x26", 0, 0x76CC},
  {"\x3B", 0, 0x76E6},
  {"\x3C", 0, 0x76E9},
  {"\x40", 0, 0x76EC},
  {"\x44", 0, 0x76ED},
  {"\x48", 0, 0x76F1},
  {"\x4B", 0, 0x7704},
  {"\x4F", 0, 0x7708},
  {"\x50", 0, 0x7707},
  {"\x53", 0, 0x76F7},
  {"\x54", 0, 0x770A},
  {"\x59", 0, 0x76FB},
  {"\x5E", 0, 0x772B},
  {"\x60", 0, 0x770E},
  {"\x62", 0, 0x771B},
  {"\x63", 0, 0x7724},
  {"\x6C", 0, 0x7722},
  {"\x6D", 0, 0x771A},
  {"\x6F", 0, 0x7721},
  {"\x74", 0, 0x7740},
  {"\x75", 0, 0x7739},
  {"\x76", 0, 0x772F},
  {"\x77", 0, 0x7731},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page146 = {
  marc8_9page146_flat, 0
};
/* PAGE 145 */
struct yaz_iconv_trie_flat marc8_9page145_flat[] = {
  {"\x22", 0, 0x7664},
  {"\x24", 0, 0x7659},
  {"\x2B", 0, 0x765F},
  {"\x32", 0, 0x7667},
  {"\x35", 0, 0x766A},
  {"\x37", 0, 0x766D},
  {"\x38", 0, 0x766F},
  {"\x3A", 0, 0x7670},
  {"\x40", 0, 0x7676},
  {"\x41", 0, 0x7677},
  {"\x48", 0, 0x7680},
  {"\x4A", 0, 0x768B},
  {"\x52", 0, 0x7695},
  {"\x55", 0, 0x656B},
  {"\x59", 0, 0x7699},
  {"\x5D", 0, 0x769C},
  {"\x5F", 0, 0x769D},
  {"\x65", 0, 0x76A4},
  {"\x66", 0, 0x76A5},
  {"\x67", 0, 0x76A6},
  {"\x6A", 0, 0x76AA},
  {"\x6D", 0, 0x76AD},
  {"\x74", 0, 0x76B8},
  {"\x77", 0, 0x76BD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page145 = {
  marc8_9page145_flat, 0
};
/* PAGE 144 */
struct yaz_iconv_trie_flat marc8_9page144_flat[] = {
  {"\x21", 0, 0x75F9},
  {"\x22", 0, 0x75FC},
  {"\x29", 0, 0x7616},
  {"\x2C", 0, 0x7608},
  {"\x2D", 0, 0x7615},
  {"\x2E", 0, 0x760C},
  {"\x2F", 0, 0x760F},
  {"\x3B", 0, 0x7610},
  {"\x3C", 0, 0x760A},
  {"\x3E", 0, 0x7625},
  {"\x3F", 0, 0x761A},
  {"\x40", 0, 0x761B},
  {"\x47", 0, 0x7619},
  {"\x48", 0, 0x761E},
  {"\x4C", 0, 0x761D},
  {"\x50", 0, 0x7622},
  {"\x51", 0, 0x762F},
  {"\x54", 0, 0x762D},
  {"\x5C", 0, 0x7633},
  {"\x5E", 0, 0x763B},
  {"\x5F", 0, 0x7630},
  {"\x60", 0, 0x763C},
  {"\x62", 0, 0x7635},
  {"\x67", 0, 0x7648},
  {"\x68", 0, 0x764E},
  {"\x69", 0, 0x7647},
  {"\x6A", 0, 0x7643},
  {"\x6E", 0, 0x764D},
  {"\x6F", 0, 0x7649},
  {"\x75", 0, 0x7654},
  {"\x7A", 0, 0x765C},
  {"\x7B", 0, 0x7657},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page144 = {
  marc8_9page144_flat, 0
};
/* PAGE 143 */
struct yaz_iconv_trie_flat marc8_9page143_flat[] = {
  {"\x25", 0, 0x7583},
  {"\x2C", 0, 0x7590},
  {"\x2D", 0, 0x7592},
  {"\x2E", 0, 0x7594},
  {"\x31", 0, 0x7595},
  {"\x35", 0, 0x7598},
  {"\x37", 0, 0x75A2},
  {"\x3B", 0, 0x75A3},
  {"\x3E", 0, 0x75BA},
  {"\x43", 0, 0x75B0},
  {"\x44", 0, 0x75C3},
  {"\x46", 0, 0x75BF},
  {"\x47", 0, 0x75B4},
  {"\x4A", 0, 0x75C2},
  {"\x4E", 0, 0x75C1},
  {"\x50", 0, 0x75B1},
  {"\x51", 0, 0x75C4},
  {"\x58", 0, 0x75CD},
  {"\x5C", 0, 0x75CF},
  {"\x5E", 0, 0x75CC},
  {"\x5F", 0, 0x75D0},
  {"\x63", 0, 0x75E7},
  {"\x66", 0, 0x75E1},
  {"\x67", 0, 0x75E6},
  {"\x71", 0, 0x75E4},
  {"\x72", 0, 0x75E0},
  {"\x73", 0, 0x75D7},
  {"\x7A", 0, 0x7602},
  {"\x7E", 0, 0x7603},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page143 = {
  marc8_9page143_flat, 0
};
/* PAGE 142 */
struct yaz_iconv_trie_flat marc8_9page142_flat[] = {
  {"\x25", 0, 0x750E},
  {"\x28", 0, 0x750D},
  {"\x2C", 0, 0x7511},
  {"\x2D", 0, 0x750F},
  {"\x32", 0, 0x7512},
  {"\x33", 0, 0x7513},
  {"\x39", 0, 0x7517},
  {"\x42", 0, 0x7521},
  {"\x44", 0, 0x7524},
  {"\x49", 0, 0x752F},
  {"\x4D", 0, 0x753A},
  {"\x4F", 0, 0x753F},
  {"\x51", 0, 0x7540},
  {"\x52", 0, 0x753E},
  {"\x55", 0, 0x754A},
  {"\x57", 0, 0x754E},
  {"\x58", 0, 0x7547},
  {"\x59", 0, 0x754B},
  {"\x5A", 0, 0x7548},
  {"\x5F", 0, 0x755F},
  {"\x60", 0, 0x755B},
  {"\x62", 0, 0x7564},
  {"\x67", 0, 0x7563},
  {"\x69", 0, 0x756F},
  {"\x6B", 0, 0x756C},
  {"\x6D", 0, 0x7579},
  {"\x6E", 0, 0x757A},
  {"\x71", 0, 0x7577},
  {"\x75", 0, 0x7571},
  {"\x79", 0, 0x757D},
  {"\x7E", 0, 0x757F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page142 = {
  marc8_9page142_flat, 0
};
/* PAGE 141 */
struct yaz_iconv_trie_flat marc8_9page141_flat[] = {
  {"\x25", 0, 0x74BF},
  {"\x28", 0, 0x74B5},
  {"\x29", 0, 0x74BA},
  {"\x30", 0, 0x74C8},
  {"\x31", 0, 0x74C5},
  {"\x32", 0, 0x74CC},
  {"\x38", 0, 0x74D6},
  {"\x3A", 0, 0x74D4},
  {"\x3D", 0, 0x74D8},
  {"\x40", 0, 0x74DA},
  {"\x41", 0, 0x74DB},
  {"\x47", 0, 0x74DE},
  {"\x50", 0, 0x74E4},
  {"\x52", 0, 0x74E7},
  {"\x54", 0, 0x74E9},
  {"\x58", 0, 0x74F1},
  {"\x5A", 0, 0x74F0},
  {"\x5C", 0, 0x74EE},
  {"\x61", 0, 0x74F4},
  {"\x63", 0, 0x74F8},
  {"\x66", 0, 0x74FB},
  {"\x67", 0, 0x74FF},
  {"\x71", 0, 0x7505},
  {"\x77", 0, 0x7503},
  {"\x7D", 0, 0x7507},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page141 = {
  marc8_9page141_flat, 0
};
/* PAGE 140 */
struct yaz_iconv_trie_flat marc8_9page140_flat[] = {
  {"\x21", 0, 0x7489},
  {"\x22", 0, 0x747C},
  {"\x27", 0, 0x7482},
  {"\x28", 0, 0x747E},
  {"\x2A", 0, 0x748A},
  {"\x2D", 0, 0x7486},
  {"\x30", 0, 0x747A},
  {"\x38", 0, 0x7480},
  {"\x3C", 0, 0x7481},
  {"\x3E", 0, 0x747D},
  {"\x3F", 0, 0x7485},
  {"\x40", 0, 0x7497},
  {"\x43", 0, 0x7498},
  {"\x45", 0, 0x749A},
  {"\x4D", 0, 0x74A4},
  {"\x54", 0, 0x749F},
  {"\x55", 0, 0x749D},
  {"\x56", 0, 0x748D},
  {"\x57", 0, 0x749E},
  {"\x59", 0, 0x74A0},
  {"\x5D", 0, 0x74A1},
  {"\x60", 0, 0x74B2},
  {"\x61", 0, 0x74B1},
  {"\x66", 0, 0x74B4},
  {"\x67", 0, 0x74AB},
  {"\x69", 0, 0x74AA},
  {"\x6A", 0, 0x7490},
  {"\x6C", 0, 0x74A5},
  {"\x6E", 0, 0x74A8},
  {"\x76", 0, 0x74B8},
  {"\x7A", 0, 0x74C0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page140 = {
  marc8_9page140_flat, 0
};
/* PAGE 139 */
struct yaz_iconv_trie_flat marc8_9page139_flat[] = {
  {"\x21", 0, 0x7428},
  {"\x23", 0, 0x7429},
  {"\x28", 0, 0x7420},
  {"\x2A", 0, 0x741B},
  {"\x2B", 0, 0x7424},
  {"\x2C", 0, 0x7432},
  {"\x2D", 0, 0x742D},
  {"\x30", 0, 0x7415},
  {"\x32", 0, 0x743B},
  {"\x36", 0, 0x7444},
  {"\x40", 0, 0x7447},
  {"\x43", 0, 0x7458},
  {"\x45", 0, 0x7442},
  {"\x47", 0, 0x744B},
  {"\x4A", 0, 0x744A},
  {"\x4F", 0, 0x7452},
  {"\x55", 0, 0x7457},
  {"\x56", 0, 0x7451},
  {"\x5A", 0, 0x745D},
  {"\x5B", 0, 0x7454},
  {"\x5D", 0, 0x7440},
  {"\x60", 0, 0x746D},
  {"\x61", 0, 0x7462},
  {"\x62", 0, 0x7473},
  {"\x68", 0, 0x7474},
  {"\x69", 0, 0x746E},
  {"\x6A", 0, 0x7471},
  {"\x6B", 0, 0x7468},
  {"\x78", 0, 0x7460},
  {"\x79", 0, 0x7472},
  {"\x7A", 0, 0x7484},
  {"\x7B", 0, 0x7487},
  {"\x7E", 0, 0x7488},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page139 = {
  marc8_9page139_flat, 0
};
/* PAGE 138 */
struct yaz_iconv_trie_flat marc8_9page138_flat[] = {
  {"\x21", 0, 0x73D3},
  {"\x27", 0, 0x73EA},
  {"\x28", 0, 0x73E5},
  {"\x2A", 0, 0x73D9},
  {"\x2B", 0, 0x73EF},
  {"\x2F", 0, 0x73D4},
  {"\x30", 0, 0x73DB},
  {"\x32", 0, 0x73D6},
  {"\x35", 0, 0x73BC},
  {"\x36", 0, 0x73E7},
  {"\x38", 0, 0x73E3},
  {"\x3A", 0, 0x73DE},
  {"\x3C", 0, 0x73E6},
  {"\x3F", 0, 0x73E9},
  {"\x45", 0, 0x73F6},
  {"\x47", 0, 0x73FA},
  {"\x4A", 0, 0x73F8},
  {"\x54", 0, 0x73F5},
  {"\x5A", 0, 0x73FD},
  {"\x5C", 0, 0x7407},
  {"\x5E", 0, 0x7412},
  {"\x63", 0, 0x743C},
  {"\x66", 0, 0x742E},
  {"\x67", 0, 0x742F},
  {"\x69", 0, 0x7414},
  {"\x6A", 0, 0x742C},
  {"\x6C", 0, 0x7430},
  {"\x6E", 0, 0x742B},
  {"\x70", 0, 0x73F7},
  {"\x71", 0, 0x741A},
  {"\x78", 0, 0x7416},
  {"\x7A", 0, 0x7426},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page138 = {
  marc8_9page138_flat, 0
};
/* PAGE 137 */
struct yaz_iconv_trie_flat marc8_9page137_flat[] = {
  {"\x21", 0, 0x734B},
  {"\x25", 0, 0x7367},
  {"\x29", 0, 0x736C},
  {"\x2B", 0, 0x736B},
  {"\x2F", 0, 0x736F},
  {"\x36", 0, 0x737C},
  {"\x38", 0, 0x737E},
  {"\x3B", 0, 0x7381},
  {"\x3F", 0, 0x7388},
  {"\x42", 0, 0x738E},
  {"\x46", 0, 0x7395},
  {"\x47", 0, 0x7392},
  {"\x48", 0, 0x7397},
  {"\x4C", 0, 0x7393},
  {"\x4D", 0, 0x7394},
  {"\x51", 0, 0x739E},
  {"\x52", 0, 0x73A6},
  {"\x5D", 0, 0x73A5},
  {"\x62", 0, 0x73A2},
  {"\x63", 0, 0x73A0},
  {"\x67", 0, 0x73B6},
  {"\x68", 0, 0x73CF},
  {"\x6A", 0, 0x73C2},
  {"\x6B", 0, 0x73D0},
  {"\x6F", 0, 0x73BF},
  {"\x70", 0, 0x73C8},
  {"\x7D", 0, 0x73CC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page137 = {
  marc8_9page137_flat, 0
};
/* PAGE 136 */
struct yaz_iconv_trie_flat marc8_9page136_flat[] = {
  {"\x24", 0, 0x72F4},
  {"\x25", 0, 0x72FE},
  {"\x29", 0, 0x7302},
  {"\x2C", 0, 0x72FB},
  {"\x2D", 0, 0x7301},
  {"\x2E", 0, 0x72F3},
  {"\x31", 0, 0x731D},
  {"\x35", 0, 0x730B},
  {"\x36", 0, 0x7317},
  {"\x3B", 0, 0x7307},
  {"\x3E", 0, 0x7318},
  {"\x42", 0, 0x731E},
  {"\x46", 0, 0x7331},
  {"\x49", 0, 0x7338},
  {"\x4A", 0, 0x7322},
  {"\x4C", 0, 0x7332},
  {"\x4D", 0, 0x732C},
  {"\x4E", 0, 0x7327},
  {"\x4F", 0, 0x732B},
  {"\x52", 0, 0x732F},
  {"\x55", 0, 0x7328},
  {"\x5A", 0, 0x7347},
  {"\x5B", 0, 0x7348},
  {"\x5C", 0, 0x7349},
  {"\x5F", 0, 0x733B},
  {"\x62", 0, 0x733A},
  {"\x65", 0, 0x7340},
  {"\x68", 0, 0x734D},
  {"\x6B", 0, 0x7352},
  {"\x72", 0, 0x735E},
  {"\x74", 0, 0x735D},
  {"\x79", 0, 0x7360},
  {"\x7B", 0, 0x7358},
  {"\x7E", 0, 0x7362},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page136 = {
  marc8_9page136_flat, 0
};
/* PAGE 135 */
struct yaz_iconv_trie_flat marc8_9page135_flat[] = {
  {"\x22", 0, 0x728D},
  {"\x28", 0, 0x728F},
  {"\x48", 0, 0x72A8},
  {"\x4C", 0, 0x72AB},
  {"\x4E", 0, 0x72B0},
  {"\x4F", 0, 0x72B4},
  {"\x51", 0, 0x72C6},
  {"\x52", 0, 0x72B5},
  {"\x56", 0, 0x72BC},
  {"\x58", 0, 0x72C3},
  {"\x5B", 0, 0x72C1},
  {"\x60", 0, 0x72D6},
  {"\x64", 0, 0x72D2},
  {"\x67", 0, 0x72C9},
  {"\x6C", 0, 0x72CC},
  {"\x6E", 0, 0x72DB},
  {"\x6F", 0, 0x72CD},
  {"\x73", 0, 0x72E8},
  {"\x76", 0, 0x72EB},
  {"\x79", 0, 0x72E5},
  {"\x7E", 0, 0x72FA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page135 = {
  marc8_9page135_flat, 0
};
/* PAGE 134 */
struct yaz_iconv_trie_flat marc8_9page134_flat[] = {
  {"\x21", 0, 0x721D},
  {"\x29", 0, 0x7225},
  {"\x2A", 0, 0x7226},
  {"\x41", 0, 0x723F},
  {"\x43", 0, 0x7241},
  {"\x44", 0, 0x7242},
  {"\x4F", 0, 0x7250},
  {"\x51", 0, 0x724F},
  {"\x52", 0, 0x7253},
  {"\x53", 0, 0x7255},
  {"\x56", 0, 0x725A},
  {"\x59", 0, 0x7263},
  {"\x61", 0, 0x7273},
  {"\x63", 0, 0x726E},
  {"\x66", 0, 0x7276},
  {"\x68", 0, 0x7277},
  {"\x6B", 0, 0x727E},
  {"\x6D", 0, 0x727C},
  {"\x71", 0, 0x727F},
  {"\x74", 0, 0x7289},
  {"\x7C", 0, 0x728B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page134 = {
  marc8_9page134_flat, 0
};
/* PAGE 133 */
struct yaz_iconv_trie_flat marc8_9page133_flat[] = {
  {"\x21", 0, 0x71DD},
  {"\x22", 0, 0x71C0},
  {"\x24", 0, 0x71C1},
  {"\x26", 0, 0x71D4},
  {"\x29", 0, 0x71CB},
  {"\x2A", 0, 0x71DE},
  {"\x32", 0, 0x71EB},
  {"\x36", 0, 0x71E8},
  {"\x3A", 0, 0x71F5},
  {"\x3D", 0, 0x71F3},
  {"\x3F", 0, 0x71E1},
  {"\x47", 0, 0x71E0},
  {"\x4B", 0, 0x720C},
  {"\x4F", 0, 0x71FC},
  {"\x56", 0, 0x71F9},
  {"\x5B", 0, 0x720E},
  {"\x5C", 0, 0x5911},
  {"\x5E", 0, 0x720A},
  {"\x60", 0, 0x7217},
  {"\x61", 0, 0x7207},
  {"\x66", 0, 0x7215},
  {"\x69", 0, 0x7213},
  {"\x6E", 0, 0x7218},
  {"\x71", 0, 0x720B},
  {"\x79", 0, 0x721A},
  {"\x7D", 0, 0x721F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page133 = {
  marc8_9page133_flat, 0
};
/* PAGE 132 */
struct yaz_iconv_trie_flat marc8_9page132_flat[] = {
  {"\x23", 0, 0x7192},
  {"\x2B", 0, 0x7180},
  {"\x2C", 0, 0x7189},
  {"\x32", 0, 0x7185},
  {"\x33", 0, 0x7196},
  {"\x36", 0, 0x717C},
  {"\x39", 0, 0x7198},
  {"\x3C", 0, 0x7197},
  {"\x3E", 0, 0x71B5},
  {"\x3F", 0, 0x71A9},
  {"\x42", 0, 0x71A5},
  {"\x46", 0, 0x719E},
  {"\x47", 0, 0x71B2},
  {"\x4A", 0, 0x719B},
  {"\x4E", 0, 0x71AF},
  {"\x51", 0, 0x71A4},
  {"\x52", 0, 0x71A0},
  {"\x55", 0, 0x719A},
  {"\x57", 0, 0x71B3},
  {"\x59", 0, 0x71B4},
  {"\x67", 0, 0x71D1},
  {"\x69", 0, 0x71C7},
  {"\x6A", 0, 0x71B7},
  {"\x6D", 0, 0x71CA},
  {"\x6F", 0, 0x71CF},
  {"\x70", 0, 0x71D6},
  {"\x72", 0, 0x71BA},
  {"\x75", 0, 0x71C2},
  {"\x77", 0, 0x71C5},
  {"\x7A", 0, 0x71BF},
  {"\x7C", 0, 0x71B8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page132 = {
  marc8_9page132_flat, 0
};
/* PAGE 131 */
struct yaz_iconv_trie_flat marc8_9page131_flat[] = {
  {"\x27", 0, 0x7139},
  {"\x28", 0, 0x7135},
  {"\x2C", 0, 0x713B},
  {"\x2E", 0, 0x711C},
  {"\x32", 0, 0x713D},
  {"\x35", 0, 0x712F},
  {"\x3B", 0, 0x7129},
  {"\x43", 0, 0x712E},
  {"\x48", 0, 0x7177},
  {"\x51", 0, 0x7146},
  {"\x52", 0, 0x7152},
  {"\x54", 0, 0x714F},
  {"\x55", 0, 0x715D},
  {"\x56", 0, 0x7141},
  {"\x57", 0, 0x7160},
  {"\x59", 0, 0x7175},
  {"\x5A", 0, 0x7173},
  {"\x5C", 0, 0x7143},
  {"\x5D", 0, 0x715A},
  {"\x5E", 0, 0x7176},
  {"\x60", 0, 0x714B},
  {"\x62", 0, 0x7147},
  {"\x65", 0, 0x7168},
  {"\x66", 0, 0x7171},
  {"\x67", 0, 0x715F},
  {"\x69", 0, 0x7150},
  {"\x6B", 0, 0x7153},
  {"\x70", 0, 0x7144},
  {"\x76", 0, 0x7172},
  {"\x78", 0, 0x7178},
  {"\x7B", 0, 0x7187},
  {"\x7C", 0, 0x717B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page131 = {
  marc8_9page131_flat, 0
};
/* PAGE 130 */
struct yaz_iconv_trie_flat marc8_9page130_flat[] = {
  {"\x22", 0, 0x70DD},
  {"\x23", 0, 0x70E1},
  {"\x26", 0, 0x70E3},
  {"\x28", 0, 0x70E0},
  {"\x2B", 0, 0x70D4},
  {"\x2E", 0, 0x70D1},
  {"\x38", 0, 0x70CB},
  {"\x3A", 0, 0x70D0},
  {"\x3B", 0, 0x70C7},
  {"\x3C", 0, 0x70DA},
  {"\x3D", 0, 0x70C6},
  {"\x3F", 0, 0x70FA},
  {"\x42", 0, 0x70F7},
  {"\x44", 0, 0x7104},
  {"\x48", 0, 0x70F3},
  {"\x4A", 0, 0x7110},
  {"\x4C", 0, 0x7103},
  {"\x50", 0, 0x70F4},
  {"\x55", 0, 0x7111},
  {"\x56", 0, 0x7112},
  {"\x5C", 0, 0x710C},
  {"\x60", 0, 0x70F6},
  {"\x66", 0, 0x7113},
  {"\x67", 0, 0x70EF},
  {"\x68", 0, 0x7100},
  {"\x6C", 0, 0x711E},
  {"\x6D", 0, 0x7134},
  {"\x6E", 0, 0x7120},
  {"\x6F", 0, 0x713F},
  {"\x74", 0, 0x7131},
  {"\x75", 0, 0x712D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page130 = {
  marc8_9page130_flat, 0
};
/* PAGE 129 */
struct yaz_iconv_trie_flat marc8_9page129_flat[] = {
  {"\x21", 0, 0x9E02},
  {"\x25", 0, 0x7066},
  {"\x27", 0, 0x7065},
  {"\x28", 0, 0x7068},
  {"\x29", 0, 0x7054},
  {"\x39", 0, 0x7074},
  {"\x3B", 0, 0x707A},
  {"\x40", 0, 0x7093},
  {"\x42", 0, 0x7086},
  {"\x48", 0, 0xE9EC},
  {"\x49", 0, 0x7084},
  {"\x4A", 0, 0x7081},
  {"\x56", 0, 0x7088},
  {"\x57", 0, 0x7098},
  {"\x59", 0, 0x708C},
  {"\x5C", 0, 0x70B7},
  {"\x62", 0, 0x70A1},
  {"\x63", 0, 0x70A3},
  {"\x68", 0, 0x7551},
  {"\x6F", 0, 0x70A7},
  {"\x70", 0, 0x79CC},
  {"\x71", 0, 0x70B5},
  {"\x72", 0, 0x70BF},
  {"\x73", 0, 0x70A9},
  {"\x78", 0, 0x70EA},
  {"\x7B", 0, 0x70E5},
  {"\x7C", 0, 0x70DC},
  {"\x7D", 0, 0x70D3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page129 = {
  marc8_9page129_flat, 0
};
/* PAGE 128 */
struct yaz_iconv_trie_flat marc8_9page128_flat[] = {
  {"\x24", 0, 0x7020},
  {"\x26", 0, 0x7027},
  {"\x2B", 0, 0xE968},
  {"\x2F", 0, 0x702E},
  {"\x31", 0, 0x702D},
  {"\x35", 0, 0x7021},
  {"\x39", 0, 0x7018},
  {"\x3A", 0, 0x7023},
  {"\x41", 0, 0x703C},
  {"\x44", 0, 0x7035},
  {"\x51", 0, 0x7034},
  {"\x53", 0, 0x7039},
  {"\x54", 0, 0x703A},
  {"\x5D", 0, 0x7043},
  {"\x61", 0, 0x7044},
  {"\x67", 0, 0x7047},
  {"\x69", 0, 0x7049},
  {"\x6B", 0, 0x7055},
  {"\x71", 0, 0x7052},
  {"\x73", 0, 0x705C},
  {"\x78", 0, 0x7059},
  {"\x7B", 0, 0x705E},
  {"\x7C", 0, 0x7061},
  {"\x7D", 0, 0x705D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page128 = {
  marc8_9page128_flat, 0
};
/* PAGE 127 */
struct yaz_iconv_trie_flat marc8_9page127_flat[] = {
  {"\x21", 0, 0x6FAA},
  {"\x25", 0, 0x6FBF},
  {"\x26", 0, 0x6FC7},
  {"\x2D", 0, 0x6FC9},
  {"\x2E", 0, 0x6F5E},
  {"\x2F", 0, 0x6FC8},
  {"\x30", 0, 0x6FA0},
  {"\x32", 0, 0x6FCA},
  {"\x35", 0, 0x6FB4},
  {"\x37", 0, 0x6FAF},
  {"\x3C", 0, 0x6FA8},
  {"\x40", 0, 0x6FA5},
  {"\x41", 0, 0x6FB0},
  {"\x42", 0, 0x6FAE},
  {"\x43", 0, 0x6FD9},
  {"\x44", 0, 0x6FDA},
  {"\x50", 0, 0x6FD4},
  {"\x56", 0, 0x6FE9},
  {"\x57", 0, 0x6FF8},
  {"\x5D", 0, 0x6FDE},
  {"\x5E", 0, 0x6FEE},
  {"\x62", 0, 0x6FF0},
  {"\x66", 0, 0x7005},
  {"\x67", 0, 0x700C},
  {"\x6A", 0, 0x700D},
  {"\x72", 0, 0x7026},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page127 = {
  marc8_9page127_flat, 0
};
/* PAGE 126 */
struct yaz_iconv_trie_flat marc8_9page126_flat[] = {
  {"\x23", 0, 0x6F7E},
  {"\x24", 0, 0x6F9D},
  {"\x27", 0, 0x6F87},
  {"\x2B", 0, 0x6F6F},
  {"\x2F", 0, 0x6F5A},
  {"\x30", 0, 0x6F60},
  {"\x35", 0, 0x6F90},
  {"\x37", 0, 0x6F8D},
  {"\x39", 0, 0x6F92},
  {"\x3A", 0, 0x6F89},
  {"\x3C", 0, 0x6F8C},
  {"\x3D", 0, 0xE967},
  {"\x44", 0, 0x6F0B},
  {"\x4B", 0, 0x6F6C},
  {"\x4D", 0, 0x6F8B},
  {"\x58", 0, 0x6E88},
  {"\x5A", 0, 0x6F55},
  {"\x5F", 0, 0x6F72},
  {"\x62", 0, 0x6F57},
  {"\x63", 0, 0x6F5F},
  {"\x68", 0, 0x6F5D},
  {"\x73", 0, 0x6FB6},
  {"\x74", 0, 0x6F9F},
  {"\x79", 0, 0x6FA6},
  {"\x7C", 0, 0x6FC6},
  {"\x7D", 0, 0x6FBC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page126 = {
  marc8_9page126_flat, 0
};
/* PAGE 125 */
struct yaz_iconv_trie_flat marc8_9page125_flat[] = {
  {"\x21", 0, 0x6EC3},
  {"\x24", 0, 0x6EB4},
  {"\x26", 0, 0x6EB2},
  {"\x29", 0, 0x6EB5},
  {"\x2E", 0, 0x6EF8},
  {"\x30", 0, 0x6F37},
  {"\x34", 0, 0x6EFD},
  {"\x35", 0, 0x6F09},
  {"\x3C", 0, 0x6F3B},
  {"\x3D", 0, 0x6F63},
  {"\x3E", 0, 0x6F12},
  {"\x3F", 0, 0x6F26},
  {"\x41", 0, 0x6F1A},
  {"\x42", 0, 0x6EF6},
  {"\x43", 0, 0x6F19},
  {"\x44", 0, 0x6F00},
  {"\x4B", 0, 0x6F24},
  {"\x51", 0, 0x6F18},
  {"\x57", 0, 0x6F1F},
  {"\x5A", 0, 0x6F0A},
  {"\x5E", 0, 0x6F36},
  {"\x60", 0, 0x6EF9},
  {"\x61", 0, 0x6EEE},
  {"\x62", 0, 0x6F41},
  {"\x64", 0, 0x6F95},
  {"\x65", 0, 0x6F2D},
  {"\x67", 0, 0x6F34},
  {"\x6B", 0, 0x6F49},
  {"\x6D", 0, 0x6F30},
  {"\x76", 0, 0x6EFA},
  {"\x77", 0, 0x6EEB},
  {"\x78", 0, 0x6F08},
  {"\x79", 0, 0x6F0E},
  {"\x7B", 0, 0x6F35},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page125 = {
  marc8_9page125_flat, 0
};
/* PAGE 124 */
struct yaz_iconv_trie_flat marc8_9page124_flat[] = {
  {"\x22", 0, 0x6E28},
  {"\x24", 0, 0x6E5C},
  {"\x26", 0, 0x6E31},
  {"\x28", 0, 0x6E5E},
  {"\x2C", 0, 0x6E84},
  {"\x2E", 0, 0x6E2E},
  {"\x30", 0, 0x6E36},
  {"\x31", 0, 0x6E5D},
  {"\x32", 0, 0x6E72},
  {"\x33", 0, 0x6E30},
  {"\x34", 0, 0x6E53},
  {"\x36", 0, 0x6E39},
  {"\x37", 0, 0x6E71},
  {"\x38", 0, 0x6E69},
  {"\x39", 0, 0x6E6B},
  {"\x3B", 0, 0x6E8B},
  {"\x3E", 0, 0x6E76},
  {"\x40", 0, 0x6E2A},
  {"\x41", 0, 0x6E4C},
  {"\x42", 0, 0x6E22},
  {"\x43", 0, 0x6ECE},
  {"\x45", 0, 0x6E9B},
  {"\x46", 0, 0x6E9F},
  {"\x48", 0, 0x6EC8},
  {"\x49", 0, 0x6ED8},
  {"\x4A", 0, 0x6E8F},
  {"\x4D", 0, 0x6E93},
  {"\x4F", 0, 0x6EA0},
  {"\x51", 0, 0x6EB1},
  {"\x57", 0, 0x6EA8},
  {"\x59", 0, 0x6E92},
  {"\x5A", 0, 0x6EA7},
  {"\x5E", 0, 0x6E8E},
  {"\x60", 0, 0x6ED9},
  {"\x61", 0, 0x6EBD},
  {"\x63", 0, 0x6EC1},
  {"\x69", 0, 0x6EBB},
  {"\x6A", 0, 0x6EC9},
  {"\x6C", 0, 0x6EB3},
  {"\x6D", 0, 0x6EB7},
  {"\x75", 0, 0x6EA4},
  {"\x79", 0, 0x6ECF},
  {"\x7C", 0, 0x6ECA},
  {"\x7D", 0, 0x6ED5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page124 = {
  marc8_9page124_flat, 0
};
/* PAGE 123 */
struct yaz_iconv_trie_flat marc8_9page123_flat[] = {
  {"\x2A", 0, 0x6DDF},
  {"\x2D", 0, 0x6DD3},
  {"\x32", 0, 0x6DFC},
  {"\x35", 0, 0x6DDD},
  {"\x36", 0, 0x6DDC},
  {"\x39", 0, 0x6DDB},
  {"\x3D", 0, 0x6DA4},
  {"\x44", 0, 0x6E12},
  {"\x46", 0, 0x6DF0},
  {"\x4A", 0, 0x6DE6},
  {"\x4C", 0, 0x6E1F},
  {"\x50", 0, 0x6E27},
  {"\x55", 0, 0x6E49},
  {"\x58", 0, 0x6E3C},
  {"\x60", 0, 0x6E8A},
  {"\x62", 0, 0x6E4B},
  {"\x66", 0, 0x6E62},
  {"\x6A", 0, 0x6E51},
  {"\x6B", 0, 0x6E44},
  {"\x6D", 0, 0x6E63},
  {"\x71", 0, 0x6E73},
  {"\x74", 0, 0x6E4F},
  {"\x77", 0, 0x6E4E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page123 = {
  marc8_9page123_flat, 0
};
/* PAGE 122 */
struct yaz_iconv_trie_flat marc8_9page122_flat[] = {
  {"\x25", 0, 0x6D6D},
  {"\x26", 0, 0x6D6F},
  {"\x28", 0, 0x6D61},
  {"\x29", 0, 0x6D91},
  {"\x2C", 0, 0x6D81},
  {"\x2E", 0, 0x6D8A},
  {"\x2F", 0, 0xE966},
  {"\x34", 0, 0x6D79},
  {"\x35", 0, 0x6DEF},
  {"\x39", 0, 0x6D7F},
  {"\x3B", 0, 0x6D85},
  {"\x3C", 0, 0x6D65},
  {"\x3E", 0, 0x6D5E},
  {"\x40", 0, 0x6D67},
  {"\x43", 0, 0x6D94},
  {"\x46", 0, 0x6D60},
  {"\x48", 0, 0x6D98},
  {"\x4B", 0, 0x6D7C},
  {"\x4C", 0, 0x6D70},
  {"\x4F", 0, 0x6D96},
  {"\x59", 0, 0x6DAB},
  {"\x5A", 0, 0x6DB4},
  {"\x5C", 0, 0x6DAA},
  {"\x60", 0, 0x6DEC},
  {"\x6A", 0, 0x6DAC},
  {"\x6B", 0, 0x6DB7},
  {"\x6C", 0, 0x6DE2},
  {"\x6D", 0, 0x6DD5},
  {"\x6E", 0, 0x6DE9},
  {"\x71", 0, 0x6DF6},
  {"\x79", 0, 0x6E0F},
  {"\x7B", 0, 0x6DBF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page122 = {
  marc8_9page122_flat, 0
};
/* PAGE 121 */
struct yaz_iconv_trie_flat marc8_9page121_flat[] = {
  {"\x24", 0, 0x6CD8},
  {"\x26", 0, 0x6CC6},
  {"\x28", 0, 0x6CCE},
  {"\x29", 0, 0x6CE9},
  {"\x2D", 0, 0x6CF2},
  {"\x2F", 0, 0x6CE0},
  {"\x30", 0, 0x6CD1},
  {"\x32", 0, 0x6CD2},
  {"\x33", 0, 0x6CB4},
  {"\x37", 0, 0x6D1D},
  {"\x3B", 0, 0x6D28},
  {"\x44", 0, 0x6D39},
  {"\x4D", 0, 0x6D26},
  {"\x4E", 0, 0x6D27},
  {"\x4F", 0, 0x6D0F},
  {"\x50", 0, 0x6D0A},
  {"\x51", 0, 0x6D3F},
  {"\x5A", 0, 0x6D07},
  {"\x5B", 0, 0x6D04},
  {"\x5C", 0, 0x6CDA},
  {"\x60", 0, 0x6D2E},
  {"\x61", 0, 0x6D35},
  {"\x62", 0, 0x6D3A},
  {"\x64", 0, 0x6D19},
  {"\x67", 0, 0x6D0E},
  {"\x6A", 0, 0x6D2B},
  {"\x6B", 0, 0x6D11},
  {"\x6C", 0, 0x6D00},
  {"\x6D", 0, 0x6D24},
  {"\x6F", 0, 0x6D33},
  {"\x73", 0, 0x6D63},
  {"\x77", 0, 0x6DA5},
  {"\x7D", 0, 0x6D92},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page121 = {
  marc8_9page121_flat, 0
};
/* PAGE 120 */
struct yaz_iconv_trie_flat marc8_9page120_flat[] = {
  {"\x24", 0, 0x6C5C},
  {"\x26", 0, 0x6C5B},
  {"\x27", 0, 0x6C4D},
  {"\x2B", 0, 0x6C4B},
  {"\x2C", 0, 0x6C54},
  {"\x2D", 0, 0x6C63},
  {"\x30", 0, 0x6C78},
  {"\x31", 0, 0x6C74},
  {"\x32", 0, 0x6C86},
  {"\x33", 0, 0x6C76},
  {"\x38", 0, 0x6C6C},
  {"\x39", 0, 0x6C67},
  {"\x3B", 0, 0x6C84},
  {"\x3E", 0, 0x6C94},
  {"\x40", 0, 0x6C8F},
  {"\x42", 0, 0x6C65},
  {"\x47", 0, 0x6C6F},
  {"\x49", 0, 0x6C9D},
  {"\x4A", 0, 0x6C69},
  {"\x4B", 0, 0x6C9A},
  {"\x4C", 0, 0x6C6D},
  {"\x4D", 0, 0x6C93},
  {"\x51", 0, 0x6C87},
  {"\x52", 0, 0x6C6E},
  {"\x56", 0, 0x6C95},
  {"\x5A", 0, 0x6C82},
  {"\x5C", 0, 0x6CA0},
  {"\x62", 0, 0x6CEB},
  {"\x63", 0, 0x6CEE},
  {"\x64", 0, 0x6CC0},
  {"\x66", 0, 0x6CEF},
  {"\x67", 0, 0x6CAC},
  {"\x6E", 0, 0xE965},
  {"\x70", 0, 0x6CAF},
  {"\x72", 0, 0x6CF5},
  {"\x7A", 0, 0x6CBA},
  {"\x7B", 0, 0x7553},
  {"\x7D", 0, 0x6CC2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page120 = {
  marc8_9page120_flat, 0
};
/* PAGE 119 */
struct yaz_iconv_trie_flat marc8_9page119_flat[] = {
  {"\x2A", 0, 0x6BF6},
  {"\x2C", 0, 0x6BF3},
  {"\x33", 0, 0x6BF8},
  {"\x37", 0, 0x6BFA},
  {"\x38", 0, 0x6BF9},
  {"\x42", 0, 0x6BFF},
  {"\x44", 0, 0x6C06},
  {"\x48", 0, 0x6C04},
  {"\x4A", 0, 0x6C05},
  {"\x4C", 0, 0x6C08},
  {"\x51", 0, 0x6C0C},
  {"\x52", 0, 0x6C0D},
  {"\x59", 0, 0x6C15},
  {"\x5A", 0, 0x6C18},
  {"\x5B", 0, 0x6C19},
  {"\x5C", 0, 0x6C1A},
  {"\x5E", 0, 0x6C1D},
  {"\x60", 0, 0x6C20},
  {"\x62", 0, 0x6C21},
  {"\x64", 0, 0x6C2A},
  {"\x66", 0, 0x6C2D},
  {"\x67", 0, 0x6C30},
  {"\x68", 0, 0x6C2C},
  {"\x69", 0, 0xE9EB},
  {"\x70", 0, 0x6C3B},
  {"\x74", 0, 0x6C3F},
  {"\x78", 0, 0x6C46},
  {"\x7A", 0, 0x6C52},
  {"\x7B", 0, 0x6C62},
  {"\x7C", 0, 0x6C4A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page119 = {
  marc8_9page119_flat, 0
};
/* PAGE 118 */
struct yaz_iconv_trie_flat marc8_9page118_flat[] = {
  {"\x25", 0, 0x6B99},
  {"\x29", 0, 0x6B9B},
  {"\x35", 0, 0x6BA3},
  {"\x36", 0, 0x6BA2},
  {"\x38", 0, 0x6BAA},
  {"\x39", 0, 0x6BAB},
  {"\x3B", 0, 0x6BAD},
  {"\x3D", 0, 0x6BB0},
  {"\x3F", 0, 0x6BB3},
  {"\x47", 0, 0x6BBD},
  {"\x4D", 0, 0x6996},
  {"\x54", 0, 0x6BC8},
  {"\x5B", 0, 0x6BD6},
  {"\x60", 0, 0x6BDA},
  {"\x62", 0, 0x6BDC},
  {"\x63", 0, 0x6BDD},
  {"\x65", 0, 0x6BDF},
  {"\x6F", 0, 0x6BE7},
  {"\x70", 0, 0x6BEA},
  {"\x71", 0, 0x6BE8},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page118 = {
  marc8_9page118_flat, 0
};
/* PAGE 117 */
struct yaz_iconv_trie_flat marc8_9page117_flat[] = {
  {"\x2A", 0, 0x6B35},
  {"\x2C", 0, 0x6B37},
  {"\x2D", 0, 0x6B3B},
  {"\x32", 0, 0x6B39},
  {"\x35", 0, 0x6B3F},
  {"\x37", 0, 0x6B46},
  {"\x38", 0, 0x6B41},
  {"\x3A", 0, 0x6B40},
  {"\x3B", 0, 0x6B42},
  {"\x3C", 0, 0x6B43},
  {"\x3E", 0, 0x6B48},
  {"\x3F", 0, 0x6B4A},
  {"\x46", 0, 0xE964},
  {"\x4A", 0, 0x6B57},
  {"\x4C", 0, 0x6B54},
  {"\x4E", 0, 0x6B55},
  {"\x51", 0, 0x6B5C},
  {"\x53", 0, 0x6B5E},
  {"\x54", 0, 0x6B60},
  {"\x5B", 0, 0x6B6B},
  {"\x5D", 0, 0x6B6C},
  {"\x5F", 0, 0x6B6E},
  {"\x61", 0, 0x6B71},
  {"\x6B", 0, 0x6B7E},
  {"\x71", 0, 0x6B82},
  {"\x73", 0, 0x6B84},
  {"\x79", 0, 0x6B8D},
  {"\x7B", 0, 0x6B95},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page117 = {
  marc8_9page117_flat, 0
};
/* PAGE 116 */
struct yaz_iconv_trie_flat marc8_9page116_flat[] = {
  {"\x25", 0, 0x6ACC},
  {"\x28", 0, 0x6AD1},
  {"\x33", 0, 0x6ADF},
  {"\x34", 0, 0x6ACD},
  {"\x35", 0, 0x6ADE},
  {"\x37", 0, 0x6AEC},
  {"\x39", 0, 0x6AF3},
  {"\x3A", 0, 0x6AE7},
  {"\x3F", 0, 0x6AEB},
  {"\x40", 0, 0x6AEA},
  {"\x44", 0, 0x6AF1},
  {"\x45", 0, 0x6AE8},
  {"\x48", 0, 0x6AF5},
  {"\x4E", 0, 0x6AFD},
  {"\x50", 0, 0x6AFA},
  {"\x52", 0, 0x6B01},
  {"\x58", 0, 0x6B03},
  {"\x59", 0, 0x6AF8},
  {"\x5F", 0, 0x6B0D},
  {"\x60", 0, 0x6B09},
  {"\x61", 0, 0x6B0E},
  {"\x67", 0, 0x6B11},
  {"\x6D", 0, 0x6B19},
  {"\x6E", 0, 0x6B17},
  {"\x72", 0, 0x6B1E},
  {"\x7E", 0, 0x6B2C},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page116 = {
  marc8_9page116_flat, 0
};
/* PAGE 115 */
struct yaz_iconv_trie_flat marc8_9page115_flat[] = {
  {"\x22", 0, 0x6A7F},
  {"\x23", 0, 0x6A89},
  {"\x24", 0, 0x6A91},
  {"\x26", 0, 0x6A9F},
  {"\x2A", 0, 0x6A92},
  {"\x2B", 0, 0x6AA3},
  {"\x34", 0, 0x6A99},
  {"\x35", 0, 0x6A9D},
  {"\x36", 0, 0x6A7E},
  {"\x37", 0, 0x6A9B},
  {"\x42", 0, 0x6AA0},
  {"\x47", 0, 0x6A90},
  {"\x49", 0, 0x6A9E},
  {"\x4A", 0, 0x6A87},
  {"\x4B", 0, 0x6A8E},
  {"\x51", 0, 0x6AAB},
  {"\x55", 0, 0x6AC8},
  {"\x57", 0, 0x6AAE},
  {"\x5D", 0, 0x6ABF},
  {"\x64", 0, 0x6ACA},
  {"\x68", 0, 0x6AB4},
  {"\x79", 0, 0x6AE6},
  {"\x7E", 0, 0x6AED},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page115 = {
  marc8_9page115_flat, 0
};
/* PAGE 114 */
struct yaz_iconv_trie_flat marc8_9page114_flat[] = {
  {"\x23", 0, 0x69F0},
  {"\x24", 0, 0x69F2},
  {"\x28", 0, 0x6A14},
  {"\x29", 0, 0x6A63},
  {"\x37", 0, 0x6A67},
  {"\x39", 0, 0x6A43},
  {"\x3A", 0, 0x6A33},
  {"\x3B", 0, 0x6A32},
  {"\x3C", 0, 0x6A5A},
  {"\x3F", 0, 0x6A28},
  {"\x40", 0, 0x6A48},
  {"\x41", 0, 0x6A50},
  {"\x42", 0, 0x6A52},
  {"\x43", 0, 0x6A72},
  {"\x45", 0, 0x6A3E},
  {"\x46", 0, 0x6A77},
  {"\x47", 0, 0x6A5B},
  {"\x4A", 0, 0x6A5E},
  {"\x4B", 0, 0x6A5C},
  {"\x4F", 0, 0x6A51},
  {"\x51", 0, 0x6A56},
  {"\x53", 0, 0x6A36},
  {"\x56", 0, 0x6A7A},
  {"\x58", 0, 0x6A3F},
  {"\x6C", 0, 0x69F9},
  {"\x6D", 0, 0x6A64},
  {"\x73", 0, 0x6A8D},
  {"\x75", 0, 0x6AA8},
  {"\x77", 0, 0x6AA5},
  {"\x79", 0, 0x6A96},
  {"\x7E", 0, 0x6A7D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page114 = {
  marc8_9page114_flat, 0
};
/* PAGE 113 */
struct yaz_iconv_trie_flat marc8_9page113_flat[] = {
  {"\x27", 0, 0x69BF},
  {"\x2D", 0, 0x69A3},
  {"\x2E", 0, 0x69A4},
  {"\x34", 0, 0x69D4},
  {"\x38", 0, 0x69C3},
  {"\x3D", 0, 0x6A12},
  {"\x3E", 0, 0x6A11},
  {"\x41", 0, 0x6A00},
  {"\x46", 0, 0x69E6},
  {"\x4B", 0, 0x6A0B},
  {"\x4C", 0, 0x69E5},
  {"\x4D", 0, 0x69E9},
  {"\x50", 0, 0x69FC},
  {"\x54", 0, 0x6A17},
  {"\x56", 0, 0x69E7},
  {"\x57", 0, 0x69EB},
  {"\x5B", 0, 0x69F1},
  {"\x5E", 0, 0x6A2B},
  {"\x5F", 0, 0x69FF},
  {"\x60", 0, 0x6A20},
  {"\x64", 0, 0x69ED},
  {"\x67", 0, 0x6A1B},
  {"\x68", 0, 0x6A2D},
  {"\x6E", 0, 0x6A18},
  {"\x72", 0, 0x6A1D},
  {"\x75", 0, 0x6A0C},
  {"\x76", 0, 0x6A0F},
  {"\x7C", 0, 0x69EE},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page113 = {
  marc8_9page113_flat, 0
};
/* PAGE 112 */
struct yaz_iconv_trie_flat marc8_9page112_flat[] = {
  {"\x21", 0, 0x6952},
  {"\x25", 0, 0x695B},
  {"\x2D", 0, 0x6985},
  {"\x32", 0, 0x693D},
  {"\x35", 0, 0x6978},
  {"\x37", 0, 0x697B},
  {"\x3A", 0, 0x6934},
  {"\x3B", 0, 0x6969},
  {"\x3D", 0, 0x6944},
  {"\x3E", 0, 0x696F},
  {"\x44", 0, 0x698A},
  {"\x45", 0, 0x69A0},
  {"\x46", 0, 0x69B1},
  {"\x50", 0, 0x69CE},
  {"\x51", 0, 0x69CA},
  {"\x59", 0, 0x698D},
  {"\x5A", 0, 0x6991},
  {"\x5C", 0, 0x69AA},
  {"\x60", 0, 0x69BC},
  {"\x61", 0, 0x69A7},
  {"\x65", 0, 0x699E},
  {"\x68", 0, 0x69D9},
  {"\x6A", 0, 0x698E},
  {"\x6D", 0, 0x69D6},
  {"\x75", 0, 0x69A5},
  {"\x77", 0, 0x69BE},
  {"\x78", 0, 0x69D1},
  {"\x7A", 0, 0x69F6},
  {"\x7E", 0, 0x69D5},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page112 = {
  marc8_9page112_flat, 0
};
/* PAGE 111 */
struct yaz_iconv_trie_flat marc8_9page111_flat[] = {
  {"\x21", 0, 0x6907},
  {"\x23", 0, 0x691A},
  {"\x24", 0, 0x6919},
  {"\x2A", 0, 0x68DE},
  {"\x2B", 0, 0x691B},
  {"\x2D", 0, 0x68FB},
  {"\x33", 0, 0x68E1},
  {"\x37", 0, 0x68D1},
  {"\x38", 0, 0x68D0},
  {"\x39", 0, 0x6908},
  {"\x3E", 0, 0x68E8},
  {"\x3F", 0, 0x68F0},
  {"\x40", 0, 0x68C3},
  {"\x44", 0, 0x6911},
  {"\x46", 0, 0x68D4},
  {"\x47", 0, 0x68EF},
  {"\x49", 0, 0x68C6},
  {"\x4B", 0, 0x68C7},
  {"\x53", 0, 0x6974},
  {"\x55", 0, 0x6938},
  {"\x58", 0, 0x6962},
  {"\x5D", 0, 0x6958},
  {"\x5F", 0, 0x6957},
  {"\x60", 0, 0x693F},
  {"\x61", 0, 0x6971},
  {"\x64", 0, 0x6945},
  {"\x65", 0, 0x695D},
  {"\x66", 0, 0x6932},
  {"\x69", 0, 0x696E},
  {"\x6A", 0, 0x6963},
  {"\x6B", 0, 0x6948},
  {"\x6E", 0, 0x6939},
  {"\x70", 0, 0x696A},
  {"\x73", 0, 0x6937},
  {"\x7A", 0, 0x696C},
  {"\x7B", 0, 0x694E},
  {"\x7D", 0, 0x6980},
  {"\x7E", 0, 0x6933},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page111 = {
  marc8_9page111_flat, 0
};
/* PAGE 110 */
struct yaz_iconv_trie_flat marc8_9page110_flat[] = {
  {"\x21", 0, 0x6872},
  {"\x22", 0, 0x689C},
  {"\x25", 0, 0x686D},
  {"\x2E", 0, 0x68A9},
  {"\x30", 0, 0x6898},
  {"\x32", 0, 0x688B},
  {"\x33", 0, 0x68A0},
  {"\x34", 0, 0x686F},
  {"\x39", 0, 0x68A3},
  {"\x3B", 0, 0x6874},
  {"\x3C", 0, 0x6875},
  {"\x3F", 0, 0x6877},
  {"\x40", 0, 0x688F},
  {"\x43", 0, 0x687B},
  {"\x44", 0, 0x688E},
  {"\x4B", 0, 0x68B4},
  {"\x50", 0, 0x692C},
  {"\x51", 0, 0x6917},
  {"\x53", 0, 0x690C},
  {"\x56", 0, 0x690B},
  {"\x58", 0, 0x68D3},
  {"\x59", 0, 0x6904},
  {"\x5B", 0, 0x690A},
  {"\x5C", 0, 0x6909},
  {"\x5D", 0, 0x6929},
  {"\x62", 0, 0x68EC},
  {"\x63", 0, 0x692A},
  {"\x64", 0, 0x68EA},
  {"\x65", 0, 0x681F},
  {"\x66", 0, 0x7439},
  {"\x6A", 0, 0x6910},
  {"\x6E", 0, 0x68D6},
  {"\x6F", 0, 0x68EB},
  {"\x73", 0, 0x68F1},
  {"\x78", 0, 0x68FD},
  {"\x79", 0, 0x68FC},
  {"\x7B", 0, 0x68F3},
  {"\x7C", 0, 0x6913},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page110 = {
  marc8_9page110_flat, 0
};
/* PAGE 109 */
struct yaz_iconv_trie_flat marc8_9page109_flat[] = {
  {"\x21", 0, 0x67B9},
  {"\x23", 0, 0x67C2},
  {"\x24", 0, 0x67E3},
  {"\x26", 0, 0x67CA},
  {"\x28", 0, 0x67CE},
  {"\x29", 0, 0x67E2},
  {"\x2A", 0, 0x67F2},
  {"\x2B", 0, 0x67C3},
  {"\x2D", 0, 0x67DD},
  {"\x2F", 0, 0x67E7},
  {"\x30", 0, 0x6849},
  {"\x31", 0, 0x683E},
  {"\x36", 0, 0x6814},
  {"\x37", 0, 0x684B},
  {"\x38", 0, 0x681E},
  {"\x3B", 0, 0x6833},
  {"\x40", 0, 0x6831},
  {"\x41", 0, 0x6832},
  {"\x42", 0, 0x6835},
  {"\x43", 0, 0x683B},
  {"\x44", 0, 0x684E},
  {"\x47", 0, 0x682B},
  {"\x48", 0, 0x682D},
  {"\x4A", 0, 0x684D},
  {"\x4F", 0, 0x6844},
  {"\x55", 0, 0x685D},
  {"\x56", 0, 0x685E},
  {"\x58", 0, 0x6834},
  {"\x59", 0, 0x6812},
  {"\x65", 0, 0x685A},
  {"\x68", 0, 0x686B},
  {"\x69", 0, 0x686C},
  {"\x6B", 0, 0x6879},
  {"\x6E", 0, 0x68B2},
  {"\x71", 0, 0x689B},
  {"\x72", 0, 0x687E},
  {"\x74", 0, 0x68B6},
  {"\x76", 0, 0x6882},
  {"\x7A", 0, 0x6890},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page109 = {
  marc8_9page109_flat, 0
};
/* PAGE 108 */
struct yaz_iconv_trie_flat marc8_9page108_flat[] = {
  {"\x21", 0, 0x677B},
  {"\x22", 0, 0x6792},
  {"\x23", 0, 0x6776},
  {"\x25", 0, 0x6791},
  {"\x26", 0, 0x6799},
  {"\x28", 0, 0x67A4},
  {"\x2E", 0, 0x678F},
  {"\x30", 0, 0x6772},
  {"\x31", 0, 0xE963},
  {"\x32", 0, 0x676A},
  {"\x39", 0, 0x67AC},
  {"\x3B", 0, 0x67A0},
  {"\x3F", 0, 0x67A1},
  {"\x44", 0, 0x67F9},
  {"\x48", 0, 0x678D},
  {"\x49", 0, 0x678C},
  {"\x4C", 0, 0x67FC},
  {"\x4E", 0, 0x6810},
  {"\x51", 0, 0x67C8},
  {"\x54", 0, 0x67CC},
  {"\x58", 0, 0x67C5},
  {"\x5C", 0, 0x67BB},
  {"\x5F", 0, 0x67B0},
  {"\x60", 0, 0x6803},
  {"\x61", 0, 0x67F8},
  {"\x63", 0, 0x67D8},
  {"\x64", 0, 0x67B7},
  {"\x6D", 0, 0x6802},
  {"\x6F", 0, 0x67E4},
  {"\x70", 0, 0x67D9},
  {"\x71", 0, 0x67DB},
  {"\x72", 0, 0x67B5},
  {"\x74", 0, 0x67DF},
  {"\x75", 0, 0x67F7},
  {"\x77", 0, 0x67B3},
  {"\x78", 0, 0x6806},
  {"\x79", 0, 0x67AE},
  {"\x7A", 0, 0x67F6},
  {"\x7C", 0, 0x67EE},
  {"\x7D", 0, 0x6AAF},
  {"\x7E", 0, 0x67B2},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page108 = {
  marc8_9page108_flat, 0
};
/* PAGE 107 */
struct yaz_iconv_trie_flat marc8_9page107_flat[] = {
  {"\x28", 0, 0x6705},
  {"\x30", 0, 0x670F},
  {"\x31", 0, 0x6710},
  {"\x33", 0, 0x6712},
  {"\x34", 0, 0x6713},
  {"\x38", 0, 0x6719},
  {"\x39", 0, 0x6718},
  {"\x47", 0, 0x6723},
  {"\x4C", 0, 0x673E},
  {"\x4E", 0, 0x673F},
  {"\x58", 0, 0x6757},
  {"\x5B", 0, 0x6745},
  {"\x5C", 0, 0x6747},
  {"\x60", 0, 0x675D},
  {"\x61", 0, 0x6755},
  {"\x66", 0, 0x674C},
  {"\x67", 0, 0x6759},
  {"\x68", 0, 0x6748},
  {"\x6B", 0, 0x6763},
  {"\x6E", 0, 0x6753},
  {"\x71", 0, 0x674A},
  {"\x75", 0, 0x6793},
  {"\x78", 0, 0x677C},
  {"\x7A", 0, 0x679F},
  {"\x7C", 0, 0x6785},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page107 = {
  marc8_9page107_flat, 0
};
/* PAGE 106 */
struct yaz_iconv_trie_flat marc8_9page106_flat[] = {
  {"\x24", 0, 0x7A25},
  {"\x2A", 0, 0x66A0},
  {"\x30", 0, 0x5C21},
  {"\x32", 0, 0x669D},
  {"\x3A", 0, 0x66B2},
  {"\x40", 0, 0x66B5},
  {"\x41", 0, 0x66AA},
  {"\x43", 0, 0x66AC},
  {"\x47", 0, 0x66B1},
  {"\x4E", 0, 0x66C8},
  {"\x4F", 0, 0x66BE},
  {"\x54", 0, 0x66C0},
  {"\x55", 0, 0x66C7},
  {"\x5A", 0, 0x66BB},
  {"\x5C", 0, 0x66C4},
  {"\x60", 0, 0x66CF},
  {"\x71", 0, 0x66DA},
  {"\x72", 0, 0x66DB},
  {"\x73", 0, 0x66E2},
  {"\x76", 0, 0x66E1},
  {"\x78", 0, 0x66E8},
  {"\x7C", 0, 0x66E9},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page106 = {
  marc8_9page106_flat, 0
};
/* PAGE 105 */
struct yaz_iconv_trie_flat marc8_9page105_flat[] = {
  {"\x27", 0, 0x6633},
  {"\x28", 0, 0x662B},
  {"\x2B", 0, 0x6634},
  {"\x2C", 0, 0x6624},
  {"\x31", 0, 0x6645},
  {"\x32", 0, 0x665F},
  {"\x3D", 0, 0x6665},
  {"\x3E", 0, 0x665C},
  {"\x3F", 0, 0x6661},
  {"\x48", 0, 0x665B},
  {"\x49", 0, 0x6659},
  {"\x4A", 0, 0x6667},
  {"\x4C", 0, 0x665E},
  {"\x4D", 0, 0x6657},
  {"\x50", 0, 0x667E},
  {"\x51", 0, 0x666C},
  {"\x5A", 0, 0x6678},
  {"\x60", 0, 0x6673},
  {"\x66", 0, 0x666D},
  {"\x68", 0, 0x6677},
  {"\x70", 0, 0x6684},
  {"\x71", 0, 0x668C},
  {"\x72", 0, 0x6693},
  {"\x75", 0, 0x668B},
  {"\x76", 0, 0x6690},
  {"\x79", 0, 0x6694},
  {"\x7A", 0, 0x668A},
  {"\x7C", 0, 0x6698},
  {"\x7D", 0, 0x668D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page105 = {
  marc8_9page105_flat, 0
};
/* PAGE 104 */
struct yaz_iconv_trie_flat marc8_9page104_flat[] = {
  {"\x22", 0, 0x65A8},
  {"\x23", 0, 0x65A6},
  {"\x27", 0, 0x65AE},
  {"\x2A", 0, 0x65B6},
  {"\x2C", 0, 0x65B8},
  {"\x2F", 0, 0x65BF},
  {"\x31", 0, 0x65C6},
  {"\x32", 0, 0x65C3},
  {"\x33", 0, 0x65C4},
  {"\x34", 0, 0x65C2},
  {"\x3B", 0, 0x65D0},
  {"\x3C", 0, 0x65D2},
  {"\x44", 0, 0x65DB},
  {"\x45", 0, 0x65DC},
  {"\x47", 0, 0x65DD},
  {"\x48", 0, 0x65DF},
  {"\x4A", 0, 0x65E1},
  {"\x4E", 0, 0x65E4},
  {"\x54", 0, 0x65F4},
  {"\x55", 0, 0x65F0},
  {"\x5A", 0, 0x6609},
  {"\x5B", 0, 0x65FB},
  {"\x5C", 0, 0x65FC},
  {"\x5E", 0, 0x660A},
  {"\x64", 0, 0x6603},
  {"\x6A", 0, 0x6611},
  {"\x6B", 0, 0x6615},
  {"\x6D", 0, 0x6604},
  {"\x6E", 0, 0x6631},
  {"\x72", 0, 0x6621},
  {"\x75", 0, 0x662C},
  {"\x77", 0, 0x6635},
  {"\x7C", 0, 0x661E},
  {"\x7D", 0, 0x663A},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page104 = {
  marc8_9page104_flat, 0
};
/* PAGE 103 */
struct yaz_iconv_trie_flat marc8_9page103_flat[] = {
  {"\x2C", 0, 0x6538},
  {"\x34", 0, 0x6542},
  {"\x36", 0, 0x6549},
  {"\x3E", 0, 0x6554},
  {"\x3F", 0, 0x6555},
  {"\x45", 0, 0x6567},
  {"\x47", 0, 0x6561},
  {"\x4F", 0, 0x656D},
  {"\x54", 0, 0x657A},
  {"\x64", 0, 0x6585},
  {"\x6E", 0, 0x658C},
  {"\x70", 0, 0x6592},
  {"\x71", 0, 0x6595},
  {"\x75", 0, 0x659B},
  {"\x77", 0, 0x659D},
  {"\x7A", 0, 0x65A0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page103 = {
  marc8_9page103_flat, 0
};
/* PAGE 102 */
struct yaz_iconv_trie_flat marc8_9page102_flat[] = {
  {"\x2A", 0, 0x64EF},
  {"\x2D", 0, 0x64E1},
  {"\x2E", 0, 0x64E5},
  {"\x31", 0, 0x64EB},
  {"\x33", 0, 0x64E2},
  {"\x36", 0, 0x64ED},
  {"\x38", 0, 0x64E4},
  {"\x42", 0, 0x64F7},
  {"\x46", 0, 0x6504},
  {"\x4B", 0, 0x64FD},
  {"\x4F", 0, 0x6508},
  {"\x53", 0, 0x6509},
  {"\x59", 0, 0x651A},
  {"\x5B", 0, 0x6516},
  {"\x61", 0, 0x651B},
  {"\x69", 0, 0x6527},
  {"\x6D", 0, 0x6522},
  {"\x6F", 0, 0x6529},
  {"\x72", 0, 0x6525},
  {"\x77", 0, 0x652E},
  {"\x7C", 0, 0x6541},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page102 = {
  marc8_9page102_flat, 0
};
/* PAGE 101 */
struct yaz_iconv_trie_flat marc8_9page101_flat[] = {
  {"\x23", 0, 0x644E},
  {"\x24", 0, 0x6464},
  {"\x27", 0, 0x6482},
  {"\x28", 0, 0x645E},
  {"\x2C", 0, 0x647B},
  {"\x2E", 0, 0x645C},
  {"\x3C", 0, 0x649D},
  {"\x3F", 0, 0x6499},
  {"\x42", 0, 0x648F},
  {"\x4D", 0, 0x6496},
  {"\x4E", 0, 0x64A2},
  {"\x54", 0, 0x6490},
  {"\x5B", 0, 0x64B6},
  {"\x61", 0, 0x6498},
  {"\x62", 0, 0x649F},
  {"\x65", 0, 0xE9EA},
  {"\x66", 0, 0x64B3},
  {"\x6A", 0, 0x64D7},
  {"\x6C", 0, 0x64D3},
  {"\x74", 0, 0x64BE},
  {"\x75", 0, 0x64D0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page101 = {
  marc8_9page101_flat, 0
};
/* PAGE 100 */
struct yaz_iconv_trie_flat marc8_9page100_flat[] = {
  {"\x22", 0, 0x6410},
  {"\x24", 0, 0x6434},
  {"\x29", 0, 0x641B},
  {"\x2B", 0, 0x6420},
  {"\x2C", 0, 0x6424},
  {"\x2F", 0, 0x6426},
  {"\x31", 0, 0x640C},
  {"\x36", 0, 0x6415},
  {"\x37", 0, 0x6418},
  {"\x38", 0, 0x640E},
  {"\x39", 0, 0xEA03},
  {"\x3B", 0, 0x6422},
  {"\x3D", 0, 0x6421},
  {"\x44", 0, 0x6430},
  {"\x45", 0, 0x6441},
  {"\x48", 0, 0x6435},
  {"\x4C", 0, 0x6409},
  {"\x51", 0, 0x640A},
  {"\x53", 0, 0x6440},
  {"\x59", 0, 0x6407},
  {"\x5B", 0, 0x643B},
  {"\x5D", 0, 0x643F},
  {"\x68", 0, 0x645B},
  {"\x6A", 0, 0x644F},
  {"\x6C", 0, 0x646B},
  {"\x6F", 0, 0x6476},
  {"\x76", 0, 0x6474},
  {"\x78", 0, 0x647D},
  {"\x7B", 0, 0x6473},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page100 = {
  marc8_9page100_flat, 0
};
/* PAGE 99 */
struct yaz_iconv_trie_flat marc8_9page99_flat[] = {
  {"\x25", 0, 0x6387},
  {"\x26", 0, 0x637A},
  {"\x27", 0, 0x638E},
  {"\x2A", 0, 0x6386},
  {"\x2F", 0, 0x6375},
  {"\x30", 0, 0x63AF},
  {"\x37", 0, 0x63B1},
  {"\x38", 0, 0x63B0},
  {"\x39", 0, 0x63AE},
  {"\x3A", 0, 0x637C},
  {"\x3B", 0, 0x6390},
  {"\x3D", 0, 0x63AD},
  {"\x41", 0, 0x636D},
  {"\x43", 0, 0x63DE},
  {"\x44", 0, 0x63E5},
  {"\x47", 0, 0x63D3},
  {"\x4F", 0, 0x63BD},
  {"\x50", 0, 0x63C3},
  {"\x52", 0, 0x63F5},
  {"\x58", 0, 0x63E6},
  {"\x5B", 0, 0x63E0},
  {"\x5C", 0, 0x63D5},
  {"\x5D", 0, 0x63F6},
  {"\x5E", 0, 0x63F2},
  {"\x5F", 0, 0x63F8},
  {"\x66", 0, 0xE9E8},
  {"\x6A", 0, 0x63F9},
  {"\x70", 0, 0x63BE},
  {"\x72", 0, 0x63EB},
  {"\x73", 0, 0x63DD},
  {"\x76", 0, 0xE9E9},
  {"\x79", 0, 0x63C4},
  {"\x7A", 0, 0x63DC},
  {"\x7B", 0, 0x63D7},
  {"\x7E", 0, 0x6412},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page99 = {
  marc8_9page99_flat, 0
};
/* PAGE 98 */
struct yaz_iconv_trie_flat marc8_9page98_flat[] = {
  {"\x25", 0, 0x62F5},
  {"\x31", 0, 0x630C},
  {"\x32", 0, 0x6360},
  {"\x37", 0, 0x62F6},
  {"\x3A", 0, 0x6331},
  {"\x42", 0, 0x6345},
  {"\x44", 0, 0x6343},
  {"\x45", 0, 0x6335},
  {"\x47", 0, 0x6353},
  {"\x48", 0, 0x6364},
  {"\x49", 0, 0x6336},
  {"\x4A", 0, 0x6344},
  {"\x54", 0, 0x6339},
  {"\x58", 0, 0x6357},
  {"\x5A", 0, 0x633C},
  {"\x5B", 0, 0x6358},
  {"\x5C", 0, 0x634B},
  {"\x5F", 0, 0x6354},
  {"\x68", 0, 0x637D},
  {"\x6A", 0, 0x63B6},
  {"\x6B", 0, 0x6382},
  {"\x6C", 0, 0x636C},
  {"\x6E", 0, 0x639F},
  {"\x72", 0, 0x639E},
  {"\x73", 0, 0x637F},
  {"\x79", 0, 0x6381},
  {"\x7B", 0, 0x6397},
  {"\x7D", 0, 0x63AB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page98 = {
  marc8_9page98_flat, 0
};
/* PAGE 97 */
struct yaz_iconv_trie_flat marc8_9page97_flat[] = {
  {"\x26", 0, 0x6268},
  {"\x28", 0, 0x6260},
  {"\x2B", 0, 0x625A},
  {"\x2C", 0, 0x6262},
  {"\x2D", 0, 0x6266},
  {"\x31", 0, 0x6286},
  {"\x32", 0, 0x628E},
  {"\x41", 0, 0x62A3},
  {"\x43", 0, 0x6282},
  {"\x46", 0, 0x6285},
  {"\x4B", 0, 0x629D},
  {"\x56", 0, 0x62A6},
  {"\x57", 0, 0x62D1},
  {"\x61", 0, 0x62E4},
  {"\x69", 0, 0x62B6},
  {"\x6A", 0, 0x62C3},
  {"\x72", 0, 0x630D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page97 = {
  marc8_9page97_flat, 0
};
/* PAGE 96 */
struct yaz_iconv_trie_flat marc8_9page96_flat[] = {
  {"\x29", 0, 0x61F3},
  {"\x3D", 0, 0x6201},
  {"\x41", 0, 0x6204},
  {"\x43", 0, 0x6207},
  {"\x44", 0, 0x6209},
  {"\x47", 0, 0x6214},
  {"\x56", 0, 0x6223},
  {"\x5B", 0, 0x6225},
  {"\x5D", 0, 0x6224},
  {"\x61", 0, 0x6229},
  {"\x67", 0, 0x622D},
  {"\x69", 0, 0x97EF},
  {"\x6E", 0, 0x6239},
  {"\x6F", 0, 0x623A},
  {"\x70", 0, 0x623D},
  {"\x75", 0, 0x6243},
  {"\x77", 0, 0x6246},
  {"\x78", 0, 0x6245},
  {"\x79", 0, 0x624A},
  {"\x7A", 0, 0x6250},
  {"\x7C", 0, 0x625E},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page96 = {
  marc8_9page96_flat, 0
};
/* PAGE 95 */
struct yaz_iconv_trie_flat marc8_9page95_flat[] = {
  {"\x23", 0, 0x618B},
  {"\x2C", 0, 0x616F},
  {"\x2D", 0, 0x6165},
  {"\x2F", 0, 0x615C},
  {"\x32", 0, 0x619D},
  {"\x33", 0, 0x61A6},
  {"\x3D", 0, 0x61A2},
  {"\x40", 0, 0x61A8},
  {"\x42", 0, 0x619C},
  {"\x43", 0, 0x61AF},
  {"\x45", 0, 0x6196},
  {"\x46", 0, 0x6197},
  {"\x47", 0, 0x61AD},
  {"\x4C", 0, 0x6192},
  {"\x52", 0, 0x61AE},
  {"\x55", 0, 0x618D},
  {"\x5A", 0, 0x61CB},
  {"\x5C", 0, 0x61CC},
  {"\x5D", 0, 0x61C6},
  {"\x68", 0, 0x61BA},
  {"\x6A", 0, 0x61B8},
  {"\x71", 0, 0x61E0},
  {"\x77", 0, 0x61E5},
  {"\x7D", 0, 0x61DC},
  {"\x7E", 0, 0x61DF},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page95 = {
  marc8_9page95_flat, 0
};
/* PAGE 94 */
struct yaz_iconv_trie_flat marc8_9page94_flat[] = {
  {"\x2A", 0, 0x610A},
  {"\x2C", 0, 0x6110},
  {"\x32", 0, 0x6112},
  {"\x34", 0, 0x60F2},
  {"\x37", 0, 0x6125},
  {"\x3B", 0, 0x60F8},
  {"\x3F", 0, 0x6121},
  {"\x41", 0, 0x60FC},
  {"\x43", 0, 0x6106},
  {"\x48", 0, 0x6149},
  {"\x4A", 0, 0x614A},
  {"\x4E", 0, 0x612B},
  {"\x50", 0, 0x6129},
  {"\x51", 0, 0x6150},
  {"\x56", 0, 0x53AF},
  {"\x58", 0, 0x6130},
  {"\x5B", 0, 0x6141},
  {"\x5E", 0, 0x6137},
  {"\x61", 0, 0x6146},
  {"\x66", 0, 0x615E},
  {"\x67", 0, 0x6175},
  {"\x68", 0, 0x6174},
  {"\x6B", 0, 0x6183},
  {"\x70", 0, 0x6171},
  {"\x74", 0, 0x616A},
  {"\x77", 0, 0x6173},
  {"\x79", 0, 0x6164},
  {"\x7B", 0, 0x6153},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page94 = {
  marc8_9page94_flat, 0
};
/* PAGE 93 */
struct yaz_iconv_trie_flat marc8_9page93_flat[] = {
  {"\x24", 0, 0x608A},
  {"\x2B", 0, 0x6092},
  {"\x2C", 0, 0x609D},
  {"\x2D", 0, 0x6081},
  {"\x2F", 0, 0x609E},
  {"\x30", 0, 0x6083},
  {"\x32", 0, 0x6097},
  {"\x34", 0, 0x60A7},
  {"\x3A", 0, 0x6095},
  {"\x3E", 0, 0x60C7},
  {"\x42", 0, 0x60B0},
  {"\x46", 0, 0x60BE},
  {"\x47", 0, 0x60D3},
  {"\x48", 0, 0x60D4},
  {"\x4E", 0, 0x60CE},
  {"\x51", 0, 0x60CF},
  {"\x53", 0, 0x60D9},
  {"\x54", 0, 0x60B3},
  {"\x56", 0, 0x60DD},
  {"\x5D", 0, 0x60C4},
  {"\x60", 0, 0x60B1},
  {"\x62", 0, 0x60E3},
  {"\x66", 0, 0x60E2},
  {"\x67", 0, 0x60E5},
  {"\x69", 0, 0x60DB},
  {"\x6E", 0, 0x60E9},
  {"\x70", 0, 0x6114},
  {"\x73", 0, 0x6103},
  {"\x75", 0, 0x6119},
  {"\x7C", 0, 0x60FD},
  {"\x7D", 0, 0x610D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page93 = {
  marc8_9page93_flat, 0
};
/* PAGE 92 */
struct yaz_iconv_trie_flat marc8_9page92_flat[] = {
  {"\x24", 0, 0x5FEA},
  {"\x2A", 0, 0x6026},
  {"\x2C", 0, 0x6029},
  {"\x2D", 0, 0x602B},
  {"\x30", 0, 0x6019},
  {"\x31", 0, 0x6008},
  {"\x36", 0, 0x600A},
  {"\x37", 0, 0x600C},
  {"\x38", 0, 0x601B},
  {"\x3C", 0, 0x6017},
  {"\x3D", 0, 0x6033},
  {"\x45", 0, 0x600D},
  {"\x46", 0, 0x6010},
  {"\x4B", 0, 0x6039},
  {"\x50", 0, 0x6013},
  {"\x53", 0, 0x6054},
  {"\x57", 0, 0x605D},
  {"\x5A", 0, 0x6047},
  {"\x5E", 0, 0x6049},
  {"\x5F", 0, 0x6053},
  {"\x68", 0, 0x6067},
  {"\x6F", 0, 0x604C},
  {"\x71", 0, 0x6041},
  {"\x72", 0, 0x6077},
  {"\x74", 0, 0x6042},
  {"\x76", 0, 0x605F},
  {"\x7A", 0, 0x6061},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page92 = {
  marc8_9page92_flat, 0
};
/* PAGE 91 */
struct yaz_iconv_trie_flat marc8_9page91_flat[] = {
  {"\x23", 0, 0x5F82},
  {"\x27", 0, 0x5F89},
  {"\x2B", 0, 0x5F94},
  {"\x34", 0, 0xEA02},
  {"\x39", 0, 0x5F9C},
  {"\x3D", 0, 0x5F9A},
  {"\x46", 0, 0x5FAF},
  {"\x50", 0, 0x5FBC},
  {"\x57", 0, 0x5FC9},
  {"\x5F", 0, 0x5FD1},
  {"\x61", 0, 0x5FD2},
  {"\x63", 0, 0x5FD0},
  {"\x67", 0, 0x5FCE},
  {"\x68", 0, 0x5FED},
  {"\x72", 0, 0x5FEE},
  {"\x73", 0, 0x5FF8},
  {"\x78", 0, 0x5FE1},
  {"\x7B", 0, 0x5FE4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page91 = {
  marc8_9page91_flat, 0
};
/* PAGE 90 */
struct yaz_iconv_trie_flat marc8_9page90_flat[] = {
  {"\x21", 0, 0x5EF1},
  {"\x23", 0, 0x5EF4},
  {"\x35", 0, 0x5F07},
  {"\x3A", 0, 0x5F0B},
  {"\x4A", 0, 0x5F28},
  {"\x4B", 0, 0x5F22},
  {"\x4C", 0, 0x5F23},
  {"\x4D", 0, 0x5F24},
  {"\x51", 0, 0x5F33},
  {"\x52", 0, 0x5F30},
  {"\x58", 0, 0x5F38},
  {"\x5C", 0, 0x5F40},
  {"\x5F", 0, 0x5F44},
  {"\x62", 0, 0x5F4D},
  {"\x68", 0, 0x5F50},
  {"\x69", 0, 0x5F54},
  {"\x6A", 0, 0x5F56},
  {"\x6C", 0, 0x5F58},
  {"\x70", 0, 0x5F60},
  {"\x71", 0, 0x5F61},
  {"\x72", 0, 0x5F63},
  {"\x73", 0, 0x809C},
  {"\x74", 0, 0x5F67},
  {"\x78", 0, 0x5F72},
  {"\x79", 0, 0x5F73},
  {"\x7C", 0, 0x5F74},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page90 = {
  marc8_9page90_flat, 0
};
/* PAGE 89 */
struct yaz_iconv_trie_flat marc8_9page89_flat[] = {
  {"\x2F", 0, 0x5EA4},
  {"\x35", 0, 0x5EA5},
  {"\x36", 0, 0x5EAF},
  {"\x42", 0, 0x5EB9},
  {"\x4B", 0, 0x5EB3},
  {"\x4C", 0, 0x5EC4},
  {"\x51", 0, 0x5ECC},
  {"\x55", 0, 0x5ECB},
  {"\x57", 0, 0x5ECD},
  {"\x5A", 0, 0x5ED2},
  {"\x5B", 0, 0x5ED1},
  {"\x5C", 0, 0x5ED5},
  {"\x5F", 0, 0x5ED4},
  {"\x60", 0, 0x5ED9},
  {"\x61", 0, 0x5ECE},
  {"\x68", 0, 0x5EE1},
  {"\x6D", 0, 0x5EE7},
  {"\x71", 0, 0x5EE8},
  {"\x7C", 0, 0x5EED},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page89 = {
  marc8_9page89_flat, 0
};
/* PAGE 88 */
struct yaz_iconv_trie_flat marc8_9page88_flat[] = {
  {"\x22", 0, 0x5E22},
  {"\x24", 0, 0x5E28},
  {"\x35", 0, 0x5E44},
  {"\x36", 0, 0x5E43},
  {"\x39", 0, 0x5E42},
  {"\x3F", 0, 0x5E4E},
  {"\x47", 0, 0x5E58},
  {"\x48", 0, 0x5E48},
  {"\x57", 0, 0x5E5E},
  {"\x58", 0, 0x5E61},
  {"\x5D", 0, 0x5E68},
  {"\x5F", 0, 0x5E6C},
  {"\x60", 0, 0x5E6A},
  {"\x63", 0, 0x5E6E},
  {"\x64", 0, 0x5E6D},
  {"\x65", 0, 0x5E70},
  {"\x6D", 0, 0x5E75},
  {"\x77", 0, 0x5E80},
  {"\x7E", 0, 0x5E8B},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page88 = {
  marc8_9page88_flat, 0
};
/* PAGE 87 */
struct yaz_iconv_trie_flat marc8_9page87_flat[] = {
  {"\x26", 0, 0x5DA7},
  {"\x2A", 0, 0x5DB0},
  {"\x2E", 0, 0x5DB4},
  {"\x2F", 0, 0x5DAE},
  {"\x30", 0, 0x5DB6},
  {"\x32", 0, 0x5DB8},
  {"\x34", 0, 0x5DBF},
  {"\x36", 0, 0x5DB7},
  {"\x3E", 0, 0x5DC3},
  {"\x44", 0, 0x5DC7},
  {"\x46", 0, 0x5DC9},
  {"\x47", 0, 0x5DCB},
  {"\x4E", 0, 0x5DD8},
  {"\x50", 0, 0x5DDB},
  {"\x52", 0, 0x5DDC},
  {"\x56", 0, 0x5DE4},
  {"\x62", 0, 0x5E00},
  {"\x64", 0, 0x51E7},
  {"\x72", 0, 0x5E14},
  {"\x73", 0, 0x5E17},
  {"\x76", 0, 0x5E19},
  {"\x77", 0, 0x5E12},
  {"\x78", 0, 0x5E1F},
  {"\x7A", 0, 0x5E23},
  {"\x7B", 0, 0x5E21},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page87 = {
  marc8_9page87_flat, 0
};
/* PAGE 86 */
struct yaz_iconv_trie_flat marc8_9page86_flat[] = {
  {"\x25", 0, 0x5D3F},
  {"\x26", 0, 0x5D52},
  {"\x27", 0, 0x5D3D},
  {"\x28", 0, 0x5D4E},
  {"\x2C", 0, 0x5D59},
  {"\x2D", 0, 0x5D47},
  {"\x2F", 0, 0x5D32},
  {"\x31", 0, 0x5D42},
  {"\x34", 0, 0x5D74},
  {"\x39", 0, 0x5D6F},
  {"\x3A", 0, 0x5D6B},
  {"\x3F", 0, 0x5D75},
  {"\x44", 0, 0x5D4A},
  {"\x49", 0, 0x5D6C},
  {"\x4A", 0, 0x5D62},
  {"\x4D", 0, 0x5D82},
  {"\x50", 0, 0x5D79},
  {"\x51", 0, 0x5D8E},
  {"\x5A", 0, 0x5D81},
  {"\x60", 0, 0x5D7E},
  {"\x66", 0, 0x5D92},
  {"\x68", 0, 0x5D99},
  {"\x69", 0, 0x5D97},
  {"\x6A", 0, 0x5DA2},
  {"\x73", 0, 0x5DA1},
  {"\x75", 0, 0x5D93},
  {"\x77", 0, 0x5DA0},
  {"\x7B", 0, 0x5D94},
  {"\x7E", 0, 0x5DAC},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page86 = {
  marc8_9page86_flat, 0
};
/* PAGE 85 */
struct yaz_iconv_trie_flat marc8_9page85_flat[] = {
  {"\x26", 0, 0x5CE0},
  {"\x28", 0, 0x5CD2},
  {"\x29", 0, 0x5CDD},
  {"\x2B", 0, 0x5CCB},
  {"\x30", 0, 0x5CC7},
  {"\x31", 0, 0x5CDC},
  {"\x34", 0, 0x5D00},
  {"\x34", 0, 0x5D00},
  {"\x3B", 0, 0x5CFF},
  {"\x3C", 0, 0x5CEB},
  {"\x41", 0, 0x5CF4},
  {"\x46", 0, 0x5CF1},
  {"\x49", 0, 0x5D1E},
  {"\x4A", 0, 0x5D12},
  {"\x50", 0, 0x5D1A},
  {"\x52", 0, 0x5D0C},
  {"\x53", 0, 0x5D20},
  {"\x54", 0, 0x5D21},
  {"\x57", 0, 0x5D27},
  {"\x58", 0, 0x5D0D},
  {"\x5A", 0, 0x5D26},
  {"\x5D", 0, 0x5D2E},
  {"\x69", 0, 0x5D24},
  {"\x71", 0, 0x5D36},
  {"\x72", 0, 0x5D3E},
  {"\x74", 0, 0x5D4B},
  {"\x76", 0, 0x5D57},
  {"\x77", 0, 0x5D34},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page85 = {
  marc8_9page85_flat, 0
};
/* PAGE 84 */
struct yaz_iconv_trie_flat marc8_9page84_flat[] = {
  {"\x23", 0, 0x5C63},
  {"\x29", 0, 0x5C67},
  {"\x2B", 0, 0x5C68},
  {"\x30", 0, 0x5C6D},
  {"\x31", 0, 0x5C6E},
  {"\x37", 0, 0x5C74},
  {"\x39", 0, 0x5C73},
  {"\x3B", 0, 0x5C77},
  {"\x3C", 0, 0x5C7A},
  {"\x40", 0, 0x5C7C},
  {"\x46", 0, 0x5C8F},
  {"\x49", 0, 0x5C88},
  {"\x4B", 0, 0x5C8D},
  {"\x4D", 0, 0x5C99},
  {"\x55", 0, 0x5CA6},
  {"\x57", 0, 0x5CA0},
  {"\x5C", 0, 0x5CA2},
  {"\x60", 0, 0x5CB5},
  {"\x61", 0, 0x5CA7},
  {"\x66", 0, 0x5CA8},
  {"\x67", 0, 0x5CAC},
  {"\x6B", 0, 0x5CA3},
  {"\x6C", 0, 0x5CB6},
  {"\x6D", 0, 0x5CC1},
  {"\x6F", 0, 0x5CAD},
  {"\x70", 0, 0x5CD5},
  {"\x78", 0, 0x5CD3},
  {"\x79", 0, 0xE9E7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page84 = {
  marc8_9page84_flat, 0
};
/* PAGE 83 */
struct yaz_iconv_trie_flat marc8_9page83_flat[] = {
  {"\x24", 0, 0x5BF0},
  {"\x25", 0, 0x5BEF},
  {"\x33", 0, 0x5C00},
  {"\x35", 0, 0x5C57},
  {"\x3C", 0, 0x5C15},
  {"\x46", 0, 0x5C22},
  {"\x48", 0, 0x5C25},
  {"\x4B", 0, 0x5C2A},
  {"\x52", 0, 0x5C2F},
  {"\x5B", 0, 0x5C32},
  {"\x63", 0, 0x5C3B},
  {"\x65", 0, 0x5C44},
  {"\x67", 0, 0x5C49},
  {"\x79", 0, 0x5C59},
  {"\x7B", 0, 0x5C5D},
  {"\x7C", 0, 0x5C5F},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page83 = {
  marc8_9page83_flat, 0
};
/* PAGE 82 */
struct yaz_iconv_trie_dir marc8_9page82_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {83, 0, 0} /* 22 */,
  {84, 0, 0} /* 23 */,
  {85, 0, 0} /* 24 */,
  {86, 0, 0} /* 25 */,
  {87, 0, 0} /* 26 */,
  {88, 0, 0} /* 27 */,
  {89, 0, 0} /* 28 */,
  {90, 0, 0} /* 29 */,
  {91, 0, 0} /* 2A */,
  {92, 0, 0} /* 2B */,
  {93, 0, 0} /* 2C */,
  {94, 0, 0} /* 2D */,
  {95, 0, 0} /* 2E */,
  {96, 0, 0} /* 2F */,
  {97, 0, 0} /* 30 */,
  {98, 0, 0} /* 31 */,
  {99, 0, 0} /* 32 */,
  {100, 0, 0} /* 33 */,
  {101, 0, 0} /* 34 */,
  {102, 0, 0} /* 35 */,
  {103, 0, 0} /* 36 */,
  {104, 0, 0} /* 37 */,
  {105, 0, 0} /* 38 */,
  {106, 0, 0} /* 39 */,
  {107, 0, 0} /* 3A */,
  {108, 0, 0} /* 3B */,
  {109, 0, 0} /* 3C */,
  {110, 0, 0} /* 3D */,
  {111, 0, 0} /* 3E */,
  {112, 0, 0} /* 3F */,
  {113, 0, 0} /* 40 */,
  {114, 0, 0} /* 41 */,
  {115, 0, 0} /* 42 */,
  {116, 0, 0} /* 43 */,
  {117, 0, 0} /* 44 */,
  {118, 0, 0} /* 45 */,
  {119, 0, 0} /* 46 */,
  {120, 0, 0} /* 47 */,
  {121, 0, 0} /* 48 */,
  {122, 0, 0} /* 49 */,
  {123, 0, 0} /* 4A */,
  {124, 0, 0} /* 4B */,
  {125, 0, 0} /* 4C */,
  {126, 0, 0} /* 4D */,
  {127, 0, 0} /* 4E */,
  {128, 0, 0} /* 4F */,
  {129, 0, 0} /* 50 */,
  {130, 0, 0} /* 51 */,
  {131, 0, 0} /* 52 */,
  {132, 0, 0} /* 53 */,
  {133, 0, 0} /* 54 */,
  {134, 0, 0} /* 55 */,
  {135, 0, 0} /* 56 */,
  {136, 0, 0} /* 57 */,
  {137, 0, 0} /* 58 */,
  {138, 0, 0} /* 59 */,
  {139, 0, 0} /* 5A */,
  {140, 0, 0} /* 5B */,
  {141, 0, 0} /* 5C */,
  {142, 0, 0} /* 5D */,
  {143, 0, 0} /* 5E */,
  {144, 0, 0} /* 5F */,
  {145, 0, 0} /* 60 */,
  {146, 0, 0} /* 61 */,
  {147, 0, 0} /* 62 */,
  {148, 0, 0} /* 63 */,
  {149, 0, 0} /* 64 */,
  {150, 0, 0} /* 65 */,
  {151, 0, 0} /* 66 */,
  {152, 0, 0} /* 67 */,
  {153, 0, 0} /* 68 */,
  {154, 0, 0} /* 69 */,
  {155, 0, 0} /* 6A */,
  {156, 0, 0} /* 6B */,
  {157, 0, 0} /* 6C */,
  {158, 0, 0} /* 6D */,
  {159, 0, 0} /* 6E */,
  {160, 0, 0} /* 6F */,
  {161, 0, 0} /* 70 */,
  {162, 0, 0} /* 71 */,
  {163, 0, 0} /* 72 */,
  {164, 0, 0} /* 73 */,
  {165, 0, 0} /* 74 */,
  {166, 0, 0} /* 75 */,
  {167, 0, 0} /* 76 */,
  {168, 0, 0} /* 77 */,
  {169, 0, 0} /* 78 */,
  {170, 0, 0} /* 79 */,
  {171, 0, 0} /* 7A */,
  {172, 0, 0} /* 7B */,
  {173, 0, 0} /* 7C */,
  {174, 0, 0} /* 7D */,
  {175, 0, 0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page82 = {
  0, marc8_9page82_dir
};
/* PAGE 81 */
struct yaz_iconv_trie_flat marc8_9page81_flat[] = {
  {"\x21", 0, 0x5B5B},
  {"\x23", 0, 0x5B62},
  {"\x24", 0, 0x5B65},
  {"\x25", 0, 0x5B67},
  {"\x27", 0, 0xE9E5},
  {"\x28", 0, 0x5B6C},
  {"\x2A", 0, 0x5B6E},
  {"\x30", 0, 0x5B7B},
  {"\x31", 0, 0x5B7C},
  {"\x32", 0, 0x5B80},
  {"\x34", 0, 0x5B84},
  {"\x35", 0, 0xE9E6},
  {"\x40", 0, 0x5B95},
  {"\x43", 0, 0x5B93},
  {"\x49", 0, 0x5BAC},
  {"\x52", 0, 0x5BA7},
  {"\x55", 0, 0x5BB7},
  {"\x59", 0, 0x5BC1},
  {"\x5B", 0, 0xEA01},
  {"\x60", 0, 0x5BC9},
  {"\x68", 0, 0x5BD4},
  {"\x6A", 0, 0x5BC3},
  {"\x6E", 0, 0x5BD6},
  {"\x75", 0, 0x5BD7},
  {"\x79", 0, 0x5BE0},
  {"\x7E", 0, 0x5BEA},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page81 = {
  marc8_9page81_flat, 0
};
/* PAGE 80 */
struct yaz_iconv_trie_flat marc8_9page80_flat[] = {
  {"\x26", 0, 0x5AFF},
  {"\x2A", 0, 0x5AFD},
  {"\x2B", 0, 0x5B08},
  {"\x2E", 0, 0x5B0D},
  {"\x38", 0, 0x5B03},
  {"\x3D", 0, 0x5B17},
  {"\x3E", 0, 0x5B16},
  {"\x40", 0, 0x5B19},
  {"\x47", 0, 0x5B1B},
  {"\x48", 0, 0x5B21},
  {"\x52", 0, 0x5B2C},
  {"\x59", 0, 0x5B32},
  {"\x63", 0, 0x5B3F},
  {"\x6E", 0, 0x5B45},
  {"\x74", 0, 0x5B4C},
  {"\x76", 0, 0x5B4B},
  {"\x7C", 0, 0x5B56},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page80 = {
  marc8_9page80_flat, 0
};
/* PAGE 79 */
struct yaz_iconv_trie_flat marc8_9page79_flat[] = {
  {"\x21", 0, 0x5AA6},
  {"\x22", 0, 0x5A8C},
  {"\x24", 0, 0x5AA7},
  {"\x25", 0, 0x5A9E},
  {"\x26", 0, 0x5AA2},
  {"\x27", 0, 0x5A9C},
  {"\x28", 0, 0x5A7C},
  {"\x29", 0, 0x5A96},
  {"\x30", 0, 0x5A93},
  {"\x31", 0, 0x5AAC},
  {"\x34", 0, 0x5AAE},
  {"\x35", 0, 0x5A95},
  {"\x36", 0, 0x5AAF},
  {"\x39", 0, 0x5AC8},
  {"\x3E", 0, 0x5AB5},
  {"\x41", 0, 0x5AC4},
  {"\x45", 0, 0x5AB7},
  {"\x49", 0, 0x5AD1},
  {"\x4A", 0, 0x5A90},
  {"\x4F", 0, 0x5AB8},
  {"\x50", 0, 0x5ABA},
  {"\x52", 0, 0x5AAA},
  {"\x59", 0, 0x5AD3},
  {"\x5B", 0, 0x5AB1},
  {"\x60", 0, 0x5ADC},
  {"\x6D", 0, 0x5AE5},
  {"\x6E", 0, 0x5AE0},
  {"\x72", 0, 0x5AEA},
  {"\x7B", 0, 0x5ADA},
  {"\x7C", 0, 0x5AEB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page79 = {
  marc8_9page79_flat, 0
};
/* PAGE 78 */
struct yaz_iconv_trie_flat marc8_9page78_flat[] = {
  {"\x2C", 0, 0x5A60},
  {"\x31", 0, 0x5A67},
  {"\x3A", 0, 0x5A38},
  {"\x3B", 0, 0x5A5E},
  {"\x3C", 0, 0x5A6D},
  {"\x3D", 0, 0x5A35},
  {"\x3E", 0, 0x5A55},
  {"\x41", 0, 0x5A2C},
  {"\x48", 0, 0x5A50},
  {"\x49", 0, 0x5A65},
  {"\x52", 0, 0x5A64},
  {"\x65", 0, 0x5A8A},
  {"\x69", 0, 0x5ACF},
  {"\x6A", 0, 0x5A7A},
  {"\x71", 0, 0x5A9F},
  {"\x75", 0, 0x5AA0},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page78 = {
  marc8_9page78_flat, 0
};
/* PAGE 77 */
struct yaz_iconv_trie_flat marc8_9page77_flat[] = {
  {"\x21", 0, 0x5990},
  {"\x24", 0, 0x59C5},
  {"\x25", 0, 0x59B5},
  {"\x28", 0, 0x59CF},
  {"\x2A", 0, 0x59BA},
  {"\x2C", 0, 0x59B8},
  {"\x35", 0, 0x59B2},
  {"\x3A", 0, 0x59B7},
  {"\x3E", 0, 0x59C1},
  {"\x43", 0, 0x59F9},
  {"\x44", 0, 0x59F8},
  {"\x4F", 0, 0x59EE},
  {"\x50", 0, 0x59F1},
  {"\x51", 0, 0x5A00},
  {"\x52", 0, 0x59DE},
  {"\x56", 0, 0x59FD},
  {"\x5D", 0, 0x59F6},
  {"\x5E", 0, 0x59DD},
  {"\x5F", 0, 0x59FA},
  {"\x61", 0, 0x59E4},
  {"\x6E", 0, 0x5A2A},
  {"\x75", 0, 0x5A16},
  {"\x78", 0, 0x5A09},
  {"\x7E", 0, 0x5A12},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page77 = {
  marc8_9page77_flat, 0
};
/* PAGE 76 */
struct yaz_iconv_trie_flat marc8_9page76_flat[] = {
  {"\x28", 0, 0x592C},
  {"\x2B", 0, 0x592F},
  {"\x30", 0, 0x593C},
  {"\x33", 0, 0x5940},
  {"\x38", 0, 0x594D},
  {"\x43", 0, 0x5953},
  {"\x4B", 0, 0x595C},
  {"\x4F", 0, 0x5961},
  {"\x54", 0, 0x596C},
  {"\x55", 0, 0x596D},
  {"\x65", 0, 0x597C},
  {"\x69", 0, 0x59A7},
  {"\x6B", 0, 0x5998},
  {"\x6F", 0, 0x599A},
  {"\x71", 0, 0x59A0},
  {"\x7C", 0, 0x5997},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page76 = {
  marc8_9page76_flat, 0
};
/* PAGE 75 */
struct yaz_iconv_trie_flat marc8_9page75_flat[] = {
  {"\x24", 0, 0x58B1},
  {"\x2B", 0, 0x58AD},
  {"\x2E", 0, 0x58A0},
  {"\x30", 0, 0x58A3},
  {"\x32", 0, 0x58A6},
  {"\x3A", 0, 0x58C8},
  {"\x41", 0, 0x58BC},
  {"\x49", 0, 0x58BF},
  {"\x4B", 0, 0x58C6},
  {"\x4C", 0, 0x58BA},
  {"\x50", 0, 0x58D6},
  {"\x54", 0, 0x58D2},
  {"\x56", 0, 0x58CE},
  {"\x5A", 0, 0x58E0},
  {"\x5E", 0, 0x58DA},
  {"\x6C", 0, 0x58FC},
  {"\x70", 0, 0x5902},
  {"\x73", 0, 0x5906},
  {"\x74", 0, 0x6535},
  {"\x7A", 0, 0x5910},
  {"\x7C", 0, 0x8641},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page75 = {
  marc8_9page75_flat, 0
};
/* PAGE 74 */
struct yaz_iconv_trie_flat marc8_9page74_flat[] = {
  {"\x21", 0, 0x5848},
  {"\x23", 0, 0x5818},
  {"\x26", 0, 0x57F5},
  {"\x29", 0, 0x582D},
  {"\x2B", 0, 0x5820},
  {"\x30", 0, 0x584E},
  {"\x33", 0, 0x585D},
  {"\x35", 0, 0x5859},
  {"\x37", 0, 0x584B},
  {"\x3D", 0, 0x5865},
  {"\x40", 0, 0x586C},
  {"\x42", 0, 0x5852},
  {"\x45", 0, 0x5864},
  {"\x47", 0, 0x5853},
  {"\x48", 0, 0x584F},
  {"\x49", 0, 0x583D},
  {"\x4D", 0, 0x584D},
  {"\x4E", 0, 0x5856},
  {"\x55", 0, 0x589A},
  {"\x58", 0, 0x5892},
  {"\x5A", 0, 0x588E},
  {"\x5C", 0, 0x5889},
  {"\x5F", 0, 0x5840},
  {"\x60", 0, 0x589B},
  {"\x61", 0, 0x587C},
  {"\x63", 0, 0x5888},
  {"\x65", 0, 0x5890},
  {"\x68", 0, 0x5898},
  {"\x6B", 0, 0x587D},
  {"\x6F", 0, 0x587F},
  {"\x70", 0, 0x5881},
  {"\x7B", 0, 0x58A9},
  {"\x7E", 0, 0x58A1},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page74 = {
  marc8_9page74_flat, 0
};
/* PAGE 73 */
struct yaz_iconv_trie_flat marc8_9page73_flat[] = {
  {"\x22", 0, 0x57C4},
  {"\x27", 0, 0x70FE},
  {"\x29", 0, 0x57E3},
  {"\x2A", 0, 0x57FB},
  {"\x2B", 0, 0x5803},
  {"\x2C", 0, 0x57F6},
  {"\x2D", 0, 0x57E6},
  {"\x31", 0, 0x57ED},
  {"\x33", 0, 0x5800},
  {"\x35", 0, 0x57EC},
  {"\x36", 0, 0x5807},
  {"\x39", 0, 0x580E},
  {"\x3B", 0, 0x580F},
  {"\x3D", 0, 0x57F4},
  {"\x3E", 0, 0x5810},
  {"\x40", 0, 0x580D},
  {"\x43", 0, 0x57EF},
  {"\x48", 0, 0x5801},
  {"\x49", 0, 0x5812},
  {"\x4D", 0, 0x57FD},
  {"\x4E", 0, 0x57F8},
  {"\x50", 0, 0x580C},
  {"\x51", 0, 0x5813},
  {"\x52", 0, 0x57F0},
  {"\x56", 0, 0x580B},
  {"\x58", 0, 0x57F3},
  {"\x59", 0, 0x5804},
  {"\x5A", 0, 0x57CF},
  {"\x5B", 0, 0x57DD},
  {"\x5F", 0, 0x5847},
  {"\x67", 0, 0x581B},
  {"\x69", 0, 0x5819},
  {"\x6A", 0, 0x5833},
  {"\x6C", 0, 0x581E},
  {"\x6D", 0, 0x583F},
  {"\x71", 0, 0x5827},
  {"\x76", 0, 0x5828},
  {"\x78", 0, 0x582E},
  {"\x7A", 0, 0x581D},
  {"\x7D", 0, 0x5844},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page73 = {
  marc8_9page73_flat, 0
};
/* PAGE 72 */
struct yaz_iconv_trie_flat marc8_9page72_flat[] = {
  {"\x26", 0, 0x5770},
  {"\x28", 0, 0x5771},
  {"\x2A", 0, 0x576E},
  {"\x2D", 0, 0x5776},
  {"\x2E", 0, 0x5789},
  {"\x30", 0, 0x577F},
  {"\x31", 0, 0x5775},
  {"\x32", 0, 0x577B},
  {"\x33", 0, 0x5788},
  {"\x35", 0, 0x5773},
  {"\x38", 0, 0x579F},
  {"\x39", 0, 0x5790},
  {"\x3A", 0, 0x5793},
  {"\x3F", 0, 0x579E},
  {"\x40", 0, 0x57B5},
  {"\x43", 0, 0x579A},
  {"\x45", 0, 0x5794},
  {"\x47", 0, 0x57A4},
  {"\x48", 0, 0x5799},
  {"\x49", 0, 0x578C},
  {"\x4B", 0, 0x5797},
  {"\x4E", 0, 0x579D},
  {"\x52", 0, 0x579C},
  {"\x54", 0, 0x57A7},
  {"\x57", 0, 0x57A1},
  {"\x59", 0, 0xEA00},
  {"\x5B", 0, 0x5795},
  {"\x5F", 0, 0x57B8},
  {"\x60", 0, 0x57C7},
  {"\x6A", 0, 0x5809},
  {"\x6C", 0, 0x57BE},
  {"\x71", 0, 0x57DB},
  {"\x73", 0, 0x57D5},
  {"\x77", 0, 0x57D2},
  {"\x7E", 0, 0x57C6},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page72 = {
  marc8_9page72_flat, 0
};
/* PAGE 71 */
struct yaz_iconv_trie_flat marc8_9page71_flat[] = {
  {"\x21", 0, 0x56F9},
  {"\x24", 0, 0x56FF},
  {"\x27", 0, 0x5705},
  {"\x28", 0, 0x5704},
  {"\x29", 0, 0x5702},
  {"\x2C", 0, 0x570A},
  {"\x2D", 0, 0x5709},
  {"\x2E", 0, 0x5707},
  {"\x30", 0, 0x570C},
  {"\x31", 0, 0x5715},
  {"\x32", 0, 0x5714},
  {"\x35", 0, 0x571A},
  {"\x36", 0, 0x571B},
  {"\x37", 0, 0x571C},
  {"\x39", 0, 0x571D},
  {"\x3A", 0, 0x571E},
  {"\x41", 0, 0x5724},
  {"\x42", 0, 0x572E},
  {"\x43", 0, 0x5729},
  {"\x48", 0, 0x5738},
  {"\x4C", 0, 0x572A},
  {"\x63", 0, 0x5749},
  {"\x65", 0, 0x5745},
  {"\x68", 0, 0x574B},
  {"\x69", 0, 0x574C},
  {"\x6A", 0, 0x573F},
  {"\x70", 0, 0x5768},
  {"\x75", 0, 0x578A},
  {"\x77", 0, 0x576D},
  {"\x79", 0, 0x5774},
  {"\x7A", 0, 0x5767},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page71 = {
  marc8_9page71_flat, 0
};
/* PAGE 70 */
struct yaz_iconv_trie_flat marc8_9page70_flat[] = {
  {"\x25", 0, 0x5693},
  {"\x28", 0, 0x568C},
  {"\x32", 0, 0x56BA},
  {"\x34", 0, 0x5686},
  {"\x35", 0, 0x5684},
  {"\x36", 0, 0x5691},
  {"\x37", 0, 0x568A},
  {"\x3E", 0, 0x569E},
  {"\x41", 0, 0x569C},
  {"\x42", 0, 0x569A},
  {"\x45", 0, 0x5699},
  {"\x4B", 0, 0x56AD},
  {"\x4C", 0, 0x56A6},
  {"\x4E", 0, 0x56AC},
  {"\x53", 0, 0x56B2},
  {"\x5A", 0, 0x56B3},
  {"\x5B", 0, 0x56C3},
  {"\x60", 0, 0x56C5},
  {"\x62", 0, 0x56CF},
  {"\x67", 0, 0x56CD},
  {"\x6A", 0, 0x56D4},
  {"\x6B", 0, 0x56D7},
  {"\x6D", 0, 0x56DD},
  {"\x6F", 0, 0x56E1},
  {"\x70", 0, 0x56DF},
  {"\x75", 0, 0x56EB},
  {"\x76", 0, 0x56EE},
  {"\x77", 0, 0x56E7},
  {"\x79", 0, 0x56FB},
  {"\x7E", 0, 0x56F7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page70 = {
  marc8_9page70_flat, 0
};
/* PAGE 69 */
struct yaz_iconv_trie_flat marc8_9page69_flat[] = {
  {"\x24", 0, 0x55FB},
  {"\x25", 0, 0x5612},
  {"\x27", 0, 0x55F8},
  {"\x28", 0, 0x560F},
  {"\x2B", 0, 0x55F9},
  {"\x2E", 0, 0x561E},
  {"\x31", 0, 0x560C},
  {"\x34", 0, 0x561C},
  {"\x35", 0, 0x5610},
  {"\x36", 0, 0x5601},
  {"\x38", 0, 0x5613},
  {"\x39", 0, 0x55F6},
  {"\x3C", 0, 0x5602},
  {"\x42", 0, 0x561D},
  {"\x44", 0, 0x55FF},
  {"\x47", 0, 0x5642},
  {"\x48", 0, 0x564C},
  {"\x4B", 0, 0x564B},
  {"\x52", 0, 0x5640},
  {"\x55", 0, 0x5635},
  {"\x57", 0, 0x5649},
  {"\x58", 0, 0x5641},
  {"\x5C", 0, 0x5658},
  {"\x5D", 0, 0x5620},
  {"\x5E", 0, 0x5654},
  {"\x60", 0, 0x562A},
  {"\x61", 0, 0x563D},
  {"\x64", 0, 0x562C},
  {"\x67", 0, 0x5638},
  {"\x69", 0, 0x564D},
  {"\x6B", 0, 0x562B},
  {"\x6C", 0, 0x564F},
  {"\x6E", 0, 0x5670},
  {"\x6F", 0, 0x565F},
  {"\x70", 0, 0x567C},
  {"\x72", 0, 0x5660},
  {"\x78", 0, 0x5676},
  {"\x7A", 0, 0x5666},
  {"\x7B", 0, 0x5673},
  {"\x7C", 0, 0x566D},
  {"\x7E", 0, 0x5672},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page69 = {
  marc8_9page69_flat, 0
};
/* PAGE 68 */
struct yaz_iconv_trie_flat marc8_9page68_flat[] = {
  {"\x23", 0, 0x5591},
  {"\x25", 0, 0x5577},
  {"\x26", 0, 0x55A8},
  {"\x27", 0, 0x55AD},
  {"\x2A", 0, 0x5605},
  {"\x2D", 0, 0x5593},
  {"\x2F", 0, 0x5586},
  {"\x34", 0, 0x5588},
  {"\x36", 0, 0x55B4},
  {"\x43", 0, 0xE962},
  {"\x44", 0, 0x5581},
  {"\x45", 0, 0x558E},
  {"\x47", 0, 0x55B5},
  {"\x49", 0, 0x558F},
  {"\x4B", 0, 0x5559},
  {"\x50", 0, 0x55A4},
  {"\x51", 0, 0x5592},
  {"\x52", 0, 0x5599},
  {"\x56", 0, 0x55F4},
  {"\x58", 0, 0x55CC},
  {"\x59", 0, 0x55D0},
  {"\x5A", 0, 0x55DB},
  {"\x5B", 0, 0x55CD},
  {"\x5C", 0, 0x55DE},
  {"\x5D", 0, 0x55D9},
  {"\x5E", 0, 0x55C3},
  {"\x5F", 0, 0x55C9},
  {"\x61", 0, 0x55CA},
  {"\x62", 0, 0x55DD},
  {"\x64", 0, 0x55D4},
  {"\x65", 0, 0x55C4},
  {"\x69", 0, 0x55E9},
  {"\x6F", 0, 0x55CF},
  {"\x70", 0, 0x55D2},
  {"\x75", 0, 0x55E5},
  {"\x77", 0, 0x55D6},
  {"\x78", 0, 0x55C1},
  {"\x79", 0, 0x55F2},
  {"\x7E", 0, 0x5627},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page68 = {
  marc8_9page68_flat, 0
};
/* PAGE 67 */
struct yaz_iconv_trie_flat marc8_9page67_flat[] = {
  {"\x23", 0, 0x5517},
  {"\x24", 0, 0x54FD},
  {"\x25", 0, 0x54E7},
  {"\x27", 0, 0x54F3},
  {"\x2A", 0, 0x54E4},
  {"\x2B", 0, 0x550A},
  {"\x2D", 0, 0x54FF},
  {"\x2E", 0, 0x5518},
  {"\x30", 0, 0x5504},
  {"\x32", 0, 0x54EF},
  {"\x34", 0, 0x5508},
  {"\x38", 0, 0x54F6},
  {"\x39", 0, 0x54F7},
  {"\x3E", 0, 0x550E},
  {"\x44", 0, 0x5523},
  {"\x46", 0, 0x550F},
  {"\x47", 0, 0x5511},
  {"\x4B", 0, 0x5575},
  {"\x4D", 0, 0x5573},
  {"\x4E", 0, 0x554C},
  {"\x4F", 0, 0x5576},
  {"\x50", 0, 0x554D},
  {"\x51", 0, 0x555A},
  {"\x53", 0, 0x553C},
  {"\x55", 0, 0x5550},
  {"\x57", 0, 0x5539},
  {"\x58", 0, 0x5548},
  {"\x59", 0, 0x552D},
  {"\x5A", 0, 0x5551},
  {"\x5D", 0, 0x552A},
  {"\x60", 0, 0x5562},
  {"\x61", 0, 0x5536},
  {"\x64", 0, 0x5549},
  {"\x68", 0, 0x5530},
  {"\x6A", 0, 0x5540},
  {"\x6B", 0, 0x5535},
  {"\x70", 0, 0x5545},
  {"\x79", 0, 0x553F},
  {"\x7B", 0, 0x5541},
  {"\x7D", 0, 0x5565},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page67 = {
  marc8_9page67_flat, 0
};
/* PAGE 66 */
struct yaz_iconv_trie_flat marc8_9page66_flat[] = {
  {"\x21", 0, 0x544F},
  {"\x24", 0, 0x542A},
  {"\x26", 0, 0x5422},
  {"\x27", 0, 0x5423},
  {"\x2E", 0, 0x545F},
  {"\x2F", 0, 0x549C},
  {"\x35", 0, 0x5488},
  {"\x37", 0, 0x547F},
  {"\x39", 0, 0x5482},
  {"\x3A", 0, 0x546D},
  {"\x3B", 0, 0x5491},
  {"\x42", 0, 0x5494},
  {"\x43", 0, 0x546B},
  {"\x49", 0, 0x548D},
  {"\x4A", 0, 0x5463},
  {"\x4B", 0, 0x5474},
  {"\x52", 0, 0x5466},
  {"\x53", 0, 0x5464},
  {"\x55", 0, 0x54A4},
  {"\x58", 0, 0x54A1},
  {"\x5A", 0, 0x54AD},
  {"\x5B", 0, 0x54BA},
  {"\x5C", 0, 0x54CF},
  {"\x5E", 0, 0x54BE},
  {"\x60", 0, 0x54A5},
  {"\x63", 0, 0x54A7},
  {"\x64", 0, 0x54B5},
  {"\x66", 0, 0x54A2},
  {"\x67", 0, 0x5472},
  {"\x68", 0, 0x5470},
  {"\x69", 0, 0x54BC},
  {"\x6A", 0, 0x54B7},
  {"\x6B", 0, 0x54DE},
  {"\x6C", 0, 0x54D6},
  {"\x6D", 0, 0x54AE},
  {"\x71", 0, 0x54BF},
  {"\x74", 0, 0x54C6},
  {"\x7B", 0, 0x551A},
  {"\x7C", 0, 0x54E2},
  {"\x7D", 0, 0x5507},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page66 = {
  marc8_9page66_flat, 0
};
/* PAGE 65 */
struct yaz_iconv_trie_flat marc8_9page65_flat[] = {
  {"\x2C", 0, 0x53B5},
  {"\x2E", 0, 0x53B9},
  {"\x3E", 0, 0x53D0},
  {"\x48", 0, 0x53DA},
  {"\x57", 0, 0x53FB},
  {"\x58", 0, 0x535F},
  {"\x61", 0, 0x5414},
  {"\x68", 0, 0x5406},
  {"\x6C", 0, 0x544C},
  {"\x6D", 0, 0x5445},
  {"\x6F", 0, 0x541A},
  {"\x70", 0, 0x5432},
  {"\x76", 0, 0x5421},
  {"\x78", 0, 0x5430},
  {"\x79", 0, 0x5454},
  {"\x7D", 0, 0x543D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page65 = {
  marc8_9page65_flat, 0
};
/* PAGE 64 */
struct yaz_iconv_trie_flat marc8_9page64_flat[] = {
  {"\x23", 0, 0x531A},
  {"\x24", 0, 0x531C},
  {"\x25", 0, 0x531F},
  {"\x2E", 0, 0x532D},
  {"\x33", 0, 0x5330},
  {"\x36", 0, 0x5335},
  {"\x3A", 0, 0x5338},
  {"\x3E", 0, 0x533D},
  {"\x41", 0, 0x534C},
  {"\x42", 0, 0x534D},
  {"\x4B", 0, 0x535D},
  {"\x4C", 0, 0x5363},
  {"\x4E", 0, 0xE9E4},
  {"\x53", 0, 0x536C},
  {"\x57", 0, 0x5372},
  {"\x58", 0, 0x537A},
  {"\x5D", 0, 0x5380},
  {"\x64", 0, 0x538E},
  {"\x66", 0, 0x5393},
  {"\x67", 0, 0x5394},
  {"\x6D", 0, 0x5399},
  {"\x74", 0, 0x8652},
  {"\x7A", 0, 0x53A4},
  {"\x7B", 0, 0x53AB},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page64 = {
  marc8_9page64_flat, 0
};
/* PAGE 63 */
struct yaz_iconv_trie_flat marc8_9page63_flat[] = {
  {"\x21", 0, 0x5293},
  {"\x27", 0, 0x5296},
  {"\x29", 0, 0x5298},
  {"\x2B", 0, 0x529A},
  {"\x2C", 0, 0x5299},
  {"\x2E", 0, 0x52A6},
  {"\x31", 0, 0x52AD},
  {"\x33", 0, 0x52AE},
  {"\x37", 0, 0x52BB},
  {"\x38", 0, 0x52BC},
  {"\x3C", 0, 0x52CA},
  {"\x3D", 0, 0x52CD},
  {"\x40", 0, 0x52D0},
  {"\x41", 0, 0x52D1},
  {"\x46", 0, 0x52D4},
  {"\x48", 0, 0x52D6},
  {"\x4C", 0, 0x52E3},
  {"\x4E", 0, 0x52E1},
  {"\x50", 0, 0x55E7},
  {"\x53", 0, 0x52E9},
  {"\x58", 0, 0x52F0},
  {"\x5A", 0, 0x52F1},
  {"\x5E", 0, 0x52F7},
  {"\x61", 0, 0x52F9},
  {"\x62", 0, 0x52FA},
  {"\x64", 0, 0x52FC},
  {"\x69", 0, 0x5307},
  {"\x6A", 0, 0x5303},
  {"\x6B", 0, 0xE9E3},
  {"\x6E", 0, 0x530A},
  {"\x6F", 0, 0x530B},
  {"\x77", 0, 0x5311},
  {"\x7B", 0, 0x6706},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page63 = {
  marc8_9page63_flat, 0
};
/* PAGE 62 */
struct yaz_iconv_trie_flat marc8_9page62_flat[] = {
  {"\x24", 0, 0x5213},
  {"\x26", 0, 0x5216},
  {"\x2A", 0, 0x521C},
  {"\x33", 0, 0x5231},
  {"\x36", 0, 0x5235},
  {"\x37", 0, 0x5232},
  {"\x39", 0, 0x5233},
  {"\x3E", 0, 0x5244},
  {"\x43", 0, 0x5249},
  {"\x47", 0, 0x5260},
  {"\x4B", 0, 0x525A},
  {"\x4C", 0, 0x5252},
  {"\x4D", 0, 0x525E},
  {"\x50", 0, 0x525F},
  {"\x53", 0, 0x5255},
  {"\x5B", 0, 0x526E},
  {"\x5E", 0, 0x5268},
  {"\x5F", 0, 0x7B9A},
  {"\x6B", 0, 0x5278},
  {"\x74", 0, 0x5282},
  {"\x75", 0, 0x5281},
  {"\x79", 0, 0x528C},
  {"\x7A", 0, 0x528A},
  {"\x7C", 0, 0x5290},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page62 = {
  marc8_9page62_flat, 0
};
/* PAGE 61 */
struct yaz_iconv_trie_flat marc8_9page61_flat[] = {
  {"\x22", 0, 0x51AA},
  {"\x23", 0, 0x51AB},
  {"\x26", 0, 0x51B1},
  {"\x35", 0, 0x51BC},
  {"\x43", 0, 0x51CA},
  {"\x46", 0, 0x51C7},
  {"\x4E", 0, 0x51D1},
  {"\x4F", 0, 0x51D0},
  {"\x54", 0, 0x51D3},
  {"\x63", 0, 0x51D9},
  {"\x66", 0, 0x51DF},
  {"\x68", 0, 0x51E2},
  {"\x73", 0, 0x5160},
  {"\x78", 0, 0x51F5},
  {"\x79", 0, 0x51F7},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page61 = {
  marc8_9page61_flat, 0
};
/* PAGE 60 */
struct yaz_iconv_trie_flat marc8_9page60_flat[] = {
  {"\x29", 0, 0x5124},
  {"\x2B", 0, 0x5129},
  {"\x30", 0, 0x5131},
  {"\x3E", 0, 0x5135},
  {"\x40", 0, 0x5133},
  {"\x44", 0, 0x513A},
  {"\x47", 0, 0x5139},
  {"\x48", 0, 0x513B},
  {"\x51", 0, 0x5159},
  {"\x52", 0, 0x515B},
  {"\x55", 0, 0x515D},
  {"\x56", 0, 0x515E},
  {"\x58", 0, 0x515F},
  {"\x59", 0, 0x5161},
  {"\x5C", 0, 0x5163},
  {"\x67", 0, 0x5182},
  {"\x69", 0, 0x5184},
  {"\x6E", 0, 0x518F},
  {"\x70", 0, 0x5194},
  {"\x71", 0, 0x5193},
  {"\x75", 0, 0x5196},
  {"\x7B", 0, 0x51A1},
  {"\x7C", 0, 0x51A3},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page60 = {
  marc8_9page60_flat, 0
};
/* PAGE 59 */
struct yaz_iconv_trie_flat marc8_9page59_flat[] = {
  {"\x22", 0, 0x50C2},
  {"\x2C", 0, 0x50BA},
  {"\x2E", 0, 0x50CD},
  {"\x32", 0, 0x50D4},
  {"\x34", 0, 0x50EF},
  {"\x35", 0, 0x50E6},
  {"\x3A", 0, 0x50F4},
  {"\x3B", 0, 0x50CE},
  {"\x3C", 0, 0x50DD},
  {"\x41", 0, 0x50F3},
  {"\x42", 0, 0x50E8},
  {"\x44", 0, 0x50F0},
  {"\x46", 0, 0x50D9},
  {"\x55", 0, 0x50EC},
  {"\x5B", 0, 0x510E},
  {"\x5F", 0, 0x5105},
  {"\x61", 0, 0x50FC},
  {"\x65", 0, 0x5106},
  {"\x66", 0, 0x5107},
  {"\x67", 0, 0x510F},
  {"\x68", 0, 0x50FE},
  {"\x69", 0, 0x510B},
  {"\x6A", 0, 0x50FD},
  {"\x6D", 0, 0x5101},
  {"\x71", 0, 0x5115},
  {"\x72", 0, 0x5113},
  {"\x78", 0, 0x511A},
  {"\x79", 0, 0x9797},
  {"\x7E", 0, 0x5126},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page59 = {
  marc8_9page59_flat, 0
};
/* PAGE 58 */
struct yaz_iconv_trie_flat marc8_9page58_flat[] = {
  {"\x22", 0, 0x506F},
  {"\x23", 0, 0x5050},
  {"\x25", 0, 0x5070},
  {"\x29", 0, 0x5053},
  {"\x2A", 0, 0x506A},
  {"\x2C", 0, 0x5056},
  {"\x31", 0, 0x506D},
  {"\x38", 0, 0x505D},
  {"\x39", 0, 0x5048},
  {"\x3B", 0, 0x5058},
  {"\x3C", 0, 0x5072},
  {"\x41", 0, 0x5041},
  {"\x46", 0, 0x5015},
  {"\x48", 0, 0x507A},
  {"\x4A", 0, 0x506C},
  {"\x4B", 0, 0x505F},
  {"\x4D", 0, 0x506B},
  {"\x4E", 0, 0x5094},
  {"\x50", 0, 0x509E},
  {"\x52", 0, 0x509B},
  {"\x53", 0, 0x509A},
  {"\x57", 0, 0x50A3},
  {"\x5A", 0, 0x508C},
  {"\x5C", 0, 0x5088},
  {"\x62", 0, 0x508E},
  {"\x64", 0, 0x5095},
  {"\x67", 0, 0x50A6},
  {"\x6A", 0, 0x5092},
  {"\x6C", 0, 0x509C},
  {"\x71", 0, 0x50C7},
  {"\x75", 0, 0x50C9},
  {"\x7B", 0, 0x50CA},
  {"\x7C", 0, 0x50B4},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page58 = {
  marc8_9page58_flat, 0
};
/* PAGE 57 */
struct yaz_iconv_trie_flat marc8_9page57_flat[] = {
  {"\x22", 0, 0x4FE4},
  {"\x26", 0, 0x4FB7},
  {"\x27", 0, 0x4FC5},
  {"\x29", 0, 0x4FC9},
  {"\x2A", 0, 0x4FE5},
  {"\x2C", 0, 0x4FE7},
  {"\x33", 0, 0x4FDC},
  {"\x35", 0, 0x4FD4},
  {"\x37", 0, 0x4FC1},
  {"\x3B", 0, 0x4FDB},
  {"\x3E", 0, 0x4FC6},
  {"\x43", 0, 0x4FB9},
  {"\x46", 0, 0x501E},
  {"\x48", 0, 0x503F},
  {"\x49", 0, 0x5005},
  {"\x4C", 0, 0x5007},
  {"\x4D", 0, 0x5013},
  {"\x4E", 0, 0x5022},
  {"\x52", 0, 0x4FF5},
  {"\x59", 0, 0x4FF4},
  {"\x5B", 0, 0x5037},
  {"\x5E", 0, 0x502E},
  {"\x61", 0, 0x4FF6},
  {"\x62", 0, 0x501C},
  {"\x66", 0, 0x502C},
  {"\x69", 0, 0x5010},
  {"\x79", 0, 0x503D},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page57 = {
  marc8_9page57_flat, 0
};
/* PAGE 56 */
struct yaz_iconv_trie_flat marc8_9page56_flat[] = {
  {"\x27", 0, 0x4EF5},
  {"\x28", 0, 0x4F07},
  {"\x2A", 0, 0x4F00},
  {"\x2C", 0, 0x4F0B},
  {"\x32", 0, 0x4F3B},
  {"\x36", 0, 0x4F58},
  {"\x37", 0, 0x4F62},
  {"\x39", 0, 0x4F64},
  {"\x3A", 0, 0x4F49},
  {"\x3F", 0, 0x4F3E},
  {"\x40", 0, 0x4F66},
  {"\x44", 0, 0x4F67},
  {"\x4D", 0, 0x4F68},
  {"\x4E", 0, 0x4F5A},
  {"\x4F", 0, 0x4F5F},
  {"\x56", 0, 0x4F82},
  {"\x57", 0, 0x4F7C},
  {"\x5A", 0, 0x4F98},
  {"\x5B", 0, 0x4F92},
  {"\x5C", 0, 0x4F7D},
  {"\x60", 0, 0x4F80},
  {"\x61", 0, 0x4F74},
  {"\x62", 0, 0x4F76},
  {"\x64", 0, 0x4FA2},
  {"\x66", 0, 0x4F91},
  {"\x67", 0, 0x4F95},
  {"\x6C", 0, 0x4F4C},
  {"\x6D", 0, 0x4F97},
  {"\x6E", 0, 0x4F94},
  {"\x70", 0, 0x4F79},
  {"\x71", 0, 0x4F9A},
  {"\x72", 0, 0x4F81},
  {"\x73", 0, 0x4F78},
  {"\x76", 0, 0x4F9C},
  {"\x77", 0, 0x4F90},
  {"\x7B", 0, 0x4F7A},
  {"\x7C", 0, 0x4FCD},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page56 = {
  marc8_9page56_flat, 0
};
/* PAGE 55 */
struct yaz_iconv_trie_flat marc8_9page55_flat[] = {
  {"\x24", 0, 0x4E0F},
  {"\x25", 0, 0x5187},
  {"\x29", 0, 0x4E28},
  {"\x2E", 0, 0x4E31},
  {"\x31", 0, 0x4E36},
  {"\x33", 0, 0x4E3F},
  {"\x34", 0, 0x4E42},
  {"\x37", 0, 0x738D},
  {"\x3C", 0, 0x4E5C},
  {"\x3F", 0, 0x6C39},
  {"\x46", 0, 0x4E85},
  {"\x50", 0, 0x4EA0},
  {"\x51", 0, 0x4EA2},
  {"\x52", 0, 0x4EB3},
  {"\x55", 0, 0xE961},
  {"\x58", 0, 0x4EB9},
  {"\x5A", 0, 0x4EBC},
  {"\x5E", 0, 0x4EC9},
  {"\x61", 0, 0x4EC8},
  {"\x62", 0, 0xE9E2},
  {"\x63", 0, 0x4EE8},
  {"\x6B", 0, 0x4EE1},
  {"\x72", 0, 0x4F08},
  {"\x73", 0, 0x4F0E},
  {"\x75", 0, 0x4F03},
  {"\x7C", 0, 0x4F22},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page55 = {
  marc8_9page55_flat, 0
};
/* PAGE 54 */
struct yaz_iconv_trie_flat marc8_9page54_flat[] = {
  {"\x21", 0, 0x9F52},
  {"\x22", 0, 0x9F5F},
  {"\x23", 0, 0x9F63},
  {"\x24", 0, 0xE960},
  {"\x25", 0, 0x9F66},
  {"\x26", 0, 0x9F5C},
  {"\x27", 0, 0x9F6C},
  {"\x28", 0, 0x9F6A},
  {"\x29", 0, 0x9F77},
  {"\x2A", 0, 0x9F72},
  {"\x2B", 0, 0x9F8D},
  {"\x2C", 0, 0x9F94},
  {"\x2D", 0, 0x9F9C},
  {"\x30", 0, 0x8288},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page54 = {
  marc8_9page54_flat, 0
};
/* PAGE 53 */
struct yaz_iconv_trie_dir marc8_9page53_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9C13} /* 21 */,
  {-1, 0, 0x9C0D} /* 22 */,
  {-1, 0, 0x9BFD} /* 23 */,
  {-1, 0, 0x9C2D} /* 24 */,
  {-1, 0, 0x9C25} /* 25 */,
  {-1, 0, 0x9C31} /* 26 */,
  {-1, 0, 0x9C3E} /* 27 */,
  {-1, 0, 0x9C3B} /* 28 */,
  {-1, 0, 0x9C54} /* 29 */,
  {-1, 0, 0x9C57} /* 2A */,
  {-1, 0, 0x9C56} /* 2B */,
  {-1, 0, 0x9C49} /* 2C */,
  {-1, 0, 0x9C77} /* 2D */,
  {-1, 0, 0x9C78} /* 2E */,
  {-1, 0, 0x9CE5} /* 2F */,
  {-1, 0, 0x9CE9} /* 30 */,
  {-1, 0, 0x9CF6} /* 31 */,
  {-1, 0, 0x9CF4} /* 32 */,
  {-1, 0, 0x9CF3} /* 33 */,
  {-1, 0, 0x9D06} /* 34 */,
  {-1, 0, 0x9D09} /* 35 */,
  {-1, 0, 0x9D15} /* 36 */,
  {-1, 0, 0x9D23} /* 37 */,
  {-1, 0, 0x9D28} /* 38 */,
  {-1, 0, 0x9D26} /* 39 */,
  {-1, 0, 0x9D1B} /* 3A */,
  {-1, 0, 0xE95F} /* 3B */,
  {-1, 0, 0x9D3B} /* 3C */,
  {-1, 0, 0x9D3F} /* 3D */,
  {-1, 0, 0x9D61} /* 3E */,
  {-1, 0, 0x9D51} /* 3F */,
  {-1, 0, 0x9D60} /* 40 */,
  {-1, 0, 0x9D5D} /* 41 */,
  {-1, 0, 0x9D89} /* 42 */,
  {-1, 0, 0x9D72} /* 43 */,
  {-1, 0, 0x9D6A} /* 44 */,
  {-1, 0, 0x9D6C} /* 45 */,
  {-1, 0, 0x9DB4} /* 46 */,
  {-1, 0, 0x9DAF} /* 47 */,
  {-1, 0, 0x9DC2} /* 48 */,
  {-1, 0, 0x9DD3} /* 49 */,
  {-1, 0, 0x9DD7} /* 4A */,
  {-1, 0, 0x9DE5} /* 4B */,
  {-1, 0, 0x9DF9} /* 4C */,
  {-1, 0, 0x9DFA} /* 4D */,
  {-1, 0, 0x9E1A} /* 4E */,
  {-1, 0, 0x9E1E} /* 4F */,
  {-1, 0, 0x9E79} /* 50 */,
  {-1, 0, 0x9E7D} /* 51 */,
  {-1, 0, 0x9E7C} /* 52 */,
  {-1, 0, 0x9E7F} /* 53 */,
  {-1, 0, 0x9E82} /* 54 */,
  {-1, 0, 0x9E8B} /* 55 */,
  {-1, 0, 0x9E97} /* 56 */,
  {-1, 0, 0x9E92} /* 57 */,
  {-1, 0, 0x9E93} /* 58 */,
  {-1, 0, 0x9E9D} /* 59 */,
  {-1, 0, 0x9E9F} /* 5A */,
  {-1, 0, 0x9EA5} /* 5B */,
  {-1, 0, 0x9EA9} /* 5C */,
  {-1, 0, 0x9EB4} /* 5D */,
  {-1, 0, 0x9EB5} /* 5E */,
  {-1, 0, 0x9EBB} /* 5F */,
  {-1, 0, 0x9EBC} /* 60 */,
  {-1, 0, 0x9EBE} /* 61 */,
  {-1, 0, 0x9EC3} /* 62 */,
  {-1, 0, 0x9ECD} /* 63 */,
  {-1, 0, 0x9ECE} /* 64 */,
  {-1, 0, 0x9ECF} /* 65 */,
  {-1, 0, 0x9ED1} /* 66 */,
  {-1, 0, 0x58A8} /* 67 */,
  {-1, 0, 0x9ED8} /* 68 */,
  {-1, 0, 0x9ED4} /* 69 */,
  {-1, 0, 0x9EDE} /* 6A */,
  {-1, 0, 0x9EDC} /* 6B */,
  {-1, 0, 0x9EDB} /* 6C */,
  {-1, 0, 0x9EDD} /* 6D */,
  {-1, 0, 0x9EE0} /* 6E */,
  {-1, 0, 0x9EE8} /* 6F */,
  {-1, 0, 0x9EEF} /* 70 */,
  {-1, 0, 0x9EF4} /* 71 */,
  {-1, 0, 0x9EF7} /* 72 */,
  {-1, 0, 0x9F07} /* 73 */,
  {-1, 0, 0x9F0E} /* 74 */,
  {-1, 0, 0x9F13} /* 75 */,
  {-1, 0, 0x9F15} /* 76 */,
  {-1, 0, 0x9F19} /* 77 */,
  {-1, 0, 0x9F20} /* 78 */,
  {-1, 0, 0x9F2C} /* 79 */,
  {-1, 0, 0x9F34} /* 7A */,
  {-1, 0, 0x9F3B} /* 7B */,
  {-1, 0, 0x9F3E} /* 7C */,
  {-1, 0, 0x9F4A} /* 7D */,
  {-1, 0, 0x9F4B} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page53 = {
  0, marc8_9page53_dir
};
/* PAGE 52 */
struct yaz_iconv_trie_dir marc8_9page52_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x993F} /* 21 */,
  {-1, 0, 0x993D} /* 22 */,
  {-1, 0, 0x9945} /* 23 */,
  {-1, 0, 0x9952} /* 24 */,
  {-1, 0, 0x9951} /* 25 */,
  {-1, 0, 0x995C} /* 26 */,
  {-1, 0, 0x995E} /* 27 */,
  {-1, 0, 0x9996} /* 28 */,
  {-1, 0, 0x9999} /* 29 */,
  {-1, 0, 0x99A5} /* 2A */,
  {-1, 0, 0x99A8} /* 2B */,
  {-1, 0, 0x99AC} /* 2C */,
  {-1, 0, 0x99AE} /* 2D */,
  {-1, 0, 0x99AD} /* 2E */,
  {-1, 0, 0x99B3} /* 2F */,
  {-1, 0, 0x99B1} /* 30 */,
  {-1, 0, 0x99B4} /* 31 */,
  {-1, 0, 0x99C1} /* 32 */,
  {-1, 0, 0x99D0} /* 33 */,
  {-1, 0, 0x99DD} /* 34 */,
  {-1, 0, 0x99D5} /* 35 */,
  {-1, 0, 0x99DF} /* 36 */,
  {-1, 0, 0x99DB} /* 37 */,
  {-1, 0, 0x99D2} /* 38 */,
  {-1, 0, 0x99D9} /* 39 */,
  {-1, 0, 0x99D1} /* 3A */,
  {-1, 0, 0x99ED} /* 3B */,
  {-1, 0, 0x99F1} /* 3C */,
  {-1, 0, 0x9A01} /* 3D */,
  {-1, 0, 0x99FF} /* 3E */,
  {-1, 0, 0x99E2} /* 3F */,
  {-1, 0, 0x9A0E} /* 40 */,
  {-1, 0, 0x9A19} /* 41 */,
  {-1, 0, 0x9A16} /* 42 */,
  {-1, 0, 0x9A2B} /* 43 */,
  {-1, 0, 0x9A30} /* 44 */,
  {-1, 0, 0x9A37} /* 45 */,
  {-1, 0, 0x9A43} /* 46 */,
  {-1, 0, 0x9A45} /* 47 */,
  {-1, 0, 0x9A40} /* 48 */,
  {-1, 0, 0x9A3E} /* 49 */,
  {-1, 0, 0x9A55} /* 4A */,
  {-1, 0, 0x9A5A} /* 4B */,
  {-1, 0, 0x9A5B} /* 4C */,
  {-1, 0, 0x9A57} /* 4D */,
  {-1, 0, 0x9A5F} /* 4E */,
  {-1, 0, 0x9A62} /* 4F */,
  {-1, 0, 0x9A65} /* 50 */,
  {-1, 0, 0x9A6A} /* 51 */,
  {-1, 0, 0x9AA8} /* 52 */,
  {-1, 0, 0x9AAF} /* 53 */,
  {-1, 0, 0x9AB0} /* 54 */,
  {-1, 0, 0x9AB7} /* 55 */,
  {-1, 0, 0x9AB8} /* 56 */,
  {-1, 0, 0x9ABC} /* 57 */,
  {-1, 0, 0x9ACF} /* 58 */,
  {-1, 0, 0x9AD3} /* 59 */,
  {-1, 0, 0x9AD4} /* 5A */,
  {-1, 0, 0x9AD2} /* 5B */,
  {-1, 0, 0x9AD8} /* 5C */,
  {-1, 0, 0x9AE5} /* 5D */,
  {-1, 0, 0},
  {-1, 0, 0x9AEE} /* 5F */,
  {-1, 0, 0x9AFB} /* 60 */,
  {-1, 0, 0x9AED} /* 61 */,
  {-1, 0, 0x9B03} /* 62 */,
  {-1, 0, 0x9B06} /* 63 */,
  {-1, 0, 0x9B0D} /* 64 */,
  {-1, 0, 0x9B1A} /* 65 */,
  {-1, 0, 0x9B22} /* 66 */,
  {-1, 0, 0x9B25} /* 67 */,
  {-1, 0, 0x9B27} /* 68 */,
  {-1, 0, 0},
  {-1, 0, 0x9B31} /* 6A */,
  {-1, 0, 0x9B32} /* 6B */,
  {-1, 0, 0x9B3C} /* 6C */,
  {-1, 0, 0x9B41} /* 6D */,
  {-1, 0, 0x9B42} /* 6E */,
  {-1, 0, 0x9B45} /* 6F */,
  {-1, 0, 0x9B44} /* 70 */,
  {-1, 0, 0x9B4F} /* 71 */,
  {-1, 0, 0x9B54} /* 72 */,
  {-1, 0, 0x9B58} /* 73 */,
  {-1, 0, 0x9B5A} /* 74 */,
  {-1, 0, 0x9B77} /* 75 */,
  {-1, 0, 0x9B6F} /* 76 */,
  {-1, 0, 0x9B91} /* 77 */,
  {-1, 0, 0x9BAB} /* 78 */,
  {-1, 0, 0x9BAE} /* 79 */,
  {-1, 0, 0x9BAA} /* 7A */,
  {-1, 0, 0x9BCA} /* 7B */,
  {-1, 0, 0x9BC9} /* 7C */,
  {-1, 0, 0x9BE8} /* 7D */,
  {-1, 0, 0x9BE7} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page52 = {
  0, marc8_9page52_dir
};
/* PAGE 51 */
struct yaz_iconv_trie_dir marc8_9page51_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x978D} /* 21 */,
  {-1, 0, 0x978B} /* 22 */,
  {-1, 0, 0x978F} /* 23 */,
  {-1, 0, 0x9798} /* 24 */,
  {-1, 0, 0x97A0} /* 25 */,
  {-1, 0, 0x97A3} /* 26 */,
  {-1, 0, 0x97A6} /* 27 */,
  {-1, 0, 0x97AD} /* 28 */,
  {-1, 0, 0x97C3} /* 29 */,
  {-1, 0, 0x97C1} /* 2A */,
  {-1, 0, 0x97C6} /* 2B */,
  {-1, 0, 0x97CB} /* 2C */,
  {-1, 0, 0x97CC} /* 2D */,
  {-1, 0, 0x97D3} /* 2E */,
  {-1, 0, 0x97DC} /* 2F */,
  {-1, 0, 0x97ED} /* 30 */,
  {-1, 0, 0x97F3} /* 31 */,
  {-1, 0, 0x7AE0} /* 32 */,
  {-1, 0, 0x7ADF} /* 33 */,
  {-1, 0, 0x97F6} /* 34 */,
  {-1, 0, 0x97FB} /* 35 */,
  {-1, 0, 0xE95C} /* 36 */,
  {-1, 0, 0x9801} /* 37 */,
  {-1, 0, 0x9802} /* 38 */,
  {-1, 0, 0x9803} /* 39 */,
  {-1, 0, 0x9805} /* 3A */,
  {-1, 0, 0x9806} /* 3B */,
  {-1, 0, 0x9808} /* 3C */,
  {-1, 0, 0x9810} /* 3D */,
  {-1, 0, 0x980A} /* 3E */,
  {-1, 0, 0x9811} /* 3F */,
  {-1, 0, 0x9813} /* 40 */,
  {-1, 0, 0x9812} /* 41 */,
  {-1, 0, 0x980C} /* 42 */,
  {-1, 0, 0x9817} /* 43 */,
  {-1, 0, 0xE95D} /* 44 */,
  {-1, 0, 0x9821} /* 45 */,
  {-1, 0, 0x982D} /* 46 */,
  {-1, 0, 0x9830} /* 47 */,
  {-1, 0, 0x9838} /* 48 */,
  {-1, 0, 0x983B} /* 49 */,
  {-1, 0, 0x9839} /* 4A */,
  {-1, 0, 0x9837} /* 4B */,
  {-1, 0, 0x9824} /* 4C */,
  {-1, 0, 0x9846} /* 4D */,
  {-1, 0, 0x9854} /* 4E */,
  {-1, 0, 0x984D} /* 4F */,
  {-1, 0, 0x984C} /* 50 */,
  {-1, 0, 0x984E} /* 51 */,
  {-1, 0, 0x9853} /* 52 */,
  {-1, 0, 0xE95E} /* 53 */,
  {-1, 0, 0x985A} /* 54 */,
  {-1, 0, 0x9858} /* 55 */,
  {-1, 0, 0x9867} /* 56 */,
  {-1, 0, 0x986B} /* 57 */,
  {-1, 0, 0x986F} /* 58 */,
  {-1, 0, 0x9871} /* 59 */,
  {-1, 0, 0x9870} /* 5A */,
  {-1, 0, 0x98A8} /* 5B */,
  {-1, 0, 0x98AF} /* 5C */,
  {-1, 0, 0x98B1} /* 5D */,
  {-1, 0, 0x98B3} /* 5E */,
  {-1, 0, 0x98B6} /* 5F */,
  {-1, 0, 0x98BA} /* 60 */,
  {-1, 0, 0x98BC} /* 61 */,
  {-1, 0, 0x98C4} /* 62 */,
  {-1, 0, 0x98DB} /* 63 */,
  {-1, 0, 0x98DF} /* 64 */,
  {-1, 0, 0x98E2} /* 65 */,
  {-1, 0, 0x98E7} /* 66 */,
  {-1, 0, 0x98E9} /* 67 */,
  {-1, 0, 0x98ED} /* 68 */,
  {-1, 0, 0x98EA} /* 69 */,
  {-1, 0, 0x98EE} /* 6A */,
  {-1, 0, 0x98EF} /* 6B */,
  {-1, 0, 0x98FC} /* 6C */,
  {-1, 0, 0x98F4} /* 6D */,
  {-1, 0, 0x98FD} /* 6E */,
  {-1, 0, 0x98FE} /* 6F */,
  {-1, 0, 0x9903} /* 70 */,
  {-1, 0, 0x990A} /* 71 */,
  {-1, 0, 0x990C} /* 72 */,
  {-1, 0, 0x9909} /* 73 */,
  {-1, 0, 0x9910} /* 74 */,
  {-1, 0, 0x9912} /* 75 */,
  {-1, 0, 0x9918} /* 76 */,
  {-1, 0, 0x9913} /* 77 */,
  {-1, 0, 0x9905} /* 78 */,
  {-1, 0, 0x9928} /* 79 */,
  {-1, 0, 0x991E} /* 7A */,
  {-1, 0, 0x991B} /* 7B */,
  {-1, 0, 0x9921} /* 7C */,
  {-1, 0, 0x9935} /* 7D */,
  {-1, 0, 0x993E} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page51 = {
  0, marc8_9page51_dir
};
/* PAGE 50 */
struct yaz_iconv_trie_dir marc8_9page50_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9664} /* 21 */,
  {-1, 0, 0x966A} /* 22 */,
  {-1, 0, 0x9673} /* 23 */,
  {-1, 0, 0x9678} /* 24 */,
  {-1, 0, 0x9675} /* 25 */,
  {-1, 0, 0x9672} /* 26 */,
  {-1, 0, 0x9676} /* 27 */,
  {-1, 0, 0x9677} /* 28 */,
  {-1, 0, 0x9674} /* 29 */,
  {-1, 0, 0x9670} /* 2A */,
  {-1, 0, 0x968A} /* 2B */,
  {-1, 0, 0x968E} /* 2C */,
  {-1, 0, 0x968B} /* 2D */,
  {-1, 0, 0x967D} /* 2E */,
  {-1, 0, 0x9685} /* 2F */,
  {-1, 0, 0x9686} /* 30 */,
  {-1, 0, 0x968D} /* 31 */,
  {-1, 0, 0x9698} /* 32 */,
  {-1, 0, 0x9694} /* 33 */,
  {-1, 0, 0x9699} /* 34 */,
  {-1, 0, 0x9695} /* 35 */,
  {-1, 0, 0x969C} /* 36 */,
  {-1, 0, 0x969B} /* 37 */,
  {-1, 0, 0x96A7} /* 38 */,
  {-1, 0, 0x96A8} /* 39 */,
  {-1, 0, 0x96AA} /* 3A */,
  {-1, 0, 0x96B1} /* 3B */,
  {-1, 0, 0x96B4} /* 3C */,
  {-1, 0, 0x96B8} /* 3D */,
  {-1, 0, 0x96BB} /* 3E */,
  {-1, 0, 0x96C0} /* 3F */,
  {-1, 0, 0x96C7} /* 40 */,
  {-1, 0, 0x96C6} /* 41 */,
  {-1, 0, 0x96C4} /* 42 */,
  {-1, 0, 0x96C1} /* 43 */,
  {-1, 0, 0x96C5} /* 44 */,
  {-1, 0, 0x96CD} /* 45 */,
  {-1, 0, 0x96CB} /* 46 */,
  {-1, 0, 0x96C9} /* 47 */,
  {-1, 0, 0x96CC} /* 48 */,
  {-1, 0, 0x96D5} /* 49 */,
  {-1, 0, 0x96D6} /* 4A */,
  {-1, 0, 0x96DC} /* 4B */,
  {-1, 0, 0x96DE} /* 4C */,
  {-1, 0, 0x96DB} /* 4D */,
  {-1, 0, 0x96D9} /* 4E */,
  {-1, 0, 0x96E2} /* 4F */,
  {-1, 0, 0xE95A} /* 50 */,
  {-1, 0, 0x96E8} /* 51 */,
  {-1, 0, 0x96EA} /* 52 */,
  {-1, 0, 0x96EF} /* 53 */,
  {-1, 0, 0x96F2} /* 54 */,
  {-1, 0, 0x96FB} /* 55 */,
  {-1, 0, 0x96F7} /* 56 */,
  {-1, 0, 0x96F9} /* 57 */,
  {-1, 0, 0x96F6} /* 58 */,
  {-1, 0, 0x9700} /* 59 */,
  {-1, 0, 0x9707} /* 5A */,
  {-1, 0, 0x9704} /* 5B */,
  {-1, 0, 0x9709} /* 5C */,
  {-1, 0, 0x9706} /* 5D */,
  {-1, 0, 0x9711} /* 5E */,
  {-1, 0, 0x970E} /* 5F */,
  {-1, 0, 0x9716} /* 60 */,
  {-1, 0, 0x970F} /* 61 */,
  {-1, 0, 0x970D} /* 62 */,
  {-1, 0, 0x9713} /* 63 */,
  {-1, 0, 0x971C} /* 64 */,
  {-1, 0, 0x971E} /* 65 */,
  {-1, 0, 0x972A} /* 66 */,
  {-1, 0, 0x9727} /* 67 */,
  {-1, 0, 0x9738} /* 68 */,
  {-1, 0, 0x9739} /* 69 */,
  {-1, 0, 0x9732} /* 6A */,
  {-1, 0, 0x973D} /* 6B */,
  {-1, 0, 0x973E} /* 6C */,
  {-1, 0, 0x9744} /* 6D */,
  {-1, 0, 0x9742} /* 6E */,
  {-1, 0, 0x9748} /* 6F */,
  {-1, 0, 0x9751} /* 70 */,
  {-1, 0, 0xFA1C} /* 71 */,
  {-1, 0, 0xE95B} /* 72 */,
  {-1, 0, 0x975C} /* 73 */,
  {-1, 0, 0x975E} /* 74 */,
  {-1, 0, 0x9760} /* 75 */,
  {-1, 0, 0x9761} /* 76 */,
  {-1, 0, 0},
  {-1, 0, 0x9766} /* 78 */,
  {-1, 0, 0x9768} /* 79 */,
  {-1, 0, 0x9769} /* 7A */,
  {-1, 0, 0x9776} /* 7B */,
  {-1, 0, 0x9774} /* 7C */,
  {-1, 0, 0x977C} /* 7D */,
  {-1, 0, 0x9785} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page50 = {
  0, marc8_9page50_dir
};
/* PAGE 49 */
struct yaz_iconv_trie_dir marc8_9page49_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x937E} /* 21 */,
  {-1, 0, 0x9318} /* 22 */,
  {-1, 0, 0x936C} /* 23 */,
  {-1, 0, 0x935B} /* 24 */,
  {-1, 0, 0x938A} /* 25 */,
  {-1, 0, 0x9394} /* 26 */,
  {-1, 0, 0x93AE} /* 27 */,
  {-1, 0, 0x9396} /* 28 */,
  {-1, 0, 0x93A2} /* 29 */,
  {-1, 0, 0x93B3} /* 2A */,
  {-1, 0, 0x93E1} /* 2B */,
  {-1, 0, 0x93D1} /* 2C */,
  {-1, 0, 0x93D6} /* 2D */,
  {-1, 0, 0x93C3} /* 2E */,
  {-1, 0, 0x93DF} /* 2F */,
  {-1, 0, 0x93D7} /* 30 */,
  {-1, 0, 0x93C8} /* 31 */,
  {-1, 0, 0x93E2} /* 32 */,
  {-1, 0, 0x93DC} /* 33 */,
  {-1, 0, 0x93E4} /* 34 */,
  {-1, 0, 0x93DD} /* 35 */,
  {-1, 0, 0x93CD} /* 36 */,
  {-1, 0, 0x93D8} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0x9403} /* 39 */,
  {-1, 0, 0x942E} /* 3A */,
  {-1, 0, 0x93FD} /* 3B */,
  {-1, 0, 0x9433} /* 3C */,
  {-1, 0, 0x9435} /* 3D */,
  {-1, 0, 0x943A} /* 3E */,
  {-1, 0, 0x9438} /* 3F */,
  {-1, 0, 0x9432} /* 40 */,
  {-1, 0, 0},
  {-1, 0, 0x9451} /* 42 */,
  {-1, 0, 0x9444} /* 43 */,
  {-1, 0, 0x9463} /* 44 */,
  {-1, 0, 0x9460} /* 45 */,
  {-1, 0, 0x9472} /* 46 */,
  {-1, 0, 0x9470} /* 47 */,
  {-1, 0, 0x947E} /* 48 */,
  {-1, 0, 0x947C} /* 49 */,
  {-1, 0, 0x947D} /* 4A */,
  {-1, 0, 0x947F} /* 4B */,
  {-1, 0, 0x9577} /* 4C */,
  {-1, 0, 0x9580} /* 4D */,
  {-1, 0, 0x9582} /* 4E */,
  {-1, 0, 0x9583} /* 4F */,
  {-1, 0, 0x9589} /* 50 */,
  {-1, 0, 0x9594} /* 51 */,
  {-1, 0, 0x958F} /* 52 */,
  {-1, 0, 0x958B} /* 53 */,
  {-1, 0, 0x9591} /* 54 */,
  {-1, 0, 0x9593} /* 55 */,
  {-1, 0, 0x9592} /* 56 */,
  {-1, 0, 0x9598} /* 57 */,
  {-1, 0, 0x95A1} /* 58 */,
  {-1, 0, 0x95A8} /* 59 */,
  {-1, 0, 0x95A9} /* 5A */,
  {-1, 0, 0x95A3} /* 5B */,
  {-1, 0, 0x95A5} /* 5C */,
  {-1, 0, 0x95A4} /* 5D */,
  {-1, 0, 0x95B1} /* 5E */,
  {-1, 0, 0x95AD} /* 5F */,
  {-1, 0, 0x95BB} /* 60 */,
  {-1, 0, 0x95CA} /* 61 */,
  {-1, 0, 0x95CB} /* 62 */,
  {-1, 0, 0x95CC} /* 63 */,
  {-1, 0, 0x95C8} /* 64 */,
  {-1, 0, 0x95C6} /* 65 */,
  {-1, 0, 0},
  {-1, 0, 0x95D6} /* 67 */,
  {-1, 0, 0x95D0} /* 68 */,
  {-1, 0, 0x95DC} /* 69 */,
  {-1, 0, 0x95E1} /* 6A */,
  {-1, 0, 0x95E2} /* 6B */,
  {-1, 0, 0x961C} /* 6C */,
  {-1, 0, 0x9621} /* 6D */,
  {-1, 0, 0x9632} /* 6E */,
  {-1, 0, 0x9631} /* 6F */,
  {-1, 0, 0x962E} /* 70 */,
  {-1, 0, 0x962A} /* 71 */,
  {-1, 0, 0x9640} /* 72 */,
  {-1, 0, 0x963F} /* 73 */,
  {-1, 0, 0x963B} /* 74 */,
  {-1, 0, 0x9644} /* 75 */,
  {-1, 0, 0x9650} /* 76 */,
  {-1, 0, 0x964C} /* 77 */,
  {-1, 0, 0x964B} /* 78 */,
  {-1, 0, 0x964D} /* 79 */,
  {-1, 0, 0x9662} /* 7A */,
  {-1, 0, 0x9663} /* 7B */,
  {-1, 0, 0x965B} /* 7C */,
  {-1, 0, 0x9661} /* 7D */,
  {-1, 0, 0x965D} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page49 = {
  0, marc8_9page49_dir
};
/* PAGE 48 */
struct yaz_iconv_trie_dir marc8_9page48_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9163} /* 21 */,
  {-1, 0, 0x9165} /* 22 */,
  {-1, 0, 0x916C} /* 23 */,
  {-1, 0, 0x9169} /* 24 */,
  {-1, 0, 0x916A} /* 25 */,
  {-1, 0, 0x9175} /* 26 */,
  {-1, 0, 0x9178} /* 27 */,
  {-1, 0, 0x9177} /* 28 */,
  {-1, 0, 0x9187} /* 29 */,
  {-1, 0, 0x9189} /* 2A */,
  {-1, 0, 0x918B} /* 2B */,
  {-1, 0, 0x9183} /* 2C */,
  {-1, 0, 0x9192} /* 2D */,
  {-1, 0, 0x91A3} /* 2E */,
  {-1, 0, 0x919E} /* 2F */,
  {-1, 0, 0x919C} /* 30 */,
  {-1, 0, 0x91AB} /* 31 */,
  {-1, 0, 0x91AC} /* 32 */,
  {-1, 0, 0x91BA} /* 33 */,
  {-1, 0, 0x91C0} /* 34 */,
  {-1, 0, 0x91C1} /* 35 */,
  {-1, 0, 0x91C7} /* 36 */,
  {-1, 0, 0x91C9} /* 37 */,
  {-1, 0, 0x91CB} /* 38 */,
  {-1, 0, 0},
  {-1, 0, 0x91CD} /* 3A */,
  {-1, 0, 0x91CE} /* 3B */,
  {-1, 0, 0x91CF} /* 3C */,
  {-1, 0, 0x91D0} /* 3D */,
  {-1, 0, 0x91D1} /* 3E */,
  {-1, 0, 0x91DD} /* 3F */,
  {-1, 0, 0x91D8} /* 40 */,
  {-1, 0, 0x91D7} /* 41 */,
  {-1, 0, 0x91DC} /* 42 */,
  {-1, 0, 0x91F5} /* 43 */,
  {-1, 0, 0x91E6} /* 44 */,
  {-1, 0, 0x91E3} /* 45 */,
  {-1, 0, 0x91E7} /* 46 */,
  {-1, 0, 0x9223} /* 47 */,
  {-1, 0, 0x920D} /* 48 */,
  {-1, 0, 0x9215} /* 49 */,
  {-1, 0, 0x9209} /* 4A */,
  {-1, 0, 0x9214} /* 4B */,
  {-1, 0, 0x921E} /* 4C */,
  {-1, 0, 0x9210} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0x9237} /* 4F */,
  {-1, 0, 0x9238} /* 50 */,
  {-1, 0, 0x923D} /* 51 */,
  {-1, 0, 0x923E} /* 52 */,
  {-1, 0, 0x9240} /* 53 */,
  {-1, 0, 0x924B} /* 54 */,
  {-1, 0, 0x925B} /* 55 */,
  {-1, 0, 0x9264} /* 56 */,
  {-1, 0, 0x9251} /* 57 */,
  {-1, 0, 0xE959} /* 58 */,
  {-1, 0, 0x9278} /* 59 */,
  {-1, 0, 0x9280} /* 5A */,
  {-1, 0, 0x92AC} /* 5B */,
  {-1, 0, 0x9285} /* 5C */,
  {-1, 0, 0x9298} /* 5D */,
  {-1, 0, 0x9296} /* 5E */,
  {-1, 0, 0x927B} /* 5F */,
  {-1, 0, 0x9293} /* 60 */,
  {-1, 0, 0x929C} /* 61 */,
  {-1, 0, 0x92C5} /* 62 */,
  {-1, 0, 0x92BB} /* 63 */,
  {-1, 0, 0x92B3} /* 64 */,
  {-1, 0, 0x92EA} /* 65 */,
  {-1, 0, 0x92B7} /* 66 */,
  {-1, 0, 0x92C1} /* 67 */,
  {-1, 0, 0x92E4} /* 68 */,
  {-1, 0, 0x92BC} /* 69 */,
  {-1, 0, 0x92D2} /* 6A */,
  {-1, 0, 0x9320} /* 6B */,
  {-1, 0, 0x9336} /* 6C */,
  {-1, 0, 0x92F8} /* 6D */,
  {-1, 0, 0x9333} /* 6E */,
  {-1, 0, 0x932F} /* 6F */,
  {-1, 0, 0x9322} /* 70 */,
  {-1, 0, 0x92FC} /* 71 */,
  {-1, 0, 0x932B} /* 72 */,
  {-1, 0, 0x931A} /* 73 */,
  {-1, 0, 0x9304} /* 74 */,
  {-1, 0, 0x9310} /* 75 */,
  {-1, 0, 0x9326} /* 76 */,
  {-1, 0, 0x934D} /* 77 */,
  {-1, 0, 0x9382} /* 78 */,
  {-1, 0, 0x9375} /* 79 */,
  {-1, 0, 0x9365} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0x934B} /* 7C */,
  {-1, 0, 0x9328} /* 7D */,
  {-1, 0, 0x9370} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page48 = {
  0, marc8_9page48_dir
};
/* PAGE 47 */
struct yaz_iconv_trie_dir marc8_9page47_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x901F} /* 21 */,
  {-1, 0, 0x9017} /* 22 */,
  {-1, 0, 0x901D} /* 23 */,
  {-1, 0, 0x9010} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x900D} /* 26 */,
  {-1, 0, 0x901E} /* 27 */,
  {-1, 0, 0x901A} /* 28 */,
  {-1, 0, 0x9020} /* 29 */,
  {-1, 0, 0x900F} /* 2A */,
  {-1, 0, 0x9022} /* 2B */,
  {-1, 0, 0x9016} /* 2C */,
  {-1, 0, 0x901B} /* 2D */,
  {-1, 0, 0x9014} /* 2E */,
  {-1, 0, 0x902E} /* 2F */,
  {-1, 0, 0x9035} /* 30 */,
  {-1, 0, 0x9031} /* 31 */,
  {-1, 0, 0xFA25} /* 32 */,
  {-1, 0, 0x9032} /* 33 */,
  {-1, 0, 0x904B} /* 34 */,
  {-1, 0, 0},
  {-1, 0, 0x9053} /* 36 */,
  {-1, 0, 0x9042} /* 37 */,
  {-1, 0, 0x9050} /* 38 */,
  {-1, 0, 0x9054} /* 39 */,
  {-1, 0, 0x9055} /* 3A */,
  {-1, 0, 0x903C} /* 3B */,
  {-1, 0, 0x9047} /* 3C */,
  {-1, 0, 0x904F} /* 3D */,
  {-1, 0, 0x904E} /* 3E */,
  {-1, 0, 0x904D} /* 3F */,
  {-1, 0, 0x9051} /* 40 */,
  {-1, 0, 0x9041} /* 41 */,
  {-1, 0, 0x903E} /* 42 */,
  {-1, 0, 0x9058} /* 43 */,
  {-1, 0, 0x9060} /* 44 */,
  {-1, 0, 0x905C} /* 45 */,
  {-1, 0, 0x9063} /* 46 */,
  {-1, 0, 0x9065} /* 47 */,
  {-1, 0, 0x905E} /* 48 */,
  {-1, 0, 0x9069} /* 49 */,
  {-1, 0, 0x906E} /* 4A */,
  {-1, 0, 0x9068} /* 4B */,
  {-1, 0, 0x906D} /* 4C */,
  {-1, 0, 0x9075} /* 4D */,
  {-1, 0, 0x9074} /* 4E */,
  {-1, 0, 0x9078} /* 4F */,
  {-1, 0, 0x9072} /* 50 */,
  {-1, 0, 0x9077} /* 51 */,
  {-1, 0, 0x907C} /* 52 */,
  {-1, 0, 0x907A} /* 53 */,
  {-1, 0, 0x907F} /* 54 */,
  {-1, 0, 0x907D} /* 55 */,
  {-1, 0, 0x9081} /* 56 */,
  {-1, 0, 0x9084} /* 57 */,
  {-1, 0, 0x9082} /* 58 */,
  {-1, 0, 0x9080} /* 59 */,
  {-1, 0, 0x9087} /* 5A */,
  {-1, 0, 0x908A} /* 5B */,
  {-1, 0, 0x9090} /* 5C */,
  {-1, 0, 0x908F} /* 5D */,
  {-1, 0, 0x9091} /* 5E */,
  {-1, 0, 0x9095} /* 5F */,
  {-1, 0, 0x90A3} /* 60 */,
  {-1, 0, 0x90A2} /* 61 */,
  {-1, 0, 0x90AA} /* 62 */,
  {-1, 0, 0x90A6} /* 63 */,
  {-1, 0, 0x90B5} /* 64 */,
  {-1, 0, 0x90B1} /* 65 */,
  {-1, 0, 0x90B8} /* 66 */,
  {-1, 0, 0x90CE} /* 67 */,
  {-1, 0, 0x90CA} /* 68 */,
  {-1, 0, 0},
  {-1, 0, 0x90E1} /* 6A */,
  {-1, 0, 0x90E8} /* 6B */,
  {-1, 0, 0x90ED} /* 6C */,
  {-1, 0, 0x90F5} /* 6D */,
  {-1, 0, 0x90FD} /* 6E */,
  {-1, 0, 0x9102} /* 6F */,
  {-1, 0, 0x9109} /* 70 */,
  {-1, 0, 0x9112} /* 71 */,
  {-1, 0, 0x9119} /* 72 */,
  {-1, 0, 0x912D} /* 73 */,
  {-1, 0, 0x9130} /* 74 */,
  {-1, 0, 0x9127} /* 75 */,
  {-1, 0, 0x9131} /* 76 */,
  {-1, 0, 0xE958} /* 77 */,
  {-1, 0, 0x9149} /* 78 */,
  {-1, 0, 0x914B} /* 79 */,
  {-1, 0, 0x914A} /* 7A */,
  {-1, 0, 0x9152} /* 7B */,
  {-1, 0, 0x914D} /* 7C */,
  {-1, 0, 0x914C} /* 7D */,
  {-1, 0, 0x9157} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page47 = {
  0, marc8_9page47_dir
};
/* PAGE 46 */
struct yaz_iconv_trie_dir marc8_9page46_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8E76} /* 21 */,
  {-1, 0, 0x8E7C} /* 22 */,
  {-1, 0, 0x8E82} /* 23 */,
  {-1, 0, 0x8E81} /* 24 */,
  {-1, 0, 0x8E87} /* 25 */,
  {-1, 0, 0x8E89} /* 26 */,
  {-1, 0, 0x8E85} /* 27 */,
  {-1, 0, 0x8E8A} /* 28 */,
  {-1, 0, 0xE955} /* 29 */,
  {-1, 0, 0x8E91} /* 2A */,
  {-1, 0, 0x8EA1} /* 2B */,
  {-1, 0, 0x8EAA} /* 2C */,
  {-1, 0, 0x8EAB} /* 2D */,
  {-1, 0, 0x8EAC} /* 2E */,
  {-1, 0, 0x8EB2} /* 2F */,
  {-1, 0, 0x8EBA} /* 30 */,
  {-1, 0, 0x8EC0} /* 31 */,
  {-1, 0, 0x8ECA} /* 32 */,
  {-1, 0, 0x8ECB} /* 33 */,
  {-1, 0, 0x8ECD} /* 34 */,
  {-1, 0, 0x8ECC} /* 35 */,
  {-1, 0, 0x8ED2} /* 36 */,
  {-1, 0, 0x8ED4} /* 37 */,
  {-1, 0, 0x8EDF} /* 38 */,
  {-1, 0, 0x8EDB} /* 39 */,
  {-1, 0, 0x8EFB} /* 3A */,
  {-1, 0, 0x8EF8} /* 3B */,
  {-1, 0, 0x8EFC} /* 3C */,
  {-1, 0, 0x8F03} /* 3D */,
  {-1, 0, 0x8EFE} /* 3E */,
  {-1, 0, 0x8F09} /* 3F */,
  {-1, 0, 0x8F0A} /* 40 */,
  {-1, 0, 0x8F14} /* 41 */,
  {-1, 0, 0x8F12} /* 42 */,
  {-1, 0, 0x8F15} /* 43 */,
  {-1, 0, 0x8F13} /* 44 */,
  {-1, 0, 0x8F26} /* 45 */,
  {-1, 0, 0x8F1B} /* 46 */,
  {-1, 0, 0x8F1F} /* 47 */,
  {-1, 0, 0x8F1D} /* 48 */,
  {-1, 0, 0x8F29} /* 49 */,
  {-1, 0, 0x8F2A} /* 4A */,
  {-1, 0, 0x8F1C} /* 4B */,
  {-1, 0, 0x8F3B} /* 4C */,
  {-1, 0, 0x8F2F} /* 4D */,
  {-1, 0, 0x8F38} /* 4E */,
  {-1, 0, 0x8F44} /* 4F */,
  {-1, 0, 0x8F3E} /* 50 */,
  {-1, 0, 0x8F45} /* 51 */,
  {-1, 0, 0xE956} /* 52 */,
  {-1, 0, 0x8F3F} /* 53 */,
  {-1, 0, 0x8F4D} /* 54 */,
  {-1, 0, 0x8F49} /* 55 */,
  {-1, 0, 0x8F54} /* 56 */,
  {-1, 0, 0x8F4E} /* 57 */,
  {-1, 0, 0x8F5F} /* 58 */,
  {-1, 0, 0x8F61} /* 59 */,
  {-1, 0, 0x8F9B} /* 5A */,
  {-1, 0, 0x8F9C} /* 5B */,
  {-1, 0, 0x8F9F} /* 5C */,
  {-1, 0, 0x8FA3} /* 5D */,
  {-1, 0, 0x8FA8} /* 5E */,
  {-1, 0, 0x8FA6} /* 5F */,
  {-1, 0, 0x8FAD} /* 60 */,
  {-1, 0, 0x8FAF} /* 61 */,
  {-1, 0, 0x8FB0} /* 62 */,
  {-1, 0, 0x8FB1} /* 63 */,
  {-1, 0, 0x8FB2} /* 64 */,
  {-1, 0, 0},
  {-1, 0, 0x8FC6} /* 66 */,
  {-1, 0, 0x8FC5} /* 67 */,
  {-1, 0, 0x8FC4} /* 68 */,
  {-1, 0, 0x5DE1} /* 69 */,
  {-1, 0, 0x8FCE} /* 6A */,
  {-1, 0, 0x8FD1} /* 6B */,
  {-1, 0, 0x8FD4} /* 6C */,
  {-1, 0, 0xE957} /* 6D */,
  {-1, 0, 0x8FE6} /* 6E */,
  {-1, 0, 0x8FE2} /* 6F */,
  {-1, 0, 0x8FEA} /* 70 */,
  {-1, 0, 0x8FE5} /* 71 */,
  {-1, 0, 0},
  {-1, 0, 0x8FEB} /* 73 */,
  {-1, 0, 0x9001} /* 74 */,
  {-1, 0, 0x9006} /* 75 */,
  {-1, 0, 0x8FF7} /* 76 */,
  {-1, 0, 0x9000} /* 77 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x9003} /* 7A */,
  {-1, 0, 0x8FFD} /* 7B */,
  {-1, 0, 0x9005} /* 7C */,
  {-1, 0, 0x9019} /* 7D */,
  {-1, 0, 0x9023} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page46 = {
  0, marc8_9page46_dir
};
/* PAGE 45 */
struct yaz_iconv_trie_dir marc8_9page45_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8CC5} /* 21 */,
  {-1, 0, 0x8CC7} /* 22 */,
  {-1, 0, 0x8CCA} /* 23 */,
  {-1, 0, 0x8CC8} /* 24 */,
  {-1, 0, 0x8CC4} /* 25 */,
  {-1, 0, 0x8CB2} /* 26 */,
  {-1, 0, 0x8CC3} /* 27 */,
  {-1, 0, 0x8CC2} /* 28 */,
  {-1, 0, 0x8CD3} /* 29 */,
  {-1, 0, 0x8CD1} /* 2A */,
  {-1, 0, 0x8CD2} /* 2B */,
  {-1, 0, 0x8CE0} /* 2C */,
  {-1, 0, 0x8CE6} /* 2D */,
  {-1, 0, 0},
  {-1, 0, 0x8CE3} /* 2F */,
  {-1, 0, 0x8CE2} /* 30 */,
  {-1, 0, 0x8CE4} /* 31 */,
  {-1, 0, 0x8CDE} /* 32 */,
  {-1, 0, 0x8CDC} /* 33 */,
  {-1, 0, 0x8CEA} /* 34 */,
  {-1, 0, 0x8CED} /* 35 */,
  {-1, 0, 0x8CF4} /* 36 */,
  {-1, 0, 0x8CFD} /* 37 */,
  {-1, 0, 0x8CFA} /* 38 */,
  {-1, 0, 0x8D05} /* 39 */,
  {-1, 0, 0x8CFC} /* 3A */,
  {-1, 0, 0xE954} /* 3B */,
  {-1, 0, 0x8D0B} /* 3C */,
  {-1, 0, 0x8D0A} /* 3D */,
  {-1, 0, 0x8D0F} /* 3E */,
  {-1, 0, 0x8D0D} /* 3F */,
  {-1, 0, 0x8D13} /* 40 */,
  {-1, 0, 0x8D16} /* 41 */,
  {-1, 0, 0x8D1B} /* 42 */,
  {-1, 0, 0x8D64} /* 43 */,
  {-1, 0, 0x8D67} /* 44 */,
  {-1, 0, 0x8D66} /* 45 */,
  {-1, 0, 0x8D6B} /* 46 */,
  {-1, 0, 0x8D6D} /* 47 */,
  {-1, 0, 0x8D70} /* 48 */,
  {-1, 0, 0x8D74} /* 49 */,
  {-1, 0, 0x8D73} /* 4A */,
  {-1, 0, 0x8D77} /* 4B */,
  {-1, 0, 0x8D85} /* 4C */,
  {-1, 0, 0x8D8A} /* 4D */,
  {-1, 0, 0x8D81} /* 4E */,
  {-1, 0, 0x8D99} /* 4F */,
  {-1, 0, 0x8D95} /* 50 */,
  {-1, 0, 0x8DA3} /* 51 */,
  {-1, 0, 0x8D9F} /* 52 */,
  {-1, 0, 0x8DA8} /* 53 */,
  {-1, 0, 0x8DB3} /* 54 */,
  {-1, 0, 0x8DB4} /* 55 */,
  {-1, 0, 0x8DBE} /* 56 */,
  {-1, 0, 0x8DCE} /* 57 */,
  {-1, 0, 0x8DDD} /* 58 */,
  {-1, 0, 0x8DDB} /* 59 */,
  {-1, 0, 0x8DCB} /* 5A */,
  {-1, 0, 0x8DDA} /* 5B */,
  {-1, 0, 0x8DC6} /* 5C */,
  {-1, 0, 0x8DD1} /* 5D */,
  {-1, 0, 0x8DCC} /* 5E */,
  {-1, 0, 0x8DE1} /* 5F */,
  {-1, 0, 0x8DDF} /* 60 */,
  {-1, 0, 0x8DE8} /* 61 */,
  {-1, 0, 0x8DF3} /* 62 */,
  {-1, 0, 0x8DFA} /* 63 */,
  {-1, 0, 0x8DEA} /* 64 */,
  {-1, 0, 0x8DEF} /* 65 */,
  {-1, 0, 0x8DFC} /* 66 */,
  {-1, 0, 0x8E2B} /* 67 */,
  {-1, 0, 0x8E10} /* 68 */,
  {-1, 0, 0x8E22} /* 69 */,
  {-1, 0, 0x8E1D} /* 6A */,
  {-1, 0, 0x8E0F} /* 6B */,
  {-1, 0, 0x8E29} /* 6C */,
  {-1, 0, 0x8E1F} /* 6D */,
  {-1, 0, 0x8E44} /* 6E */,
  {-1, 0, 0x8E31} /* 6F */,
  {-1, 0, 0x8E42} /* 70 */,
  {-1, 0, 0x8E34} /* 71 */,
  {-1, 0, 0x8E39} /* 72 */,
  {-1, 0, 0x8E35} /* 73 */,
  {-1, 0, 0x8E49} /* 74 */,
  {-1, 0, 0x8E4B} /* 75 */,
  {-1, 0, 0x8E48} /* 76 */,
  {-1, 0, 0x8E4A} /* 77 */,
  {-1, 0, 0x8E63} /* 78 */,
  {-1, 0, 0x8E59} /* 79 */,
  {-1, 0, 0x8E66} /* 7A */,
  {-1, 0, 0x8E64} /* 7B */,
  {-1, 0, 0x8E72} /* 7C */,
  {-1, 0, 0x8E6C} /* 7D */,
  {-1, 0, 0x8E7A} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page45 = {
  0, marc8_9page45_dir
};
/* PAGE 44 */
struct yaz_iconv_trie_dir marc8_9page44_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8AC2} /* 21 */,
  {-1, 0, 0x8AB0} /* 22 */,
  {-1, 0, 0x8A95} /* 23 */,
  {-1, 0, 0x8AD6} /* 24 */,
  {-1, 0, 0x8AE6} /* 25 */,
  {-1, 0, 0x8AFA} /* 26 */,
  {-1, 0, 0x8AEB} /* 27 */,
  {-1, 0, 0x8AF1} /* 28 */,
  {-1, 0, 0x8AE7} /* 29 */,
  {-1, 0, 0x8ADC} /* 2A */,
  {-1, 0, 0x8B00} /* 2B */,
  {-1, 0, 0xE953} /* 2C */,
  {-1, 0, 0x8B02} /* 2D */,
  {-1, 0, 0x8AFE} /* 2E */,
  {-1, 0, 0x8AF7} /* 2F */,
  {-1, 0, 0x8AED} /* 30 */,
  {-1, 0, 0x8B17} /* 31 */,
  {-1, 0, 0x8B19} /* 32 */,
  {-1, 0, 0x8B0E} /* 33 */,
  {-1, 0, 0x8B1B} /* 34 */,
  {-1, 0, 0x8B0A} /* 35 */,
  {-1, 0, 0x8B21} /* 36 */,
  {-1, 0, 0x8B04} /* 37 */,
  {-1, 0, 0x8B1D} /* 38 */,
  {-1, 0, 0x8B39} /* 39 */,
  {-1, 0, 0x8B2C} /* 3A */,
  {-1, 0, 0x8B28} /* 3B */,
  {-1, 0, 0x8B58} /* 3C */,
  {-1, 0, 0x8B5C} /* 3D */,
  {-1, 0, 0x8B4E} /* 3E */,
  {-1, 0, 0x8B49} /* 3F */,
  {-1, 0, 0x8B5A} /* 40 */,
  {-1, 0, 0x8B41} /* 41 */,
  {-1, 0, 0x8B4F} /* 42 */,
  {-1, 0, 0x8B70} /* 43 */,
  {-1, 0, 0x8B6C} /* 44 */,
  {-1, 0, 0x8B66} /* 45 */,
  {-1, 0, 0x8B6F} /* 46 */,
  {-1, 0, 0x8B74} /* 47 */,
  {-1, 0, 0x8B77} /* 48 */,
  {-1, 0, 0x8B7D} /* 49 */,
  {-1, 0, 0x8B80} /* 4A */,
  {-1, 0, 0x8B8A} /* 4B */,
  {-1, 0, 0x8B93} /* 4C */,
  {-1, 0, 0x8B96} /* 4D */,
  {-1, 0, 0x8B92} /* 4E */,
  {-1, 0, 0x8B9A} /* 4F */,
  {-1, 0, 0},
  {-1, 0, 0x8C41} /* 51 */,
  {-1, 0, 0x8C3F} /* 52 */,
  {-1, 0, 0x8C46} /* 53 */,
  {-1, 0, 0x8C48} /* 54 */,
  {-1, 0, 0x8C49} /* 55 */,
  {-1, 0, 0x8C4C} /* 56 */,
  {-1, 0, 0x8C4E} /* 57 */,
  {-1, 0, 0x8C50} /* 58 */,
  {-1, 0, 0x8C54} /* 59 */,
  {-1, 0, 0x8C5A} /* 5A */,
  {-1, 0, 0},
  {-1, 0, 0x8C62} /* 5C */,
  {-1, 0, 0x8C6A} /* 5D */,
  {-1, 0, 0x8C6B} /* 5E */,
  {-1, 0, 0x8C6C} /* 5F */,
  {-1, 0, 0x8C7A} /* 60 */,
  {-1, 0, 0x8C79} /* 61 */,
  {-1, 0, 0x8C82} /* 62 */,
  {-1, 0, 0x8C8A} /* 63 */,
  {-1, 0, 0x8C89} /* 64 */,
  {-1, 0, 0x8C8D} /* 65 */,
  {-1, 0, 0x8C8C} /* 66 */,
  {-1, 0, 0x8C93} /* 67 */,
  {-1, 0, 0x8C9D} /* 68 */,
  {-1, 0, 0x8C9E} /* 69 */,
  {-1, 0, 0x8CA0} /* 6A */,
  {-1, 0, 0x8CA2} /* 6B */,
  {-1, 0, 0x8CA1} /* 6C */,
  {-1, 0, 0x8CAC} /* 6D */,
  {-1, 0, 0x8CAB} /* 6E */,
  {-1, 0, 0x8CA8} /* 6F */,
  {-1, 0, 0x8CAA} /* 70 */,
  {-1, 0, 0x8CA7} /* 71 */,
  {-1, 0, 0x8CA9} /* 72 */,
  {-1, 0, 0x8CAF} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0x8CBB} /* 75 */,
  {-1, 0, 0x8CC1} /* 76 */,
  {-1, 0, 0x8CC0} /* 77 */,
  {-1, 0, 0x8CB4} /* 78 */,
  {-1, 0, 0x8CBC} /* 79 */,
  {-1, 0, 0x8CB7} /* 7A */,
  {-1, 0, 0x8CB6} /* 7B */,
  {-1, 0, 0x8CBD} /* 7C */,
  {-1, 0, 0x8CB8} /* 7D */,
  {-1, 0, 0x8CBF} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page44 = {
  0, marc8_9page44_dir
};
/* PAGE 43 */
struct yaz_iconv_trie_dir marc8_9page43_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x896A} /* 21 */,
  {-1, 0, 0x896F} /* 22 */,
  {-1, 0, 0x8972} /* 23 */,
  {-1, 0, 0x897F} /* 24 */,
  {-1, 0, 0x8981} /* 25 */,
  {-1, 0, 0x8983} /* 26 */,
  {-1, 0, 0},
  {-1, 0, 0x898B} /* 28 */,
  {-1, 0, 0x898F} /* 29 */,
  {-1, 0, 0x8993} /* 2A */,
  {-1, 0, 0x8996} /* 2B */,
  {-1, 0, 0x89AA} /* 2C */,
  {-1, 0, 0x89A6} /* 2D */,
  {-1, 0, 0x89AC} /* 2E */,
  {-1, 0, 0x89B2} /* 2F */,
  {-1, 0, 0x89BA} /* 30 */,
  {-1, 0, 0x89BD} /* 31 */,
  {-1, 0, 0x89C0} /* 32 */,
  {-1, 0, 0x89D2} /* 33 */,
  {-1, 0, 0x89E3} /* 34 */,
  {-1, 0, 0x89F4} /* 35 */,
  {-1, 0, 0x89F8} /* 36 */,
  {-1, 0, 0x8A00} /* 37 */,
  {-1, 0, 0x8A08} /* 38 */,
  {-1, 0, 0x8A02} /* 39 */,
  {-1, 0, 0x8A03} /* 3A */,
  {-1, 0, 0x8A10} /* 3B */,
  {-1, 0, 0x8A18} /* 3C */,
  {-1, 0, 0x8A0E} /* 3D */,
  {-1, 0, 0x8A0C} /* 3E */,
  {-1, 0, 0x8A15} /* 3F */,
  {-1, 0, 0x8A0A} /* 40 */,
  {-1, 0, 0x8A16} /* 41 */,
  {-1, 0, 0x8A17} /* 42 */,
  {-1, 0, 0x8A13} /* 43 */,
  {-1, 0, 0x8A2A} /* 44 */,
  {-1, 0, 0x8A23} /* 45 */,
  {-1, 0, 0x8A1D} /* 46 */,
  {-1, 0, 0x8A25} /* 47 */,
  {-1, 0, 0x8A31} /* 48 */,
  {-1, 0, 0x8A2D} /* 49 */,
  {-1, 0, 0x8A1B} /* 4A */,
  {-1, 0, 0x8A1F} /* 4B */,
  {-1, 0, 0x8A3B} /* 4C */,
  {-1, 0, 0x8A60} /* 4D */,
  {-1, 0, 0x8A55} /* 4E */,
  {-1, 0, 0x8A5E} /* 4F */,
  {-1, 0, 0},
  {-1, 0, 0x8A41} /* 51 */,
  {-1, 0, 0x8A54} /* 52 */,
  {-1, 0, 0x8A5B} /* 53 */,
  {-1, 0, 0x8A50} /* 54 */,
  {-1, 0, 0x8A46} /* 55 */,
  {-1, 0, 0x8A34} /* 56 */,
  {-1, 0, 0x8A3A} /* 57 */,
  {-1, 0, 0x8A6B} /* 58 */,
  {-1, 0, 0x8A72} /* 59 */,
  {-1, 0, 0x8A73} /* 5A */,
  {-1, 0, 0x8A66} /* 5B */,
  {-1, 0, 0x8A69} /* 5C */,
  {-1, 0, 0x8A70} /* 5D */,
  {-1, 0, 0x8A63} /* 5E */,
  {-1, 0, 0x8A7C} /* 5F */,
  {-1, 0, 0x8AA0} /* 60 */,
  {-1, 0, 0x8A87} /* 61 */,
  {-1, 0, 0x8A85} /* 62 */,
  {-1, 0, 0x8A6D} /* 63 */,
  {-1, 0, 0x8A79} /* 64 */,
  {-1, 0, 0x8A62} /* 65 */,
  {-1, 0, 0x8A71} /* 66 */,
  {-1, 0, 0x8A6E} /* 67 */,
  {-1, 0, 0x8A6C} /* 68 */,
  {-1, 0, 0x8AAA} /* 69 */,
  {-1, 0, 0x8AA6} /* 6A */,
  {-1, 0, 0x8AA1} /* 6B */,
  {-1, 0, 0x8A9E} /* 6C */,
  {-1, 0, 0x8A8C} /* 6D */,
  {-1, 0, 0x8A93} /* 6E */,
  {-1, 0, 0x8AA3} /* 6F */,
  {-1, 0, 0x8A8D} /* 70 */,
  {-1, 0, 0xE951} /* 71 */,
  {-1, 0, 0x8AA8} /* 72 */,
  {-1, 0, 0x8AA5} /* 73 */,
  {-1, 0, 0x8A98} /* 74 */,
  {-1, 0, 0x8A91} /* 75 */,
  {-1, 0, 0x8ABC} /* 76 */,
  {-1, 0, 0x8AC4} /* 77 */,
  {-1, 0, 0x8AD2} /* 78 */,
  {-1, 0, 0x8AC7} /* 79 */,
  {-1, 0, 0xE952} /* 7A */,
  {-1, 0, 0x8AF8} /* 7B */,
  {-1, 0, 0x8AB2} /* 7C */,
  {-1, 0, 0x8ABF} /* 7D */,
  {-1, 0, 0x8AC9} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page43 = {
  0, marc8_9page43_dir
};
/* PAGE 42 */
struct yaz_iconv_trie_dir marc8_9page42_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8759} /* 21 */,
  {-1, 0, 0x8783} /* 22 */,
  {-1, 0, 0x8782} /* 23 */,
  {-1, 0, 0x87A2} /* 24 */,
  {-1, 0, 0x879E} /* 25 */,
  {-1, 0, 0x878D} /* 26 */,
  {-1, 0, 0x879F} /* 27 */,
  {-1, 0, 0x87D1} /* 28 */,
  {-1, 0, 0x87C0} /* 29 */,
  {-1, 0, 0x87AB} /* 2A */,
  {-1, 0, 0x87B3} /* 2B */,
  {-1, 0, 0x87BB} /* 2C */,
  {-1, 0, 0x87C8} /* 2D */,
  {-1, 0, 0x87D2} /* 2E */,
  {-1, 0, 0x87BA} /* 2F */,
  {-1, 0, 0x87C6} /* 30 */,
  {-1, 0, 0x87CB} /* 31 */,
  {-1, 0, 0x87EF} /* 32 */,
  {-1, 0, 0x87F2} /* 33 */,
  {-1, 0, 0x87EC} /* 34 */,
  {-1, 0, 0x87FB} /* 35 */,
  {-1, 0, 0x8805} /* 36 */,
  {-1, 0, 0x880D} /* 37 */,
  {-1, 0, 0x87F9} /* 38 */,
  {-1, 0, 0x8814} /* 39 */,
  {-1, 0, 0x8815} /* 3A */,
  {-1, 0, 0x8822} /* 3B */,
  {-1, 0, 0x8823} /* 3C */,
  {-1, 0, 0x8821} /* 3D */,
  {-1, 0, 0x881F} /* 3E */,
  {-1, 0, 0x8831} /* 3F */,
  {-1, 0, 0x8839} /* 40 */,
  {-1, 0, 0x8836} /* 41 */,
  {-1, 0, 0x883B} /* 42 */,
  {-1, 0, 0x8840} /* 43 */,
  {-1, 0, 0x884C} /* 44 */,
  {-1, 0, 0x884D} /* 45 */,
  {-1, 0, 0xE950} /* 46 */,
  {-1, 0, 0x8857} /* 47 */,
  {-1, 0, 0x8859} /* 48 */,
  {-1, 0, 0x885B} /* 49 */,
  {-1, 0, 0x885D} /* 4A */,
  {-1, 0, 0x8861} /* 4B */,
  {-1, 0, 0x8862} /* 4C */,
  {-1, 0, 0x8863} /* 4D */,
  {-1, 0, 0x521D} /* 4E */,
  {-1, 0, 0x8868} /* 4F */,
  {-1, 0, 0x886B} /* 50 */,
  {-1, 0, 0x8882} /* 51 */,
  {-1, 0, 0x8881} /* 52 */,
  {-1, 0, 0x8870} /* 53 */,
  {-1, 0, 0x8877} /* 54 */,
  {-1, 0, 0x8888} /* 55 */,
  {-1, 0, 0x88AB} /* 56 */,
  {-1, 0, 0x8892} /* 57 */,
  {-1, 0, 0x8896} /* 58 */,
  {-1, 0, 0x888D} /* 59 */,
  {-1, 0, 0x888B} /* 5A */,
  {-1, 0, 0x889E} /* 5B */,
  {-1, 0, 0x88C1} /* 5C */,
  {-1, 0, 0x88C2} /* 5D */,
  {-1, 0, 0x88B1} /* 5E */,
  {-1, 0, 0x88DF} /* 5F */,
  {-1, 0, 0x88D9} /* 60 */,
  {-1, 0, 0x88D8} /* 61 */,
  {-1, 0, 0x88DC} /* 62 */,
  {-1, 0, 0x88CF} /* 63 */,
  {-1, 0, 0x88D4} /* 64 */,
  {-1, 0, 0x88DD} /* 65 */,
  {-1, 0, 0x88D5} /* 66 */,
  {-1, 0, 0x8902} /* 67 */,
  {-1, 0, 0x88F3} /* 68 */,
  {-1, 0, 0x88F8} /* 69 */,
  {-1, 0, 0x88F9} /* 6A */,
  {-1, 0, 0x88F4} /* 6B */,
  {-1, 0, 0x88FD} /* 6C */,
  {-1, 0, 0x88E8} /* 6D */,
  {-1, 0, 0x891A} /* 6E */,
  {-1, 0, 0x8910} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x8913} /* 71 */,
  {-1, 0, 0x8912} /* 72 */,
  {-1, 0, 0x8932} /* 73 */,
  {-1, 0, 0x892A} /* 74 */,
  {-1, 0, 0x8925} /* 75 */,
  {-1, 0, 0x892B} /* 76 */,
  {-1, 0, 0x893B} /* 77 */,
  {-1, 0, 0x8936} /* 78 */,
  {-1, 0, 0x8938} /* 79 */,
  {-1, 0, 0x8944} /* 7A */,
  {-1, 0, 0x895F} /* 7B */,
  {-1, 0, 0x8960} /* 7C */,
  {-1, 0, 0x8956} /* 7D */,
  {-1, 0, 0x8964} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page42 = {
  0, marc8_9page42_dir
};
/* PAGE 41 */
struct yaz_iconv_trie_dir marc8_9page41_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x85AA} /* 21 */,
  {-1, 0, 0x856D} /* 22 */,
  {-1, 0, 0x859B} /* 23 */,
  {-1, 0, 0x8591} /* 24 */,
  {-1, 0, 0x857E} /* 25 */,
  {-1, 0, 0x8594} /* 26 */,
  {-1, 0, 0x859C} /* 27 */,
  {-1, 0, 0x8587} /* 28 */,
  {-1, 0, 0xE94F} /* 29 */,
  {-1, 0, 0x85A9} /* 2A */,
  {-1, 0, 0x85CF} /* 2B */,
  {-1, 0, 0x85AF} /* 2C */,
  {-1, 0, 0x85D0} /* 2D */,
  {-1, 0, 0x85C9} /* 2E */,
  {-1, 0, 0x85B0} /* 2F */,
  {-1, 0, 0x85E9} /* 30 */,
  {-1, 0, 0x85DD} /* 31 */,
  {-1, 0, 0x85EA} /* 32 */,
  {-1, 0, 0x85E4} /* 33 */,
  {-1, 0, 0x85D5} /* 34 */,
  {-1, 0, 0x85E5} /* 35 */,
  {-1, 0, 0x85FB} /* 36 */,
  {-1, 0, 0x85F9} /* 37 */,
  {-1, 0, 0x8611} /* 38 */,
  {-1, 0, 0x85FA} /* 39 */,
  {-1, 0, 0x8606} /* 3A */,
  {-1, 0, 0x860B} /* 3B */,
  {-1, 0, 0x8607} /* 3C */,
  {-1, 0, 0x860A} /* 3D */,
  {-1, 0, 0x862D} /* 3E */,
  {-1, 0, 0x8617} /* 3F */,
  {-1, 0, 0x861A} /* 40 */,
  {-1, 0, 0x8638} /* 41 */,
  {-1, 0, 0x863F} /* 42 */,
  {-1, 0, 0x864E} /* 43 */,
  {-1, 0, 0x8650} /* 44 */,
  {-1, 0, 0x8654} /* 45 */,
  {-1, 0, 0x5F6A} /* 46 */,
  {-1, 0, 0x8655} /* 47 */,
  {-1, 0, 0x865C} /* 48 */,
  {-1, 0, 0x865B} /* 49 */,
  {-1, 0, 0x865F} /* 4A */,
  {-1, 0, 0x865E} /* 4B */,
  {-1, 0, 0x8667} /* 4C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8679} /* 4F */,
  {-1, 0, 0x86A9} /* 50 */,
  {-1, 0, 0x86AA} /* 51 */,
  {-1, 0, 0x868A} /* 52 */,
  {-1, 0, 0x8693} /* 53 */,
  {-1, 0, 0x86A4} /* 54 */,
  {-1, 0, 0x868C} /* 55 */,
  {-1, 0, 0x86A3} /* 56 */,
  {-1, 0, 0x86C0} /* 57 */,
  {-1, 0, 0x86C7} /* 58 */,
  {-1, 0, 0x86B5} /* 59 */,
  {-1, 0, 0x86CB} /* 5A */,
  {-1, 0, 0x86B6} /* 5B */,
  {-1, 0, 0x86C4} /* 5C */,
  {-1, 0, 0x86C6} /* 5D */,
  {-1, 0, 0x86B1} /* 5E */,
  {-1, 0, 0x86AF} /* 5F */,
  {-1, 0, 0x86DF} /* 60 */,
  {-1, 0, 0x86D9} /* 61 */,
  {-1, 0, 0x86ED} /* 62 */,
  {-1, 0, 0x86D4} /* 63 */,
  {-1, 0, 0x86DB} /* 64 */,
  {-1, 0, 0x86E4} /* 65 */,
  {-1, 0, 0x86FB} /* 66 */,
  {-1, 0, 0x86F9} /* 67 */,
  {-1, 0, 0x8707} /* 68 */,
  {-1, 0, 0x8703} /* 69 */,
  {-1, 0, 0x8708} /* 6A */,
  {-1, 0, 0x8700} /* 6B */,
  {-1, 0, 0x86FE} /* 6C */,
  {-1, 0, 0x8713} /* 6D */,
  {-1, 0, 0x8702} /* 6E */,
  {-1, 0, 0x871C} /* 6F */,
  {-1, 0, 0x873F} /* 70 */,
  {-1, 0, 0x873B} /* 71 */,
  {-1, 0, 0x8722} /* 72 */,
  {-1, 0, 0x8725} /* 73 */,
  {-1, 0, 0x8734} /* 74 */,
  {-1, 0, 0x8718} /* 75 */,
  {-1, 0, 0x8755} /* 76 */,
  {-1, 0, 0x8760} /* 77 */,
  {-1, 0, 0x8776} /* 78 */,
  {-1, 0, 0x8774} /* 79 */,
  {-1, 0, 0x8766} /* 7A */,
  {-1, 0, 0x8778} /* 7B */,
  {-1, 0, 0x8768} /* 7C */,
  {-1, 0, 0x874C} /* 7D */,
  {-1, 0, 0x8757} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page41 = {
  0, marc8_9page41_dir
};
/* PAGE 40 */
struct yaz_iconv_trie_dir marc8_9page40_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5179} /* 21 */,
  {-1, 0, 0x834F} /* 22 */,
  {-1, 0, 0x8339} /* 23 */,
  {-1, 0, 0x838E} /* 24 */,
  {-1, 0, 0x8398} /* 25 */,
  {-1, 0, 0x839E} /* 26 */,
  {-1, 0, 0x8378} /* 27 */,
  {-1, 0, 0x83A2} /* 28 */,
  {-1, 0, 0x8396} /* 29 */,
  {-1, 0, 0x83A7} /* 2A */,
  {-1, 0, 0x83AB} /* 2B */,
  {-1, 0, 0xE94E} /* 2C */,
  {-1, 0, 0x838A} /* 2D */,
  {-1, 0, 0x8393} /* 2E */,
  {-1, 0, 0x83A0} /* 2F */,
  {-1, 0, 0x8389} /* 30 */,
  {-1, 0, 0x8377} /* 31 */,
  {-1, 0, 0x837C} /* 32 */,
  {-1, 0, 0x837B} /* 33 */,
  {-1, 0, 0x840D} /* 34 */,
  {-1, 0, 0x83E0} /* 35 */,
  {-1, 0, 0x83E9} /* 36 */,
  {-1, 0, 0},
  {-1, 0, 0x8403} /* 38 */,
  {-1, 0, 0x83C5} /* 39 */,
  {-1, 0, 0x83C1} /* 3A */,
  {-1, 0, 0x840B} /* 3B */,
  {-1, 0, 0x83EF} /* 3C */,
  {-1, 0, 0},
  {-1, 0, 0x83F1} /* 3E */,
  {-1, 0, 0x83BD} /* 3F */,
  {-1, 0, 0},
  {-1, 0, 0x840A} /* 41 */,
  {-1, 0, 0x840C} /* 42 */,
  {-1, 0, 0x83CC} /* 43 */,
  {-1, 0, 0x83DC} /* 44 */,
  {-1, 0, 0x83CA} /* 45 */,
  {-1, 0, 0x83F2} /* 46 */,
  {-1, 0, 0x840E} /* 47 */,
  {-1, 0, 0x8404} /* 48 */,
  {-1, 0, 0x843D} /* 49 */,
  {-1, 0, 0x8482} /* 4A */,
  {-1, 0, 0x8431} /* 4B */,
  {-1, 0, 0x8475} /* 4C */,
  {-1, 0, 0x8466} /* 4D */,
  {-1, 0, 0x8457} /* 4E */,
  {-1, 0, 0x8449} /* 4F */,
  {-1, 0, 0x846C} /* 50 */,
  {-1, 0, 0x846B} /* 51 */,
  {-1, 0, 0x845B} /* 52 */,
  {-1, 0, 0x8477} /* 53 */,
  {-1, 0, 0x843C} /* 54 */,
  {-1, 0, 0x8435} /* 55 */,
  {-1, 0, 0x8461} /* 56 */,
  {-1, 0, 0x8463} /* 57 */,
  {-1, 0, 0x8469} /* 58 */,
  {-1, 0, 0x8438} /* 59 */,
  {-1, 0, 0x84B2} /* 5A */,
  {-1, 0, 0x849E} /* 5B */,
  {-1, 0, 0x84BF} /* 5C */,
  {-1, 0, 0x84C6} /* 5D */,
  {-1, 0, 0x84C4} /* 5E */,
  {-1, 0, 0x84C9} /* 5F */,
  {-1, 0, 0x849C} /* 60 */,
  {-1, 0, 0x84CB} /* 61 */,
  {-1, 0, 0x84B8} /* 62 */,
  {-1, 0, 0x84C0} /* 63 */,
  {-1, 0, 0x8499} /* 64 */,
  {-1, 0, 0x84D3} /* 65 */,
  {-1, 0, 0x8490} /* 66 */,
  {-1, 0, 0x84BC} /* 67 */,
  {-1, 0, 0x853D} /* 68 */,
  {-1, 0, 0x84FF} /* 69 */,
  {-1, 0, 0x8517} /* 6A */,
  {-1, 0, 0x851A} /* 6B */,
  {-1, 0, 0x84EE} /* 6C */,
  {-1, 0, 0x852C} /* 6D */,
  {-1, 0, 0x852D} /* 6E */,
  {-1, 0, 0x8513} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x8523} /* 71 */,
  {-1, 0, 0x8521} /* 72 */,
  {-1, 0, 0x8514} /* 73 */,
  {-1, 0, 0x84EC} /* 74 */,
  {-1, 0, 0x8525} /* 75 */,
  {-1, 0, 0x8569} /* 76 */,
  {-1, 0, 0x854A} /* 77 */,
  {-1, 0, 0x8559} /* 78 */,
  {-1, 0, 0x8548} /* 79 */,
  {-1, 0, 0x8568} /* 7A */,
  {-1, 0, 0x8543} /* 7B */,
  {-1, 0, 0x856A} /* 7C */,
  {-1, 0, 0x8549} /* 7D */,
  {-1, 0, 0x8584} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page40 = {
  0, marc8_9page40_dir
};
/* PAGE 39 */
struct yaz_iconv_trie_dir marc8_9page39_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x81DA} /* 21 */,
  {-1, 0, 0x81DF} /* 22 */,
  {-1, 0, 0x81E3} /* 23 */,
  {-1, 0, 0x81E5} /* 24 */,
  {-1, 0, 0x81E8} /* 25 */,
  {-1, 0, 0x81EA} /* 26 */,
  {-1, 0, 0x81EC} /* 27 */,
  {-1, 0, 0x81ED} /* 28 */,
  {-1, 0, 0x81F3} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0x81FA} /* 2B */,
  {-1, 0, 0x81FB} /* 2C */,
  {-1, 0, 0x81FC} /* 2D */,
  {-1, 0, 0x81FE} /* 2E */,
  {-1, 0, 0x8200} /* 2F */,
  {-1, 0, 0x8202} /* 30 */,
  {-1, 0, 0x8205} /* 31 */,
  {-1, 0, 0x8207} /* 32 */,
  {-1, 0, 0x8208} /* 33 */,
  {-1, 0, 0x8209} /* 34 */,
  {-1, 0, 0x820A} /* 35 */,
  {-1, 0, 0x820C} /* 36 */,
  {-1, 0, 0x820D} /* 37 */,
  {-1, 0, 0x8210} /* 38 */,
  {-1, 0, 0x8212} /* 39 */,
  {-1, 0, 0x8214} /* 3A */,
  {-1, 0, 0x821B} /* 3B */,
  {-1, 0, 0x821C} /* 3C */,
  {-1, 0, 0x821E} /* 3D */,
  {-1, 0, 0x821F} /* 3E */,
  {-1, 0, 0x8222} /* 3F */,
  {-1, 0, 0x822A} /* 40 */,
  {-1, 0, 0x822B} /* 41 */,
  {-1, 0, 0x822C} /* 42 */,
  {-1, 0, 0x8228} /* 43 */,
  {-1, 0, 0x8237} /* 44 */,
  {-1, 0, 0x8235} /* 45 */,
  {-1, 0, 0x8239} /* 46 */,
  {-1, 0, 0x8236} /* 47 */,
  {-1, 0, 0x8247} /* 48 */,
  {-1, 0, 0x8258} /* 49 */,
  {-1, 0, 0x8259} /* 4A */,
  {-1, 0, 0x8266} /* 4B */,
  {-1, 0, 0x826E} /* 4C */,
  {-1, 0, 0x826F} /* 4D */,
  {-1, 0, 0x8271} /* 4E */,
  {-1, 0, 0x8272} /* 4F */,
  {-1, 0, 0x827E} /* 50 */,
  {-1, 0, 0x8292} /* 51 */,
  {-1, 0, 0x828B} /* 52 */,
  {-1, 0, 0x828D} /* 53 */,
  {-1, 0, 0x82B3} /* 54 */,
  {-1, 0, 0x829D} /* 55 */,
  {-1, 0, 0x8299} /* 56 */,
  {-1, 0, 0x82BD} /* 57 */,
  {-1, 0, 0x82AD} /* 58 */,
  {-1, 0, 0x82AC} /* 59 */,
  {-1, 0, 0x82A5} /* 5A */,
  {-1, 0, 0x829F} /* 5B */,
  {-1, 0, 0x82BB} /* 5C */,
  {-1, 0, 0x82B1} /* 5D */,
  {-1, 0, 0x82B9} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0x82E7} /* 60 */,
  {-1, 0, 0x8305} /* 61 */,
  {-1, 0, 0x8309} /* 62 */,
  {-1, 0, 0x82E3} /* 63 */,
  {-1, 0, 0x82DB} /* 64 */,
  {-1, 0, 0x82E6} /* 65 */,
  {-1, 0, 0x8304} /* 66 */,
  {-1, 0, 0x82E5} /* 67 */,
  {-1, 0, 0x8302} /* 68 */,
  {-1, 0, 0x82DC} /* 69 */,
  {-1, 0, 0x82D7} /* 6A */,
  {-1, 0, 0x82F1} /* 6B */,
  {-1, 0, 0x8301} /* 6C */,
  {-1, 0, 0x82D3} /* 6D */,
  {-1, 0, 0x82D4} /* 6E */,
  {-1, 0, 0x82D1} /* 6F */,
  {-1, 0, 0x82DE} /* 70 */,
  {-1, 0, 0x82DF} /* 71 */,
  {-1, 0, 0x832B} /* 72 */,
  {-1, 0, 0x8352} /* 73 */,
  {-1, 0, 0x834A} /* 74 */,
  {-1, 0, 0x8338} /* 75 */,
  {-1, 0, 0x8354} /* 76 */,
  {-1, 0, 0x8350} /* 77 */,
  {-1, 0, 0x8349} /* 78 */,
  {-1, 0, 0x8335} /* 79 */,
  {-1, 0, 0x8334} /* 7A */,
  {-1, 0, 0x8336} /* 7B */,
  {-1, 0, 0x8331} /* 7C */,
  {-1, 0, 0x8340} /* 7D */,
  {-1, 0, 0x8317} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page39 = {
  0, marc8_9page39_dir
};
/* PAGE 38 */
struct yaz_iconv_trie_dir marc8_9page38_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x8085} /* 21 */,
  {-1, 0, 0x8087} /* 22 */,
  {-1, 0, 0x8089} /* 23 */,
  {-1, 0, 0x808B} /* 24 */,
  {-1, 0, 0x808C} /* 25 */,
  {-1, 0, 0x8093} /* 26 */,
  {-1, 0, 0x809D} /* 27 */,
  {-1, 0, 0x8098} /* 28 */,
  {-1, 0, 0x809B} /* 29 */,
  {-1, 0, 0x809A} /* 2A */,
  {-1, 0, 0x8096} /* 2B */,
  {-1, 0, 0x80B2} /* 2C */,
  {-1, 0, 0x80AA} /* 2D */,
  {-1, 0, 0x80BA} /* 2E */,
  {-1, 0, 0x80A5} /* 2F */,
  {-1, 0, 0x80A2} /* 30 */,
  {-1, 0, 0x80AB} /* 31 */,
  {-1, 0, 0x80B1} /* 32 */,
  {-1, 0, 0x80AF} /* 33 */,
  {-1, 0, 0x80A1} /* 34 */,
  {-1, 0, 0x80A9} /* 35 */,
  {-1, 0, 0x80B4} /* 36 */,
  {-1, 0, 0x80D6} /* 37 */,
  {-1, 0, 0x80CC} /* 38 */,
  {-1, 0, 0x80E5} /* 39 */,
  {-1, 0, 0x80DA} /* 3A */,
  {-1, 0, 0x80E1} /* 3B */,
  {-1, 0, 0x80C3} /* 3C */,
  {-1, 0, 0x80DB} /* 3D */,
  {-1, 0, 0x80C4} /* 3E */,
  {-1, 0, 0x80CE} /* 3F */,
  {-1, 0, 0x80DE} /* 40 */,
  {-1, 0, 0x80E4} /* 41 */,
  {-1, 0, 0x80F0} /* 42 */,
  {-1, 0, 0x8102} /* 43 */,
  {-1, 0, 0x8105} /* 44 */,
  {-1, 0, 0x80F1} /* 45 */,
  {-1, 0, 0x80F4} /* 46 */,
  {-1, 0, 0x80ED} /* 47 */,
  {-1, 0, 0x80FD} /* 48 */,
  {-1, 0, 0x8106} /* 49 */,
  {-1, 0, 0x80F3} /* 4A */,
  {-1, 0, 0x80F8} /* 4B */,
  {-1, 0, 0x810A} /* 4C */,
  {-1, 0, 0x8108} /* 4D */,
  {-1, 0, 0x812B} /* 4E */,
  {-1, 0, 0x812F} /* 4F */,
  {-1, 0, 0x8116} /* 50 */,
  {-1, 0, 0},
  {-1, 0, 0x8129} /* 52 */,
  {-1, 0, 0x8155} /* 53 */,
  {-1, 0, 0x8154} /* 54 */,
  {-1, 0, 0x814B} /* 55 */,
  {-1, 0, 0x8151} /* 56 */,
  {-1, 0, 0x8150} /* 57 */,
  {-1, 0, 0x814E} /* 58 */,
  {-1, 0, 0x8139} /* 59 */,
  {-1, 0, 0x8146} /* 5A */,
  {-1, 0, 0x813E} /* 5B */,
  {-1, 0, 0x8171} /* 5C */,
  {-1, 0, 0x8170} /* 5D */,
  {-1, 0, 0x8178} /* 5E */,
  {-1, 0, 0x8165} /* 5F */,
  {-1, 0, 0x816E} /* 60 */,
  {-1, 0, 0x8173} /* 61 */,
  {-1, 0, 0x816B} /* 62 */,
  {-1, 0, 0x8179} /* 63 */,
  {-1, 0, 0x817A} /* 64 */,
  {-1, 0, 0x8166} /* 65 */,
  {-1, 0, 0x8180} /* 66 */,
  {-1, 0, 0x818F} /* 67 */,
  {-1, 0, 0x817F} /* 68 */,
  {-1, 0, 0x818A} /* 69 */,
  {-1, 0, 0x8188} /* 6A */,
  {-1, 0, 0x819D} /* 6B */,
  {-1, 0, 0x81A0} /* 6C */,
  {-1, 0, 0x819B} /* 6D */,
  {-1, 0, 0x819A} /* 6E */,
  {-1, 0, 0x819C} /* 6F */,
  {-1, 0, 0x81B3} /* 70 */,
  {-1, 0, 0x81A9} /* 71 */,
  {-1, 0, 0x81A8} /* 72 */,
  {-1, 0, 0x81C6} /* 73 */,
  {-1, 0, 0x81BA} /* 74 */,
  {-1, 0, 0x81C3} /* 75 */,
  {-1, 0, 0x81C0} /* 76 */,
  {-1, 0, 0x81C2} /* 77 */,
  {-1, 0, 0x81BF} /* 78 */,
  {-1, 0, 0x81BD} /* 79 */,
  {-1, 0, 0x81C9} /* 7A */,
  {-1, 0, 0x81BE} /* 7B */,
  {-1, 0, 0x81CD} /* 7C */,
  {-1, 0, 0x81CF} /* 7D */,
  {-1, 0, 0x81D8} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page38 = {
  0, marc8_9page38_dir
};
/* PAGE 37 */
struct yaz_iconv_trie_dir marc8_9page37_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7E8C} /* 21 */,
  {-1, 0, 0x7E93} /* 22 */,
  {-1, 0, 0x7E96} /* 23 */,
  {-1, 0, 0x7E9C} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x7F38} /* 26 */,
  {-1, 0, 0x7F3A} /* 27 */,
  {-1, 0, 0x7F3D} /* 28 */,
  {-1, 0, 0x7F44} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0x7F50} /* 2B */,
  {-1, 0, 0x7F55} /* 2C */,
  {-1, 0, 0x7F54} /* 2D */,
  {-1, 0, 0x7F5F} /* 2E */,
  {-1, 0, 0x7F72} /* 2F */,
  {-1, 0, 0x7F6E} /* 30 */,
  {-1, 0, 0x7F69} /* 31 */,
  {-1, 0, 0x7F6A} /* 32 */,
  {-1, 0, 0x7F70} /* 33 */,
  {-1, 0, 0x7F75} /* 34 */,
  {-1, 0, 0x7F77} /* 35 */,
  {-1, 0, 0x7F79} /* 36 */,
  {-1, 0, 0x7F85} /* 37 */,
  {-1, 0, 0x7F88} /* 38 */,
  {-1, 0, 0x7F8A} /* 39 */,
  {-1, 0, 0x7F8C} /* 3A */,
  {-1, 0, 0x7F8E} /* 3B */,
  {-1, 0, 0x7F94} /* 3C */,
  {-1, 0, 0x7F9E} /* 3D */,
  {-1, 0, 0x7F9A} /* 3E */,
  {-1, 0, 0x5584} /* 3F */,
  {-1, 0, 0x7FA8} /* 40 */,
  {-1, 0, 0x7FA4} /* 41 */,
  {-1, 0, 0x7FA9} /* 42 */,
  {-1, 0, 0x7FAF} /* 43 */,
  {-1, 0, 0x7FB2} /* 44 */,
  {-1, 0, 0x7FB6} /* 45 */,
  {-1, 0, 0x7FB8} /* 46 */,
  {-1, 0, 0x7FB9} /* 47 */,
  {-1, 0, 0x7FBD} /* 48 */,
  {-1, 0, 0x7FBF} /* 49 */,
  {-1, 0, 0x7FC5} /* 4A */,
  {-1, 0, 0x7FC1} /* 4B */,
  {-1, 0, 0x7FCC} /* 4C */,
  {-1, 0, 0x7FD2} /* 4D */,
  {-1, 0, 0xE94D} /* 4E */,
  {-1, 0, 0x7FD4} /* 4F */,
  {-1, 0, 0x7FD5} /* 50 */,
  {-1, 0, 0x7FE0} /* 51 */,
  {-1, 0, 0x7FE1} /* 52 */,
  {-1, 0, 0x7FDF} /* 53 */,
  {-1, 0, 0x7FE9} /* 54 */,
  {-1, 0, 0x7FF0} /* 55 */,
  {-1, 0, 0x7FF3} /* 56 */,
  {-1, 0, 0x7FFC} /* 57 */,
  {-1, 0, 0x7FF9} /* 58 */,
  {-1, 0, 0x7FFB} /* 59 */,
  {-1, 0, 0x7FF1} /* 5A */,
  {-1, 0, 0x8000} /* 5B */,
  {-1, 0, 0x8001} /* 5C */,
  {-1, 0, 0x8003} /* 5D */,
  {-1, 0, 0x8006} /* 5E */,
  {-1, 0, 0x8005} /* 5F */,
  {-1, 0, 0x800C} /* 60 */,
  {-1, 0, 0x8010} /* 61 */,
  {-1, 0, 0x800D} /* 62 */,
  {-1, 0, 0x8012} /* 63 */,
  {-1, 0, 0x8015} /* 64 */,
  {-1, 0, 0x8018} /* 65 */,
  {-1, 0, 0x8019} /* 66 */,
  {-1, 0, 0x8017} /* 67 */,
  {-1, 0, 0x801C} /* 68 */,
  {-1, 0, 0x8033} /* 69 */,
  {-1, 0, 0x8036} /* 6A */,
  {-1, 0, 0x803F} /* 6B */,
  {-1, 0, 0x803D} /* 6C */,
  {-1, 0, 0x804A} /* 6D */,
  {-1, 0, 0x8046} /* 6E */,
  {-1, 0, 0x8056} /* 6F */,
  {-1, 0, 0x8058} /* 70 */,
  {-1, 0, 0x805E} /* 71 */,
  {-1, 0, 0x805A} /* 72 */,
  {-1, 0, 0x8071} /* 73 */,
  {-1, 0, 0x8072} /* 74 */,
  {-1, 0, 0x8073} /* 75 */,
  {-1, 0, 0x8070} /* 76 */,
  {-1, 0, 0x806F} /* 77 */,
  {-1, 0, 0x8077} /* 78 */,
  {-1, 0, 0x8076} /* 79 */,
  {-1, 0, 0x807E} /* 7A */,
  {-1, 0, 0x807D} /* 7B */,
  {-1, 0, 0x807F} /* 7C */,
  {-1, 0, 0},
  {-1, 0, 0x8084} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page37 = {
  0, marc8_9page37_dir
};
/* PAGE 36 */
struct yaz_iconv_trie_dir marc8_9page36_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7D17} /* 21 */,
  {-1, 0, 0xE94B} /* 22 */,
  {-1, 0, 0x7D1A} /* 23 */,
  {-1, 0, 0x7D19} /* 24 */,
  {-1, 0, 0x7D1B} /* 25 */,
  {-1, 0, 0x7D46} /* 26 */,
  {-1, 0, 0},
  {-1, 0, 0x7D3C} /* 28 */,
  {-1, 0, 0x7D2E} /* 29 */,
  {-1, 0, 0x7D39} /* 2A */,
  {-1, 0, 0x7D44} /* 2B */,
  {-1, 0, 0x7D30} /* 2C */,
  {-1, 0, 0x7D33} /* 2D */,
  {-1, 0, 0x7D2F} /* 2E */,
  {-1, 0, 0x7D40} /* 2F */,
  {-1, 0, 0x7D42} /* 30 */,
  {-1, 0, 0x7D71} /* 31 */,
  {-1, 0, 0x7D5E} /* 32 */,
  {-1, 0, 0x7D68} /* 33 */,
  {-1, 0, 0x7D50} /* 34 */,
  {-1, 0, 0x7D2B} /* 35 */,
  {-1, 0, 0x7D62} /* 36 */,
  {-1, 0, 0x7D76} /* 37 */,
  {-1, 0, 0x7D61} /* 38 */,
  {-1, 0, 0x7D66} /* 39 */,
  {-1, 0, 0x7D6E} /* 3A */,
  {-1, 0, 0x7D72} /* 3B */,
  {-1, 0, 0x7D93} /* 3C */,
  {-1, 0, 0x7D91} /* 3D */,
  {-1, 0, 0x7D79} /* 3E */,
  {-1, 0, 0x7D8F} /* 3F */,
  {-1, 0, 0x7D81} /* 40 */,
  {-1, 0, 0x7D9C} /* 41 */,
  {-1, 0, 0x7DBB} /* 42 */,
  {-1, 0, 0x7DB0} /* 43 */,
  {-1, 0, 0x7DCA} /* 44 */,
  {-1, 0, 0x7DBE} /* 45 */,
  {-1, 0, 0x7DB4} /* 46 */,
  {-1, 0, 0x7DBA} /* 47 */,
  {-1, 0, 0x7DB2} /* 48 */,
  {-1, 0, 0x7DB1} /* 49 */,
  {-1, 0, 0x7DBD} /* 4A */,
  {-1, 0, 0x7DB5} /* 4B */,
  {-1, 0, 0x7DA0} /* 4C */,
  {-1, 0, 0x7DA2} /* 4D */,
  {-1, 0, 0x7DAD} /* 4E */,
  {-1, 0, 0x7DBF} /* 4F */,
  {-1, 0, 0x7DB8} /* 50 */,
  {-1, 0, 0x7DC7} /* 51 */,
  {-1, 0, 0x7DE0} /* 52 */,
  {-1, 0, 0x7DEF} /* 53 */,
  {-1, 0, 0xE94C} /* 54 */,
  {-1, 0, 0x7DD6} /* 55 */,
  {-1, 0, 0x7DD8} /* 56 */,
  {-1, 0, 0x7DEC} /* 57 */,
  {-1, 0, 0x7DDD} /* 58 */,
  {-1, 0, 0x7DE9} /* 59 */,
  {-1, 0, 0x7DE3} /* 5A */,
  {-1, 0, 0x7DE8} /* 5B */,
  {-1, 0, 0x7DDA} /* 5C */,
  {-1, 0, 0x7D9E} /* 5D */,
  {-1, 0, 0x7DDE} /* 5E */,
  {-1, 0, 0x7E11} /* 5F */,
  {-1, 0, 0x7E0A} /* 60 */,
  {-1, 0, 0x7E08} /* 61 */,
  {-1, 0, 0x7E1B} /* 62 */,
  {-1, 0, 0x7DFB} /* 63 */,
  {-1, 0, 0x7E23} /* 64 */,
  {-1, 0, 0x7E2E} /* 65 */,
  {-1, 0, 0x7E3E} /* 66 */,
  {-1, 0, 0x7E46} /* 67 */,
  {-1, 0, 0x7E37} /* 68 */,
  {-1, 0, 0x7E32} /* 69 */,
  {-1, 0, 0x7E43} /* 6A */,
  {-1, 0, 0x7E41} /* 6B */,
  {-1, 0, 0x7E2B} /* 6C */,
  {-1, 0, 0x7E3D} /* 6D */,
  {-1, 0, 0x7E31} /* 6E */,
  {-1, 0, 0x7E45} /* 6F */,
  {-1, 0, 0x7E55} /* 70 */,
  {-1, 0, 0x7E54} /* 71 */,
  {-1, 0, 0x7E61} /* 72 */,
  {-1, 0, 0x7E5E} /* 73 */,
  {-1, 0, 0x7E5A} /* 74 */,
  {-1, 0, 0x7E6B} /* 75 */,
  {-1, 0, 0x7E69} /* 76 */,
  {-1, 0, 0x7E6D} /* 77 */,
  {-1, 0, 0x7E79} /* 78 */,
  {-1, 0, 0x7E6A} /* 79 */,
  {-1, 0, 0x8FAE} /* 7A */,
  {-1, 0, 0x7E7D} /* 7B */,
  {-1, 0, 0x7E82} /* 7C */,
  {-1, 0, 0x7E7C} /* 7D */,
  {-1, 0, 0x7E8F} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page36 = {
  0, marc8_9page36_dir
};
/* PAGE 35 */
struct yaz_iconv_trie_dir marc8_9page35_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7B4D} /* 21 */,
  {-1, 0, 0x7B4F} /* 22 */,
  {-1, 0, 0x7B54} /* 23 */,
  {-1, 0, 0x7B60} /* 24 */,
  {-1, 0, 0x7B77} /* 25 */,
  {-1, 0, 0x7B75} /* 26 */,
  {-1, 0, 0x7BA1} /* 27 */,
  {-1, 0, 0x7B94} /* 28 */,
  {-1, 0, 0x7B95} /* 29 */,
  {-1, 0, 0x7B9D} /* 2A */,
  {-1, 0, 0x7B8B} /* 2B */,
  {-1, 0, 0x7B97} /* 2C */,
  {-1, 0, 0x7B8F} /* 2D */,
  {-1, 0, 0x7BC7} /* 2E */,
  {-1, 0, 0x7BAD} /* 2F */,
  {-1, 0, 0x7BC4} /* 30 */,
  {-1, 0, 0x7BB1} /* 31 */,
  {-1, 0, 0x7BB4} /* 32 */,
  {-1, 0, 0x7BC0} /* 33 */,
  {-1, 0, 0x7BC6} /* 34 */,
  {-1, 0, 0x7BC1} /* 35 */,
  {-1, 0, 0x7C11} /* 36 */,
  {-1, 0, 0x7BD9} /* 37 */,
  {-1, 0, 0x7BDB} /* 38 */,
  {-1, 0, 0x7BE4} /* 39 */,
  {-1, 0, 0x7BC9} /* 3A */,
  {-1, 0, 0x7BE1} /* 3B */,
  {-1, 0, 0x7BE9} /* 3C */,
  {-1, 0, 0x7C07} /* 3D */,
  {-1, 0, 0x7C0D} /* 3E */,
  {-1, 0, 0x7BFE} /* 3F */,
  {-1, 0, 0x7BF7} /* 40 */,
  {-1, 0, 0x7C21} /* 41 */,
  {-1, 0, 0x7C2B} /* 42 */,
  {-1, 0, 0x7C2A} /* 43 */,
  {-1, 0, 0x7C27} /* 44 */,
  {-1, 0, 0x7C1E} /* 45 */,
  {-1, 0, 0x7C23} /* 46 */,
  {-1, 0, 0x7C3F} /* 47 */,
  {-1, 0, 0x7C3E} /* 48 */,
  {-1, 0, 0x7C38} /* 49 */,
  {-1, 0, 0x7C37} /* 4A */,
  {-1, 0, 0x7C3D} /* 4B */,
  {-1, 0, 0x7C43} /* 4C */,
  {-1, 0, 0x7C4C} /* 4D */,
  {-1, 0, 0x7C4D} /* 4E */,
  {-1, 0, 0x7C50} /* 4F */,
  {-1, 0, 0x7C60} /* 50 */,
  {-1, 0, 0x7C5F} /* 51 */,
  {-1, 0, 0x7C64} /* 52 */,
  {-1, 0, 0x7C6C} /* 53 */,
  {-1, 0, 0x7C6E} /* 54 */,
  {-1, 0, 0x7C72} /* 55 */,
  {-1, 0, 0x7C73} /* 56 */,
  {-1, 0, 0x7C89} /* 57 */,
  {-1, 0, 0x7C92} /* 58 */,
  {-1, 0, 0x7C97} /* 59 */,
  {-1, 0, 0x7C9F} /* 5A */,
  {-1, 0, 0x7CA5} /* 5B */,
  {-1, 0, 0x7CA4} /* 5C */,
  {-1, 0, 0x7CB1} /* 5D */,
  {-1, 0, 0x7CB3} /* 5E */,
  {-1, 0, 0x7CBD} /* 5F */,
  {-1, 0, 0x7CB9} /* 60 */,
  {-1, 0, 0xFA1D} /* 61 */,
  {-1, 0, 0x7CCA} /* 62 */,
  {-1, 0, 0x7CD6} /* 63 */,
  {-1, 0, 0x7CD5} /* 64 */,
  {-1, 0, 0x7CE0} /* 65 */,
  {-1, 0, 0x7CDC} /* 66 */,
  {-1, 0, 0x7CDF} /* 67 */,
  {-1, 0, 0x7CDE} /* 68 */,
  {-1, 0, 0x7CE2} /* 69 */,
  {-1, 0, 0x7CD9} /* 6A */,
  {-1, 0, 0x7CE7} /* 6B */,
  {-1, 0, 0x7CEF} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0x7CFB} /* 6E */,
  {-1, 0, 0x7CFE} /* 6F */,
  {-1, 0, 0x7D00} /* 70 */,
  {-1, 0, 0x7D02} /* 71 */,
  {-1, 0, 0x7D05} /* 72 */,
  {-1, 0, 0x7D09} /* 73 */,
  {-1, 0, 0x7D04} /* 74 */,
  {-1, 0, 0x7D07} /* 75 */,
  {-1, 0, 0x7D21} /* 76 */,
  {-1, 0, 0x7D0B} /* 77 */,
  {-1, 0, 0x7D0A} /* 78 */,
  {-1, 0, 0x7D20} /* 79 */,
  {-1, 0, 0x7D1C} /* 7A */,
  {-1, 0, 0x7D22} /* 7B */,
  {-1, 0, 0x7D15} /* 7C */,
  {-1, 0, 0x7D14} /* 7D */,
  {-1, 0, 0x7D10} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page35 = {
  0, marc8_9page35_dir
};
/* PAGE 34 */
struct yaz_iconv_trie_dir marc8_9page34_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x79BD} /* 21 */,
  {-1, 0, 0x842C} /* 22 */,
  {-1, 0, 0x79BE} /* 23 */,
  {-1, 0, 0x79C0} /* 24 */,
  {-1, 0, 0x79C1} /* 25 */,
  {-1, 0, 0x79BF} /* 26 */,
  {-1, 0, 0x79C9} /* 27 */,
  {-1, 0, 0x79D1} /* 28 */,
  {-1, 0, 0x79CB} /* 29 */,
  {-1, 0, 0x79D2} /* 2A */,
  {-1, 0, 0x79E4} /* 2B */,
  {-1, 0, 0x79E6} /* 2C */,
  {-1, 0, 0x79E3} /* 2D */,
  {-1, 0, 0x79DF} /* 2E */,
  {-1, 0, 0x79E7} /* 2F */,
  {-1, 0, 0x79E9} /* 30 */,
  {-1, 0, 0x79FB} /* 31 */,
  {-1, 0, 0x7A05} /* 32 */,
  {-1, 0, 0x7A0D} /* 33 */,
  {-1, 0, 0x7A08} /* 34 */,
  {-1, 0, 0x7A0B} /* 35 */,
  {-1, 0, 0x7A00} /* 36 */,
  {-1, 0, 0x7A1F} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0x7A20} /* 39 */,
  {-1, 0, 0x7A1A} /* 3A */,
  {-1, 0, 0x7A14} /* 3B */,
  {-1, 0, 0x7A31} /* 3C */,
  {-1, 0, 0x7A2E} /* 3D */,
  {-1, 0, 0x7A3F} /* 3E */,
  {-1, 0, 0x7A3C} /* 3F */,
  {-1, 0, 0x7A40} /* 40 */,
  {-1, 0, 0x7A3D} /* 41 */,
  {-1, 0, 0x7A37} /* 42 */,
  {-1, 0, 0x7A3B} /* 43 */,
  {-1, 0, 0x7A4D} /* 44 */,
  {-1, 0, 0x7A4E} /* 45 */,
  {-1, 0, 0x7A4C} /* 46 */,
  {-1, 0, 0x7A46} /* 47 */,
  {-1, 0, 0x7A57} /* 48 */,
  {-1, 0, 0x7A61} /* 49 */,
  {-1, 0, 0x7A62} /* 4A */,
  {-1, 0, 0x7A6B} /* 4B */,
  {-1, 0, 0x7A69} /* 4C */,
  {-1, 0, 0x7A74} /* 4D */,
  {-1, 0, 0x7A76} /* 4E */,
  {-1, 0, 0x7A79} /* 4F */,
  {-1, 0, 0x7A7A} /* 50 */,
  {-1, 0, 0x7A7F} /* 51 */,
  {-1, 0, 0x7A81} /* 52 */,
  {-1, 0, 0x7A84} /* 53 */,
  {-1, 0, 0x7A88} /* 54 */,
  {-1, 0, 0x7A92} /* 55 */,
  {-1, 0, 0x7A95} /* 56 */,
  {-1, 0, 0x7A98} /* 57 */,
  {-1, 0, 0x7A96} /* 58 */,
  {-1, 0, 0x7A97} /* 59 */,
  {-1, 0, 0x7A9F} /* 5A */,
  {-1, 0, 0x7AA0} /* 5B */,
  {-1, 0, 0x7AAA} /* 5C */,
  {-1, 0, 0x7AA9} /* 5D */,
  {-1, 0, 0x7AAF} /* 5E */,
  {-1, 0, 0x7AAE} /* 5F */,
  {-1, 0, 0x7ABA} /* 60 */,
  {-1, 0, 0x7AC5} /* 61 */,
  {-1, 0, 0x7AC4} /* 62 */,
  {-1, 0, 0x7AC7} /* 63 */,
  {-1, 0, 0x7ACA} /* 64 */,
  {-1, 0, 0x7ACB} /* 65 */,
  {-1, 0, 0x7AD9} /* 66 */,
  {-1, 0, 0x7AE5} /* 67 */,
  {-1, 0, 0x7AE3} /* 68 */,
  {-1, 0, 0x7AED} /* 69 */,
  {-1, 0, 0x7AEF} /* 6A */,
  {-1, 0, 0x7AF6} /* 6B */,
  {-1, 0, 0x7AF9} /* 6C */,
  {-1, 0, 0x7AFA} /* 6D */,
  {-1, 0, 0x7AFF} /* 6E */,
  {-1, 0, 0x7AFD} /* 6F */,
  {-1, 0, 0x7B06} /* 70 */,
  {-1, 0, 0x7B11} /* 71 */,
  {-1, 0, 0x7B20} /* 72 */,
  {-1, 0, 0x7B2C} /* 73 */,
  {-1, 0, 0x7B28} /* 74 */,
  {-1, 0, 0x7B1B} /* 75 */,
  {-1, 0, 0x7B1E} /* 76 */,
  {-1, 0, 0x7B19} /* 77 */,
  {-1, 0, 0x7B26} /* 78 */,
  {-1, 0, 0x7B46} /* 79 */,
  {-1, 0, 0x7B49} /* 7A */,
  {-1, 0, 0x7B50} /* 7B */,
  {-1, 0, 0x7B56} /* 7C */,
  {-1, 0, 0x7B52} /* 7D */,
  {-1, 0, 0x7B4B} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page34 = {
  0, marc8_9page34_dir
};
/* PAGE 33 */
struct yaz_iconv_trie_dir marc8_9page33_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x77E2} /* 21 */,
  {-1, 0, 0x77E3} /* 22 */,
  {-1, 0, 0x77E5} /* 23 */,
  {-1, 0, 0x77E9} /* 24 */,
  {-1, 0, 0x77ED} /* 25 */,
  {-1, 0, 0x77EE} /* 26 */,
  {-1, 0, 0x77EF} /* 27 */,
  {-1, 0, 0x77F3} /* 28 */,
  {-1, 0, 0x77FD} /* 29 */,
  {-1, 0, 0x7802} /* 2A */,
  {-1, 0, 0x780D} /* 2B */,
  {-1, 0, 0x780C} /* 2C */,
  {-1, 0, 0x65AB} /* 2D */,
  {-1, 0, 0x7830} /* 2E */,
  {-1, 0, 0x781D} /* 2F */,
  {-1, 0, 0x7834} /* 30 */,
  {-1, 0, 0x7838} /* 31 */,
  {-1, 0, 0x7837} /* 32 */,
  {-1, 0, 0x7827} /* 33 */,
  {-1, 0, 0x782D} /* 34 */,
  {-1, 0, 0x7825} /* 35 */,
  {-1, 0, 0x786B} /* 36 */,
  {-1, 0, 0x784F} /* 37 */,
  {-1, 0, 0x7843} /* 38 */,
  {-1, 0, 0x786C} /* 39 */,
  {-1, 0, 0x785D} /* 3A */,
  {-1, 0, 0x786F} /* 3B */,
  {-1, 0, 0x78B0} /* 3C */,
  {-1, 0, 0x7897} /* 3D */,
  {-1, 0, 0x788E} /* 3E */,
  {-1, 0, 0x7898} /* 3F */,
  {-1, 0, 0x7889} /* 40 */,
  {-1, 0, 0x7891} /* 41 */,
  {-1, 0, 0x787C} /* 42 */,
  {-1, 0, 0x788C} /* 43 */,
  {-1, 0, 0x78A7} /* 44 */,
  {-1, 0, 0x78A9} /* 45 */,
  {-1, 0, 0x789F} /* 46 */,
  {-1, 0, 0x78B3} /* 47 */,
  {-1, 0, 0x78CB} /* 48 */,
  {-1, 0, 0x78BA} /* 49 */,
  {-1, 0, 0x78C1} /* 4A */,
  {-1, 0, 0x78C5} /* 4B */,
  {-1, 0, 0x78BC} /* 4C */,
  {-1, 0, 0x78D5} /* 4D */,
  {-1, 0, 0x78BE} /* 4E */,
  {-1, 0, 0x78CA} /* 4F */,
  {-1, 0, 0x78D0} /* 50 */,
  {-1, 0, 0x78E8} /* 51 */,
  {-1, 0, 0x78EC} /* 52 */,
  {-1, 0, 0x78DA} /* 53 */,
  {-1, 0, 0x78F7} /* 54 */,
  {-1, 0, 0x78F4} /* 55 */,
  {-1, 0, 0xE94A} /* 56 */,
  {-1, 0, 0x7901} /* 57 */,
  {-1, 0, 0x78EF} /* 58 */,
  {-1, 0, 0x790E} /* 59 */,
  {-1, 0, 0x7919} /* 5A */,
  {-1, 0, 0x7926} /* 5B */,
  {-1, 0, 0x792C} /* 5C */,
  {-1, 0, 0x792A} /* 5D */,
  {-1, 0, 0x792B} /* 5E */,
  {-1, 0, 0x793A} /* 5F */,
  {-1, 0, 0x7940} /* 60 */,
  {-1, 0, 0x793E} /* 61 */,
  {-1, 0, 0x7941} /* 62 */,
  {-1, 0, 0x7945} /* 63 */,
  {-1, 0, 0x7949} /* 64 */,
  {-1, 0, 0x7948} /* 65 */,
  {-1, 0, 0x7947} /* 66 */,
  {-1, 0, 0x7955} /* 67 */,
  {-1, 0, 0x7960} /* 68 */,
  {-1, 0, 0x7950} /* 69 */,
  {-1, 0, 0x7956} /* 6A */,
  {-1, 0, 0x795E} /* 6B */,
  {-1, 0, 0x795D} /* 6C */,
  {-1, 0, 0x795F} /* 6D */,
  {-1, 0, 0x795A} /* 6E */,
  {-1, 0, 0x7957} /* 6F */,
  {-1, 0, 0x7965} /* 70 */,
  {-1, 0, 0x7968} /* 71 */,
  {-1, 0, 0x796D} /* 72 */,
  {-1, 0, 0x797A} /* 73 */,
  {-1, 0, 0x7981} /* 74 */,
  {-1, 0, 0x797F} /* 75 */,
  {-1, 0, 0x798F} /* 76 */,
  {-1, 0, 0x798D} /* 77 */,
  {-1, 0, 0x798E} /* 78 */,
  {-1, 0, 0x79A6} /* 79 */,
  {-1, 0, 0x79A7} /* 7A */,
  {-1, 0, 0x79AA} /* 7B */,
  {-1, 0, 0x79AE} /* 7C */,
  {-1, 0, 0x79B1} /* 7D */,
  {-1, 0, 0x79B9} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page33 = {
  0, marc8_9page33_dir
};
/* PAGE 32 */
struct yaz_iconv_trie_dir marc8_9page32_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x7682} /* 21 */,
  {-1, 0, 0x7684} /* 22 */,
  {-1, 0, 0x7687} /* 23 */,
  {-1, 0, 0x7686} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x768E} /* 26 */,
  {-1, 0, 0x7696} /* 27 */,
  {-1, 0, 0x7693} /* 28 */,
  {-1, 0, 0x769A} /* 29 */,
  {-1, 0, 0x76AE} /* 2A */,
  {-1, 0, 0x76B0} /* 2B */,
  {-1, 0, 0x76B4} /* 2C */,
  {-1, 0, 0x76BA} /* 2D */,
  {-1, 0, 0x76BF} /* 2E */,
  {-1, 0, 0x76C2} /* 2F */,
  {-1, 0, 0},
  {-1, 0, 0x76C8} /* 31 */,
  {-1, 0, 0x76C6} /* 32 */,
  {-1, 0, 0x76CA} /* 33 */,
  {-1, 0, 0x76CD} /* 34 */,
  {-1, 0, 0x76CE} /* 35 */,
  {-1, 0, 0x76D4} /* 36 */,
  {-1, 0, 0x76D2} /* 37 */,
  {-1, 0, 0x76DC} /* 38 */,
  {-1, 0, 0x76DB} /* 39 */,
  {-1, 0, 0x76DE} /* 3A */,
  {-1, 0, 0x76DF} /* 3B */,
  {-1, 0, 0x76E1} /* 3C */,
  {-1, 0, 0x76E3} /* 3D */,
  {-1, 0, 0x76E4} /* 3E */,
  {-1, 0, 0x76E7} /* 3F */,
  {-1, 0, 0x76E5} /* 40 */,
  {-1, 0, 0x76EA} /* 41 */,
  {-1, 0, 0x76EE} /* 42 */,
  {-1, 0, 0x76EF} /* 43 */,
  {-1, 0, 0x76F2} /* 44 */,
  {-1, 0, 0x76F4} /* 45 */,
  {-1, 0, 0x7709} /* 46 */,
  {-1, 0, 0x76F9} /* 47 */,
  {-1, 0, 0x76F8} /* 48 */,
  {-1, 0, 0x7701} /* 49 */,
  {-1, 0, 0x770B} /* 4A */,
  {-1, 0, 0x76FC} /* 4B */,
  {-1, 0, 0x76FE} /* 4C */,
  {-1, 0, 0x7729} /* 4D */,
  {-1, 0, 0x7720} /* 4E */,
  {-1, 0, 0x771E} /* 4F */,
  {-1, 0, 0x7728} /* 50 */,
  {-1, 0, 0x7737} /* 51 */,
  {-1, 0, 0x773C} /* 52 */,
  {-1, 0, 0x7736} /* 53 */,
  {-1, 0, 0x7738} /* 54 */,
  {-1, 0, 0x773A} /* 55 */,
  {-1, 0, 0x773E} /* 56 */,
  {-1, 0, 0x774F} /* 57 */,
  {-1, 0, 0x776B} /* 58 */,
  {-1, 0, 0x775B} /* 59 */,
  {-1, 0, 0x776A} /* 5A */,
  {-1, 0, 0x7766} /* 5B */,
  {-1, 0, 0x7779} /* 5C */,
  {-1, 0, 0x775E} /* 5D */,
  {-1, 0, 0x7763} /* 5E */,
  {-1, 0, 0x775C} /* 5F */,
  {-1, 0, 0x776C} /* 60 */,
  {-1, 0, 0x7768} /* 61 */,
  {-1, 0, 0x7765} /* 62 */,
  {-1, 0, 0x777D} /* 63 */,
  {-1, 0, 0x7771} /* 64 */,
  {-1, 0, 0x777F} /* 65 */,
  {-1, 0, 0x7784} /* 66 */,
  {-1, 0, 0x7761} /* 67 */,
  {-1, 0, 0x7787} /* 68 */,
  {-1, 0, 0x778E} /* 69 */,
  {-1, 0, 0x778C} /* 6A */,
  {-1, 0, 0x7791} /* 6B */,
  {-1, 0, 0x779F} /* 6C */,
  {-1, 0, 0x779E} /* 6D */,
  {-1, 0, 0x77A0} /* 6E */,
  {-1, 0, 0x77A5} /* 6F */,
  {-1, 0, 0x77B3} /* 70 */,
  {-1, 0, 0x77AA} /* 71 */,
  {-1, 0, 0x77B0} /* 72 */,
  {-1, 0, 0x77AD} /* 73 */,
  {-1, 0, 0x77AC} /* 74 */,
  {-1, 0, 0x77A7} /* 75 */,
  {-1, 0, 0x77BD} /* 76 */,
  {-1, 0, 0x77BF} /* 77 */,
  {-1, 0, 0x77BB} /* 78 */,
  {-1, 0, 0},
  {-1, 0, 0x77D3} /* 7A */,
  {-1, 0, 0x77D7} /* 7B */,
  {-1, 0, 0x77DA} /* 7C */,
  {-1, 0, 0x77DB} /* 7D */,
  {-1, 0, 0x77DC} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page32 = {
  0, marc8_9page32_dir
};
/* PAGE 31 */
struct yaz_iconv_trie_dir marc8_9page31_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x752C} /* 21 */,
  {-1, 0, 0x752B} /* 22 */,
  {-1, 0, 0x752D} /* 23 */,
  {-1, 0, 0x7530} /* 24 */,
  {-1, 0, 0x7532} /* 25 */,
  {-1, 0, 0x7531} /* 26 */,
  {-1, 0, 0x7533} /* 27 */,
  {-1, 0, 0x7537} /* 28 */,
  {-1, 0, 0x7538} /* 29 */,
  {-1, 0, 0x753D} /* 2A */,
  {-1, 0, 0x754F} /* 2B */,
  {-1, 0, 0x754C} /* 2C */,
  {-1, 0, 0x755D} /* 2D */,
  {-1, 0, 0x755C} /* 2E */,
  {-1, 0, 0x7554} /* 2F */,
  {-1, 0, 0x755A} /* 30 */,
  {-1, 0, 0x7559} /* 31 */,
  {-1, 0, 0x7566} /* 32 */,
  {-1, 0, 0x7562} /* 33 */,
  {-1, 0, 0x7570} /* 34 */,
  {-1, 0, 0x7565} /* 35 */,
  {-1, 0, 0x756B} /* 36 */,
  {-1, 0, 0x756A} /* 37 */,
  {-1, 0, 0x7578} /* 38 */,
  {-1, 0, 0x7576} /* 39 */,
  {-1, 0, 0x7586} /* 3A */,
  {-1, 0, 0x7587} /* 3B */,
  {-1, 0, 0x758A} /* 3C */,
  {-1, 0, 0},
  {-1, 0, 0x758F} /* 3E */,
  {-1, 0, 0x7591} /* 3F */,
  {-1, 0, 0x759D} /* 40 */,
  {-1, 0, 0x7599} /* 41 */,
  {-1, 0, 0x759A} /* 42 */,
  {-1, 0, 0x75A4} /* 43 */,
  {-1, 0, 0x75AB} /* 44 */,
  {-1, 0, 0x75A5} /* 45 */,
  {-1, 0, 0x75C7} /* 46 */,
  {-1, 0, 0x75C5} /* 47 */,
  {-1, 0, 0x75B3} /* 48 */,
  {-1, 0, 0x75B2} /* 49 */,
  {-1, 0, 0x75BD} /* 4A */,
  {-1, 0, 0x75BE} /* 4B */,
  {-1, 0, 0x75BC} /* 4C */,
  {-1, 0, 0x75B9} /* 4D */,
  {-1, 0, 0x75D5} /* 4E */,
  {-1, 0, 0x75D4} /* 4F */,
  {-1, 0, 0x75B5} /* 50 */,
  {-1, 0, 0xE948} /* 51 */,
  {-1, 0, 0x75DB} /* 52 */,
  {-1, 0, 0x75E3} /* 53 */,
  {-1, 0, 0x75D8} /* 54 */,
  {-1, 0, 0x75DE} /* 55 */,
  {-1, 0, 0x75D9} /* 56 */,
  {-1, 0, 0x75E2} /* 57 */,
  {-1, 0, 0x7601} /* 58 */,
  {-1, 0, 0x7600} /* 59 */,
  {-1, 0, 0x75F0} /* 5A */,
  {-1, 0, 0x75F2} /* 5B */,
  {-1, 0, 0x75F1} /* 5C */,
  {-1, 0, 0x75F4} /* 5D */,
  {-1, 0, 0x75FF} /* 5E */,
  {-1, 0, 0x75FA} /* 5F */,
  {-1, 0, 0x760D} /* 60 */,
  {-1, 0, 0x7627} /* 61 */,
  {-1, 0, 0x7613} /* 62 */,
  {-1, 0, 0x760B} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x7620} /* 65 */,
  {-1, 0, 0x7629} /* 66 */,
  {-1, 0, 0x761F} /* 67 */,
  {-1, 0, 0x7624} /* 68 */,
  {-1, 0, 0x7626} /* 69 */,
  {-1, 0, 0x7621} /* 6A */,
  {-1, 0, 0x7634} /* 6B */,
  {-1, 0, 0x7638} /* 6C */,
  {-1, 0, 0x7646} /* 6D */,
  {-1, 0, 0x7642} /* 6E */,
  {-1, 0, 0x764C} /* 6F */,
  {-1, 0, 0x7656} /* 70 */,
  {-1, 0, 0x7658} /* 71 */,
  {-1, 0, 0},
  {-1, 0, 0x7662} /* 73 */,
  {-1, 0, 0x7665} /* 74 */,
  {-1, 0, 0x7669} /* 75 */,
  {-1, 0, 0x766E} /* 76 */,
  {-1, 0, 0x766C} /* 77 */,
  {-1, 0, 0x7671} /* 78 */,
  {-1, 0, 0xE949} /* 79 */,
  {-1, 0, 0x7678} /* 7A */,
  {-1, 0, 0x767C} /* 7B */,
  {-1, 0, 0x767B} /* 7C */,
  {-1, 0, 0x767D} /* 7D */,
  {-1, 0, 0x767E} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page31 = {
  0, marc8_9page31_dir
};
/* PAGE 30 */
struct yaz_iconv_trie_dir marc8_9page30_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x733F} /* 21 */,
  {-1, 0, 0x733E} /* 22 */,
  {-1, 0, 0x7345} /* 23 */,
  {-1, 0, 0x7350} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x7357} /* 26 */,
  {-1, 0, 0x7368} /* 27 */,
  {-1, 0, 0x7370} /* 28 */,
  {-1, 0, 0x7372} /* 29 */,
  {-1, 0, 0x7377} /* 2A */,
  {-1, 0, 0x7378} /* 2B */,
  {-1, 0, 0x7375} /* 2C */,
  {-1, 0, 0x737A} /* 2D */,
  {-1, 0, 0x737B} /* 2E */,
  {-1, 0, 0x7380} /* 2F */,
  {-1, 0, 0x7384} /* 30 */,
  {-1, 0, 0x7387} /* 31 */,
  {-1, 0, 0x7389} /* 32 */,
  {-1, 0, 0x738B} /* 33 */,
  {-1, 0, 0x7396} /* 34 */,
  {-1, 0, 0x739F} /* 35 */,
  {-1, 0, 0x73A8} /* 36 */,
  {-1, 0, 0x73A9} /* 37 */,
  {-1, 0, 0x73AB} /* 38 */,
  {-1, 0, 0x73BB} /* 39 */,
  {-1, 0, 0x73CA} /* 3A */,
  {-1, 0, 0x73B7} /* 3B */,
  {-1, 0, 0x73C0} /* 3C */,
  {-1, 0, 0},
  {-1, 0, 0x73B2} /* 3E */,
  {-1, 0, 0x73CD} /* 3F */,
  {-1, 0, 0x73ED} /* 40 */,
  {-1, 0, 0x73EE} /* 41 */,
  {-1, 0, 0x73E0} /* 42 */,
  {-1, 0, 0x7405} /* 43 */,
  {-1, 0, 0x7409} /* 44 */,
  {-1, 0, 0x7403} /* 45 */,
  {-1, 0, 0x740A} /* 46 */,
  {-1, 0, 0x73FE} /* 47 */,
  {-1, 0, 0x7406} /* 48 */,
  {-1, 0, 0x740D} /* 49 */,
  {-1, 0, 0x743A} /* 4A */,
  {-1, 0, 0x7435} /* 4B */,
  {-1, 0, 0x7436} /* 4C */,
  {-1, 0, 0x7434} /* 4D */,
  {-1, 0, 0x742A} /* 4E */,
  {-1, 0, 0x7433} /* 4F */,
  {-1, 0, 0x7422} /* 50 */,
  {-1, 0, 0x7425} /* 51 */,
  {-1, 0, 0},
  {-1, 0, 0x7455} /* 53 */,
  {-1, 0, 0x745F} /* 54 */,
  {-1, 0, 0x745A} /* 55 */,
  {-1, 0, 0x7441} /* 56 */,
  {-1, 0, 0x743F} /* 57 */,
  {-1, 0, 0x745B} /* 58 */,
  {-1, 0, 0x745E} /* 59 */,
  {-1, 0, 0x745C} /* 5A */,
  {-1, 0, 0x7459} /* 5B */,
  {-1, 0, 0x7483} /* 5C */,
  {-1, 0, 0x7469} /* 5D */,
  {-1, 0, 0x746A} /* 5E */,
  {-1, 0, 0x7463} /* 5F */,
  {-1, 0, 0x7464} /* 60 */,
  {-1, 0, 0x7470} /* 61 */,
  {-1, 0, 0x748B} /* 62 */,
  {-1, 0, 0xE947} /* 63 */,
  {-1, 0, 0x74A3} /* 64 */,
  {-1, 0, 0x74A7} /* 65 */,
  {-1, 0, 0x74A9} /* 66 */,
  {-1, 0, 0x74B0} /* 67 */,
  {-1, 0, 0x74A6} /* 68 */,
  {-1, 0, 0x74BD} /* 69 */,
  {-1, 0, 0x74CA} /* 6A */,
  {-1, 0, 0x74CF} /* 6B */,
  {-1, 0, 0x74DC} /* 6C */,
  {-1, 0, 0x74E0} /* 6D */,
  {-1, 0, 0x74E2} /* 6E */,
  {-1, 0, 0x74E3} /* 6F */,
  {-1, 0, 0x74E6} /* 70 */,
  {-1, 0, 0x74F6} /* 71 */,
  {-1, 0, 0x74F7} /* 72 */,
  {-1, 0, 0x7504} /* 73 */,
  {-1, 0, 0x750C} /* 74 */,
  {-1, 0, 0x7515} /* 75 */,
  {-1, 0, 0x7518} /* 76 */,
  {-1, 0, 0x751A} /* 77 */,
  {-1, 0, 0x751C} /* 78 */,
  {-1, 0, 0x751F} /* 79 */,
  {-1, 0, 0x7522} /* 7A */,
  {-1, 0, 0x7526} /* 7B */,
  {-1, 0, 0x7525} /* 7C */,
  {-1, 0, 0x7528} /* 7D */,
  {-1, 0, 0x7529} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page30 = {
  0, marc8_9page30_dir
};
/* PAGE 29 */
struct yaz_iconv_trie_dir marc8_9page29_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x71BE} /* 21 */,
  {-1, 0, 0x71C9} /* 22 */,
  {-1, 0, 0x71D0} /* 23 */,
  {-1, 0, 0x71C8} /* 24 */,
  {-1, 0, 0x71DC} /* 25 */,
  {-1, 0, 0x71D2} /* 26 */,
  {-1, 0, 0x71B9} /* 27 */,
  {-1, 0, 0x71D5} /* 28 */,
  {-1, 0, 0x71CE} /* 29 */,
  {-1, 0, 0x71C3} /* 2A */,
  {-1, 0, 0x71C4} /* 2B */,
  {-1, 0, 0x71EE} /* 2C */,
  {-1, 0, 0x71E7} /* 2D */,
  {-1, 0, 0x71DF} /* 2E */,
  {-1, 0, 0x71E5} /* 2F */,
  {-1, 0, 0x71ED} /* 30 */,
  {-1, 0, 0x71E6} /* 31 */,
  {-1, 0, 0x71EC} /* 32 */,
  {-1, 0, 0x71F4} /* 33 */,
  {-1, 0, 0x71FB} /* 34 */,
  {-1, 0, 0x7206} /* 35 */,
  {-1, 0, 0x720D} /* 36 */,
  {-1, 0, 0x7210} /* 37 */,
  {-1, 0, 0x721B} /* 38 */,
  {-1, 0, 0x7228} /* 39 */,
  {-1, 0, 0x722A} /* 3A */,
  {-1, 0, 0x722D} /* 3B */,
  {-1, 0, 0x722C} /* 3C */,
  {-1, 0, 0x7230} /* 3D */,
  {-1, 0, 0xE946} /* 3E */,
  {-1, 0, 0x7236} /* 3F */,
  {-1, 0, 0x7238} /* 40 */,
  {-1, 0, 0x7239} /* 41 */,
  {-1, 0, 0x723A} /* 42 */,
  {-1, 0, 0x723B} /* 43 */,
  {-1, 0, 0x723D} /* 44 */,
  {-1, 0, 0x723E} /* 45 */,
  {-1, 0, 0x7246} /* 46 */,
  {-1, 0, 0x7247} /* 47 */,
  {-1, 0, 0x7248} /* 48 */,
  {-1, 0, 0x724C} /* 49 */,
  {-1, 0, 0x7252} /* 4A */,
  {-1, 0, 0x7256} /* 4B */,
  {-1, 0, 0x7258} /* 4C */,
  {-1, 0, 0x7259} /* 4D */,
  {-1, 0, 0x725B} /* 4E */,
  {-1, 0, 0x725F} /* 4F */,
  {-1, 0, 0x725D} /* 50 */,
  {-1, 0, 0x7262} /* 51 */,
  {-1, 0, 0x7261} /* 52 */,
  {-1, 0, 0x7260} /* 53 */,
  {-1, 0, 0x7267} /* 54 */,
  {-1, 0, 0x7269} /* 55 */,
  {-1, 0, 0x726F} /* 56 */,
  {-1, 0, 0x7272} /* 57 */,
  {-1, 0, 0x7274} /* 58 */,
  {-1, 0, 0x7279} /* 59 */,
  {-1, 0, 0x727D} /* 5A */,
  {-1, 0, 0x7281} /* 5B */,
  {-1, 0, 0x7280} /* 5C */,
  {-1, 0, 0x7284} /* 5D */,
  {-1, 0, 0x7296} /* 5E */,
  {-1, 0, 0x7292} /* 5F */,
  {-1, 0, 0x729B} /* 60 */,
  {-1, 0, 0x72A2} /* 61 */,
  {-1, 0, 0x72A7} /* 62 */,
  {-1, 0, 0x72AC} /* 63 */,
  {-1, 0, 0x72AF} /* 64 */,
  {-1, 0, 0x72C4} /* 65 */,
  {-1, 0, 0x72C2} /* 66 */,
  {-1, 0, 0x72D9} /* 67 */,
  {-1, 0, 0x72C0} /* 68 */,
  {-1, 0, 0x72CE} /* 69 */,
  {-1, 0, 0x72D7} /* 6A */,
  {-1, 0, 0x72D0} /* 6B */,
  {-1, 0, 0x72E1} /* 6C */,
  {-1, 0, 0x72E9} /* 6D */,
  {-1, 0, 0x72E0} /* 6E */,
  {-1, 0, 0x72FC} /* 6F */,
  {-1, 0, 0x72F9} /* 70 */,
  {-1, 0, 0},
  {-1, 0, 0x72FD} /* 72 */,
  {-1, 0, 0x72F7} /* 73 */,
  {-1, 0, 0x731C} /* 74 */,
  {-1, 0, 0x731B} /* 75 */,
  {-1, 0, 0x7313} /* 76 */,
  {-1, 0, 0x7316} /* 77 */,
  {-1, 0, 0x7319} /* 78 */,
  {-1, 0, 0x7336} /* 79 */,
  {-1, 0, 0x7337} /* 7A */,
  {-1, 0, 0x7329} /* 7B */,
  {-1, 0, 0x7325} /* 7C */,
  {-1, 0, 0x7334} /* 7D */,
  {-1, 0, 0x7344} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page29 = {
  0, marc8_9page29_dir
};
/* PAGE 28 */
struct yaz_iconv_trie_dir marc8_9page28_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6FA4} /* 21 */,
  {-1, 0, 0x6FC1} /* 22 */,
  {-1, 0, 0},
  {-1, 0, 0x6FC0} /* 24 */,
  {-1, 0, 0x6FB3} /* 25 */,
  {-1, 0, 0x6FDF} /* 26 */,
  {-1, 0, 0x6FD8} /* 27 */,
  {-1, 0, 0x6FF1} /* 28 */,
  {-1, 0, 0x6FE0} /* 29 */,
  {-1, 0, 0x6FEF} /* 2A */,
  {-1, 0, 0xE945} /* 2B */,
  {-1, 0, 0x6FE1} /* 2C */,
  {-1, 0, 0x6FE4} /* 2D */,
  {-1, 0, 0x6F80} /* 2E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x700B} /* 31 */,
  {-1, 0, 0x7009} /* 32 */,
  {-1, 0, 0x7006} /* 33 */,
  {-1, 0, 0x6FFA} /* 34 */,
  {-1, 0, 0x7011} /* 35 */,
  {-1, 0, 0x6FFE} /* 36 */,
  {-1, 0, 0x700F} /* 37 */,
  {-1, 0, 0x701B} /* 38 */,
  {-1, 0, 0x701A} /* 39 */,
  {-1, 0, 0x7028} /* 3A */,
  {-1, 0, 0x701D} /* 3B */,
  {-1, 0, 0x7015} /* 3C */,
  {-1, 0, 0x701F} /* 3D */,
  {-1, 0, 0},
  {-1, 0, 0x703E} /* 3F */,
  {-1, 0, 0x704C} /* 40 */,
  {-1, 0, 0x7051} /* 41 */,
  {-1, 0, 0x7058} /* 42 */,
  {-1, 0, 0x7063} /* 43 */,
  {-1, 0, 0x7064} /* 44 */,
  {-1, 0, 0x706B} /* 45 */,
  {-1, 0, 0x7070} /* 46 */,
  {-1, 0, 0x7076} /* 47 */,
  {-1, 0, 0x707C} /* 48 */,
  {-1, 0, 0x7078} /* 49 */,
  {-1, 0, 0x707D} /* 4A */,
  {-1, 0, 0x7095} /* 4B */,
  {-1, 0, 0x708E} /* 4C */,
  {-1, 0, 0x7092} /* 4D */,
  {-1, 0, 0x7099} /* 4E */,
  {-1, 0, 0x708A} /* 4F */,
  {-1, 0, 0x70AB} /* 50 */,
  {-1, 0, 0x70BA} /* 51 */,
  {-1, 0, 0x70AC} /* 52 */,
  {-1, 0, 0x70B3} /* 53 */,
  {-1, 0, 0x70AF} /* 54 */,
  {-1, 0, 0x70AD} /* 55 */,
  {-1, 0, 0x70AE} /* 56 */,
  {-1, 0, 0x70B8} /* 57 */,
  {-1, 0, 0x70CA} /* 58 */,
  {-1, 0, 0x70E4} /* 59 */,
  {-1, 0, 0x70D8} /* 5A */,
  {-1, 0, 0x70C8} /* 5B */,
  {-1, 0, 0x70D9} /* 5C */,
  {-1, 0, 0x70CF} /* 5D */,
  {-1, 0, 0x70F9} /* 5E */,
  {-1, 0, 0x7109} /* 5F */,
  {-1, 0, 0x710A} /* 60 */,
  {-1, 0, 0x70FD} /* 61 */,
  {-1, 0, 0x7119} /* 62 */,
  {-1, 0, 0x716E} /* 63 */,
  {-1, 0, 0x711A} /* 64 */,
  {-1, 0, 0x7136} /* 65 */,
  {-1, 0, 0x7121} /* 66 */,
  {-1, 0, 0x7130} /* 67 */,
  {-1, 0, 0x7126} /* 68 */,
  {-1, 0, 0x714E} /* 69 */,
  {-1, 0, 0x7149} /* 6A */,
  {-1, 0, 0x7159} /* 6B */,
  {-1, 0, 0x7164} /* 6C */,
  {-1, 0, 0x7169} /* 6D */,
  {-1, 0, 0x715C} /* 6E */,
  {-1, 0, 0x716C} /* 6F */,
  {-1, 0, 0x7166} /* 70 */,
  {-1, 0, 0x7167} /* 71 */,
  {-1, 0, 0x715E} /* 72 */,
  {-1, 0, 0x7165} /* 73 */,
  {-1, 0, 0x714C} /* 74 */,
  {-1, 0, 0x717D} /* 75 */,
  {-1, 0, 0},
  {-1, 0, 0x7199} /* 77 */,
  {-1, 0, 0x718A} /* 78 */,
  {-1, 0, 0x7184} /* 79 */,
  {-1, 0, 0x719F} /* 7A */,
  {-1, 0, 0x71A8} /* 7B */,
  {-1, 0, 0x71AC} /* 7C */,
  {-1, 0, 0x71B1} /* 7D */,
  {-1, 0, 0x71D9} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page28 = {
  0, marc8_9page28_dir
};
/* PAGE 27 */
struct yaz_iconv_trie_dir marc8_9page27_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6E5B} /* 21 */,
  {-1, 0, 0x6E1A} /* 22 */,
  {-1, 0, 0x6E56} /* 23 */,
  {-1, 0, 0x6E2F} /* 24 */,
  {-1, 0, 0x6E6E} /* 25 */,
  {-1, 0, 0x6E58} /* 26 */,
  {-1, 0, 0x6E23} /* 27 */,
  {-1, 0, 0x6E24} /* 28 */,
  {-1, 0, 0x6E1B} /* 29 */,
  {-1, 0, 0x6E25} /* 2A */,
  {-1, 0, 0x6E4A} /* 2B */,
  {-1, 0, 0x6E3A} /* 2C */,
  {-1, 0, 0x6E6F} /* 2D */,
  {-1, 0, 0x6E2D} /* 2E */,
  {-1, 0, 0x6E34} /* 2F */,
  {-1, 0, 0x6E2C} /* 30 */,
  {-1, 0, 0x6E26} /* 31 */,
  {-1, 0, 0x6E4D} /* 32 */,
  {-1, 0, 0x6E3E} /* 33 */,
  {-1, 0, 0x6E43} /* 34 */,
  {-1, 0, 0x6E19} /* 35 */,
  {-1, 0, 0x6E1D} /* 36 */,
  {-1, 0, 0x6ED3} /* 37 */,
  {-1, 0, 0x6EB6} /* 38 */,
  {-1, 0, 0x6EC2} /* 39 */,
  {-1, 0, 0},
  {-1, 0, 0x6EAF} /* 3B */,
  {-1, 0, 0x6EA2} /* 3C */,
  {-1, 0, 0x6E9D} /* 3D */,
  {-1, 0, 0},
  {-1, 0, 0x6EA5} /* 3F */,
  {-1, 0, 0x6E98} /* 40 */,
  {-1, 0, 0x6E90} /* 41 */,
  {-1, 0, 0x6EC5} /* 42 */,
  {-1, 0, 0x6EC7} /* 43 */,
  {-1, 0, 0x6EBC} /* 44 */,
  {-1, 0, 0x6EAB} /* 45 */,
  {-1, 0, 0x6ED1} /* 46 */,
  {-1, 0, 0x6ECB} /* 47 */,
  {-1, 0, 0x6EC4} /* 48 */,
  {-1, 0, 0x6ED4} /* 49 */,
  {-1, 0, 0x6EAA} /* 4A */,
  {-1, 0, 0x6E96} /* 4B */,
  {-1, 0, 0x6E9C} /* 4C */,
  {-1, 0, 0x6F33} /* 4D */,
  {-1, 0, 0x6EF4} /* 4E */,
  {-1, 0, 0x6EEC} /* 4F */,
  {-1, 0, 0x6EFE} /* 50 */,
  {-1, 0, 0x6F29} /* 51 */,
  {-1, 0, 0x6F14} /* 52 */,
  {-1, 0, 0x6F3E} /* 53 */,
  {-1, 0, 0x6F2C} /* 54 */,
  {-1, 0, 0x6F32} /* 55 */,
  {-1, 0, 0x6F0F} /* 56 */,
  {-1, 0, 0xE944} /* 57 */,
  {-1, 0, 0x6EFF} /* 58 */,
  {-1, 0, 0x6F23} /* 59 */,
  {-1, 0, 0x6F38} /* 5A */,
  {-1, 0, 0x6F15} /* 5B */,
  {-1, 0, 0x6F31} /* 5C */,
  {-1, 0, 0x6F02} /* 5D */,
  {-1, 0, 0x6F06} /* 5E */,
  {-1, 0, 0x6EEF} /* 5F */,
  {-1, 0, 0x6F2B} /* 60 */,
  {-1, 0, 0x6F2F} /* 61 */,
  {-1, 0, 0x6F20} /* 62 */,
  {-1, 0, 0x6F3F} /* 63 */,
  {-1, 0, 0x6EF2} /* 64 */,
  {-1, 0, 0x6F01} /* 65 */,
  {-1, 0, 0x6F11} /* 66 */,
  {-1, 0, 0x6ECC} /* 67 */,
  {-1, 0, 0x6F2A} /* 68 */,
  {-1, 0, 0x6F7C} /* 69 */,
  {-1, 0, 0x6F88} /* 6A */,
  {-1, 0, 0x6F84} /* 6B */,
  {-1, 0, 0x6F51} /* 6C */,
  {-1, 0, 0x6F64} /* 6D */,
  {-1, 0, 0x6F97} /* 6E */,
  {-1, 0, 0x6F54} /* 6F */,
  {-1, 0, 0x6F7A} /* 70 */,
  {-1, 0, 0x6F86} /* 71 */,
  {-1, 0, 0x6F8E} /* 72 */,
  {-1, 0, 0x6F6D} /* 73 */,
  {-1, 0, 0x6F5B} /* 74 */,
  {-1, 0, 0x6F6E} /* 75 */,
  {-1, 0, 0x6F78} /* 76 */,
  {-1, 0, 0x6F66} /* 77 */,
  {-1, 0, 0x6F70} /* 78 */,
  {-1, 0, 0x6F58} /* 79 */,
  {-1, 0, 0x6FC2} /* 7A */,
  {-1, 0, 0x6FB1} /* 7B */,
  {-1, 0, 0x6FC3} /* 7C */,
  {-1, 0, 0x6FA7} /* 7D */,
  {-1, 0, 0x6FA1} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page27 = {
  0, marc8_9page27_dir
};
/* PAGE 26 */
struct yaz_iconv_trie_dir marc8_9page26_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6CE3} /* 21 */,
  {-1, 0, 0x6CF0} /* 22 */,
  {-1, 0, 0x6CB8} /* 23 */,
  {-1, 0, 0x6CD3} /* 24 */,
  {-1, 0, 0x6CAB} /* 25 */,
  {-1, 0, 0x6CE5} /* 26 */,
  {-1, 0, 0x6CBD} /* 27 */,
  {-1, 0, 0x6CB3} /* 28 */,
  {-1, 0, 0x6CC4} /* 29 */,
  {-1, 0, 0x6CD5} /* 2A */,
  {-1, 0, 0x6CE2} /* 2B */,
  {-1, 0, 0x6CBC} /* 2C */,
  {-1, 0, 0x6CAE} /* 2D */,
  {-1, 0, 0x6CB9} /* 2E */,
  {-1, 0, 0x6CF1} /* 2F */,
  {-1, 0, 0x6CC1} /* 30 */,
  {-1, 0, 0x6CBE} /* 31 */,
  {-1, 0, 0x6CC5} /* 32 */,
  {-1, 0, 0x6CD7} /* 33 */,
  {-1, 0, 0x6CBB} /* 34 */,
  {-1, 0, 0x6CDB} /* 35 */,
  {-1, 0, 0x6CE1} /* 36 */,
  {-1, 0, 0x6CBF} /* 37 */,
  {-1, 0, 0x6CCA} /* 38 */,
  {-1, 0, 0x6CCC} /* 39 */,
  {-1, 0, 0x6CC9} /* 3A */,
  {-1, 0, 0x6D41} /* 3B */,
  {-1, 0, 0x6D0B} /* 3C */,
  {-1, 0, 0x6D32} /* 3D */,
  {-1, 0, 0x6D25} /* 3E */,
  {-1, 0, 0x6D31} /* 3F */,
  {-1, 0, 0x6D2A} /* 40 */,
  {-1, 0, 0x6D0C} /* 41 */,
  {-1, 0, 0x6D1E} /* 42 */,
  {-1, 0, 0x6D17} /* 43 */,
  {-1, 0, 0x6D3B} /* 44 */,
  {-1, 0, 0x6D1B} /* 45 */,
  {-1, 0, 0x6D36} /* 46 */,
  {-1, 0, 0x6D3D} /* 47 */,
  {-1, 0, 0x6D3E} /* 48 */,
  {-1, 0, 0x6D6A} /* 49 */,
  {-1, 0, 0x6D95} /* 4A */,
  {-1, 0, 0x6D78} /* 4B */,
  {-1, 0, 0x6D66} /* 4C */,
  {-1, 0, 0x6D59} /* 4D */,
  {-1, 0, 0x6D87} /* 4E */,
  {-1, 0, 0x6D88} /* 4F */,
  {-1, 0, 0x6D6C} /* 50 */,
  {-1, 0, 0x6D93} /* 51 */,
  {-1, 0, 0x6D89} /* 52 */,
  {-1, 0, 0x6D6E} /* 53 */,
  {-1, 0, 0x6D74} /* 54 */,
  {-1, 0, 0x6D5A} /* 55 */,
  {-1, 0, 0x6D69} /* 56 */,
  {-1, 0, 0x6D77} /* 57 */,
  {-1, 0, 0x6DD9} /* 58 */,
  {-1, 0, 0x6DDA} /* 59 */,
  {-1, 0, 0x6DF3} /* 5A */,
  {-1, 0, 0x6DBC} /* 5B */,
  {-1, 0, 0x6DE4} /* 5C */,
  {-1, 0, 0x6DB2} /* 5D */,
  {-1, 0, 0x6DE1} /* 5E */,
  {-1, 0, 0x6DD2} /* 5F */,
  {-1, 0, 0x6DAE} /* 60 */,
  {-1, 0, 0x6DF8} /* 61 */,
  {-1, 0, 0x6DC7} /* 62 */,
  {-1, 0, 0x6DCB} /* 63 */,
  {-1, 0, 0x6DC5} /* 64 */,
  {-1, 0, 0x6DDE} /* 65 */,
  {-1, 0, 0x6DAF} /* 66 */,
  {-1, 0, 0x6DB5} /* 67 */,
  {-1, 0, 0x6DFA} /* 68 */,
  {-1, 0, 0x6DF9} /* 69 */,
  {-1, 0, 0x6DCC} /* 6A */,
  {-1, 0, 0x6DF7} /* 6B */,
  {-1, 0, 0x6DB8} /* 6C */,
  {-1, 0, 0x6DD1} /* 6D */,
  {-1, 0, 0x6DF1} /* 6E */,
  {-1, 0, 0x6DE8} /* 6F */,
  {-1, 0, 0x6DEB} /* 70 */,
  {-1, 0, 0x6DD8} /* 71 */,
  {-1, 0, 0x6DFB} /* 72 */,
  {-1, 0, 0x6DEE} /* 73 */,
  {-1, 0, 0x6DF5} /* 74 */,
  {-1, 0, 0x6D8E} /* 75 */,
  {-1, 0, 0x6DC6} /* 76 */,
  {-1, 0, 0x6DEA} /* 77 */,
  {-1, 0, 0x6DC4} /* 78 */,
  {-1, 0, 0x6E54} /* 79 */,
  {-1, 0, 0x6E21} /* 7A */,
  {-1, 0, 0x6E38} /* 7B */,
  {-1, 0, 0x6E32} /* 7C */,
  {-1, 0, 0x6E67} /* 7D */,
  {-1, 0, 0x6E20} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page26 = {
  0, marc8_9page26_dir
};
/* PAGE 25 */
struct yaz_iconv_trie_dir marc8_9page25_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6B61} /* 21 */,
  {-1, 0, 0},
  {-1, 0, 0x6B63} /* 23 */,
  {-1, 0, 0x6B64} /* 24 */,
  {-1, 0, 0x6B65} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0x6B66} /* 27 */,
  {-1, 0, 0x6B6A} /* 28 */,
  {-1, 0, 0x6B72} /* 29 */,
  {-1, 0, 0x6B77} /* 2A */,
  {-1, 0, 0x6B78} /* 2B */,
  {-1, 0, 0x6B79} /* 2C */,
  {-1, 0, 0x6B7B} /* 2D */,
  {-1, 0, 0x6B7F} /* 2E */,
  {-1, 0, 0x6B83} /* 2F */,
  {-1, 0, 0x6B86} /* 30 */,
  {-1, 0, 0x6B8A} /* 31 */,
  {-1, 0, 0x6B89} /* 32 */,
  {-1, 0, 0x6B98} /* 33 */,
  {-1, 0, 0x6B96} /* 34 */,
  {-1, 0, 0x6BA4} /* 35 */,
  {-1, 0, 0x6BAE} /* 36 */,
  {-1, 0, 0x6BAF} /* 37 */,
  {-1, 0, 0x6BB2} /* 38 */,
  {-1, 0, 0x6BB5} /* 39 */,
  {-1, 0, 0x6BB7} /* 3A */,
  {-1, 0, 0x6BBA} /* 3B */,
  {-1, 0, 0x6BBC} /* 3C */,
  {-1, 0, 0x6BC0} /* 3D */,
  {-1, 0, 0x6BBF} /* 3E */,
  {-1, 0, 0x6BC5} /* 3F */,
  {-1, 0, 0x6BC6} /* 40 */,
  {-1, 0, 0x6BCB} /* 41 */,
  {-1, 0, 0x6BCD} /* 42 */,
  {-1, 0, 0x6BCF} /* 43 */,
  {-1, 0, 0x6BD2} /* 44 */,
  {-1, 0, 0},
  {-1, 0, 0x6BD4} /* 46 */,
  {-1, 0, 0x6BD7} /* 47 */,
  {-1, 0, 0x6BDB} /* 48 */,
  {-1, 0, 0x6BEB} /* 49 */,
  {-1, 0, 0x6BEF} /* 4A */,
  {-1, 0, 0x6BFD} /* 4B */,
  {-1, 0, 0x6C0F} /* 4C */,
  {-1, 0, 0x6C11} /* 4D */,
  {-1, 0, 0x6C10} /* 4E */,
  {-1, 0, 0x6C13} /* 4F */,
  {-1, 0, 0x6C16} /* 50 */,
  {-1, 0, 0x6C1B} /* 51 */,
  {-1, 0, 0x6C1F} /* 52 */,
  {-1, 0, 0x6C27} /* 53 */,
  {-1, 0, 0x6C26} /* 54 */,
  {-1, 0, 0x6C23} /* 55 */,
  {-1, 0, 0x6C28} /* 56 */,
  {-1, 0, 0x6C24} /* 57 */,
  {-1, 0, 0x6C2B} /* 58 */,
  {-1, 0, 0x6C2E} /* 59 */,
  {-1, 0, 0x6C33} /* 5A */,
  {-1, 0, 0xE942} /* 5B */,
  {-1, 0, 0x6C34} /* 5C */,
  {-1, 0, 0x6C38} /* 5D */,
  {-1, 0, 0x6C41} /* 5E */,
  {-1, 0, 0},
  {-1, 0, 0x6C40} /* 60 */,
  {-1, 0, 0x6C42} /* 61 */,
  {-1, 0, 0x6C5E} /* 62 */,
  {-1, 0, 0x6C57} /* 63 */,
  {-1, 0, 0x6C5F} /* 64 */,
  {-1, 0, 0x6C59} /* 65 */,
  {-1, 0, 0x6C60} /* 66 */,
  {-1, 0, 0x6C55} /* 67 */,
  {-1, 0, 0x6C50} /* 68 */,
  {-1, 0, 0x6C5D} /* 69 */,
  {-1, 0, 0x6C9B} /* 6A */,
  {-1, 0, 0x6C81} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0x6C7A} /* 6D */,
  {-1, 0, 0x6C6A} /* 6E */,
  {-1, 0, 0x6C8C} /* 6F */,
  {-1, 0, 0x6C90} /* 70 */,
  {-1, 0, 0x6C72} /* 71 */,
  {-1, 0, 0x6C70} /* 72 */,
  {-1, 0, 0x6C68} /* 73 */,
  {-1, 0, 0x6C96} /* 74 */,
  {-1, 0, 0},
  {-1, 0, 0xE943} /* 76 */,
  {-1, 0, 0x6C99} /* 77 */,
  {-1, 0, 0x6C7E} /* 78 */,
  {-1, 0, 0x6C7D} /* 79 */,
  {-1, 0, 0x6C92} /* 7A */,
  {-1, 0, 0x6C83} /* 7B */,
  {-1, 0, 0x6CB1} /* 7C */,
  {-1, 0, 0},
  {-1, 0, 0x6CF3} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page25 = {
  0, marc8_9page25_dir
};
/* PAGE 24 */
struct yaz_iconv_trie_dir marc8_9page24_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x690E} /* 21 */,
  {-1, 0, 0x68C9} /* 22 */,
  {-1, 0, 0x6954} /* 23 */,
  {-1, 0, 0x6930} /* 24 */,
  {-1, 0, 0x6977} /* 25 */,
  {-1, 0, 0x6975} /* 26 */,
  {-1, 0, 0x695A} /* 27 */,
  {-1, 0, 0x6960} /* 28 */,
  {-1, 0, 0x696B} /* 29 */,
  {-1, 0, 0x694A} /* 2A */,
  {-1, 0, 0x6968} /* 2B */,
  {-1, 0, 0x695E} /* 2C */,
  {-1, 0, 0x696D} /* 2D */,
  {-1, 0, 0x6979} /* 2E */,
  {-1, 0, 0x6953} /* 2F */,
  {-1, 0, 0x6986} /* 30 */,
  {-1, 0, 0x69A8} /* 31 */,
  {-1, 0, 0x6995} /* 32 */,
  {-1, 0, 0x699C} /* 33 */,
  {-1, 0, 0x6994} /* 34 */,
  {-1, 0, 0x69C1} /* 35 */,
  {-1, 0, 0x69B7} /* 36 */,
  {-1, 0, 0x69AE} /* 37 */,
  {-1, 0, 0x699B} /* 38 */,
  {-1, 0, 0x69CB} /* 39 */,
  {-1, 0, 0x69D3} /* 3A */,
  {-1, 0, 0x69BB} /* 3B */,
  {-1, 0, 0x69AB} /* 3C */,
  {-1, 0, 0x69CC} /* 3D */,
  {-1, 0, 0x69AD} /* 3E */,
  {-1, 0, 0x69D0} /* 3F */,
  {-1, 0, 0x69CD} /* 40 */,
  {-1, 0, 0x69B4} /* 41 */,
  {-1, 0, 0x6A1F} /* 42 */,
  {-1, 0, 0x69E8} /* 43 */,
  {-1, 0, 0x6A23} /* 44 */,
  {-1, 0, 0x69EA} /* 45 */,
  {-1, 0, 0x6A01} /* 46 */,
  {-1, 0, 0x6A19} /* 47 */,
  {-1, 0, 0x69FD} /* 48 */,
  {-1, 0, 0x6A1E} /* 49 */,
  {-1, 0, 0x6A13} /* 4A */,
  {-1, 0, 0x6A21} /* 4B */,
  {-1, 0, 0x69F3} /* 4C */,
  {-1, 0, 0x6A0A} /* 4D */,
  {-1, 0, 0x6A02} /* 4E */,
  {-1, 0, 0x6A05} /* 4F */,
  {-1, 0, 0x6A3D} /* 50 */,
  {-1, 0, 0x6A58} /* 51 */,
  {-1, 0, 0x6A59} /* 52 */,
  {-1, 0, 0x6A62} /* 53 */,
  {-1, 0, 0x6A44} /* 54 */,
  {-1, 0, 0x6A39} /* 55 */,
  {-1, 0, 0x6A6B} /* 56 */,
  {-1, 0, 0x6A3A} /* 57 */,
  {-1, 0, 0x6A38} /* 58 */,
  {-1, 0, 0x6A47} /* 59 */,
  {-1, 0, 0x6A61} /* 5A */,
  {-1, 0, 0x6A4B} /* 5B */,
  {-1, 0, 0x6A35} /* 5C */,
  {-1, 0, 0x6A5F} /* 5D */,
  {-1, 0, 0x6A80} /* 5E */,
  {-1, 0, 0x6A94} /* 5F */,
  {-1, 0, 0x6A84} /* 60 */,
  {-1, 0, 0x6AA2} /* 61 */,
  {-1, 0, 0x6A9C} /* 62 */,
  {-1, 0, 0x6AB8} /* 63 */,
  {-1, 0, 0x6AB3} /* 64 */,
  {-1, 0, 0x6AC3} /* 65 */,
  {-1, 0, 0x6ABB} /* 66 */,
  {-1, 0, 0},
  {-1, 0, 0x6AAC} /* 68 */,
  {-1, 0, 0x6AE5} /* 69 */,
  {-1, 0, 0x6ADA} /* 6A */,
  {-1, 0, 0x6ADD} /* 6B */,
  {-1, 0, 0x6ADB} /* 6C */,
  {-1, 0, 0x6AD3} /* 6D */,
  {-1, 0, 0x6B04} /* 6E */,
  {-1, 0, 0x6AFB} /* 6F */,
  {-1, 0, 0x6B0A} /* 70 */,
  {-1, 0, 0x6B16} /* 71 */,
  {-1, 0, 0},
  {-1, 0, 0x6B21} /* 73 */,
  {-1, 0, 0x6B23} /* 74 */,
  {-1, 0, 0},
  {-1, 0, 0x6B3E} /* 76 */,
  {-1, 0, 0x6B3A} /* 77 */,
  {-1, 0, 0x6B3D} /* 78 */,
  {-1, 0, 0x6B47} /* 79 */,
  {-1, 0, 0x6B49} /* 7A */,
  {-1, 0, 0x6B4C} /* 7B */,
  {-1, 0, 0x6B50} /* 7C */,
  {-1, 0, 0x6B59} /* 7D */,
  {-1, 0, 0x6B5F} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page24 = {
  0, marc8_9page24_dir
};
/* PAGE 23 */
struct yaz_iconv_trie_dir marc8_9page23_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6787} /* 21 */,
  {-1, 0, 0x6777} /* 22 */,
  {-1, 0, 0x679D} /* 23 */,
  {-1, 0, 0x6797} /* 24 */,
  {-1, 0, 0x676F} /* 25 */,
  {-1, 0, 0x6771} /* 26 */,
  {-1, 0, 0x6773} /* 27 */,
  {-1, 0, 0x679C} /* 28 */,
  {-1, 0, 0x6775} /* 29 */,
  {-1, 0, 0x679A} /* 2A */,
  {-1, 0, 0x6790} /* 2B */,
  {-1, 0, 0},
  {-1, 0, 0x677E} /* 2D */,
  {-1, 0, 0x67D3} /* 2E */,
  {-1, 0, 0x67F1} /* 2F */,
  {-1, 0, 0x67FF} /* 30 */,
  {-1, 0, 0x67D4} /* 31 */,
  {-1, 0, 0x67C4} /* 32 */,
  {-1, 0, 0x67AF} /* 33 */,
  {-1, 0, 0x67D0} /* 34 */,
  {-1, 0, 0x67D1} /* 35 */,
  {-1, 0, 0x67EF} /* 36 */,
  {-1, 0, 0x67E9} /* 37 */,
  {-1, 0, 0x67B6} /* 38 */,
  {-1, 0, 0x67EC} /* 39 */,
  {-1, 0, 0x67E5} /* 3A */,
  {-1, 0, 0x67FA} /* 3B */,
  {-1, 0, 0x67DA} /* 3C */,
  {-1, 0, 0x6805} /* 3D */,
  {-1, 0, 0x67DE} /* 3E */,
  {-1, 0, 0x67B8} /* 3F */,
  {-1, 0, 0x67CF} /* 40 */,
  {-1, 0, 0x67F3} /* 41 */,
  {-1, 0, 0x6848} /* 42 */,
  {-1, 0, 0x6821} /* 43 */,
  {-1, 0, 0x6838} /* 44 */,
  {-1, 0, 0x6853} /* 45 */,
  {-1, 0, 0x6846} /* 46 */,
  {-1, 0, 0x6842} /* 47 */,
  {-1, 0, 0x6854} /* 48 */,
  {-1, 0, 0x6817} /* 49 */,
  {-1, 0, 0x683D} /* 4A */,
  {-1, 0, 0x6851} /* 4B */,
  {-1, 0, 0x6829} /* 4C */,
  {-1, 0, 0x6850} /* 4D */,
  {-1, 0, 0x6839} /* 4E */,
  {-1, 0, 0},
  {-1, 0, 0x67F4} /* 50 */,
  {-1, 0, 0x6843} /* 51 */,
  {-1, 0, 0x6840} /* 52 */,
  {-1, 0, 0x682A} /* 53 */,
  {-1, 0, 0x6845} /* 54 */,
  {-1, 0, 0x683C} /* 55 */,
  {-1, 0, 0xE941} /* 56 */,
  {-1, 0, 0x6881} /* 57 */,
  {-1, 0, 0x6893} /* 58 */,
  {-1, 0, 0x68AF} /* 59 */,
  {-1, 0, 0x6876} /* 5A */,
  {-1, 0, 0x68B0} /* 5B */,
  {-1, 0, 0x68A7} /* 5C */,
  {-1, 0, 0x6897} /* 5D */,
  {-1, 0, 0x68B5} /* 5E */,
  {-1, 0, 0x68B3} /* 5F */,
  {-1, 0, 0x68A2} /* 60 */,
  {-1, 0, 0x687F} /* 61 */,
  {-1, 0, 0x68B1} /* 62 */,
  {-1, 0, 0x689D} /* 63 */,
  {-1, 0, 0x68AD} /* 64 */,
  {-1, 0, 0x6886} /* 65 */,
  {-1, 0, 0x6885} /* 66 */,
  {-1, 0, 0x68A8} /* 67 */,
  {-1, 0, 0x689F} /* 68 */,
  {-1, 0, 0x6894} /* 69 */,
  {-1, 0, 0x6883} /* 6A */,
  {-1, 0, 0x68D5} /* 6B */,
  {-1, 0, 0x68FA} /* 6C */,
  {-1, 0, 0x68C4} /* 6D */,
  {-1, 0, 0x68F2} /* 6E */,
  {-1, 0, 0x68D2} /* 6F */,
  {-1, 0, 0x68E3} /* 70 */,
  {-1, 0, 0x68DF} /* 71 */,
  {-1, 0, 0x68CB} /* 72 */,
  {-1, 0, 0x68EE} /* 73 */,
  {-1, 0, 0x690D} /* 74 */,
  {-1, 0, 0x6905} /* 75 */,
  {-1, 0, 0x68E7} /* 76 */,
  {-1, 0, 0x68E0} /* 77 */,
  {-1, 0, 0x68F5} /* 78 */,
  {-1, 0, 0x68CD} /* 79 */,
  {-1, 0, 0x68D7} /* 7A */,
  {-1, 0, 0x68D8} /* 7B */,
  {-1, 0, 0x6912} /* 7C */,
  {-1, 0, 0x68F9} /* 7D */,
  {-1, 0, 0x68DA} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page23 = {
  0, marc8_9page23_dir
};
/* PAGE 22 */
struct yaz_iconv_trie_dir marc8_9page22_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x660E} /* 21 */,
  {-1, 0, 0x6613} /* 22 */,
  {-1, 0, 0x6602} /* 23 */,
  {-1, 0, 0x660F} /* 24 */,
  {-1, 0, 0x6625} /* 25 */,
  {-1, 0, 0x6627} /* 26 */,
  {-1, 0, 0x662F} /* 27 */,
  {-1, 0, 0x662D} /* 28 */,
  {-1, 0, 0x6620} /* 29 */,
  {-1, 0, 0x661F} /* 2A */,
  {-1, 0, 0x6628} /* 2B */,
  {-1, 0, 0x664F} /* 2C */,
  {-1, 0, 0x6642} /* 2D */,
  {-1, 0, 0x6652} /* 2E */,
  {-1, 0, 0x6649} /* 2F */,
  {-1, 0, 0x6643} /* 30 */,
  {-1, 0, 0x664C} /* 31 */,
  {-1, 0, 0x665D} /* 32 */,
  {-1, 0, 0x6664} /* 33 */,
  {-1, 0, 0x6668} /* 34 */,
  {-1, 0, 0x6666} /* 35 */,
  {-1, 0, 0x665A} /* 36 */,
  {-1, 0, 0x666F} /* 37 */,
  {-1, 0, 0x666E} /* 38 */,
  {-1, 0, 0xFA12} /* 39 */,
  {-1, 0, 0x6691} /* 3A */,
  {-1, 0, 0x6670} /* 3B */,
  {-1, 0, 0x6676} /* 3C */,
  {-1, 0, 0x667A} /* 3D */,
  {-1, 0, 0x6697} /* 3E */,
  {-1, 0, 0x6687} /* 3F */,
  {-1, 0, 0x6689} /* 40 */,
  {-1, 0, 0x6688} /* 41 */,
  {-1, 0, 0x6696} /* 42 */,
  {-1, 0, 0x66A2} /* 43 */,
  {-1, 0, 0x66AB} /* 44 */,
  {-1, 0, 0x66B4} /* 45 */,
  {-1, 0, 0x66AE} /* 46 */,
  {-1, 0, 0x66C1} /* 47 */,
  {-1, 0, 0x66C9} /* 48 */,
  {-1, 0, 0x66C6} /* 49 */,
  {-1, 0, 0x66B9} /* 4A */,
  {-1, 0, 0x66D6} /* 4B */,
  {-1, 0, 0x66D9} /* 4C */,
  {-1, 0, 0x66E0} /* 4D */,
  {-1, 0, 0x66DD} /* 4E */,
  {-1, 0, 0x66E6} /* 4F */,
  {-1, 0, 0x66F0} /* 50 */,
  {-1, 0, 0x66F2} /* 51 */,
  {-1, 0, 0x66F3} /* 52 */,
  {-1, 0, 0x66F4} /* 53 */,
  {-1, 0, 0x66F7} /* 54 */,
  {-1, 0, 0x66F8} /* 55 */,
  {-1, 0, 0x66F9} /* 56 */,
  {-1, 0, 0x52D7} /* 57 */,
  {-1, 0, 0x66FE} /* 58 */,
  {-1, 0, 0x66FF} /* 59 */,
  {-1, 0, 0x6703} /* 5A */,
  {-1, 0, 0x6708} /* 5B */,
  {-1, 0, 0x6709} /* 5C */,
  {-1, 0, 0x670D} /* 5D */,
  {-1, 0, 0x670B} /* 5E */,
  {-1, 0, 0x6717} /* 5F */,
  {-1, 0, 0x6715} /* 60 */,
  {-1, 0, 0x6714} /* 61 */,
  {-1, 0, 0x671B} /* 62 */,
  {-1, 0, 0x671D} /* 63 */,
  {-1, 0, 0x671F} /* 64 */,
  {-1, 0, 0},
  {-1, 0, 0x6727} /* 66 */,
  {-1, 0, 0x6728} /* 67 */,
  {-1, 0, 0},
  {-1, 0, 0x672C} /* 69 */,
  {-1, 0, 0x672B} /* 6A */,
  {-1, 0, 0x672A} /* 6B */,
  {-1, 0, 0},
  {-1, 0, 0x673D} /* 6D */,
  {-1, 0, 0},
  {-1, 0, 0x6731} /* 6F */,
  {-1, 0, 0x6735} /* 70 */,
  {-1, 0, 0x675E} /* 71 */,
  {-1, 0, 0x6751} /* 72 */,
  {-1, 0, 0x674E} /* 73 */,
  {-1, 0, 0x675C} /* 74 */,
  {-1, 0, 0x6750} /* 75 */,
  {-1, 0, 0x6756} /* 76 */,
  {-1, 0, 0x675F} /* 77 */,
  {-1, 0, 0x674F} /* 78 */,
  {-1, 0, 0x6749} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0x676D} /* 7B */,
  {-1, 0, 0x678B} /* 7C */,
  {-1, 0, 0x6795} /* 7D */,
  {-1, 0, 0x6789} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page22 = {
  0, marc8_9page22_dir
};
/* PAGE 21 */
struct yaz_iconv_trie_dir marc8_9page21_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x64CE} /* 21 */,
  {-1, 0, 0x64D4} /* 22 */,
  {-1, 0, 0x64D2} /* 23 */,
  {-1, 0, 0x64BF} /* 24 */,
  {-1, 0, 0x64E0} /* 25 */,
  {-1, 0, 0x64F0} /* 26 */,
  {-1, 0, 0x64E6} /* 27 */,
  {-1, 0, 0x64EC} /* 28 */,
  {-1, 0, 0x64F1} /* 29 */,
  {-1, 0, 0x64F4} /* 2A */,
  {-1, 0, 0x64F2} /* 2B */,
  {-1, 0, 0x6506} /* 2C */,
  {-1, 0, 0x6500} /* 2D */,
  {-1, 0, 0x64FE} /* 2E */,
  {-1, 0, 0x64FB} /* 2F */,
  {-1, 0, 0x64FA} /* 30 */,
  {-1, 0, 0x650F} /* 31 */,
  {-1, 0, 0x6518} /* 32 */,
  {-1, 0, 0x6514} /* 33 */,
  {-1, 0, 0x6519} /* 34 */,
  {-1, 0, 0x651D} /* 35 */,
  {-1, 0, 0x651C} /* 36 */,
  {-1, 0, 0x6523} /* 37 */,
  {-1, 0, 0x6524} /* 38 */,
  {-1, 0, 0x652B} /* 39 */,
  {-1, 0, 0x652A} /* 3A */,
  {-1, 0, 0x652C} /* 3B */,
  {-1, 0, 0x652F} /* 3C */,
  {-1, 0, 0x6536} /* 3D */,
  {-1, 0, 0x6539} /* 3E */,
  {-1, 0, 0x653B} /* 3F */,
  {-1, 0, 0x653E} /* 40 */,
  {-1, 0, 0x653F} /* 41 */,
  {-1, 0, 0x6545} /* 42 */,
  {-1, 0, 0x6548} /* 43 */,
  {-1, 0, 0x654E} /* 44 */,
  {-1, 0, 0x6556} /* 45 */,
  {-1, 0, 0x6551} /* 46 */,
  {-1, 0, 0x6557} /* 47 */,
  {-1, 0, 0x655D} /* 48 */,
  {-1, 0, 0x6558} /* 49 */,
  {-1, 0, 0x654F} /* 4A */,
  {-1, 0, 0x6566} /* 4B */,
  {-1, 0, 0x6562} /* 4C */,
  {-1, 0, 0x6563} /* 4D */,
  {-1, 0, 0x655E} /* 4E */,
  {-1, 0, 0x5553} /* 4F */,
  {-1, 0, 0x656C} /* 50 */,
  {-1, 0, 0x6572} /* 51 */,
  {-1, 0, 0x6575} /* 52 */,
  {-1, 0, 0x6577} /* 53 */,
  {-1, 0, 0x6578} /* 54 */,
  {-1, 0, 0x6574} /* 55 */,
  {-1, 0, 0x6582} /* 56 */,
  {-1, 0, 0x6583} /* 57 */,
  {-1, 0, 0x6587} /* 58 */,
  {-1, 0, 0x6591} /* 59 */,
  {-1, 0, 0x6590} /* 5A */,
  {-1, 0, 0},
  {-1, 0, 0x6599} /* 5C */,
  {-1, 0, 0x659C} /* 5D */,
  {-1, 0, 0x659F} /* 5E */,
  {-1, 0, 0x65A1} /* 5F */,
  {-1, 0, 0x65A4} /* 60 */,
  {-1, 0, 0x65A5} /* 61 */,
  {-1, 0, 0x65A7} /* 62 */,
  {-1, 0, 0x65AC} /* 63 */,
  {-1, 0, 0x65AF} /* 64 */,
  {-1, 0, 0x65B0} /* 65 */,
  {-1, 0, 0x65B7} /* 66 */,
  {-1, 0, 0x65B9} /* 67 */,
  {-1, 0, 0},
  {-1, 0, 0x65BD} /* 69 */,
  {-1, 0, 0x65C1} /* 6A */,
  {-1, 0, 0x65C5} /* 6B */,
  {-1, 0, 0x65CE} /* 6C */,
  {-1, 0, 0x65CB} /* 6D */,
  {-1, 0, 0x65CC} /* 6E */,
  {-1, 0, 0x65CF} /* 6F */,
  {-1, 0, 0x65D7} /* 70 */,
  {-1, 0, 0x65D6} /* 71 */,
  {-1, 0, 0x65E2} /* 72 */,
  {-1, 0, 0x65E5} /* 73 */,
  {-1, 0, 0},
  {-1, 0, 0x65E9} /* 75 */,
  {-1, 0, 0x65EC} /* 76 */,
  {-1, 0, 0x65ED} /* 77 */,
  {-1, 0, 0x65E8} /* 78 */,
  {-1, 0, 0x65F1} /* 79 */,
  {-1, 0, 0x65FA} /* 7A */,
  {-1, 0, 0x6606} /* 7B */,
  {-1, 0, 0x6614} /* 7C */,
  {-1, 0, 0x660C} /* 7D */,
  {-1, 0, 0x6600} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page21 = {
  0, marc8_9page21_dir
};
/* PAGE 20 */
struct yaz_iconv_trie_dir marc8_9page20_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6367} /* 21 */,
  {-1, 0, 0x6398} /* 22 */,
  {-1, 0, 0x639B} /* 23 */,
  {-1, 0, 0x63AA} /* 24 */,
  {-1, 0, 0x6371} /* 25 */,
  {-1, 0, 0x63A9} /* 26 */,
  {-1, 0, 0x638C} /* 27 */,
  {-1, 0, 0x6389} /* 28 */,
  {-1, 0, 0x63A2} /* 29 */,
  {-1, 0, 0x6399} /* 2A */,
  {-1, 0, 0x63A1} /* 2B */,
  {-1, 0, 0x6388} /* 2C */,
  {-1, 0, 0x63AC} /* 2D */,
  {-1, 0, 0x633D} /* 2E */,
  {-1, 0, 0x6392} /* 2F */,
  {-1, 0, 0x63A3} /* 30 */,
  {-1, 0, 0x6376} /* 31 */,
  {-1, 0, 0x638F} /* 32 */,
  {-1, 0, 0x63A8} /* 33 */,
  {-1, 0, 0x637B} /* 34 */,
  {-1, 0, 0xE93F} /* 35 */,
  {-1, 0, 0x6384} /* 36 */,
  {-1, 0, 0x6380} /* 37 */,
  {-1, 0, 0x63C6} /* 38 */,
  {-1, 0, 0x63C9} /* 39 */,
  {-1, 0, 0x63CD} /* 3A */,
  {-1, 0, 0x63E1} /* 3B */,
  {-1, 0, 0x63C0} /* 3C */,
  {-1, 0, 0x63E9} /* 3D */,
  {-1, 0, 0x63D0} /* 3E */,
  {-1, 0, 0x63DA} /* 3F */,
  {-1, 0, 0x63D6} /* 40 */,
  {-1, 0, 0x63ED} /* 41 */,
  {-1, 0, 0x63EE} /* 42 */,
  {-1, 0, 0x63CF} /* 43 */,
  {-1, 0, 0x63E3} /* 44 */,
  {-1, 0, 0x63F4} /* 45 */,
  {-1, 0, 0xE940} /* 46 */,
  {-1, 0, 0x63D2} /* 47 */,
  {-1, 0, 0x63EA} /* 48 */,
  {-1, 0, 0x641E} /* 49 */,
  {-1, 0, 0x642A} /* 4A */,
  {-1, 0, 0x643E} /* 4B */,
  {-1, 0, 0x6413} /* 4C */,
  {-1, 0, 0x640F} /* 4D */,
  {-1, 0, 0x6414} /* 4E */,
  {-1, 0, 0x640D} /* 4F */,
  {-1, 0, 0x642D} /* 50 */,
  {-1, 0, 0x643D} /* 51 */,
  {-1, 0, 0x6416} /* 52 */,
  {-1, 0, 0x6417} /* 53 */,
  {-1, 0, 0x641C} /* 54 */,
  {-1, 0, 0x6436} /* 55 */,
  {-1, 0, 0x642C} /* 56 */,
  {-1, 0, 0x6458} /* 57 */,
  {-1, 0, 0x6469} /* 58 */,
  {-1, 0, 0x6454} /* 59 */,
  {-1, 0, 0x6452} /* 5A */,
  {-1, 0, 0x646F} /* 5B */,
  {-1, 0, 0x6478} /* 5C */,
  {-1, 0, 0x6479} /* 5D */,
  {-1, 0, 0x647A} /* 5E */,
  {-1, 0, 0x645F} /* 5F */,
  {-1, 0, 0x6451} /* 60 */,
  {-1, 0, 0x6467} /* 61 */,
  {-1, 0, 0x649E} /* 62 */,
  {-1, 0, 0x64A4} /* 63 */,
  {-1, 0, 0x6487} /* 64 */,
  {-1, 0, 0x6488} /* 65 */,
  {-1, 0, 0x64A5} /* 66 */,
  {-1, 0, 0x64B0} /* 67 */,
  {-1, 0, 0x6493} /* 68 */,
  {-1, 0, 0x6495} /* 69 */,
  {-1, 0, 0x6492} /* 6A */,
  {-1, 0, 0x64A9} /* 6B */,
  {-1, 0, 0x6491} /* 6C */,
  {-1, 0, 0x64AE} /* 6D */,
  {-1, 0, 0x64B2} /* 6E */,
  {-1, 0, 0x64AD} /* 6F */,
  {-1, 0, 0x649A} /* 70 */,
  {-1, 0, 0x64AB} /* 71 */,
  {-1, 0, 0x64AC} /* 72 */,
  {-1, 0, 0x64C5} /* 73 */,
  {-1, 0, 0x64C1} /* 74 */,
  {-1, 0, 0x64D8} /* 75 */,
  {-1, 0, 0x64CA} /* 76 */,
  {-1, 0, 0x64BB} /* 77 */,
  {-1, 0, 0x64C2} /* 78 */,
  {-1, 0, 0x64BC} /* 79 */,
  {-1, 0, 0x64CB} /* 7A */,
  {-1, 0, 0x64CD} /* 7B */,
  {-1, 0, 0x64DA} /* 7C */,
  {-1, 0, 0x64C4} /* 7D */,
  {-1, 0, 0x64C7} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page20 = {
  0, marc8_9page20_dir
};
/* PAGE 19 */
struct yaz_iconv_trie_dir marc8_9page19_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6252} /* 21 */,
  {-1, 0, 0x625B} /* 22 */,
  {-1, 0, 0x6263} /* 23 */,
  {-1, 0, 0x6258} /* 24 */,
  {-1, 0, 0x6296} /* 25 */,
  {-1, 0, 0x6297} /* 26 */,
  {-1, 0, 0x6292} /* 27 */,
  {-1, 0, 0x6276} /* 28 */,
  {-1, 0, 0x6289} /* 29 */,
  {-1, 0, 0x627F} /* 2A */,
  {-1, 0, 0x6279} /* 2B */,
  {-1, 0, 0x6280} /* 2C */,
  {-1, 0, 0x628A} /* 2D */,
  {-1, 0, 0x626D} /* 2E */,
  {-1, 0, 0x627C} /* 2F */,
  {-1, 0, 0x627E} /* 30 */,
  {-1, 0, 0x626F} /* 31 */,
  {-1, 0, 0x6284} /* 32 */,
  {-1, 0, 0x6295} /* 33 */,
  {-1, 0, 0x6291} /* 34 */,
  {-1, 0, 0x6298} /* 35 */,
  {-1, 0, 0x626E} /* 36 */,
  {-1, 0, 0x6273} /* 37 */,
  {-1, 0, 0x6293} /* 38 */,
  {-1, 0, 0x62C9} /* 39 */,
  {-1, 0, 0x62C4} /* 3A */,
  {-1, 0, 0x62CC} /* 3B */,
  {-1, 0, 0x62A8} /* 3C */,
  {-1, 0, 0x62DC} /* 3D */,
  {-1, 0, 0x62BF} /* 3E */,
  {-1, 0, 0x62C2} /* 3F */,
  {-1, 0, 0x62B9} /* 40 */,
  {-1, 0, 0x62D2} /* 41 */,
  {-1, 0, 0x62D3} /* 42 */,
  {-1, 0, 0x62DB} /* 43 */,
  {-1, 0, 0x62AB} /* 44 */,
  {-1, 0, 0x62CB} /* 45 */,
  {-1, 0, 0x62D4} /* 46 */,
  {-1, 0, 0x62BD} /* 47 */,
  {-1, 0, 0x62BC} /* 48 */,
  {-1, 0, 0xE93D} /* 49 */,
  {-1, 0, 0x62C8} /* 4A */,
  {-1, 0, 0x62D9} /* 4B */,
  {-1, 0, 0x62DA} /* 4C */,
  {-1, 0, 0x62AC} /* 4D */,
  {-1, 0, 0x62C7} /* 4E */,
  {-1, 0, 0x62B1} /* 4F */,
  {-1, 0, 0x62D6} /* 50 */,
  {-1, 0, 0x62D8} /* 51 */,
  {-1, 0, 0x62CD} /* 52 */,
  {-1, 0, 0x62B5} /* 53 */,
  {-1, 0, 0x62CE} /* 54 */,
  {-1, 0, 0x62D7} /* 55 */,
  {-1, 0, 0x62C6} /* 56 */,
  {-1, 0, 0x6309} /* 57 */,
  {-1, 0, 0x6316} /* 58 */,
  {-1, 0, 0x62FC} /* 59 */,
  {-1, 0, 0x62F3} /* 5A */,
  {-1, 0, 0x6308} /* 5B */,
  {-1, 0, 0x62ED} /* 5C */,
  {-1, 0, 0x6301} /* 5D */,
  {-1, 0, 0x62EE} /* 5E */,
  {-1, 0, 0x62EF} /* 5F */,
  {-1, 0, 0x62F7} /* 60 */,
  {-1, 0, 0x6307} /* 61 */,
  {-1, 0, 0x62F1} /* 62 */,
  {-1, 0, 0x62FD} /* 63 */,
  {-1, 0, 0x6311} /* 64 */,
  {-1, 0, 0x62EC} /* 65 */,
  {-1, 0, 0xE93E} /* 66 */,
  {-1, 0, 0x62FF} /* 67 */,
  {-1, 0, 0},
  {-1, 0, 0x6342} /* 69 */,
  {-1, 0, 0x632A} /* 6A */,
  {-1, 0, 0x6355} /* 6B */,
  {-1, 0, 0x633E} /* 6C */,
  {-1, 0, 0x632F} /* 6D */,
  {-1, 0, 0x634E} /* 6E */,
  {-1, 0, 0x634F} /* 6F */,
  {-1, 0, 0x6350} /* 70 */,
  {-1, 0, 0x6349} /* 71 */,
  {-1, 0, 0},
  {-1, 0, 0x632B} /* 73 */,
  {-1, 0, 0x6328} /* 74 */,
  {-1, 0, 0x633A} /* 75 */,
  {-1, 0, 0x63A5} /* 76 */,
  {-1, 0, 0x6369} /* 77 */,
  {-1, 0, 0x63A0} /* 78 */,
  {-1, 0, 0x6396} /* 79 */,
  {-1, 0, 0x63A7} /* 7A */,
  {-1, 0, 0x6372} /* 7B */,
  {-1, 0, 0x6377} /* 7C */,
  {-1, 0, 0x6383} /* 7D */,
  {-1, 0, 0x636B} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page19 = {
  0, marc8_9page19_dir
};
/* PAGE 18 */
struct yaz_iconv_trie_dir marc8_9page18_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6148} /* 21 */,
  {-1, 0, 0x6168} /* 22 */,
  {-1, 0, 0},
  {-1, 0, 0x613C} /* 24 */,
  {-1, 0, 0},
  {-1, 0, 0x614C} /* 26 */,
  {-1, 0, 0x614D} /* 27 */,
  {-1, 0, 0x614B} /* 28 */,
  {-1, 0, 0x613E} /* 29 */,
  {-1, 0, 0x6127} /* 2A */,
  {-1, 0, 0x6134} /* 2B */,
  {-1, 0, 0x6147} /* 2C */,
  {-1, 0, 0x6177} /* 2D */,
  {-1, 0, 0x6176} /* 2E */,
  {-1, 0, 0x6167} /* 2F */,
  {-1, 0, 0x6170} /* 30 */,
  {-1, 0, 0x615A} /* 31 */,
  {-1, 0, 0x615D} /* 32 */,
  {-1, 0, 0x6182} /* 33 */,
  {-1, 0, 0x617C} /* 34 */,
  {-1, 0, 0x6162} /* 35 */,
  {-1, 0, 0x616E} /* 36 */,
  {-1, 0, 0x6155} /* 37 */,
  {-1, 0, 0x6158} /* 38 */,
  {-1, 0, 0x6163} /* 39 */,
  {-1, 0, 0x615F} /* 3A */,
  {-1, 0, 0x616B} /* 3B */,
  {-1, 0, 0x617E} /* 3C */,
  {-1, 0, 0x61A7} /* 3D */,
  {-1, 0, 0x61B2} /* 3E */,
  {-1, 0, 0x6191} /* 3F */,
  {-1, 0, 0x618E} /* 40 */,
  {-1, 0, 0x61AB} /* 41 */,
  {-1, 0, 0x61A4} /* 42 */,
  {-1, 0, 0x61AC} /* 43 */,
  {-1, 0, 0x619A} /* 44 */,
  {-1, 0, 0x61A9} /* 45 */,
  {-1, 0, 0x6194} /* 46 */,
  {-1, 0, 0x618A} /* 47 */,
  {-1, 0, 0x61B6} /* 48 */,
  {-1, 0, 0x61CD} /* 49 */,
  {-1, 0, 0x61C9} /* 4A */,
  {-1, 0, 0x6190} /* 4B */,
  {-1, 0, 0x61BE} /* 4C */,
  {-1, 0, 0x61C2} /* 4D */,
  {-1, 0, 0x61C7} /* 4E */,
  {-1, 0, 0x61C8} /* 4F */,
  {-1, 0, 0x61CA} /* 50 */,
  {-1, 0, 0x61E3} /* 51 */,
  {-1, 0, 0x61E6} /* 52 */,
  {-1, 0, 0xE93C} /* 53 */,
  {-1, 0, 0x61F7} /* 54 */,
  {-1, 0, 0x61F6} /* 55 */,
  {-1, 0, 0x61F8} /* 56 */,
  {-1, 0, 0x61F5} /* 57 */,
  {-1, 0, 0x61FA} /* 58 */,
  {-1, 0, 0x61FE} /* 59 */,
  {-1, 0, 0x61FF} /* 5A */,
  {-1, 0, 0x61FC} /* 5B */,
  {-1, 0, 0x6200} /* 5C */,
  {-1, 0, 0x6208} /* 5D */,
  {-1, 0, 0x620A} /* 5E */,
  {-1, 0, 0x620E} /* 5F */,
  {-1, 0, 0x620D} /* 60 */,
  {-1, 0, 0x620C} /* 61 */,
  {-1, 0, 0x6210} /* 62 */,
  {-1, 0, 0x6212} /* 63 */,
  {-1, 0, 0x6211} /* 64 */,
  {-1, 0, 0x6216} /* 65 */,
  {-1, 0, 0x6215} /* 66 */,
  {-1, 0, 0x621B} /* 67 */,
  {-1, 0, 0x621A} /* 68 */,
  {-1, 0, 0x621F} /* 69 */,
  {-1, 0, 0x6221} /* 6A */,
  {-1, 0, 0x6222} /* 6B */,
  {-1, 0, 0x622A} /* 6C */,
  {-1, 0, 0x622E} /* 6D */,
  {-1, 0, 0x6230} /* 6E */,
  {-1, 0, 0x6232} /* 6F */,
  {-1, 0, 0x6234} /* 70 */,
  {-1, 0, 0x6233} /* 71 */,
  {-1, 0, 0x6236} /* 72 */,
  {-1, 0, 0x623F} /* 73 */,
  {-1, 0, 0x623E} /* 74 */,
  {-1, 0, 0x6240} /* 75 */,
  {-1, 0, 0x6241} /* 76 */,
  {-1, 0, 0},
  {-1, 0, 0x6248} /* 78 */,
  {-1, 0, 0x6249} /* 79 */,
  {-1, 0, 0x624B} /* 7A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x6253} /* 7D */,
  {-1, 0, 0x6254} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page18 = {
  0, marc8_9page18_dir
};
/* PAGE 17 */
struct yaz_iconv_trie_dir marc8_9page17_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5FCD} /* 21 */,
  {-1, 0, 0x5FEB} /* 22 */,
  {-1, 0, 0x5FE0} /* 23 */,
  {-1, 0, 0x5FF1} /* 24 */,
  {-1, 0, 0x5FFD} /* 25 */,
  {-1, 0, 0x5FDD} /* 26 */,
  {-1, 0, 0x5FF5} /* 27 */,
  {-1, 0, 0x5FFF} /* 28 */,
  {-1, 0, 0x6014} /* 29 */,
  {-1, 0, 0xE939} /* 2A */,
  {-1, 0, 0x602A} /* 2B */,
  {-1, 0, 0x602F} /* 2C */,
  {-1, 0, 0x6016} /* 2D */,
  {-1, 0, 0x601D} /* 2E */,
  {-1, 0, 0x600F} /* 2F */,
  {-1, 0, 0x6021} /* 30 */,
  {-1, 0, 0x6020} /* 31 */,
  {-1, 0, 0x6028} /* 32 */,
  {-1, 0, 0x6025} /* 33 */,
  {-1, 0, 0x6027} /* 34 */,
  {-1, 0, 0x600E} /* 35 */,
  {-1, 0, 0x6015} /* 36 */,
  {-1, 0, 0x6012} /* 37 */,
  {-1, 0, 0x6059} /* 38 */,
  {-1, 0, 0x6063} /* 39 */,
  {-1, 0, 0x6068} /* 3A */,
  {-1, 0, 0x6043} /* 3B */,
  {-1, 0, 0x6065} /* 3C */,
  {-1, 0, 0x6050} /* 3D */,
  {-1, 0, 0x606D} /* 3E */,
  {-1, 0, 0x6062} /* 3F */,
  {-1, 0, 0xE93A} /* 40 */,
  {-1, 0, 0x604D} /* 41 */,
  {-1, 0, 0x606B} /* 42 */,
  {-1, 0, 0x6069} /* 43 */,
  {-1, 0, 0x606C} /* 44 */,
  {-1, 0, 0x606F} /* 45 */,
  {-1, 0, 0x606A} /* 46 */,
  {-1, 0, 0x6064} /* 47 */,
  {-1, 0, 0x6070} /* 48 */,
  {-1, 0, 0x6055} /* 49 */,
  {-1, 0, 0x608C} /* 4A */,
  {-1, 0, 0x60A6} /* 4B */,
  {-1, 0, 0x607F} /* 4C */,
  {-1, 0, 0x609F} /* 4D */,
  {-1, 0, 0x609A} /* 4E */,
  {-1, 0, 0x6096} /* 4F */,
  {-1, 0, 0x6084} /* 50 */,
  {-1, 0, 0x608D} /* 51 */,
  {-1, 0, 0x60A3} /* 52 */,
  {-1, 0, 0x6089} /* 53 */,
  {-1, 0, 0x6094} /* 54 */,
  {-1, 0, 0x60A0} /* 55 */,
  {-1, 0, 0x60A8} /* 56 */,
  {-1, 0, 0x60B4} /* 57 */,
  {-1, 0, 0x60E6} /* 58 */,
  {-1, 0, 0x60CB} /* 59 */,
  {-1, 0, 0},
  {-1, 0, 0xE93B} /* 5B */,
  {-1, 0, 0x60B6} /* 5C */,
  {-1, 0, 0x60D1} /* 5D */,
  {-1, 0, 0x60B5} /* 5E */,
  {-1, 0, 0x60BB} /* 5F */,
  {-1, 0, 0x60E0} /* 60 */,
  {-1, 0, 0x60E1} /* 61 */,
  {-1, 0, 0x60DC} /* 62 */,
  {-1, 0, 0x60D8} /* 63 */,
  {-1, 0, 0x60D5} /* 64 */,
  {-1, 0, 0x60BC} /* 65 */,
  {-1, 0, 0x60B2} /* 66 */,
  {-1, 0, 0x60C6} /* 67 */,
  {-1, 0, 0x60B8} /* 68 */,
  {-1, 0, 0x60DA} /* 69 */,
  {-1, 0, 0x60DF} /* 6A */,
  {-1, 0, 0x610F} /* 6B */,
  {-1, 0, 0x611C} /* 6C */,
  {-1, 0, 0x60F3} /* 6D */,
  {-1, 0, 0x611F} /* 6E */,
  {-1, 0, 0x60F0} /* 6F */,
  {-1, 0, 0x60FB} /* 70 */,
  {-1, 0, 0x60FA} /* 71 */,
  {-1, 0, 0x611A} /* 72 */,
  {-1, 0, 0x6115} /* 73 */,
  {-1, 0, 0x60F9} /* 74 */,
  {-1, 0, 0x6123} /* 75 */,
  {-1, 0, 0x60F4} /* 76 */,
  {-1, 0, 0x611B} /* 77 */,
  {-1, 0, 0x610E} /* 78 */,
  {-1, 0, 0x6100} /* 79 */,
  {-1, 0, 0x6101} /* 7A */,
  {-1, 0, 0x60F6} /* 7B */,
  {-1, 0, 0x6109} /* 7C */,
  {-1, 0, 0x6108} /* 7D */,
  {-1, 0, 0x60F1} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page17 = {
  0, marc8_9page17_dir
};
/* PAGE 16 */
struct yaz_iconv_trie_dir marc8_9page16_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5EBE} /* 21 */,
  {-1, 0, 0x5ECA} /* 22 */,
  {-1, 0, 0x5EC9} /* 23 */,
  {-1, 0, 0x5EC8} /* 24 */,
  {-1, 0, 0x5ED3} /* 25 */,
  {-1, 0, 0x5ED6} /* 26 */,
  {-1, 0, 0x5EE2} /* 27 */,
  {-1, 0, 0x5EDA} /* 28 */,
  {-1, 0, 0x5EDD} /* 29 */,
  {-1, 0, 0xE938} /* 2A */,
  {-1, 0, 0x5EDF} /* 2B */,
  {-1, 0, 0x5EE0} /* 2C */,
  {-1, 0, 0x9F90} /* 2D */,
  {-1, 0, 0x5EEC} /* 2E */,
  {-1, 0, 0x5EF3} /* 2F */,
  {-1, 0, 0x5EF7} /* 30 */,
  {-1, 0, 0},
  {-1, 0, 0x5EF6} /* 32 */,
  {-1, 0, 0x5EFA} /* 33 */,
  {-1, 0, 0x5EFF} /* 34 */,
  {-1, 0, 0},
  {-1, 0, 0x5F04} /* 36 */,
  {-1, 0, 0x5F08} /* 37 */,
  {-1, 0, 0x5F0A} /* 38 */,
  {-1, 0, 0x5F0F} /* 39 */,
  {-1, 0, 0x5F12} /* 3A */,
  {-1, 0, 0x5F13} /* 3B */,
  {-1, 0, 0x5F15} /* 3C */,
  {-1, 0, 0x5F14} /* 3D */,
  {-1, 0, 0x5F18} /* 3E */,
  {-1, 0, 0x5F17} /* 3F */,
  {-1, 0, 0x5F1B} /* 40 */,
  {-1, 0, 0x5F1F} /* 41 */,
  {-1, 0, 0x5F26} /* 42 */,
  {-1, 0, 0x5F27} /* 43 */,
  {-1, 0, 0x5F29} /* 44 */,
  {-1, 0, 0x5F2D} /* 45 */,
  {-1, 0, 0x5F31} /* 46 */,
  {-1, 0, 0x5F35} /* 47 */,
  {-1, 0, 0x5F37} /* 48 */,
  {-1, 0, 0x5F3C} /* 49 */,
  {-1, 0, 0x5F46} /* 4A */,
  {-1, 0, 0x5F48} /* 4B */,
  {-1, 0, 0x5F4C} /* 4C */,
  {-1, 0, 0x5F4E} /* 4D */,
  {-1, 0, 0x5F57} /* 4E */,
  {-1, 0, 0x5F59} /* 4F */,
  {-1, 0, 0x5F5D} /* 50 */,
  {-1, 0, 0x5F62} /* 51 */,
  {-1, 0, 0x5F64} /* 52 */,
  {-1, 0, 0x5F65} /* 53 */,
  {-1, 0, 0x5F6C} /* 54 */,
  {-1, 0, 0x5F69} /* 55 */,
  {-1, 0, 0},
  {-1, 0, 0x5F6D} /* 57 */,
  {-1, 0, 0x5F70} /* 58 */,
  {-1, 0, 0x5F71} /* 59 */,
  {-1, 0, 0},
  {-1, 0, 0x5F79} /* 5B */,
  {-1, 0, 0x5F80} /* 5C */,
  {-1, 0, 0},
  {-1, 0, 0x5F7F} /* 5E */,
  {-1, 0, 0x5F7C} /* 5F */,
  {-1, 0, 0x5F85} /* 60 */,
  {-1, 0, 0x5F88} /* 61 */,
  {-1, 0, 0x5F8B} /* 62 */,
  {-1, 0, 0x5F8A} /* 63 */,
  {-1, 0, 0x5F87} /* 64 */,
  {-1, 0, 0x5F8C} /* 65 */,
  {-1, 0, 0x5F92} /* 66 */,
  {-1, 0, 0x5F91} /* 67 */,
  {-1, 0, 0x5F90} /* 68 */,
  {-1, 0, 0x5F98} /* 69 */,
  {-1, 0, 0x5F97} /* 6A */,
  {-1, 0, 0x5F99} /* 6B */,
  {-1, 0, 0x5F9E} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5FA9} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x5FAA} /* 71 */,
  {-1, 0, 0x5FAC} /* 72 */,
  {-1, 0, 0x5FAE} /* 73 */,
  {-1, 0, 0x5FB9} /* 74 */,
  {-1, 0, 0x5FB7} /* 75 */,
  {-1, 0, 0x5FB5} /* 76 */,
  {-1, 0, 0x5FBD} /* 77 */,
  {-1, 0, 0x5FC3} /* 78 */,
  {-1, 0, 0x5FC5} /* 79 */,
  {-1, 0, 0x5FD9} /* 7A */,
  {-1, 0, 0x5FD8} /* 7B */,
  {-1, 0, 0x5FCC} /* 7C */,
  {-1, 0, 0x5FD6} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page16 = {
  0, marc8_9page16_dir
};
/* PAGE 15 */
struct yaz_iconv_trie_dir marc8_9page15_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5D0E} /* 21 */,
  {-1, 0, 0x5D11} /* 22 */,
  {-1, 0, 0x5D22} /* 23 */,
  {-1, 0, 0x5D29} /* 24 */,
  {-1, 0, 0x5D14} /* 25 */,
  {-1, 0, 0x5D19} /* 26 */,
  {-1, 0, 0x5D4C} /* 27 */,
  {-1, 0, 0x5D50} /* 28 */,
  {-1, 0, 0x5D69} /* 29 */,
  {-1, 0, 0x5D84} /* 2A */,
  {-1, 0, 0x5D87} /* 2B */,
  {-1, 0, 0x5D9D} /* 2C */,
  {-1, 0, 0x5DBC} /* 2D */,
  {-1, 0, 0x5DBD} /* 2E */,
  {-1, 0, 0xE937} /* 2F */,
  {-1, 0, 0x5DCD} /* 30 */,
  {-1, 0, 0x5DD2} /* 31 */,
  {-1, 0, 0x5DD4} /* 32 */,
  {-1, 0, 0x5DD6} /* 33 */,
  {-1, 0, 0x5DDD} /* 34 */,
  {-1, 0, 0x5DDE} /* 35 */,
  {-1, 0, 0x5DE2} /* 36 */,
  {-1, 0, 0x5DE5} /* 37 */,
  {-1, 0, 0x5DE8} /* 38 */,
  {-1, 0, 0x5DE7} /* 39 */,
  {-1, 0, 0x5DE6} /* 3A */,
  {-1, 0, 0x5DEB} /* 3B */,
  {-1, 0, 0x5DEE} /* 3C */,
  {-1, 0, 0x5DF1} /* 3D */,
  {-1, 0, 0x5DF2} /* 3E */,
  {-1, 0, 0x5DF3} /* 3F */,
  {-1, 0, 0x5DF4} /* 40 */,
  {-1, 0, 0x5DF7} /* 41 */,
  {-1, 0, 0x5DFD} /* 42 */,
  {-1, 0, 0x5DFE} /* 43 */,
  {-1, 0, 0x5E02} /* 44 */,
  {-1, 0, 0},
  {-1, 0, 0x5E06} /* 46 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5E1A} /* 49 */,
  {-1, 0, 0x5E16} /* 4A */,
  {-1, 0, 0x5E15} /* 4B */,
  {-1, 0, 0x5E1B} /* 4C */,
  {-1, 0, 0x5E11} /* 4D */,
  {-1, 0, 0x5E1D} /* 4E */,
  {-1, 0, 0x5E25} /* 4F */,
  {-1, 0, 0},
  {-1, 0, 0x5E2B} /* 51 */,
  {-1, 0, 0x5E33} /* 52 */,
  {-1, 0, 0x5E36} /* 53 */,
  {-1, 0, 0x5E38} /* 54 */,
  {-1, 0, 0x5E37} /* 55 */,
  {-1, 0, 0x5E45} /* 56 */,
  {-1, 0, 0x5E3D} /* 57 */,
  {-1, 0, 0x5E40} /* 58 */,
  {-1, 0, 0x5E4C} /* 59 */,
  {-1, 0, 0x5E5B} /* 5A */,
  {-1, 0, 0x5E54} /* 5B */,
  {-1, 0, 0x5E57} /* 5C */,
  {-1, 0, 0x5E55} /* 5D */,
  {-1, 0, 0x5E63} /* 5E */,
  {-1, 0, 0x5E62} /* 5F */,
  {-1, 0, 0x5E5F} /* 60 */,
  {-1, 0, 0x5E6B} /* 61 */,
  {-1, 0, 0},
  {-1, 0, 0x5E73} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x5E74} /* 65 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5E7B} /* 68 */,
  {-1, 0, 0x5E7C} /* 69 */,
  {-1, 0, 0x5E7D} /* 6A */,
  {-1, 0, 0x5E7E} /* 6B */,
  {-1, 0, 0x5E8F} /* 6C */,
  {-1, 0, 0x5E87} /* 6D */,
  {-1, 0, 0x5E8A} /* 6E */,
  {-1, 0, 0x5E9A} /* 6F */,
  {-1, 0, 0x5E97} /* 70 */,
  {-1, 0, 0x5E96} /* 71 */,
  {-1, 0, 0x5E9C} /* 72 */,
  {-1, 0, 0x5E95} /* 73 */,
  {-1, 0, 0x5EA0} /* 74 */,
  {-1, 0, 0x5EA6} /* 75 */,
  {-1, 0, 0x5EAB} /* 76 */,
  {-1, 0, 0x5EA7} /* 77 */,
  {-1, 0, 0x5EAD} /* 78 */,
  {-1, 0, 0x5EB7} /* 79 */,
  {-1, 0, 0x5EB8} /* 7A */,
  {-1, 0, 0x5EB6} /* 7B */,
  {-1, 0, 0x5EB5} /* 7C */,
  {-1, 0, 0x5EC2} /* 7D */,
  {-1, 0, 0x5EC1} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page15 = {
  0, marc8_9page15_dir
};
/* PAGE 14 */
struct yaz_iconv_trie_dir marc8_9page14_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5BC6} /* 21 */,
  {-1, 0, 0x5BC7} /* 22 */,
  {-1, 0, 0x5BC5} /* 23 */,
  {-1, 0, 0x5BC4} /* 24 */,
  {-1, 0, 0x5BC2} /* 25 */,
  {-1, 0, 0x5BBF} /* 26 */,
  {-1, 0, 0x5BCC} /* 27 */,
  {-1, 0, 0x5BD2} /* 28 */,
  {-1, 0, 0x5BD0} /* 29 */,
  {-1, 0, 0x5BD3} /* 2A */,
  {-1, 0, 0x5BE1} /* 2B */,
  {-1, 0, 0x5BE5} /* 2C */,
  {-1, 0, 0x5BE8} /* 2D */,
  {-1, 0, 0x5BE2} /* 2E */,
  {-1, 0, 0x5BE4} /* 2F */,
  {-1, 0, 0x5BDE} /* 30 */,
  {-1, 0, 0x5BE6} /* 31 */,
  {-1, 0, 0x5BE7} /* 32 */,
  {-1, 0, 0x5BDF} /* 33 */,
  {-1, 0, 0x5BEE} /* 34 */,
  {-1, 0, 0x5BEC} /* 35 */,
  {-1, 0, 0x5BE9} /* 36 */,
  {-1, 0, 0x5BEB} /* 37 */,
  {-1, 0, 0x5BF5} /* 38 */,
  {-1, 0, 0x5BF6} /* 39 */,
  {-1, 0, 0x5BF8} /* 3A */,
  {-1, 0, 0x5BFA} /* 3B */,
  {-1, 0, 0x5C01} /* 3C */,
  {-1, 0, 0x5C04} /* 3D */,
  {-1, 0, 0x5C09} /* 3E */,
  {-1, 0, 0x5C08} /* 3F */,
  {-1, 0, 0x5C07} /* 40 */,
  {-1, 0, 0x5C0A} /* 41 */,
  {-1, 0, 0x5C0B} /* 42 */,
  {-1, 0, 0x5C0D} /* 43 */,
  {-1, 0, 0x5C0E} /* 44 */,
  {-1, 0, 0x5C0F} /* 45 */,
  {-1, 0, 0x5C11} /* 46 */,
  {-1, 0, 0x5C16} /* 47 */,
  {-1, 0, 0x5C1A} /* 48 */,
  {-1, 0, 0x5C24} /* 49 */,
  {-1, 0, 0x5C2C} /* 4A */,
  {-1, 0, 0x5C31} /* 4B */,
  {-1, 0, 0x5C37} /* 4C */,
  {-1, 0, 0x5C38} /* 4D */,
  {-1, 0, 0x5C3A} /* 4E */,
  {-1, 0, 0x5C3C} /* 4F */,
  {-1, 0, 0x5C40} /* 50 */,
  {-1, 0, 0x5C41} /* 51 */,
  {-1, 0, 0x5C3F} /* 52 */,
  {-1, 0, 0x5C3E} /* 53 */,
  {-1, 0, 0x5C46} /* 54 */,
  {-1, 0, 0x5C45} /* 55 */,
  {-1, 0, 0x5C48} /* 56 */,
  {-1, 0, 0x5C4E} /* 57 */,
  {-1, 0, 0x5C4B} /* 58 */,
  {-1, 0, 0x5C4D} /* 59 */,
  {-1, 0, 0x5C55} /* 5A */,
  {-1, 0, 0x5C51} /* 5B */,
  {-1, 0, 0x5C50} /* 5C */,
  {-1, 0, 0xE9E1} /* 5D */,
  {-1, 0, 0x5C60} /* 5E */,
  {-1, 0, 0x5C5C} /* 5F */,
  {-1, 0, 0x5C62} /* 60 */,
  {-1, 0, 0xE936} /* 61 */,
  {-1, 0, 0x5C65} /* 62 */,
  {-1, 0, 0x5C6C} /* 63 */,
  {-1, 0, 0x5C6F} /* 64 */,
  {-1, 0, 0x5C71} /* 65 */,
  {-1, 0, 0x5C79} /* 66 */,
  {-1, 0, 0x5C90} /* 67 */,
  {-1, 0, 0x5C8C} /* 68 */,
  {-1, 0, 0x5C91} /* 69 */,
  {-1, 0, 0x5C94} /* 6A */,
  {-1, 0, 0x5CB7} /* 6B */,
  {-1, 0, 0x5CB8} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0x5CA1} /* 6E */,
  {-1, 0, 0x5CAB} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x5CB1} /* 71 */,
  {-1, 0, 0x5CD9} /* 72 */,
  {-1, 0, 0x5D01} /* 73 */,
  {-1, 0, 0x5CFD} /* 74 */,
  {-1, 0, 0x5CED} /* 75 */,
  {-1, 0, 0x5CFB} /* 76 */,
  {-1, 0, 0x5CE8} /* 77 */,
  {-1, 0, 0x5CF0} /* 78 */,
  {-1, 0, 0x5CF6} /* 79 */,
  {-1, 0, 0x5CEA} /* 7A */,
  {-1, 0, 0x5D07} /* 7B */,
  {-1, 0, 0x5D06} /* 7C */,
  {-1, 0, 0x5D1B} /* 7D */,
  {-1, 0, 0x5D16} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page14 = {
  0, marc8_9page14_dir
};
/* PAGE 13 */
struct yaz_iconv_trie_dir marc8_9page13_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5A46} /* 21 */,
  {-1, 0, 0x5A49} /* 22 */,
  {-1, 0, 0x5A6A} /* 23 */,
  {-1, 0, 0x5A36} /* 24 */,
  {-1, 0, 0x5A4A} /* 25 */,
  {-1, 0, 0x5A40} /* 26 */,
  {-1, 0, 0x5A66} /* 27 */,
  {-1, 0, 0x5A41} /* 28 */,
  {-1, 0, 0x5A3C} /* 29 */,
  {-1, 0, 0x5A62} /* 2A */,
  {-1, 0, 0x5A5A} /* 2B */,
  {-1, 0, 0x5A77} /* 2C */,
  {-1, 0, 0x5A9A} /* 2D */,
  {-1, 0, 0x5A92} /* 2E */,
  {-1, 0, 0x5A7F} /* 2F */,
  {-1, 0, 0x5ABC} /* 30 */,
  {-1, 0, 0x5A9B} /* 31 */,
  {-1, 0, 0x5ACC} /* 32 */,
  {-1, 0, 0x5AC1} /* 33 */,
  {-1, 0, 0x5AC9} /* 34 */,
  {-1, 0, 0x5ABE} /* 35 */,
  {-1, 0, 0x5ABD} /* 36 */,
  {-1, 0, 0x5AB2} /* 37 */,
  {-1, 0, 0x5AC2} /* 38 */,
  {-1, 0, 0x5AB3} /* 39 */,
  {-1, 0, 0x5AE1} /* 3A */,
  {-1, 0, 0x5AD7} /* 3B */,
  {-1, 0, 0x5AD6} /* 3C */,
  {-1, 0, 0x5AE3} /* 3D */,
  {-1, 0, 0x5AE9} /* 3E */,
  {-1, 0, 0x5AD8} /* 3F */,
  {-1, 0, 0x5AE6} /* 40 */,
  {-1, 0, 0x5AFB} /* 41 */,
  {-1, 0, 0x5B09} /* 42 */,
  {-1, 0, 0x5B0B} /* 43 */,
  {-1, 0, 0x5B0C} /* 44 */,
  {-1, 0, 0x5AF5} /* 45 */,
  {-1, 0, 0x5B34} /* 46 */,
  {-1, 0, 0x5B1D} /* 47 */,
  {-1, 0, 0x5B2A} /* 48 */,
  {-1, 0, 0x5B24} /* 49 */,
  {-1, 0, 0x5B30} /* 4A */,
  {-1, 0, 0x5B38} /* 4B */,
  {-1, 0, 0x5B40} /* 4C */,
  {-1, 0, 0x5B50} /* 4D */,
  {-1, 0, 0x5B51} /* 4E */,
  {-1, 0, 0x5B53} /* 4F */,
  {-1, 0, 0x5B54} /* 50 */,
  {-1, 0, 0x5B55} /* 51 */,
  {-1, 0, 0x5B57} /* 52 */,
  {-1, 0, 0x5B58} /* 53 */,
  {-1, 0, 0x5B5D} /* 54 */,
  {-1, 0, 0x5B5C} /* 55 */,
  {-1, 0, 0},
  {-1, 0, 0x5B5F} /* 57 */,
  {-1, 0, 0x5B63} /* 58 */,
  {-1, 0, 0x5B64} /* 59 */,
  {-1, 0, 0x5B69} /* 5A */,
  {-1, 0, 0x5B6B} /* 5B */,
  {-1, 0, 0x5B70} /* 5C */,
  {-1, 0, 0x5B73} /* 5D */,
  {-1, 0, 0x5B71} /* 5E */,
  {-1, 0, 0x5B75} /* 5F */,
  {-1, 0, 0x5B78} /* 60 */,
  {-1, 0, 0x5B7A} /* 61 */,
  {-1, 0, 0x5B7D} /* 62 */,
  {-1, 0, 0x5B7F} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x5B87} /* 65 */,
  {-1, 0, 0x5B88} /* 66 */,
  {-1, 0, 0x5B89} /* 67 */,
  {-1, 0, 0x5B85} /* 68 */,
  {-1, 0, 0x5B8C} /* 69 */,
  {-1, 0, 0x5B8B} /* 6A */,
  {-1, 0, 0x5B8F} /* 6B */,
  {-1, 0, 0x5B97} /* 6C */,
  {-1, 0, 0x5B9A} /* 6D */,
  {-1, 0, 0x5B9C} /* 6E */,
  {-1, 0, 0x5B98} /* 6F */,
  {-1, 0, 0x5B99} /* 70 */,
  {-1, 0, 0x5B9B} /* 71 */,
  {-1, 0, 0x5BA5} /* 72 */,
  {-1, 0, 0x5BA3} /* 73 */,
  {-1, 0, 0x5BA6} /* 74 */,
  {-1, 0, 0x5BA4} /* 75 */,
  {-1, 0, 0x5BA2} /* 76 */,
  {-1, 0, 0x5BB0} /* 77 */,
  {-1, 0, 0x5BB8} /* 78 */,
  {-1, 0, 0},
  {-1, 0, 0x5BB5} /* 7A */,
  {-1, 0, 0x5BB4} /* 7B */,
  {-1, 0, 0x5BAE} /* 7C */,
  {-1, 0, 0x5BB9} /* 7D */,
  {-1, 0, 0x5BB3} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page13 = {
  0, marc8_9page13_dir
};
/* PAGE 12 */
struct yaz_iconv_trie_dir marc8_9page12_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5920} /* 21 */,
  {-1, 0, 0x5924} /* 22 */,
  {-1, 0, 0x5925} /* 23 */,
  {-1, 0, 0x5922} /* 24 */,
  {-1, 0, 0x5927} /* 25 */,
  {-1, 0, 0x592A} /* 26 */,
  {-1, 0, 0x592B} /* 27 */,
  {-1, 0, 0x5929} /* 28 */,
  {-1, 0, 0x592D} /* 29 */,
  {-1, 0, 0x592E} /* 2A */,
  {-1, 0, 0x5931} /* 2B */,
  {-1, 0, 0x5937} /* 2C */,
  {-1, 0, 0},
  {-1, 0, 0x593E} /* 2E */,
  {-1, 0, 0x5954} /* 2F */,
  {-1, 0, 0x5949} /* 30 */,
  {-1, 0, 0x5948} /* 31 */,
  {-1, 0, 0x5947} /* 32 */,
  {-1, 0, 0x5944} /* 33 */,
  {-1, 0, 0x5955} /* 34 */,
  {-1, 0, 0x5951} /* 35 */,
  {-1, 0, 0x594E} /* 36 */,
  {-1, 0, 0x594F} /* 37 */,
  {-1, 0, 0x5950} /* 38 */,
  {-1, 0, 0x5957} /* 39 */,
  {-1, 0, 0x5958} /* 3A */,
  {-1, 0, 0x595A} /* 3B */,
  {-1, 0, 0x5960} /* 3C */,
  {-1, 0, 0x5962} /* 3D */,
  {-1, 0, 0x5967} /* 3E */,
  {-1, 0, 0x5969} /* 3F */,
  {-1, 0, 0x596A} /* 40 */,
  {-1, 0, 0x596E} /* 41 */,
  {-1, 0, 0x5973} /* 42 */,
  {-1, 0, 0x5974} /* 43 */,
  {-1, 0, 0x5976} /* 44 */,
  {-1, 0, 0x5984} /* 45 */,
  {-1, 0, 0x5983} /* 46 */,
  {-1, 0, 0x5978} /* 47 */,
  {-1, 0, 0x597D} /* 48 */,
  {-1, 0, 0x5979} /* 49 */,
  {-1, 0, 0x5982} /* 4A */,
  {-1, 0, 0x5981} /* 4B */,
  {-1, 0, 0x59A8} /* 4C */,
  {-1, 0, 0x5992} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0x59A4} /* 4F */,
  {-1, 0, 0x59A3} /* 50 */,
  {-1, 0, 0x5993} /* 51 */,
  {-1, 0, 0x599E} /* 52 */,
  {-1, 0, 0x599D} /* 53 */,
  {-1, 0, 0x5999} /* 54 */,
  {-1, 0, 0x59A5} /* 55 */,
  {-1, 0, 0x598A} /* 56 */,
  {-1, 0, 0x5996} /* 57 */,
  {-1, 0, 0x59BE} /* 58 */,
  {-1, 0, 0x59BB} /* 59 */,
  {-1, 0, 0x59AE} /* 5A */,
  {-1, 0, 0x59D1} /* 5B */,
  {-1, 0, 0x59B9} /* 5C */,
  {-1, 0, 0x59C6} /* 5D */,
  {-1, 0, 0x59D0} /* 5E */,
  {-1, 0, 0x59D7} /* 5F */,
  {-1, 0, 0x59AF} /* 60 */,
  {-1, 0, 0x59D2} /* 61 */,
  {-1, 0, 0x59D3} /* 62 */,
  {-1, 0, 0x59CA} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0x59CB} /* 65 */,
  {-1, 0, 0x59D4} /* 66 */,
  {-1, 0, 0x59E3} /* 67 */,
  {-1, 0, 0},
  {-1, 0, 0x59FF} /* 69 */,
  {-1, 0, 0x59D8} /* 6A */,
  {-1, 0, 0x5A03} /* 6B */,
  {-1, 0, 0x59E8} /* 6C */,
  {-1, 0, 0x59E5} /* 6D */,
  {-1, 0, 0x59EA} /* 6E */,
  {-1, 0, 0x5A01} /* 6F */,
  {-1, 0, 0x59FB} /* 70 */,
  {-1, 0, 0x59E6} /* 71 */,
  {-1, 0, 0x59DA} /* 72 */,
  {-1, 0, 0x5A11} /* 73 */,
  {-1, 0, 0x5A18} /* 74 */,
  {-1, 0, 0x5A23} /* 75 */,
  {-1, 0, 0x5A1C} /* 76 */,
  {-1, 0, 0x5A13} /* 77 */,
  {-1, 0, 0x59EC} /* 78 */,
  {-1, 0, 0x5A20} /* 79 */,
  {-1, 0, 0x5A1F} /* 7A */,
  {-1, 0, 0x5A1B} /* 7B */,
  {-1, 0, 0x5A0C} /* 7C */,
  {-1, 0, 0x5A29} /* 7D */,
  {-1, 0, 0x5A25} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page12 = {
  0, marc8_9page12_dir
};
/* PAGE 11 */
struct yaz_iconv_trie_dir marc8_9page11_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5740} /* 21 */,
  {-1, 0, 0x5747} /* 22 */,
  {-1, 0, 0x574D} /* 23 */,
  {-1, 0, 0x573E} /* 24 */,
  {-1, 0, 0x574E} /* 25 */,
  {-1, 0, 0},
  {-1, 0, 0x5783} /* 27 */,
  {-1, 0, 0x576A} /* 28 */,
  {-1, 0, 0x5769} /* 29 */,
  {-1, 0, 0x5777} /* 2A */,
  {-1, 0, 0x5761} /* 2B */,
  {-1, 0, 0x5764} /* 2C */,
  {-1, 0, 0x5766} /* 2D */,
  {-1, 0, 0x5782} /* 2E */,
  {-1, 0, 0x577C} /* 2F */,
  {-1, 0, 0x57A0} /* 30 */,
  {-1, 0, 0x578B} /* 31 */,
  {-1, 0, 0x57A3} /* 32 */,
  {-1, 0, 0x57AE} /* 33 */,
  {-1, 0, 0x57A2} /* 34 */,
  {-1, 0, 0x57D4} /* 35 */,
  {-1, 0, 0x57C2} /* 36 */,
  {-1, 0, 0x57CE} /* 37 */,
  {-1, 0, 0x57CB} /* 38 */,
  {-1, 0, 0x57C3} /* 39 */,
  {-1, 0, 0x57F9} /* 3A */,
  {-1, 0, 0x57F7} /* 3B */,
  {-1, 0, 0x57FA} /* 3C */,
  {-1, 0, 0x57DF} /* 3D */,
  {-1, 0, 0x580A} /* 3E */,
  {-1, 0, 0x5805} /* 3F */,
  {-1, 0, 0x5802} /* 40 */,
  {-1, 0, 0x5806} /* 41 */,
  {-1, 0, 0x57E4} /* 42 */,
  {-1, 0, 0x57E0} /* 43 */,
  {-1, 0, 0x5831} /* 44 */,
  {-1, 0, 0x582F} /* 45 */,
  {-1, 0, 0x5835} /* 46 */,
  {-1, 0, 0x582A} /* 47 */,
  {-1, 0, 0x5830} /* 48 */,
  {-1, 0, 0x5824} /* 49 */,
  {-1, 0, 0x5834} /* 4A */,
  {-1, 0, 0x5821} /* 4B */,
  {-1, 0, 0x585E} /* 4C */,
  {-1, 0, 0x5857} /* 4D */,
  {-1, 0, 0x5858} /* 4E */,
  {-1, 0, 0x5851} /* 4F */,
  {-1, 0, 0x586B} /* 50 */,
  {-1, 0, 0x584C} /* 51 */,
  {-1, 0, 0x585A} /* 52 */,
  {-1, 0, 0x586D} /* 53 */,
  {-1, 0, 0x5854} /* 54 */,
  {-1, 0, 0x5862} /* 55 */,
  {-1, 0, 0x584A} /* 56 */,
  {-1, 0, 0x5883} /* 57 */,
  {-1, 0, 0x587E} /* 58 */,
  {-1, 0, 0x5875} /* 59 */,
  {-1, 0, 0x588A} /* 5A */,
  {-1, 0, 0x5879} /* 5B */,
  {-1, 0, 0x5885} /* 5C */,
  {-1, 0, 0x5893} /* 5D */,
  {-1, 0, 0x589E} /* 5E */,
  {-1, 0, 0x5880} /* 5F */,
  {-1, 0, 0x58B3} /* 60 */,
  {-1, 0, 0x589C} /* 61 */,
  {-1, 0, 0x58AE} /* 62 */,
  {-1, 0, 0x589F} /* 63 */,
  {-1, 0, 0xE935} /* 64 */,
  {-1, 0, 0x58C5} /* 65 */,
  {-1, 0, 0x58C1} /* 66 */,
  {-1, 0, 0x58BE} /* 67 */,
  {-1, 0, 0x58D5} /* 68 */,
  {-1, 0, 0x58D3} /* 69 */,
  {-1, 0, 0x58D1} /* 6A */,
  {-1, 0, 0x58D9} /* 6B */,
  {-1, 0, 0x58D8} /* 6C */,
  {-1, 0, 0x58DF} /* 6D */,
  {-1, 0, 0x58DE} /* 6E */,
  {-1, 0, 0x58E2} /* 6F */,
  {-1, 0, 0x58E4} /* 70 */,
  {-1, 0, 0x58E9} /* 71 */,
  {-1, 0, 0x58EB} /* 72 */,
  {-1, 0, 0x58EC} /* 73 */,
  {-1, 0, 0x58EF} /* 74 */,
  {-1, 0, 0},
  {-1, 0, 0x58FA} /* 76 */,
  {-1, 0, 0x58FD} /* 77 */,
  {-1, 0, 0x590F} /* 78 */,
  {-1, 0, 0x5914} /* 79 */,
  {-1, 0, 0x5915} /* 7A */,
  {-1, 0, 0x5916} /* 7B */,
  {-1, 0, 0x5919} /* 7C */,
  {-1, 0, 0x591A} /* 7D */,
  {-1, 0, 0x591C} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page11 = {
  0, marc8_9page11_dir
};
/* PAGE 10 */
struct yaz_iconv_trie_dir marc8_9page10_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x55DA} /* 21 */,
  {-1, 0, 0x55C6} /* 22 */,
  {-1, 0, 0x55E1} /* 23 */,
  {-1, 0, 0x5600} /* 24 */,
  {-1, 0, 0x561B} /* 25 */,
  {-1, 0, 0x55FE} /* 26 */,
  {-1, 0, 0x5616} /* 27 */,
  {-1, 0, 0x55F7} /* 28 */,
  {-1, 0, 0x5608} /* 29 */,
  {-1, 0, 0x561F} /* 2A */,
  {-1, 0, 0x55FD} /* 2B */,
  {-1, 0, 0xE932} /* 2C */,
  {-1, 0, 0x5609} /* 2D */,
  {-1, 0, 0x5614} /* 2E */,
  {-1, 0, 0x560E} /* 2F */,
  {-1, 0, 0x5617} /* 30 */,
  {-1, 0, 0x560D} /* 31 */,
  {-1, 0, 0x562E} /* 32 */,
  {-1, 0, 0x562F} /* 33 */,
  {-1, 0, 0x564E} /* 34 */,
  {-1, 0, 0x5636} /* 35 */,
  {-1, 0, 0x5632} /* 36 */,
  {-1, 0, 0x563B} /* 37 */,
  {-1, 0, 0x5639} /* 38 */,
  {-1, 0, 0x5657} /* 39 */,
  {-1, 0, 0},
  {-1, 0, 0x5653} /* 3B */,
  {-1, 0, 0x563F} /* 3C */,
  {-1, 0, 0x5634} /* 3D */,
  {-1, 0, 0x5637} /* 3E */,
  {-1, 0, 0x5659} /* 3F */,
  {-1, 0, 0x5630} /* 40 */,
  {-1, 0, 0x566B} /* 41 */,
  {-1, 0, 0x5664} /* 42 */,
  {-1, 0, 0x5669} /* 43 */,
  {-1, 0, 0x5678} /* 44 */,
  {-1, 0, 0x5674} /* 45 */,
  {-1, 0, 0x5679} /* 46 */,
  {-1, 0, 0x5665} /* 47 */,
  {-1, 0, 0x566A} /* 48 */,
  {-1, 0, 0x5668} /* 49 */,
  {-1, 0, 0x5671} /* 4A */,
  {-1, 0, 0x566F} /* 4B */,
  {-1, 0, 0xE933} /* 4C */,
  {-1, 0, 0x566C} /* 4D */,
  {-1, 0, 0x5680} /* 4E */,
  {-1, 0, 0x568E} /* 4F */,
  {-1, 0, 0x5685} /* 50 */,
  {-1, 0, 0x5687} /* 51 */,
  {-1, 0, 0x5690} /* 52 */,
  {-1, 0, 0x568F} /* 53 */,
  {-1, 0, 0x5695} /* 54 */,
  {-1, 0, 0xE934} /* 55 */,
  {-1, 0, 0x56A8} /* 56 */,
  {-1, 0, 0x56B0} /* 57 */,
  {-1, 0, 0x56A5} /* 58 */,
  {-1, 0, 0x56B7} /* 59 */,
  {-1, 0, 0x56B4} /* 5A */,
  {-1, 0, 0x56B6} /* 5B */,
  {-1, 0, 0x56C0} /* 5C */,
  {-1, 0, 0x56C1} /* 5D */,
  {-1, 0, 0x56C2} /* 5E */,
  {-1, 0, 0x56BC} /* 5F */,
  {-1, 0, 0x56CA} /* 60 */,
  {-1, 0, 0x56C9} /* 61 */,
  {-1, 0, 0x56C8} /* 62 */,
  {-1, 0, 0},
  {-1, 0, 0x56D1} /* 64 */,
  {-1, 0, 0x56DB} /* 65 */,
  {-1, 0, 0x56DA} /* 66 */,
  {-1, 0, 0x56E0} /* 67 */,
  {-1, 0, 0x56DE} /* 68 */,
  {-1, 0, 0x56E4} /* 69 */,
  {-1, 0, 0},
  {-1, 0, 0x56F1} /* 6B */,
  {-1, 0, 0x56FA} /* 6C */,
  {-1, 0, 0x5703} /* 6D */,
  {-1, 0, 0x5708} /* 6E */,
  {-1, 0, 0x570B} /* 6F */,
  {-1, 0, 0x570D} /* 70 */,
  {-1, 0, 0x5712} /* 71 */,
  {-1, 0, 0x5713} /* 72 */,
  {-1, 0, 0x5718} /* 73 */,
  {-1, 0, 0x5716} /* 74 */,
  {-1, 0, 0x571F} /* 75 */,
  {-1, 0, 0},
  {-1, 0, 0x572D} /* 77 */,
  {-1, 0, 0x572F} /* 78 */,
  {-1, 0, 0x5730} /* 79 */,
  {-1, 0, 0x5728} /* 7A */,
  {-1, 0, 0x5733} /* 7B */,
  {-1, 0, 0x5751} /* 7C */,
  {-1, 0, 0x574A} /* 7D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page10 = {
  0, marc8_9page10_dir
};
/* PAGE 9 */
struct yaz_iconv_trie_dir marc8_9page9_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x54AA} /* 21 */,
  {-1, 0, 0x54A8} /* 22 */,
  {-1, 0, 0x54AC} /* 23 */,
  {-1, 0, 0x54C0} /* 24 */,
  {-1, 0, 0x54B3} /* 25 */,
  {-1, 0, 0x54A6} /* 26 */,
  {-1, 0, 0x54AB} /* 27 */,
  {-1, 0, 0x54C7} /* 28 */,
  {-1, 0, 0x54C9} /* 29 */,
  {-1, 0, 0x54C4} /* 2A */,
  {-1, 0, 0x54C2} /* 2B */,
  {-1, 0, 0},
  {-1, 0, 0x54C1} /* 2D */,
  {-1, 0, 0},
  {-1, 0, 0x54CE} /* 2F */,
  {-1, 0, 0x54B1} /* 30 */,
  {-1, 0, 0x54BB} /* 31 */,
  {-1, 0, 0x54AF} /* 32 */,
  {-1, 0, 0x54C8} /* 33 */,
  {-1, 0, 0x5501} /* 34 */,
  {-1, 0, 0x54FC} /* 35 */,
  {-1, 0, 0x5510} /* 36 */,
  {-1, 0, 0x54EA} /* 37 */,
  {-1, 0, 0x5514} /* 38 */,
  {-1, 0, 0x54FA} /* 39 */,
  {-1, 0, 0x54E5} /* 3A */,
  {-1, 0, 0x54EE} /* 3B */,
  {-1, 0, 0x54F2} /* 3C */,
  {-1, 0, 0x54E8} /* 3D */,
  {-1, 0, 0x54E1} /* 3E */,
  {-1, 0, 0x54E9} /* 3F */,
  {-1, 0, 0x54ED} /* 40 */,
  {-1, 0, 0x5506} /* 41 */,
  {-1, 0, 0x5509} /* 42 */,
  {-1, 0, 0x54E6} /* 43 */,
  {-1, 0, 0x5556} /* 44 */,
  {-1, 0, 0x5533} /* 45 */,
  {-1, 0, 0x5546} /* 46 */,
  {-1, 0, 0x5537} /* 47 */,
  {-1, 0, 0x554F} /* 48 */,
  {-1, 0, 0x555E} /* 49 */,
  {-1, 0, 0x5566} /* 4A */,
  {-1, 0, 0x556A} /* 4B */,
  {-1, 0, 0x554A} /* 4C */,
  {-1, 0, 0x5544} /* 4D */,
  {-1, 0, 0x555C} /* 4E */,
  {-1, 0, 0x5531} /* 4F */,
  {-1, 0, 0x5543} /* 50 */,
  {-1, 0, 0x552C} /* 51 */,
  {-1, 0, 0x5561} /* 52 */,
  {-1, 0, 0x553E} /* 53 */,
  {-1, 0, 0x5563} /* 54 */,
  {-1, 0, 0x5555} /* 55 */,
  {-1, 0, 0x552F} /* 56 */,
  {-1, 0, 0x552E} /* 57 */,
  {-1, 0, 0x5564} /* 58 */,
  {-1, 0, 0x5538} /* 59 */,
  {-1, 0, 0x55A7} /* 5A */,
  {-1, 0, 0x5580} /* 5B */,
  {-1, 0, 0x557B} /* 5C */,
  {-1, 0, 0x557C} /* 5D */,
  {-1, 0, 0x5527} /* 5E */,
  {-1, 0, 0x5594} /* 5F */,
  {-1, 0, 0x5587} /* 60 */,
  {-1, 0, 0x559C} /* 61 */,
  {-1, 0, 0x558B} /* 62 */,
  {-1, 0, 0x55AA} /* 63 */,
  {-1, 0, 0x55B3} /* 64 */,
  {-1, 0, 0x558A} /* 65 */,
  {-1, 0, 0x5583} /* 66 */,
  {-1, 0, 0x55B1} /* 67 */,
  {-1, 0, 0x55AE} /* 68 */,
  {-1, 0, 0x5582} /* 69 */,
  {-1, 0, 0x559F} /* 6A */,
  {-1, 0, 0x559D} /* 6B */,
  {-1, 0, 0x5598} /* 6C */,
  {-1, 0, 0x559A} /* 6D */,
  {-1, 0, 0x557E} /* 6E */,
  {-1, 0, 0x55AC} /* 6F */,
  {-1, 0, 0x5589} /* 70 */,
  {-1, 0, 0x55B2} /* 71 */,
  {-1, 0, 0x55BB} /* 72 */,
  {-1, 0, 0x55E8} /* 73 */,
  {-1, 0, 0x55DF} /* 74 */,
  {-1, 0, 0x55D1} /* 75 */,
  {-1, 0, 0x55DC} /* 76 */,
  {-1, 0, 0x55E6} /* 77 */,
  {-1, 0, 0x55C7} /* 78 */,
  {-1, 0, 0x55D3} /* 79 */,
  {-1, 0, 0x55CE} /* 7A */,
  {-1, 0, 0x55E3} /* 7B */,
  {-1, 0, 0x55EF} /* 7C */,
  {-1, 0, 0x55E4} /* 7D */,
  {-1, 0, 0x55C5} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page9 = {
  0, marc8_9page9_dir
};
/* PAGE 8 */
struct yaz_iconv_trie_dir marc8_9page8_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x53C9} /* 21 */,
  {-1, 0, 0x53CB} /* 22 */,
  {-1, 0, 0x53CA} /* 23 */,
  {-1, 0, 0x53CD} /* 24 */,
  {-1, 0, 0x53D6} /* 25 */,
  {-1, 0, 0x53D4} /* 26 */,
  {-1, 0, 0x53D7} /* 27 */,
  {-1, 0, 0x53DB} /* 28 */,
  {-1, 0, 0x53DF} /* 29 */,
  {-1, 0, 0x66FC} /* 2A */,
  {-1, 0, 0x53E2} /* 2B */,
  {-1, 0, 0x53E3} /* 2C */,
  {-1, 0, 0x53F8} /* 2D */,
  {-1, 0, 0x53E4} /* 2E */,
  {-1, 0, 0x53EE} /* 2F */,
  {-1, 0, 0x53EF} /* 30 */,
  {-1, 0, 0x53E9} /* 31 */,
  {-1, 0, 0x53F3} /* 32 */,
  {-1, 0, 0x53FC} /* 33 */,
  {-1, 0, 0x53E8} /* 34 */,
  {-1, 0, 0x53E6} /* 35 */,
  {-1, 0, 0x53EC} /* 36 */,
  {-1, 0, 0x53EB} /* 37 */,
  {-1, 0, 0xE900} /* 38 */,
  {-1, 0, 0x53E5} /* 39 */,
  {-1, 0, 0x53F1} /* 3A */,
  {-1, 0, 0x53ED} /* 3B */,
  {-1, 0, 0x53EA} /* 3C */,
  {-1, 0, 0x53F2} /* 3D */,
  {-1, 0, 0},
  {-1, 0, 0x540B} /* 3F */,
  {-1, 0, 0x5409} /* 40 */,
  {-1, 0, 0x5410} /* 41 */,
  {-1, 0, 0x540F} /* 42 */,
  {-1, 0, 0x540C} /* 43 */,
  {-1, 0, 0x540A} /* 44 */,
  {-1, 0, 0x540D} /* 45 */,
  {-1, 0, 0x5404} /* 46 */,
  {-1, 0, 0x5403} /* 47 */,
  {-1, 0, 0x5412} /* 48 */,
  {-1, 0, 0},
  {-1, 0, 0xE9E0} /* 4A */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x542D} /* 4D */,
  {-1, 0, 0x541D} /* 4E */,
  {-1, 0, 0x541E} /* 4F */,
  {-1, 0, 0x541B} /* 50 */,
  {-1, 0, 0x544E} /* 51 */,
  {-1, 0, 0x543E} /* 52 */,
  {-1, 0, 0x5427} /* 53 */,
  {-1, 0, 0x5440} /* 54 */,
  {-1, 0, 0x5431} /* 55 */,
  {-1, 0, 0x5446} /* 56 */,
  {-1, 0, 0x543C} /* 57 */,
  {-1, 0, 0x5443} /* 58 */,
  {-1, 0, 0x5426} /* 59 */,
  {-1, 0, 0x5420} /* 5A */,
  {-1, 0, 0x5436} /* 5B */,
  {-1, 0, 0x5433} /* 5C */,
  {-1, 0, 0x5435} /* 5D */,
  {-1, 0, 0x542E} /* 5E */,
  {-1, 0, 0x544A} /* 5F */,
  {-1, 0, 0x5448} /* 60 */,
  {-1, 0, 0x543B} /* 61 */,
  {-1, 0, 0x5438} /* 62 */,
  {-1, 0, 0x5439} /* 63 */,
  {-1, 0, 0x5442} /* 64 */,
  {-1, 0, 0x542B} /* 65 */,
  {-1, 0, 0x541F} /* 66 */,
  {-1, 0, 0x5429} /* 67 */,
  {-1, 0, 0x5473} /* 68 */,
  {-1, 0, 0x5462} /* 69 */,
  {-1, 0, 0x5475} /* 6A */,
  {-1, 0, 0x5495} /* 6B */,
  {-1, 0, 0x5478} /* 6C */,
  {-1, 0, 0x5496} /* 6D */,
  {-1, 0, 0x5477} /* 6E */,
  {-1, 0, 0x547B} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x5492} /* 71 */,
  {-1, 0, 0x5484} /* 72 */,
  {-1, 0, 0x547C} /* 73 */,
  {-1, 0, 0x5468} /* 74 */,
  {-1, 0, 0x5486} /* 75 */,
  {-1, 0, 0x548B} /* 76 */,
  {-1, 0, 0x548C} /* 77 */,
  {-1, 0, 0x5490} /* 78 */,
  {-1, 0, 0x547D} /* 79 */,
  {-1, 0, 0x5476} /* 7A */,
  {-1, 0, 0x5471} /* 7B */,
  {-1, 0, 0x549A} /* 7C */,
  {-1, 0, 0x548E} /* 7D */,
  {-1, 0, 0x54A9} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page8 = {
  0, marc8_9page8_dir
};
/* PAGE 7 */
struct yaz_iconv_trie_dir marc8_9page7_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x528D} /* 21 */,
  {-1, 0, 0x5289} /* 22 */,
  {-1, 0, 0x5291} /* 23 */,
  {-1, 0, 0x529B} /* 24 */,
  {-1, 0, 0x529F} /* 25 */,
  {-1, 0, 0x52A0} /* 26 */,
  {-1, 0, 0x52A3} /* 27 */,
  {-1, 0, 0x52AB} /* 28 */,
  {-1, 0, 0x52A9} /* 29 */,
  {-1, 0, 0x52AC} /* 2A */,
  {-1, 0, 0x52AA} /* 2B */,
  {-1, 0, 0x52BE} /* 2C */,
  {-1, 0, 0x52C7} /* 2D */,
  {-1, 0, 0x52C3} /* 2E */,
  {-1, 0, 0x52C1} /* 2F */,
  {-1, 0, 0x52C9} /* 30 */,
  {-1, 0, 0x52D8} /* 31 */,
  {-1, 0, 0x52D2} /* 32 */,
  {-1, 0, 0x52D9} /* 33 */,
  {-1, 0, 0x52D5} /* 34 */,
  {-1, 0, 0x52DE} /* 35 */,
  {-1, 0, 0x52DB} /* 36 */,
  {-1, 0, 0x52DD} /* 37 */,
  {-1, 0, 0x52E2} /* 38 */,
  {-1, 0, 0x52E4} /* 39 */,
  {-1, 0, 0x52DF} /* 3A */,
  {-1, 0, 0},
  {-1, 0, 0x52F5} /* 3C */,
  {-1, 0, 0x52F8} /* 3D */,
  {-1, 0, 0x52FB} /* 3E */,
  {-1, 0, 0},
  {-1, 0, 0x52FF} /* 40 */,
  {-1, 0, 0x5305} /* 41 */,
  {-1, 0, 0x5306} /* 42 */,
  {-1, 0, 0x5308} /* 43 */,
  {-1, 0, 0x530D} /* 44 */,
  {-1, 0, 0x5310} /* 45 */,
  {-1, 0, 0x530F} /* 46 */,
  {-1, 0, 0x5315} /* 47 */,
  {-1, 0, 0x5316} /* 48 */,
  {-1, 0, 0x5317} /* 49 */,
  {-1, 0, 0x5319} /* 4A */,
  {-1, 0, 0x53F5} /* 4B */,
  {-1, 0, 0x531D} /* 4C */,
  {-1, 0, 0x5321} /* 4D */,
  {-1, 0, 0x5320} /* 4E */,
  {-1, 0, 0x5323} /* 4F */,
  {-1, 0, 0x532A} /* 50 */,
  {-1, 0, 0x532F} /* 51 */,
  {-1, 0, 0x5331} /* 52 */,
  {-1, 0, 0x5339} /* 53 */,
  {-1, 0, 0x533E} /* 54 */,
  {-1, 0, 0x5340} /* 55 */,
  {-1, 0, 0x533F} /* 56 */,
  {-1, 0, 0x5341} /* 57 */,
  {-1, 0, 0x5343} /* 58 */,
  {-1, 0, 0x5345} /* 59 */,
  {-1, 0, 0x5348} /* 5A */,
  {-1, 0, 0x5347} /* 5B */,
  {-1, 0, 0x534A} /* 5C */,
  {-1, 0, 0xE931} /* 5D */,
  {-1, 0, 0},
  {-1, 0, 0x5352} /* 5F */,
  {-1, 0, 0x5354} /* 60 */,
  {-1, 0, 0x5353} /* 61 */,
  {-1, 0, 0x5351} /* 62 */,
  {-1, 0, 0x5357} /* 63 */,
  {-1, 0, 0x535A} /* 64 */,
  {-1, 0, 0},
  {-1, 0, 0x535E} /* 66 */,
  {-1, 0, 0x5361} /* 67 */,
  {-1, 0, 0},
  {-1, 0, 0x5366} /* 69 */,
  {-1, 0, 0x536F} /* 6A */,
  {-1, 0, 0x536E} /* 6B */,
  {-1, 0, 0x5370} /* 6C */,
  {-1, 0, 0x5371} /* 6D */,
  {-1, 0, 0x537D} /* 6E */,
  {-1, 0, 0x5375} /* 6F */,
  {-1, 0, 0},
  {-1, 0, 0x5378} /* 71 */,
  {-1, 0, 0},
  {-1, 0, 0x537B} /* 73 */,
  {-1, 0, 0x537F} /* 74 */,
  {-1, 0, 0x5384} /* 75 */,
  {-1, 0, 0x539A} /* 76 */,
  {-1, 0, 0x539D} /* 77 */,
  {-1, 0, 0x539F} /* 78 */,
  {-1, 0, 0x53A5} /* 79 */,
  {-1, 0, 0x53AD} /* 7A */,
  {-1, 0, 0x53B2} /* 7B */,
  {-1, 0, 0x53BB} /* 7C */,
  {-1, 0, 0x53C3} /* 7D */,
  {-1, 0, 0x53C8} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page7 = {
  0, marc8_9page7_dir
};
/* PAGE 6 */
struct yaz_iconv_trie_dir marc8_9page6_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5167} /* 21 */,
  {-1, 0, 0x5168} /* 22 */,
  {-1, 0, 0x5169} /* 23 */,
  {-1, 0, 0x516B} /* 24 */,
  {-1, 0, 0x516D} /* 25 */,
  {-1, 0, 0x516E} /* 26 */,
  {-1, 0, 0x516C} /* 27 */,
  {-1, 0, 0x5171} /* 28 */,
  {-1, 0, 0x5175} /* 29 */,
  {-1, 0, 0x5176} /* 2A */,
  {-1, 0, 0x5177} /* 2B */,
  {-1, 0, 0x5178} /* 2C */,
  {-1, 0, 0x517C} /* 2D */,
  {-1, 0, 0x5180} /* 2E */,
  {-1, 0, 0x5189} /* 2F */,
  {-1, 0, 0x518C} /* 30 */,
  {-1, 0, 0x518D} /* 31 */,
  {-1, 0, 0x5192} /* 32 */,
  {-1, 0, 0x5191} /* 33 */,
  {-1, 0, 0x5195} /* 34 */,
  {-1, 0, 0x6700} /* 35 */,
  {-1, 0, 0x5197} /* 36 */,
  {-1, 0, 0x51A0} /* 37 */,
  {-1, 0, 0},
  {-1, 0, 0x51A5} /* 39 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x51B0} /* 3C */,
  {-1, 0, 0x51B6} /* 3D */,
  {-1, 0, 0x51B7} /* 3E */,
  {-1, 0, 0},
  {-1, 0, 0x51CD} /* 40 */,
  {-1, 0, 0x51CC} /* 41 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x51DC} /* 44 */,
  {-1, 0, 0x51DD} /* 45 */,
  {-1, 0, 0},
  {-1, 0, 0x51F0} /* 47 */,
  {-1, 0, 0x51F1} /* 48 */,
  {-1, 0, 0x51F3} /* 49 */,
  {-1, 0, 0},
  {-1, 0, 0x51FA} /* 4B */,
  {-1, 0, 0x51F9} /* 4C */,
  {-1, 0, 0x51F8} /* 4D */,
  {-1, 0, 0x51FD} /* 4E */,
  {-1, 0, 0x5200} /* 4F */,
  {-1, 0, 0x5201} /* 50 */,
  {-1, 0, 0x5203} /* 51 */,
  {-1, 0, 0x5207} /* 52 */,
  {-1, 0, 0x5206} /* 53 */,
  {-1, 0, 0x5208} /* 54 */,
  {-1, 0, 0x520A} /* 55 */,
  {-1, 0, 0x5211} /* 56 */,
  {-1, 0, 0x5217} /* 57 */,
  {-1, 0, 0},
  {-1, 0, 0x520E} /* 59 */,
  {-1, 0, 0x5224} /* 5A */,
  {-1, 0, 0x5225} /* 5B */,
  {-1, 0, 0x5220} /* 5C */,
  {-1, 0, 0x5228} /* 5D */,
  {-1, 0, 0x5229} /* 5E */,
  {-1, 0, 0x5238} /* 5F */,
  {-1, 0, 0x523B} /* 60 */,
  {-1, 0, 0x5237} /* 61 */,
  {-1, 0, 0x5230} /* 62 */,
  {-1, 0, 0x523A} /* 63 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5241} /* 66 */,
  {-1, 0, 0x5239} /* 67 */,
  {-1, 0, 0x5243} /* 68 */,
  {-1, 0, 0x524D} /* 69 */,
  {-1, 0, 0x524C} /* 6A */,
  {-1, 0, 0x524B} /* 6B */,
  {-1, 0, 0x524A} /* 6C */,
  {-1, 0, 0x5247} /* 6D */,
  {-1, 0, 0x525C} /* 6E */,
  {-1, 0, 0x5256} /* 6F */,
  {-1, 0, 0x525B} /* 70 */,
  {-1, 0, 0x5254} /* 71 */,
  {-1, 0, 0x525D} /* 72 */,
  {-1, 0, 0x526A} /* 73 */,
  {-1, 0, 0x526F} /* 74 */,
  {-1, 0, 0x5272} /* 75 */,
  {-1, 0, 0x5274} /* 76 */,
  {-1, 0, 0x5269} /* 77 */,
  {-1, 0, 0x5275} /* 78 */,
  {-1, 0, 0},
  {-1, 0, 0x527D} /* 7A */,
  {-1, 0, 0x527F} /* 7B */,
  {-1, 0, 0x5283} /* 7C */,
  {-1, 0, 0x5288} /* 7D */,
  {-1, 0, 0x5287} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page6 = {
  0, marc8_9page6_dir
};
/* PAGE 5 */
struct yaz_iconv_trie_dir marc8_9page5_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x5018} /* 21 */,
  {-1, 0, 0x4FF1} /* 22 */,
  {-1, 0, 0x5021} /* 23 */,
  {-1, 0, 0x500B} /* 24 */,
  {-1, 0, 0x5019} /* 25 */,
  {-1, 0, 0x5000} /* 26 */,
  {-1, 0, 0x4FEE} /* 27 */,
  {-1, 0, 0x4FF3} /* 28 */,
  {-1, 0, 0x502D} /* 29 */,
  {-1, 0, 0x5003} /* 2A */,
  {-1, 0, 0x4FFE} /* 2B */,
  {-1, 0, 0x502A} /* 2C */,
  {-1, 0, 0x502B} /* 2D */,
  {-1, 0, 0x505C} /* 2E */,
  {-1, 0, 0x504F} /* 2F */,
  {-1, 0, 0x5065} /* 30 */,
  {-1, 0, 0x5047} /* 31 */,
  {-1, 0, 0x505A} /* 32 */,
  {-1, 0, 0x5049} /* 33 */,
  {-1, 0, 0x5043} /* 34 */,
  {-1, 0, 0x5074} /* 35 */,
  {-1, 0, 0x5076} /* 36 */,
  {-1, 0, 0x504E} /* 37 */,
  {-1, 0, 0x5075} /* 38 */,
  {-1, 0, 0x504C} /* 39 */,
  {-1, 0, 0x5055} /* 3A */,
  {-1, 0, 0x500F} /* 3B */,
  {-1, 0, 0x5077} /* 3C */,
  {-1, 0, 0x508D} /* 3D */,
  {-1, 0, 0x50A2} /* 3E */,
  {-1, 0, 0x5085} /* 3F */,
  {-1, 0, 0x5099} /* 40 */,
  {-1, 0, 0x5091} /* 41 */,
  {-1, 0, 0x5080} /* 42 */,
  {-1, 0, 0x5096} /* 43 */,
  {-1, 0, 0x5098} /* 44 */,
  {-1, 0, 0x50AD} /* 45 */,
  {-1, 0, 0x50B3} /* 46 */,
  {-1, 0, 0x50B5} /* 47 */,
  {-1, 0, 0x50B2} /* 48 */,
  {-1, 0, 0x50C5} /* 49 */,
  {-1, 0, 0x50BE} /* 4A */,
  {-1, 0, 0x50AC} /* 4B */,
  {-1, 0, 0x50B7} /* 4C */,
  {-1, 0, 0x50AF} /* 4D */,
  {-1, 0, 0x50E7} /* 4E */,
  {-1, 0, 0x50EE} /* 4F */,
  {-1, 0, 0x50F1} /* 50 */,
  {-1, 0, 0x50E5} /* 51 */,
  {-1, 0, 0x50D6} /* 52 */,
  {-1, 0, 0x50ED} /* 53 */,
  {-1, 0, 0x50DA} /* 54 */,
  {-1, 0, 0x50D5} /* 55 */,
  {-1, 0, 0x507D} /* 56 */,
  {-1, 0, 0x50CF} /* 57 */,
  {-1, 0, 0x50D1} /* 58 */,
  {-1, 0, 0x5100} /* 59 */,
  {-1, 0, 0x5104} /* 5A */,
  {-1, 0, 0x50FB} /* 5B */,
  {-1, 0, 0x50F5} /* 5C */,
  {-1, 0, 0x50F9} /* 5D */,
  {-1, 0, 0x5102} /* 5E */,
  {-1, 0, 0x510D} /* 5F */,
  {-1, 0, 0x5108} /* 60 */,
  {-1, 0, 0x5109} /* 61 */,
  {-1, 0, 0x5110} /* 62 */,
  {-1, 0, 0x5118} /* 63 */,
  {-1, 0, 0x5112} /* 64 */,
  {-1, 0, 0x5114} /* 65 */,
  {-1, 0, 0x512A} /* 66 */,
  {-1, 0, 0x511F} /* 67 */,
  {-1, 0, 0x5121} /* 68 */,
  {-1, 0, 0x5132} /* 69 */,
  {-1, 0, 0x5137} /* 6A */,
  {-1, 0, 0x513C} /* 6B */,
  {-1, 0, 0x5140} /* 6C */,
  {-1, 0, 0x5143} /* 6D */,
  {-1, 0, 0x5141} /* 6E */,
  {-1, 0, 0x5145} /* 6F */,
  {-1, 0, 0x5144} /* 70 */,
  {-1, 0, 0x5146} /* 71 */,
  {-1, 0, 0x5149} /* 72 */,
  {-1, 0, 0x5147} /* 73 */,
  {-1, 0, 0x5148} /* 74 */,
  {-1, 0, 0x514C} /* 75 */,
  {-1, 0, 0},
  {-1, 0, 0x514D} /* 77 */,
  {-1, 0, 0x5155} /* 78 */,
  {-1, 0, 0x5154} /* 79 */,
  {-1, 0, 0x5152} /* 7A */,
  {-1, 0, 0x5157} /* 7B */,
  {-1, 0, 0x515C} /* 7C */,
  {-1, 0, 0x5162} /* 7D */,
  {-1, 0, 0x5165} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page5 = {
  0, marc8_9page5_dir
};
/* PAGE 4 */
struct yaz_iconv_trie_dir marc8_9page4_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4F11} /* 21 */,
  {-1, 0, 0x4F10} /* 22 */,
  {-1, 0, 0x4F0F} /* 23 */,
  {-1, 0, 0x4EF2} /* 24 */,
  {-1, 0, 0x4F01} /* 25 */,
  {-1, 0, 0x4EF3} /* 26 */,
  {-1, 0, 0x4EF6} /* 27 */,
  {-1, 0, 0x4EF0} /* 28 */,
  {-1, 0, 0},
  {-1, 0, 0x4F4F} /* 2A */,
  {-1, 0, 0x4F4D} /* 2B */,
  {-1, 0, 0x4F34} /* 2C */,
  {-1, 0, 0x4F47} /* 2D */,
  {-1, 0, 0x4F57} /* 2E */,
  {-1, 0, 0x4F3A} /* 2F */,
  {-1, 0, 0x4F5E} /* 30 */,
  {-1, 0, 0},
  {-1, 0, 0x4F5B} /* 32 */,
  {-1, 0, 0x4F55} /* 33 */,
  {-1, 0, 0x4F30} /* 34 */,
  {-1, 0, 0x4F50} /* 35 */,
  {-1, 0, 0x4F51} /* 36 */,
  {-1, 0, 0x4F3D} /* 37 */,
  {-1, 0, 0x4F48} /* 38 */,
  {-1, 0, 0x4F46} /* 39 */,
  {-1, 0, 0x4F38} /* 3A */,
  {-1, 0, 0x4F43} /* 3B */,
  {-1, 0, 0x4F54} /* 3C */,
  {-1, 0, 0x4F3C} /* 3D */,
  {-1, 0, 0x4F63} /* 3E */,
  {-1, 0, 0x4F5C} /* 3F */,
  {-1, 0, 0x4F60} /* 40 */,
  {-1, 0, 0x4F2F} /* 41 */,
  {-1, 0, 0x4F4E} /* 42 */,
  {-1, 0, 0x4F5D} /* 43 */,
  {-1, 0, 0x4F36} /* 44 */,
  {-1, 0, 0x4F9D} /* 45 */,
  {-1, 0, 0x4F6F} /* 46 */,
  {-1, 0, 0x4F75} /* 47 */,
  {-1, 0, 0x4F8D} /* 48 */,
  {-1, 0, 0x4F73} /* 49 */,
  {-1, 0, 0x4F7F} /* 4A */,
  {-1, 0, 0x4F9B} /* 4B */,
  {-1, 0, 0x4F86} /* 4C */,
  {-1, 0, 0x4F6C} /* 4D */,
  {-1, 0, 0x4F8B} /* 4E */,
  {-1, 0, 0x4F96} /* 4F */,
  {-1, 0, 0},
  {-1, 0, 0x4F83} /* 51 */,
  {-1, 0, 0x4F7B} /* 52 */,
  {-1, 0, 0x4F88} /* 53 */,
  {-1, 0, 0x4F69} /* 54 */,
  {-1, 0, 0x4F8F} /* 55 */,
  {-1, 0, 0x4F7E} /* 56 */,
  {-1, 0, 0x4FE1} /* 57 */,
  {-1, 0, 0x4FD1} /* 58 */,
  {-1, 0, 0x4FB5} /* 59 */,
  {-1, 0, 0x4FAF} /* 5A */,
  {-1, 0, 0x4FBF} /* 5B */,
  {-1, 0, 0x4FDE} /* 5C */,
  {-1, 0, 0x4FE0} /* 5D */,
  {-1, 0, 0x4FCF} /* 5E */,
  {-1, 0, 0x4FB6} /* 5F */,
  {-1, 0, 0x4FDA} /* 60 */,
  {-1, 0, 0x4FDD} /* 61 */,
  {-1, 0, 0x4FC3} /* 62 */,
  {-1, 0, 0x4FD8} /* 63 */,
  {-1, 0, 0x4FDF} /* 64 */,
  {-1, 0, 0x4FCA} /* 65 */,
  {-1, 0, 0x4FAE} /* 66 */,
  {-1, 0, 0x4FD0} /* 67 */,
  {-1, 0, 0x4FC4} /* 68 */,
  {-1, 0, 0x4FC2} /* 69 */,
  {-1, 0, 0x4FCE} /* 6A */,
  {-1, 0, 0x4FD7} /* 6B */,
  {-1, 0, 0x5009} /* 6C */,
  {-1, 0, 0},
  {-1, 0, 0x500D} /* 6E */,
  {-1, 0, 0x4FEF} /* 6F */,
  {-1, 0, 0x5026} /* 70 */,
  {-1, 0, 0x500C} /* 71 */,
  {-1, 0, 0x5025} /* 72 */,
  {-1, 0, 0x5011} /* 73 */,
  {-1, 0, 0x4FF8} /* 74 */,
  {-1, 0, 0x5028} /* 75 */,
  {-1, 0, 0x5014} /* 76 */,
  {-1, 0, 0x5016} /* 77 */,
  {-1, 0, 0x5029} /* 78 */,
  {-1, 0, 0x5006} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0x5012} /* 7B */,
  {-1, 0, 0x503C} /* 7C */,
  {-1, 0, 0x501A} /* 7D */,
  {-1, 0, 0x4FFA} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page4 = {
  0, marc8_9page4_dir
};
/* PAGE 3 */
struct yaz_iconv_trie_dir marc8_9page3_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4E00} /* 21 */,
  {-1, 0, 0x4E01} /* 22 */,
  {-1, 0, 0x4E03} /* 23 */,
  {-1, 0, 0x4E09} /* 24 */,
  {-1, 0, 0x4E0B} /* 25 */,
  {-1, 0, 0x4E0A} /* 26 */,
  {-1, 0, 0x4E08} /* 27 */,
  {-1, 0, 0},
  {-1, 0, 0x4E10} /* 29 */,
  {-1, 0, 0x4E0D} /* 2A */,
  {-1, 0, 0x4E14} /* 2B */,
  {-1, 0, 0x4E19} /* 2C */,
  {-1, 0, 0x4E16} /* 2D */,
  {-1, 0, 0x4E15} /* 2E */,
  {-1, 0, 0x4E18} /* 2F */,
  {-1, 0, 0x4E22} /* 30 */,
  {-1, 0, 0x4E1E} /* 31 */,
  {-1, 0, 0x4E26} /* 32 */,
  {-1, 0, 0},
  {-1, 0, 0x4E2D} /* 34 */,
  {-1, 0, 0x4E32} /* 35 */,
  {-1, 0, 0x51E1} /* 36 */,
  {-1, 0, 0x4E38} /* 37 */,
  {-1, 0, 0x4E39} /* 38 */,
  {-1, 0, 0x4E3B} /* 39 */,
  {-1, 0, 0x4E43} /* 3A */,
  {-1, 0, 0x4E45} /* 3B */,
  {-1, 0, 0},
  {-1, 0, 0x4E4B} /* 3D */,
  {-1, 0, 0x5C39} /* 3E */,
  {-1, 0, 0x4E4F} /* 3F */,
  {-1, 0, 0x4E4E} /* 40 */,
  {-1, 0, 0x4E4D} /* 41 */,
  {-1, 0, 0x4E52} /* 42 */,
  {-1, 0, 0x4E53} /* 43 */,
  {-1, 0, 0x4E56} /* 44 */,
  {-1, 0, 0x4E58} /* 45 */,
  {-1, 0, 0x4E59} /* 46 */,
  {-1, 0, 0x4E5D} /* 47 */,
  {-1, 0, 0x4E5F} /* 48 */,
  {-1, 0, 0x4E5E} /* 49 */,
  {-1, 0, 0},
  {-1, 0, 0x4E73} /* 4B */,
  {-1, 0, 0x4E7E} /* 4C */,
  {-1, 0, 0x4E82} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4E8B} /* 50 */,
  {-1, 0, 0x4E8C} /* 51 */,
  {-1, 0, 0x4E8E} /* 52 */,
  {-1, 0, 0x4E95} /* 53 */,
  {-1, 0, 0x4E94} /* 54 */,
  {-1, 0, 0x4E92} /* 55 */,
  {-1, 0, 0},
  {-1, 0, 0xE930} /* 57 */,
  {-1, 0, 0x4E9E} /* 58 */,
  {-1, 0, 0x4E9B} /* 59 */,
  {-1, 0, 0x4E9F} /* 5A */,
  {-1, 0, 0x4EA1} /* 5B */,
  {-1, 0, 0x4EA6} /* 5C */,
  {-1, 0, 0x4EA5} /* 5D */,
  {-1, 0, 0x4EA4} /* 5E */,
  {-1, 0, 0x4EA8} /* 5F */,
  {-1, 0, 0x4EAB} /* 60 */,
  {-1, 0, 0x4EAC} /* 61 */,
  {-1, 0, 0x4EAD} /* 62 */,
  {-1, 0, 0x4EAE} /* 63 */,
  {-1, 0, 0x4EBA} /* 64 */,
  {-1, 0, 0x4ECA} /* 65 */,
  {-1, 0, 0x4EC1} /* 66 */,
  {-1, 0, 0},
  {-1, 0, 0x4EC3} /* 68 */,
  {-1, 0, 0x4EC4} /* 69 */,
  {-1, 0, 0},
  {-1, 0, 0x4ECD} /* 6B */,
  {-1, 0, 0x4EC7} /* 6C */,
  {-1, 0, 0x4ECB} /* 6D */,
  {-1, 0, 0x4EE4} /* 6E */,
  {-1, 0, 0x4ED8} /* 6F */,
  {-1, 0, 0x4ED5} /* 70 */,
  {-1, 0, 0x4ED6} /* 71 */,
  {-1, 0, 0x4EDE} /* 72 */,
  {-1, 0, 0x4EE3} /* 73 */,
  {-1, 0, 0x4ED4} /* 74 */,
  {-1, 0, 0x4ED7} /* 75 */,
  {-1, 0, 0x4ED9} /* 76 */,
  {-1, 0, 0x4EE5} /* 77 */,
  {-1, 0, 0x4EFF} /* 78 */,
  {-1, 0, 0x4F09} /* 79 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0x4EFB} /* 7C */,
  {-1, 0, 0x4F0A} /* 7D */,
  {-1, 0, 0x4F15} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page3 = {
  0, marc8_9page3_dir
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8_9page2_flat[] = {
  {"\x30", 0, 0x3007},
  {"", 0}
};
struct yaz_iconv_trie marc8_9page2 = {
  marc8_9page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_dir marc8_9page1_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {825, 0, 0} /* 23 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {826, 0, 0} /* 2A */,
  {827, 0, 0} /* 2B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {2, 0, 0} /* 2F */,
  {3, 0, 0} /* 30 */,
  {4, 0, 0} /* 31 */,
  {5, 0, 0} /* 32 */,
  {6, 0, 0} /* 33 */,
  {7, 0, 0} /* 34 */,
  {8, 0, 0} /* 35 */,
  {9, 0, 0} /* 36 */,
  {10, 0, 0} /* 37 */,
  {11, 0, 0} /* 38 */,
  {12, 0, 0} /* 39 */,
  {13, 0, 0} /* 3A */,
  {14, 0, 0} /* 3B */,
  {15, 0, 0} /* 3C */,
  {16, 0, 0} /* 3D */,
  {17, 0, 0} /* 3E */,
  {18, 0, 0} /* 3F */,
  {19, 0, 0} /* 40 */,
  {20, 0, 0} /* 41 */,
  {21, 0, 0} /* 42 */,
  {22, 0, 0} /* 43 */,
  {23, 0, 0} /* 44 */,
  {24, 0, 0} /* 45 */,
  {25, 0, 0} /* 46 */,
  {26, 0, 0} /* 47 */,
  {27, 0, 0} /* 48 */,
  {28, 0, 0} /* 49 */,
  {29, 0, 0} /* 4A */,
  {30, 0, 0} /* 4B */,
  {31, 0, 0} /* 4C */,
  {32, 0, 0} /* 4D */,
  {33, 0, 0} /* 4E */,
  {34, 0, 0} /* 4F */,
  {35, 0, 0} /* 50 */,
  {36, 0, 0} /* 51 */,
  {37, 0, 0} /* 52 */,
  {38, 0, 0} /* 53 */,
  {39, 0, 0} /* 54 */,
  {40, 0, 0} /* 55 */,
  {41, 0, 0} /* 56 */,
  {42, 0, 0} /* 57 */,
  {43, 0, 0} /* 58 */,
  {44, 0, 0} /* 59 */,
  {45, 0, 0} /* 5A */,
  {46, 0, 0} /* 5B */,
  {47, 0, 0} /* 5C */,
  {48, 0, 0} /* 5D */,
  {49, 0, 0} /* 5E */,
  {50, 0, 0} /* 5F */,
  {51, 0, 0} /* 60 */,
  {52, 0, 0} /* 61 */,
  {53, 0, 0} /* 62 */,
  {54, 0, 0} /* 63 */,
  {55, 0, 0} /* 64 */,
  {56, 0, 0} /* 65 */,
  {57, 0, 0} /* 66 */,
  {58, 0, 0} /* 67 */,
  {59, 0, 0} /* 68 */,
  {60, 0, 0} /* 69 */,
  {61, 0, 0} /* 6A */,
  {62, 0, 0} /* 6B */,
  {63, 0, 0} /* 6C */,
  {64, 0, 0} /* 6D */,
  {65, 0, 0} /* 6E */,
  {66, 0, 0} /* 6F */,
  {67, 0, 0} /* 70 */,
  {68, 0, 0} /* 71 */,
  {69, 0, 0} /* 72 */,
  {70, 0, 0} /* 73 */,
  {71, 0, 0} /* 74 */,
  {72, 0, 0} /* 75 */,
  {73, 0, 0} /* 76 */,
  {74, 0, 0} /* 77 */,
  {75, 0, 0} /* 78 */,
  {76, 0, 0} /* 79 */,
  {77, 0, 0} /* 7A */,
  {78, 0, 0} /* 7B */,
  {79, 0, 0} /* 7C */,
  {80, 0, 0} /* 7D */,
  {81, 0, 0} /* 7E */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page1 = {
  0, marc8_9page1_dir
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_9page0_dir[256] = {
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {1, 0, 0} /* 21 */,
  {82, 0, 0} /* 22 */,
  {176, 0, 0} /* 23 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {240, 0, 0} /* 27 */,
  {313, 0, 0} /* 28 */,
  {380, 0, 0} /* 29 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {437, 0, 0} /* 2D */,
  {497, 0, 0} /* 2E */,
  {544, 0, 0} /* 2F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {545, 0, 0} /* 33 */,
  {596, 0, 0} /* 34 */,
  {597, 0, 0} /* 35 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {598, 0, 0} /* 39 */,
  {640, 0, 0} /* 3A */,
  {641, 0, 0} /* 3B */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {642, 0, 0} /* 3F */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {643, 0, 0} /* 45 */,
  {644, 0, 0} /* 46 */,
  {645, 0, 0} /* 47 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {646, 0, 0} /* 4B */,
  {709, 0, 0} /* 4C */,
  {752, 0, 0} /* 4D */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {753, 0, 0} /* 51 */,
  {754, 0, 0} /* 52 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {755, 0, 0} /* 69 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {797, 0, 0} /* 6F */,
  {793, 0, 0} /* 70 */,
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0},
  {-1, 0, 0}
};
struct yaz_iconv_trie marc8_9page0 = {
  0, marc8_9page0_dir
};
struct yaz_iconv_trie *marc8_9ptrs [] = {
 &marc8_9page0,
 &marc8_9page1,
 &marc8_9page2,
 &marc8_9page3,
 &marc8_9page4,
 &marc8_9page5,
 &marc8_9page6,
 &marc8_9page7,
 &marc8_9page8,
 &marc8_9page9,
 &marc8_9page10,
 &marc8_9page11,
 &marc8_9page12,
 &marc8_9page13,
 &marc8_9page14,
 &marc8_9page15,
 &marc8_9page16,
 &marc8_9page17,
 &marc8_9page18,
 &marc8_9page19,
 &marc8_9page20,
 &marc8_9page21,
 &marc8_9page22,
 &marc8_9page23,
 &marc8_9page24,
 &marc8_9page25,
 &marc8_9page26,
 &marc8_9page27,
 &marc8_9page28,
 &marc8_9page29,
 &marc8_9page30,
 &marc8_9page31,
 &marc8_9page32,
 &marc8_9page33,
 &marc8_9page34,
 &marc8_9page35,
 &marc8_9page36,
 &marc8_9page37,
 &marc8_9page38,
 &marc8_9page39,
 &marc8_9page40,
 &marc8_9page41,
 &marc8_9page42,
 &marc8_9page43,
 &marc8_9page44,
 &marc8_9page45,
 &marc8_9page46,
 &marc8_9page47,
 &marc8_9page48,
 &marc8_9page49,
 &marc8_9page50,
 &marc8_9page51,
 &marc8_9page52,
 &marc8_9page53,
 &marc8_9page54,
 &marc8_9page55,
 &marc8_9page56,
 &marc8_9page57,
 &marc8_9page58,
 &marc8_9page59,
 &marc8_9page60,
 &marc8_9page61,
 &marc8_9page62,
 &marc8_9page63,
 &marc8_9page64,
 &marc8_9page65,
 &marc8_9page66,
 &marc8_9page67,
 &marc8_9page68,
 &marc8_9page69,
 &marc8_9page70,
 &marc8_9page71,
 &marc8_9page72,
 &marc8_9page73,
 &marc8_9page74,
 &marc8_9page75,
 &marc8_9page76,
 &marc8_9page77,
 &marc8_9page78,
 &marc8_9page79,
 &marc8_9page80,
 &marc8_9page81,
 &marc8_9page82,
 &marc8_9page83,
 &marc8_9page84,
 &marc8_9page85,
 &marc8_9page86,
 &marc8_9page87,
 &marc8_9page88,
 &marc8_9page89,
 &marc8_9page90,
 &marc8_9page91,
 &marc8_9page92,
 &marc8_9page93,
 &marc8_9page94,
 &marc8_9page95,
 &marc8_9page96,
 &marc8_9page97,
 &marc8_9page98,
 &marc8_9page99,
 &marc8_9page100,
 &marc8_9page101,
 &marc8_9page102,
 &marc8_9page103,
 &marc8_9page104,
 &marc8_9page105,
 &marc8_9page106,
 &marc8_9page107,
 &marc8_9page108,
 &marc8_9page109,
 &marc8_9page110,
 &marc8_9page111,
 &marc8_9page112,
 &marc8_9page113,
 &marc8_9page114,
 &marc8_9page115,
 &marc8_9page116,
 &marc8_9page117,
 &marc8_9page118,
 &marc8_9page119,
 &marc8_9page120,
 &marc8_9page121,
 &marc8_9page122,
 &marc8_9page123,
 &marc8_9page124,
 &marc8_9page125,
 &marc8_9page126,
 &marc8_9page127,
 &marc8_9page128,
 &marc8_9page129,
 &marc8_9page130,
 &marc8_9page131,
 &marc8_9page132,
 &marc8_9page133,
 &marc8_9page134,
 &marc8_9page135,
 &marc8_9page136,
 &marc8_9page137,
 &marc8_9page138,
 &marc8_9page139,
 &marc8_9page140,
 &marc8_9page141,
 &marc8_9page142,
 &marc8_9page143,
 &marc8_9page144,
 &marc8_9page145,
 &marc8_9page146,
 &marc8_9page147,
 &marc8_9page148,
 &marc8_9page149,
 &marc8_9page150,
 &marc8_9page151,
 &marc8_9page152,
 &marc8_9page153,
 &marc8_9page154,
 &marc8_9page155,
 &marc8_9page156,
 &marc8_9page157,
 &marc8_9page158,
 &marc8_9page159,
 &marc8_9page160,
 &marc8_9page161,
 &marc8_9page162,
 &marc8_9page163,
 &marc8_9page164,
 &marc8_9page165,
 &marc8_9page166,
 &marc8_9page167,
 &marc8_9page168,
 &marc8_9page169,
 &marc8_9page170,
 &marc8_9page171,
 &marc8_9page172,
 &marc8_9page173,
 &marc8_9page174,
 &marc8_9page175,
 &marc8_9page176,
 &marc8_9page177,
 &marc8_9page178,
 &marc8_9page179,
 &marc8_9page180,
 &marc8_9page181,
 &marc8_9page182,
 &marc8_9page183,
 &marc8_9page184,
 &marc8_9page185,
 &marc8_9page186,
 &marc8_9page187,
 &marc8_9page188,
 &marc8_9page189,
 &marc8_9page190,
 &marc8_9page191,
 &marc8_9page192,
 &marc8_9page193,
 &marc8_9page194,
 &marc8_9page195,
 &marc8_9page196,
 &marc8_9page197,
 &marc8_9page198,
 &marc8_9page199,
 &marc8_9page200,
 &marc8_9page201,
 &marc8_9page202,
 &marc8_9page203,
 &marc8_9page204,
 &marc8_9page205,
 &marc8_9page206,
 &marc8_9page207,
 &marc8_9page208,
 &marc8_9page209,
 &marc8_9page210,
 &marc8_9page211,
 &marc8_9page212,
 &marc8_9page213,
 &marc8_9page214,
 &marc8_9page215,
 &marc8_9page216,
 &marc8_9page217,
 &marc8_9page218,
 &marc8_9page219,
 &marc8_9page220,
 &marc8_9page221,
 &marc8_9page222,
 &marc8_9page223,
 &marc8_9page224,
 &marc8_9page225,
 &marc8_9page226,
 &marc8_9page227,
 &marc8_9page228,
 &marc8_9page229,
 &marc8_9page230,
 &marc8_9page231,
 &marc8_9page232,
 &marc8_9page233,
 &marc8_9page234,
 &marc8_9page235,
 &marc8_9page236,
 &marc8_9page237,
 &marc8_9page238,
 &marc8_9page239,
 &marc8_9page240,
 &marc8_9page241,
 &marc8_9page242,
 &marc8_9page243,
 &marc8_9page244,
 &marc8_9page245,
 &marc8_9page246,
 &marc8_9page247,
 &marc8_9page248,
 &marc8_9page249,
 &marc8_9page250,
 &marc8_9page251,
 &marc8_9page252,
 &marc8_9page253,
 &marc8_9page254,
 &marc8_9page255,
 &marc8_9page256,
 &marc8_9page257,
 &marc8_9page258,
 &marc8_9page259,
 &marc8_9page260,
 &marc8_9page261,
 &marc8_9page262,
 &marc8_9page263,
 &marc8_9page264,
 &marc8_9page265,
 &marc8_9page266,
 &marc8_9page267,
 &marc8_9page268,
 &marc8_9page269,
 &marc8_9page270,
 &marc8_9page271,
 &marc8_9page272,
 &marc8_9page273,
 &marc8_9page274,
 &marc8_9page275,
 &marc8_9page276,
 &marc8_9page277,
 &marc8_9page278,
 &marc8_9page279,
 &marc8_9page280,
 &marc8_9page281,
 &marc8_9page282,
 &marc8_9page283,
 &marc8_9page284,
 &marc8_9page285,
 &marc8_9page286,
 &marc8_9page287,
 &marc8_9page288,
 &marc8_9page289,
 &marc8_9page290,
 &marc8_9page291,
 &marc8_9page292,
 &marc8_9page293,
 &marc8_9page294,
 &marc8_9page295,
 &marc8_9page296,
 &marc8_9page297,
 &marc8_9page298,
 &marc8_9page299,
 &marc8_9page300,
 &marc8_9page301,
 &marc8_9page302,
 &marc8_9page303,
 &marc8_9page304,
 &marc8_9page305,
 &marc8_9page306,
 &marc8_9page307,
 &marc8_9page308,
 &marc8_9page309,
 &marc8_9page310,
 &marc8_9page311,
 &marc8_9page312,
 &marc8_9page313,
 &marc8_9page314,
 &marc8_9page315,
 &marc8_9page316,
 &marc8_9page317,
 &marc8_9page318,
 &marc8_9page319,
 &marc8_9page320,
 &marc8_9page321,
 &marc8_9page322,
 &marc8_9page323,
 &marc8_9page324,
 &marc8_9page325,
 &marc8_9page326,
 &marc8_9page327,
 &marc8_9page328,
 &marc8_9page329,
 &marc8_9page330,
 &marc8_9page331,
 &marc8_9page332,
 &marc8_9page333,
 &marc8_9page334,
 &marc8_9page335,
 &marc8_9page336,
 &marc8_9page337,
 &marc8_9page338,
 &marc8_9page339,
 &marc8_9page340,
 &marc8_9page341,
 &marc8_9page342,
 &marc8_9page343,
 &marc8_9page344,
 &marc8_9page345,
 &marc8_9page346,
 &marc8_9page347,
 &marc8_9page348,
 &marc8_9page349,
 &marc8_9page350,
 &marc8_9page351,
 &marc8_9page352,
 &marc8_9page353,
 &marc8_9page354,
 &marc8_9page355,
 &marc8_9page356,
 &marc8_9page357,
 &marc8_9page358,
 &marc8_9page359,
 &marc8_9page360,
 &marc8_9page361,
 &marc8_9page362,
 &marc8_9page363,
 &marc8_9page364,
 &marc8_9page365,
 &marc8_9page366,
 &marc8_9page367,
 &marc8_9page368,
 &marc8_9page369,
 &marc8_9page370,
 &marc8_9page371,
 &marc8_9page372,
 &marc8_9page373,
 &marc8_9page374,
 &marc8_9page375,
 &marc8_9page376,
 &marc8_9page377,
 &marc8_9page378,
 &marc8_9page379,
 &marc8_9page380,
 &marc8_9page381,
 &marc8_9page382,
 &marc8_9page383,
 &marc8_9page384,
 &marc8_9page385,
 &marc8_9page386,
 &marc8_9page387,
 &marc8_9page388,
 &marc8_9page389,
 &marc8_9page390,
 &marc8_9page391,
 &marc8_9page392,
 &marc8_9page393,
 &marc8_9page394,
 &marc8_9page395,
 &marc8_9page396,
 &marc8_9page397,
 &marc8_9page398,
 &marc8_9page399,
 &marc8_9page400,
 &marc8_9page401,
 &marc8_9page402,
 &marc8_9page403,
 &marc8_9page404,
 &marc8_9page405,
 &marc8_9page406,
 &marc8_9page407,
 &marc8_9page408,
 &marc8_9page409,
 &marc8_9page410,
 &marc8_9page411,
 &marc8_9page412,
 &marc8_9page413,
 &marc8_9page414,
 &marc8_9page415,
 &marc8_9page416,
 &marc8_9page417,
 &marc8_9page418,
 &marc8_9page419,
 &marc8_9page420,
 &marc8_9page421,
 &marc8_9page422,
 &marc8_9page423,
 &marc8_9page424,
 &marc8_9page425,
 &marc8_9page426,
 &marc8_9page427,
 &marc8_9page428,
 &marc8_9page429,
 &marc8_9page430,
 &marc8_9page431,
 &marc8_9page432,
 &marc8_9page433,
 &marc8_9page434,
 &marc8_9page435,
 &marc8_9page436,
 &marc8_9page437,
 &marc8_9page438,
 &marc8_9page439,
 &marc8_9page440,
 &marc8_9page441,
 &marc8_9page442,
 &marc8_9page443,
 &marc8_9page444,
 &marc8_9page445,
 &marc8_9page446,
 &marc8_9page447,
 &marc8_9page448,
 &marc8_9page449,
 &marc8_9page450,
 &marc8_9page451,
 &marc8_9page452,
 &marc8_9page453,
 &marc8_9page454,
 &marc8_9page455,
 &marc8_9page456,
 &marc8_9page457,
 &marc8_9page458,
 &marc8_9page459,
 &marc8_9page460,
 &marc8_9page461,
 &marc8_9page462,
 &marc8_9page463,
 &marc8_9page464,
 &marc8_9page465,
 &marc8_9page466,
 &marc8_9page467,
 &marc8_9page468,
 &marc8_9page469,
 &marc8_9page470,
 &marc8_9page471,
 &marc8_9page472,
 &marc8_9page473,
 &marc8_9page474,
 &marc8_9page475,
 &marc8_9page476,
 &marc8_9page477,
 &marc8_9page478,
 &marc8_9page479,
 &marc8_9page480,
 &marc8_9page481,
 &marc8_9page482,
 &marc8_9page483,
 &marc8_9page484,
 &marc8_9page485,
 &marc8_9page486,
 &marc8_9page487,
 &marc8_9page488,
 &marc8_9page489,
 &marc8_9page490,
 &marc8_9page491,
 &marc8_9page492,
 &marc8_9page493,
 &marc8_9page494,
 &marc8_9page495,
 &marc8_9page496,
 &marc8_9page497,
 &marc8_9page498,
 &marc8_9page499,
 &marc8_9page500,
 &marc8_9page501,
 &marc8_9page502,
 &marc8_9page503,
 &marc8_9page504,
 &marc8_9page505,
 &marc8_9page506,
 &marc8_9page507,
 &marc8_9page508,
 &marc8_9page509,
 &marc8_9page510,
 &marc8_9page511,
 &marc8_9page512,
 &marc8_9page513,
 &marc8_9page514,
 &marc8_9page515,
 &marc8_9page516,
 &marc8_9page517,
 &marc8_9page518,
 &marc8_9page519,
 &marc8_9page520,
 &marc8_9page521,
 &marc8_9page522,
 &marc8_9page523,
 &marc8_9page524,
 &marc8_9page525,
 &marc8_9page526,
 &marc8_9page527,
 &marc8_9page528,
 &marc8_9page529,
 &marc8_9page530,
 &marc8_9page531,
 &marc8_9page532,
 &marc8_9page533,
 &marc8_9page534,
 &marc8_9page535,
 &marc8_9page536,
 &marc8_9page537,
 &marc8_9page538,
 &marc8_9page539,
 &marc8_9page540,
 &marc8_9page541,
 &marc8_9page542,
 &marc8_9page543,
 &marc8_9page544,
 &marc8_9page545,
 &marc8_9page546,
 &marc8_9page547,
 &marc8_9page548,
 &marc8_9page549,
 &marc8_9page550,
 &marc8_9page551,
 &marc8_9page552,
 &marc8_9page553,
 &marc8_9page554,
 &marc8_9page555,
 &marc8_9page556,
 &marc8_9page557,
 &marc8_9page558,
 &marc8_9page559,
 &marc8_9page560,
 &marc8_9page561,
 &marc8_9page562,
 &marc8_9page563,
 &marc8_9page564,
 &marc8_9page565,
 &marc8_9page566,
 &marc8_9page567,
 &marc8_9page568,
 &marc8_9page569,
 &marc8_9page570,
 &marc8_9page571,
 &marc8_9page572,
 &marc8_9page573,
 &marc8_9page574,
 &marc8_9page575,
 &marc8_9page576,
 &marc8_9page577,
 &marc8_9page578,
 &marc8_9page579,
 &marc8_9page580,
 &marc8_9page581,
 &marc8_9page582,
 &marc8_9page583,
 &marc8_9page584,
 &marc8_9page585,
 &marc8_9page586,
 &marc8_9page587,
 &marc8_9page588,
 &marc8_9page589,
 &marc8_9page590,
 &marc8_9page591,
 &marc8_9page592,
 &marc8_9page593,
 &marc8_9page594,
 &marc8_9page595,
 &marc8_9page596,
 &marc8_9page597,
 &marc8_9page598,
 &marc8_9page599,
 &marc8_9page600,
 &marc8_9page601,
 &marc8_9page602,
 &marc8_9page603,
 &marc8_9page604,
 &marc8_9page605,
 &marc8_9page606,
 &marc8_9page607,
 &marc8_9page608,
 &marc8_9page609,
 &marc8_9page610,
 &marc8_9page611,
 &marc8_9page612,
 &marc8_9page613,
 &marc8_9page614,
 &marc8_9page615,
 &marc8_9page616,
 &marc8_9page617,
 &marc8_9page618,
 &marc8_9page619,
 &marc8_9page620,
 &marc8_9page621,
 &marc8_9page622,
 &marc8_9page623,
 &marc8_9page624,
 &marc8_9page625,
 &marc8_9page626,
 &marc8_9page627,
 &marc8_9page628,
 &marc8_9page629,
 &marc8_9page630,
 &marc8_9page631,
 &marc8_9page632,
 &marc8_9page633,
 &marc8_9page634,
 &marc8_9page635,
 &marc8_9page636,
 &marc8_9page637,
 &marc8_9page638,
 &marc8_9page639,
 &marc8_9page640,
 &marc8_9page641,
 &marc8_9page642,
 &marc8_9page643,
 &marc8_9page644,
 &marc8_9page645,
 &marc8_9page646,
 &marc8_9page647,
 &marc8_9page648,
 &marc8_9page649,
 &marc8_9page650,
 &marc8_9page651,
 &marc8_9page652,
 &marc8_9page653,
 &marc8_9page654,
 &marc8_9page655,
 &marc8_9page656,
 &marc8_9page657,
 &marc8_9page658,
 &marc8_9page659,
 &marc8_9page660,
 &marc8_9page661,
 &marc8_9page662,
 &marc8_9page663,
 &marc8_9page664,
 &marc8_9page665,
 &marc8_9page666,
 &marc8_9page667,
 &marc8_9page668,
 &marc8_9page669,
 &marc8_9page670,
 &marc8_9page671,
 &marc8_9page672,
 &marc8_9page673,
 &marc8_9page674,
 &marc8_9page675,
 &marc8_9page676,
 &marc8_9page677,
 &marc8_9page678,
 &marc8_9page679,
 &marc8_9page680,
 &marc8_9page681,
 &marc8_9page682,
 &marc8_9page683,
 &marc8_9page684,
 &marc8_9page685,
 &marc8_9page686,
 &marc8_9page687,
 &marc8_9page688,
 &marc8_9page689,
 &marc8_9page690,
 &marc8_9page691,
 &marc8_9page692,
 &marc8_9page693,
 &marc8_9page694,
 &marc8_9page695,
 &marc8_9page696,
 &marc8_9page697,
 &marc8_9page698,
 &marc8_9page699,
 &marc8_9page700,
 &marc8_9page701,
 &marc8_9page702,
 &marc8_9page703,
 &marc8_9page704,
 &marc8_9page705,
 &marc8_9page706,
 &marc8_9page707,
 &marc8_9page708,
 &marc8_9page709,
 &marc8_9page710,
 &marc8_9page711,
 &marc8_9page712,
 &marc8_9page713,
 &marc8_9page714,
 &marc8_9page715,
 &marc8_9page716,
 &marc8_9page717,
 &marc8_9page718,
 &marc8_9page719,
 &marc8_9page720,
 &marc8_9page721,
 &marc8_9page722,
 &marc8_9page723,
 &marc8_9page724,
 &marc8_9page725,
 &marc8_9page726,
 &marc8_9page727,
 &marc8_9page728,
 &marc8_9page729,
 &marc8_9page730,
 &marc8_9page731,
 &marc8_9page732,
 &marc8_9page733,
 &marc8_9page734,
 &marc8_9page735,
 &marc8_9page736,
 &marc8_9page737,
 &marc8_9page738,
 &marc8_9page739,
 &marc8_9page740,
 &marc8_9page741,
 &marc8_9page742,
 &marc8_9page743,
 &marc8_9page744,
 &marc8_9page745,
 &marc8_9page746,
 &marc8_9page747,
 &marc8_9page748,
 &marc8_9page749,
 &marc8_9page750,
 &marc8_9page751,
 &marc8_9page752,
 &marc8_9page753,
 &marc8_9page754,
 &marc8_9page755,
 &marc8_9page756,
 &marc8_9page757,
 &marc8_9page758,
 &marc8_9page759,
 &marc8_9page760,
 &marc8_9page761,
 &marc8_9page762,
 &marc8_9page763,
 &marc8_9page764,
 &marc8_9page765,
 &marc8_9page766,
 &marc8_9page767,
 &marc8_9page768,
 &marc8_9page769,
 &marc8_9page770,
 &marc8_9page771,
 &marc8_9page772,
 &marc8_9page773,
 &marc8_9page774,
 &marc8_9page775,
 &marc8_9page776,
 &marc8_9page777,
 &marc8_9page778,
 &marc8_9page779,
 &marc8_9page780,
 &marc8_9page781,
 &marc8_9page782,
 &marc8_9page783,
 &marc8_9page784,
 &marc8_9page785,
 &marc8_9page786,
 &marc8_9page787,
 &marc8_9page788,
 &marc8_9page789,
 &marc8_9page790,
 &marc8_9page791,
 &marc8_9page792,
 &marc8_9page793,
 &marc8_9page794,
 &marc8_9page795,
 &marc8_9page796,
 &marc8_9page797,
 &marc8_9page798,
 &marc8_9page799,
 &marc8_9page800,
 &marc8_9page801,
 &marc8_9page802,
 &marc8_9page803,
 &marc8_9page804,
 &marc8_9page805,
 &marc8_9page806,
 &marc8_9page807,
 &marc8_9page808,
 &marc8_9page809,
 &marc8_9page810,
 &marc8_9page811,
 &marc8_9page812,
 &marc8_9page813,
 &marc8_9page814,
 &marc8_9page815,
 &marc8_9page816,
 &marc8_9page817,
 &marc8_9page818,
 &marc8_9page819,
 &marc8_9page820,
 &marc8_9page821,
 &marc8_9page822,
 &marc8_9page823,
 &marc8_9page824,
 &marc8_9page825,
 &marc8_9page826,
 &marc8_9page827,
0, };

unsigned long yaz_marc8_9_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining)
        {
            unsigned long code;
            
            code = lookup(marc8_9ptrs, 0, inp, inbytesleft, no_read, combining);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
