/*
				 Audio CD IO
 */

#ifndef AUDIOCD_H
#define AUDIOCD_H

#include <sys/types.h>

/*
 *	Audio CD track structure:
 */
typedef struct {

	int number;
	unsigned long start_time;
	unsigned long length;
	char *name;

} AudioCDTrack;

/*
 *	Audio CD context structure:
 */
typedef struct {

	char *prog;
	char *device;
	int current_track_number;	/* 0 for none/not playing. */

} AudioCDContext;


extern AudioCDContext *AudioCDInit(void);
extern void AudioCDShutdown(AudioCDContext *ctx);

extern AudioCDTrack **AudioCDListTracks(AudioCDContext *ctx, int *total);
extern void AudioCDDeleteTracksList(AudioCDTrack **track, int total);

extern int AudioCDLastTrack(AudioCDContext *ctx);

extern void AudioCDPlayTrack(AudioCDContext *ctx, int track_number);
extern void AudioCDStop(AudioCDContext *ctx);
extern void AudioCDEject(AudioCDContext *ctx);


#endif	/* AUDIOCD_H */
