/*
	List of hosts allowed accesss to connect.
 */

#ifndef YHOST_H
#define YHOST_H

#include <sys/types.h>
#include "ytypes.h"


/*
 *	YHost structure:
 */
typedef struct {

	YIPUnion ip;

} YHost;

extern YHost **yhost;
extern int total_yhosts;


/*
 *	Functions:
 */
extern int YHostIsAllocated(int n);
extern YHost *YHostGetPtr(int n);

extern int YHostInList(YIPUnion *ip);
extern int YHostDeleteByHost(YIPUnion *ip);

extern int YHostAllocate(YIPUnion *ip);
extern void YHostDelete(int n);
extern void YHostDeleteAll(void);


#endif	/* YHOST_H */
