#line 9 "heap.nw"
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include "run.h"
#include "heap.h"
#include "eval.h"

#line 165 "heap.nw"
const int ot_binary[] = { 0 };

#line 216 "heap.nw"
NodeInfo ___91__93__info = {
    NIL_TAG, nil_node_size, (const int *)0, (Label)eval_whnf, "[]", (FinalFun)0
};
NodeInfo ___58__info = {
    CONS_TAG, cons_node_size, (const int *)0, (Label)eval_whnf, ":", (FinalFun)0
};
NodeInfo ___40__41__info = {
    UNIT_TAG, unit_node_size, (const int *)0, (Label)eval_whnf, "()", (FinalFun)0
};
NodeInfo __Success_info = {
    SUCCESS_TAG, success_node_size, (const int *)0, (Label)eval_whnf, "Success",
    (FinalFun)0
};

NodeInfo *___91__93__node = &___91__93__info;
NodeInfo *___40__41__node = &___40__41__info;
NodeInfo *__Success_node  = &__Success_info;

boolean
is_tuple(const NodeInfo *info)
{
    const char *cp = info->cname;

    if ( *cp++ != '(' || *cp++ != ',' )
	return false;
    while ( *cp == ',' )
	cp++;
    return *cp++ == ')' && *cp == '\0';
}

#line 320 "heap.nw"
#if ONLY_BOXED_OBJECTS
NodeInfo int_info = { 
    INT_TAG, int_node_size, ot_binary, (Label)eval_whnf, (const char *)0, (FinalFun)0
};
#endif

#line 391 "heap.nw"
NodeInfo char_info = {
    CHAR_TAG, char_node_size, ot_binary, (Label)eval_whnf, (const char *)0,
    (FinalFun)0
};

struct char_node char_table[256];

void
init_chars()
{
    int i;
    
    for (i = 0; i < 256; i++ )
    {
	char_table[i].info = &char_info;
	char_table[i].ch = i;
    }
}

#line 476 "heap.nw"
NodeInfo variable_info = {
    VARIABLE_TAG, variable_node_size, (const int *)0, (Label)eval_whnf,
    (const char *)0, (FinalFun)0
};

#line 524 "heap.nw"
NodeInfo suspend_info = {
    SUSPEND_TAG, suspend_node_size, (const int *)0, (Label)eval_suspend,
    (const char *)0, (FinalFun)0
};
NodeInfo queueMe_info = {
    QUEUEME_TAG, queueMe_node_size, (const int *)0, (Label)eval_queueMe,
    (const char *)0, (FinalFun)0
};

#line 555 "heap.nw"
NodeInfo indir_info = {
    INDIR_TAG, indir_node_size, (const int *)0, (Label)eval_indir, (const char *)0,
    (FinalFun)0
};
NodeInfo suspend_indir_info = {
    INDIR_TAG, suspend_node_size, (const int *)0, (Label)eval_indir, (const char *)0,
    (FinalFun)0
};
NodeInfo variable_indir_info = {
    INDIR_TAG, variable_node_size, (const int *)0, (Label)eval_indir, (const char *)0,
    (FinalFun)0
};

#line 586 "heap.nw"
NodeInfo search_cont_info = {
    SEARCH_CONT_TAG, search_cont_node_size, (const int *)0, (Label)no_eval,
    "<state>", (FinalFun)0
};

#line 628 "heap.nw"
word *hp;
word *hlim;
word *heap_base;
word *heap_end;

#line 368 "heap.nw"
NodeInfo float_info = {
    FLOAT_TAG, float_node_size, ot_binary, (Label)eval_whnf, (const char *)0,
    (FinalFun)0
};


#line 653 "heap.nw"
boolean in_gc = false;

#line 708 "heap.nw"
Node **additional_roots;

#line 747 "heap.nw"
void
heap_exhausted()
{
    fprintf(stderr,
	    "not enough free memory in heap after garbage collection\n");
    exit(1);
}
