/* -*- c++ -*-_______________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: gdbmdatabase.h,v 1.1 2003/09/16 17:58:14 kgk Exp $
____________________________________________________________________________*/


#ifndef INCLUDED_DATABASE_H_
#define INCLUDED_DATABASE_H_

#include <gdbm.h>

#include "config.h"
#include "mutex.h"
#include "metadatadb.h"
#include "cachedb.h"

class GDBMDatabase;


struct gdbm_iterator  {
//    typedef forward_iterator_tag iterator_category;
    typedef ptrdiff_t difference_type;
    
    GDBM_FILE* m_dbase;
    datum key;

    gdbm_iterator();
    gdbm_iterator(GDBMDatabase &db);
    ~gdbm_iterator();

    std::string operator*();
    gdbm_iterator& operator ++();
    gdbm_iterator operator ++(int);
    operator std::string();
};



class ZINF_EXPORT GDBMDatabase : public MetadataDB
{
    friend class gdbm_iterator;
public:


public:
    GDBMDatabase(const std::string& name, int version = -1);
    ~GDBMDatabase();

public:
    // Inherited interface;


    bool add(const url_t& url, const Metadata&);
    bool remove(const url_t& url);
    bool contains(const url_t&url);

    // Low level manipulations
    bool getMetadata(const url_t&url, Metadata&m);
    bool setMetadata(const url_t&url, const Metadata&m);

    Error query (const std::string&target, 
                 const params_t& params,
                 result_t& results);

    bool permitWrites(bool );
    void setPriority(int spot);
    int  getPriority();

    bool  isWorking();
private:    // New Interface 
    static std::vector<std::string> supported_tags;

    bool  loadDatabaseFormat(int version);
    void  storeDatabaseFormat(int version);

    gdbm_iterator begin() { return gdbm_iterator(*this); }
    gdbm_iterator end()   { return gdbm_iterator(); }

    void keyvalue(const std::string&key, std::string&val);
    void keyinsert(const std::string&key, const std::string&val);
    void keyremove(const std::string&key, const std::string&val);

private:    // Old interface
    

    int   Insert(const char *key, const char *content);
    void  Remove(const char *key);
    char *Value(const char *key);
    int   Exists(const char *key);
    char *NextKey(char *key);
    void  Sync(void);
    
    bool  IsUpgraded(void);
    
    int   GetSubVersion(void);
    void  StoreSubVersion(int version);
    

    void reloadCache();
    
    GDBM_FILE m_dbase;
    Mutex    *m_lock;
    bool      m_upgraded;
    CacheDB   *m_cache;
};

#endif
/* arch-tag: f25a5f04-e7aa-4ee1-b41f-44b5a7d677a7 */
