/*
 * stat.c
 *
 * Copyright (C) 1993 Alain Knaff
 */

#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

#ifdef HAVE___XSTAT
# include "xstatconv.c"
#endif

#include <sys/syscall.h>

#ifdef HAVE___XSTAT
# if defined(__GLIBC__) && __GLIBC__ >= 2
#  define no_syscall_stat

int ___zlibc_fstat(int fd, struct kernel_stat *buf)
{
  return zlib_real_fxstat(_STAT_VER_KERNEL, fd, (struct stat *) buf);
}

# endif
#endif

#define KSTAT STAT32
#define STAT(x) x ## stat
#define fSTAT fSTAT32

#include "stat_tmpl.c"

#undef STAT(x)
#undef KSTAT
#undef fSTAT


#ifdef HAVE_STAT64

# define KSTAT stat64
# define STAT(x) x##stat64
# define fSTAT fstat64

# include "stat_tmpl.c"

#endif


#ifdef HAVE___XSTAT


int __xstat(int vers, __const char *name, struct stat *buf)
{
     struct kernel_stat kbuf;
     int result;

     if (vers == _STAT_VER_KERNEL) {
	 return zlibc_stat(name, (struct kernel_stat *) buf);
     }
     
     result = zlibc_stat(name, &kbuf);
     if (result == 0)
	 result = xstat_conv (vers, &kbuf, buf);

     return result; 
}

int __lxstat (int vers, const char *name, struct stat *buf)
{
  struct kernel_stat kbuf;
  int result;

  if (vers == _STAT_VER_KERNEL) {
      return zlibc_lstat(name,(struct kernel_stat *) buf);
  }

  result = zlibc_lstat(name, &kbuf);
  if (result == 0)
    result = xstat_conv (vers, &kbuf, buf);
  return result;
}

#  ifdef HAVE___XSTAT64

static int __have_no_stat64=0;
int __xstat64(int vers, const char *name, struct stat64 *buf)
{
  return  zlibc_stat64(name, buf);
}

int __lxstat64 (int vers, const char *name, struct stat64 *buf)
{
  return zlibc_lstat64(name, buf);
}

#  endif


#else /* no xstat */


int stat(__const char *name, struct stat *buf)
{
    return zlibc_stat(name, buf);
}

int lstat(__const char *name, struct stat *buf)
{
    return zlibc_lstat(name, buf);
}


# ifdef HAVE_STAT64
int stat64(__const char *name, struct stat64 *buf)
{
    return zlibc_stat64(name, buf);
}
int lstat64(__const char *name, struct stat64 *buf)
{
    return zlibc_lstat64(name, buf);
}
# endif

#endif
