(in-package "ACL2")

(include-book "rtl")
(local (include-book "expt"))
(local (include-book "expt2"))
(local (include-book "arith2"))
(local (include-book "bvecp"))
(local (include-book "cat"))

(local (in-theory (disable a15)))

(defun mulcat (l n x)
  (if (and (integerp n) (> n 0))
      (cat (mulcat l (1- n) x)
	   x
	   l)
    0))

(in-theory (disable mulcat))

(defthm mulcat-nonnegative-integer-type
  (and (integerp (mulcat l n x))
       (<= 0 (mulcat l n x)))
  :hints (("Goal" :in-theory (enable mulcat)))
  :rule-classes (:type-prescription)
  )

;this rule is no better than mulcat-nonnegative-integer-type and might be worse
(in-theory (disable (:type-prescription mulcat)))

(defthm mulcat-natp
  (natp (mulcat l n x)))

(defthm mulcat-1
  (implies (and (case-split (integerp x))
                (case-split (<= 0 x)))
           (equal (mulcat l 1 x) x))
  :hints (("Goal" :in-theory (enable mulcat ;cat-0-rewrite
                                     )
           :expand ((mulcat l 1 x)))))

(defthm mulcat-bvecp-simple
  (implies (and (= p (* l n))
                (case-split (natp l))
                (case-split (bvecp x l))
                )
           (bvecp (mulcat l n x) p))
  :hints (("Goal" :in-theory (enable mulcat)))
  :rule-classes nil
  )

(defthm mulcat-bvecp
  (implies (and (>= p (* l n))
                (case-split (integerp p))
                (case-split (natp l))
                (case-split (bvecp x l))
                )
           (bvecp (mulcat l n x) p))
  :hints (("Goal" :in-theory (disable bvecp-longer)
           :use ((:instance mulcat-bvecp-simple (p (* l n)))
                 (:instance bvecp-longer (x (mulcat l n x)) (k2 p) (k1 (* l n)))))
          ))

(defthm mulcat-0
  (equal (mulcat l n 0) 0)
  :hints (("Goal" :in-theory (enable cat mulcat))))

(defthm mulcat-n-1
    (implies (case-split (<= 0 n))
	     (equal (mulcat 1 n 1)
		    (1- (expt 2 n))))
  :hints (("Goal" :in-theory (enable cat mulcat expt-split))))




