(in-package "ACL2")

(local (include-book "predicate"))

(defthm rationalp-product-when-one-arg-is-rational
  (implies (and (rationalp x)
                (case-split (not (equal x 0)))
                (case-split (acl2-numberp y))
                )
           (and (equal (rationalp (* x y))
                       (rationalp y))
                (equal (rationalp (* y x))
                       (rationalp y)))))

(defthm rationalp-sum-when-one-arg-is-rational
  (implies (and (rationalp x)
                (case-split (acl2-numberp y)))
           (and (equal (rationalp (+ x y))
                       (rationalp y))
                (equal (rationalp (+ y x))
                       (rationalp y)))))

(defthm rationalp-unary-divide
  (implies (case-split (acl2-numberp x))
           (equal (rationalp (/ x))
                  (rationalp x))))


                