#!/bin/sh
#
# Generate project documentation from XML.
#

xmlto=xmlto

if [ "$#" -lt 2 ]; then
	echo "Usage: $0 <format> <file.xml> [direcotry]" >&2
	exit 1
fi

FILE="`basename $2 | sed -e 's/\..*$//'`"

if [ X$3 != X ]; then
    DIRECTORY="$3/$FILE"
else
    DIRECTORY="$FILE"
fi

mkdir $DIRECTORY &> /dev/null

DOC_FILE=`pwd`/$2

check_file() {
    if [ -f $DIRECTORY/$1 ]; then
	return 0
    else
	return 1
    fi
}

msg() {
    echo
    echo "Generating documentation $FILE in $1 format..."
    echo
}

generate_html() {
	msg html
        cd $DIRECTORY
	$xmlto html --skip-validation $DOC_FILE
        cd -
}

generate_htmlnochunks() {
	msg htmlnochunks
	$xmlto html-nochunks -o $DIRECTORY --skip-validation $DOC_FILE
}

generate_pdf() {
	check_file $FILE.pdf && return 0
	msg pdf
	$xmlto pdf -o $DIRECTORY --skip-validation $DOC_FILE
}

generate_txt() {
	msg txt
	$xmlto txt -o $DIRECTORY --skip-validation $DOC_FILE
}

case $1 in
	html)
		generate_html $2
		;;
	html-nochunks)
		generate_htmlnochunks $2
		;;
	pdf)
		generate_pdf $2
		;;
        txt)
                generate_txt $2
                ;;
	all)
                generate_txt $2
		generate_html $2
		generate_htmlnochunks $2
		generate_pdf $2
	;;
	*)
		echo "ERROR: Unknow format '$1'." >&2
		echo "  choose one of: all, html, html-nochunks, pdf, txt" >&2
		exit 1
		;;
esac

