#define _SFUNC_ROSENBROCK_C_
/*
   --------------------------------------------------------------
   File sfunc_rosenbrock.C 
   of ADOL-C version 1.8.2                        as of Jan/21/99
   -------------------------------------------------------------- 

   Example: function module containing Rosenbrock's function

   Each << function module >> contains:
          
     (1) const char* const controlFileName 
     (2) int indepDim; 
 
     (3) void initProblemParameters( void )
     (4) void initIndependents( double* indeps )
     (5) double originalScalarFunction( double* indeps )
     (6) double tapingScalarFunction( int tag, double* indeps )   

   Last changes: 
     990121 olvo first version

   --------------------------------------------------------------
*/


/****************************************************************************/
/*                                                                 INCLUDES */
#include "adouble.h"

#include <math.h>


/****************************************************************************/
/*                                                         GLOBAL VARIABLES */

/*--------------------------------------------------------------------------*/
/*                                                        Control file name */
const char* controlFileName = "rosenbrockexam.ctrl";

/*--------------------------------------------------------------------------*/
/*                                                               Dimensions */
int indepDim;

/*--------------------------------------------------------------------------*/
/*                                       Other problem dependent parameters */


/****************************************************************************/
/*                                                  INIT PROBLEM PARAMETERS */
void initProblemParameters( void )
{ fprintf(stdout,"ROSENBROCKs FUNCTION (ADOL-C Example)\n\n");
  if (indepDim <= 0)
  { fprintf(stdout,"    number of independent variables = ? ");
    fscanf(stdin,"%d",&indepDim);
    fprintf(stdout,"\n");
  }
}


/****************************************************************************/
/*                                                        INITIALIZE INDEPs */
void initIndependents( double* indeps )
{ int i;
  for (i=0; i<indepDim; i++)
    indeps[i] = 600.0*(i+1.0)/(2.0+i);
}


/****************************************************************************/
/*                                                 ORIGINAL SCALAR FUNCTION */

/*--------------------------------------------------------------------------*/
/*                                                       Griewanks function */
double rosenbrock( int dim, double* indeps ) 
{ int i;
  double Val1,
	 Val2,
         tmp;

  tmp = 0.0;
  for (i = 0; i < dim-1; i++) 
  { Val1 = 10.0*(indeps[i+1]-indeps[i]*indeps[i]);
    Val2 = indeps[i]-1.0;
    tmp  += Val1*Val1 + Val2*Val2;
  }

  return tmp;
}

/*--------------------------------------------------------------------------*/
/*                                                   The interface function */
double originalScalarFunction( double* indeps )
{ return rosenbrock(indepDim, indeps);
}


/****************************************************************************/
/*                                                   TAPING SCALAR FUNCTION */

/*--------------------------------------------------------------------------*/
/*                                                active Griewnaks function */
adouble activeRosenbrock( int dim, adouble* indeps ) 
{ int i;
  adouble Val1,
	  Val2,
          tmp;

  tmp = 0.0;
  for (i = 0; i < dim-1; i++) 
  { Val1 = 10.0*(indeps[i+1]-indeps[i]*indeps[i]);
    Val2 = indeps[i]-1.0;
    tmp  += Val1*Val1 + Val2*Val2;
  }

  return tmp;
}

/*--------------------------------------------------------------------------*/
/*                                                   The interface function */
double tapingScalarFunction( int tag, double* indeps )
{ int i;
  trace_on(tag);
  adouble* activeIndeps = new adouble[indepDim];
  adouble* aIP = activeIndeps;
  double*  iP  = indeps; 
  for (i=0; i<indepDim; i++)
     *aIP++ <<= *iP++; 
  adouble ares = activeRosenbrock(indepDim, activeIndeps);
  double res = 0;
  ares >>= res;
  trace_off();
  return res; 
}

#undef _SFUNC_ROSENBROCK_C_





