#ifndef _MUDOBJECT_H
#define _MUDOBJECT_H

#include "strings.h"
#include "inventory.h"
#include "specials.h"
#include "parse.h"
#include "entity.h"
#include "errlog.h"
#include "status.h"

struct special_holder {
   Specials       *the_special;
   special_env    environment;
   special_holder *next_special;
};


class Player;
class Object_List;
class MudObject;

class MudObject : public Entity
{
public:

   MudObject();
   virtual ~MudObject();
   MudObject  *find_contained(char *the_object, int *find_num);
   int        find_contained(MudObject *the_obj);
   int        remove_contained(MudObject *the_object);
   int        add_contained(MudObject *the_object);
   Inventory  *get_inventory();
   virtual int set_location(MudObject *new_loc);
   virtual int set_dual_loc(char *loc1_name, char *loc2_name, 
                                                  Object_List *the_dbase);
   int        set_loc_str(char *the_loc);
   char       *get_loc_str();
   char       *get_location();
   virtual int set_title(char *the_title);
   char       *get_title();
   int        set_desc(char *the_desc);
   virtual char *get_desc();
   int        find_altname(char *the_name);
   int        set_altname(char *the_names);
   char       *get_altname();
   int        add_clones(Object_List *obj_dbase, ErrLog *error_log);
   
   int add_special(Specials *the_special);
   int remove_special(Specials *the_special);
   int del_special(int the_num);
   special_holder *find_special(char *the_text);
   special_holder *copy_specials();
   special_holder *get_special_list();
   int add_special_holder(special_holder *new_holder);
   void set_special_list(special_holder *the_holder);
   MudObject  *operator = (MudObject *copy_from); 
   int copy_mudobject(MudObject *copy_from);
   int describe_special(Builder *the_builder, int specialnr);
   char *get_clones();
   int set_clones(char *the_list);
   char *get_special_str();
   int set_special_str(char *the_list);
   void increment_cloned();
   unsigned long get_next_cloned();

   MudObject *get_contained_by();

   int set_attrib_title(Parse *the_parsed, Builder *the_builder);
   int set_attrib_altnames(Parse *the_parsed, Builder *the_builder);
   int set_attrib_desc(Builder *the_builder);
   int set_attrib_loc(Parse *the_parsed, Builder *the_builder);
   int set_attrib_clones(Parse *the_parsed, Builder *the_builder);
   int set_attrib_special(Parse *the_parsed, Builder *the_builder);
   int set_attrib_capacity(Parse *the_parsed, Builder *the_builder);

   int copy_mudobject_attrib(MudObject *copy_from);

   int write_mudobject_attrib(FILE *the_file);
   int read_mudobject_attrib(FILE *read_file, char *areaname, int build_format, 
                                    ErrLog *error_log);

   int set_attrib_desc(Player *the_player);

   char *get_parent();
   void set_parent(char *new_obj);
   char *get_keywords();
   void set_keywords(char *new_str);
   int  assign_keywords(char *the_string);

   int       get_long_input(Strings *the_input);

   void set_capacity(int the_num);
   int get_capacity(void);
   int get_size_held(void);
   int get_weight_held(void);

   int carried_by_player();
   int write_contents(FILE *the_file);

   int add_status(char *the_name);
   int add_status(char *the_name, char *the_string);
   int remove_status(char *the_name);
   int has_status(char *the_name);
   char *get_status_string(char *the_name);
 
   int   contains_lit(void);
   MudObject *find_fire(void);
   int check_contained_spec(char *trig_name, MudObject *the_primary,
            MudObject *the_secondary, Player *the_player, int obj_type);

   int list_specials(Player *the_player);
   virtual void write_object(FILE *the_file, int build_format);
   MudObject *get_loc_obj();

   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int copy_object(Entity *copy_obj);
   int     get_mem_size_mudobj();
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

   void            set_contained_by(MudObject *the_obj);

protected:

   Strings         title;
   Strings         desc;

   Inventory       inventory;   /* what the object contains */
   special_holder  *special_list;     /* the list of specials for this obj */
   Strings         specials;

private:


   MudObject       *contained_by;     /* pointer to the object that contains
                                         this object */
   int             capacity;          /* how much the object can hold */

   Strings         altnames;          /* alt names the object can have */
   Strings         location;          /* the object's current location */
   Strings         clones;           /* cloned objects containd in this */
   Strings         parent;

   Strings         keywords;

   unsigned long   next_cloned;       /* the next number to use for appending
                                         to a cloned object name */
   Status          the_status;
};

#endif

