#include <download_manager.h>

#include <sys/ioctl.h>
#include <signal.h>

#include <generic/acqprogress.h>

#include <sigc++/bind.h>
#include <sigc++/object_slot.h>

unsigned int screen_width=80;

void update_screen_width(int foo=0)
{
  // Ripped from apt-get, which ripped it from GNU ls
  winsize ws;

  if (ioctl(1, TIOCGWINSZ, &ws) != -1 && ws.ws_col >= 5)
    screen_width = ws.ws_col - 1;
}

static void dl_complete(download_manager &manager,
			AcqTextStatus *acqprogress)
{
  delete acqprogress;
}

download_manager *gen_cmdline_download_progress()
{
  download_manager *m=new download_manager;

  update_screen_width();
  // FIXME: put this in a shared init function.
  signal(SIGWINCH, update_screen_width);

  // FIXME: LEAK!!!!  (since the command-line stuff will only use this once
  // and then terminate, and killing this leak is a major pain, I'm
  // letting it by for now, but this MUST BE FIXED EVENTUALLY!)
  AcqTextStatus *acqprogress=new AcqTextStatus(screen_width, 0);

  m->MediaChange_sig.connect(slot(*acqprogress, &AcqTextStatus::MediaChange));
  m->IMSHit_sig.connect(slot(*acqprogress, &AcqTextStatus::IMSHit));
  m->Fetch_sig.connect(slot(*acqprogress, &AcqTextStatus::Fetch));
  m->Done_sig.connect(slot(*acqprogress, &AcqTextStatus::Done));
  m->Fail_sig.connect(slot(*acqprogress, &AcqTextStatus::Fail));
  m->Pulse_sig.connect(slot(*acqprogress, &AcqTextStatus::Pulse));
  m->Start_sig.connect(slot(*acqprogress, &AcqTextStatus::Start));
  m->Stop_sig.connect(slot(*acqprogress, &AcqTextStatus::Stop));
  m->Complete_sig.connect(bind(SigC::slot(dl_complete),
			       acqprogress));

  // FIXME: Maybe the AcqTextStatus should be deleted on Complete?
  //m->Complete_sig.connect(slot(acqprogress, &AcqTextStatus::Complete));

  return m;
}

