// download_item.cc
//
//  Copyright 1999, 2004, 2005 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "aptitude.h"

#include "download_item.h"

#include <apt-pkg/acquire-worker.h>
#include <apt-pkg/init.h> // For the APT version number.
#include <apt-pkg/strutl.h>

#include "vscreen/vs_tree.h"

int download_item::get_normal_attr()
{
  switch(item.Owner->Status)
    {
    case pkgAcquire::Item::StatIdle:
      return A_DIM|vs_treeitem::get_normal_attr();
    case pkgAcquire::Item::StatFetching:
      return vs_treeitem::get_normal_attr();
    case pkgAcquire::Item::StatDone:
      if(!hit)
	return get_color("Progress");
      else
	return get_color("DownloadHit");
    case pkgAcquire::Item::StatError:
      return get_color("Error");
    default:
      assert(0);
    }
}

void download_item::paint(vs_tree *win, int y, bool hierarchical)
  // A little confusing -- basically, there are two branches: either we display
  // a progress bar, or we don't.  If we don't, I can just display it as usual
  // (note, though, that I don't yet indent it according to the depth..); if we
  // do, a rather specialized set of code is called and then returns. (that's
  // the confusing bit :) )
{
  string output=((item.Owner->Status==pkgAcquire::Item::StatFetching)?item.ShortDesc:item.Description)+": ";
  int width,height;

  win->getmaxyx(height,width);

  switch(item.Owner->Status)
    {
    case pkgAcquire::Item::StatIdle:
      output+=_(" [Working]");
      break;
    case pkgAcquire::Item::StatFetching:
      if(worker==NULL)
	output+=_(" [Working]");
      else
	{
	  assert(worker->CurrentItem->Owner==item.Owner);

	  if(worker->TotalSize>0)
	    {
	      char intbuf[50]; // Waay more than enough.
	      int barsize=(width*worker->CurrentSize)/worker->TotalSize;
	      win->attrset(get_color("DownloadProgress"));

	      if(barsize>width)
		barsize=width;

	      win->attrset(get_normal_attr());
	      sprintf(intbuf,
		      "%sB/%sB",
		      SizeToStr(worker->CurrentSize).c_str(),
		      SizeToStr(worker->TotalSize).c_str());
	      output+=string(" [ ")+intbuf+" ]";
	      win->show_string_as_progbar(0,
					  y,
					  output,
					  get_color("DownloadProgress"),
					  get_normal_attr(),
					  barsize,
					  width);
	      return;
	    }
	  else
	    output+=_(" [Working]");
	}
      break;
    case pkgAcquire::Item::StatDone:
      output+=hit?_("[Hit]"):_("[Downloaded]");
      break;
    case pkgAcquire::Item::StatError:
      output+=item.Owner->ErrorText;
      break;
#if APT_PKG_MAJOR >= 3 && APT_PKG_MINOR >= 5
    case pkgAcquire::Item::StatAuthError:
      output+=item.Owner->ErrorText;
      break;
#endif
    }

  win->mvaddnstr(y, 0, output.c_str(), width);

  int newy,newx;
  win->getyx(newy, newx);
  if(newy!=y)
    return;
  for( ; newx<width; newx++)
    win->addch(' ');
}
