# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::completion;
use base 'AXP::Command::self';

sub shell_name {
	my $self = shift;
	return ref($self) eq __PACKAGE__? "several shells": $self->{name};
}

sub infoline {
	my $shell = shift()->shell_name;
	return "dump completion lines for $shell";
}

sub options {
	my $self = shift;
	return () if ref($self) eq __PACKAGE__;
	(
		compact => { sh => 'c', desc => "eliminate comments and empty lines" },
		output  => { sh => 'o', type => "=s", arg => 'FILE', desc => "write to FILE rather than stdout" },
	)
}

sub helptext {
	my $shell = shift()->shell_name;
	qq{
		Some shells allow the command completion feature that is very
		useful in a day to day work.  This script uses a declarative
		command hierarchy and has an ability to dump the information
		to complete its own subcommands and options.

		Use this command to generate completion info for $shell.
	}
}

use Arch::Util qw(save_file);

sub write ($$) {
	my $self = shift;
	my $output = shift;
	my %opt = %{$self->{options}};
	my $file = $opt{output} || "-";
	if ($opt{compact}) {
		$output =~ s/\s*\\\n\s*\n/\n/g;
		$output =~ s/(^|\n)[ \t]*(?:#[^\n]*)?\n+/$1/g;
	} else {
		my $cmd = $self->{prefix};
		my $shell = $self->shell_name;
		my $script_version = $self->script_version;
		my $comment = "# $shell completions for $script_version, "
			. "generated by '$cmd'";
		$output =~ s/^((?:#.*\n)*)/$1$comment\n/;
	}
	save_file($file, $output);
}

1;
