#!/bin/sh
# Install a database for an Axyl website. Note this is only expected
# to be run if you have previously installed Axyl and a valid
# /etc/axyl/axyl.conf exists.

# NOTE: This is not normally run standalone. The create-axyl-website.sh
# script usually runs this as part of what it does to set up a brand
# new Axyl website.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# This script requires that Axyl is properly installed. If it isn't
# then the following vars will not be defined, which is an error.
if [ "$AXUSER" = "" -o "$AXYL_DATA" = "" ]
then
  echo "ERROR: Axyl is not configured properly and one of AXUSER, and/or"
  echo "AXYL_DATA are undefined. Check /etc/axyl/axyl.conf exists and"
  echo "contains these settings. Otherwise, do you need to run script"
  echo "./setup-axyl.sh first?"
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# INCOMING PARAMETERS
#  $1  - INSTALLTYPE
#  $2  - DBTYPE
#  $3  - DBNAME
#  $4  - DBUSER
#  $5  - DBPASSWD ('none' means a blank password)
#  $6  - DBHOST ('direct' means a local database server)
#  $7  - DBPORT
#  $8  - META ('y' --> Install Metadata)
#  $9  - MICRO ('y' --> Install Microsites data)
#  $10 - AXVER (Axyl version, 'unknown' or 'n.n.n')
#  $11 - APFX (Application prefix)
#  $12 - DOCROOT (site docroot of website)
INSTALLTYPE=""
DBTYPE=""
DBNAME=""
DBUSER=""
DBPASSWD=""
DBHOST=""
DBPORT=5432
META="n"
MICRO="n"
AXVER=""
APFX=""
DOCROOT=""

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  INSTALLTYPE=$1
        ;;
    2)  DBTYPE=$1
        ;;
    3)  DBNAME=$1
        ;;
    4)  DBUSER=$1
        ;;
    5)  DBPASSWD=$1
        ;;
    6)  DBHOST=$1
        ;;
    7)  DBPORT=$1
        ;;
    8)  META=$1
        ;;
    9)  MICRO=$1
        ;;
   10)  AXVER=$1
        ;;
   11)  APFX=$1
        ;;
   12)  DOCROOT=$1
        ;;
  esac
  shift
done

if [ "$INSTALLTYPE" = "" -o "$AXUSER" = "" -o "$AXYL_HOME" = "" -o "$AXYL_DATA" = "" ]
then
  echo "ERROR: install-db.sh: parameters."
  echo "usage: install-db.sh empty|demo dbtype dbname dbuser [dbpasswd] [dbhost] [dbport] [axyl version] [app prefix] [docroot]"
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# CALL APPROPRIATE DATABASE INSTALLER

# DBTYPE values:
#     1 - Postgresql
#     2 - MySQL
#     3 - ODBC
#     4 - Oracle
#     5 - MS SQL Server
#     6 - Other
#
echo ""
echo "Axyl Database Installation"
case $DBTYPE in
  # Postgresql
  1)
    . ${AXYL_HOME}/db/postgres/install-db.sh $INSTALLTYPE $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $META $MICRO $AXVER $APFX $DOCROOT
    ;;
  # MySQL
  2)
    . ${AXYL_HOME}/db/mysql/install-db.sh $INSTALLTYPE $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $META $MICRO $AXVER $APFX $DOCROOT
    ;;
  # ODBC
  3)
    . ${AXYL_HOME}/db/odbc/install-db.sh $INSTALLTYPE $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $META $MICRO $AXVER $APFX $DOCROOT
    ;;
  # Oracle
  4)
    . ${AXYL_HOME}/db/oracle/install-db.sh $INSTALLTYPE $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $META $MICRO $AXVER $APFX $DOCROOT
    ;;
  # SQL Server
  5)
    . ${AXYL_HOME}/db/mssql_server/install-db.sh $INSTALLTYPE $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $META $MICRO $AXVER $APFX $DOCROOT
    ;;
  # Something else
  *)
    echo ""
    echo "*********************************************************************"
    echo "IMPORTANT NOTICE!"
    echo "You have chosen a database type which does not currently have an"
    echo "Axyl installer. At the present time we only provide an automatic"
    echo "installation process for Postgresql."
    echo ""
    echo "In the directory $AXYL_HOME/db/postgres you will find the Axyl core"
    echo "schema in 'axyl_core.sql'. This SQL definition may, with some editing,"
    echo "suit your database creation needs. Failing that, if you have the"
    echo "Sybase Powerdesigner package there is a PDM file which can be found"
    echo "in $AXYL_HOME/db, called 'axyl_core.pdm' which you could be used to"
    echo "produce a new definition."
    echo ""
    echo "Note also the file 'axyl_core_data.sql', is an SQL definition, which"
    echo "has the mandatory initial dataset for Axyl. This must be loaded."
    echo "*********************************************************************"
    echo -n "[ENTER] to continue.."
    read ANS
    ;;
esac

# END