#include <bakery/Utilities/BusyCursor.h>
#include <gtkmm/main.h>
#include <gtk/gtk.h>

namespace Bakery
{

BusyCursor::BusyCursor(Gtk::Window& window, Gdk::CursorType cursor_type)
: m_Cursor(cursor_type)
{
  m_refWindow = window.get_window();

  //Change the cursor:
  m_refWindow->set_cursor(m_Cursor);
  
  force_gui_update();
}

BusyCursor::~BusyCursor()
{
  //Restore the old cursor:
  m_refWindow->set_cursor();
  
  force_gui_update();
}


void BusyCursor::force_gui_update()
{
  //Force the GUI to update:
  while(Gtk::Main::events_pending())
    Gtk::Main::iteration();
}


} //namespace Bakery
