/* cmd-mv.c
 *
 ****************************************************************
 * Copyright (C) 2001, 2002, 2003, 2004  Tom Lord, Stefanie Tellex
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "config-options.h"
#include "hackerlab/cmd/main.h"
#include "hackerlab/fs/file-names.h"
#include "libarch/inv-ids.h"
#include "commands/rm.h"
#include "commands/version.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>




static t_uchar * usage = "[options] file...";

#define OPTS(OP) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_long_help, "H", 0, 0, \
      "Display a verbose help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string\n" \
      "and exit.")

t_uchar arch_cmd_rm_help[] = ("remove a file (or dir, or symlink) and its explicit inventory tag (if any)\n");

enum options
{
  OPTS (OPT_ENUM)
};

static struct opt_desc opts[] =
{
  OPTS (OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
arch_cmd_rm (t_uchar * program_name, int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;

  safe_buffer_fd (1, 0, O_WRONLY, 0);

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, libarch_version_string, arch_cmd_rm_help, opt_help_msg, opt_long_help, opt_version);
      if (o == opt_none)
        break;
      switch (o)
        {
        default:
          safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
          panic ("internal error parsing arguments");

        usage_error:
          opt_usage (2, argv[0], program_name, usage, 1);
          exit (1);

          /* bogus_arg: */
          safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
          goto usage_error;
        }
    }

  if (argc < 2)
    goto usage_error;



  {
    int a;

    for (a = 1; a < argc; ++a)
      {
        t_uchar * file;
	struct stat buf; 

        file = argv[a];

	safe_lstat(file, &buf);
	
	if (!S_ISDIR(buf.st_mode)) {
	  arch_delete_explicit_id (file);
	  safe_unlink(file);
	} else {
	  safe_printfmt (2, "attempt to remove directory %s\n", file);
	  exit (2);
	}
      }
  }




  return 0;
}


/*
 * tag:
 */
