#!/bin/sh

URL="http://ftp.de.debian.org/debian/"
DIR="/tmp/bootcd"

do_config()
{
cat >$DIR/etc/apt/sources.list <<EOI
deb http://ftp.de.debian.org/debian/ $DISTR main non-free contrib
deb http://non-us.debian.org/debian-non-US $DISTR/non-US main contrib non-free
deb http://security.debian.org/ $DISTR/updates main contrib non-free
EOI
cp /etc/fstab $DIR/etc/fstab
cp /etc/fstab $DIR/etc/mtab
}

do_config_lilo()
{
sed -e "s|^\([[:space:]]*initrd[[:space:]]*=\).*|\1/initrd.img|" $DIR/etc/lilo.conf >/tmp/lilo.tmp
cat /tmp/lilo.tmp > $DIR/etc/lilo.conf
rm -f /tmp/lilo.tmp
}

menu1()
{
  C1="toggel # $TOGGEL"
  C2="rm -rf $DIR"
  C3="mkdir -p $DIR"
  C4="debootstrap $DISTR $DIR $URL"
  C5="chroot $DIR mount /proc"
  C6="do_config"
  C7="cp /etc/lilo.conf $DIR/etc/"
  C8="chroot $DIR apt-get update "
  C9="chroot $DIR apt-get install lilo bootcd bootcd-i386 bootcd-mkinitrd"
  C10="chroot $DIR apt-get install $KERNEL "
  C11="do_config_lilo"
  C12="chroot $DIR bootcdmkinitrd -s"
  C13="chroot $DIR bootcdwrite -s"
  C14="chroot $DIR umount /proc"
  C15="exit"
  ITEMS=15
}

TOGGEL=""
toggel()
{
  if [ "$TOGGEL" = "sarge26" ]; then
    TOGGEL=sarge24
    DISTR=sarge
    KERNEL="kernel-image-2.4.8-2-686"
    menu1
  else
    TOGGEL=sarge26
    DISTR=sarge 
    KERNEL="kernel-image-2.6.8-2-686"
    menu1
  fi
}

toggel 

LCHOICE=""
DCHOICE=""
while :; do
  for i in $(seq 1 $ITEMS); do
    eval "echo \"($i) $(echo \$C$i)\""
  done
  echo -n "Your choice: "
  [ "$LCHOICE" ] && let DCHOICE=LCHOICE+1
  [ "$DCHOICE" ] && echo -n "($DCHOICE) "
  read A
  [ "$A" ] || A="$DCHOICE"
  for i in $(seq 1 $ITEMS); do
    if [ "$A" = "$i" ]; then
      LCHOICE="$i"
      eval "$(echo \$C$i)"
      echo -n "press RETURN"; read DUMMY
    fi
  done
done
