#ifndef _GLUENOTE_H_
#define _GLUENOTE_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Note;
class Part;
class Table;

/** This operation glues a note to its next neighbour
 */
class GlueNote : public Operation
{
 private:
  Part *  _part;
  Note *  _note;
  Note *  _next;
  Note * _delete;
  long _len;

 public:
  GlueNote(Note * nt, Part * pt);
  GlueNote(const GlueNote&);
  ~GlueNote();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
