#ifndef _ITERATOR_CPP_
#define _ITERATOR_CPP_

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "iterator.h"
#include "track.h"
#include "part.h"
#include "event.h"
#include "note.h"
#include "prPartEditor.h"

Iterator::Iterator(const Iterator& i) : _track(i._track), _part(i._part), _new_part(i._new_part), _event(i._event), _left(i._left), _right(i._right) { }

Iterator::Iterator(Track * tr, Position left, Position right) : _new_part(0), _event(0), _left(left), _right(right) {
  _track = tr;
  for (_part = (Part*) tr->first(); (_part != 0) && (_part->content()) && (_part->start((Event*)_part->last()) < _left); _part = (Part*) _track->next(_part)) {}
  if (_part) {
    for (_event = (Event*) _part->first(); (_event != 0) && (_part->start(_event) < _left); _event = (Event*) _part->next(_event)) { }
  }
  _new_part = _part;
}

Iterator::Iterator(Part * pt, Position left, Position right) : _new_part(pt), _event(0), _left(left), _right(right) {
  _track = 0;
  for (_part = pt; (_part != 0) && (_part->content()) && (_part->start((Event*)_part->last()) < _left); _part = (Part*) _track->next(_part)) {}
  if (_part) {
    for (_event = (Event*) _part->first(); (_event != 0) && (_part->start(_event) < _left); _event = (Event*) _part->next(_event)) { }
  }
  _new_part = _part;
}

Iterator::Iterator(PrPartEditor * editor) : _track(0), _new_part(0), _event(0) {
  for (_part = editor->part(); (_part != 0) && (_part->content()) && (_part->start((Event*)_part->last()) < editor->left()); _part = (Part*) _track->next(_part)) {}
  if (_part) {
    _left  = editor->left();
    editor->adjustRightPos();
    _right = editor->right();
    _track = _part->track();
    for (_event = (Event*) _part->first(); (_event != 0) && (_part->start(_event) < _left); _event = (Event*) _part->next(_event)) { }
  }
  _new_part = _part;
}

Iterator::~Iterator()
{
}

bool Iterator::operator!=(const Iterator& i) const {
  return (_part != i._part) || (_event != i._event);
}

bool Iterator::operator==(const Iterator& i) const {
  return (_part == i._part) && (_event == i._event);
}

bool Iterator::endsAt(long p) {
  if (!_event || !_part) return false;
  return _part->eventEndsAt(_event,p);
}

bool Iterator::startsAt(long p) {
  if (!_event || !_part) return false;
  return _part->eventStartsAt(_event,p);
}

bool Iterator::startsAfter(long p) {
  if (!_event || !_part) return false;
  return _part->eventStartsAfter(_event,p);
}

Element * Iterator::operator *() {
  return _event;
}

/* events are incremented in the following manner:
 * if there is a right limit (_right) (a track is specified in this case!), move on until this limit is reached. At the end of a part, move on to the next part.
 * if there is no right limit, but a track is specified move through all parts of that track.
 * if there is no right limit and no track specified, move through the specified part only.
 */
Iterator& Iterator::operator++() {
  if(!_event || !_part) {
    cerr << ("NO EVENT OR NO PART\n");
    return *this;
  }

  _event = (Event*) _part->next(_event);
  if(_event==0 && _track!=0) {
    _part = (Part*) _part->next(_part);
    if(_part) {
      _event = (Event*) _part->first();
      _new_part = _part;
    } // else _new_part = 0;
  } // else _new_part = 0;
  if (_event!=0 && _right!=0) {
    if (_part->start(_event) >= _right) _event = 0; // done!
  }
  return *this;
}

Iterator Iterator::operator++(int) {
  Iterator __tmp = *this;
  ++*this;
  return __tmp;
}

bool Iterator::done() const {
  return (_event==0);
}

Position Iterator::start() {
  if(!_event || !_part) return Position(0);
  return _part->start();
}

Part * Iterator::change() {
  Part * ret = _new_part;
  _new_part = 0;
  return ret;
}


#endif
