#ifndef _REMOVEFROMSELECTION_CPP_
#define _REMOVEFROMSELECTION_CPP_

#include <iostream.h>

#include "removeFromSelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

RemoveFromSelection::RemoveFromSelection(Reference * ref) : _ref(ref) {
  _type = REMOVEFROMSELECTION;
  _description = "remove from selection";
  _to_be_undone = false;
  if (selectioN) {
    for (Reference * r = _ref; r!=0; r = (Reference*) Element::next(r)) {
      cout << "rem" << endl;
      selectioN->removeEntry(r);
    }
  }
}


RemoveFromSelection::RemoveFromSelection(const RemoveFromSelection& el) : Operation(el) {
  _type = REMOVEFROMSELECTION;
  _ref = el._ref;
}

RemoveFromSelection::~RemoveFromSelection() {
  Reference * r1 = 0;
  for (Reference * r = _ref; r!=0; ) {
    r1 = (Reference*) Element::next(r);
    delete r;
    r = r1;
  }
}

void RemoveFromSelection::undo() {
  if (selectioN) {
    for (Reference * r = _ref; r!=0; r = (Reference*) Element::next(r))
      selectioN->add(r);
  }
}

void RemoveFromSelection::redo() {
  if (selectioN) {
    for (Reference * r = _ref; r!=0; r = (Reference*) Element::next(r))
      selectioN->remove(r);
  }
}



// ---------------
// virtuals:
//

ostream & RemoveFromSelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<REMOVEFROMSELECTION ref=\"" << _ref->ctype() << "\" />" << endl;
  return s;
}

void RemoveFromSelection::flush(const char * c) const {
  cout << c << "REMOVEFROMSELECTION" << endl;
}

Element * RemoveFromSelection::copy() const {
  return new RemoveFromSelection(*this);
}




#endif
