#ifndef _STRING_CPP_
#define _STRING_CPP_

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>

#include "str.h"

String::String() {
  _type = STRING;
  _value = 0;
}

String::String(const String& e) : Atoma(e,STRING) {
  _value = strdup(e.getValue());
}

String::String(const char * c) : _value(strdup(c)) {
  _type = STRING;
}

String::~String()
{
  free((void*)_value);
}


bool String::operator==(const String & s) {
  if (_value==0 && s._value==0) return true;
  else if (_value==0) return false;
  else if (s._value==0) return false;
  else
    return (strcmp(_value,s._value)==0);
}

bool String::operator==(const char * s) {
  if (_value==0 && s==0) return true;
  else if (_value==0) return false;
  else if (s==0) return false;
  else
    return (strcmp(_value,s)==0);
}

String String::operator+(const String & s) {
  if (_value==0 || strlen(_value)==0) return String(s); // ### this looks buggy!
  else if (s._value==0 || strlen(s._value)==0) return String(*this); // ### this looks buggy!
  else {
    char * x = new char(strlen(_value)+strlen(s._value));
    sprintf(x, "%s%s", _value, s._value);
    String *sx = new String((const char *) x);
    delete x;

    return *sx;
  }
}


ostream & String::print(int dep, ostream & s) const {
  s << spc(dep) << "<STRING value=\"" << _value << "\" />";
  return s;
}

void String::flush(const char * c) const {
  cout << c << "STRING " << _value << endl;

}

Element * String::copy() const {
  return new String(*this);
}


#endif
