#ifndef _KDEPART_H_
#define _KDEPART_H_

#include <qlabel.h>

#include "prPart.h"

class Part;
class QPopupMenu;
class QWidget;
class QButton;
class QPaintEvent;

class KdePart : public QLabel, public PrPart
{
  Q_OBJECT

 private:
  QWidget * mask;
  QPopupMenu * rbmenu;
  QPopupMenu * instPM;
  QPopupMenu * instPMs[16];
  // QPopupMenu * userDef;
  int instrument;
  int local_x;
  int local_y;
  int mask_x;
  int mask_y;
  int splitPoint;
  int trackOrd;
  void paintTrackName();
  void paintInstrument();
  void paintEvents();

 protected:
  Part * _part;

 public:
  KdePart(Part*);

  virtual void update(bool menu = false);
  virtual void erase();
  virtual void hide();
  virtual void show();

  Part * part();
  void buildMenu();

 public slots:
  void instMenu(int);
  void scoreEdit();
  void drumEdit();
  void eventEdit();
  void pianoRollEdit();
  void sampleEdit();
  void eventTimeEdit();
  void commentEdit();
  void waveEdit();
  void closeEditor();
  void deletePart();
  void testPart();
  void partCopy();
  void partGlue();
  void partSplit();
  void mousePressEvent ( QMouseEvent * );
  void mouseMoveEvent ( QMouseEvent * );
  void mouseReleaseEvent ( QMouseEvent * );
  void paintEvent( QPaintEvent * );
  void slotAddon(int);
};


#endif
