#include <ncurses.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"
#include "socket.h"
#include "parsecfg.h"
#include "server.h"
#include "keyb.h"
#include "screen.h"
#include "version.h"

extern int sock;
extern List roster;
extern int numbuddies;

void
exitcabber (void)
{
  DeleteList (roster);
  clear ();
  endwin ();
  exit (EXIT_SUCCESS);
}

int
main (void)
{
  char *response;
  char *inputline = malloc (MAXINPUT);
  char *idsession;
  char *filename = malloc (4096);
  int offset = 0;
  int selected = 0;
  int x;
  int curx, cury;
  int i;

  atexit (exitcabber);

  memset (inputline, 0, MAXINPUT);

  fprintf (stderr, "\n\r%s\n\r %s\n\r\n\r", VERSION, EMAIL);

  strncpy (filename, getenv ("HOME"), 1024);
  strcat (filename, "/.cabberrc");
  ReadCFGFile (filename);
  free (filename);
  fprintf (stderr, "\n\rConfig file parsed...\n\rInitializing NCurses...");

  InitCurses ();


  fprintf (stderr, "\n\rNcurses ok. Connecting...");

  ConnectToServer ();
  idsession = LogInServer ();
  free (idsession);
  DoScreen ();
  RequestRoster ();
  SetPresence ("Online!");
  DrawRoster (roster, offset, selected);

  mvprintw (LINES - 3, 1, "");
  for (i = 2; i < COLS - 2; i++)
    addch (' ');
  mvprintw (LINES - 3, 1, "<%s>: %s",
	    FindSelectedJidInList (selected, roster), inputline);

  refresh ();

  getyx (stdscr, cury, curx);


  while (1)			//Our main loop!
    {
      x = check_io (sock, 0);
      if ((x & 1) == 1)
	{
	  getyx (stdscr, cury, curx);
	  response = receivedata ();
	  checkdatafromserver (response, offset, selected);
	  free (response);
	  move (cury, curx);
	  refresh ();
	}
      if ((x & 2) == 2)
	{
	  switch (processinput (inputline, getch ()))
	    {
	    case KEY_DOWN:
	      selected++;
	      if (selected == numbuddies)
		selected = numbuddies - 1;
	      else if (selected - offset > LINES - 10)
		offset++;
	      DrawRoster (roster, offset, selected - offset);
	      break;

	    case KEY_UP:
	      selected--;
	      if (selected < 0)
		selected = 0;
	      if (selected - offset == -1)
		offset--;
	      DrawRoster (roster, offset, selected - offset);
	      break;

	    case ERETURN:
	      SendInputLine (inputline, offset, selected);
	      memset (inputline, 0, MAXINPUT);
	      break;

	    case EEXIT:
	      clear ();
	      refresh ();
	      endwin ();
	      exit (1);
	      break;
	    }
	  mvprintw (LINES - 3, 1, "");
	  for (i = 2; i < COLS - 2; i++)
	    addch (' ');
	  mvprintw (LINES - 3, 1, "<%s>: %s",
		    FindSelectedJidInList (selected, roster), inputline);
	  refresh ();
	}
    }
  return 1;
}
