/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          typedefs.h  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TYPEDEFS_H
#define TYPEDEFS_H

#include <iostream>
#include <stdio.h>
#include <string>

#include <math.h>

#define FUNCTION_SUCCESS 0
#define FUNCTION_FAILED -1

//#define DIR_SEPARATOR "/"

typedef unsigned char   Uint8;
typedef signed char     Sint8;
typedef unsigned short  Uint16;
typedef signed short    Sint16;
typedef unsigned int    Uint32;
typedef signed int      Sint32;
typedef long long 	Sint64;
typedef unsigned long long Uint64;
typedef unsigned char byte;


const char DEFAULT_COLOR[] =	"\033[0;40;39m";
const char LIGHT_BLUE[] =	"\033[01;32;34m";

#define ERROR(reason) do { \
	std::cout << "Error: "<< __FILE__ <<':'<< __LINE__ << ": " << reason << std::endl;\
} while (0)
#define WARN(reason) do { \
	std::cout << LIGHT_BLUE << "Warning: "<< __FILE__ << ':' << __LINE__ << ": " << reason << DEFAULT_COLOR << std::endl;\
} while(0)


	using std::string;
static inline string itostr(int m_val) {

	char cacabuffer[100];
	sprintf(cacabuffer,"%i",m_val);
 	return cacabuffer;
}

	
static inline int near2power(int m_val) {

	int bit=0;
	while (m_val)
		m_val&=~(1<<(bit++));
	return(1<<bit)>>1;
}


#define BOUND(bvar,bmin,bmax) (bvar>bmax)?bmax:(bvar<bmin)?bmin:bvar
#define NUM_2_THIRD_CHAR(num) ('0'+((num)/100) % 10)
#define NUM_2_SECOND_CHAR(num) ('0'+((num)/10) % 10)
#define NUM_2_FIRST_CHAR(num) ('0'+(num) % 10)
#define BITBOOL(m_exp) ((m_exp)?1:0)



#define OCTAVE 12

#endif

