/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      CompressionView : NSObject <PrefsViewProtocol>
 *
 *  Description:  This view contains compression protocols preferences
 *
 *  pppd options:
 *
 *  bsdcomp -------- BSD-Compress scheme (nr,nt level: 9-15)
 *  nobsdcomp    --- Disable
 *  deflate -------- Deflate  scheme (nr,nt level: 9-15)
 *  nodeflate    --- Disable
 *  noaccomp ------- Disable Address/Control compression
 *  noccp ---------- Disable CCP (Compression Control Protocol) negotiation
 *  nopcomp -------- Disable  protocol  field compression negotiation
 *  novj ----------- Disable Van Jacobson style TCP/IP header compresion
 *  novjccomp ------ Disable the connection-ID compression
 *  nopredictor1 --- Do not accept or agree to Predictor-1  compression
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSView;
@class NSBox;
@class NSButton;

@interface CompressionView : NSObject <PrefsViewProtocol>
{
  NSView              *view;
                      
  NSBox               *protocolsFrame;
  NSButton            *bsdButton;
  NSButton            *deflateButton;
  NSButton            *addressControlButton;
  NSButton            *CCPButton;
  NSButton            *protocolFieldButton;
  NSButton            *tcpipHeaderButton;
  NSButton            *connectionIDButton;
  NSButton            *predictor1Button;

  NSMutableDictionary *prefs;
}

@end
