/* main.h */
#ifndef MAIN_H
#define MAIN_H

#include <sys/types.h>

#include "config.h"

#define MAX_LOADS 20

/* if you change this, update string limit in parse_log() too */
#define MAX_UNAME 200

#define MAX_MEMINFO 200
#define DEF_LOG_FILE "contest.log"
#define DEF_TMP_FILE "dump"
#define SOURCE_TAR "linux.tar"
#define KERNEL 1
#define LOAD 2

struct load {
	char *load_name;
	int (*prep)(void);
	int (*do_load)(void);
	int (*cleanup)(void);
	char *logfile;
	int prep_done;
	pid_t child_pid;
	int pipe[2];
};

struct bench_results {
	char name[MAX_UNAME];
	unsigned long utime;
	unsigned long systime;
	unsigned long elapsed;
	unsigned long minor_faults;
	unsigned long major_faults;
	unsigned long loadruns;
};

struct ref_stats {
	char kernel[MAX_UNAME];
	double no_load_time;
	struct ref_stats *next;
};

typedef struct ref_stats * ref_stats_list;
#define INIT_REF_LIST	NULL

struct harvest {
	pid_t make;
	struct load *load;
};

extern struct harvest deadbeef;

#define harvester_add_load(ld)	do{\
						deadbeef.load=(ld);\
					}while(0)

#define harvester_del_load(ld)	do{\
						deadbeef.load=NULL;\
					}while(0)

#define harvester_add_child(pid)	do{\
						deadbeef.make=(pid);\
					}while(0)

#define harvester_del_child(pid)	do{\
						deadbeef.make=0;\
					}while(0)

#define ulong unsigned long

#ifdef USE_GMAKE
#define make_clean()	system("gmake clean >/dev/null 2>&1")
#else
#define make_clean()	system("make clean >/dev/null 2>&1")
#endif	/* USE_GMAKE */

void usage(void);
int clean_mem(void);
int write_res(char *fname, struct bench_results kern, struct bench_results load);
int comp_fields(const void *c, const void *d);
unsigned long toy_strtoul(char **str);
void err_if_unexpected(char **c, char ch);
inline int same_res(struct bench_results *kern, int i);
struct bench_results add_res(struct bench_results *a, struct bench_results *b);
struct bench_results div_res(struct bench_results *a, int num);
struct bench_results * parse_log(char *fname);
int gen_report(struct load *ld);
int do_preps(char **req_loads);
int prep_io_load(void);
int do_no_load(void);
int do_list_load(void);
int do_process_load(void);
int do_io_load(void);
int kill_load(struct load *ld);
struct bench_results load_get_stats(struct load *ld);
int est_elapsed(char *log);
int get_max_width(struct load *all);
int new_ref_stats(ref_stats_list *list, char *name, double time);
int get_ref_stats(ref_stats_list list, char *name, double *time);
void lose_ref_stats(ref_stats_list *list);
int  init_signals(void);
int restore_signals(void);
void harvester(int err);
inline void block_signals(void);
inline void unblock_signals(void);
#endif	/* MAIN_H */
