/* xtar_load.c */
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include "trivial.h"
#include "programs.h"
#include "ctar_load.h"	/* for cleanup_ctar_load */
#include "xtar_load.h"

static pid_t pid;

static volatile sig_atomic_t can_exit=0;

static void sig_term(int whatever gcc_unused);

int do_xtar_load(void)
{
	struct sigaction sa;

	sa.sa_handler=&sig_term;
	sigfillset(&sa.sa_mask);
	sa.sa_flags=SA_RESTART;
	for(;;){
		if((pid=fork())<0){
			printsys("fork error\n");
		} else if(!pid){	/* child */
			int dev_null;
			if((dev_null=open("/dev/null", O_WRONLY))==-1){
				printsys("could not open /dev/null for writing\n");
			}
			if(dup2(dev_null, STDOUT_FILENO)==-1){
				printsys("error redirecting stdout to /dev/null\n");
			}
			if(dup2(dev_null, STDERR_FILENO)==-1){
				printsys("error redirecting stderr to /dev/null\n");
			}
			if(execlp("tar", "tar", "xf", "linux-for-contest.tar", "-C", "temp/linux-for-contest", NULL)){
				printsys("error executing tar\n");
			}
		} else {	/* parent */
			sigaction(SIGTERM, &sa, NULL);
			if(wait4(pid, NULL, 0, NULL)!=pid){
				printsys("error waiting for pid %d\n", pid);
			}
			if(can_exit){
				printd("exiting\n");
				exit(0);
			}
			report_progress();
		}
	}
	return 0;
}

static void sig_term(int whatever gcc_unused)
{
	printd("killing process %d\n", pid);
	if(kill(pid, SIGTERM) && (errno!=ESRCH)){
		printsys("could not kill pid %d\n", pid);
	}
	can_exit=1;
	return;
}

int prep_xtar_load(void)
{
	struct stat buf;
	int ret;

	if(!stat("linux-for-contest.tar", &buf)){
			return 0;
	}
	if(errno!=ENOENT){
		printsys("error stating \"linux-for-contest.tar\"\n");
	}
	printf("Creating working tar for xtar_load\n");
	if((ret=system("tar cf linux-for-contest.tar --exclude temp --exclude "
			"linux-for-contest.tar --exclude linux.tar --exclude "
			" dump ./ > /dev/null 2>&1"))){
		printsys("error creating \"linux-for-contest.tar\", "
			"tar exit status is %d\n", ret);
	}
	return 0;
}	

int cleanup_xtar_load(void)
{
	return cleanup_ctar_load();
}
