/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000 The PHP Group                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors:                                                             |
   | Cristian Giussani                                                    |
   +----------------------------------------------------------------------+
 */

#include "php.h"
#include "php_ini.h"
#include "php_dbtcp.h"

#if HAVE_DBTCP

#include <protocol.h>

/*
#ifdef ZTS
int dbtcp_globals_id;
#else
ZEND_API php_dbtcp_globals dbtcp_globals;
#endif
*/

#define CHECK_DEFAULT_LINK(x) if (x == -1) { php_error(E_WARNING, "%s() no dbtcp link opened yet", get_active_function_name(TSRMLS_C)); RETURN_FALSE; }


ZEND_DECLARE_MODULE_GLOBALS(dbtcp)

/* True global resources - no need for thread safety here */
static int le_dbtcp;

/* Every user visible function must have an entry in dbtcp_functions[].
*/
function_entry dbtcp_functions[] = {
	PHP_FE( dbtcp_connect, NULL )
	PHP_FE( dbtcp_close, NULL )
	PHP_FE( dbtcp_sql, NULL )
    PHP_FE( dbtcp_fetch, NULL )
	PHP_FE( dbtcp_fetch_assoc, NULL )
    PHP_FE( dbtcp_field_info, NULL )
	PHP_FE( dbtcp_num_fields, NULL )
	PHP_FE( dbtcp_error, NULL )
	{NULL, NULL, NULL}	/* Must be the last line in dbtcp_functions[] */
};

zend_module_entry dbtcp_module_entry = {
#if PHP_API_VERSION >= 20010901
        STANDARD_MODULE_HEADER,
#endif
	"dbtcp",
	dbtcp_functions,
	PHP_MINIT(dbtcp),
	PHP_MSHUTDOWN(dbtcp),
	PHP_RINIT(dbtcp),		/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(dbtcp),	/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(dbtcp),
#if PHP_API_VERSION >= 20010901
    NO_VERSION_YET,
#endif
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_DBTCP
ZEND_GET_MODULE(dbtcp)
#endif

/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
PHP_INI_END()
*/

static void dbtcp_set_default_link(int id TSRMLS_DC )
{
	if ( DBTCP_G(default_link)!=-1 ) {
		zend_list_delete( DBTCP_G(default_link) );
	}
	DBTCP_G(default_link) = id;
	zend_list_addref(id);
}

static void _close_dbtcp_link (zend_rsrc_list_entry *rsrc TSRMLS_DC )
{
	dbftp_result *link = (dbftp_result *)rsrc->ptr;

	if ( link != NULL ) {
		free_dbftp_result(link);
	}
}

static void php_dbtcp_init_globals(zend_dbtcp_globals *dbtcp_globals )
{
	dbtcp_globals->default_link=-1;
}

PHP_MINIT_FUNCTION(dbtcp)
{
	ZEND_INIT_MODULE_GLOBALS(dbtcp, php_dbtcp_init_globals, NULL );

	le_dbtcp = zend_register_list_destructors_ex( _close_dbtcp_link, NULL, "dbtcp-link", module_number );

	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(dbtcp)
{
/* Remove comments if you have entries in php.ini
	UNREGISTER_INI_ENTRIES();
*/
	return SUCCESS;
}

/* Remove if there's nothing to do at request start */
PHP_RINIT_FUNCTION(dbtcp)
{
	DBTCP_G(default_link) = -1;
	return SUCCESS;
}

/* Remove if there's nothing to do at request end */
PHP_RSHUTDOWN_FUNCTION(dbtcp)
{
	return SUCCESS;
}

PHP_MINFO_FUNCTION(dbtcp)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "dbtcp support", "enabled");
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}

/* {{{ proto string dbtcp_connect(string dsn, string host[, string port])
   Connect to a remote datasource */
PHP_FUNCTION(dbtcp_connect)
{
	pval **dsn, **host, **port;
	dbftp_result *new_result;
	long id;
	int portnum;

	switch ( ZEND_NUM_ARGS() ) {
	case 2:
		if ( zend_get_parameters_ex ( 2, &dsn, &host ) == FAILURE ) {
			RETURN_FALSE;
		}
		portnum=DBTCP_DEFAULT_PORT;
		break;
	
	case 3:
		if (zend_get_parameters_ex(3, &dsn, &host, &port )==FAILURE) {
			RETURN_FALSE;
		}
		convert_to_string_ex( port );
		portnum=atoi( Z_STRVAL_PP( port ) );
		break;

	default:
		WRONG_PARAM_COUNT;
    }

	convert_to_string_ex( dsn );
	convert_to_string_ex( host );

	new_result = init_dbftp_result();
	if ( new_result != NULL ) {
		if ( dbftp_connect ( new_result, Z_STRVAL_PP( host ), 
							 portnum, Z_STRVAL_PP( dsn ) ) != OK ) {
			php_error(E_WARNING, "%s", dbftp_error_string(new_result));
			RETURN_FALSE;
		}
		else {
			ZEND_REGISTER_RESOURCE ( return_value, new_result, le_dbtcp );
			dbtcp_set_default_link( return_value->value.lval TSRMLS_CC );
		}
	}
}
/* }}} */

/* {{{ proto string dbtcp_close ( [ int id ] )
   Disconnect a previously connected DSN */
PHP_FUNCTION(dbtcp_close)
{
    zval **dbtcp_link=NULL;
    int id;
    dbftp_result *result;

    switch  ( ZEND_NUM_ARGS() ) {

    case 0:
                id=DBTCP_G(default_link);
                CHECK_DEFAULT_LINK(id);
                break;
    case 1:
        if (zend_get_parameters_ex( 1, &dbtcp_link )==FAILURE) {
            RETURN_FALSE;
        }
	id = -1;
	break;

    default:
        WRONG_PARAM_COUNT;
    }

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, dbtcp_link, id, "dbtcp-link", le_dbtcp );
    if ( id==-1) { /* explicit resource number */
		zend_list_delete( Z_RESVAL_PP( dbtcp_link ) );
        }

    if ( id!=-1
         || (dbtcp_link && Z_RESVAL_PP(dbtcp_link)==DBTCP_G(default_link))) {
                zend_list_delete( DBTCP_G(default_link) );
		DBTCP_G(default_link) = -1;
        }

    RETURN_TRUE;
}
/* }}} */


static void php_dbtcp_fetch_hash ( INTERNAL_FUNCTION_PARAMETERS, int result_type ) 
{
    dbftp_result *result;
    zval **id=NULL;
	int idmy;
	char *cptrdmy;
	int defid;

    switch  ( ZEND_NUM_ARGS() ) {

    case 0:
        defid=DBTCP_G(default_link);
        CHECK_DEFAULT_LINK(defid);
        break;

    case 1:
        if (zend_get_parameters_ex( 1, &id )==FAILURE) {
            RETURN_FALSE;
        }
        defid=-1;
        break;

    default:
        WRONG_PARAM_COUNT;
    }

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, id, defid, "dbtcp-link", le_dbtcp );

	if (array_init(return_value)==FAILURE) {
		RETURN_FALSE;
	}

	if ( dbftp_fetch_row ( result ) == OK ) {

		for ( idmy=0; idmy<dbftp_num_field(result); idmy++ ) {
			cptrdmy=dbftp_fetch_value ( result, idmy );
			if ( cptrdmy != NULL ) {
				switch ( result_type )
					{
					case DBTCP_NUM:
						add_index_string ( return_value, idmy, cptrdmy, 1 );
						break;

					case DBTCP_ASSOC:
						add_assoc_string ( return_value, dbftp_field_name ( result, idmy ), cptrdmy, 1 );
						break;
					}
			}
			else {
				add_index_unset ( return_value, idmy );
			}
		}
	}
	else {
		RETURN_FALSE;
	}
}

/* {{{ proto string dbtcp_fetch ( [ int id ] )
   Fetch a result row such as an array indexed by number */
PHP_FUNCTION(dbtcp_fetch)
{
	php_dbtcp_fetch_hash ( INTERNAL_FUNCTION_PARAM_PASSTHRU, DBTCP_NUM );
}
/* }}} */

/* {{{ proto string dbtcp_fetch_assoc ( [ int id ] )
   Fetch a result row such as an array indexed by field name */
PHP_FUNCTION(dbtcp_fetch_assoc)
{
    php_dbtcp_fetch_hash ( INTERNAL_FUNCTION_PARAM_PASSTHRU, DBTCP_ASSOC );
}
/* }}} */

/* {{{ proto string dbtcp_sql ( string query [, int link-id] )
   Send a query to a remote dbtcp server */
PHP_FUNCTION(dbtcp_sql)
{
    dbftp_result *result;
    zval **id=NULL,**query;
	int defid;

    switch  ( ZEND_NUM_ARGS() ) {

    case 1:
		if (zend_get_parameters_ex( 1, &query )==FAILURE) {
            RETURN_FALSE;
        }
        defid=DBTCP_G(default_link);
	CHECK_DEFAULT_LINK(defid);
        break;

    case 2:
        if (zend_get_parameters_ex( 2, &query, &id )==FAILURE) {
            RETURN_FALSE;
        }
        defid=-1;
        break;

    default:
        WRONG_PARAM_COUNT;
    }

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, id, defid, "dbtcp-link", le_dbtcp );
	convert_to_string_ex( query );

	if ( Z_STRVAL_PP(query) != NULL ) {
		if ( dbftp_sql ( result, Z_STRVAL_PP(query) ) == OK ) {
			RETURN_TRUE;
		}
		else {
			RETURN_FALSE;
		}
	}
		
}
/* }}} */

/* {{{ proto string dbtcp_field_info ( int field [, int link-id ] )
   Returns ( name, type, length ) of the field-th field in the result set */
PHP_FUNCTION(dbtcp_field_info)
{
    dbftp_result *result;
    zval **id=NULL,**field=NULL;
	char *cptrdmy,type[2];
	int num_field;
	int defid;

    switch  ( ZEND_NUM_ARGS() ) {

    case 1:
		if (zend_get_parameters_ex( 1, &field )==FAILURE) {
            RETURN_FALSE;
        }
        defid=DBTCP_G(default_link);
        CHECK_DEFAULT_LINK(defid);
        break;

    case 2:
        if (zend_get_parameters_ex( 2, &field, &id )==FAILURE) {
            RETURN_FALSE;
        }
        defid=-1;
        break;

    default:
        WRONG_PARAM_COUNT;
    }

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, id, defid, "dbtcp-link", le_dbtcp );

	if (array_init(return_value)==FAILURE) {
        RETURN_FALSE;
    }

	convert_to_string_ex( field );
	num_field = atoi(Z_STRVAL_PP(field));

	/* Field name, if name == NULL something is wrong !!!*/
	cptrdmy=dbftp_field_name( result, num_field );
	if ( cptrdmy != NULL )
        {
		add_index_string ( return_value, 0, cptrdmy, 1 );

		/* Field type */
		type[0]=( char )dbftp_field_type ( result, num_field );
		type[1]=0x00;
		add_index_stringl ( return_value, 1, type, 1, 1 );

		/* Field length */
		add_index_long ( return_value, 2, dbftp_field_len ( result, num_field ) );
	}
	else
		RETURN_FALSE;
}
/* }}} */


/* {{{ proto string dbtcp_num_fields ( [ int id ] )
   Returns the number of the fields in the result set*/
PHP_FUNCTION(dbtcp_num_fields)
{
    dbftp_result *result;
    zval **id=NULL;
    int defid;

    switch  ( ZEND_NUM_ARGS() ) {

    case 0:
        defid=DBTCP_G(default_link);
   	CHECK_DEFAULT_LINK(defid);
        break;

    case 1:
        if (zend_get_parameters_ex( 1, &id )==FAILURE) {
            RETURN_FALSE;
        }
        defid=-1;
        break;

    default:
        WRONG_PARAM_COUNT;
    }

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, id, defid, "dbtcp-link", le_dbtcp );

    RETURN_LONG( dbftp_num_field(result) );
}
/* }}} */

/* {{{ proto string dbtcp_error ( [ int id ] )
   Returns the error string */
PHP_FUNCTION(dbtcp_error)
{
    dbftp_result *result;
    zval **id=NULL;
    int defid;

    switch  ( ZEND_NUM_ARGS() ) {

	case 0:
		defid=DBTCP_G(default_link);
		CHECK_DEFAULT_LINK(defid);
		break;
		
	case 1:
		if (zend_get_parameters_ex( 1, &id )==FAILURE) {
			RETURN_FALSE;
		}
		defid=-1;
		break;

	default:
		WRONG_PARAM_COUNT;
	}

    ZEND_FETCH_RESOURCE ( result, dbftp_result *, id, defid, "dbtcp-link", le_dbtcp );
    RETURN_STRING( dbftp_error_string( result ), 1 );
}
/* }}} */


#endif	/* HAVE_DBTCP */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */


