/******************************************************************************
Definizioni per il protocollo DBFTP
 *****************************************************************************/
#ifndef DBFTP_PROTOCOL
#define DBFTP_PROTOCOL

#include <my_string.h>
#include <my_bstring.h>

/* --------------------------------------------------------------- Strutture */
typedef struct _my_fields {
  MY_STRING name;
  int length;
  int type;
} my_fields;


typedef struct _dbftp_result {

  /* Network communication */
  int sock;                /* Socket used to connect to the server */
  MY_BSTRING *net_buf;     /* Buffer for network comunication */

  /* Results from the remote server */
  MY_STRING *dsn;    /* DSN connect string */
  MY_STRING *error;  /* Error string from the remote server */
  int errorno;

  struct MY_ARRAY *field;  /* Result set field structure */
  struct MY_ARRAY *cols;   /* Result set actual row */
  int num_fields;

} dbftp_result;

/* ---------------------------------------------------------------- Funzioni */
dbftp_result *init_dbftp_result ( void );
int free_dbftp_result ( dbftp_result *myresults );

int dbftp_connect ( dbftp_result *myres, char *host, int port, char *dsn );
int dbftp_sql ( dbftp_result *myres, char *query );
int dbftp_fetch_row ( dbftp_result *myres );
int dbftp_close ( dbftp_result *myres );
void dbftp_set_error ( dbftp_result *myres, char *string, int len );

int dbftp_fetch_fields ( dbftp_result *myres );
char *dbftp_field_name ( dbftp_result *myres, int field );
int dbftp_field_len ( dbftp_result *myres, int field );
int dbftp_field_type ( dbftp_result *myres, int field );
char *dbftp_fetch_value ( dbftp_result *myres, int col );

#define dbftp_num_field(A) A->num_fields
#define dbftp_error_string(A) string_ptr(A->error)

#define DBTCP_DEFAULT_PORT 3000

/* Return values */
#define ON                 1
#define OK                 0
#define ERR               -1

#define FETCH_OK           0
#define FETCH_ERROR       -1
#define FETCH_EOF          1

/* Client command code */
#define CLN_CMD_CONNECT    1      // Connect
#define CLN_CMD_SQL        2      // Execute SQL
#define CLN_CMD_FETCH_F    5      // Fetch result set fields info
#define CLN_CMD_FETCH      6      // Fetch next row in result set

/* Server return code */
#define SRV_CMD_ERROR     50      // Generic Error
#define SRV_CMD_SUCCESS   51      // Success
#define SRV_FETCH_EOF     52      // Fetch: end of records
#define SRV_CMD_UNDEFINED 53      // Server: command id undefined
#define SRV_FETCH_RESULT  54      // Fetch: packet is a data record
#define SRV_FETCH_FIELDS  55      // Fetch: packet is fields description
#define SRV_CMD_NO_DATA   56      // Sql: Query has no result

#endif

