/*****************************************************************************
Modulo string.c 
(C) 1998 Giussani Cristian Fastflow Srl
Routine di manipolazione di stringhe con allocazione dinamica della
lunghezza.
Routine esportate:
*****************************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <my_bstring.h>
#include <define.h>

/* 
   Attenzione non controlla che la stringa sia gia' allocata 
 */
int bstring_init ( MY_BSTRING *stringa, ulong len_inizio, ulong incremento, char *valore, ulong val_len )
{
  ulong inizio;

  if (incremento == 0)
    stringa->increment = 128;
  else
    stringa->increment = incremento;

  if ( valore != NULL )
    {
      if ( val_len == 0 )
	val_len = strlen ( valore );
    }
  else
    val_len=0;
  
  if (len_inizio < (val_len + stringa->increment))
    inizio = val_len + stringa->increment;
  else
    inizio = val_len;

  if (((stringa->string) = malloc (inizio)) == NULL)
    return (ERR);

  stringa->length = val_len;
  stringa->max_length = inizio;

  if (valore != NULL)
    memcpy (stringa->string, valore, val_len);
  
  return (OK);
}

/******************************************************************************
int bstring_append ( MY_BSTRING *stringa, char *altra, ulong length )
- Accoda una strina ad un'altra
- Se uso altra=NULL e length!=0 -> alloca spazio per poter inserire almeno length caratteri
 *****************************************************************************/
int bstring_append ( MY_BSTRING *stringa, char *altra, ulong length )
{
  char *newptr;

  if ( altra != NULL )
    {
      if (length == 0)
	length = strlen ( altra );
    }

  if (stringa->max_length <= (stringa->length) + length )
    {
      newptr = (char *) malloc (stringa->max_length + length + stringa->increment);
      if (newptr == NULL)
	{
	  /* Il blocco di memoria non e' stato toccato */
	  printf ("Errore allocazione di memoria\n");
	  return (ERR);
	}
      memcpy (newptr, stringa->string, stringa->length);
      free (stringa->string);
      stringa->string = newptr;
      stringa->max_length += length + stringa->increment;

    }
 
  if ( altra != NULL )
    {
      memcpy (&(stringa->string[stringa->length]), altra, length);
      stringa->length += length;
    }

  return ( OK );
}

/******************************************************************************

 *****************************************************************************/
int bstring_free ( MY_BSTRING *stringa )
{
  if (stringa->max_length != 0)
    {
      free (stringa->string);
      stringa->string = NULL;
      stringa->length = 0;
      stringa->max_length = 0;
    }

  return (OK);
}

/******************************************************************************
int string_replace ( MY_STRING *string, char *find, char *replace )
Cerca la stringa 'find' e la sostituisce con 'replace' nella stringa dinamica 'string'.
Valori restituiti:
                   0 - Nessuna sostituzione
                  >0 - Numero delle sostituzioni effettuate
 *****************************************************************************/
/*
int string_replace ( MY_STRING *string, char *find, char *replace )
{
  MY_STRING new;
  char *source, *pnt;
  int len_find,len_replace,idx;

  if ( ( string->string != NULL ) &&
       ( find != NULL ) &&
       ( replace != NULL ) )
    {
      string_init ( &new, string_length(string), 256, string->string );
      string_clear ( &new );

      len_find=strlen(find);
      len_replace=strlen(replace);
      idx=0;
      source=string->string;
      while ( (pnt=strstr( source, find )) != NULL )
        {
	  Copia la parte prima della stringa e attacca la sostituzione 
	  string_append ( &new, source, (pnt-source) );
	  string_append ( &new, replace, len_replace );
          source = pnt+len_find;
	  idx++;
        }

      if ( idx != 0 )
	{
	  Ho fatto delle sostituzioni 
	  string_append ( &new, source, 0 );
	  string_free ( string );
	  memcpy ( string, &new, sizeof ( MY_STRING ) );
	  return ( idx );
	}
      else
	{
	  Non ho fatto delle sostituzione 
	  string_free ( &new );
	}

    }
  
  return ( 0 );
}

	  */
