/* exit.c - Exit routines and help messages for deborphan
   Copyright (C) 2000, 2001, 2002, 2003 Cris van Pelt
   Copyright (C) 2003, 2004 Peter Palfrader

   $Id: exit.c 483 2004-07-13 17:43:53Z weasel $

   Distributed under the terms of the Artistic License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <deborphan.h>

#ifdef HAVE_ERRNO_H
#  include <errno.h>
extern int errno;
#endif

#ifdef ENABLE_NLS
#  include <libintl.h>
#endif

#ifdef USE_XALLOC
#  include <xalloc.h>
#endif

/* The calling program should set this. */
extern char *program_name;

/* Print an error message stating the program name, an optional,
   user defined string and an error message as produced by strerror(error_no). 
   If exit_status is non-nil, the program will terminate. */
void
error(int exit_status, int error_no, const char *format, ...)
{
    va_list args;
    va_start(args, format);

    fprintf(stderr, "%s", program_name);
    if (format != NULL) {
	fprintf(stderr, ": ");
	vfprintf(stderr, format, args);
    }
    va_end(args);

    if (error_no)
	fprintf(stderr, ": %s\n", strerror(error_no));
    else
	fprintf(stderr, "\n");

    fflush(stderr);

    if (exit_status)
	exit(exit_status);
}

void
exit_help()
{
    print_usage(stdout);

    printf(_("\nThe following options are available:\n"));
    /* General option */
    printf("--help,           ");
    printf(_("-h        This help.\n"));

    printf("--version,        ");
    printf(_("-v        Version information.\n"));

    printf("--status-file,    ");
    printf(_("-f FILE   Use FILE as statusfile.\n"));


    /* output modifiers */
    printf("--show-deps,      ");
    printf(_("-d        Show dependencies for packages that have them.\n"));

    printf("--show-priority,  ");
    printf(_("-P        Show priority of packages found.\n"));

    printf("--show-size,      ");
    printf(_("-z        Show installed size of packages found.\n"));

    printf("--show-section,   ");
    printf(_("-s        Show the sections the packages are in.\n"));

    printf(_("--no-show-section           Do not show sections.\n"));


    /* search modifiers */
    printf("--nice-mode,      ");
#ifdef DEFAULT_NICE
    printf(_("-n        Disable checks for `recommends' and `suggests'.\n"));
#else
    printf(_("-n        Enable checks for `recommends' and `suggests'.\n"));
#endif

    printf("--all-packages,   ");
    printf(_("-a        Compare all packages, not just libs.\n"));

    printf(_("--libdevel                  Search in libdevel in addition to libs and oldlibs.\n"));

    printf("--exclude,        ");
    printf(_("-e LIST   Work as if packages in LIST were not installed.\n"));

    printf("--priority,       ");
    printf(_("-p PRIOR  Select only packages with priority >= PRIOR.\n"));

    printf("--force-hold,     ");
    printf(_("-H        Ignore hold flags.\n"));

    printf(_("--find-config               Find \"orphaned\" configuration files.\n"));


    /* keep file management */
    printf("--add-keep,       ");
    printf(_("-A PKGS.. Never report PKGS.\n"));

    printf("--del-keep,       ");
    printf(_("-R PKGS.. Report PKGS if there are no dependencies.\n"));

    printf("--list-keep,      ");
    printf(_("-L        List the packages that are never reported.\n"));

    printf("--zero-keep,      ");
    printf(_("-Z        Remove all packages from the \"keep\" file.\n"));

    printf("--keep-file,      ");
    printf(_("-k FILE   Use FILE to get/store info about kept packages.\n"));

#ifdef DEBFOSTER_KEEP
    printf(_("--df-keep                   Read debfoster's \"keepers\" file.\n"));
    printf(_("--no-df-keep                Do not read debfoster's \"keepers\" file.\n"));
#endif

    /* guessing */

    printf(_("--guess-perl                Try to report perl libraries.\n"));
    printf(_("--guess-python              Try to report python libraries.\n"));
    printf(_("--guess-pike                Try to report pike libraries.\n"));
    printf(_("--guess-ruby                Try to report ruby libraries.\n"));
    printf(_("--guess-interpreters        Try to report interpreter libraries.\n"));

    printf(_("--guess-section             Try to report libraries in wrong sections.\n"));
    printf(_("--guess-dev                 Try to report development packages.\n"));
    printf(_("--guess-debug               Try to report debugging libraries.\n"));
    printf(_("--guess-common              Try to report common packages.\n"));
    printf(_("--guess-data                Try to report data packages.\n"));
    printf(_("--guess-doc                 Try to report documentation packages.\n"));
    printf(_("--guess-dummy               Try to report dummy packages.\n"));
    printf(_("--guess-all                 Try all of the above.\n"));
    printf(_("--guess-only                Use --guess options only.\n"));

    printf(_("\n\
See also: deborphan(1), orphaner(8)\n\
Report bugs to: Peter Palfrader <weasel@debian.org>\n"));

    exit(EXIT_SUCCESS);
}

void
exit_version()
{
    printf(_("\
%s %s - Find packages without other packages depending on them\n\
Distributed under the terms of the Artistic License.\n\
\n\
THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR\n\
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED\n\
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n\
\n\
Copyright (C) 2000 - 2003 Cris van Pelt <\"Cris van Pelt\"@tribe.eu.org>.\n\
Copyright (C) 2003, 2004 Peter Palfrader <weasel@debian.org>.\n"), PACKAGE, VERSION);

    exit(EXIT_SUCCESS);
}

void
print_usage(FILE * output)
{
    fprintf(output, _("Usage: %s [OPTIONS] [PACKAGE]...\n"), program_name);
}
