<?xml version="1.0"?>

<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
     xmlns:tml="http://helm.cs.unibo.it/2002/TML"
     xmlns:m="http://www.w3.org/1998/Math/MathML"
     version="1.0">

  <xsl:output method="text" indent="yes"/>

  <xsl:param name="id" select="/.."/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$id">
        <xsl:apply-templates select="descendant::*[@id=$id]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="*[@id]">{\id{<xsl:value-of select="@id"/>}{<xsl:apply-templates select="." mode="core"/>}}</xsl:template>

  <xsl:template match="*"><xsl:apply-templates select="." mode="core"/></xsl:template>

  <xsl:template match="tml:tex">
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="tml:math[@id]">
    <xsl:choose>
      <xsl:when test="@display='1'">$${\id{<xsl:value-of select="@id"/>}{<xsl:apply-templates select="*" mode="core"/>}}$$</xsl:when>
      <xsl:otherwise>${\id{<xsl:value-of select="@id"/>}{<xsl:apply-templates select="*" mode="core"/>}}$</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="tml:math">
    <xsl:choose>
      <xsl:when test="@display='1'">$$<xsl:apply-templates select="*"/>$$</xsl:when>
      <xsl:otherwise>$<xsl:apply-templates select="*"/>$</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:i" mode="core">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:n" mode="core">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:o" mode="core">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:s" mode="core">
    <xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template match="tml:sb" mode="core">
    <xsl:choose>
      <xsl:when test="@under='1'">
        <xsl:apply-templates select="*[1]"/>__<xsl:apply-templates select="*[2]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*[1]"/>_<xsl:apply-templates select="*[2]"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:sp" mode="core">
    <xsl:choose>
      <xsl:when test="@over='1'">
        <xsl:apply-templates select="*[1]"/>^^<xsl:apply-templates select="*[2]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*[1]"/>^<xsl:apply-templates select="*[2]"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:g" mode="core">{<xsl:apply-templates select="*"/>}</xsl:template>

  <xsl:template match="tml:row" mode="core">
    <xsl:apply-templates select="cell"/>\cr </xsl:template>

  <xsl:template match="tml:cell" mode="core">
    <xsl:apply-templates select="*"/>
    <xsl:if test="position() &lt; last()">&amp;</xsl:if>
  </xsl:template>

<!--/// CONTROL SEQUENCES ///-->

  <xsl:template match="tml:c[*[1][self::tml:g[@left-open='1']]]" mode="core">
    <xsl:apply-templates select="*[1]"/>\<xsl:value-of select="@name"/>
    <xsl:if test="*[2][self::tml:i]"><xsl:value-of select="' '"/></xsl:if>
    <xsl:apply-templates select="*[position()&gt;1]"/>
  </xsl:template>

  <xsl:template match="tml:c" mode="core">\<xsl:value-of select="@name"/>
    <xsl:if test="*[1][self::tml:i]"><xsl:value-of select="' '"/></xsl:if>
    <xsl:apply-templates select="*"/>
  </xsl:template>

</xsl:stylesheet>

