/* $Id: SymInh.c,v 1.3 1997/01/06 13:20:17 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "SymInh.h"
#include "List.h"
#include "Bool.h"
#include "Consts.h"
#include "AttrDefs.h"
#include "Names.h"

#include "LIGA.h"
#include "LIGAMacros.h"
#include "liga_func.h"
#include "lookup_idl.h"
#include "ligaconsts.h"
#include "msgtxt.h"

static
int InheritsFrom (Key, FromList)
	DefTableKey	Key;
	TList	FromList;
{	DefTableKey	FromKey;
	TList	ItsList;

while (FromList != NullList) {
	FromKey = (DefTableKey)HeadList (FromList);
	if (Key == FromKey) return (true);
	ItsList = GetInhFrom (FromKey, NullList);
	if (InheritsFrom (Key, ItsList))
		return (true);
	FromList = TailList (FromList);
}
return (false);
}/*InheritsFrom*/

int EnterInherit (To, From, Coord)
	DefTableKey		To, From;
	POSITION	*Coord;
{	TList	ToFrom, newToFrom, FromTo, FromFrom;

if (From == To) {
	message (ERROR,MSGTXT( "Inheritance to itself",
			      (lidoref)Inheritance of Computations), 0, Coord);
	return (false);
}
FromFrom = GetInhFrom (From, NullList);
if (InheritsFrom (To, FromFrom)) {
	message (ERROR,MSGTXT("Cyclic inheritance",
			      (lidoref)Inheritance of Computations), 0, Coord);
	return (false);
}

ToFrom = GetInhTo (From, NullList);
newToFrom = AddToSetList (To, ToFrom);
if (newToFrom == ToFrom) return (true);
SetInhTo (From, newToFrom, newToFrom);

FromTo = ConsList (From, GetInhFrom (To, NullList));
SetInhFrom (To, FromTo, FromTo);
return (true);
}/*EnterInherit*/

static POSITION	NoPos;
static Environment	toscope;
static int		toroot;

static
void InheritAttrsFromSymb (fromkey)
	DefTableKey		fromkey;
{	Scope		scdefs;
	Environment	env;
	DefTableKey	k;
	int		id, tp, cl;
	POSITION	*pos;

env = GetAttrScope (fromkey, NoEnv);
scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	id = IdnOf (scdefs);
	tp = GetAttrType (k, DIDNON);
	cl = GetAttrClass (k, ATCLUNKN);
	if (toroot) cl = ATCLSYNT;
	pos = GetCoord (k, &NoPos);
	(void)DeclareExplAttr (toscope, id, tp, cl, pos);	
	scdefs = NextDefinition (scdefs);
}
}/*InheritAttrsFromSymb*/

static
void InheritAllAttrs (inhlist)
	TList	inhlist;
{	DefTableKey	fromkey;
while (inhlist != NullList) {
	fromkey = (DefTableKey)HeadList (inhlist);
	InheritAttrsFromSymb (fromkey);
	InheritAllAttrs (GetInhFrom (fromkey, NullList));
	inhlist = TailList (inhlist);
}
}/*InheritAllAttrs*/

static
void InheritAttrs (symkey)
	DefTableKey	symkey;
{	
NoPos.line = 0;
NoPos.col = 0;

toroot = GetIsRoot (symkey, false);
toscope = GetAttrScope (symkey, NoEnv);
InheritAllAttrs (GetInhFrom (symkey, NullList));
}/*InheritAttrs*/

void AllSymbInheritAttrs (env) Environment env;
{ Scope scdefs = DefinitionsOf (env);
  while (scdefs != NoScope)
  {  DefTableKey symkey = KeyOf (scdefs);
     if (GetAttrScope (symkey, NoEnv) != NoEnv) /* is a symbol */
        InheritAttrs (symkey);
     scdefs = NextDefinition (scdefs);
  }
}/* AllSymbInheritAttrs */

int InSymbattrs (symdid, atdid, attrlist, coord)
	int		symdid, atdid;
	SEQSymbattr	attrlist;
	POSITION	*coord;
{	Symbattr	syat;

foreachinSEQSymbattr (attrlist, attrlist, syat) {
	if (symdid == symbdefOfSymbattr (syat)) {
		if (atdid != attrdefOfSymbattr (syat)) {
			message (ERROR,		
	MSGTXT("Remote access to two attributes of one symbol",
	       (lidoref)Remote Attribute Access), 0, coord);
		}
		return (true);
	}
}
return (false);
}/*InSymbattrs*/


SEQSymbattr MapToRealSymbattrs (symkey, attrid, attrlist,coord)
	DefTableKey	symkey;
	int 		attrid;
	SEQSymbattr	attrlist;
	POSITION	*coord;
{	TList		inhto;
	int		symdid, atdid, attp, atcl;
	POSITION	*atcoord;
	Environment	attrscope;
	DefTableKey	attrkey;

/* symkey has attrid in its attrscope */
attrscope = GetAttrScope (symkey, NoEnv);
attrkey = KeyInScope (attrscope, attrid);
attp = GetAttrType (attrkey, DIDNON);
atcl = GetAttrClass (attrkey, ATCLUNKN);
atcoord = GetCoord (attrkey, coord);

if (GetRealSym (symkey, false)) {
	symdid = GetDid (symkey, DIDNON);
	atdid = GetDid (attrkey, DIDNON);
	if (!InSymbattrs (symdid, atdid, attrlist, coord))
		attrlist =
		AppFrontSEQSymbattr (MkSymbattr (
			symdid, atdid),
			attrlist);
}
inhto = GetInhTo (symkey, NullList);
while (inhto != NullList) {
	symkey = (DefTableKey)HeadList (inhto);
	attrscope = GetAttrScope (symkey, NoEnv);
	(void)DeclareExplAttr (attrscope, attrid, attp, atcl, atcoord);
	attrlist =
	MapToRealSymbattrs (symkey, attrid, attrlist, coord);
	inhto = TailList (inhto);
}
return (attrlist);
}/*MapToRealSymbattrs*/

static
int InSymbExprs (symdid, exprs)
	int		symdid;
	SEQExpr		exprs;
{	Expr		exp;

foreachinSEQExpr (exprs, exprs, exp) {
	if (symdid == vOfVal (ExprToVal (exp)))
		return (true);
}
return (false);
}/*InSymbExprs*/


SEQExpr MapToRealSyms (symkey, exprs, coord)
	DefTableKey	symkey;
	SEQExpr		exprs;
	POSITION	*coord;
{	TList		inhto;
	int		symdid;

if (GetRealSym (symkey, false)) {
	symdid = GetDid (symkey, DIDNON);
	if (!InSymbExprs (symdid, exprs))
		exprs =
		AppFrontSEQExpr (ValToExpr (MkVal (
			symdid, coord->line, coord->col)),
			exprs);
}
inhto = GetInhTo (symkey, NullList);
while (inhto != NullList) {
	symkey = (DefTableKey)HeadList (inhto);
	exprs =
	MapToRealSyms (symkey, exprs, coord);
	inhto = TailList (inhto);
}
return (exprs);
}/*MapToRealSyms*/

