#ifndef IFDHANDLER_H
#define IFDHANDLER_H

#include <wintypes.h>
#include <pcsclite.h>

typedef struct _SCARD_IO_HEADER {
	DWORD Protocol;
	DWORD Length;
} SCARD_IO_HEADER, *PSCARD_IO_HEADER;

#define IFD_SUCCESS                     0

#define IFD_POWER_UP                    500
#define IFD_POWER_DOWN                  501
#define IFD_RESET                       502

#define IFD_ERROR_TAG                   600
#define IFD_ERROR_NOT_SUPPORTED         606
#define IFD_PROTOCOL_NOT_SUPPORTED      607
#define IFD_ERROR_POWER_ACTION		608
#define IFD_COMMUNICATION_ERROR         612
#define IFD_NOT_SUPPORTED               614
#define IFD_ICC_PRESENT                 615

RESPONSECODE IFDHCreateChannel(DWORD Lun, DWORD Channel);
RESPONSECODE IFDHCloseChannel(DWORD Lun);
RESPONSECODE IFDHGetCapabilities(DWORD Lun, DWORD Tag,
				 PDWORD Length, PUCHAR Value);
RESPONSECODE IFDHSetCapabilities(DWORD Lun, DWORD Tag,
				 DWORD Length, PUCHAR Value);
RESPONSECODE IFDHSetProtocolParameters(DWORD Lun, DWORD Protocol,
				       UCHAR FLAGS, UCHAR PTS1, UCHAR PTS2,
				       UCHAR PTS3);
RESPONSECODE IFDHPowerICC(DWORD Lun, DWORD Action, PUCHAR Atr,
			  PDWORD AtrLength);
RESPONSECODE IFDHControl(DWORD Lun, PUCHAR TxBuffer, DWORD TxLength,
			 PUCHAR RxBuffer, PDWORD RxLength);
RESPONSECODE IFDHICCPresence(DWORD Lun);
RESPONSECODE IFDHTransmitToICC(DWORD Lun, SCARD_IO_HEADER SendPci,
			       PUCHAR TxBuffer, DWORD TxLength,
			       PUCHAR RxBuffer, PDWORD RxLength,
			       PSCARD_IO_HEADER RecvPci);

#endif				/* IFDHANDLER_H */
